/*
 * File: heat.m256.c
 *   By: Dave Hiebeler
 *       hiebeler@turing.cs.rpi.edu
 *       August 1989
 *
 * The "heat" rule in the moore neighborhood.  Each cell finds the average
 * value of the cells in the neighborhood; it then moves toward that
 * average, and adds an increment.
 *  If h = the heat at the current cell, and H = the average heat in the
 * neighborhood, and dH = the difference between them, then this is what
 * happens:
 *   h = h + (dH * (parm1/100)) + parm2
 *
 * Thus, parm1 is the "heat constant" which controls how quickly heat
 * will diffuse, and parm2 is an increment that is added in after the
 * cell moves toward the local average.
 *
 * Try this with parm1 = 100 and parm2 = 2, starting from the "heat.64x"
 * image.
 */


#include "nborhood.h"

byte heat();
void before_func(), after_func();

static int hsum=0;

void
heat_init()
{
    update_function = heat;
    before_function = before_func;
    after_function = after_func;
    parm1 = 100;
    parm2 = 2;
}


byte
heat(nbors)
moore_nbors *nbors;
{
    int heat_avg;

    Get_moore_nbors;
    hsum += c;
    heat_avg = (tl + l + bl + t + c + b + tr + r + br) / 9;
    return (byte)((c + (heat_avg - c) * parm1 / 100 + parm2) % 256);
}


void
before_func(array_info)
array_info_struct *array_info;
{
    printf("setting hsum to 0\n");
    hsum = 0;
}


void
after_func(array_info)
array_info_struct *array_info;
{
    int size;

    size = array_info->size;
    printf("h-average = %d\n", hsum / (size*size));
}
