/* $Id: params.c,v 1.29 90/05/09 22:11:37 pturner Exp Locker: pturner $
 *
 * read/write parameter files
 *
 */

#include <stdio.h>
#include "defines.h"
#include "globals.h"
#include "objdefs.h"

#define	BOX0    1
#define	BOXCOL  52
#define	BOXLIN  53
#define	BOXTYPE 2
#define	DEFCHAR 48
#define	DEFCOLOR 3
#define	DEFFONT 4
#define	DEFLINE 5
#define	DEFNTICS 55
#define	DEFSYMSIZE 54
#define	ERRBAR	6
#define	ERRBARPER 7
#define	ERRBARTYPE 8
#define	GRAPHHID  9
#define	GRAPHLAB  10
#define	GRAPHNO  11
#define	GRAPHTYPE  12
#define	LABDEF  47
#define	LEGSTR  13
#define	LEGFLAG 14
#define	LEGGAP  15
#define	LEGLEN  16
#define	LEGLOC  17
#define	LINES   18
#define	NBOXES  19
#define	NLINES  20
#define	NSETS   21
#define	NSTRINGS 22
#define	SETPROPS 23
#define	STRING0   24
#define STRINGDEF 25
#define	SUBTITLE 26
#define	TICS     27
#define	TICSABS  28
#define	TICSFLAG 29
#define	TICSGRID 30
#define	TICSINOUT  31
#define	TICSINT    32
#define	TICSLFLAG  33
#define	TICSLOG    34
#define	TICSLTOP   35
#define	TICSLTYPE  36
#define	TICSOP   37
#define	TICSPREC   38
#define	TICSSIZE   56
#define	TITLE      39
#define	VIEW       40
#define	WORLD      41
#define	XLABEL     42
#define	XTICANG     43
#define	XTICSKIP     50
#define	YLABEL     44
#define	YTICANG     49
#define	YTICSKIP     51
#define	ZEROAXIS   45
#define	ZEROTICS   46

#define MAXPAR 55

static char cstr[] = "##grtool parameter file";	/* the standard version */

#ifdef LOCAL
static char *cstr5 = "gr parameter file 5";
static char *cstr6 = "gr parameter file 6";

#endif

extern plotstr legstr[];
extern plotstr pstr[];

static char readbuf[512];
static int nleg, nstr;

getparms(plfile)
    char plfile[];

{
    int icheck, ptype;
    char s[256];
    FILE *pp;

    if ((pp = fopen(plfile, "r")) == NULL) {
	sprintf(readbuf, "Can't open parameter file %s", plfile);
	errwin(readbuf);
	plfile[0] = 0;
    } else {
	fgets(s, 255, pp);
	s[strlen(s) - 1] = 0;
	icheck = strcmp(s, cstr);
#ifdef LOCAL
	/* read old format */
	if (!strcmp(s, cstr6)) {
	    errwin("Warning: old style parameter file");
	    read6(pp);
	    fclose(pp);
	    return;
	} else if (!strcmp(s, cstr5)) {
	    errwin("Warning: old style parameter file");
	    read5(pp);
	    fclose(pp);
	    return;
	}
#endif
	if (icheck) {
	    sprintf(readbuf, "File %s not legal parameter file", plfile);
	    errwin(readbuf);
	    fclose(pp);
	    return;
	}
	do_clear_lines();
	do_clear_boxes();
	do_clear_text();
	nlines = 0;
	nboxes = 0;
	nstrings = 0;
	nstr = 0;
	nleg = 0;
	while (fgets(readbuf, 511, pp) != NULL) {
	    ptype = read_param(readbuf);
	}
	fclose(pp);
    }
}

struct pnames {
    char *s;
    int type;
} parmnames[] = {

    "box", BOX0,
    "boxcolor", BOXCOL,
    "boxlinestyle", BOXLIN,
    "boxtypes", BOXTYPE,
    "defchar", DEFCHAR,
    "defcolor", DEFCOLOR,
    "deffont", DEFFONT,
    "defline", DEFLINE,
    "defntics", DEFNTICS,
    "defsymsize", DEFSYMSIZE,
    "errorbar", ERRBAR,
    "errorbarper", ERRBARPER,
    "errorbartype", ERRBARTYPE,
    "graphhid", GRAPHHID,
    "graphlab", GRAPHLAB,
    "graphno", GRAPHNO,
    "graphtype", GRAPHTYPE,
    "labdef", LABDEF,
    "legendflag", LEGFLAG,
    "legendstr", LEGSTR,
    "leggap", LEGGAP,
    "leglen", LEGLEN,
    "legloc", LEGLOC,
    "line", LINES,
    "nboxes", NBOXES,
    "nlines", NLINES,
    "nsets", NSETS,
    "nstrings", NSTRINGS,
    "setprops", SETPROPS,
    "string", STRING0,
    "stringdef", STRINGDEF,
    "subtitle", SUBTITLE,
    "ticflags", TICSFLAG,
    "ticlabels", TICSLFLAG,
    "tics", TICS,
    "ticsabs", TICSABS,
    "ticsgrid", TICSGRID,
    "ticsinout", TICSINOUT,
    "ticsint", TICSINT,
    "ticslog", TICSLOG,
    "ticsltop", TICSLTOP,
    "ticsltype", TICSLTYPE,
    "ticsop", TICSOP,
    "ticsprec", TICSPREC,
    "ticssize", TICSSIZE,
    "title", TITLE,
    "view", VIEW,
    "world", WORLD,
    "xlabel", XLABEL,
    "xticang", XTICANG,
    "xticskip", XTICSKIP,
    "ylabel", YLABEL,
    "yticang", YTICANG,
    "yticskip", YTICSKIP,
    "zeroflag", ZEROAXIS,
    "zerotics", ZEROTICS
};

putparms(pp, graph_number, imbed)
    FILE *pp;
    int graph_number, imbed;
{
    char istr[2];
    int i, j, gh, gl, gn;

    if (!imbed) {
	istr[0] = 0;
    } else {
	strcpy(istr, "@");
    }
    fprintf(pp, "##grtool parameter file\n");
    fprintf(pp, "# Do not touch the first line of this file!!!\n");
    fprintf(pp, "# $Id: params.c,v 1.29 90/05/09 22:11:37 pturner Exp Locker: pturner $\n");
    fprintf(pp, "%sgraphno %d\n", istr, graph_number);
    fprintf(pp, "%sworld %le %le %le %le\n", istr, xg1, xg2, yg1, yg2);
    fprintf(pp, "%sview %le %le %le %le\n", istr, xv1, xv2, yv1, yv2);
    fprintf(pp, "%stics %le %le %le %le\n", istr, xt1, xt2, yt1, yt2);
    fprintf(pp, "%sticsprec %d %d\n", istr, xform, yform);
    fprintf(pp, "%sticssize %le %le\n", istr, xticsize, yticsize);
    fprintf(pp, "%sdeffont %d\n", istr, curfont);
    fprintf(pp, "%sdefchar %lf\n", istr, defchar);
    fprintf(pp, "%sdefcolor %d\n", istr, defcolor);
    fprintf(pp, "%sdefline %d\n", istr, defline);
    fprintf(pp, "%sdefntics %d %d\n", istr, xticnum, yticnum);
    fprintf(pp, "%sdefsymsize %lf\n", istr, defsymsize);
    fprintf(pp, "%snsets %d\n", istr, maxplot);
    for (i = 0; i < maxplot; i++) {
	fprintf(pp, "%ssetprops %d %d %d %d\n", istr, i, getsetlinesym(i), getsetplotsym(i), getsetcolor(i));
	fprintf(pp, "%serrorbar %d %d\n", istr, i, iserrbar(i));
	fprintf(pp, "%serrorbartype %d %d\n", istr, i, getseterrbarxy(i));
    }
    fprintf(pp, "%sxlabel %s\n", istr, xlabel);
    fprintf(pp, "%sylabel %s\n", istr, ylabel);
    fprintf(pp, "%stitle %s\n", istr, title);
    fprintf(pp, "%ssubtitle %s\n", istr, stitle);
    fprintf(pp, "%sticsint %d %d\n", istr, xticsintflag, yticsintflag);
    fprintf(pp, "%sboxtypes %d %d\n", istr, boxflag, boxon);
    fprintf(pp, "%sboxcolor %d\n", istr, boxcol);
    fprintf(pp, "%sboxlinestyle %d\n", istr, boxlin);
    fprintf(pp, "%sticflags %d %d\n", istr, xticflag, yticflag);
    fprintf(pp, "%sticsltop %d %d\n", istr, xtopflag, ytopflag);
    fprintf(pp, "%sticsop %d %d\n", istr, xticopflag, yticopflag);
    fprintf(pp, "%sxticang %d\n", istr, xticangle);
    fprintf(pp, "%syticang %d\n", istr, yticangle);
    fprintf(pp, "%sxticskip %d\n", istr, xticlskip);
    fprintf(pp, "%syticskip %d\n", istr, yticlskip);
    fprintf(pp, "%sticsltype %d %d\n", istr, fformx, fformy);
    fprintf(pp, "%sticlabels %d %d\n", istr, xticlflag, yticlflag);
    fprintf(pp, "%sticsabs %d %d\n", istr, xabsflag, yabsflag);
    fprintf(pp, "%sticsgrid %d %d\n", istr, xgridflag, ygridflag);
    fprintf(pp, "%sticsinout %d %d\n", istr, xticinoutflag, yticinoutflag);
    fprintf(pp, "%sticslog %d %d\n", istr, xticslog, yticslog);
    fprintf(pp, "%szeroflag %d %d\n", istr, xzflag, yzflag);
    fprintf(pp, "%szerotics %d %d\n", istr, xztflag, yztflag);
    fprintf(pp, "%slegendflag %d\n", istr, legendflag);
    fprintf(pp, "%slegloc %le %le %d\n", istr, legx, legy, legloctype);
    fprintf(pp, "%sleggap %d\n", istr, lgap);
    fprintf(pp, "%sleglen %d\n", istr, llen);
    for (i = 0; i < maxplot; i++) {
	fprintf(pp, "%slegendstr %s\n", istr, legstr[i].s);
    }
    fprintf(pp, "# string (x,y), size, rotation, font\n");
    for (i = 0; i < MAXSTR; i++) {
	if (pstr[i].s[0]) {
	    fprintf(pp, "%sstring %le %le %le %d %d %d %d %d\n",
		    istr, pstr[i].x, pstr[i].y, pstr[i].size, pstr[i].rot, pstr[i].font, pstr[i].color, pstr[i].loctype, pstr[i].just);
	    fprintf(pp, "%sstringdef %s\n", istr, pstr[i].s);
	}
    }
    fprintf(pp, "# box (x1,y1,x2,y2), color, style, active\n");
    for (i = 0; i < MAXBOXES; i++) {
	if (isactive_box(i)) {
	    fprintf(pp, "%sbox %le %le %le %le %d %d %d %d\n", istr, boxes[i].x1, boxes[i].y1,
		    boxes[i].x2, boxes[i].y2, boxes[i].color, boxes[i].style, boxes[i].active, boxes[i].loctype);
	}
    }
    fprintf(pp, "# line (x1,y1,x2,y2), color, style, arrow, active\n");
    for (i = 0; i < MAXLINES; i++) {
	if (isactive_line(i)) {
	    fprintf(pp, "%sline %le %le %le %le %d %d %d %d %d %le\n", istr, lines[i].x1, lines[i].y1,
		    lines[i].x2, lines[i].y2, lines[i].color, lines[i].style, lines[i].arrow,
		    lines[i].active, lines[i].loctype, lines[i].asize);
	}
    }
    fflush(pp);
}

int read_param(s)
    char *s;
{
    int didit = 0, gnum, glab, ghid;
    int itmp, type, mtmp, stmp, ltmp, btmp, ls, cs, ps;
    char name[256];

    if (s[0] != '#') {
	sscanf(s, "%s", name);
	type = findf(parmnames, name, MAXPAR);
	if (type >= 0) {
	    type = parmnames[type].type;
	    /* printf("%s %d\n",name,type); */
	    switch (type) {
	    case BOX0:
		nboxes = next_box();
		if (nboxes >= 0) {
		    sscanf(s, "%*s %le %le %le %le %d %d %d %d", &boxes[nboxes].x1, &boxes[nboxes].y1,
			   &boxes[nboxes].x2, &boxes[nboxes].y2, &boxes[nboxes].color,
			   &boxes[nboxes].style, &boxes[nboxes].active, &boxes[nboxes].loctype);
		}
		break;
	    case BOXCOL:
		sscanf(s, "%*s %d", &boxcol);
		break;
	    case BOXLIN:
		sscanf(s, "%*s %d", &boxlin);
		break;
	    case BOXTYPE:
		sscanf(s, "%*s %d %d", &boxflag, &boxon);
		break;
	    case DEFCHAR:
		sscanf(s, "%*s %lf", &defchar);
		break;
	    case DEFCOLOR:
		sscanf(s, "%*s %d", &defcolor);
		break;
	    case DEFFONT:
		sscanf(s, "%*s %d", &curfont);
		break;
	    case DEFLINE:
		sscanf(s, "%*s %d", &defline);
		break;
	    case DEFNTICS:
		sscanf(s, "%*s %d %d", &xticnum, &yticnum);
		break;
	    case DEFSYMSIZE:
		sscanf(s, "%*s %lf", &defsymsize);
		break;
	    case ERRBAR:
		sscanf(s, "%*s %d %d", &stmp, &itmp);
		makeseterrbar(stmp, itmp);
		break;
	    case ERRBARPER:
		sscanf(s, "%*s %lf", &errbarper);
		break;
	    case ERRBARTYPE:
		sscanf(s, "%*s %d %d", &stmp, &itmp);
		seterrbarxy(stmp, itmp);
		break;

		/* the following 3 items are not used in this version */
	    case GRAPHHID:
		sscanf(s, "%*s %d", &ghid);
		if (ghid) {
		}
		break;
	    case GRAPHLAB:
		sscanf(s, "%*s %d", &glab);
		if (glab) {
		}
		break;
	    case GRAPHNO:
		break;
		/* end skip */

	    case LABDEF:
		sscanf(s, "%*s %d", &labeldefault);
		break;
	    case LEGSTR:
		strcpy(legstr[nleg].s, s + 10);
		legstr[nleg].s[strlen(legstr[nleg].s) - 1] = 0;
		nleg++;
		break;
	    case LEGFLAG:
		sscanf(s, "%*s %d", &legendflag);
		break;
	    case LEGGAP:
		sscanf(s, "%*s %d", &lgap);
		break;
	    case LEGLEN:
		sscanf(s, "%*s %d", &llen);
		break;
	    case LEGLOC:
		{
		    int ncheck;

		    ncheck = sscanf(s, "%*s %lf %lf %d", &legx, &legy, &legloctype);
		    if (ncheck == 2) {
			legloctype = 0;
		    }
		}
		break;
	    case LINES:
		nlines = next_line();
		if (nlines >= 0) {
		    {
			int ncheck;

			ncheck = sscanf(s, "%*s %le %le %le %le %d %d %d %d %d %le", &lines[nlines].x1,
					&lines[nlines].y1, &lines[nlines].x2, &lines[nlines].y2,
					&lines[nlines].color, &lines[nlines].style, &lines[nlines].arrow,
					&lines[nlines].active, &lines[nlines].loctype, &lines[nlines].asize);
			if (ncheck == 9) {
			    lines[nlines].asize = 1.0;
			}
		    }
		}
		break;
	    case NBOXES:
		sscanf(s, "%*s %d", &btmp);
		break;
	    case NLINES:
		sscanf(s, "%*s %d", &ltmp);
		break;
	    case NSETS:
		sscanf(s, "%*s %d", &mtmp);
		break;
	    case NSTRINGS:
		sscanf(s, "%*s %d", &stmp);
		break;
	    case SETPROPS:
		sscanf(s, "%*s %d %d %d %d", &itmp, &ls, &ps, &cs);
		setlinesym(itmp, ls);
		setplotsym(itmp, ps);
		setplotcolor(itmp, cs);
		break;
	    case STRING0:
		nstr = next_string();
		if (nstr >= 0) {
		    sscanf(s, "%*s %lf %lf %lf %d %d %d %d &d",
			   &pstr[nstr].x, &pstr[nstr].y, &pstr[nstr].size,
			   &pstr[nstr].rot, &pstr[nstr].font, &pstr[nstr].color, &pstr[nstr].loctype, &pstr[nstr].just);
		}
		break;
	    case STRINGDEF:
		if (nstr >= 0) {
		    strcpy(pstr[nstr].s, s + 10);
		    pstr[nstr].s[strlen(pstr[nstr].s) - 1] = 0;
		}
		break;
	    case SUBTITLE:
		strcpy(stitle, s + 9);
		stitle[strlen(stitle) - 1] = 0;
		break;
	    case TICS:
		sscanf(s, "%*s %lf %lf %lf %lf", &xt1, &xt2, &yt1, &yt2);
		break;
	    case TICSABS:
		sscanf(s, "%*s %d %d", &xabsflag, &yabsflag);
		break;
	    case TICSFLAG:
		sscanf(s, "%*s %d %d", &xticflag, &yticflag);
		break;
	    case TICSGRID:
		sscanf(s, "%*s %d %d", &xgridflag, &ygridflag);
		break;
	    case TICSINT:
		sscanf(s, "%*s %d %d", &xticsintflag, &yticsintflag);
		break;
	    case TICSINOUT:
		sscanf(s, "%*s %d %d", &xticinoutflag, &yticinoutflag);
		break;
	    case TICSLFLAG:
		sscanf(s, "%*s %d %d", &xticlflag, &yticlflag);
		break;
	    case TICSLOG:
		sscanf(s, "%*s %d %d", &xticslog, &yticslog);
		break;
	    case XTICANG:
		sscanf(s, "%*s %d", &xticangle);
		break;
	    case YTICANG:
		sscanf(s, "%*s %d", &yticangle);
		break;
	    case XTICSKIP:
		sscanf(s, "%*s %d", &xticlskip);
		break;
	    case YTICSKIP:
		sscanf(s, "%*s %d", &yticlskip);
		break;
	    case TICSOP:
		sscanf(s, "%*s %d %d", &xticopflag, &yticopflag);
		break;
	    case TICSLTOP:
		sscanf(s, "%*s %d %d", &xtopflag, &ytopflag);
		break;
	    case TICSLTYPE:
		sscanf(s, "%*s %d %d", &fformx, &fformy);
		break;
	    case TICSPREC:
		sscanf(s, "%*s %d %d", &xform, &yform);
		break;
	    case TICSSIZE:
		sscanf(s, "%*s %lf %lf", &xticsize, &yticsize);
		break;
	    case TITLE:
		strcpy(title, s + 6);
		title[strlen(title) - 1] = 0;
		break;
	    case VIEW:
		sscanf(s, "%*s %lf %lf %lf %lf", &xv1, &xv2, &yv1, &yv2);
		break;
	    case WORLD:
		sscanf(s, "%*s %lf %lf %lf %lf", &xg1, &xg2, &yg1, &yg2);
		break;
	    case XLABEL:
		strcpy(xlabel, s + 7);
		xlabel[strlen(xlabel) - 1] = 0;
		break;
	    case YLABEL:
		strcpy(ylabel, s + 7);
		ylabel[strlen(ylabel) - 1] = 0;
		break;
	    case ZEROAXIS:
		sscanf(s, "%*s %d %d", &xzflag, &yzflag);
		break;
	    case ZEROTICS:
		sscanf(s, "%*s %d %d", &xztflag, &yztflag);
		break;
	    }
	    return (type);	/* type found */
	} else {
	    return -1;		/* not found */
	}
    } else {
	return -2;		/* comment */
    }
}

/*
   Need to read old format parameter files at our site
*/
#ifdef LOCAL

read5(pp)
    FILE *pp;
{
    int i, ls, ps, cs;
    char s[256];

    fgets(s, 255, pp);
    sscanf(s, "%lf %lf %lf %lf", &xg1, &xg2, &yg1, &yg2);
    fgets(s, 255, pp);
    sscanf(s, "%lf %lf %lf %lf", &xv1, &xv2, &yv1, &yv2);
    fgets(s, 255, pp);
    sscanf(s, "%lf %lf %lf %lf", &xt1, &xt2, &yt1, &yt2);
    fgets(s, 255, pp);
    sscanf(s, "%d %d", &xform, &yform);
    for (i = 0; i < maxplot; i++) {
	fgets(s, 255, pp);
	sscanf(s, "%d %d %d", &ls, &ps, &cs);
	setlinesym(i, ls);
	setplotsym(i, ps);
	setplotcolor(i, cs);
    }
    fgets(s, 255, pp);
    fgets(xlabel, 79, pp);
    xlabel[strlen(xlabel) - 1] = 0;
    fgets(ylabel, 79, pp);
    ylabel[strlen(ylabel) - 1] = 0;
    fgets(title, 79, pp);
    title[strlen(title) - 1] = 0;
    fgets(stitle, 79, pp);
    stitle[strlen(stitle) - 1] = 0;
    fgets(s, 255, pp);
    legendflag = 0;
    sscanf(s, "%d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d",
	   &xticsintflag, &yticsintflag, &boxflag, &boxon, &xticflag, &yticflag, &fformx, &fformy, &xticlflag, &yticlflag, &xgridflag,
	   &ygridflag, &xticslog, &yticslog, &xzflag, &yzflag, &xztflag, &yztflag, &legendflag);
    if (legendflag) {
	fgets(s, 255, pp);
	fgets(s, 255, pp);
	sscanf(s, "%lf %lf", &legx, &legy);
	for (i = 0; i < maxplot; i++) {
	    fgets(legstr[i].s, 79, pp);
	    legstr[i].s[strlen(legstr[i].s) - 1] = 0;
	}
    }
    fclose(pp);
}

read6(pp)
    FILE *pp;
{
    int i, ls, ps, cs, mtmp, stmp;
    char s[256];

    fgets(s, 255, pp);
    sscanf(s, "%lf %lf %lf %lf", &xg1, &xg2, &yg1, &yg2);
    fgets(s, 255, pp);
    sscanf(s, "%lf %lf %lf %lf", &xv1, &xv2, &yv1, &yv2);
    fgets(s, 255, pp);
    sscanf(s, "%lf %lf %lf %lf", &xt1, &xt2, &yt1, &yt2);
    fgets(s, 255, pp);
    sscanf(s, "%d %d", &xform, &yform);
    fgets(s, 255, pp);
    sscanf(s, "%d", &mtmp);
    for (i = 0; i < mtmp; i++) {
	fgets(s, 255, pp);
	sscanf(s, "%d %d %d", &ls, &ps, &cs);
	setlinesym(i, ls);
	setplotsym(i, ps);
	setplotcolor(i, cs);
    }
    fgets(s, 255, pp);
    fgets(xlabel, 79, pp);
    xlabel[strlen(xlabel) - 1] = 0;
    fgets(ylabel, 79, pp);
    ylabel[strlen(ylabel) - 1] = 0;
    fgets(title, 79, pp);
    title[strlen(title) - 1] = 0;
    fgets(stitle, 79, pp);
    stitle[strlen(stitle) - 1] = 0;
    fgets(s, 255, pp);
    sscanf(s, "%d %d", &xticsintflag, &yticsintflag);
    fgets(s, 255, pp);
    sscanf(s, "%d %d", &boxflag, &boxon);
    fgets(s, 255, pp);
    sscanf(s, "%d %d", &xticflag, &yticflag);
    fgets(s, 255, pp);
    sscanf(s, "%d %d", &fformx, &fformy);
    fgets(s, 255, pp);
    sscanf(s, "%d %d", &xticlflag, &yticlflag);
    fgets(s, 255, pp);
    sscanf(s, "%d %d", &xgridflag, &ygridflag);
    fgets(s, 255, pp);
    sscanf(s, "%d %d", &xticslog, &yticslog);
    fgets(s, 255, pp);
    sscanf(s, "%d %d", &xzflag, &yzflag);
    fgets(s, 255, pp);
    sscanf(s, "%d %d", &xztflag, &yztflag);
    fgets(s, 255, pp);
    fgets(s, 255, pp);
    sscanf(s, "%d", &legendflag);
    fgets(s, 255, pp);
    sscanf(s, "%lf %lf", &legx, &legy);
    for (i = 0; i < mtmp; i++) {
	fgets(legstr[i].s, 79, pp);
	legstr[i].s[strlen(legstr[i].s) - 1] = 0;
    }
    fgets(s, 255, pp);
    fgets(s, 255, pp);
    sscanf(s, "%d", &stmp);
    for (i = 0; i < stmp; i++) {
	fgets(pstr[i].s, 79, pp);
	pstr[i].s[strlen(pstr[i].s) - 1] = 0;
	fgets(s, 255, pp);
	sscanf(s, "%lf %lf", &pstr[i].x, &pstr[i].y);
	fgets(s, 255, pp);
	sscanf(s, "%lf", &pstr[i].size);
	fgets(s, 255, pp);
	sscanf(s, "%d", &pstr[i].rot);
	fgets(s, 255, pp);
	sscanf(s, "%d", &pstr[i].font);
    }
    if (fgets(s, 255, pp) != NULL) {
	nboxes = 0;
	fgets(s, 255, pp);
	sscanf(s, "%d", &stmp);
	for (i = 0; i < stmp; i++) {
	    fgets(s, 255, pp);
	    sscanf(s, "%le %le %le %le", &boxes[i].x1, &boxes[i].y1, &boxes[i].x2, &boxes[i].y2);
	    fgets(s, 255, pp);
	    sscanf(s, "%d %d %d", &boxes[i].color, &boxes[i].style, &boxes[i].active);
	    if (boxes[i].active)
		nboxes++;
	}
    }
    if (fgets(s, 255, pp) != NULL) {
	nlines = 0;
	fgets(s, 255, pp);
	sscanf(s, "%d", &stmp);
	for (i = 0; i < stmp; i++) {
	    fgets(s, 255, pp);
	    sscanf(s, "%le %le %le %le", &lines[i].x1, &lines[i].y1, &lines[i].x2, &lines[i].y2);
	    fgets(s, 255, pp);
	    sscanf(s, "%d %d %d %d", &lines[i].color, &lines[i].style, &lines[i].arrow, &lines[i].active);
	    if (lines[i].active)
		nlines++;
	}
    }
    fclose(pp);
}

#endif
