#! /bin/sh
#
# move queued mail around
#
# Brian Reid, 17 August 1989
#
# The "requeue" program moves mail from one sendmail queue to another while
# obeying the lock protocol. It breaks any locks that are more than 12 hours
# old. The "-d" argument provides the "delta" in number of hours. "-d 4" means
# that any message more than 4 hours old will be moved.

/etc/renice -16 $$ > /dev/null 2>&1

PN=/usr/local/adm/sendmail/requeue
$PN -d   1 -f /usr/spool/mqueue -t /usr/spool/mq1	
$PN -d   2 -f /usr/spool/mq1    -t /usr/spool/mq2	
$PN -d   4 -f /usr/spool/mq2    -t /usr/spool/mq3    
$PN -d   8 -f /usr/spool/mq3    -t /usr/spool/mq4
$PN -d  16 -f /usr/spool/mq4    -t /usr/spool/mq5 
$PN -d  32 -f /usr/spool/mq5    -t /usr/spool/mq6	
$PN -d  64 -f /usr/spool/mq6    -t /usr/spool/mq7 
$PN -d 128 -f /usr/spool/mq7    -t /usr/spool/mq8
