/******************************************************************************
*******************************************************************************
	A George Kalwitz Production, 1990
*******************************************************************************
******************************************************************************/

/******************************************************************************
 BOARD ID DEFINITIONS

 32 Bits of information are returned by 'GetBoardID ()'.

	The low order 16 bits correspond to the Feature Bits which make
	up a unique ID for a given class of boards.

		e.g. STARLAN MEDIA, INTERFACE_CHIP

		note: board ID should be ANDed with the STATIC_ID_MASK
		      before comparing to a specific board ID


	The high order 16 bits correspond to the Extra Bits which do not
	change the boards ID.

		e.g. INTERFACE_584_CHIP, 16 BIT SLOT, ALTERNATE IRQ

******************************************************************************/
#define BID_EEPROM_OVERRIDE     0xffd0ffb0      /* stuff override by eeprom */
#define	STARLAN_MEDIA		0x00000001	/* StarLAN */
#define	ETHERNET_MEDIA		0x00000002	/* Ethernet */
#define	TWISTED_PAIR_MEDIA	0x00000003	/* Twisted Pair */
#define	EW_MEDIA		0x00000004	/* Ethernet and Twisted Pair */
#define	INTERFACE_CHIP		0x00000010	/* Soft Config Adapter */
#define	BID_UNUSED_1		0x00000020	/* used to be INTELLIGENT */
#define	BOARD_16BIT		0x00000040	/* 16 bit capability */
#define	RAM_SIZE_UNKNOWN	0x00000000	/* 000 => Unknown RAM Size */
#define	RAM_SIZE_RESERVED_1	0x00010000	/* 001 => Reserved */
#define	RAM_SIZE_8K		0x00020000	/* 010 => 8k RAM */
#define	RAM_SIZE_16K		0x00030000	/* 011 => 16k RAM */
#define	RAM_SIZE_32K		0x00040000	/* 100 => 32k RAM */
#define	RAM_SIZE_64K		0x00050000	/* 101 => 64k RAM */ 
#define	RAM_SIZE_RESERVED_6	0x00060000	/* 110 => Reserved */ 
#define	RAM_SIZE_RESERVED_7	0x00070000	/* 111 => Reserved */ 
/* #define	BID_UNUSED_2		0x00010000 */	/* used to be RAM Size field */
/* #define	BID_UNUSED_3		0x00020000 */	/* used to be RAM Size field */
/* #define	BID_UNUSED_4		0x00040000 */	/* used to be RAM Size field */
#define	SLOT_16BIT		0x00080000	/* 16 bit board - 16 bit slot */
#define	NIC_690_BIT		0x00100000	/* NIC is 690 */
#define	ALTERNATE_IRQ_BIT	0x00200000	/* Alternate IRQ is used */
#define	INTERFACE_5X3_CHIP	0x00000000	/* 0000 = 583 or 593 chips */
#define	INTERFACE_584_CHIP	0x00400000	/* 0001 = 584 chip */
#define	INTERFACE_594_CHIP	0x00800000	/* 0010 = 594 chip */

#define	MEDIA_MASK		0x00000007	/* Isolates Media Type */
#define	RAM_SIZE_MASK		0x00070000	/* Isolates RAM Size */
#define	STATIC_ID_MASK		0x0000FFFF	/* Isolates Board ID */
#define	INTERFACE_CHIP_MASK	0x03C00000	/* Isolates Intfc Chip Type */

/* Word definitions for board types */
#define	WD8003E		ETHERNET_MEDIA
#define	WD8003EBT	WD8003E		/* functionally identical to WD8003E */
#define	WD8003S		STARLAN_MEDIA
#define	WD8003SH	WD8003S		/* functionally identical to WD8003S */
#define	WD8003WT	TWISTED_PAIR_MEDIA
#define	WD8003W		(TWISTED_PAIR_MEDIA | INTERFACE_CHIP)
#define	WD8003EB	(ETHERNET_MEDIA | INTERFACE_CHIP)
#define	WD8003EP	WD8003EB	/* with INTERFACE_584_CHIP */
#define	WD8003EW	(EW_MEDIA | INTERFACE_CHIP)
#define	WD8013EBT	(ETHERNET_MEDIA | BOARD_16BIT)
#define	WD8013EB	(ETHERNET_MEDIA | BOARD_16BIT | INTERFACE_CHIP)
#define	WD8013W		(TWISTED_PAIR_MEDIA | BOARD_16BIT | INTERFACE_CHIP)
#define	WD8013EW	(EW_MEDIA | BOARD_16BIT | INTERFACE_CHIP)

/******************************************************************************

Declaration for the Routine Provided in the 'Board ID' Library.

******************************************************************************/
unsigned	long	GetBoardID (unsigned int, int);


/******************************************************************************
  This describes the smc_get_cnfg interface structure.
******************************************************************************/
typedef	struct
{
	unsigned short bid;	/* Board ID from GetBoardID */
	unsigned long  full_bid;	/* all Information from GetBoardID */
	unsigned short bus;	/* 0=AT...1=MCA */
	unsigned short base_io;	/* Adapter Base I/O Address */
	unsigned short slot;	/* Micro Channel Slot Number */
	unsigned long  ram_base;	/* 32-Bit Phys Address of Shared RAM */
	unsigned short ram_size;	/* Shared RAM Size (# of 1KB blocks) */
	unsigned short irq_line;	/* Adapter IRQ Interrupt Line */
	unsigned long  rom_base;	/* 32-Bit Phys Address of Adapter ROM */
	unsigned short rom_size;	/* Adapter ROM Size (# of 1KB blocks) */
	unsigned short bio_new;	/* New Base I/O Address (for PutCnfg) */
	unsigned short mode_bits1;	/* Mode bits for adapter (see below) */
	char name[20]; /* name for board type */
} CNFG_Adapter;

/********* Prototype Declaration ***********/
int	smc_get_cnfg (CNFG_Adapter *);

/******************************************************************************
 This describes definitions in the smc_get_cnfg interface structure.
******************************************************************************/
/******************************************************************************
 Definitions for the field:
	cnfg_mode_bits1
******************************************************************************/
#define	INTERRUPT_STATUS_BIT	0x8000	/* PC Interrupt Line: 0 = Not Enabled */
#define	BOOT_STATUS_MASK	0x6000	/* Mask to isolate BOOT_STATUS */
#define	BOOT_INHIBIT		0x0000	/* BOOT_STATUS is 'inhibited' */
#define	BOOT_TYPE_1		0x2000	/* Unused BOOT_STATUS value */
#define	BOOT_TYPE_2		0x4000	/* Unused BOOT_STATUS value */
#define	BOOT_TYPE_3		0x6000	/* Unused BOOT_STATUS value */
#define	ZERO_WAIT_STATE_MASK	0x1800	/* Mask to isolate Wait State flags */
#define	ZERO_WAIT_STATE_8_BIT	0x1000	/* 0 = Disabled (Inserts Wait States) */
#define	ZERO_WAIT_STATE_16_BIT	0x0800	/* 0 = Disabled (Inserts Wait States) */

