/* ARC instruction defintions.
   Copyright (C) 1994-2023 Free Software Foundation, Inc.

   Contributed by Claudiu Zissulescu (claziss@synopsys.com)

   This file is part of libopcodes.

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 51 Franklin Street - Fifth Floor, Boston, MA 02110-1301, USA.  */

/* abs<.f> b,c 00100bbb00101111FBBBCCCCCC001001.  */
{ "abs", 0x202F0009, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RC }, { C_F }},

/* abs<.f> 0,c 0010011000101111F111CCCCCC001001.  */
{ "abs", 0x262F7009, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RC }, { C_F }},

/* abs<.f> b,u6 00100bbb01101111FBBBuuuuuu001001.  */
{ "abs", 0x206F0009, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* abs<.f> 0,u6 0010011001101111F111uuuuuu001001.  */
{ "abs", 0x266F7009, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* abs<.f> b,limm 00100bbb00101111FBBB111110001001.  */
{ "abs", 0x202F0F89, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, LIMM }, { C_F }},

/* abs<.f> 0,limm 0010011000101111F111111110001001.  */
{ "abs", 0x262F7F89, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* abss<.f> b,c 00101bbb00101111FBBBCCCCCC000101.  */
{ "abss", 0x282F0005, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RC }, { C_F }},

/* abss<.f> 0,c 0010111000101111F111CCCCCC000101.  */
{ "abss", 0x2E2F7005, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RC }, { C_F }},

/* abss<.f> b,u6 00101bbb01101111FBBBuuuuuu000101.  */
{ "abss", 0x286F0005, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* abss<.f> 0,u6 0010111001101111F111uuuuuu000101.  */
{ "abss", 0x2E6F7005, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* abss<.f> b,limm 00101bbb00101111FBBB111110000101.  */
{ "abss", 0x282F0F85, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, LIMM }, { C_F }},

/* abss<.f> 0,limm 0010111000101111F111111110000101.  */
{ "abss", 0x2E2F7F85, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* abssh<.f> b,c 00101bbb00101111FBBBCCCCCC000100.  */
{ "abssh", 0x282F0004, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RC }, { C_F }},

/* abssh<.f> 0,c 0010111000101111F111CCCCCC000100.  */
{ "abssh", 0x2E2F7004, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RC }, { C_F }},

/* abssh<.f> b,u6 00101bbb01101111FBBBuuuuuu000100.  */
{ "abssh", 0x286F0004, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, UIMM6_20 }, { C_F }},

/* abssh<.f> 0,u6 0010111001101111F111uuuuuu000100.  */
{ "abssh", 0x2E6F7004, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, UIMM6_20 }, { C_F }},

/* abssh<.f> b,limm 00101bbb00101111FBBB111110000100.  */
{ "abssh", 0x282F0F84, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, LIMM }, { C_F }},

/* abssh<.f> 0,limm 0010111000101111F111111110000100.  */
{ "abssh", 0x2E2F7F84, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM }, { C_F }},

/* abssw<.f> b,c 00101bbb00101111FBBBCCCCCC000100.  */
{ "abssw", 0x282F0004, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, RC }, { C_F }},

/* abssw<.f> 0,c 0010111000101111F111CCCCCC000100.  */
{ "abssw", 0x2E2F7004, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, RC }, { C_F }},

/* abssw<.f> b,u6 00101bbb01101111FBBBuuuuuu000100.  */
{ "abssw", 0x286F0004, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* abssw<.f> 0,u6 0010111001101111F111uuuuuu000100.  */
{ "abssw", 0x2E6F7004, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* abssw<.f> b,limm 00101bbb00101111FBBB111110000100.  */
{ "abssw", 0x282F0F84, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, LIMM }, { C_F }},

/* abssw<.f> 0,limm 0010111000101111F111111110000100.  */
{ "abssw", 0x2E2F7F84, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* abs_s b,c 01111bbbccc10001.  */
{ "abs_s", 0x00007811, 0x0000F81F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB_S, RC_S }, { 0 }},

/* acm<.f> a,b,c 00110bbb00101000FBBBCCCCCCAAAAAA.  */
{ "acm", 0x30280000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* acm<.f><.cc> b,b,c 00110bbb11101000FBBBCCCCCC0QQQQQ.  */
{ "acm", 0x30E80000, 0xF8FF0020, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* acm<.f> a,b,u6 00110bbb01101000FBBBuuuuuuAAAAAA.  */
{ "acm", 0x30680000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* acm<.f><.cc> b,b,u6 00110bbb11101000FBBBuuuuuu1QQQQQ.  */
{ "acm", 0x30E80020, 0xF8FF0020, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* acm<.f> b,b,s12 00110bbb10101000FBBBssssssSSSSSS.  */
{ "acm", 0x30A80000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* acm<.f> a,limm,c 0011011000101000F111CCCCCCAAAAAA.  */
{ "acm", 0x36287000, 0xFFFF7000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* acm<.f> a,b,limm 00110bbb00101000FBBB111110AAAAAA.  */
{ "acm", 0x30280F80, 0xF8FF0FC0, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* acm<.f><.cc> b,b,limm 00110bbb11101000FBBB1111100QQQQQ.  */
{ "acm", 0x30E80F80, 0xF8FF0FE0, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* adc<.f> a,b,c 00100bbb00000001FBBBCCCCCCAAAAAA.  */
{ "adc", 0x20010000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* adc<.f> 0,b,c 00100bbb00000001FBBBCCCCCC111110.  */
{ "adc", 0x2001003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* adc<.f><.cc> b,b,c 00100bbb11000001FBBBCCCCCC0QQQQQ.  */
{ "adc", 0x20C10000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* adc<.f> a,b,u6 00100bbb01000001FBBBuuuuuuAAAAAA.  */
{ "adc", 0x20410000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* adc<.f> 0,b,u6 00100bbb01000001FBBBuuuuuu111110.  */
{ "adc", 0x2041003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* adc<.f><.cc> b,b,u6 00100bbb11000001FBBBuuuuuu1QQQQQ.  */
{ "adc", 0x20C10020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* adc<.f> b,b,s12 00100bbb10000001FBBBssssssSSSSSS.  */
{ "adc", 0x20810000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* adc<.f> a,limm,c 0010011000000001F111CCCCCCAAAAAA.  */
{ "adc", 0x26017000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* adc<.f> a,b,limm 00100bbb00000001FBBB111110AAAAAA.  */
{ "adc", 0x20010F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* adc<.f> 0,limm,c 0010011000000001F111CCCCCC111110.  */
{ "adc", 0x2601703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* adc<.f> 0,b,limm 00100bbb00000001FBBB111110111110.  */
{ "adc", 0x20010FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* adc<.f><.cc> b,b,limm 00100bbb11000001FBBB1111100QQQQQ.  */
{ "adc", 0x20C10F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* adc<.f><.cc> 0,limm,c 0010011011000001F111CCCCCC0QQQQQ.  */
{ "adc", 0x26C17000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* adc<.f> a,limm,u6 0010011001000001F111uuuuuuAAAAAA.  */
{ "adc", 0x26417000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* adc<.f> 0,limm,u6 0010011001000001F111uuuuuu111110.  */
{ "adc", 0x2641703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* adc<.f><.cc> 0,limm,u6 0010011011000001F111uuuuuu1QQQQQ.  */
{ "adc", 0x26C17020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* adc<.f> 0,limm,s12 0010011010000001F111ssssssSSSSSS.  */
{ "adc", 0x26817000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* adc<.f> a,limm,limm 0010011000000001F111111110AAAAAA.  */
{ "adc", 0x26017F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* adc<.f> 0,limm,limm 0010011000000001F111111110111110.  */
{ "adc", 0x26017FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* adc<.f><.cc> 0,limm,limm 0010011011000001F1111111100QQQQQ.  */
{ "adc", 0x26C17F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* adcs<.f> a,b,c 00101bbb00100110FBBBCCCCCCAAAAAA.  */
{ "adcs", 0x28260000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* adcs<.f> 0,b,c 00101bbb00100110FBBBCCCCCC111110.  */
{ "adcs", 0x2826003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* adcs<.f><.cc> b,b,c 00101bbb11100110FBBBCCCCCC0QQQQQ.  */
{ "adcs", 0x28E60000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* adcs<.f> a,b,u6 00101bbb01100110FBBBuuuuuuAAAAAA.  */
{ "adcs", 0x28660000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* adcs<.f> 0,b,u6 00101bbb01100110FBBBuuuuuu111110.  */
{ "adcs", 0x2866003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* adcs<.f><.cc> b,b,u6 00101bbb11100110FBBBuuuuuu1QQQQQ.  */
{ "adcs", 0x28E60020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* adcs<.f> b,b,s12 00101bbb10100110FBBBssssssSSSSSS.  */
{ "adcs", 0x28A60000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* adcs<.f> a,limm,c 0010111000100110F111CCCCCCAAAAAA.  */
{ "adcs", 0x2E267000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* adcs<.f> a,b,limm 00101bbb00100110FBBB111110AAAAAA.  */
{ "adcs", 0x28260F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* adcs<.f> 0,limm,c 0010111001100110F111CCCCCC111110.  */
{ "adcs", 0x2E66703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* adcs<.f> 0,b,limm 00101bbb00100110FBBB111110111110.  */
{ "adcs", 0x28260FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* adcs<.f><.cc> b,b,limm 00101bbb11100110FBBB1111100QQQQQ.  */
{ "adcs", 0x28E60F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* adcs<.f><.cc> 0,limm,c 0010111011100110F111CCCCCC0QQQQQ.  */
{ "adcs", 0x2EE67000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* adcs<.f> a,limm,u6 0010111001100110F111uuuuuuAAAAAA.  */
{ "adcs", 0x2E667000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* adcs<.f> 0,limm,u6 0010111001100110F111uuuuuu111110.  */
{ "adcs", 0x2E66703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* adcs<.f><.cc> 0,limm,u6 0010111011100110F111uuuuuu1QQQQQ.  */
{ "adcs", 0x2EE67020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* adcs<.f> 0,limm,s12 0010111010100110F111ssssssSSSSSS.  */
{ "adcs", 0x2EA67000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* adcs<.f> a,limm,limm 0010111000100110F111111110AAAAAA.  */
{ "adcs", 0x2E267F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* adcs<.f> 0,limm,limm 0010111000100110F111111110111110.  */
{ "adcs", 0x2E267FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* adcs<.f><.cc> 0,limm,limm 0010111011100110F1111111100QQQQQ.  */
{ "adcs", 0x2EE67F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* add<.f> a,b,c 00100bbb00000000FBBBCCCCCCAAAAAA.  */
{ "add", 0x20000000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* add<.f> 0,b,c 00100bbb00000000FBBBCCCCCC111110.  */
{ "add", 0x2000003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* add<.f><.cc> b,b,c 00100bbb11000000FBBBCCCCCC0QQQQQ.  */
{ "add", 0x20C00000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* add<.f> a,b,u6 00100bbb01000000FBBBuuuuuuAAAAAA.  */
{ "add", 0x20400000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* add<.f> 0,b,u6 00100bbb01000000FBBBuuuuuu111110.  */
{ "add", 0x2040003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* add<.f><.cc> b,b,u6 00100bbb11000000FBBBuuuuuu1QQQQQ.  */
{ "add", 0x20C00020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* add<.f> b,b,s12 00100bbb10000000FBBBssssssSSSSSS.  */
{ "add", 0x20800000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* add<.f> a,limm,c 0010011000000000F111CCCCCCAAAAAA.  */
{ "add", 0x26007000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* add<.f> a,b,limm 00100bbb00000000FBBB111110AAAAAA.  */
{ "add", 0x20000F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* add<.f> 0,limm,c 0010011000000000F111CCCCCC111110.  */
{ "add", 0x2600703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* add<.f> 0,b,limm 00100bbb00000000FBBB111110111110.  */
{ "add", 0x20000FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* add<.f><.cc> b,b,limm 00100bbb11000000FBBB1111100QQQQQ.  */
{ "add", 0x20C00F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* add<.f><.cc> 0,limm,c 0010011011000000F111CCCCCC0QQQQQ.  */
{ "add", 0x26C07000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* add<.f> a,limm,u6 0010011001000000F111uuuuuuAAAAAA.  */
{ "add", 0x26407000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* add<.f> 0,limm,u6 0010011001000000F111uuuuuu111110.  */
{ "add", 0x2640703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* add<.f><.cc> 0,limm,u6 0010011011000000F111uuuuuu1QQQQQ.  */
{ "add", 0x26C07020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* add<.f> 0,limm,s12 0010011010000000F111ssssssSSSSSS.  */
{ "add", 0x26807000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* add<.f> a,limm,limm 0010011000000000F111111110AAAAAA.  */
{ "add", 0x26007F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* add<.f> 0,limm,limm 0010011000000000F111111110111110.  */
{ "add", 0x26007FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* add<.f><.cc> 0,limm,limm 0010011011000000F1111111100QQQQQ.  */
{ "add", 0x26C07F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* add1<.f> a,b,c 00100bbb00010100FBBBCCCCCCAAAAAA.  */
{ "add1", 0x20140000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* add1<.f> 0,b,c 00100bbb00010100FBBBCCCCCC111110.  */
{ "add1", 0x2014003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* add1<.f><.cc> b,b,c 00100bbb11010100FBBBCCCCCC0QQQQQ.  */
{ "add1", 0x20D40000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* add1<.f> a,b,u6 00100bbb01010100FBBBuuuuuuAAAAAA.  */
{ "add1", 0x20540000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* add1<.f> 0,b,u6 00100bbb01010100FBBBuuuuuu111110.  */
{ "add1", 0x2054003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* add1<.f><.cc> b,b,u6 00100bbb11010100FBBBuuuuuu1QQQQQ.  */
{ "add1", 0x20D40020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* add1<.f> b,b,s12 00100bbb10010100FBBBssssssSSSSSS.  */
{ "add1", 0x20940000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* add1<.f> a,limm,c 0010011000010100F111CCCCCCAAAAAA.  */
{ "add1", 0x26147000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* add1<.f> a,b,limm 00100bbb00010100FBBB111110AAAAAA.  */
{ "add1", 0x20140F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* add1<.f> 0,limm,c 0010011000010100F111CCCCCC111110.  */
{ "add1", 0x2614703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* add1<.f> 0,b,limm 00100bbb00010100FBBB111110111110.  */
{ "add1", 0x20140FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* add1<.f><.cc> b,b,limm 00100bbb11010100FBBB1111100QQQQQ.  */
{ "add1", 0x20D40F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* add1<.f><.cc> 0,limm,c 0010011011010100F111CCCCCC0QQQQQ.  */
{ "add1", 0x26D47000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* add1<.f> a,limm,u6 0010011001010100F111uuuuuuAAAAAA.  */
{ "add1", 0x26547000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* add1<.f> 0,limm,u6 0010011001010100F111uuuuuu111110.  */
{ "add1", 0x2654703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* add1<.f><.cc> 0,limm,u6 0010011011010100F111uuuuuu1QQQQQ.  */
{ "add1", 0x26D47020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* add1<.f> 0,limm,s12 0010011010010100F111ssssssSSSSSS.  */
{ "add1", 0x26947000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* add1<.f> a,limm,limm 0010011000010100F111111110AAAAAA.  */
{ "add1", 0x26147F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* add1<.f> 0,limm,limm 0010011000010100F111111110111110.  */
{ "add1", 0x26147FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* add1<.f><.cc> 0,limm,limm 0010011011010100F1111111100QQQQQ.  */
{ "add1", 0x26D47F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* add1_s b,b,c 01111bbbccc10100.  */
{ "add1_s", 0x00007814, 0x0000F81F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* add2<.f> a,b,c 00100bbb00010101FBBBCCCCCCAAAAAA.  */
{ "add2", 0x20150000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* add2<.f> 0,b,c 00100bbb00010101FBBBCCCCCC111110.  */
{ "add2", 0x2015003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* add2<.f><.cc> b,b,c 00100bbb11010101FBBBCCCCCC0QQQQQ.  */
{ "add2", 0x20D50000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* add2<.f> a,b,u6 00100bbb01010101FBBBuuuuuuAAAAAA.  */
{ "add2", 0x20550000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* add2<.f> 0,b,u6 00100bbb01010101FBBBuuuuuu111110.  */
{ "add2", 0x2055003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* add2<.f><.cc> b,b,u6 00100bbb11010101FBBBuuuuuu1QQQQQ.  */
{ "add2", 0x20D50020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* add2<.f> b,b,s12 00100bbb10010101FBBBssssssSSSSSS.  */
{ "add2", 0x20950000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* add2<.f> a,limm,c 0010011000010101F111CCCCCCAAAAAA.  */
{ "add2", 0x26157000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* add2<.f> a,b,limm 00100bbb00010101FBBB111110AAAAAA.  */
{ "add2", 0x20150F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* add2<.f> 0,limm,c 0010011000010101F111CCCCCC111110.  */
{ "add2", 0x2615703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* add2<.f> 0,b,limm 00100bbb00010101FBBB111110111110.  */
{ "add2", 0x20150FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* add2<.f><.cc> b,b,limm 00100bbb11010101FBBB1111100QQQQQ.  */
{ "add2", 0x20D50F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* add2<.f><.cc> 0,limm,c 0010011011010101F111CCCCCC0QQQQQ.  */
{ "add2", 0x26D57000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* add2<.f> a,limm,u6 0010011001010101F111uuuuuuAAAAAA.  */
{ "add2", 0x26557000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* add2<.f> 0,limm,u6 0010011001010101F111uuuuuu111110.  */
{ "add2", 0x2655703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* add2<.f><.cc> 0,limm,u6 0010011011010101F111uuuuuu1QQQQQ.  */
{ "add2", 0x26D57020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* add2<.f> 0,limm,s12 0010011010010101F111ssssssSSSSSS.  */
{ "add2", 0x26957000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* add2<.f> a,limm,limm 0010011000010101F111111110AAAAAA.  */
{ "add2", 0x26157F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* add2<.f> 0,limm,limm 0010011000010101F111111110111110.  */
{ "add2", 0x26157FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* add2<.f><.cc> 0,limm,limm 0010011011010101F1111111100QQQQQ.  */
{ "add2", 0x26D57F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* add2_s b,b,c 01111bbbccc10101.  */
{ "add2_s", 0x00007815, 0x0000F81F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* add3<.f> a,b,c 00100bbb00010110FBBBCCCCCCAAAAAA.  */
{ "add3", 0x20160000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* add3<.f> 0,b,c 00100bbb00010110FBBBCCCCCC111110.  */
{ "add3", 0x2016003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* add3<.f><.cc> b,b,c 00100bbb11010110FBBBCCCCCC0QQQQQ.  */
{ "add3", 0x20D60000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* add3<.f> a,b,u6 00100bbb01010110FBBBuuuuuuAAAAAA.  */
{ "add3", 0x20560000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* add3<.f> 0,b,u6 00100bbb01010110FBBBuuuuuu111110.  */
{ "add3", 0x2056003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* add3<.f><.cc> b,b,u6 00100bbb11010110FBBBuuuuuu1QQQQQ.  */
{ "add3", 0x20D60020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* add3<.f> b,b,s12 00100bbb10010110FBBBssssssSSSSSS.  */
{ "add3", 0x20960000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* add3<.f> a,limm,c 0010011000010110F111CCCCCCAAAAAA.  */
{ "add3", 0x26167000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* add3<.f> a,b,limm 00100bbb00010110FBBB111110AAAAAA.  */
{ "add3", 0x20160F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* add3<.f> 0,limm,c 0010011000010110F111CCCCCC111110.  */
{ "add3", 0x2616703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* add3<.f> 0,b,limm 00100bbb00010110FBBB111110111110.  */
{ "add3", 0x20160FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* add3<.f><.cc> b,b,limm 00100bbb11010110FBBB1111100QQQQQ.  */
{ "add3", 0x20D60F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* add3<.f><.cc> 0,limm,c 0010011011010110F111CCCCCC0QQQQQ.  */
{ "add3", 0x26D67000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* add3<.f> a,limm,u6 0010011001010110F111uuuuuuAAAAAA.  */
{ "add3", 0x26567000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* add3<.f> 0,limm,u6 0010011001010110F111uuuuuu111110.  */
{ "add3", 0x2656703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* add3<.f><.cc> 0,limm,u6 0010011011010110F111uuuuuu1QQQQQ.  */
{ "add3", 0x26D67020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* add3<.f> 0,limm,s12 0010011010010110F111ssssssSSSSSS.  */
{ "add3", 0x26967000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* add3<.f> a,limm,limm 0010011000010110F111111110AAAAAA.  */
{ "add3", 0x26167F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* add3<.f> 0,limm,limm 0010011000010110F111111110111110.  */
{ "add3", 0x26167FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* add3<.f><.cc> 0,limm,limm 0010011011010110F1111111100QQQQQ.  */
{ "add3", 0x26D67F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* add3_s b,b,c 01111bbbccc10110.  */
{ "add3_s", 0x00007816, 0x0000F81F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* addqbs<.f> a,b,c 00110bbb00100100FBBBCCCCCCAAAAAA.  */
{ "addqbs", 0x30240000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* addqbs<.f><.cc> b,b,c 00110bbb11100100FBBBCCCCCC0QQQQQ.  */
{ "addqbs", 0x30E40000, 0xF8FF0020, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* addqbs<.f> a,b,u6 00110bbb01100100FBBBuuuuuuAAAAAA.  */
{ "addqbs", 0x30640000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* addqbs<.f><.cc> b,b,u6 00110bbb11100100FBBBuuuuuu1QQQQQ.  */
{ "addqbs", 0x30E40020, 0xF8FF0020, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* addqbs<.f> b,b,s12 00110bbb10100100FBBBssssssSSSSSS.  */
{ "addqbs", 0x30A40000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* addqbs<.f> a,limm,c 0011011000100100F111CCCCCCAAAAAA.  */
{ "addqbs", 0x36247000, 0xFFFF7000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* addqbs<.f> a,b,limm 00110bbb00100100FBBB111110AAAAAA.  */
{ "addqbs", 0x30240F80, 0xF8FF0FC0, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* addqbs<.f><.cc> b,b,limm 00110bbb11100100FBBB1111100QQQQQ.  */
{ "addqbs", 0x30E40F80, 0xF8FF0FE0, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* adds<.f> a,b,c 00101bbb00000110FBBBCCCCCCAAAAAA.  */
{ "adds", 0x28060000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* adds<.f> 0,b,c 00101bbb00000110FBBBCCCCCC111110.  */
{ "adds", 0x2806003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* adds<.f><.cc> b,b,c 00101bbb11000110FBBBCCCCCC0QQQQQ.  */
{ "adds", 0x28C60000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* adds<.f> a,b,u6 00101bbb01000110FBBBuuuuuuAAAAAA.  */
{ "adds", 0x28460000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* adds<.f> 0,b,u6 00101bbb01000110FBBBuuuuuu111110.  */
{ "adds", 0x2846003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* adds<.f><.cc> b,b,u6 00101bbb11000110FBBBuuuuuu1QQQQQ.  */
{ "adds", 0x28C60020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* adds<.f> b,b,s12 00101bbb10000110FBBBssssssSSSSSS.  */
{ "adds", 0x28860000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* adds<.f> a,limm,c 0010111000000110F111CCCCCCAAAAAA.  */
{ "adds", 0x2E067000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* adds<.f> a,b,limm 00101bbb00000110FBBB111110AAAAAA.  */
{ "adds", 0x28060F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* adds<.f> 0,limm,c 0010111000000110F111CCCCCC111110.  */
{ "adds", 0x2E06703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* adds<.f> 0,b,limm 00101bbb00000110FBBB111110111110.  */
{ "adds", 0x28060FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* adds<.f><.cc> b,b,limm 00101bbb11000110FBBB1111100QQQQQ.  */
{ "adds", 0x28C60F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* adds<.f><.cc> 0,limm,c 0010111011000110F111CCCCCC0QQQQQ.  */
{ "adds", 0x2EC67000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* adds<.f> a,limm,u6 0010111001000110F111uuuuuuAAAAAA.  */
{ "adds", 0x2E467000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* adds<.f> 0,limm,u6 0010111001000110F111uuuuuu111110.  */
{ "adds", 0x2E46703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* adds<.f><.cc> 0,limm,u6 0010111011000110F111uuuuuu1QQQQQ.  */
{ "adds", 0x2EC67020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* adds<.f> 0,limm,s12 0010111010000110F111ssssssSSSSSS.  */
{ "adds", 0x2E867000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* adds<.f> a,limm,limm 0010111000000110F111111110AAAAAA.  */
{ "adds", 0x2E067F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* adds<.f> 0,limm,limm 0010111000000110F111111110111110.  */
{ "adds", 0x2E067FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* adds<.f><.cc> 0,limm,limm 0010111011000110F1111111100QQQQQ.  */
{ "adds", 0x2EC67F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* addsdw<.f> a,b,c 00101bbb00101000FBBBCCCCCCAAAAAA.  */
{ "addsdw", 0x28280000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* addsdw<.f> 0,b,c 00101bbb00101000FBBBCCCCCC111110.  */
{ "addsdw", 0x2828003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* addsdw<.f><.cc> b,b,c 00101bbb11101000FBBBCCCCCC0QQQQQ.  */
{ "addsdw", 0x28E80000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* addsdw<.f> a,b,u6 00101bbb01101000FBBBuuuuuuAAAAAA.  */
{ "addsdw", 0x28680000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* addsdw<.f> 0,b,u6 00101bbb01101000FBBBuuuuuu111110.  */
{ "addsdw", 0x2868003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* addsdw<.f><.cc> b,b,u6 00101bbb11101000FBBBuuuuuu1QQQQQ.  */
{ "addsdw", 0x28E80020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* addsdw<.f> b,b,s12 00101bbb10101000FBBBssssssSSSSSS.  */
{ "addsdw", 0x28A80000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* addsdw<.f> a,limm,c 0010111000101000F111CCCCCCAAAAAA.  */
{ "addsdw", 0x2E287000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* addsdw<.f> a,b,limm 00101bbb00101000FBBB111110AAAAAA.  */
{ "addsdw", 0x28280F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* addsdw<.f> 0,limm,c 0010111000101000F111CCCCCC111110.  */
{ "addsdw", 0x2E28703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* addsdw<.f> 0,b,limm 00101bbb00101000FBBB111110111110.  */
{ "addsdw", 0x28280FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* addsdw<.f><.cc> b,b,limm 00101bbb11101000FBBB1111100QQQQQ.  */
{ "addsdw", 0x28E80F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* addsdw<.f><.cc> 0,limm,c 0010111011101000F111CCCCCC0QQQQQ.  */
{ "addsdw", 0x2EE87000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* addsdw<.f> a,limm,u6 0010111001101000F111uuuuuuAAAAAA.  */
{ "addsdw", 0x2E687000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* addsdw<.f> 0,limm,u6 0010111001101000F111uuuuuu111110.  */
{ "addsdw", 0x2E68703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* addsdw<.f><.cc> 0,limm,u6 0010111011101000F111uuuuuu1QQQQQ.  */
{ "addsdw", 0x2EE87020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* addsdw<.f> 0,limm,s12 0010111010101000F111ssssssSSSSSS.  */
{ "addsdw", 0x2EA87000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* addsdw<.f> a,limm,limm 0010111000101000F111111110AAAAAA.  */
{ "addsdw", 0x2E287F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* addsdw<.f> 0,limm,limm 0010111000101000F111111110111110.  */
{ "addsdw", 0x2E287FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* addsdw<.f><.cc> 0,limm,limm 0010111011101000F1111111100QQQQQ.  */
{ "addsdw", 0x2EE87F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* add_s a,b,c 01100bbbccc11aaa.  */
{ "add_s", 0x00006018, 0x0000F818, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA_S, RB_S, RC_S }, { 0 }},

/* add_s b,b,h 01110bbbhhh00HHH.  */
{ "add_s", 0x00007000, 0x0000F818, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB_S, RB_Sdup, R6H }, { 0 }},

/* add_s b,b,h 01110bbbhhh000HH.  */
{ "add_s", 0x00007000, 0x0000F81C, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB_S, RB_Sdup, RH_S }, { 0 }},

/* add_s h,h,s3 01110ssshhh001HH.  */
{ "add_s", 0x00007004, 0x0000F81C, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RH_S, RH_Sdup, SIMM3_5_S }, { 0 }},

/* add_s c,b,u3 01101bbbccc00uuu.  */
{ "add_s", 0x00006800, 0x0000F818, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RC_S, RB_S, UIMM3_13_S }, { 0 }},

/* add_s R0,b,u6 01001bbb0UUU1uuu.  */
{ "add_s", 0x00004808, 0x0000F888, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, CD2, { R0_S, RB_S, UIMM6_13_S }, { 0 }},

/* add_s R1,b,u6 01001bbb1UUU1uuu.  */
{ "add_s", 0x00004888, 0x0000F888, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, CD2, { R1_S, RB_S, UIMM6_13_S }, { 0 }},

/* add_s b,sp,u7 11000bbb100uuuuu.  */
{ "add_s", 0x0000C080, 0x0000F8E0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB_S, SP_S, UIMM7_A32_11_S }, { 0 }},

/* add_s b,b,u7 11100bbb0uuuuuuu.  */
{ "add_s", 0x0000E000, 0x0000F880, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB_S, RB_Sdup, UIMM7_9_S }, { 0 }},

/* add_s SP,SP,u7 11000000101uuuuu.  */
{ "add_s", 0x0000C0A0, 0x0000FFE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { SP_S, SP_Sdup, UIMM7_A32_11_S }, { 0 }},

/* add_s R0,GP,s11 1100111sssssssss.  */
{ "add_s", 0x0000CE00, 0x0000FE00, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { R0_S, GP_S, SIMM11_A32_7_S }, { 0 }},

/* add_s b,b,limm 01110bbb11000111.  */
{ "add_s", 0x000070C7, 0x0000F8FF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB_S, RB_Sdup, LIMM_S }, { 0 }},

/* add_s b,b,limm 01110bbb11000011.  */
{ "add_s", 0x000070C3, 0x0000F8FF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB_S, RB_Sdup, LIMM_S }, { 0 }},

/* add_s 0,limm,s3 01110sss11000111.  */
{ "add_s", 0x000070C7, 0x0000F8FF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA_S, LIMM_S, SIMM3_5_S }, { 0 }},

/* aex b,c 00100bbb00100111RBBBCCCCCCRRRRRR.  */
{ "aex", 0x20270000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { RB_CHK, BRAKET, RC, BRAKETdup }, { 0 }},

/* aex<.cc> b,c 00100bbb11100111RBBBCCCCCC0QQQQQ.  */
{ "aex", 0x20E70000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { RB_CHK, BRAKET, RC, BRAKETdup }, { C_CC }},

/* aex b,u6 00100bbb01100111RBBBuuuuuuRRRRRR.  */
{ "aex", 0x20670000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { RB_CHK, BRAKET, UIMM6_20, BRAKETdup }, { 0 }},

/* aex<.cc> b,u6 00100bbb11100111RBBBuuuuuu1QQQQQ.  */
{ "aex", 0x20E70020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { RB_CHK, BRAKET, UIMM6_20, BRAKETdup }, { C_CC }},

/* aex b,s12 00100bbb10100111RBBBssssssSSSSSS.  */
{ "aex", 0x20A70000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { RB_CHK, BRAKET, SIMM12_20, BRAKETdup }, { 0 }},

/* aex limm,c 0010011000100111R111CCCCCCRRRRRR.  */
{ "aex", 0x26277000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { LIMM, BRAKET, RC, BRAKETdup }, { 0 }},

/* aex b,limm 00100bbb00100111RBBB111110RRRRRR.  */
{ "aex", 0x20270F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { RB_CHK, BRAKET, LIMM, BRAKETdup }, { 0 }},

/* aex<.cc> limm,c 0010011011100111R111CCCCCC0QQQQQ.  */
{ "aex", 0x26E77000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { LIMM, BRAKET, RC, BRAKETdup }, { C_CC }},

/* aex<.cc> b,limm 00100bbb11100111RBBB1111100QQQQQ.  */
{ "aex", 0x20E70F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { RB_CHK, BRAKET, LIMM, BRAKETdup }, { C_CC }},

/* aex limm,u6 0010011001100111R111uuuuuuRRRRRR.  */
{ "aex", 0x26677000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { LIMM, BRAKET, UIMM6_20, BRAKETdup }, { 0 }},

/* aex<.cc> limm,u6 0010011011100111R111uuuuuu1QQQQQ.  */
{ "aex", 0x26E77020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { LIMM, BRAKET, UIMM6_20, BRAKETdup }, { C_CC }},

/* aex limm,s12 0010011010100111R111ssssssSSSSSS.  */
{ "aex", 0x26A77000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { LIMM, BRAKET, SIMM12_20, BRAKETdup }, { 0 }},

/* aex limm,limm 0010011000100111R111111110RRRRRR.  */
{ "aex", 0x26277F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { LIMM, BRAKET, LIMMdup, BRAKETdup }, { 0 }},

/* aex<.cc> limm,limm 0010011011100111R1111111100QQQQQ.  */
{ "aex", 0x26E77F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { LIMM, BRAKET, LIMMdup, BRAKETdup }, { C_CC }},

/* and<.f> a,b,c 00100bbb00000100FBBBCCCCCCAAAAAA.  */
{ "and", 0x20040000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* and<.f> 0,b,c 00100bbb00000100FBBBCCCCCC111110.  */
{ "and", 0x2004003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* and<.f><.cc> b,b,c 00100bbb11000100FBBBCCCCCC0QQQQQ.  */
{ "and", 0x20C40000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* and<.f> a,b,u6 00100bbb01000100FBBBuuuuuuAAAAAA.  */
{ "and", 0x20440000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* and<.f> 0,b,u6 00100bbb01000100FBBBuuuuuu111110.  */
{ "and", 0x2044003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* and<.f><.cc> b,b,u6 00100bbb11000100FBBBuuuuuu1QQQQQ.  */
{ "and", 0x20C40020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* and<.f> b,b,s12 00100bbb10000100FBBBssssssSSSSSS.  */
{ "and", 0x20840000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* and<.f> a,limm,c 0010011000000100F111CCCCCCAAAAAA.  */
{ "and", 0x26047000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* and<.f> a,b,limm 00100bbb00000100FBBB111110AAAAAA.  */
{ "and", 0x20040F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* and<.f> 0,limm,c 0010011000000100F111CCCCCC111110.  */
{ "and", 0x2604703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* and<.f> 0,b,limm 00100bbb00000100FBBB111110111110.  */
{ "and", 0x20040FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* and<.f><.cc> b,b,limm 00100bbb11000100FBBB1111100QQQQQ.  */
{ "and", 0x20C40F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* and<.f><.cc> 0,limm,c 0010011011000100F111CCCCCC0QQQQQ.  */
{ "and", 0x26C47000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* and<.f> a,limm,u6 0010011001000100F111uuuuuuAAAAAA.  */
{ "and", 0x26447000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* and<.f> 0,limm,u6 0010011001000100F111uuuuuu111110.  */
{ "and", 0x2644703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* and<.f><.cc> 0,limm,u6 0010011011000100F111uuuuuu1QQQQQ.  */
{ "and", 0x26C47020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* and<.f> 0,limm,s12 0010011010000100F111ssssssSSSSSS.  */
{ "and", 0x26847000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* and<.f> a,limm,limm 0010011000000100F111111110AAAAAA.  */
{ "and", 0x26047F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* and<.f> 0,limm,limm 0010011000000100F111111110111110.  */
{ "and", 0x26047FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* and<.f><.cc> 0,limm,limm 0010011011000100F1111111100QQQQQ.  */
{ "and", 0x26C47F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* and_s b,b,c 01111bbbccc00100.  */
{ "and_s", 0x00007804, 0x0000F81F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* asl<.f> b,c 00100bbb00101111FBBBCCCCCC000000.  */
{ "asl", 0x202F0000, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RC }, { C_F }},

/* asl<.f> 0,c 0010011000101111F111CCCCCC000000.  */
{ "asl", 0x262F7000, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RC }, { C_F }},

/* asl<.f> a,b,c 00101bbb00000000FBBBCCCCCCAAAAAA.  */
{ "asl", 0x28000000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, RB, RC }, { C_F }},

/* asl<.f> 0,b,c 00101bbb00000000FBBBCCCCCC111110.  */
{ "asl", 0x2800003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, RB, RC }, { C_F }},

/* asl<.f><.cc> b,b,c 00101bbb11000000FBBBCCCCCC0QQQQQ.  */
{ "asl", 0x28C00000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB, RBdup, RC }, { C_F, C_CC }},

/* asl<.f> b,u6 00100bbb01101111FBBBuuuuuu000000.  */
{ "asl", 0x206F0000, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, UIMM6_20 }, { C_F }},

/* asl<.f> 0,u6 0010011001101111F111uuuuuu000000.  */
{ "asl", 0x266F7000, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, UIMM6_20 }, { C_F }},

/* asl<.f> a,b,u6 00101bbb01000000FBBBuuuuuuAAAAAA.  */
{ "asl", 0x28400000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, RB, UIMM6_20 }, { C_F }},

/* asl<.f> 0,b,u6 00101bbb01000000FBBBuuuuuu111110.  */
{ "asl", 0x2840003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, RB, UIMM6_20 }, { C_F }},

/* asl<.f><.cc> b,b,u6 00101bbb11000000FBBBuuuuuu1QQQQQ.  */
{ "asl", 0x28C00020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* asl<.f> b,b,s12 00101bbb10000000FBBBssssssSSSSSS.  */
{ "asl", 0x28800000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB, RBdup, SIMM12_20 }, { C_F }},

/* asl<.f> b,limm 00100bbb00101111FBBB111110000000.  */
{ "asl", 0x202F0F80, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, LIMM }, { C_F }},

/* asl<.f> 0,limm 0010011000101111F111111110000000.  */
{ "asl", 0x262F7F80, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM }, { C_F }},

/* asl<.f> a,limm,c 0010111000000000F111CCCCCCAAAAAA.  */
{ "asl", 0x2E007000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, LIMM, RC }, { C_F }},

/* asl<.f> a,b,limm 00101bbb00000000FBBB111110AAAAAA.  */
{ "asl", 0x28000F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, RB, LIMM }, { C_F }},

/* asl<.f> 0,limm,c 0010111000000000F111CCCCCC111110.  */
{ "asl", 0x2E00703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, RC }, { C_F }},

/* asl<.f> 0,b,limm 00101bbb00000000FBBB111110111110.  */
{ "asl", 0x28000FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, RB, LIMM }, { C_F }},

/* asl<.f><.cc> b,b,limm 00101bbb11000000FBBB1111100QQQQQ.  */
{ "asl", 0x28C00F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* asl<.f><.cc> 0,limm,c 0010111011000000F111CCCCCC0QQQQQ.  */
{ "asl", 0x2EC07000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, RC }, { C_F, C_CC }},

/* asl<.f> a,limm,u6 0010111001000000F111uuuuuuAAAAAA.  */
{ "asl", 0x2E407000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, LIMM, UIMM6_20 }, { C_F }},

/* asl<.f> 0,limm,u6 0010111001000000F111uuuuuu111110.  */
{ "asl", 0x2E40703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* asl<.f><.cc> 0,limm,u6 0010111011000000F111uuuuuu1QQQQQ.  */
{ "asl", 0x2EC07020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* asl<.f> 0,limm,s12 0010111010000000F111ssssssSSSSSS.  */
{ "asl", 0x2E807000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* asl<.f> a,limm,limm 0010111000000000F111111110AAAAAA.  */
{ "asl", 0x2E007F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, LIMM, LIMMdup }, { C_F }},

/* asl<.f> 0,limm,limm 0010111000000000F111111110111110.  */
{ "asl", 0x2E007FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, LIMMdup }, { C_F }},

/* asl<.f><.cc> 0,limm,limm 0010111011000000F1111111100QQQQQ.  */
{ "asl", 0x2EC07F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* aslacc c 00101000001011110000CCCCCC111111.  */
{ "aslacc", 0x282F003F, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RC }, { 0 }},

/* aslacc u6 00101000011011110000uuuuuu111111.  */
{ "aslacc", 0x286F003F, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { UIMM6_20 }, { 0 }},

/* asldw<.f> a,b,c 00101bbb00100001FBBBCCCCCCAAAAAA.  */
{ "asldw", 0x28210000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* asldw<.f> 0,b,c 00101bbb00100001FBBBCCCCCC111110.  */
{ "asldw", 0x2821003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* asldw<.f><.cc> b,b,c 00101bbb11100001FBBBCCCCCC0QQQQQ.  */
{ "asldw", 0x28E10000, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* asldw<.f> a,b,u6 00101bbb01100001FBBBuuuuuuAAAAAA.  */
{ "asldw", 0x28610000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* asldw<.f> 0,b,u6 00101bbb01100001FBBBuuuuuu111110.  */
{ "asldw", 0x2861003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* asldw<.f><.cc> b,b,u6 00101bbb11100001FBBBuuuuuu1QQQQQ.  */
{ "asldw", 0x28E10020, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* asldw<.f> b,b,s12 00101bbb10100001FBBBssssssSSSSSS.  */
{ "asldw", 0x28A10000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* asldw<.f> a,limm,c 0010111000100001F111CCCCCCAAAAAA.  */
{ "asldw", 0x2E217000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* asldw<.f> a,b,limm 00101bbb00100001FBBB111110AAAAAA.  */
{ "asldw", 0x28210F80, 0xF8FF0FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* asldw<.f> 0,limm,c 0010111000100001F111CCCCCC111110.  */
{ "asldw", 0x2E21703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* asldw<.f> 0,b,limm 00101bbb00100001FBBB111110111110.  */
{ "asldw", 0x28210FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* asldw<.f><.cc> 0,limm,c 0010111011100001F111CCCCCC0QQQQQ.  */
{ "asldw", 0x2EE17000, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* asldw<.f><.cc> b,b,limm 00101bbb11100001FBBB1111100QQQQQ.  */
{ "asldw", 0x28E10F80, 0xF8FF0FE0, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* asldw<.f> a,limm,u6 0010111001100001F111uuuuuuAAAAAA.  */
{ "asldw", 0x2E617000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* asldw<.f> 0,limm,u6 0010111001100001F111uuuuuu111110.  */
{ "asldw", 0x2E61703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* asldw<.f><.cc> 0,limm,u6 0010111011100001F111uuuuuu1QQQQQ.  */
{ "asldw", 0x2EE17020, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* asldw<.f> 0,limm,s12 0010111010100001F111ssssssSSSSSS.  */
{ "asldw", 0x2EA17000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* asldw<.f> a,limm,limm 0010111000100001F111111110AAAAAA.  */
{ "asldw", 0x2E217F80, 0xFFFF7FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* asldw<.f> 0,limm,limm 0010111000100001F111111110111110.  */
{ "asldw", 0x2E217FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* asldw<.f><.cc> 0,limm,limm 0010111011100001F1111111100QQQQQ.  */
{ "asldw", 0x2EE17F80, 0xFFFF7FE0, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* asls<.f> a,b,c 00101bbb00001010FBBBCCCCCCAAAAAA.  */
{ "asls", 0x280A0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* asls<.f> 0,b,c 00101bbb00001010FBBBCCCCCC111110.  */
{ "asls", 0x280A003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* asls<.f><.cc> b,b,c 00101bbb11001010FBBBCCCCCC0QQQQQ.  */
{ "asls", 0x28CA0000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* asls<.f> a,b,u6 00101bbb01001010FBBBuuuuuuAAAAAA.  */
{ "asls", 0x284A0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* asls<.f> 0,b,u6 00101bbb01001010FBBBuuuuuu111110.  */
{ "asls", 0x284A003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* asls<.f><.cc> b,b,u6 00101bbb11001010FBBBuuuuuu1QQQQQ.  */
{ "asls", 0x28CA0020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* asls<.f> b,b,s12 00101bbb10001010FBBBssssssSSSSSS.  */
{ "asls", 0x288A0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* asls<.f> a,limm,c 0010111000001010F111CCCCCCAAAAAA.  */
{ "asls", 0x2E0A7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* asls<.f> a,b,limm 00101bbb00001010FBBB111110AAAAAA.  */
{ "asls", 0x280A0F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* asls<.f> 0,limm,c 0010111000001010F111CCCCCC111110.  */
{ "asls", 0x2E0A703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* asls<.f> 0,b,limm 00101bbb00001010FBBB111110111110.  */
{ "asls", 0x280A0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* asls<.f><.cc> b,b,limm 00101bbb11001010FBBB1111100QQQQQ.  */
{ "asls", 0x28CA0F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* asls<.f><.cc> 0,limm,c 0010111011001010F111CCCCCC0QQQQQ.  */
{ "asls", 0x2ECA7000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* asls<.f> a,limm,u6 0010111001001010F111uuuuuuAAAAAA.  */
{ "asls", 0x2E4A7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* asls<.f> 0,limm,u6 0010111001001010F111uuuuuu111110.  */
{ "asls", 0x2E4A703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* asls<.f><.cc> 0,limm,u6 0010111011001010F111uuuuuu1QQQQQ.  */
{ "asls", 0x2ECA7020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* asls<.f> 0,limm,s12 0010111010001010F111ssssssSSSSSS.  */
{ "asls", 0x2E8A7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* asls<.f> a,limm,limm 0010111000001010F111111110AAAAAA.  */
{ "asls", 0x2E0A7F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* asls<.f> 0,limm,limm 0010111000001010F111111110111110.  */
{ "asls", 0x2E0A7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* asls<.f><.cc> 0,limm,limm 0010111011001010F1111111100QQQQQ.  */
{ "asls", 0x2ECA7F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* aslsacc c 00101001001011110000CCCCCC111111.  */
{ "aslsacc", 0x292F003F, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RC }, { 0 }},

/* aslsacc u6 00101001011011110000uuuuuu111111.  */
{ "aslsacc", 0x296F003F, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { UIMM6_20 }, { 0 }},

/* aslsdw<.f> a,b,c 00101bbb00100100FBBBCCCCCCAAAAAA.  */
{ "aslsdw", 0x28240000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* aslsdw<.f> 0,b,c 00101bbb00100100FBBBCCCCCC111110.  */
{ "aslsdw", 0x2824003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* aslsdw<.f><.cc> b,b,c 00101bbb11100100FBBBCCCCCC0QQQQQ.  */
{ "aslsdw", 0x28E40000, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* aslsdw<.f> a,b,u6 00101bbb01100100FBBBuuuuuuAAAAAA.  */
{ "aslsdw", 0x28640000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* aslsdw<.f> 0,b,u6 00101bbb01100100FBBBuuuuuu111110.  */
{ "aslsdw", 0x2864003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* aslsdw<.f><.cc> b,b,u6 00101bbb11100100FBBBuuuuuu1QQQQQ.  */
{ "aslsdw", 0x28E40020, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* aslsdw<.f> b,b,s12 00101bbb10100100FBBBssssssSSSSSS.  */
{ "aslsdw", 0x28A40000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* aslsdw<.f> a,limm,c 0010111000100100F111CCCCCCAAAAAA.  */
{ "aslsdw", 0x2E247000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* aslsdw<.f> a,b,limm 00101bbb00100100FBBB111110AAAAAA.  */
{ "aslsdw", 0x28240F80, 0xF8FF0FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* aslsdw<.f> 0,limm,c 0010111000100100F111CCCCCC111110.  */
{ "aslsdw", 0x2E24703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* aslsdw<.f> 0,b,limm 00101bbb00100100FBBB111110111110.  */
{ "aslsdw", 0x28240FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* aslsdw<.f><.cc> 0,limm,c 0010111011100100F111CCCCCC0QQQQQ.  */
{ "aslsdw", 0x2EE47000, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* aslsdw<.f><.cc> b,b,limm 00101bbb11100100FBBB1111100QQQQQ.  */
{ "aslsdw", 0x28E40F80, 0xF8FF0FE0, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* aslsdw<.f> a,limm,u6 0010111001100100F111uuuuuuAAAAAA.  */
{ "aslsdw", 0x2E647000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* aslsdw<.f> 0,limm,u6 0010111001100100F111uuuuuu111110.  */
{ "aslsdw", 0x2E64703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* aslsdw<.f><.cc> 0,limm,u6 0010111011100100F111uuuuuu1QQQQQ.  */
{ "aslsdw", 0x2EE47020, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* aslsdw<.f> 0,limm,s12 0010111010100100F111ssssssSSSSSS.  */
{ "aslsdw", 0x2EA47000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* aslsdw<.f> a,limm,limm 0010111000100100F111111110AAAAAA.  */
{ "aslsdw", 0x2E247F80, 0xFFFF7FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* aslsdw<.f> 0,limm,limm 0010111000100100F111111110111110.  */
{ "aslsdw", 0x2E247FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* aslsdw<.f><.cc> 0,limm,limm 0010111011100100F1111111100QQQQQ.  */
{ "aslsdw", 0x2EE47F80, 0xFFFF7FE0, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* asl_s b,c 01111bbbccc11011.  */
{ "asl_s", 0x0000781B, 0x0000F81F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB_S, RC_S }, { 0 }},

/* asl_s b,b,c 01111bbbccc11000.  */
{ "asl_s", 0x00007818, 0x0000F81F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* asl_s c,b,u3 01101bbbccc10uuu.  */
{ "asl_s", 0x00006810, 0x0000F818, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RC_S, RB_S, UIMM3_13_S }, { 0 }},

/* asl_s b,b,u5 10111bbb000uuuuu.  */
{ "asl_s", 0x0000B800, 0x0000F8E0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB_S, RB_Sdup, UIMM5_11_S }, { 0 }},

/* asr<.f> b,c 00100bbb00101111FBBBCCCCCC000001.  */
{ "asr", 0x202F0001, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RC }, { C_F }},

/* asr<.f> 0,c 0010011000101111F111CCCCCC000001.  */
{ "asr", 0x262F7001, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RC }, { C_F }},

/* asr<.f> a,b,c 00101bbb00000010FBBBCCCCCCAAAAAA.  */
{ "asr", 0x28020000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, RB, RC }, { C_F }},

/* asr<.f> 0,b,c 00101bbb00000010FBBBCCCCCC111110.  */
{ "asr", 0x2802003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, RB, RC }, { C_F }},

/* asr<.f><.cc> b,b,c 00101bbb11000010FBBBCCCCCC0QQQQQ.  */
{ "asr", 0x28C20000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB, RBdup, RC }, { C_F, C_CC }},

/* asr<.f> b,u6 00100bbb01101111FBBBuuuuuu000001.  */
{ "asr", 0x206F0001, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, UIMM6_20 }, { C_F }},

/* asr<.f> 0,u6 0010011001101111F111uuuuuu000001.  */
{ "asr", 0x266F7001, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, UIMM6_20 }, { C_F }},

/* asr<.f> a,b,u6 00101bbb01000010FBBBuuuuuuAAAAAA.  */
{ "asr", 0x28420000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, RB, UIMM6_20 }, { C_F }},

/* asr<.f> 0,b,u6 00101bbb01000010FBBBuuuuuu111110.  */
{ "asr", 0x2842003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, RB, UIMM6_20 }, { C_F }},

/* asr<.f><.cc> b,b,u6 00101bbb11000010FBBBuuuuuu1QQQQQ.  */
{ "asr", 0x28C20020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* asr<.f> b,b,s12 00101bbb10000010FBBBssssssSSSSSS.  */
{ "asr", 0x28820000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB, RBdup, SIMM12_20 }, { C_F }},

/* asr<.f> b,limm 00100bbb00101111FBBB111110000001.  */
{ "asr", 0x202F0F81, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, LIMM }, { C_F }},

/* asr<.f> 0,limm 0010011000101111F111111110000001.  */
{ "asr", 0x262F7F81, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM }, { C_F }},

/* asr<.f> a,limm,c 0010111000000010F111CCCCCCAAAAAA.  */
{ "asr", 0x2E027000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, LIMM, RC }, { C_F }},

/* asr<.f> a,b,limm 00101bbb00000010FBBB111110AAAAAA.  */
{ "asr", 0x28020F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, RB, LIMM }, { C_F }},

/* asr<.f> 0,limm,c 0010111000000010F111CCCCCC111110.  */
{ "asr", 0x2E02703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, RC }, { C_F }},

/* asr<.f> 0,b,limm 00101bbb00000010FBBB111110111110.  */
{ "asr", 0x28020FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, RB, LIMM }, { C_F }},

/* asr<.f><.cc> b,b,limm 00101bbb11000010FBBB1111100QQQQQ.  */
{ "asr", 0x28C20F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* asr<.f><.cc> 0,limm,c 0010111011000010F111CCCCCC0QQQQQ.  */
{ "asr", 0x2EC27000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, RC }, { C_F, C_CC }},

/* asr<.f> a,limm,u6 0010111001000010F111uuuuuuAAAAAA.  */
{ "asr", 0x2E427000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, LIMM, UIMM6_20 }, { C_F }},

/* asr<.f> 0,limm,u6 0010111001000010F111uuuuuu111110.  */
{ "asr", 0x2E42703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* asr<.f><.cc> 0,limm,u6 0010111011000010F111uuuuuu1QQQQQ.  */
{ "asr", 0x2EC27020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* asr<.f> 0,limm,s12 0010111010000010F111ssssssSSSSSS.  */
{ "asr", 0x2E827000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* asr<.f> a,limm,limm 0010111000000010F111111110AAAAAA.  */
{ "asr", 0x2E027F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, LIMM, LIMMdup }, { C_F }},

/* asr<.f> 0,limm,limm 0010111000000010F111111110111110.  */
{ "asr", 0x2E027FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, LIMMdup }, { C_F }},

/* asr<.f><.cc> 0,limm,limm 0010111011000010F1111111100QQQQQ.  */
{ "asr", 0x2EC27F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* asr16<.f> b,c 00101bbb00101111FBBBCCCCCC001100.  */
{ "asr16", 0x282F000C, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { RB, RC }, { C_F }},

/* asr16<.f> 0,c 0010111000101111F111CCCCCC001100.  */
{ "asr16", 0x2E2F700C, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { ZA, RC }, { C_F }},

/* asr16<.f> b,u6 00101bbb01101111FBBBuuuuuu001100.  */
{ "asr16", 0x286F000C, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { RB, UIMM6_20 }, { C_F }},

/* asr16<.f> 0,u6 0010111001101111F111uuuuuu001100.  */
{ "asr16", 0x2E6F700C, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { ZA, UIMM6_20 }, { C_F }},

/* asr16<.f> b,limm 00101bbb00101111FBBB111110001100.  */
{ "asr16", 0x282F0F8C, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { RB, LIMM }, { C_F }},

/* asr16<.f> 0,limm 0010111000101111F111111110001100.  */
{ "asr16", 0x2E2F7F8C, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { ZA, LIMM }, { C_F }},

/* asr8<.f> b,c 00101bbb00101111FBBBCCCCCC001101.  */
{ "asr8", 0x282F000D, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { RB, RC }, { C_F }},

/* asr8<.f> 0,c 0010111000101111F111CCCCCC001101.  */
{ "asr8", 0x2E2F700D, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { ZA, RC }, { C_F }},

/* asr8<.f> b,u6 00101bbb01101111FBBBuuuuuu001101.  */
{ "asr8", 0x286F000D, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { RB, UIMM6_20 }, { C_F }},

/* asr8<.f> 0,u6 0010111001101111F111uuuuuu001101.  */
{ "asr8", 0x2E6F700D, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { ZA, UIMM6_20 }, { C_F }},

/* asr8<.f> b,limm 00101bbb00101111FBBB111110001101.  */
{ "asr8", 0x282F0F8D, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { RB, LIMM }, { C_F }},

/* asr8<.f> 0,limm 0010111000101111F111111110001101.  */
{ "asr8", 0x2E2F7F8D, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { ZA, LIMM }, { C_F }},

/* asrdw<.f> a,b,c 00101bbb00100010FBBBCCCCCCAAAAAA.  */
{ "asrdw", 0x28220000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* asrdw<.f> 0,b,c 00101bbb00100010FBBBCCCCCC111110.  */
{ "asrdw", 0x2822003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* asrdw<.f><.cc> b,b,c 00101bbb11100010FBBBCCCCCC0QQQQQ.  */
{ "asrdw", 0x28E20000, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* asrdw<.f> a,b,u6 00101bbb01100010FBBBuuuuuuAAAAAA.  */
{ "asrdw", 0x28620000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* asrdw<.f> 0,b,u6 00101bbb01100010FBBBuuuuuu111110.  */
{ "asrdw", 0x2862003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* asrdw<.f><.cc> b,b,u6 00101bbb11100010FBBBuuuuuu1QQQQQ.  */
{ "asrdw", 0x28E20020, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* asrdw<.f> b,b,s12 00101bbb10100010FBBBssssssSSSSSS.  */
{ "asrdw", 0x28A20000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* asrdw<.f> a,limm,c 0010111000100010F111CCCCCCAAAAAA.  */
{ "asrdw", 0x2E227000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* asrdw<.f> a,b,limm 00101bbb00100010FBBB111110AAAAAA.  */
{ "asrdw", 0x28220F80, 0xF8FF0FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* asrdw<.f> 0,limm,c 0010111000100010F111CCCCCC111110.  */
{ "asrdw", 0x2E22703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* asrdw<.f> 0,b,limm 00101bbb00100010FBBB111110111110.  */
{ "asrdw", 0x28220FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* asrdw<.f><.cc> 0,limm,c 0010111011100010F111CCCCCC0QQQQQ.  */
{ "asrdw", 0x2EE27000, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* asrdw<.f><.cc> b,b,limm 00101bbb11100010FBBB1111100QQQQQ.  */
{ "asrdw", 0x28E20F80, 0xF8FF0FE0, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* asrdw<.f> a,limm,u6 0010111001100010F111uuuuuuAAAAAA.  */
{ "asrdw", 0x2E627000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* asrdw<.f> 0,limm,u6 0010111001100010F111uuuuuu111110.  */
{ "asrdw", 0x2E62703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* asrdw<.f><.cc> 0,limm,u6 0010111011100010F111uuuuuu1QQQQQ.  */
{ "asrdw", 0x2EE27020, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* asrdw<.f> 0,limm,s12 0010111010100010F111ssssssSSSSSS.  */
{ "asrdw", 0x2EA27000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* asrdw<.f> a,limm,limm 0010111000100010F111111110AAAAAA.  */
{ "asrdw", 0x2E227F80, 0xFFFF7FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* asrdw<.f> 0,limm,limm 0010111000100010F111111110111110.  */
{ "asrdw", 0x2E227FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* asrdw<.f><.cc> 0,limm,limm 0010111011100010F1111111100QQQQQ.  */
{ "asrdw", 0x2EE27F80, 0xFFFF7FE0, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* asrs<.f> a,b,c 00101bbb00001011FBBBCCCCCCAAAAAA.  */
{ "asrs", 0x280B0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* asrs<.f> 0,b,c 00101bbb00001011FBBBCCCCCC111110.  */
{ "asrs", 0x280B003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* asrs<.f><.cc> b,b,c 00101bbb11001011FBBBCCCCCC0QQQQQ.  */
{ "asrs", 0x28CB0000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* asrs<.f> a,b,u6 00101bbb01001011FBBBuuuuuuAAAAAA.  */
{ "asrs", 0x284B0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* asrs<.f> 0,b,u6 00101bbb01001011FBBBuuuuuu111110.  */
{ "asrs", 0x284B003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* asrs<.f><.cc> b,b,u6 00101bbb11001011FBBBuuuuuu1QQQQQ.  */
{ "asrs", 0x28CB0020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* asrs<.f> b,b,s12 00101bbb10001011FBBBssssssSSSSSS.  */
{ "asrs", 0x288B0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* asrs<.f> a,limm,c 0010111000001011F111CCCCCCAAAAAA.  */
{ "asrs", 0x2E0B7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* asrs<.f> a,b,limm 00101bbb00001011FBBB111110AAAAAA.  */
{ "asrs", 0x280B0F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* asrs<.f> 0,limm,c 0010111000001011F111CCCCCC111110.  */
{ "asrs", 0x2E0B703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* asrs<.f> 0,b,limm 00101bbb00001011FBBB111110111110.  */
{ "asrs", 0x280B0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* asrs<.f><.cc> b,b,limm 00101bbb11001011FBBB1111100QQQQQ.  */
{ "asrs", 0x28CB0F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* asrs<.f><.cc> 0,limm,c 0010111011001011F111CCCCCC0QQQQQ.  */
{ "asrs", 0x2ECB7000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* asrs<.f> a,limm,u6 0010111001001011F111uuuuuuAAAAAA.  */
{ "asrs", 0x2E4B7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* asrs<.f> 0,limm,u6 0010111001001011F111uuuuuu111110.  */
{ "asrs", 0x2E4B703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* asrs<.f><.cc> 0,limm,u6 0010111011001011F111uuuuuu1QQQQQ.  */
{ "asrs", 0x2ECB7020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* asrs<.f> 0,limm,s12 0010111010001011F111ssssssSSSSSS.  */
{ "asrs", 0x2E8B7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* asrs<.f> a,limm,limm 0010111000001011F111111110AAAAAA.  */
{ "asrs", 0x2E0B7F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* asrs<.f> 0,limm,limm 0010111000001011F111111110111110.  */
{ "asrs", 0x2E0B7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* asrs<.f><.cc> 0,limm,limm 0010111011001011F1111111100QQQQQ.  */
{ "asrs", 0x2ECB7F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* asrsdw<.f> a,b,c 00101bbb00100101FBBBCCCCCCAAAAAA.  */
{ "asrsdw", 0x28250000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* asrsdw<.f> 0,b,c 00101bbb00100101FBBBCCCCCC111110.  */
{ "asrsdw", 0x2825003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* asrsdw<.f><.cc> b,b,c 00101bbb11100101FBBBCCCCCC0QQQQQ.  */
{ "asrsdw", 0x28E50000, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* asrsdw<.f> a,b,u6 00101bbb01100101FBBBuuuuuuAAAAAA.  */
{ "asrsdw", 0x28650000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* asrsdw<.f> 0,b,u6 00101bbb01100101FBBBuuuuuu111110.  */
{ "asrsdw", 0x2865003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* asrsdw<.f><.cc> b,b,u6 00101bbb11100101FBBBuuuuuu1QQQQQ.  */
{ "asrsdw", 0x28E50020, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* asrsdw<.f> b,b,s12 00101bbb10100101FBBBssssssSSSSSS.  */
{ "asrsdw", 0x28A50000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* asrsdw<.f> a,limm,c 0010111000100101F111CCCCCCAAAAAA.  */
{ "asrsdw", 0x2E257000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* asrsdw<.f> a,b,limm 00101bbb00100101FBBB111110AAAAAA.  */
{ "asrsdw", 0x28250F80, 0xF8FF0FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* asrsdw<.f> 0,limm,c 0010111000100101F111CCCCCC111110.  */
{ "asrsdw", 0x2E25703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* asrsdw<.f> 0,b,limm 00101bbb00100101FBBB111110111110.  */
{ "asrsdw", 0x28250FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* asrsdw<.f><.cc> 0,limm,c 0010111011100101F111CCCCCC0QQQQQ.  */
{ "asrsdw", 0x2EE57000, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* asrsdw<.f><.cc> b,b,limm 00101bbb11100101FBBB1111100QQQQQ.  */
{ "asrsdw", 0x28E50F80, 0xF8FF0FE0, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* asrsdw<.f> a,limm,u6 0010111001100101F111uuuuuuAAAAAA.  */
{ "asrsdw", 0x2E657000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* asrsdw<.f> 0,limm,u6 0010111001100101F111uuuuuu111110.  */
{ "asrsdw", 0x2E65703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* asrsdw<.f><.cc> 0,limm,u6 0010111011100101F111uuuuuu1QQQQQ.  */
{ "asrsdw", 0x2EE57020, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* asrsdw<.f> 0,limm,s12 0010111010100101F111ssssssSSSSSS.  */
{ "asrsdw", 0x2EA57000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* asrsdw<.f> a,limm,limm 0010111000100101F111111110AAAAAA.  */
{ "asrsdw", 0x2E257F80, 0xFFFF7FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* asrsdw<.f> 0,limm,limm 0010111000100101F111111110111110.  */
{ "asrsdw", 0x2E257FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* asrsdw<.f><.cc> 0,limm,limm 0010111011100101F1111111100QQQQQ.  */
{ "asrsdw", 0x2EE57F80, 0xFFFF7FE0, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* asrsr<.f> a,b,c 00101bbb00001100FBBBCCCCCCAAAAAA.  */
{ "asrsr", 0x280C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* asrsr<.f> 0,b,c 00101bbb00001100FBBBCCCCCC111110.  */
{ "asrsr", 0x280C003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* asrsr<.f><.cc> b,b,c 00101bbb11001100FBBBCCCCCC0QQQQQ.  */
{ "asrsr", 0x28CC0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* asrsr<.f> a,b,u6 00101bbb01001100FBBBuuuuuuAAAAAA.  */
{ "asrsr", 0x284C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* asrsr<.f> 0,b,u6 00101bbb01001100FBBBuuuuuu111110.  */
{ "asrsr", 0x284C003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* asrsr<.f><.cc> b,b,u6 00101bbb11001100FBBBuuuuuu1QQQQQ.  */
{ "asrsr", 0x28CC0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* asrsr<.f> b,b,s12 00101bbb10001100FBBBssssssSSSSSS.  */
{ "asrsr", 0x288C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* asrsr<.f> a,limm,c 0010111000001100F111CCCCCCAAAAAA.  */
{ "asrsr", 0x2E0C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* asrsr<.f> a,b,limm 00101bbb00001100FBBB111110AAAAAA.  */
{ "asrsr", 0x280C0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* asrsr<.f> 0,limm,c 0010111000001100F111CCCCCC111110.  */
{ "asrsr", 0x2E0C703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* asrsr<.f> 0,b,limm 00101bbb00001100FBBB111110111110.  */
{ "asrsr", 0x280C0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* asrsr<.f><.cc> b,b,limm 00101bbb11001100FBBB1111100QQQQQ.  */
{ "asrsr", 0x28CC0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* asrsr<.f><.cc> 0,limm,c 0010111011001100F111CCCCCC0QQQQQ.  */
{ "asrsr", 0x2ECC7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* asrsr<.f> a,limm,u6 0010111001001100F111uuuuuuAAAAAA.  */
{ "asrsr", 0x2E4C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* asrsr<.f> 0,limm,u6 0010111001001100F111uuuuuu111110.  */
{ "asrsr", 0x2E4C703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* asrsr<.f><.cc> 0,limm,u6 0010111011001100F111uuuuuu1QQQQQ.  */
{ "asrsr", 0x2ECC7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* asrsr<.f> 0,limm,s12 0010111010001100F111ssssssSSSSSS.  */
{ "asrsr", 0x2E8C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* asrsr<.f> a,limm,limm 0010111000001100F111111110AAAAAA.  */
{ "asrsr", 0x2E0C7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* asrsr<.f> 0,limm,limm 0010111000001100F111111110111110.  */
{ "asrsr", 0x2E0C7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* asrsr<.f><.cc> 0,limm,limm 0010111011001100F1111111100QQQQQ.  */
{ "asrsr", 0x2ECC7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* asr_s b,c 01111bbbccc11100.  */
{ "asr_s", 0x0000781C, 0x0000F81F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB_S, RC_S }, { 0 }},

/* asr_s b,b,c 01111bbbccc11010.  */
{ "asr_s", 0x0000781A, 0x0000F81F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* asr_s c,b,u3 01101bbbccc11uuu.  */
{ "asr_s", 0x00006818, 0x0000F818, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RC_S, RB_S, UIMM3_13_S }, { 0 }},

/* asr_s b,b,u5 10111bbb010uuuuu.  */
{ "asr_s", 0x0000B840, 0x0000F8E0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB_S, RB_Sdup, UIMM5_11_S }, { 0 }},

/* avgqb<.f> a,b,c 00110bbb00100011FBBBCCCCCCAAAAAA.  */
{ "avgqb", 0x30230000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* avgqb<.f><.cc> b,b,c 00110bbb11100011FBBBCCCCCC0QQQQQ.  */
{ "avgqb", 0x30E30000, 0xF8FF0020, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* avgqb<.f> a,b,u6 00110bbb01100011FBBBuuuuuuAAAAAA.  */
{ "avgqb", 0x30630000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* avgqb<.f><.cc> b,b,u6 00110bbb11100011FBBBuuuuuu1QQQQQ.  */
{ "avgqb", 0x30E30020, 0xF8FF0020, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* avgqb<.f> b,b,s12 00110bbb10100011FBBBssssssSSSSSS.  */
{ "avgqb", 0x30A30000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* avgqb<.f> a,limm,c 0011011000100011F111CCCCCCAAAAAA.  */
{ "avgqb", 0x36237000, 0xFFFF7000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* avgqb<.f> a,b,limm 00110bbb00100011FBBB111110AAAAAA.  */
{ "avgqb", 0x30230F80, 0xF8FF0FC0, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* avgqb<.f><.cc> b,b,limm 00110bbb11100011FBBB1111100QQQQQ.  */
{ "avgqb", 0x30E30F80, 0xF8FF0FE0, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* b<.d> s25 00000ssssssssss1SSSSSSSSSSNRtttt.  */
{ "b", 0x00010000, 0xF8010000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRANCH, NONE, { SIMM25_A16_5 }, { C_D }},

/* b<.d><cc> s21 00000ssssssssss0SSSSSSSSSSNQQQQQ.  */
{ "b", 0x00000000, 0xF8010000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRANCH, NONE, { SIMM21_A16_5 }, { C_CC, C_D }},

/* bbit0<.d> b,c,s9 00001bbbsssssss1SBBBCCCCCCN01110.  */
{ "bbit0", 0x0801000E, 0xF801001F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BBIT0, COND, { RB, RC, SIMM9_A16_8 }, { C_D }},

/* bbit0<.d><.T> b,c,s9 00001bbbsssssss1SBBBCCCCCCN0Y110.  */
{ "bbit0", 0x08010006, 0xF8010017, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BBIT0, COND, { RB, RC, SIMM9_A16_8 }, { C_D, C_T }},

/* bbit0<.d> b,u6,s9 00001bbbsssssss1SBBBuuuuuuN11110.  */
{ "bbit0", 0x0801001E, 0xF801001F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BBIT0, COND, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D }},

/* bbit0<.d><.T> b,u6,s9 00001bbbsssssss1SBBBuuuuuuN1Y110.  */
{ "bbit0", 0x08010016, 0xF8010017, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BBIT0, COND, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D, C_T }},

/* bbit0 b,limm,s9 00001bbbsssssss1SBBB111110001110.  */
{ "bbit0", 0x08010F8E, 0xF8010FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BBIT0, COND, { RB, LIMM, SIMM9_A16_8 }, { 0 }},

/* bbit0 limm,c,s9 00001110sssssss1S111CCCCCC001110.  */
{ "bbit0", 0x0E01700E, 0xFF01703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BBIT0, COND, { LIMM, RC, SIMM9_A16_8 }, { 0 }},

/* bbit0<.T> b,limm,s9 00001bbbsssssss1SBBB11111000Y110.  */
{ "bbit0", 0x08010F86, 0xF8010FF7, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BBIT0, COND, { RB, LIMM, SIMM9_A16_8 }, { C_T }},

/* bbit0<.T> limm,c,s9 00001110sssssss1S111CCCCCC00Y110.  */
{ "bbit0", 0x0E017006, 0xFF017037, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BBIT0, COND, { LIMM, RC, SIMM9_A16_8 }, { C_T }},

/* bbit0 limm,u6,s9 00001110sssssss1S111uuuuuu011110.  */
{ "bbit0", 0x0E01701E, 0xFF01703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BBIT0, COND, { LIMM, UIMM6_8, SIMM9_A16_8 }, { 0 }},

/* bbit0<.T> limm,u6,s9 00001110sssssss1S111uuuuuu01Y110.  */
{ "bbit0", 0x0E017016, 0xFF017037, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BBIT0, COND, { LIMM, UIMM6_8, SIMM9_A16_8 }, { C_T }},

/* bbit0 limm,limm,s9 00001110sssssss1S111111110001110.  */
{ "bbit0", 0x0E017F8E, 0xFF017FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BBIT0, COND, { LIMM, LIMMdup, SIMM9_A16_8 }, { 0 }},

/* bbit0<.T> limm,limm,s9 00001110sssssss1S11111111000Y110.  */
{ "bbit0", 0x0E017F86, 0xFF017FF7, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BBIT0, COND, { LIMM, LIMMdup, SIMM9_A16_8 }, { C_T }},

/* bbit1<.d> b,c,s9 00001bbbsssssss1SBBBCCCCCCN01111.  */
{ "bbit1", 0x0801000F, 0xF801001F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BBIT1, COND, { RB, RC, SIMM9_A16_8 }, { C_D }},

/* bbit1<.d><.T> b,c,s9 00001bbbsssssss1SBBBCCCCCCN0Y111.  */
{ "bbit1", 0x08010007, 0xF8010017, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BBIT1, COND, { RB, RC, SIMM9_A16_8 }, { C_D, C_T }},

/* bbit1<.d> b,u6,s9 00001bbbsssssss1SBBBuuuuuuN11111.  */
{ "bbit1", 0x0801001F, 0xF801001F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BBIT1, COND, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D }},

/* bbit1<.d><.T> b,u6,s9 00001bbbsssssss1SBBBuuuuuuN1Y111.  */
{ "bbit1", 0x08010017, 0xF8010017, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BBIT1, COND, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D, C_T }},

/* bbit1 b,limm,s9 00001bbbsssssss1SBBB111110001111.  */
{ "bbit1", 0x08010F8F, 0xF8010FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BBIT1, COND, { RB, LIMM, SIMM9_A16_8 }, { 0 }},

/* bbit1 limm,c,s9 00001110sssssss1S111CCCCCC001111.  */
{ "bbit1", 0x0E01700F, 0xFF01703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BBIT1, COND, { LIMM, RC, SIMM9_A16_8 }, { 0 }},

/* bbit1<.T> b,limm,s9 00001bbbsssssss1SBBB11111000Y111.  */
{ "bbit1", 0x08010F87, 0xF8010FF7, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BBIT1, COND, { RB, LIMM, SIMM9_A16_8 }, { C_T }},

/* bbit1<.T> limm,c,s9 00001110sssssss1S111CCCCCC00Y111.  */
{ "bbit1", 0x0E017007, 0xFF017037, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BBIT1, COND, { LIMM, RC, SIMM9_A16_8 }, { C_T }},

/* bbit1 limm,u6,s9 00001110sssssss1S111uuuuuu011111.  */
{ "bbit1", 0x0E01701F, 0xFF01703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BBIT1, COND, { LIMM, UIMM6_8, SIMM9_A16_8 }, { 0 }},

/* bbit1<.T> limm,u6,s9 00001110sssssss1S111uuuuuu01Y111.  */
{ "bbit1", 0x0E017017, 0xFF017037, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BBIT1, COND, { LIMM, UIMM6_8, SIMM9_A16_8 }, { C_T }},

/* bbit1 limm,limm,s9 00001110sssssss1S111111110001111.  */
{ "bbit1", 0x0E017F8F, 0xFF017FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BBIT1, COND, { LIMM, LIMMdup, SIMM9_A16_8 }, { 0 }},

/* bbit1<.T> limm,limm,s9 00001110sssssss1S11111111000Y111.  */
{ "bbit1", 0x0E017F87, 0xFF017FF7, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BBIT1, COND, { LIMM, LIMMdup, SIMM9_A16_8 }, { C_T }},

/* bclr<.f> a,b,c 00100bbb00010000FBBBCCCCCCAAAAAA.  */
{ "bclr", 0x20100000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* bclr<.f> 0,b,c 00100bbb00010000FBBBCCCCCC111110.  */
{ "bclr", 0x2010003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* bclr<.f><.cc> b,b,c 00100bbb11010000FBBBCCCCCC0QQQQQ.  */
{ "bclr", 0x20D00000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* bclr<.f> a,b,u6 00100bbb01010000FBBBuuuuuuAAAAAA.  */
{ "bclr", 0x20500000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* bclr<.f> 0,b,u6 00100bbb01010000FBBBuuuuuu111110.  */
{ "bclr", 0x2050003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* bclr<.f><.cc> b,b,u6 00100bbb11010000FBBBuuuuuu1QQQQQ.  */
{ "bclr", 0x20D00020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* bclr<.f> b,b,s12 00100bbb10010000FBBBssssssSSSSSS.  */
{ "bclr", 0x20900000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* bclr<.f> a,limm,c 0010011000010000F111CCCCCCAAAAAA.  */
{ "bclr", 0x26107000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* bclr<.f> a,b,limm 00100bbb00010000FBBB111110AAAAAA.  */
{ "bclr", 0x20100F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* bclr<.f> 0,limm,c 0010011000010000F111CCCCCC111110.  */
{ "bclr", 0x2610703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* bclr<.f> 0,b,limm 00100bbb00010000FBBB111110111110.  */
{ "bclr", 0x20100FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* bclr<.f><.cc> b,b,limm 00100bbb11010000FBBB1111100QQQQQ.  */
{ "bclr", 0x20D00F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* bclr<.f><.cc> 0,limm,c 0010011011010000F111CCCCCC0QQQQQ.  */
{ "bclr", 0x26D07000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* bclr<.f> a,limm,u6 0010011001010000F111uuuuuuAAAAAA.  */
{ "bclr", 0x26507000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* bclr<.f> 0,limm,u6 0010011001010000F111uuuuuu111110.  */
{ "bclr", 0x2650703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* bclr<.f><.cc> 0,limm,u6 0010011011010000F111uuuuuu1QQQQQ.  */
{ "bclr", 0x26D07020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* bclr<.f> 0,limm,s12 0010011010010000F111ssssssSSSSSS.  */
{ "bclr", 0x26907000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* bclr<.f> a,limm,limm 0010011000010000F111111110AAAAAA.  */
{ "bclr", 0x26107F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* bclr<.f> 0,limm,limm 0010011000010000F111111110111110.  */
{ "bclr", 0x26107FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* bclr<.f><.cc> 0,limm,limm 0010011011010000F1111111100QQQQQ.  */
{ "bclr", 0x26D07F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* bclr_s b,b,u5 10111bbb101uuuuu.  */
{ "bclr_s", 0x0000B8A0, 0x0000F8E0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB_S, RB_Sdup, UIMM5_11_S }, { 0 }},

/* beq_sCC_EQ s10 1111001sssssssss.  */
{ "beq_s", 0x0000F200, 0x0000FE00, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRANCH, COND, { SIMM10_A16_7_S }, { C_CC_EQ }},

/* bge_sCC_GE s7 1111011001ssssss.  */
{ "bge_s", 0x0000F640, 0x0000FFC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRANCH, COND, { SIMM7_A16_10_S }, { C_CC_GE }},

/* bgt_sCC_GT s7 1111011000ssssss.  */
{ "bgt_s", 0x0000F600, 0x0000FFC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRANCH, COND, { SIMM7_A16_10_S }, { C_CC_GT }},

/* bhi_sCC_HI s7 1111011100ssssss.  */
{ "bhi_s", 0x0000F700, 0x0000FFC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRANCH, COND, { SIMM7_A16_10_S }, { C_CC_HI }},

/* bhs_sCC_HS s7 1111011101ssssss.  */
{ "bhs_s", 0x0000F740, 0x0000FFC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRANCH, COND, { SIMM7_A16_10_S }, { C_CC_HS }},

/* bi c 00100RRR001001000RRRCCCCCCRRRRRR.  */
{ "bi", 0x20240000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BI, CD1, { BRAKET, RC, BRAKETdup }, { 0 }},

/* bi limm 00100RRR001001000RRR111110RRRRRR.  */
{ "bi", 0x20240F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BI, CD1, { BRAKET, LIMM, BRAKETdup }, { 0 }},

/* bic<.f> a,b,c 00100bbb00000110FBBBCCCCCCAAAAAA.  */
{ "bic", 0x20060000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* bic<.f> 0,b,c 00100bbb00000110FBBBCCCCCC111110.  */
{ "bic", 0x2006003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* bic<.f><.cc> b,b,c 00100bbb11000110FBBBCCCCCC0QQQQQ.  */
{ "bic", 0x20C60000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* bic<.f> a,b,u6 00100bbb01000110FBBBuuuuuuAAAAAA.  */
{ "bic", 0x20460000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* bic<.f> 0,b,u6 00100bbb01000110FBBBuuuuuu111110.  */
{ "bic", 0x2046003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* bic<.f><.cc> b,b,u6 00100bbb11000110FBBBuuuuuu1QQQQQ.  */
{ "bic", 0x20C60020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* bic<.f> b,b,s12 00100bbb10000110FBBBssssssSSSSSS.  */
{ "bic", 0x20860000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* bic<.f> a,limm,c 0010011000000110F111CCCCCCAAAAAA.  */
{ "bic", 0x26067000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* bic<.f> a,b,limm 00100bbb00000110FBBB111110AAAAAA.  */
{ "bic", 0x20060F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* bic<.f> 0,limm,c 0010011000000110F111CCCCCC111110.  */
{ "bic", 0x2606703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* bic<.f> 0,b,limm 00100bbb00000110FBBB111110111110.  */
{ "bic", 0x20060FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* bic<.f><.cc> b,b,limm 00100bbb11000110FBBB1111100QQQQQ.  */
{ "bic", 0x20C60F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* bic<.f><.cc> 0,limm,c 0010011011000110F111CCCCCC0QQQQQ.  */
{ "bic", 0x26C67000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* bic<.f> a,limm,u6 0010011001000110F111uuuuuuAAAAAA.  */
{ "bic", 0x26467000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* bic<.f> 0,limm,u6 0010011001000110F111uuuuuu111110.  */
{ "bic", 0x2646703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* bic<.f><.cc> 0,limm,u6 0010011011000110F111uuuuuu1QQQQQ.  */
{ "bic", 0x26C67020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* bic<.f> 0,limm,s12 0010011010000110F111ssssssSSSSSS.  */
{ "bic", 0x26867000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* bic<.f> a,limm,limm 0010011000000110F111111110AAAAAA.  */
{ "bic", 0x26067F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* bic<.f> 0,limm,limm 0010011000000110F111111110111110.  */
{ "bic", 0x26067FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* bic<.f><.cc> 0,limm,limm 0010011011000110F1111111100QQQQQ.  */
{ "bic", 0x26C67F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* bic_s b,b,c 01111bbbccc00110.  */
{ "bic_s", 0x00007806, 0x0000F81F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* bih c 00100RRR001001010RRRCCCCCCRRRRRR.  */
{ "bih", 0x20250000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BIH, CD1, { BRAKET, RC, BRAKETdup }, { 0 }},

/* bih limm 00100RRR001001010RRR111110RRRRRR.  */
{ "bih", 0x20250F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BIH, CD1, { BRAKET, LIMM, BRAKETdup }, { 0 }},

/* bl<.d> s25 00001sssssssss10SSSSSSSSSSNRtttt.  */
{ "bl", 0x08020000, 0xF8030000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRANCH, NONE, { SIMM25_A32_5 }, { C_D }},

/* bl<.cc><.d> s21 00001sssssssss00SSSSSSSSSSNQQQQQ.  */
{ "bl", 0x08000000, 0xF8030000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRANCH, NONE, { SIMM21_A32_5 }, { C_CC, C_D }},

/* ble_sCC_LE s7 1111011011ssssss.  */
{ "ble_s", 0x0000F6C0, 0x0000FFC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRANCH, COND, { SIMM7_A16_10_S }, { C_CC_LE }},

/* blo_sCC_LO s7 1111011110ssssss.  */
{ "blo_s", 0x0000F780, 0x0000FFC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRANCH, COND, { SIMM7_A16_10_S }, { C_CC_LO }},

/* bls_sCC_LS s7 1111011111ssssss.  */
{ "bls_s", 0x0000F7C0, 0x0000FFC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRANCH, COND, { SIMM7_A16_10_S }, { C_CC_LS }},

/* blt_sCC_LT s7 1111011010ssssss.  */
{ "blt_s", 0x0000F680, 0x0000FFC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRANCH, COND, { SIMM7_A16_10_S }, { C_CC_LT }},

/* bl_s s13 11111sssssssssss.  */
{ "bl_s", 0x0000F800, 0x0000F800, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRANCH, NONE, { SIMM13_A32_5_S }, { 0 }},

/* bmsk<.f> a,b,c 00100bbb00010011FBBBCCCCCCAAAAAA.  */
{ "bmsk", 0x20130000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* bmsk<.f> 0,b,c 00100bbb00010011FBBBCCCCCC111110.  */
{ "bmsk", 0x2013003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* bmsk<.f><.cc> b,b,c 00100bbb11010011FBBBCCCCCC0QQQQQ.  */
{ "bmsk", 0x20D30000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* bmsk<.f> a,b,u6 00100bbb01010011FBBBuuuuuuAAAAAA.  */
{ "bmsk", 0x20530000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* bmsk<.f> 0,b,u6 00100bbb01010011FBBBuuuuuu111110.  */
{ "bmsk", 0x2053003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* bmsk<.f><.cc> b,b,u6 00100bbb11010011FBBBuuuuuu1QQQQQ.  */
{ "bmsk", 0x20D30020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* bmsk<.f> b,b,s12 00100bbb10010011FBBBssssssSSSSSS.  */
{ "bmsk", 0x20930000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* bmsk<.f> a,limm,c 0010011000010011F111CCCCCCAAAAAA.  */
{ "bmsk", 0x26137000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* bmsk<.f> a,b,limm 00100bbb00010011FBBB111110AAAAAA.  */
{ "bmsk", 0x20130F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* bmsk<.f> 0,limm,c 0010011000010011F111CCCCCC111110.  */
{ "bmsk", 0x2613703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* bmsk<.f> 0,b,limm 00100bbb00010011FBBB111110111110.  */
{ "bmsk", 0x20130FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* bmsk<.f><.cc> b,b,limm 00100bbb11010011FBBB1111100QQQQQ.  */
{ "bmsk", 0x20D30F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* bmsk<.f><.cc> 0,limm,c 0010011011010011F111CCCCCC0QQQQQ.  */
{ "bmsk", 0x26D37000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* bmsk<.f> a,limm,u6 0010011001010011F111uuuuuuAAAAAA.  */
{ "bmsk", 0x26537000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* bmsk<.f> 0,limm,u6 0010011001010011F111uuuuuu111110.  */
{ "bmsk", 0x2653703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* bmsk<.f><.cc> 0,limm,u6 0010011011010011F111uuuuuu1QQQQQ.  */
{ "bmsk", 0x26D37020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* bmsk<.f> 0,limm,s12 0010011010010011F111ssssssSSSSSS.  */
{ "bmsk", 0x26937000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* bmsk<.f> a,limm,limm 0010011000010011F111111110AAAAAA.  */
{ "bmsk", 0x26137F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* bmsk<.f> 0,limm,limm 0010011000010011F111111110111110.  */
{ "bmsk", 0x26137FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* bmsk<.f><.cc> 0,limm,limm 0010011011010011F1111111100QQQQQ.  */
{ "bmsk", 0x26D37F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* bmskn<.f> a,b,c 00100bbb00101100FBBBCCCCCCAAAAAA.  */
{ "bmskn", 0x202C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* bmskn<.f> 0,b,c 00100bbb00101100FBBBCCCCCC111110.  */
{ "bmskn", 0x202C003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* bmskn<.f><.cc> b,b,c 00100bbb11101100FBBBCCCCCC0QQQQQ.  */
{ "bmskn", 0x20EC0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* bmskn<.f> a,b,u6 00100bbb01101100FBBBuuuuuuAAAAAA.  */
{ "bmskn", 0x206C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* bmskn<.f> 0,b,u6 00100bbb01101100FBBBuuuuuu111110.  */
{ "bmskn", 0x206C003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* bmskn<.f><.cc> b,b,u6 00100bbb11101100FBBBuuuuuu1QQQQQ.  */
{ "bmskn", 0x20EC0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* bmskn<.f> b,b,s12 00100bbb10101100FBBBssssssSSSSSS.  */
{ "bmskn", 0x20AC0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* bmskn<.f> a,limm,c 0010011000101100F111CCCCCCAAAAAA.  */
{ "bmskn", 0x262C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* bmskn<.f> a,b,limm 00100bbb00101100FBBB111110AAAAAA.  */
{ "bmskn", 0x202C0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* bmskn<.f> 0,limm,c 0010011000101100F111CCCCCC111110.  */
{ "bmskn", 0x262C703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* bmskn<.f> 0,b,limm 00100bbb00101100FBBB111110111110.  */
{ "bmskn", 0x202C0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* bmskn<.f><.cc> b,b,limm 00100bbb11101100FBBB1111100QQQQQ.  */
{ "bmskn", 0x20EC0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* bmskn<.f><.cc> 0,limm,c 0010011011101100F111CCCCCC0QQQQQ.  */
{ "bmskn", 0x26EC7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* bmskn<.f> a,limm,u6 0010011001101100F111uuuuuuAAAAAA.  */
{ "bmskn", 0x266C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* bmskn<.f> 0,limm,u6 0010011001101100F111uuuuuu111110.  */
{ "bmskn", 0x266C703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* bmskn<.f><.cc> 0,limm,u6 0010011011101100F111uuuuuu1QQQQQ.  */
{ "bmskn", 0x26EC7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* bmskn<.f> 0,limm,s12 0010011010101100F111ssssssSSSSSS.  */
{ "bmskn", 0x26AC7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* bmskn<.f> a,limm,limm 0010011000101100F111111110AAAAAA.  */
{ "bmskn", 0x262C7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* bmskn<.f> 0,limm,limm 0010011000101100F111111110111110.  */
{ "bmskn", 0x262C7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* bmskn<.f><.cc> 0,limm,limm 0010011011101100F1111111100QQQQQ.  */
{ "bmskn", 0x26EC7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* bmsk_s b,b,u5 10111bbb110uuuuu.  */
{ "bmsk_s", 0x0000B8C0, 0x0000F8E0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB_S, RB_Sdup, UIMM5_11_S }, { 0 }},

/* bne_sCC_NE s10 1111010sssssssss.  */
{ "bne_s", 0x0000F400, 0x0000FE00, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRANCH, COND, { SIMM10_A16_7_S }, { C_CC_NE }},

/* breq<.d>CC_EQ b,c,s9 00001bbbsssssss1SBBBCCCCCCN00000.  */
{ "breq", 0x08010000, 0xF801001F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { RB, RC, SIMM9_A16_8 }, { C_D, C_CC_EQ }},

/* breq<.d><.T> b,c,s9 00001bbbsssssss1SBBBCCCCCCN0Y000.  */
{ "breq", 0x08010000, 0xF8010017, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { RB, RC, SIMM9_A16_8 }, { C_D, C_T, C_CC_EQ }},

/* breq<.d>CC_EQ b,u6,s9 00001bbbsssssss1SBBBuuuuuuN10000.  */
{ "breq", 0x08010010, 0xF801001F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D, C_CC_EQ }},

/* breq<.d><.T> b,u6,s9 00001bbbsssssss1SBBBuuuuuuN1Y000.  */
{ "breq", 0x08010010, 0xF8010017, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D, C_T, C_CC_EQ }},

/* breqCC_EQ b,limm,s9 00001bbbsssssss1SBBB111110000000.  */
{ "breq", 0x08010F80, 0xF8010FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { RB, LIMM, SIMM9_A16_8 }, { C_CC_EQ }},

/* breqCC_EQ limm,c,s9 00001110sssssss1S111CCCCCC000000.  */
{ "breq", 0x0E017000, 0xFF01703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { LIMM, RC, SIMM9_A16_8 }, { C_CC_EQ }},

/* breq<.T>CC_EQ b,limm,s9 00001bbbsssssss1SBBB11111000Y000.  */
{ "breq", 0x08010F80, 0xF8010FF7, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { RB, LIMM, SIMM9_A16_8 }, { C_T, C_CC_EQ }},

/* breq<.T>CC_EQ limm,c,s9 00001110sssssss1S111CCCCCC00Y000.  */
{ "breq", 0x0E017000, 0xFF017037, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { LIMM, RC, SIMM9_A16_8 }, { C_T, C_CC_EQ }},

/* breqCC_EQ limm,u6,s9 00001110sssssss1S111uuuuuu010000.  */
{ "breq", 0x0E017010, 0xFF01703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { LIMM, UIMM6_8, SIMM9_A16_8 }, { C_CC_EQ }},

/* breq<.T>CC_EQ limm,u6,s9 00001110sssssss1S111uuuuuu01Y000.  */
{ "breq", 0x0E017010, 0xFF017037, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { LIMM, UIMM6_8, SIMM9_A16_8 }, { C_T, C_CC_EQ }},

/* breq<.T>CC_EQ limm,limm,s9 00001110sssssss1S11111111000Y000.  */
{ "breq", 0x0E017F80, 0xFF017FF7, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { LIMM, LIMMdup, SIMM9_A16_8 }, { C_T, C_CC_EQ }},

/* breq_sCC_EQ b,0,s8 11101bbb0sssssss.  */
{ "breq_s", 0x0000E800, 0x0000F880, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { RB_S, ZB_S, SIMM8_A16_9_S }, { C_CC_EQ }},

/* brge<.d>CC_GE b,c,s9 00001bbbsssssss1SBBBCCCCCCN00011.  */
{ "brge", 0x08010003, 0xF801001F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { RB, RC, SIMM9_A16_8 }, { C_D, C_CC_GE }},

/* brge<.d><.T> b,c,s9 00001bbbsssssss1SBBBCCCCCCN0Y011.  */
{ "brge", 0x08010003, 0xF8010017, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { RB, RC, SIMM9_A16_8 }, { C_D, C_T, C_CC_GE }},

/* brge<.d>CC_GE b,u6,s9 00001bbbsssssss1SBBBuuuuuuN10011.  */
{ "brge", 0x08010013, 0xF801001F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D, C_CC_GE }},

/* brge<.d><.T> b,u6,s9 00001bbbsssssss1SBBBuuuuuuN1Y011.  */
{ "brge", 0x08010013, 0xF8010017, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D, C_T, C_CC_GE }},

/* brgeCC_GE b,limm,s9 00001bbbsssssss1SBBB111110000011.  */
{ "brge", 0x08010F83, 0xF8010FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { RB, LIMM, SIMM9_A16_8 }, { C_CC_GE }},

/* brgeCC_GE limm,c,s9 00001110sssssss1S111CCCCCC000011.  */
{ "brge", 0x0E017003, 0xFF01703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { LIMM, RC, SIMM9_A16_8 }, { C_CC_GE }},

/* brge<.T>CC_GE b,limm,s9 00001bbbsssssss1SBBB11111000Y011.  */
{ "brge", 0x08010F83, 0xF8010FF7, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { RB, LIMM, SIMM9_A16_8 }, { C_T, C_CC_GE }},

/* brge<.T>CC_GE limm,c,s9 00001110sssssss1S111CCCCCC00Y011.  */
{ "brge", 0x0E017003, 0xFF017037, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { LIMM, RC, SIMM9_A16_8 }, { C_T, C_CC_GE }},

/* brgeCC_GE limm,u6,s9 00001110sssssss1S111uuuuuu010011.  */
{ "brge", 0x0E017013, 0xFF01703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { LIMM, UIMM6_8, SIMM9_A16_8 }, { C_CC_GE }},

/* brge<.T>CC_GE limm,u6,s9 00001110sssssss1S111uuuuuu01Y011.  */
{ "brge", 0x0E017013, 0xFF017037, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { LIMM, UIMM6_8, SIMM9_A16_8 }, { C_T, C_CC_GE }},

/* brge<.T>CC_GE limm,limm,s9 00001110sssssss1S11111111000Y011.  */
{ "brge", 0x0E017F83, 0xFF017FF7, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { LIMM, LIMMdup, SIMM9_A16_8 }, { C_T, C_CC_GE }},

/* brhs<.d>CC_HS b,c,s9 00001bbbsssssss1SBBBCCCCCCN00101.  */
{ "brhs", 0x08010005, 0xF801001F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { RB, RC, SIMM9_A16_8 }, { C_D, C_CC_HS }},

/* brhs<.d><.T> b,c,s9 00001bbbsssssss1SBBBCCCCCCN0Y101.  */
{ "brhs", 0x08010005, 0xF8010017, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { RB, RC, SIMM9_A16_8 }, { C_D, C_T, C_CC_HS }},

/* brhs<.d>CC_HS b,u6,s9 00001bbbsssssss1SBBBuuuuuuN10101.  */
{ "brhs", 0x08010015, 0xF801001F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D, C_CC_HS }},

/* brhs<.d><.T> b,u6,s9 00001bbbsssssss1SBBBuuuuuuN1Y101.  */
{ "brhs", 0x08010015, 0xF8010017, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D, C_T, C_CC_HS }},

/* brhsCC_HS b,limm,s9 00001bbbsssssss1SBBB111110000101.  */
{ "brhs", 0x08010F85, 0xF8010FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { RB, LIMM, SIMM9_A16_8 }, { C_CC_HS }},

/* brhsCC_HS limm,c,s9 00001110sssssss1S111CCCCCC000101.  */
{ "brhs", 0x0E017005, 0xFF01703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { LIMM, RC, SIMM9_A16_8 }, { C_CC_HS }},

/* brhs<.T>CC_HS b,limm,s9 00001bbbsssssss1SBBB11111000Y101.  */
{ "brhs", 0x08010F85, 0xF8010FF7, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { RB, LIMM, SIMM9_A16_8 }, { C_T, C_CC_HS }},

/* brhs<.T>CC_HS limm,c,s9 00001110sssssss1S111CCCCCC00Y101.  */
{ "brhs", 0x0E017005, 0xFF017037, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { LIMM, RC, SIMM9_A16_8 }, { C_T, C_CC_HS }},

/* brhsCC_HS limm,u6,s9 00001110sssssss1S111uuuuuu010101.  */
{ "brhs", 0x0E017015, 0xFF01703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { LIMM, UIMM6_8, SIMM9_A16_8 }, { C_CC_HS }},

/* brhs<.T>CC_HS limm,u6,s9 00001110sssssss1S111uuuuuu01Y101.  */
{ "brhs", 0x0E017015, 0xFF017037, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { LIMM, UIMM6_8, SIMM9_A16_8 }, { C_T, C_CC_HS }},

/* brhs<.T>CC_HS limm,limm,s9 00001110sssssss1S11111111000Y101.  */
{ "brhs", 0x0E017F85, 0xFF017FF7, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { LIMM, LIMMdup, SIMM9_A16_8 }, { C_T, C_CC_HS }},

/* brk  00100101011011110000000000111111.  */
{ "brk", 0x256F003F, 0xFFFFFFFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, KERNEL, NONE, { 0 }, { 0 }},

/* brk_s  0111111111111111.  */
{ "brk_s", 0x00007FFF, 0x0000FFFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, KERNEL, NONE, { 0 }, { 0 }},

/* brlo<.d>CC_LO b,c,s9 00001bbbsssssss1SBBBCCCCCCN00100.  */
{ "brlo", 0x08010004, 0xF801001F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { RB, RC, SIMM9_A16_8 }, { C_D, C_CC_LO }},

/* brlo<.d><.T> b,c,s9 00001bbbsssssss1SBBBCCCCCCN0Y100.  */
{ "brlo", 0x08010004, 0xF8010017, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { RB, RC, SIMM9_A16_8 }, { C_D, C_T, C_CC_LO }},

/* brlo<.d>CC_LO b,u6,s9 00001bbbsssssss1SBBBuuuuuuN10100.  */
{ "brlo", 0x08010014, 0xF801001F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D, C_CC_LO }},

/* brlo<.d><.T> b,u6,s9 00001bbbsssssss1SBBBuuuuuuN1Y100.  */
{ "brlo", 0x08010014, 0xF8010017, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D, C_T, C_CC_LO }},

/* brloCC_LO b,limm,s9 00001bbbsssssss1SBBB111110000100.  */
{ "brlo", 0x08010F84, 0xF8010FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { RB, LIMM, SIMM9_A16_8 }, { C_CC_LO }},

/* brloCC_LO limm,c,s9 00001110sssssss1S111CCCCCC000100.  */
{ "brlo", 0x0E017004, 0xFF01703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { LIMM, RC, SIMM9_A16_8 }, { C_CC_LO }},

/* brlo<.T>CC_LO b,limm,s9 00001bbbsssssss1SBBB11111000Y100.  */
{ "brlo", 0x08010F84, 0xF8010FF7, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { RB, LIMM, SIMM9_A16_8 }, { C_T, C_CC_LO }},

/* brlo<.T>CC_LO limm,c,s9 00001110sssssss1S111CCCCCC00Y100.  */
{ "brlo", 0x0E017004, 0xFF017037, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { LIMM, RC, SIMM9_A16_8 }, { C_T, C_CC_LO }},

/* brloCC_LO limm,u6,s9 00001110sssssss1S111uuuuuu010100.  */
{ "brlo", 0x0E017014, 0xFF01703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { LIMM, UIMM6_8, SIMM9_A16_8 }, { C_CC_LO }},

/* brlo<.T>CC_LO limm,u6,s9 00001110sssssss1S111uuuuuu01Y100.  */
{ "brlo", 0x0E017014, 0xFF017037, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { LIMM, UIMM6_8, SIMM9_A16_8 }, { C_T, C_CC_LO }},

/* brlo<.T>CC_LO limm,limm,s9 00001110sssssss1S11111111000Y100.  */
{ "brlo", 0x0E017F84, 0xFF017FF7, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { LIMM, LIMMdup, SIMM9_A16_8 }, { C_T, C_CC_LO }},

/* brlt<.d>CC_LT b,c,s9 00001bbbsssssss1SBBBCCCCCCN00010.  */
{ "brlt", 0x08010002, 0xF801001F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { RB, RC, SIMM9_A16_8 }, { C_D, C_CC_LT }},

/* brlt<.d><.T> b,c,s9 00001bbbsssssss1SBBBCCCCCCN0Y010.  */
{ "brlt", 0x08010002, 0xF8010017, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { RB, RC, SIMM9_A16_8 }, { C_D, C_T, C_CC_LT }},

/* brlt<.d>CC_LT b,u6,s9 00001bbbsssssss1SBBBuuuuuuN10010.  */
{ "brlt", 0x08010012, 0xF801001F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D, C_CC_LT }},

/* brlt<.d><.T> b,u6,s9 00001bbbsssssss1SBBBuuuuuuN1Y010.  */
{ "brlt", 0x08010012, 0xF8010017, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D, C_T, C_CC_LT }},

/* brltCC_LT b,limm,s9 00001bbbsssssss1SBBB111110000010.  */
{ "brlt", 0x08010F82, 0xF8010FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { RB, LIMM, SIMM9_A16_8 }, { C_CC_LT }},

/* brltCC_LT limm,c,s9 00001110sssssss1S111CCCCCC000010.  */
{ "brlt", 0x0E017002, 0xFF01703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { LIMM, RC, SIMM9_A16_8 }, { C_CC_LT }},

/* brlt<.T>CC_LT b,limm,s9 00001bbbsssssss1SBBB11111000Y010.  */
{ "brlt", 0x08010F82, 0xF8010FF7, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { RB, LIMM, SIMM9_A16_8 }, { C_T, C_CC_LT }},

/* brlt<.T>CC_LT limm,c,s9 00001110sssssss1S111CCCCCC00Y010.  */
{ "brlt", 0x0E017002, 0xFF017037, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { LIMM, RC, SIMM9_A16_8 }, { C_T, C_CC_LT }},

/* brltCC_LT limm,u6,s9 00001110sssssss1S111uuuuuu010010.  */
{ "brlt", 0x0E017012, 0xFF01703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { LIMM, UIMM6_8, SIMM9_A16_8 }, { C_CC_LT }},

/* brlt<.T>CC_LT limm,u6,s9 00001110sssssss1S111uuuuuu01Y010.  */
{ "brlt", 0x0E017012, 0xFF017037, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { LIMM, UIMM6_8, SIMM9_A16_8 }, { C_T, C_CC_LT }},

/* brlt<.T>CC_LT limm,limm,s9 00001110sssssss1S11111111000Y010.  */
{ "brlt", 0x0E017F82, 0xFF017FF7, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { LIMM, LIMMdup, SIMM9_A16_8 }, { C_T, C_CC_LT }},

/* brne<.d>CC_NE b,c,s9 00001bbbsssssss1SBBBCCCCCCN00001.  */
{ "brne", 0x08010001, 0xF801001F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { RB, RC, SIMM9_A16_8 }, { C_D, C_CC_NE }},

/* brne<.d><.T> b,c,s9 00001bbbsssssss1SBBBCCCCCCN0Y001.  */
{ "brne", 0x08010001, 0xF8010017, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { RB, RC, SIMM9_A16_8 }, { C_D, C_T, C_CC_NE }},

/* brne<.d>CC_NE b,u6,s9 00001bbbsssssss1SBBBUUUUUUN10001.  */
{ "brne", 0x08010011, 0xF801001F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D, C_CC_NE }},

/* brne<.d><.T> b,u6,s9 00001bbbsssssss1SBBBuuuuuuN1Y001.  */
{ "brne", 0x08010011, 0xF8010017, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D, C_T, C_CC_NE }},

/* brneCC_NE b,limm,s9 00001bbbsssssss1SBBB111110000001.  */
{ "brne", 0x08010F81, 0xF8010FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { RB, LIMM, SIMM9_A16_8 }, { C_CC_NE }},

/* brneCC_NE limm,c,s9 00001110sssssss1S111CCCCCC000001.  */
{ "brne", 0x0E017001, 0xFF01703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { LIMM, RC, SIMM9_A16_8 }, { C_CC_NE }},

/* brne<.T>CC_NE b,limm,s9 00001bbbsssssss1SBBB11111000Y001.  */
{ "brne", 0x08010F81, 0xF8010FF7, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { RB, LIMM, SIMM9_A16_8 }, { C_T, C_CC_NE }},

/* brne<.T>CC_NE limm,c,s9 00001110sssssss1S111CCCCCC00Y001.  */
{ "brne", 0x0E017001, 0xFF017037, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { LIMM, RC, SIMM9_A16_8 }, { C_T, C_CC_NE }},

/* brneCC_NE limm,u6,s9 00001110sssssss1S111uuuuuu010001.  */
{ "brne", 0x0E017011, 0xFF01703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, BRCC, COND, { LIMM, UIMM6_8, SIMM9_A16_8 }, { C_CC_NE }},

/* brne<.T>CC_NE limm,u6,s9 00001110sssssss1S111uuuuuu01Y001.  */
{ "brne", 0x0E017011, 0xFF017037, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { LIMM, UIMM6_8, SIMM9_A16_8 }, { C_T, C_CC_NE }},

/* brne<.T>CC_NE limm,limm,s9 00001110sssssss1S11111111000Y001.  */
{ "brne", 0x0E017F81, 0xFF017FF7, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { LIMM, LIMMdup, SIMM9_A16_8 }, { C_T, C_CC_NE }},

/* brne_sCC_NE b,0,s8 11101bbb1sssssss.  */
{ "brne_s", 0x0000E880, 0x0000F880, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRCC, COND, { RB_S, ZB_S, SIMM8_A16_9_S }, { C_CC_NE }},

/* bset<.f> a,b,c 00100bbb00001111FBBBCCCCCCAAAAAA.  */
{ "bset", 0x200F0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* bset<.f> 0,b,c 00100bbb00001111FBBBCCCCCC111110.  */
{ "bset", 0x200F003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* bset<.f><.cc> b,b,c 00100bbb11001111FBBBCCCCCC0QQQQQ.  */
{ "bset", 0x20CF0000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* bset<.f> a,b,u6 00100bbb01001111FBBBuuuuuuAAAAAA.  */
{ "bset", 0x204F0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* bset<.f> 0,b,u6 00100bbb01001111FBBBuuuuuu111110.  */
{ "bset", 0x204F003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* bset<.f><.cc> b,b,u6 00100bbb11001111FBBBuuuuuu1QQQQQ.  */
{ "bset", 0x20CF0020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* bset<.f> b,b,s12 00100bbb10001111FBBBssssssSSSSSS.  */
{ "bset", 0x208F0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* bset<.f> a,limm,c 0010011000001111F111CCCCCCAAAAAA.  */
{ "bset", 0x260F7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* bset<.f> a,b,limm 00100bbb00001111FBBB111110AAAAAA.  */
{ "bset", 0x200F0F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* bset<.f> 0,limm,c 0010011000001111F111CCCCCC111110.  */
{ "bset", 0x260F703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* bset<.f> 0,b,limm 00100bbb00001111FBBB111110111110.  */
{ "bset", 0x200F0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* bset<.f><.cc> b,b,limm 00100bbb11001111FBBB1111100QQQQQ.  */
{ "bset", 0x20CF0F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* bset<.f><.cc> 0,limm,c 0010011011001111F111CCCCCC0QQQQQ.  */
{ "bset", 0x26CF7000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* bset<.f> a,limm,u6 0010011001001111F111uuuuuuAAAAAA.  */
{ "bset", 0x264F7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* bset<.f> 0,limm,u6 0010011001001111F111uuuuuu111110.  */
{ "bset", 0x264F703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* bset<.f><.cc> 0,limm,u6 0010011011001111F111uuuuuu1QQQQQ.  */
{ "bset", 0x26CF7020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* bset<.f> 0,limm,s12 0010011010001111F111ssssssSSSSSS.  */
{ "bset", 0x268F7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* bset<.f> a,limm,limm 0010011000001111F111111110AAAAAA.  */
{ "bset", 0x260F7F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* bset<.f> 0,limm,limm 0010011000001111F111111110111110.  */
{ "bset", 0x260F7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* bset<.f><.cc> 0,limm,limm 0010011011001111F1111111100QQQQQ.  */
{ "bset", 0x26CF7F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* bset_s b,b,u5 10111bbb100uuuuu.  */
{ "bset_s", 0x0000B880, 0x0000F8E0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB_S, RB_Sdup, UIMM5_11_S }, { 0 }},

/* bspeek<.f> b,c 00101bbb00101111FBBBCCCCCC101110.  */
{ "bspeek", 0x282F002E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { RB, RC }, { C_F }},

/* bspeek<.f> 0,c 0010111000101111F111CCCCCC101110.  */
{ "bspeek", 0x2E2F702E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { ZA, RC }, { C_F }},

/* bspeek<.f> b,u6 00101bbb01101111FBBBuuuuuu101110.  */
{ "bspeek", 0x286F002E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { RB, UIMM6_20 }, { C_F }},

/* bspeek<.f> 0,u6 0010111001101111F111uuuuuu101110.  */
{ "bspeek", 0x2E6F702E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { ZA, UIMM6_20 }, { C_F }},

/* bspeek<.f> b,limm 00101bbb00101111FBBB111110101110.  */
{ "bspeek", 0x282F0FAE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { RB, LIMM }, { C_F }},

/* bspeek<.f> 0,limm 0010111000101111F111111110101110.  */
{ "bspeek", 0x2E2F7FAE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { ZA, LIMM }, { C_F }},

/* bspop<.f> b,c 00101bbb00101111FBBBCCCCCC101111.  */
{ "bspop", 0x282F002F, 0xF8FF003F, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { RB, RC }, { C_F }},

/* bspop<.f> 0,c 0010111000101111F111CCCCCC101111.  */
{ "bspop", 0x2E2F702F, 0xFFFF703F, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { ZA, RC }, { C_F }},

/* bspop<.f> b,u6 00101bbb01101111FBBBuuuuuu101111.  */
{ "bspop", 0x286F002F, 0xF8FF003F, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { RB, UIMM6_20 }, { C_F }},

/* bspop<.f> 0,u6 0010111001101111F111uuuuuu101111.  */
{ "bspop", 0x2E6F702F, 0xFFFF703F, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { ZA, UIMM6_20 }, { C_F }},

/* bspop<.f> b,limm 00101bbb00101111FBBB111110101111.  */
{ "bspop", 0x282F0FAF, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { RB, LIMM }, { C_F }},

/* bspop<.f> 0,limm 0010111000101111F111111110101111.  */
{ "bspop", 0x2E2F7FAF, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { ZA, LIMM }, { C_F }},

/* bspush a,b,c 00101bbb001011101BBBCCCCCCAAAAAA.  */
{ "bspush", 0x282E8000, 0xF8FF8000, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { RA, RB, RC }, { 0 }},

/* bspush 0,b,c 00101bbb001011101BBBCCCCCC111110.  */
{ "bspush", 0x282E803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { ZA, RB, RC }, { 0 }},

/* bspush<.cc> b,b,c 00101bbb111011101BBBCCCCCC0QQQQQ.  */
{ "bspush", 0x28EE8000, 0xF8FF8020, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { RB, RBdup, RC }, { C_CC }},

/* bspush a,b,u6 00101bbb011011101BBBuuuuuuAAAAAA.  */
{ "bspush", 0x286E8000, 0xF8FF8000, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { RA, RB, UIMM6_20 }, { 0 }},

/* bspush 0,b,u6 00101bbb011011101BBBuuuuuu111110.  */
{ "bspush", 0x286E803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { ZA, RB, UIMM6_20 }, { 0 }},

/* bspush<.cc> b,b,u6 00101bbb111011101BBBuuuuuu1QQQQQ.  */
{ "bspush", 0x28EE8020, 0xF8FF8020, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { RB, RBdup, UIMM6_20 }, { C_CC }},

/* bspush b,b,s12 00101bbb101011101BBBssssssSSSSSS.  */
{ "bspush", 0x28AE8000, 0xF8FF8000, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { RB, RBdup, SIMM12_20 }, { 0 }},

/* bspush a,limm,c 00101110001011101111CCCCCCAAAAAA.  */
{ "bspush", 0x2E2EF000, 0xFFFFF000, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { RA, LIMM, RC }, { 0 }},

/* bspush a,b,limm 00101bbb001011101BBB111110AAAAAA.  */
{ "bspush", 0x282E8F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { RA, RB, LIMM }, { 0 }},

/* bspush 0,limm,c 00101110011011101111CCCCCC111110.  */
{ "bspush", 0x2E6EF03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { ZA, LIMM, RC }, { 0 }},

/* bspush 0,b,limm 00101bbb001011101BBB111110111110.  */
{ "bspush", 0x282E8FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { ZA, RB, LIMM }, { 0 }},

/* bspush<.cc> b,b,limm 00101bbb111011101BBB1111100QQQQQ.  */
{ "bspush", 0x28EE8F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { RB, RBdup, LIMM }, { C_CC }},

/* bspush<.cc> 0,limm,c 00101110111011101111CCCCCC0QQQQQ.  */
{ "bspush", 0x2EEEF000, 0xFFFFF020, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { ZA, LIMM, RC }, { C_CC }},

/* bspush a,limm,u6 00101110011011101111uuuuuuAAAAAA.  */
{ "bspush", 0x2E6EF000, 0xFFFFF000, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { RA, LIMM, UIMM6_20 }, { 0 }},

/* bspush 0,limm,u6 00101110011011101111uuuuuu111110.  */
{ "bspush", 0x2E6EF03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* bspush<.cc> 0,limm,u6 00101110111011101111uuuuuu1QQQQQ.  */
{ "bspush", 0x2EEEF020, 0xFFFFF020, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* bspush 0,limm,s12 00101110101011101111ssssssSSSSSS.  */
{ "bspush", 0x2EAEF000, 0xFFFFF000, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* bspush a,limm,limm 00101110001011101111111110AAAAAA.  */
{ "bspush", 0x2E2EFF80, 0xFFFFFFC0, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { RA, LIMM, LIMMdup }, { 0 }},

/* bspush 0,limm,limm 00101110001011101111111110111110.  */
{ "bspush", 0x2E2EFFBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { ZA, LIMM, LIMMdup }, { 0 }},

/* bspush<.cc> 0,limm,limm 001011101110111011111111100QQQQQ.  */
{ "bspush", 0x2EEEFF80, 0xFFFFFFE0, ARC_OPCODE_ARCv2EM, BITSTREAM, NONE, { ZA, LIMM, LIMMdup }, { C_CC }},

/* btst b,c 00100bbb000100011BBBCCCCCCRRRRRR.  */
{ "btst", 0x20118000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RC }, { 0 }},

/* btst b,c 00100bbb000100011BBBCCCCCC000000.  */
{ "btst", 0x20118000, 0xF8FF803F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, LOGICAL, NONE, { RB, RC }, { 0 }},

/* btst<.cc> b,c 00100bbb110100011BBBCCCCCC0QQQQQ.  */
{ "btst", 0x20D18000, 0xF8FF8020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RC }, { C_CC }},

/* btst b,u6 00100bbb010100011BBBuuuuuuRRRRRR.  */
{ "btst", 0x20518000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, UIMM6_20 }, { 0 }},

/* btst b,u6 00100bbb010100011BBBuuuuuu000000.  */
{ "btst", 0x20518000, 0xF8FF803F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, LOGICAL, NONE, { RB, UIMM6_20 }, { 0 }},

/* btst<.cc> b,u6 00100bbb110100011BBBuuuuuu1QQQQQ.  */
{ "btst", 0x20D18020, 0xF8FF8020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, UIMM6_20 }, { C_CC }},

/* btst b,s12 00100bbb100100011BBBssssssSSSSSS.  */
{ "btst", 0x20918000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, SIMM12_20 }, { 0 }},

/* btst limm,c 00100110000100011111CCCCCCRRRRRR.  */
{ "btst", 0x2611F000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { LIMM, RC }, { 0 }},

/* btst b,limm 00100bbb000100011BBB111110RRRRRR.  */
{ "btst", 0x20118F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, LIMM }, { 0 }},

/* btst limm,c 00100110000100011111CCCCCC000000.  */
{ "btst", 0x2611F000, 0xFFFFF03F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, LOGICAL, NONE, { LIMM, RC }, { 0 }},

/* btst b,limm 00100bbb000100011BBB111110000000.  */
{ "btst", 0x20118F80, 0xF8FF8FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, LOGICAL, NONE, { RB, LIMM }, { 0 }},

/* btst<.cc> b,limm 00100bbb110100011BBB1111100QQQQQ.  */
{ "btst", 0x20D18F80, 0xF8FF8FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, LIMM }, { C_CC }},

/* btst<.cc> limm,c 00100110110100011111CCCCCC0QQQQQ.  */
{ "btst", 0x26D1F000, 0xFFFFF020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { LIMM, RC }, { C_CC }},

/* btst limm,u6 00100110010100011111uuuuuuRRRRRR.  */
{ "btst", 0x2651F000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { LIMM, UIMM6_20 }, { 0 }},

/* btst limm,u6 00100110010100011111uuuuuu000000.  */
{ "btst", 0x2651F000, 0xFFFFF03F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, LOGICAL, NONE, { LIMM, UIMM6_20 }, { 0 }},

/* btst<.cc> limm,u6 00100110110100011111uuuuuu1QQQQQ.  */
{ "btst", 0x26D1F020, 0xFFFFF020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { LIMM, UIMM6_20 }, { C_CC }},

/* btst limm,s12 00100110100100011111ssssssSSSSSS.  */
{ "btst", 0x2691F000, 0xFFFFF000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { LIMM, SIMM12_20 }, { 0 }},

/* btst limm,limm 00100110000100011111111110RRRRRR.  */
{ "btst", 0x2611FF80, 0xFFFFFFC0, ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { LIMM, LIMMdup }, { 0 }},

/* btst limm,limm 00100110000100011111111110000000.  */
{ "btst", 0x2611FF80, 0xFFFFFFFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, LOGICAL, NONE, { LIMM, LIMMdup }, { 0 }},

/* btst<.cc> limm,limm 001001101101000111111111100QQQQQ.  */
{ "btst", 0x26D1FF80, 0xFFFFFFE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { LIMM, LIMMdup }, { C_CC }},

/* btst_s b,u5 10111bbb111uuuuu.  */
{ "btst_s", 0x0000B8E0, 0x0000F8E0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB_S, UIMM5_11_S }, { 0 }},

/* bxor<.f> a,b,c 00100bbb00010010FBBBCCCCCCAAAAAA.  */
{ "bxor", 0x20120000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* bxor<.f> 0,b,c 00100bbb00010010FBBBCCCCCC111110.  */
{ "bxor", 0x2012003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* bxor<.f><.cc> b,b,c 00100bbb11010010FBBBCCCCCC0QQQQQ.  */
{ "bxor", 0x20D20000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* bxor<.f> a,b,u6 00100bbb01010010FBBBuuuuuuAAAAAA.  */
{ "bxor", 0x20520000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* bxor<.f> 0,b,u6 00100bbb01010010FBBBuuuuuu111110.  */
{ "bxor", 0x2052003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* bxor<.f><.cc> b,b,u6 00100bbb11010010FBBBuuuuuu1QQQQQ.  */
{ "bxor", 0x20D20020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* bxor<.f> b,b,s12 00100bbb10010010FBBBssssssSSSSSS.  */
{ "bxor", 0x20920000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* bxor<.f> a,limm,c 0010011000010010F111CCCCCCAAAAAA.  */
{ "bxor", 0x26127000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* bxor<.f> a,b,limm 00100bbb00010010FBBB111110AAAAAA.  */
{ "bxor", 0x20120F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* bxor<.f> 0,limm,c 0010011000010010F111CCCCCC111110.  */
{ "bxor", 0x2612703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* bxor<.f> 0,b,limm 00100bbb00010010FBBB111110111110.  */
{ "bxor", 0x20120FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* bxor<.f><.cc> b,b,limm 00100bbb11010010FBBB1111100QQQQQ.  */
{ "bxor", 0x20D20F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* bxor<.f><.cc> 0,limm,c 0010011011010010F111CCCCCC0QQQQQ.  */
{ "bxor", 0x26D27000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* bxor<.f> a,limm,u6 0010011001010010F111uuuuuuAAAAAA.  */
{ "bxor", 0x26527000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* bxor<.f> 0,limm,u6 0010011001010010F111uuuuuu111110.  */
{ "bxor", 0x2652703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* bxor<.f><.cc> 0,limm,u6 0010011011010010F111uuuuuu1QQQQQ.  */
{ "bxor", 0x26D27020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* bxor<.f> 0,limm,s12 0010011010010010F111ssssssSSSSSS.  */
{ "bxor", 0x26927000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* bxor<.f> a,limm,limm 0010011000010010F111111110AAAAAA.  */
{ "bxor", 0x26127F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* bxor<.f> 0,limm,limm 0010011000010010F111111110111110.  */
{ "bxor", 0x26127FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* bxor<.f><.cc> 0,limm,limm 0010011011010010F1111111100QQQQQ.  */
{ "bxor", 0x26D27F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* b_s s10 1111000sssssssss.  */
{ "b_s", 0x0000F000, 0x0000FE00, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRANCH, NONE, { SIMM10_A16_7_S }, { 0 }},

/* cbflyhf0r a,b,c 00110bbb000110111BBBCCCCCCAAAAAA.  */
{ "cbflyhf0r", 0x301B8000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { 0 }},

/* cbflyhf0r 0,b,c 00110bbb000110111BBBCCCCCC111110.  */
{ "cbflyhf0r", 0x301B803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { 0 }},

/* cbflyhf0r<.cc> b,b,c 00110bbb110110111BBBCCCCCC0QQQQQ.  */
{ "cbflyhf0r", 0x30DB8000, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_CC }},

/* cbflyhf0r a,b,u6 00110bbb010110111BBBuuuuuuAAAAAA.  */
{ "cbflyhf0r", 0x305B8000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* cbflyhf0r 0,b,u6 00110bbb010110111BBBuuuuuu111110.  */
{ "cbflyhf0r", 0x305B803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { 0 }},

/* cbflyhf0r<.cc> b,b,u6 00110bbb110110111BBBuuuuuu1QQQQQ.  */
{ "cbflyhf0r", 0x30DB8020, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* cbflyhf0r b,b,s12 00110bbb100110111BBBssssssSSSSSS.  */
{ "cbflyhf0r", 0x309B8000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* cbflyhf0r a,limm,c 00110110000110111111CCCCCCAAAAAA.  */
{ "cbflyhf0r", 0x361BF000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { 0 }},

/* cbflyhf0r a,b,limm 00110bbb000110111BBB111110AAAAAA.  */
{ "cbflyhf0r", 0x301B8F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { 0 }},

/* cbflyhf0r 0,limm,c 00110110000110111111CCCCCC111110.  */
{ "cbflyhf0r", 0x361BF03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { 0 }},

/* cbflyhf0r 0,b,limm 00110bbb000110111BBB111110111110.  */
{ "cbflyhf0r", 0x301B8FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { 0 }},

/* cbflyhf0r<.cc> b,b,limm 00110bbb110110111BBB1111100QQQQQ.  */
{ "cbflyhf0r", 0x30DB8F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* cbflyhf0r<.cc> 0,limm,c 00110110110110111111CCCCCC0QQQQQ.  */
{ "cbflyhf0r", 0x36DBF000, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_CC }},

/* cbflyhf0r a,limm,u6 00110110010110111111uuuuuuAAAAAA.  */
{ "cbflyhf0r", 0x365BF000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* cbflyhf0r 0,limm,u6 00110110010110111111uuuuuu111110.  */
{ "cbflyhf0r", 0x365BF03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* cbflyhf0r<.cc> 0,limm,u6 00110110110110111111uuuuuu1QQQQQ.  */
{ "cbflyhf0r", 0x36DBF020, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* cbflyhf0r 0,limm,s12 00110110100110111111ssssssSSSSSS.  */
{ "cbflyhf0r", 0x369BF000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* cbflyhf0r a,limm,limm 00110110000110111111111110AAAAAA.  */
{ "cbflyhf0r", 0x361BFF80, 0xFFFFFFC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* cbflyhf0r 0,limm,limm 00110110000110111111111110111110.  */
{ "cbflyhf0r", 0x361BFFBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { 0 }},

/* cbflyhf0r<.cc> 0,limm,limm 001101101101101111111111100QQQQQ.  */
{ "cbflyhf0r", 0x36DBFF80, 0xFFFFFFE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_CC }},

/* cbflyhf1r b,c 00110bbb001011110BBBCCCCCC111001.  */
{ "cbflyhf1r", 0x302F0039, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RC }, { 0 }},

/* cbflyhf1r 0,c 00110110001011110111CCCCCC011001.  */
{ "cbflyhf1r", 0x362F7019, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RC }, { 0 }},

/* cbflyhf1r b,u6 00110bbb011011110BBBuuuuuu011001.  */
{ "cbflyhf1r", 0x306F0019, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, UIMM6_20 }, { 0 }},

/* cbflyhf1r 0,u6 00110110011011110111uuuuuu011001.  */
{ "cbflyhf1r", 0x366F7019, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, UIMM6_20 }, { 0 }},

/* cbflyhf1r b,limm 00110bbb001011110BBB111110011001.  */
{ "cbflyhf1r", 0x302F0F99, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, LIMM }, { 0 }},

/* cbflyhf1r 0,limm 00110110001011110111111110011001.  */
{ "cbflyhf1r", 0x362F7F99, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM }, { 0 }},

/* clamp<.f> a,b,c 00110bbb00101010FBBBCCCCCCAAAAAA.  */
{ "clamp", 0x302A0000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* clamp<.f><.cc> b,b,c 00110bbb11101010FBBBCCCCCC0QQQQQ.  */
{ "clamp", 0x30EA0000, 0xF8FF0020, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* clamp<.f> a,b,u6 00110bbb01101010FBBBuuuuuuAAAAAA.  */
{ "clamp", 0x306A0000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* clamp<.f><.cc> b,b,u6 00110bbb11101010FBBBuuuuuu1QQQQQ.  */
{ "clamp", 0x30EA0020, 0xF8FF0020, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* clamp<.f> b,b,s12 00110bbb10101010FBBBssssssSSSSSS.  */
{ "clamp", 0x30AA0000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* clamp<.f> a,limm,c 0011011000101010F111CCCCCCAAAAAA.  */
{ "clamp", 0x362A7000, 0xFFFF7000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* clamp<.f> a,b,limm 00110bbb00101010FBBB111110AAAAAA.  */
{ "clamp", 0x302A0F80, 0xF8FF0FC0, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* clamp<.f><.cc> b,b,limm 00110bbb11101010FBBB1111100QQQQQ.  */
{ "clamp", 0x30EA0F80, 0xF8FF0FE0, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* clri c 00100111001011110000CCCCCC111111.  */
{ "clri", 0x272F003F, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { RC }, { 0 }},

/* clri u6 00100111011011110000uuuuuu111111.  */
{ "clri", 0x276F003F, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { UIMM6_20 }, { 0 }},

/* clri 00100111011011110000uuuuuu111111.  */
{ "clri", 0x276F003F, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { 0 }, { 0 }},

/* cmacchfr a,b,c 00110bbb000010011BBBCCCCCCAAAAAA.  */
{ "cmacchfr", 0x30098000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { 0 }},

/* cmacchfr 0,b,c 00110bbb000010011BBBCCCCCC111110.  */
{ "cmacchfr", 0x3009803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { 0 }},

/* cmacchfr<.cc> b,b,c 00110bbb110010011BBBCCCCCC0QQQQQ.  */
{ "cmacchfr", 0x30C98000, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_CC }},

/* cmacchfr a,b,u6 00110bbb010010011BBBuuuuuuAAAAAA.  */
{ "cmacchfr", 0x30498000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* cmacchfr 0,b,u6 00110bbb010010011BBBuuuuuu111110.  */
{ "cmacchfr", 0x3049803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { 0 }},

/* cmacchfr<.cc> b,b,u6 00110bbb110010011BBBuuuuuu1QQQQQ.  */
{ "cmacchfr", 0x30C98020, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* cmacchfr b,b,s12 00110bbb100010011BBBssssssSSSSSS.  */
{ "cmacchfr", 0x30898000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* cmacchfr a,limm,c 00110110000010011111CCCCCCAAAAAA.  */
{ "cmacchfr", 0x3609F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { 0 }},

/* cmacchfr a,b,limm 00110bbb000010011BBB111110AAAAAA.  */
{ "cmacchfr", 0x30098F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { 0 }},

/* cmacchfr 0,limm,c 00110110000010011111CCCCCC111110.  */
{ "cmacchfr", 0x3609F03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { 0 }},

/* cmacchfr 0,b,limm 00110bbb000010011BBB111110111110.  */
{ "cmacchfr", 0x30098FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { 0 }},

/* cmacchfr<.cc> b,b,limm 00110bbb110010011BBB1111100QQQQQ.  */
{ "cmacchfr", 0x30C98F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* cmacchfr<.cc> 0,limm,c 00110110110010011111CCCCCC0QQQQQ.  */
{ "cmacchfr", 0x36C9F000, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_CC }},

/* cmacchfr a,limm,u6 00110110010010011111uuuuuuAAAAAA.  */
{ "cmacchfr", 0x3649F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* cmacchfr 0,limm,u6 00110110010010011111uuuuuu111110.  */
{ "cmacchfr", 0x3649F03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* cmacchfr<.cc> 0,limm,u6 00110110110010011111uuuuuu1QQQQQ.  */
{ "cmacchfr", 0x36C9F020, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* cmacchfr 0,limm,s12 00110110100010011111ssssssSSSSSS.  */
{ "cmacchfr", 0x3689F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* cmacchfr a,limm,limm 00110110000010011111111110AAAAAA.  */
{ "cmacchfr", 0x3609FF80, 0xFFFFFFC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* cmacchfr 0,limm,limm 00110110000010011111111110111110.  */
{ "cmacchfr", 0x3609FFBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { 0 }},

/* cmacchfr<.cc> 0,limm,limm 001101101100100111111111100QQQQQ.  */
{ "cmacchfr", 0x36C9FF80, 0xFFFFFFE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_CC }},

/* cmacchnfr a,b,c 00110bbb000010001BBBCCCCCCAAAAAA.  */
{ "cmacchnfr", 0x30088000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { 0 }},

/* cmacchnfr 0,b,c 00110bbb000010001BBBCCCCCC111110.  */
{ "cmacchnfr", 0x3008803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { 0 }},

/* cmacchnfr<.cc> b,b,c 00110bbb110010001BBBCCCCCC0QQQQQ.  */
{ "cmacchnfr", 0x30C88000, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_CC }},

/* cmacchnfr a,b,u6 00110bbb010010001BBBuuuuuuAAAAAA.  */
{ "cmacchnfr", 0x30488000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* cmacchnfr 0,b,u6 00110bbb010010001BBBuuuuuu111110.  */
{ "cmacchnfr", 0x3048803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { 0 }},

/* cmacchnfr<.cc> b,b,u6 00110bbb110010001BBBuuuuuu1QQQQQ.  */
{ "cmacchnfr", 0x30C88020, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* cmacchnfr b,b,s12 00110bbb100010001BBBssssssSSSSSS.  */
{ "cmacchnfr", 0x30888000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* cmacchnfr a,limm,c 00110110000010001111CCCCCCAAAAAA.  */
{ "cmacchnfr", 0x3608F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { 0 }},

/* cmacchnfr a,b,limm 00110bbb000010001BBB111110AAAAAA.  */
{ "cmacchnfr", 0x30088F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { 0 }},

/* cmacchnfr 0,limm,c 00110110000010001111CCCCCC111110.  */
{ "cmacchnfr", 0x3608F03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { 0 }},

/* cmacchnfr 0,b,limm 00110bbb000010001BBB111110111110.  */
{ "cmacchnfr", 0x30088FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { 0 }},

/* cmacchnfr<.cc> b,b,limm 00110bbb110010001BBB1111100QQQQQ.  */
{ "cmacchnfr", 0x30C88F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* cmacchnfr<.cc> 0,limm,c 00110110110010001111CCCCCC0QQQQQ.  */
{ "cmacchnfr", 0x36C8F000, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_CC }},

/* cmacchnfr a,limm,u6 00110110010010001111uuuuuuAAAAAA.  */
{ "cmacchnfr", 0x3648F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* cmacchnfr 0,limm,u6 00110110010010001111uuuuuu111110.  */
{ "cmacchnfr", 0x3648F03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* cmacchnfr<.cc> 0,limm,u6 00110110110010001111uuuuuu1QQQQQ.  */
{ "cmacchnfr", 0x36C8F020, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* cmacchnfr 0,limm,s12 00110110100010001111ssssssSSSSSS.  */
{ "cmacchnfr", 0x3688F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* cmacchnfr a,limm,limm 00110110000010001111111110AAAAAA.  */
{ "cmacchnfr", 0x3608FF80, 0xFFFFFFC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* cmacchnfr 0,limm,limm 00110110000010001111111110111110.  */
{ "cmacchnfr", 0x3608FFBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { 0 }},

/* cmacchnfr<.cc> 0,limm,limm 001101101100100011111111100QQQQQ.  */
{ "cmacchnfr", 0x36C8FF80, 0xFFFFFFE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_CC }},

/* cmachfr a,b,c 00110bbb000001111BBBCCCCCCAAAAAA.  */
{ "cmachfr", 0x30078000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { 0 }},

/* cmachfr 0,b,c 00110bbb000001111BBBCCCCCC111110.  */
{ "cmachfr", 0x3007803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { 0 }},

/* cmachfr<.cc> b,b,c 00110bbb110001111BBBCCCCCC0QQQQQ.  */
{ "cmachfr", 0x30C78000, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_CC }},

/* cmachfr a,b,u6 00110bbb010001111BBBuuuuuuAAAAAA.  */
{ "cmachfr", 0x30478000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* cmachfr 0,b,u6 00110bbb010001111BBBuuuuuu111110.  */
{ "cmachfr", 0x3047803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { 0 }},

/* cmachfr<.cc> b,b,u6 00110bbb110001111BBBuuuuuu1QQQQQ.  */
{ "cmachfr", 0x30C78020, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* cmachfr b,b,s12 00110bbb100001111BBBssssssSSSSSS.  */
{ "cmachfr", 0x30878000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* cmachfr a,limm,c 00110110000001111111CCCCCCAAAAAA.  */
{ "cmachfr", 0x3607F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { 0 }},

/* cmachfr a,b,limm 00110bbb000001111BBB111110AAAAAA.  */
{ "cmachfr", 0x30078F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { 0 }},

/* cmachfr 0,limm,c 00110110000001111111CCCCCC111110.  */
{ "cmachfr", 0x3607F03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { 0 }},

/* cmachfr 0,b,limm 00110bbb000001111BBB111110111110.  */
{ "cmachfr", 0x30078FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { 0 }},

/* cmachfr<.cc> b,b,limm 00110bbb110001111BBB1111100QQQQQ.  */
{ "cmachfr", 0x30C78F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* cmachfr<.cc> 0,limm,c 00110110110001111111CCCCCC0QQQQQ.  */
{ "cmachfr", 0x36C7F000, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_CC }},

/* cmachfr a,limm,u6 00110110010001111111uuuuuuAAAAAA.  */
{ "cmachfr", 0x3647F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* cmachfr 0,limm,u6 00110110010001111111uuuuuu111110.  */
{ "cmachfr", 0x3647F03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* cmachfr<.cc> 0,limm,u6 00110110110001111111uuuuuu1QQQQQ.  */
{ "cmachfr", 0x36C7F020, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* cmachfr 0,limm,s12 00110110100001111111ssssssSSSSSS.  */
{ "cmachfr", 0x3687F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* cmachfr a,limm,limm 00110110000001111111111110AAAAAA.  */
{ "cmachfr", 0x3607FF80, 0xFFFFFFC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* cmachfr 0,limm,limm 00110110000001111111111110111110.  */
{ "cmachfr", 0x3607FFBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { 0 }},

/* cmachfr<.cc> 0,limm,limm 001101101100011111111111100QQQQQ.  */
{ "cmachfr", 0x36C7FF80, 0xFFFFFFE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_CC }},

/* cmachnfr a,b,c 00110bbb000001101BBBCCCCCCAAAAAA.  */
{ "cmachnfr", 0x30068000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { 0 }},

/* cmachnfr 0,b,c 00110bbb000001101BBBCCCCCC111110.  */
{ "cmachnfr", 0x3006803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { 0 }},

/* cmachnfr<.cc> b,b,c 00110bbb110001101BBBCCCCCC0QQQQQ.  */
{ "cmachnfr", 0x30C68000, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_CC }},

/* cmachnfr a,b,u6 00110bbb010001101BBBuuuuuuAAAAAA.  */
{ "cmachnfr", 0x30468000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* cmachnfr 0,b,u6 00110bbb010001101BBBuuuuuu111110.  */
{ "cmachnfr", 0x3046803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { 0 }},

/* cmachnfr<.cc> b,b,u6 00110bbb110001101BBBuuuuuu1QQQQQ.  */
{ "cmachnfr", 0x30C68020, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* cmachnfr b,b,s12 00110bbb100001101BBBssssssSSSSSS.  */
{ "cmachnfr", 0x30868000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* cmachnfr a,limm,c 00110110000001101111CCCCCCAAAAAA.  */
{ "cmachnfr", 0x3606F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { 0 }},

/* cmachnfr a,b,limm 00110bbb000001101BBB111110AAAAAA.  */
{ "cmachnfr", 0x30068F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { 0 }},

/* cmachnfr 0,limm,c 00110110000001101111CCCCCC111110.  */
{ "cmachnfr", 0x3606F03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { 0 }},

/* cmachnfr 0,b,limm 00110bbb000001101BBB111110111110.  */
{ "cmachnfr", 0x30068FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { 0 }},

/* cmachnfr<.cc> b,b,limm 00110bbb110001101BBB1111100QQQQQ.  */
{ "cmachnfr", 0x30C68F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* cmachnfr<.cc> 0,limm,c 00110110110001101111CCCCCC0QQQQQ.  */
{ "cmachnfr", 0x36C6F000, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_CC }},

/* cmachnfr a,limm,u6 00110110010001101111uuuuuuAAAAAA.  */
{ "cmachnfr", 0x3646F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* cmachnfr 0,limm,u6 00110110010001101111uuuuuu111110.  */
{ "cmachnfr", 0x3646F03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* cmachnfr<.cc> 0,limm,u6 00110110110001101111uuuuuu1QQQQQ.  */
{ "cmachnfr", 0x36C6F020, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* cmachnfr 0,limm,s12 00110110100001101111ssssssSSSSSS.  */
{ "cmachnfr", 0x3686F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* cmachnfr a,limm,limm 00110110000001101111111110AAAAAA.  */
{ "cmachnfr", 0x3606FF80, 0xFFFFFFC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* cmachnfr 0,limm,limm 00110110000001101111111110111110.  */
{ "cmachnfr", 0x3606FFBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { 0 }},

/* cmachnfr<.cc> 0,limm,limm 001101101100011011111111100QQQQQ.  */
{ "cmachnfr", 0x36C6FF80, 0xFFFFFFE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_CC }},

/* cmacrdw<.f> a,b,c 00101bbb00100110FBBBCCCCCCAAAAAA.  */
{ "cmacrdw", 0x28260000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* cmacrdw<.f> 0,b,c 00101bbb00100110FBBBCCCCCC111110.  */
{ "cmacrdw", 0x2826003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* cmacrdw<.f><.cc> b,b,c 00101bbb11100110FBBBCCCCCC0QQQQQ.  */
{ "cmacrdw", 0x28E60000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* cmacrdw<.f> a,b,u6 00101bbb01100110FBBBuuuuuuAAAAAA.  */
{ "cmacrdw", 0x28660000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* cmacrdw<.f> 0,b,u6 00101bbb01100110FBBBuuuuuu111110.  */
{ "cmacrdw", 0x2866003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* cmacrdw<.f><.cc> b,b,u6 00101bbb11100110FBBBuuuuuu1QQQQQ.  */
{ "cmacrdw", 0x28E60020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* cmacrdw<.f> b,b,s12 00101bbb10100110FBBBssssssSSSSSS.  */
{ "cmacrdw", 0x28A60000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* cmacrdw<.f> a,limm,c 0010111000100110F111CCCCCCAAAAAA.  */
{ "cmacrdw", 0x2E267000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* cmacrdw<.f> a,b,limm 00101bbb00100110FBBB111110AAAAAA.  */
{ "cmacrdw", 0x28260F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* cmacrdw<.f> 0,limm,c 0010111000100110F111CCCCCC111110.  */
{ "cmacrdw", 0x2E26703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* cmacrdw<.f> 0,b,limm 00101bbb00100110FBBB111110111110.  */
{ "cmacrdw", 0x28260FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* cmacrdw<.f><.cc> 0,limm,c 0010111011100110F111CCCCCC0QQQQQ.  */
{ "cmacrdw", 0x2EE67000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* cmacrdw<.f><.cc> b,b,limm 00101bbb11100110FBBB1111100QQQQQ.  */
{ "cmacrdw", 0x28E60F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* cmacrdw<.f> a,limm,u6 0010111001100110F111uuuuuuAAAAAA.  */
{ "cmacrdw", 0x2E667000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* cmacrdw<.f> 0,limm,u6 0010111001100110F111uuuuuu111110.  */
{ "cmacrdw", 0x2E66703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* cmacrdw<.f><.cc> 0,limm,u6 0010111011100110F111uuuuuu1QQQQQ.  */
{ "cmacrdw", 0x2EE67020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* cmacrdw<.f> 0,limm,s12 0010111010100110F111ssssssSSSSSS.  */
{ "cmacrdw", 0x2EA67000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* cmacrdw<.f> a,limm,limm 0010111000100110F111111110AAAAAA.  */
{ "cmacrdw", 0x2E267F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* cmacrdw<.f> 0,limm,limm 0010111000100110F111111110111110.  */
{ "cmacrdw", 0x2E267FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* cmacrdw<.f><.cc> 0,limm,limm 0010111011100110F1111111100QQQQQ.  */
{ "cmacrdw", 0x2EE67F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* cmp b,c 00100bbb000011001BBBCCCCCCRRRRRR.  */
{ "cmp", 0x200C8000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RC }, { 0 }},

/* cmp b,c 00100bbb000011001BBBCCCCCC000000.  */
{ "cmp", 0x200C8000, 0xF8FF803F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, ARITH, NONE, { RB, RC }, { 0 }},

/* cmp<.cc> b,c 00100bbb110011001BBBCCCCCC0QQQQQ.  */
{ "cmp", 0x20CC8000, 0xF8FF8020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RC }, { C_CC }},

/* cmp b,u6 00100bbb010011001BBBuuuuuuRRRRRR.  */
{ "cmp", 0x204C8000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, UIMM6_20 }, { 0 }},

/* cmp b,u6 00100bbb010011001BBBuuuuuu000000.  */
{ "cmp", 0x204C8000, 0xF8FF803F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, ARITH, NONE, { RB, UIMM6_20 }, { 0 }},

/* cmp<.cc> b,u6 00100bbb110011001BBBuuuuuu1QQQQQ.  */
{ "cmp", 0x20CC8020, 0xF8FF8020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, UIMM6_20 }, { C_CC }},

/* cmp b,s12 00100bbb100011001BBBssssssSSSSSS.  */
{ "cmp", 0x208C8000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, SIMM12_20 }, { 0 }},

/* cmp limm,c 00100110000011001111CCCCCCRRRRRR.  */
{ "cmp", 0x260CF000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, ARITH, NONE, { LIMM, RC }, { 0 }},

/* cmp b,limm 00100bbb000011001BBB111110RRRRRR.  */
{ "cmp", 0x200C8F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, LIMM }, { 0 }},

/* cmp limm,c 00100110000011001111CCCCCC000000.  */
{ "cmp", 0x260CF000, 0xFFFFF03F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, ARITH, NONE, { LIMM, RC }, { 0 }},

/* cmp b,limm 00100bbb000011001BBB111110000000.  */
{ "cmp", 0x200C8F80, 0xF8FF8FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, ARITH, NONE, { RB, LIMM }, { 0 }},

/* cmp<.cc> b,limm 00100bbb110011001BBB1111100QQQQQ.  */
{ "cmp", 0x20CC8F80, 0xF8FF8FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, LIMM }, { C_CC }},

/* cmp<.cc> limm,c 00100110110011001111CCCCCC0QQQQQ.  */
{ "cmp", 0x26CCF000, 0xFFFFF020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { LIMM, RC }, { C_CC }},

/* cmp limm,u6 00100110010011001111uuuuuuRRRRRR.  */
{ "cmp", 0x264CF000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, ARITH, NONE, { LIMM, UIMM6_20 }, { 0 }},

/* cmp limm,u6 00100110010011001111uuuuuu000000.  */
{ "cmp", 0x264CF000, 0xFFFFF03F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, ARITH, NONE, { LIMM, UIMM6_20 }, { 0 }},

/* cmp<.cc> limm,u6 00100110110011001111uuuuuu1QQQQQ.  */
{ "cmp", 0x26CCF020, 0xFFFFF020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { LIMM, UIMM6_20 }, { C_CC }},

/* cmp limm,s12 00100110100011001111ssssssSSSSSS.  */
{ "cmp", 0x268CF000, 0xFFFFF000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { LIMM, SIMM12_20 }, { 0 }},

/* cmp limm,limm 00100110000011001111111110RRRRRR.  */
{ "cmp", 0x260CFF80, 0xFFFFFFC0, ARC_OPCODE_ARCv2HS, ARITH, NONE, { LIMM, LIMMdup }, { 0 }},

/* cmp limm,limm 00100110000011001111111110000000.  */
{ "cmp", 0x260CFF80, 0xFFFFFFFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, ARITH, NONE, { LIMM, LIMMdup }, { 0 }},

/* cmp<.cc> limm,limm 001001101100110011111111100QQQQQ.  */
{ "cmp", 0x26CCFF80, 0xFFFFFFE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { LIMM, LIMMdup }, { C_CC }},

/* cmpychfr a,b,c 00110bbb000001011BBBCCCCCCAAAAAA.  */
{ "cmpychfr", 0x30058000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { 0 }},

/* cmpychfr 0,b,c 00110bbb000001011BBBCCCCCC111110.  */
{ "cmpychfr", 0x3005803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { 0 }},

/* cmpychfr<.cc> b,b,c 00110bbb110001011BBBCCCCCC0QQQQQ.  */
{ "cmpychfr", 0x30C58000, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_CC }},

/* cmpychfr a,b,u6 00110bbb010001011BBBuuuuuuAAAAAA.  */
{ "cmpychfr", 0x30458000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* cmpychfr 0,b,u6 00110bbb010001011BBBuuuuuu111110.  */
{ "cmpychfr", 0x3045803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { 0 }},

/* cmpychfr<.cc> b,b,u6 00110bbb110001011BBBuuuuuu1QQQQQ.  */
{ "cmpychfr", 0x30C58020, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* cmpychfr b,b,s12 00110bbb100001011BBBssssssSSSSSS.  */
{ "cmpychfr", 0x30858000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* cmpychfr a,limm,c 00110110000001011111CCCCCCAAAAAA.  */
{ "cmpychfr", 0x3605F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { 0 }},

/* cmpychfr a,b,limm 00110bbb000001011BBB111110AAAAAA.  */
{ "cmpychfr", 0x30058F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { 0 }},

/* cmpychfr 0,limm,c 00110110000001011111CCCCCC111110.  */
{ "cmpychfr", 0x3605F03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { 0 }},

/* cmpychfr 0,b,limm 00110bbb000001011BBB111110111110.  */
{ "cmpychfr", 0x30058FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { 0 }},

/* cmpychfr<.cc> b,b,limm 00110bbb110001011BBB1111100QQQQQ.  */
{ "cmpychfr", 0x30C58F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* cmpychfr<.cc> 0,limm,c 00110110110001011111CCCCCC0QQQQQ.  */
{ "cmpychfr", 0x36C5F000, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_CC }},

/* cmpychfr a,limm,u6 00110110010001011111uuuuuuAAAAAA.  */
{ "cmpychfr", 0x3645F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* cmpychfr 0,limm,u6 00110110010001011111uuuuuu111110.  */
{ "cmpychfr", 0x3645F03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* cmpychfr<.cc> 0,limm,u6 00110110110001011111uuuuuu1QQQQQ.  */
{ "cmpychfr", 0x36C5F020, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* cmpychfr 0,limm,s12 00110110100001011111ssssssSSSSSS.  */
{ "cmpychfr", 0x3685F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* cmpychfr a,limm,limm 00110110000001011111111110AAAAAA.  */
{ "cmpychfr", 0x3605FF80, 0xFFFFFFC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* cmpychfr 0,limm,limm 00110110000001011111111110111110.  */
{ "cmpychfr", 0x3605FFBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { 0 }},

/* cmpychfr<.cc> 0,limm,limm 001101101100010111111111100QQQQQ.  */
{ "cmpychfr", 0x36C5FF80, 0xFFFFFFE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_CC }},

/* cmpychnfr a,b,c 00110bbb000000101BBBCCCCCCAAAAAA.  */
{ "cmpychnfr", 0x30028000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { 0 }},

/* cmpychnfr 0,b,c 00110bbb000000001BBBCCCCCC111110.  */
{ "cmpychnfr", 0x3000803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { 0 }},

/* cmpychnfr<.cc> b,b,c 00110bbb110000001BBBCCCCCC0QQQQQ.  */
{ "cmpychnfr", 0x30C08000, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_CC }},

/* cmpychnfr a,b,u6 00110bbb010000001BBBuuuuuuAAAAAA.  */
{ "cmpychnfr", 0x30408000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* cmpychnfr 0,b,u6 00110bbb010000001BBBuuuuuu111110.  */
{ "cmpychnfr", 0x3040803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { 0 }},

/* cmpychnfr<.cc> b,b,u6 00110bbb110000001BBBuuuuuu1QQQQQ.  */
{ "cmpychnfr", 0x30C08020, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* cmpychnfr b,b,s12 00110bbb100000001BBBssssssSSSSSS.  */
{ "cmpychnfr", 0x30808000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* cmpychnfr a,limm,c 00110110000000001111CCCCCCAAAAAA.  */
{ "cmpychnfr", 0x3600F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { 0 }},

/* cmpychnfr a,b,limm 00110bbb000000001BBB111110AAAAAA.  */
{ "cmpychnfr", 0x30008F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { 0 }},

/* cmpychnfr 0,limm,c 00110110000000001111CCCCCC111110.  */
{ "cmpychnfr", 0x3600F03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { 0 }},

/* cmpychnfr 0,b,limm 00110bbb000000001BBB111110111110.  */
{ "cmpychnfr", 0x30008FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { 0 }},

/* cmpychnfr<.cc> b,b,limm 00110bbb110000001BBB1111100QQQQQ.  */
{ "cmpychnfr", 0x30C08F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* cmpychnfr<.cc> 0,limm,c 00110110110000001111CCCCCC0QQQQQ.  */
{ "cmpychnfr", 0x36C0F000, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_CC }},

/* cmpychnfr a,limm,u6 00110110010000001111uuuuuuAAAAAA.  */
{ "cmpychnfr", 0x3640F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* cmpychnfr 0,limm,u6 00110110010000001111uuuuuu111110.  */
{ "cmpychnfr", 0x3640F03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* cmpychnfr<.cc> 0,limm,u6 00110110110000001111uuuuuu1QQQQQ.  */
{ "cmpychnfr", 0x36C0F020, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* cmpychnfr 0,limm,s12 00110110100000001111ssssssSSSSSS.  */
{ "cmpychnfr", 0x3680F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* cmpychnfr a,limm,limm 00110110000000001111111110AAAAAA.  */
{ "cmpychnfr", 0x3600FF80, 0xFFFFFFC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* cmpychnfr 0,limm,limm 00110110000000001111111110111110.  */
{ "cmpychnfr", 0x3600FFBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { 0 }},

/* cmpychnfr<.cc> 0,limm,limm 001101101100000011111111100QQQQQ.  */
{ "cmpychnfr", 0x36C0FF80, 0xFFFFFFE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_CC }},

/* cmpyhfmr a,b,c 00110bbb000110110BBBCCCCCCAAAAAA.  */
{ "cmpyhfmr", 0x301B0000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { 0 }},

/* cmpyhfmr 0,b,c 00110bbb000110110BBBCCCCCC111110.  */
{ "cmpyhfmr", 0x301B003E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { 0 }},

/* cmpyhfmr<.cc> b,b,c 00110bbb110110110BBBCCCCCC0QQQQQ.  */
{ "cmpyhfmr", 0x30DB0000, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_CC }},

/* cmpyhfmr a,b,u6 00110bbb010110110BBBuuuuuuAAAAAA.  */
{ "cmpyhfmr", 0x305B0000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* cmpyhfmr 0,b,u6 00110bbb010110110BBBuuuuuu111110.  */
{ "cmpyhfmr", 0x305B003E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { 0 }},

/* cmpyhfmr<.cc> b,b,u6 00110bbb110110110BBBuuuuuu1QQQQQ.  */
{ "cmpyhfmr", 0x30DB0020, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* cmpyhfmr b,b,s12 00110bbb100110110BBBssssssSSSSSS.  */
{ "cmpyhfmr", 0x309B0000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* cmpyhfmr a,limm,c 00110110000110110111CCCCCCAAAAAA.  */
{ "cmpyhfmr", 0x361B7000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { 0 }},

/* cmpyhfmr a,b,limm 00110bbb000110110BBB111110AAAAAA.  */
{ "cmpyhfmr", 0x301B0F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { 0 }},

/* cmpyhfmr 0,limm,c 00110110000110110111CCCCCC111110.  */
{ "cmpyhfmr", 0x361B703E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { 0 }},

/* cmpyhfmr 0,b,limm 00110bbb000110110BBB111110111110.  */
{ "cmpyhfmr", 0x301B0FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { 0 }},

/* cmpyhfmr<.cc> b,b,limm 00110bbb110110110BBB1111100QQQQQ.  */
{ "cmpyhfmr", 0x30DB0F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* cmpyhfmr<.cc> 0,limm,c 00110110110110110111CCCCCC0QQQQQ.  */
{ "cmpyhfmr", 0x36DB7000, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_CC }},

/* cmpyhfmr a,limm,u6 00110110010110110111uuuuuuAAAAAA.  */
{ "cmpyhfmr", 0x365B7000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* cmpyhfmr 0,limm,u6 00110110010110110111uuuuuu111110.  */
{ "cmpyhfmr", 0x365B703E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* cmpyhfmr<.cc> 0,limm,u6 00110110110110110111uuuuuu1QQQQQ.  */
{ "cmpyhfmr", 0x36DB7020, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* cmpyhfmr 0,limm,s12 00110110100110110111ssssssSSSSSS.  */
{ "cmpyhfmr", 0x369B7000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* cmpyhfmr a,limm,limm 00110110000110110111111110AAAAAA.  */
{ "cmpyhfmr", 0x361B7F80, 0xFFFFFFC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* cmpyhfmr 0,limm,limm 00110110000110110111111110111110.  */
{ "cmpyhfmr", 0x361B7FBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { 0 }},

/* cmpyhfmr<.cc> 0,limm,limm 001101101101101101111111100QQQQQ.  */
{ "cmpyhfmr", 0x36DB7F80, 0xFFFFFFE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_CC }},

/* cmpyhfr a,b,c 00110bbb000000011BBBCCCCCCAAAAAA.  */
{ "cmpyhfr", 0x30018000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { 0 }},

/* cmpyhfr 0,b,c 00110bbb000000011BBBCCCCCC111110.  */
{ "cmpyhfr", 0x3001803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { 0 }},

/* cmpyhfr<.cc> b,b,c 00110bbb110000011BBBCCCCCC0QQQQQ.  */
{ "cmpyhfr", 0x30C18000, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_CC }},

/* cmpyhfr a,b,u6 00110bbb010000011BBBuuuuuuAAAAAA.  */
{ "cmpyhfr", 0x30418000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* cmpyhfr 0,b,u6 00110bbb010000011BBBuuuuuu111110.  */
{ "cmpyhfr", 0x3041803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { 0 }},

/* cmpyhfr<.cc> b,b,u6 00110bbb110000011BBBuuuuuu1QQQQQ.  */
{ "cmpyhfr", 0x30C18020, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* cmpyhfr b,b,s12 00110bbb100000011BBBssssssSSSSSS.  */
{ "cmpyhfr", 0x30818000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* cmpyhfr a,limm,c 00110110000000011111CCCCCCAAAAAA.  */
{ "cmpyhfr", 0x3601F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { 0 }},

/* cmpyhfr a,b,limm 00110bbb000000011BBB111110AAAAAA.  */
{ "cmpyhfr", 0x30018F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { 0 }},

/* cmpyhfr 0,limm,c 00110110000000011111CCCCCC111110.  */
{ "cmpyhfr", 0x3601F03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { 0 }},

/* cmpyhfr 0,b,limm 00110bbb000000011BBB111110111110.  */
{ "cmpyhfr", 0x30018FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { 0 }},

/* cmpyhfr<.cc> b,b,limm 00110bbb110000011BBB1111100QQQQQ.  */
{ "cmpyhfr", 0x30C18F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* cmpyhfr<.cc> 0,limm,c 00110110110000011111CCCCCC0QQQQQ.  */
{ "cmpyhfr", 0x36C1F000, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_CC }},

/* cmpyhfr a,limm,u6 00110110010000011111uuuuuuAAAAAA.  */
{ "cmpyhfr", 0x3641F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* cmpyhfr 0,limm,u6 00110110010000011111uuuuuu111110.  */
{ "cmpyhfr", 0x3641F03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* cmpyhfr<.cc> 0,limm,u6 00110110110000011111uuuuuu1QQQQQ.  */
{ "cmpyhfr", 0x36C1F020, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* cmpyhfr 0,limm,s12 00110110100000011111ssssssSSSSSS.  */
{ "cmpyhfr", 0x3681F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* cmpyhfr a,limm,limm 00110110000000011111111110AAAAAA.  */
{ "cmpyhfr", 0x3601FF80, 0xFFFFFFC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* cmpyhfr 0,limm,limm 00110110000000011111111110111110.  */
{ "cmpyhfr", 0x3601FFBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { 0 }},

/* cmpyhfr<.cc> 0,limm,limm 001101101100000111111111100QQQQQ.  */
{ "cmpyhfr", 0x36C1FF80, 0xFFFFFFE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_CC }},

/* cmpyhnfr a,b,c 00110bbb000000001BBBCCCCCCAAAAAA.  */
{ "cmpyhnfr", 0x30008000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { 0 }},

/* cmpyhnfr 0,b,c 00110bbb000000101BBBCCCCCC111110.  */
{ "cmpyhnfr", 0x3002803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { 0 }},

/* cmpyhnfr<.cc> b,b,c 00110bbb110000101BBBCCCCCC0QQQQQ.  */
{ "cmpyhnfr", 0x30C28000, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_CC }},

/* cmpyhnfr a,b,u6 00110bbb010000101BBBuuuuuuAAAAAA.  */
{ "cmpyhnfr", 0x30428000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* cmpyhnfr 0,b,u6 00110bbb010000101BBBuuuuuu111110.  */
{ "cmpyhnfr", 0x3042803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { 0 }},

/* cmpyhnfr<.cc> b,b,u6 00110bbb110000101BBBuuuuuu1QQQQQ.  */
{ "cmpyhnfr", 0x30C28020, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* cmpyhnfr b,b,s12 00110bbb100000101BBBssssssSSSSSS.  */
{ "cmpyhnfr", 0x30828000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* cmpyhnfr a,limm,c 00110110000000101111CCCCCCAAAAAA.  */
{ "cmpyhnfr", 0x3602F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { 0 }},

/* cmpyhnfr a,b,limm 00110bbb000000101BBB111110AAAAAA.  */
{ "cmpyhnfr", 0x30028F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { 0 }},

/* cmpyhnfr 0,limm,c 00110110000000101111CCCCCC111110.  */
{ "cmpyhnfr", 0x3602F03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { 0 }},

/* cmpyhnfr 0,b,limm 00110bbb000000101BBB111110111110.  */
{ "cmpyhnfr", 0x30028FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { 0 }},

/* cmpyhnfr<.cc> b,b,limm 00110bbb110000101BBB1111100QQQQQ.  */
{ "cmpyhnfr", 0x30C28F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* cmpyhnfr<.cc> 0,limm,c 00110110110000101111CCCCCC0QQQQQ.  */
{ "cmpyhnfr", 0x36C2F000, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_CC }},

/* cmpyhnfr a,limm,u6 00110110010000101111uuuuuuAAAAAA.  */
{ "cmpyhnfr", 0x3642F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* cmpyhnfr 0,limm,u6 00110110010000101111uuuuuu111110.  */
{ "cmpyhnfr", 0x3642F03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* cmpyhnfr<.cc> 0,limm,u6 00110110110000101111uuuuuu1QQQQQ.  */
{ "cmpyhnfr", 0x36C2F020, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* cmpyhnfr 0,limm,s12 00110110100000101111ssssssSSSSSS.  */
{ "cmpyhnfr", 0x3682F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* cmpyhnfr a,limm,limm 00110110000000101111111110AAAAAA.  */
{ "cmpyhnfr", 0x3602FF80, 0xFFFFFFC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* cmpyhnfr 0,limm,limm 00110110000000101111111110111110.  */
{ "cmpyhnfr", 0x3602FFBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { 0 }},

/* cmpyhnfr<.cc> 0,limm,limm 001101101100001011111111100QQQQQ.  */
{ "cmpyhnfr", 0x36C2FF80, 0xFFFFFFE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_CC }},

/* cmp_s b,h 01110bbbhhh10HHH.  */
{ "cmp_s", 0x00007010, 0x0000F818, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB_S, R6H }, { 0 }},

/* cmp_s b,h 01110bbbhhh100HH.  */
{ "cmp_s", 0x00007010, 0x0000F81C, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB_S, RH_S }, { 0 }},

/* cmp_s h,s3 01110ssshhh101HH.  */
{ "cmp_s", 0x00007014, 0x0000F81C, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RH_S, SIMM3_5_S }, { 0 }},

/* cmp_s b,u7 11100bbb1uuuuuuu.  */
{ "cmp_s", 0x0000E080, 0x0000F880, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB_S, UIMM7_9_S }, { 0 }},

/* cmp_s b,limm 01110bbb11010111.  */
{ "cmp_s", 0x000070D7, 0x0000F8FF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB_S, LIMM_S }, { 0 }},

/* cmp_s b,limm 01110bbb11010011.  */
{ "cmp_s", 0x000070D3, 0x0000F8FF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB_S, LIMM_S }, { 0 }},

/* cmp_s limm,s3 01110sss11010111.  */
{ "cmp_s", 0x000070D7, 0x0000F8FF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { LIMM_S, SIMM3_5_S }, { 0 }},

/* crc<.f> a,b,c 00101bbb00101100FBBBCCCCCCAAAAAA.  */
{ "crc", 0x282C0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* crc<.f> 0,b,c 00101bbb00101100FBBBCCCCCC111110.  */
{ "crc", 0x282C003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* crc<.f><.cc> b,b,c 00101bbb11101100FBBBCCCCCC0QQQQQ.  */
{ "crc", 0x28EC0000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* crc<.f> a,b,u6 00101bbb01101100FBBBuuuuuuAAAAAA.  */
{ "crc", 0x286C0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* crc<.f> 0,b,u6 00101bbb01101100FBBBuuuuuu111110.  */
{ "crc", 0x286C003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* crc<.f><.cc> b,b,u6 00101bbb11101100FBBBuuuuuu1QQQQQ.  */
{ "crc", 0x28EC0020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* crc<.f> b,b,s12 00101bbb10101100FBBBssssssSSSSSS.  */
{ "crc", 0x28AC0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* crc<.f> a,limm,c 0010111000101100F111CCCCCCAAAAAA.  */
{ "crc", 0x2E2C7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* crc<.f> a,b,limm 00101bbb00101100FBBB111110AAAAAA.  */
{ "crc", 0x282C0F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* crc<.f> 0,limm,c 0010111000101100F111CCCCCC111110.  */
{ "crc", 0x2E2C703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* crc<.f> 0,b,limm 00101bbb00101100FBBB111110111110.  */
{ "crc", 0x282C0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* crc<.f><.cc> 0,limm,c 0010111011101100F111CCCCCC0QQQQQ.  */
{ "crc", 0x2EEC7000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* crc<.f><.cc> b,b,limm 00101bbb11101100FBBB1111100QQQQQ.  */
{ "crc", 0x28EC0F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* crc<.f> a,limm,u6 0010111001101100F111uuuuuuAAAAAA.  */
{ "crc", 0x2E6C7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* crc<.f> 0,limm,u6 0010111001101100F111uuuuuu111110.  */
{ "crc", 0x2E6C703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* crc<.f><.cc> 0,limm,u6 0010111011101100F111uuuuuu1QQQQQ.  */
{ "crc", 0x2EEC7020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* crc<.f> 0,limm,s12 0010111010101100F111ssssssSSSSSS.  */
{ "crc", 0x2EAC7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* crc<.f> a,limm,limm 0010111000101100F111111110AAAAAA.  */
{ "crc", 0x2E2C7F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* crc<.f> 0,limm,limm 0010111000101100F111111110111110.  */
{ "crc", 0x2E2C7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* crc<.f><.cc> 0,limm,limm 0010111011101100F1111111100QQQQQ.  */
{ "crc", 0x2EEC7F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* daddh11<.f> a,b,c 00110bbb00001100FBBBCCCCCCAAAAAA.  */
{ "daddh11", 0x300C0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, RC }, { C_F }},

/* daddh11<.f> 0,b,c 00110bbb00001100FBBBCCCCCC111110.  */
{ "daddh11", 0x300C003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, RC }, { C_F }},

/* daddh11<.f><.cc> b,b,c 00110bbb11001100FBBBCCCCCC0QQQQQ.  */
{ "daddh11", 0x30CC0000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, RC }, { C_F, C_CC }},

/* daddh11<.f> a,b,c 00110bbb00110100FBBBCCCCCCAAAAAA.  */
{ "daddh11", 0x30340000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, RC }, { C_F }},

/* daddh11<.f> 0,b,c 00110bbb00110100FBBBCCCCCC111110.  */
{ "daddh11", 0x3034003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, RC }, { C_F }},

/* daddh11<.f><.cc> b,b,c 00110bbb11110100FBBBCCCCCC0QQQQQ.  */
{ "daddh11", 0x30F40000, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, RC }, { C_F, C_CC }},

/* daddh11<.f> a,b,u6 00110bbb01001100FBBBuuuuuuAAAAAA.  */
{ "daddh11", 0x304C0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, UIMM6_20 }, { C_F }},

/* daddh11<.f> 0,b,u6 00110bbb01001100FBBBuuuuuu111110.  */
{ "daddh11", 0x304C003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, UIMM6_20 }, { C_F }},

/* daddh11<.f><.cc> b,b,u6 00110bbb11001100FBBBuuuuuu1QQQQQ.  */
{ "daddh11", 0x30CC0020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* daddh11<.f> a,b,u6 00110bbb01110100FBBBuuuuuuAAAAAA.  */
{ "daddh11", 0x30740000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, UIMM6_20 }, { C_F }},

/* daddh11<.f> 0,b,u6 00110bbb01110100FBBBuuuuuu111110.  */
{ "daddh11", 0x3074003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, UIMM6_20 }, { C_F }},

/* daddh11<.f><.cc> b,b,u6 00110bbb11110100FBBBuuuuuu1QQQQQ.  */
{ "daddh11", 0x30F40020, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* daddh11<.f> b,b,s12 00110bbb10001100FBBBssssssSSSSSS.  */
{ "daddh11", 0x308C0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, SIMM12_20 }, { C_F }},

/* daddh11<.f> b,b,s12 00110bbb10110100FBBBssssssSSSSSS.  */
{ "daddh11", 0x30B40000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, SIMM12_20 }, { C_F }},

/* daddh11<.f> a,limm,c 0011011000001100F111CCCCCCAAAAAA.  */
{ "daddh11", 0x360C7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, RC }, { C_F }},

/* daddh11<.f> a,b,limm 00110bbb00001100FBBB111110AAAAAA.  */
{ "daddh11", 0x300C0F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, LIMM }, { C_F }},

/* daddh11<.f> 0,limm,c 0011011000001100F111CCCCCC111110.  */
{ "daddh11", 0x360C703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F }},

/* daddh11<.f> 0,b,limm 00110bbb00001100FBBB111110111110.  */
{ "daddh11", 0x300C0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, LIMM }, { C_F }},

/* daddh11<.f><.cc> 0,limm,c 0011011011001100F111CCCCCC0QQQQQ.  */
{ "daddh11", 0x36CC7000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F, C_CC }},

/* daddh11<.f><.cc> b,b,limm 00110bbb11001100FBBB1111100QQQQQ.  */
{ "daddh11", 0x30CC0F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* daddh11<.f> a,limm,c 0011011000110100F111CCCCCCAAAAAA.  */
{ "daddh11", 0x36347000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, RC }, { C_F }},

/* daddh11<.f> a,b,limm 00110bbb00110100FBBB111110AAAAAA.  */
{ "daddh11", 0x30340F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, LIMM }, { C_F }},

/* daddh11<.f> 0,limm,c 0011011000110100F111CCCCCC111110.  */
{ "daddh11", 0x3634703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F }},

/* daddh11<.f> 0,b,limm 00110bbb00110100FBBB111110111110.  */
{ "daddh11", 0x30340FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, LIMM }, { C_F }},

/* daddh11<.f><.cc> 0,limm,c 0011011011110100F111CCCCCC0QQQQQ.  */
{ "daddh11", 0x36F47000, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F, C_CC }},

/* daddh11<.f><.cc> b,b,limm 00110bbb11110100FBBB1111100QQQQQ.  */
{ "daddh11", 0x30F40F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* daddh11<.f> a,limm,u6 0011011001001100F111uuuuuuAAAAAA.  */
{ "daddh11", 0x364C7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, UIMM6_20 }, { C_F }},

/* daddh11<.f> 0,limm,u6 0011011001001100F111uuuuuu111110.  */
{ "daddh11", 0x364C703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* daddh11<.f><.cc> 0,limm,u6 0011011011001100F111uuuuuu1QQQQQ.  */
{ "daddh11", 0x36CC7020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* daddh11<.f> a,limm,u6 0011011001110100F111uuuuuuAAAAAA.  */
{ "daddh11", 0x36747000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, UIMM6_20 }, { C_F }},

/* daddh11<.f> 0,limm,u6 0011011001110100F111uuuuuu111110.  */
{ "daddh11", 0x3674703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* daddh11<.f><.cc> 0,limm,u6 0011011011110100F111uuuuuu1QQQQQ.  */
{ "daddh11", 0x36F47020, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* daddh11<.f> 0,limm,s12 0011011010001100F111ssssssSSSSSS.  */
{ "daddh11", 0x368C7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* daddh11<.f> 0,limm,s12 0011011010110100F111ssssssSSSSSS.  */
{ "daddh11", 0x36B47000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* daddh11<.f> a,limm,limm 0011011000001100F111111110AAAAAA.  */
{ "daddh11", 0x360C7F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, LIMMdup }, { C_F }},

/* daddh11<.f> 0,limm,limm 0011011000001100F111111110111110.  */
{ "daddh11", 0x360C7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F }},

/* daddh11<.f><.cc> 0,limm,limm 0011011011001100F1111111100QQQQQ.  */
{ "daddh11", 0x36CC7F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* daddh11<.f> a,limm,limm 0011011000110100F111111110AAAAAA.  */
{ "daddh11", 0x36347F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, LIMMdup }, { C_F }},

/* daddh11<.f> 0,limm,limm 0011011000110100F111111110111110.  */
{ "daddh11", 0x36347FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F }},

/* daddh11<.f><.cc> 0,limm,limm 0011011011110100F1111111100QQQQQ.  */
{ "daddh11", 0x36F47F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* daddh12<.f> a,b,c 00110bbb00001101FBBBCCCCCCAAAAAA.  */
{ "daddh12", 0x300D0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, RC }, { C_F }},

/* daddh12<.f> 0,b,c 00110bbb00001101FBBBCCCCCC111110.  */
{ "daddh12", 0x300D003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, RC }, { C_F }},

/* daddh12<.f><.cc> b,b,c 00110bbb11001101FBBBCCCCCC0QQQQQ.  */
{ "daddh12", 0x30CD0000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, RC }, { C_F, C_CC }},

/* daddh12<.f> a,b,c 00110bbb00110101FBBBCCCCCCAAAAAA.  */
{ "daddh12", 0x30350000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, RC }, { C_F }},

/* daddh12<.f> 0,b,c 00110bbb00110101FBBBCCCCCC111110.  */
{ "daddh12", 0x3035003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, RC }, { C_F }},

/* daddh12<.f><.cc> b,b,c 00110bbb11110101FBBBCCCCCC0QQQQQ.  */
{ "daddh12", 0x30F50000, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, RC }, { C_F, C_CC }},

/* daddh12<.f> a,b,u6 00110bbb01001101FBBBuuuuuuAAAAAA.  */
{ "daddh12", 0x304D0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, UIMM6_20 }, { C_F }},

/* daddh12<.f> 0,b,u6 00110bbb01001101FBBBuuuuuu111110.  */
{ "daddh12", 0x304D003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, UIMM6_20 }, { C_F }},

/* daddh12<.f><.cc> b,b,u6 00110bbb11001101FBBBuuuuuu1QQQQQ.  */
{ "daddh12", 0x30CD0020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* daddh12<.f> a,b,u6 00110bbb01110101FBBBuuuuuuAAAAAA.  */
{ "daddh12", 0x30750000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, UIMM6_20 }, { C_F }},

/* daddh12<.f> 0,b,u6 00110bbb01110101FBBBuuuuuu111110.  */
{ "daddh12", 0x3075003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, UIMM6_20 }, { C_F }},

/* daddh12<.f><.cc> b,b,u6 00110bbb11110101FBBBuuuuuu1QQQQQ.  */
{ "daddh12", 0x30F50020, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* daddh12<.f> b,b,s12 00110bbb10001101FBBBssssssSSSSSS.  */
{ "daddh12", 0x308D0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, SIMM12_20 }, { C_F }},

/* daddh12<.f> b,b,s12 00110bbb10110101FBBBssssssSSSSSS.  */
{ "daddh12", 0x30B50000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, SIMM12_20 }, { C_F }},

/* daddh12<.f> a,limm,c 0011011000001101F111CCCCCCAAAAAA.  */
{ "daddh12", 0x360D7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, RC }, { C_F }},

/* daddh12<.f> a,b,limm 00110bbb00001101FBBB111110AAAAAA.  */
{ "daddh12", 0x300D0F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, LIMM }, { C_F }},

/* daddh12<.f> 0,limm,c 0011011000001101F111CCCCCC111110.  */
{ "daddh12", 0x360D703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F }},

/* daddh12<.f> 0,b,limm 00110bbb00001101FBBB111110111110.  */
{ "daddh12", 0x300D0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, LIMM }, { C_F }},

/* daddh12<.f><.cc> 0,limm,c 0011011011001101F111CCCCCC0QQQQQ.  */
{ "daddh12", 0x36CD7000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F, C_CC }},

/* daddh12<.f><.cc> b,b,limm 00110bbb11001101FBBB1111100QQQQQ.  */
{ "daddh12", 0x30CD0F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* daddh12<.f> a,limm,c 0011011000110101F111CCCCCCAAAAAA.  */
{ "daddh12", 0x36357000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, RC }, { C_F }},

/* daddh12<.f> a,b,limm 00110bbb00110101FBBB111110AAAAAA.  */
{ "daddh12", 0x30350F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, LIMM }, { C_F }},

/* daddh12<.f> 0,limm,c 0011011000110101F111CCCCCC111110.  */
{ "daddh12", 0x3635703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F }},

/* daddh12<.f> 0,b,limm 00110bbb00110101FBBB111110111110.  */
{ "daddh12", 0x30350FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, LIMM }, { C_F }},

/* daddh12<.f><.cc> 0,limm,c 0011011011110101F111CCCCCC0QQQQQ.  */
{ "daddh12", 0x36F57000, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F, C_CC }},

/* daddh12<.f><.cc> b,b,limm 00110bbb11110101FBBB1111100QQQQQ.  */
{ "daddh12", 0x30F50F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* daddh12<.f> a,limm,u6 0011011001001101F111uuuuuuAAAAAA.  */
{ "daddh12", 0x364D7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, UIMM6_20 }, { C_F }},

/* daddh12<.f> 0,limm,u6 0011011001001101F111uuuuuu111110.  */
{ "daddh12", 0x364D703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* daddh12<.f><.cc> 0,limm,u6 0011011011001101F111uuuuuu1QQQQQ.  */
{ "daddh12", 0x36CD7020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* daddh12<.f> a,limm,u6 0011011001110101F111uuuuuuAAAAAA.  */
{ "daddh12", 0x36757000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, UIMM6_20 }, { C_F }},

/* daddh12<.f> 0,limm,u6 0011011001110101F111uuuuuu111110.  */
{ "daddh12", 0x3675703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* daddh12<.f><.cc> 0,limm,u6 0011011011110101F111uuuuuu1QQQQQ.  */
{ "daddh12", 0x36F57020, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* daddh12<.f> 0,limm,s12 0011011010001101F111ssssssSSSSSS.  */
{ "daddh12", 0x368D7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* daddh12<.f> 0,limm,s12 0011011010110101F111ssssssSSSSSS.  */
{ "daddh12", 0x36B57000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* daddh12<.f> a,limm,limm 0011011000001101F111111110AAAAAA.  */
{ "daddh12", 0x360D7F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, LIMMdup }, { C_F }},

/* daddh12<.f> 0,limm,limm 0011011000001101F111111110111110.  */
{ "daddh12", 0x360D7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F }},

/* daddh12<.f><.cc> 0,limm,limm 0011011011001101F1111111100QQQQQ.  */
{ "daddh12", 0x36CD7F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* daddh12<.f> a,limm,limm 0011011000110101F111111110AAAAAA.  */
{ "daddh12", 0x36357F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, LIMMdup }, { C_F }},

/* daddh12<.f> 0,limm,limm 0011011000110101F111111110111110.  */
{ "daddh12", 0x36357FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F }},

/* daddh12<.f><.cc> 0,limm,limm 0011011011110101F1111111100QQQQQ.  */
{ "daddh12", 0x36F57F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* daddh21<.f> a,b,c 00110bbb00001110FBBBCCCCCCAAAAAA.  */
{ "daddh21", 0x300E0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, RC }, { C_F }},

/* daddh21<.f> 0,b,c 00110bbb00001110FBBBCCCCCC111110.  */
{ "daddh21", 0x300E003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, RC }, { C_F }},

/* daddh21<.f><.cc> b,b,c 00110bbb11001110FBBBCCCCCC0QQQQQ.  */
{ "daddh21", 0x30CE0000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, RC }, { C_F, C_CC }},

/* daddh21<.f> a,b,c 00110bbb00110110FBBBCCCCCCAAAAAA.  */
{ "daddh21", 0x30360000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, RC }, { C_F }},

/* daddh21<.f> 0,b,c 00110bbb00110110FBBBCCCCCC111110.  */
{ "daddh21", 0x3036003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, RC }, { C_F }},

/* daddh21<.f><.cc> b,b,c 00110bbb11110110FBBBCCCCCC0QQQQQ.  */
{ "daddh21", 0x30F60000, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, RC }, { C_F, C_CC }},

/* daddh21<.f> a,b,u6 00110bbb01001110FBBBuuuuuuAAAAAA.  */
{ "daddh21", 0x304E0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, UIMM6_20 }, { C_F }},

/* daddh21<.f> 0,b,u6 00110bbb01001110FBBBuuuuuu111110.  */
{ "daddh21", 0x304E003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, UIMM6_20 }, { C_F }},

/* daddh21<.f><.cc> b,b,u6 00110bbb11001110FBBBuuuuuu1QQQQQ.  */
{ "daddh21", 0x30CE0020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* daddh21<.f> a,b,u6 00110bbb01110110FBBBuuuuuuAAAAAA.  */
{ "daddh21", 0x30760000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, UIMM6_20 }, { C_F }},

/* daddh21<.f> 0,b,u6 00110bbb01110110FBBBuuuuuu111110.  */
{ "daddh21", 0x3076003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, UIMM6_20 }, { C_F }},

/* daddh21<.f><.cc> b,b,u6 00110bbb11110110FBBBuuuuuu1QQQQQ.  */
{ "daddh21", 0x30F60020, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* daddh21<.f> b,b,s12 00110bbb10001110FBBBssssssSSSSSS.  */
{ "daddh21", 0x308E0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, SIMM12_20 }, { C_F }},

/* daddh21<.f> b,b,s12 00110bbb10110110FBBBssssssSSSSSS.  */
{ "daddh21", 0x30B60000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, SIMM12_20 }, { C_F }},

/* daddh21<.f> a,limm,c 0011011000001110F111CCCCCCAAAAAA.  */
{ "daddh21", 0x360E7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, RC }, { C_F }},

/* daddh21<.f> a,b,limm 00110bbb00001110FBBB111110AAAAAA.  */
{ "daddh21", 0x300E0F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, LIMM }, { C_F }},

/* daddh21<.f> 0,limm,c 0011011000001110F111CCCCCC111110.  */
{ "daddh21", 0x360E703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F }},

/* daddh21<.f> 0,b,limm 00110bbb00001110FBBB111110111110.  */
{ "daddh21", 0x300E0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, LIMM }, { C_F }},

/* daddh21<.f><.cc> 0,limm,c 0011011011001110F111CCCCCC0QQQQQ.  */
{ "daddh21", 0x36CE7000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F, C_CC }},

/* daddh21<.f><.cc> b,b,limm 00110bbb11001110FBBB1111100QQQQQ.  */
{ "daddh21", 0x30CE0F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* daddh21<.f> a,limm,c 0011011000110110F111CCCCCCAAAAAA.  */
{ "daddh21", 0x36367000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, RC }, { C_F }},

/* daddh21<.f> a,b,limm 00110bbb00110110FBBB111110AAAAAA.  */
{ "daddh21", 0x30360F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, LIMM }, { C_F }},

/* daddh21<.f> 0,limm,c 0011011000110110F111CCCCCC111110.  */
{ "daddh21", 0x3636703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F }},

/* daddh21<.f> 0,b,limm 00110bbb00110110FBBB111110111110.  */
{ "daddh21", 0x30360FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, LIMM }, { C_F }},

/* daddh21<.f><.cc> 0,limm,c 0011011011110110F111CCCCCC0QQQQQ.  */
{ "daddh21", 0x36F67000, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F, C_CC }},

/* daddh21<.f><.cc> b,b,limm 00110bbb11110110FBBB1111100QQQQQ.  */
{ "daddh21", 0x30F60F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* daddh21<.f> a,limm,u6 0011011001001110F111uuuuuuAAAAAA.  */
{ "daddh21", 0x364E7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, UIMM6_20 }, { C_F }},

/* daddh21<.f> 0,limm,u6 0011011001001110F111uuuuuu111110.  */
{ "daddh21", 0x364E703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* daddh21<.f><.cc> 0,limm,u6 0011011011001110F111uuuuuu1QQQQQ.  */
{ "daddh21", 0x36CE7020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* daddh21<.f> a,limm,u6 0011011001110110F111uuuuuuAAAAAA.  */
{ "daddh21", 0x36767000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, UIMM6_20 }, { C_F }},

/* daddh21<.f> 0,limm,u6 0011011001110110F111uuuuuu111110.  */
{ "daddh21", 0x3676703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* daddh21<.f><.cc> 0,limm,u6 0011011011110110F111uuuuuu1QQQQQ.  */
{ "daddh21", 0x36F67020, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* daddh21<.f> 0,limm,s12 0011011010001110F111ssssssSSSSSS.  */
{ "daddh21", 0x368E7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* daddh21<.f> 0,limm,s12 0011011010110110F111ssssssSSSSSS.  */
{ "daddh21", 0x36B67000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* daddh21<.f> a,limm,limm 0011011000001110F111111110AAAAAA.  */
{ "daddh21", 0x360E7F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, LIMMdup }, { C_F }},

/* daddh21<.f> 0,limm,limm 0011011000001110F111111110111110.  */
{ "daddh21", 0x360E7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F }},

/* daddh21<.f><.cc> 0,limm,limm 0011011011001110F1111111100QQQQQ.  */
{ "daddh21", 0x36CE7F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* daddh21<.f> a,limm,limm 0011011000110110F111111110AAAAAA.  */
{ "daddh21", 0x36367F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, LIMMdup }, { C_F }},

/* daddh21<.f> 0,limm,limm 0011011000110110F111111110111110.  */
{ "daddh21", 0x36367FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F }},

/* daddh21<.f><.cc> 0,limm,limm 0011011011110110F1111111100QQQQQ.  */
{ "daddh21", 0x36F67F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* daddh22<.f> a,b,c 00110bbb00001111FBBBCCCCCCAAAAAA.  */
{ "daddh22", 0x300F0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, RC }, { C_F }},

/* daddh22<.f> 0,b,c 00110bbb00001111FBBBCCCCCC111110.  */
{ "daddh22", 0x300F003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, RC }, { C_F }},

/* daddh22<.f><.cc> b,b,c 00110bbb11001111FBBBCCCCCC0QQQQQ.  */
{ "daddh22", 0x30CF0000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, RC }, { C_F, C_CC }},

/* daddh22<.f> a,b,c 00110bbb00110111FBBBCCCCCCAAAAAA.  */
{ "daddh22", 0x30370000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, RC }, { C_F }},

/* daddh22<.f> 0,b,c 00110bbb00110111FBBBCCCCCC111110.  */
{ "daddh22", 0x3037003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, RC }, { C_F }},

/* daddh22<.f><.cc> b,b,c 00110bbb11110111FBBBCCCCCC0QQQQQ.  */
{ "daddh22", 0x30F70000, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, RC }, { C_F, C_CC }},

/* daddh22<.f> a,b,u6 00110bbb01001111FBBBuuuuuuAAAAAA.  */
{ "daddh22", 0x304F0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, UIMM6_20 }, { C_F }},

/* daddh22<.f> 0,b,u6 00110bbb01001111FBBBuuuuuu111110.  */
{ "daddh22", 0x304F003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, UIMM6_20 }, { C_F }},

/* daddh22<.f><.cc> b,b,u6 00110bbb11001111FBBBuuuuuu1QQQQQ.  */
{ "daddh22", 0x30CF0020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* daddh22<.f> a,b,u6 00110bbb01110111FBBBuuuuuuAAAAAA.  */
{ "daddh22", 0x30770000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, UIMM6_20 }, { C_F }},

/* daddh22<.f> 0,b,u6 00110bbb01110111FBBBuuuuuu111110.  */
{ "daddh22", 0x3077003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, UIMM6_20 }, { C_F }},

/* daddh22<.f><.cc> b,b,u6 00110bbb11110111FBBBuuuuuu1QQQQQ.  */
{ "daddh22", 0x30F70020, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* daddh22<.f> b,b,s12 00110bbb10001111FBBBssssssSSSSSS.  */
{ "daddh22", 0x308F0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, SIMM12_20 }, { C_F }},

/* daddh22<.f> b,b,s12 00110bbb10110111FBBBssssssSSSSSS.  */
{ "daddh22", 0x30B70000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, SIMM12_20 }, { C_F }},

/* daddh22<.f> a,limm,c 0011011000001111F111CCCCCCAAAAAA.  */
{ "daddh22", 0x360F7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, RC }, { C_F }},

/* daddh22<.f> a,b,limm 00110bbb00001111FBBB111110AAAAAA.  */
{ "daddh22", 0x300F0F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, LIMM }, { C_F }},

/* daddh22<.f> 0,limm,c 0011011000001111F111CCCCCC111110.  */
{ "daddh22", 0x360F703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F }},

/* daddh22<.f> 0,b,limm 00110bbb00001111FBBB111110111110.  */
{ "daddh22", 0x300F0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, LIMM }, { C_F }},

/* daddh22<.f><.cc> 0,limm,c 0011011011001111F111CCCCCC0QQQQQ.  */
{ "daddh22", 0x36CF7000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F, C_CC }},

/* daddh22<.f><.cc> b,b,limm 00110bbb11001111FBBB1111100QQQQQ.  */
{ "daddh22", 0x30CF0F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* daddh22<.f> a,limm,c 0011011000110111F111CCCCCCAAAAAA.  */
{ "daddh22", 0x36377000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, RC }, { C_F }},

/* daddh22<.f> a,b,limm 00110bbb00110111FBBB111110AAAAAA.  */
{ "daddh22", 0x30370F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, LIMM }, { C_F }},

/* daddh22<.f> 0,limm,c 0011011000110111F111CCCCCC111110.  */
{ "daddh22", 0x3637703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F }},

/* daddh22<.f> 0,b,limm 00110bbb00110111FBBB111110111110.  */
{ "daddh22", 0x30370FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, LIMM }, { C_F }},

/* daddh22<.f><.cc> 0,limm,c 0011011011110111F111CCCCCC0QQQQQ.  */
{ "daddh22", 0x36F77000, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F, C_CC }},

/* daddh22<.f><.cc> b,b,limm 00110bbb11110111FBBB1111100QQQQQ.  */
{ "daddh22", 0x30F70F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* daddh22<.f> a,limm,u6 0011011001001111F111uuuuuuAAAAAA.  */
{ "daddh22", 0x364F7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, UIMM6_20 }, { C_F }},

/* daddh22<.f> 0,limm,u6 0011011001001111F111uuuuuu111110.  */
{ "daddh22", 0x364F703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* daddh22<.f><.cc> 0,limm,u6 0011011011001111F111uuuuuu1QQQQQ.  */
{ "daddh22", 0x36CF7020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* daddh22<.f> a,limm,u6 0011011001110111F111uuuuuuAAAAAA.  */
{ "daddh22", 0x36777000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, UIMM6_20 }, { C_F }},

/* daddh22<.f> 0,limm,u6 0011011001110111F111uuuuuu111110.  */
{ "daddh22", 0x3677703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* daddh22<.f><.cc> 0,limm,u6 0011011011110111F111uuuuuu1QQQQQ.  */
{ "daddh22", 0x36F77020, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* daddh22<.f> 0,limm,s12 0011011010001111F111ssssssSSSSSS.  */
{ "daddh22", 0x368F7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* daddh22<.f> 0,limm,s12 0011011010110111F111ssssssSSSSSS.  */
{ "daddh22", 0x36B77000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* daddh22<.f> a,limm,limm 0011011000001111F111111110AAAAAA.  */
{ "daddh22", 0x360F7F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, LIMMdup }, { C_F }},

/* daddh22<.f> 0,limm,limm 0011011000001111F111111110111110.  */
{ "daddh22", 0x360F7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F }},

/* daddh22<.f><.cc> 0,limm,limm 0011011011001111F1111111100QQQQQ.  */
{ "daddh22", 0x36CF7F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* daddh22<.f> a,limm,limm 0011011000110111F111111110AAAAAA.  */
{ "daddh22", 0x36377F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, LIMMdup }, { C_F }},

/* daddh22<.f> 0,limm,limm 0011011000110111F111111110111110.  */
{ "daddh22", 0x36377FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F }},

/* daddh22<.f><.cc> 0,limm,limm 0011011011110111F1111111100QQQQQ.  */
{ "daddh22", 0x36F77F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dbnz<.d> b,s13 00100bbb1000110N0BBBssssssSSSSSS.  */
{ "dbnz", 0x208C0000, 0xF8FE8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, BRANCH, NONE, { RB, SIMM13_A16_20}, { C_DNZ_D }},

/* dexcl1<.f> a,b,c 00110bbb00011000FBBBCCCCCCAAAAAA.  */
{ "dexcl1", 0x30180000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, RC }, { C_F }},

/* dexcl1<.f> 0,b,c 00110bbb00011000FBBBCCCCCC111110.  */
{ "dexcl1", 0x3018003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, RC }, { C_F }},

/* dexcl1<.f><.cc> b,b,c 00110bbb11011000FBBBCCCCCC0QQQQQ.  */
{ "dexcl1", 0x30D80000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, RC }, { C_F, C_CC }},

/* dexcl1<.f> a,b,c 00110bbb00111100FBBBCCCCCCAAAAAA.  */
{ "dexcl1", 0x303C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, RC }, { C_F }},

/* dexcl1<.f> 0,b,c 00110bbb00111100FBBBCCCCCC111110.  */
{ "dexcl1", 0x303C003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, RC }, { C_F }},

/* dexcl1<.f><.cc> b,b,c 00110bbb11111100FBBBCCCCCC0QQQQQ.  */
{ "dexcl1", 0x30FC0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, RC }, { C_F, C_CC }},

/* dexcl1<.f> a,b,u6 00110bbb01011000FBBBuuuuuuAAAAAA.  */
{ "dexcl1", 0x30580000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, UIMM6_20 }, { C_F }},

/* dexcl1<.f> 0,b,u6 00110bbb01011000FBBBuuuuuu111110.  */
{ "dexcl1", 0x3058003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, UIMM6_20 }, { C_F }},

/* dexcl1<.f><.cc> b,b,u6 00110bbb11011000FBBBuuuuuu1QQQQQ.  */
{ "dexcl1", 0x30D80020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dexcl1<.f> a,b,u6 00110bbb01111100FBBBuuuuuuAAAAAA.  */
{ "dexcl1", 0x307C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, UIMM6_20 }, { C_F }},

/* dexcl1<.f> 0,b,u6 00110bbb01111100FBBBuuuuuu111110.  */
{ "dexcl1", 0x307C003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, UIMM6_20 }, { C_F }},

/* dexcl1<.f><.cc> b,b,u6 00110bbb11111100FBBBuuuuuu1QQQQQ.  */
{ "dexcl1", 0x30FC0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dexcl1<.f> b,b,s12 00110bbb10011000FBBBssssssSSSSSS.  */
{ "dexcl1", 0x30980000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, SIMM12_20 }, { C_F }},

/* dexcl1<.f> b,b,s12 00110bbb10111100FBBBssssssSSSSSS.  */
{ "dexcl1", 0x30BC0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, SIMM12_20 }, { C_F }},

/* dexcl1<.f> a,limm,c 0011011000011000F111CCCCCCAAAAAA.  */
{ "dexcl1", 0x36187000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, RC }, { C_F }},

/* dexcl1<.f> a,b,limm 00110bbb00011000FBBB111110AAAAAA.  */
{ "dexcl1", 0x30180F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, LIMM }, { C_F }},

/* dexcl1<.f> 0,limm,c 0011011000011000F111CCCCCC111110.  */
{ "dexcl1", 0x3618703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F }},

/* dexcl1<.f> 0,b,limm 00110bbb00011000FBBB111110111110.  */
{ "dexcl1", 0x30180FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, LIMM }, { C_F }},

/* dexcl1<.f><.cc> 0,limm,c 0011011011011000F111CCCCCC0QQQQQ.  */
{ "dexcl1", 0x36D87000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dexcl1<.f><.cc> b,b,limm 00110bbb11011000FBBB1111100QQQQQ.  */
{ "dexcl1", 0x30D80F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* dexcl1<.f> a,limm,c 0011011000111100F111CCCCCCAAAAAA.  */
{ "dexcl1", 0x363C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, RC }, { C_F }},

/* dexcl1<.f> a,b,limm 00110bbb00111100FBBB111110AAAAAA.  */
{ "dexcl1", 0x303C0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, LIMM }, { C_F }},

/* dexcl1<.f> 0,limm,c 0011011000111100F111CCCCCC111110.  */
{ "dexcl1", 0x363C703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F }},

/* dexcl1<.f> 0,b,limm 00110bbb00111100FBBB111110111110.  */
{ "dexcl1", 0x303C0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, LIMM }, { C_F }},

/* dexcl1<.f><.cc> 0,limm,c 0011011011111100F111CCCCCC0QQQQQ.  */
{ "dexcl1", 0x36FC7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dexcl1<.f><.cc> b,b,limm 00110bbb11111100FBBB1111100QQQQQ.  */
{ "dexcl1", 0x30FC0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* dexcl1<.f> a,limm,u6 0011011001011000F111uuuuuuAAAAAA.  */
{ "dexcl1", 0x36587000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, UIMM6_20 }, { C_F }},

/* dexcl1<.f> 0,limm,u6 0011011001011000F111uuuuuu111110.  */
{ "dexcl1", 0x3658703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dexcl1<.f><.cc> 0,limm,u6 0011011011011000F111uuuuuu1QQQQQ.  */
{ "dexcl1", 0x36D87020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dexcl1<.f> a,limm,u6 0011011001111100F111uuuuuuAAAAAA.  */
{ "dexcl1", 0x367C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, UIMM6_20 }, { C_F }},

/* dexcl1<.f> 0,limm,u6 0011011001111100F111uuuuuu111110.  */
{ "dexcl1", 0x367C703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dexcl1<.f><.cc> 0,limm,u6 0011011011111100F111uuuuuu1QQQQQ.  */
{ "dexcl1", 0x36FC7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dexcl1<.f> 0,limm,s12 0011011010011000F111ssssssSSSSSS.  */
{ "dexcl1", 0x36987000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dexcl1<.f> 0,limm,s12 0011011010111100F111ssssssSSSSSS.  */
{ "dexcl1", 0x36BC7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dexcl1<.f> a,limm,limm 0011011000011000F111111110AAAAAA.  */
{ "dexcl1", 0x36187F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, LIMMdup }, { C_F }},

/* dexcl1<.f> 0,limm,limm 0011011000011000F111111110111110.  */
{ "dexcl1", 0x36187FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F }},

/* dexcl1<.f><.cc> 0,limm,limm 0011011011011000F1111111100QQQQQ.  */
{ "dexcl1", 0x36D87F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dexcl1<.f> a,limm,limm 0011011000111100F111111110AAAAAA.  */
{ "dexcl1", 0x363C7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, LIMMdup }, { C_F }},

/* dexcl1<.f> 0,limm,limm 0011011000111100F111111110111110.  */
{ "dexcl1", 0x363C7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F }},

/* dexcl1<.f><.cc> 0,limm,limm 0011011011111100F1111111100QQQQQ.  */
{ "dexcl1", 0x36FC7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dexcl2<.f> a,b,c 00110bbb00011001FBBBCCCCCCAAAAAA.  */
{ "dexcl2", 0x30190000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, RC }, { C_F }},

/* dexcl2<.f> 0,b,c 00110bbb00011001FBBBCCCCCC111110.  */
{ "dexcl2", 0x3019003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, RC }, { C_F }},

/* dexcl2<.f><.cc> b,b,c 00110bbb11011001FBBBCCCCCC0QQQQQ.  */
{ "dexcl2", 0x30D90000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, RC }, { C_F, C_CC }},

/* dexcl2<.f> a,b,c 00110bbb00111101FBBBCCCCCCAAAAAA.  */
{ "dexcl2", 0x303D0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, RC }, { C_F }},

/* dexcl2<.f> 0,b,c 00110bbb00111101FBBBCCCCCC111110.  */
{ "dexcl2", 0x303D003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, RC }, { C_F }},

/* dexcl2<.f><.cc> b,b,c 00110bbb11111101FBBBCCCCCC0QQQQQ.  */
{ "dexcl2", 0x30FD0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, RC }, { C_F, C_CC }},

/* dexcl2<.f> a,b,u6 00110bbb01011001FBBBuuuuuuAAAAAA.  */
{ "dexcl2", 0x30590000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, UIMM6_20 }, { C_F }},

/* dexcl2<.f> 0,b,u6 00110bbb01011001FBBBuuuuuu111110.  */
{ "dexcl2", 0x3059003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, UIMM6_20 }, { C_F }},

/* dexcl2<.f><.cc> b,b,u6 00110bbb11011001FBBBuuuuuu1QQQQQ.  */
{ "dexcl2", 0x30D90020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dexcl2<.f> a,b,u6 00110bbb01111101FBBBuuuuuuAAAAAA.  */
{ "dexcl2", 0x307D0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, UIMM6_20 }, { C_F }},

/* dexcl2<.f> 0,b,u6 00110bbb01111101FBBBuuuuuu111110.  */
{ "dexcl2", 0x307D003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, UIMM6_20 }, { C_F }},

/* dexcl2<.f><.cc> b,b,u6 00110bbb11111101FBBBuuuuuu1QQQQQ.  */
{ "dexcl2", 0x30FD0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dexcl2<.f> b,b,s12 00110bbb10011001FBBBssssssSSSSSS.  */
{ "dexcl2", 0x30990000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, SIMM12_20 }, { C_F }},

/* dexcl2<.f> b,b,s12 00110bbb10111101FBBBssssssSSSSSS.  */
{ "dexcl2", 0x30BD0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, SIMM12_20 }, { C_F }},

/* dexcl2<.f> a,limm,c 0011011000011001F111CCCCCCAAAAAA.  */
{ "dexcl2", 0x36197000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, RC }, { C_F }},

/* dexcl2<.f> a,b,limm 00110bbb00011001FBBB111110AAAAAA.  */
{ "dexcl2", 0x30190F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, LIMM }, { C_F }},

/* dexcl2<.f> 0,limm,c 0011011000011001F111CCCCCC111110.  */
{ "dexcl2", 0x3619703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F }},

/* dexcl2<.f> 0,b,limm 00110bbb00011001FBBB111110111110.  */
{ "dexcl2", 0x30190FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, LIMM }, { C_F }},

/* dexcl2<.f><.cc> 0,limm,c 0011011011011001F111CCCCCC0QQQQQ.  */
{ "dexcl2", 0x36D97000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dexcl2<.f><.cc> b,b,limm 00110bbb11011001FBBB1111100QQQQQ.  */
{ "dexcl2", 0x30D90F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* dexcl2<.f> a,limm,c 0011011000111101F111CCCCCCAAAAAA.  */
{ "dexcl2", 0x363D7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, RC }, { C_F }},

/* dexcl2<.f> a,b,limm 00110bbb00111101FBBB111110AAAAAA.  */
{ "dexcl2", 0x303D0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, LIMM }, { C_F }},

/* dexcl2<.f> 0,limm,c 0011011000111101F111CCCCCC111110.  */
{ "dexcl2", 0x363D703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F }},

/* dexcl2<.f> 0,b,limm 00110bbb00111101FBBB111110111110.  */
{ "dexcl2", 0x303D0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, LIMM }, { C_F }},

/* dexcl2<.f><.cc> 0,limm,c 0011011011111101F111CCCCCC0QQQQQ.  */
{ "dexcl2", 0x36FD7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dexcl2<.f><.cc> b,b,limm 00110bbb11111101FBBB1111100QQQQQ.  */
{ "dexcl2", 0x30FD0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* dexcl2<.f> a,limm,u6 0011011001011001F111uuuuuuAAAAAA.  */
{ "dexcl2", 0x36597000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, UIMM6_20 }, { C_F }},

/* dexcl2<.f> 0,limm,u6 0011011001011001F111uuuuuu111110.  */
{ "dexcl2", 0x3659703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dexcl2<.f><.cc> 0,limm,u6 0011011011011001F111uuuuuu1QQQQQ.  */
{ "dexcl2", 0x36D97020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dexcl2<.f> a,limm,u6 0011011001111101F111uuuuuuAAAAAA.  */
{ "dexcl2", 0x367D7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, UIMM6_20 }, { C_F }},

/* dexcl2<.f> 0,limm,u6 0011011001111101F111uuuuuu111110.  */
{ "dexcl2", 0x367D703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dexcl2<.f><.cc> 0,limm,u6 0011011011111101F111uuuuuu1QQQQQ.  */
{ "dexcl2", 0x36FD7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dexcl2<.f> 0,limm,s12 0011011010011001F111ssssssSSSSSS.  */
{ "dexcl2", 0x36997000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dexcl2<.f> 0,limm,s12 0011011010111101F111ssssssSSSSSS.  */
{ "dexcl2", 0x36BD7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dexcl2<.f> a,limm,limm 0011011000011001F111111110AAAAAA.  */
{ "dexcl2", 0x36197F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, LIMMdup }, { C_F }},

/* dexcl2<.f> 0,limm,limm 0011011000011001F111111110111110.  */
{ "dexcl2", 0x36197FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F }},

/* dexcl2<.f><.cc> 0,limm,limm 0011011011011001F1111111100QQQQQ.  */
{ "dexcl2", 0x36D97F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dexcl2<.f> a,limm,limm 0011011000111101F111111110AAAAAA.  */
{ "dexcl2", 0x363D7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, LIMMdup }, { C_F }},

/* dexcl2<.f> 0,limm,limm 0011011000111101F111111110111110.  */
{ "dexcl2", 0x363D7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F }},

/* dexcl2<.f><.cc> 0,limm,limm 0011011011111101F1111111100QQQQQ.  */
{ "dexcl2", 0x36FD7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* div<.f> a,b,c 00101bbb00000100FBBBCCCCCCAAAAAA.  */
{ "div", 0x28040000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, RB, RC }, { C_F }},

/* div<.f> 0,b,c 00101bbb00000100FBBBCCCCCC111110.  */
{ "div", 0x2804003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, RB, RC }, { C_F }},

/* div<.f><.cc> b,b,c 00101bbb11000100FBBBCCCCCC0QQQQQ.  */
{ "div", 0x28C40000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* div<.f> a,b,c 00101bbb00000100FBBBCCCCCCAAAAAA.  */
{ "div", 0x28040000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RA_CHK, RB, RC }, { C_F }},

/* div<.f> 0,b,c 00101bbb00000100FBBBCCCCCC111110.  */
{ "div", 0x2804003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, RB, RC }, { C_F }},

/* div<.f><.cc> b,b,c 00101bbb11000100FBBBCCCCCC0QQQQQ.  */
{ "div", 0x28C40000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* div<.f> a,b,u6 00101bbb01000100FBBBuuuuuuAAAAAA.  */
{ "div", 0x28440000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* div<.f> 0,b,u6 00101bbb01000100FBBBuuuuuu111110.  */
{ "div", 0x2844003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, RB, UIMM6_20 }, { C_F }},

/* div<.f><.cc> b,b,u6 00101bbb11000100FBBBuuuuuu1QQQQQ.  */
{ "div", 0x28C40020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* div<.f> a,b,u6 00101bbb01000100FBBBuuuuuuAAAAAA.  */
{ "div", 0x28440000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* div<.f> 0,b,u6 00101bbb01000100FBBBuuuuuu111110.  */
{ "div", 0x2844003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, RB, UIMM6_20 }, { C_F }},

/* div<.f><.cc> b,b,u6 00101bbb11000100FBBBuuuuuu1QQQQQ.  */
{ "div", 0x28C40020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* div<.f> b,b,s12 00101bbb10000100FBBBssssssSSSSSS.  */
{ "div", 0x28840000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* div<.f> b,b,s12 00101bbb10000100FBBBssssssSSSSSS.  */
{ "div", 0x28840000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* div<.f> a,limm,c 0010111000000100F111CCCCCCAAAAAA.  */
{ "div", 0x2E047000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, LIMM, RC }, { C_F }},

/* div<.f> a,b,limm 00101bbb00000100FBBB111110AAAAAA.  */
{ "div", 0x28040F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, RB, LIMM }, { C_F }},

/* div<.f> 0,limm,c 0010111000000100F111CCCCCC111110.  */
{ "div", 0x2E04703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, RC }, { C_F }},

/* div<.f> 0,b,limm 00101bbb00000100FBBB111110111110.  */
{ "div", 0x28040FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, RB, LIMM }, { C_F }},

/* div<.f><.cc> b,b,limm 00101bbb11000100FBBB1111100QQQQQ.  */
{ "div", 0x28C40F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* div<.f><.cc> 0,limm,c 0010111011000100F111CCCCCC0QQQQQ.  */
{ "div", 0x2EC47000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, RC }, { C_F, C_CC }},

/* div<.f> a,limm,c 0010111000000100F111CCCCCCAAAAAA.  */
{ "div", 0x2E047000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RA_CHK, LIMM, RC }, { C_F }},

/* div<.f> a,b,limm 00101bbb00000100FBBB111110AAAAAA.  */
{ "div", 0x28040F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RA_CHK, RB, LIMM }, { C_F }},

/* div<.f> 0,limm,c 0010111000000100F111CCCCCC111110.  */
{ "div", 0x2E04703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, LIMM, RC }, { C_F }},

/* div<.f> 0,b,limm 00101bbb00000100FBBB111110111110.  */
{ "div", 0x28040FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, RB, LIMM }, { C_F }},

/* div<.f><.cc> b,b,limm 00101bbb11000100FBBB1111100QQQQQ.  */
{ "div", 0x28C40F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* div<.f><.cc> 0,limm,c 0010111011000100F111CCCCCC0QQQQQ.  */
{ "div", 0x2EC47000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, LIMM, RC }, { C_F, C_CC }},

/* div<.f> a,limm,u6 0010111001000100F111uuuuuuAAAAAA.  */
{ "div", 0x2E447000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* div<.f> 0,limm,u6 0010111001000100F111uuuuuu111110.  */
{ "div", 0x2E44703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* div<.f><.cc> 0,limm,u6 0010111011000100F111uuuuuu1QQQQQ.  */
{ "div", 0x2EC47020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* div<.f> a,limm,u6 0010111001000100F111uuuuuuAAAAAA.  */
{ "div", 0x2E447000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* div<.f> 0,limm,u6 0010111001000100F111uuuuuu111110.  */
{ "div", 0x2E44703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* div<.f><.cc> 0,limm,u6 0010111011000100F111uuuuuu1QQQQQ.  */
{ "div", 0x2EC47020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* div<.f> 0,limm,s12 0010111010000100F111ssssssSSSSSS.  */
{ "div", 0x2E847000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* div<.f> 0,limm,s12 0010111010000100F111ssssssSSSSSS.  */
{ "div", 0x2E847000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* div<.f> a,limm,limm 0010111000000100F111111110AAAAAA.  */
{ "div", 0x2E047F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* div<.f> 0,limm,limm 0010111000000100F111111110111110.  */
{ "div", 0x2E047FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, LIMMdup }, { C_F }},

/* div<.f><.cc> 0,limm,limm 0010111011000100F1111111100QQQQQ.  */
{ "div", 0x2EC47F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* div<.f> a,limm,limm 0010111000000100F111111110AAAAAA.  */
{ "div", 0x2E047F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* div<.f> 0,limm,limm 0010111000000100F111111110111110.  */
{ "div", 0x2E047FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, LIMM, LIMMdup }, { C_F }},

/* div<.f><.cc> 0,limm,limm 0010111011000100F1111111100QQQQQ.  */
{ "div", 0x2EC47F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* divacc c 00101011001011110000CCCCCC111111.  */
{ "divacc", 0x2B2F003F, 0xFFFFF03F, ARC_OPCODE_ARCv2EM, DSP, NONE, { RC }, { 0 }},

/* divacc u6 00101011011011110000uuuuuu111111.  */
{ "divacc", 0x2B6F003F, 0xFFFFF03F, ARC_OPCODE_ARCv2EM, DSP, NONE, { UIMM6_20 }, { 0 }},

/* divaw<.f> a,b,c 00101bbb00001000FBBBCCCCCCAAAAAA.  */
{ "divaw", 0x28080000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* divaw<.f> 0,b,c 00101bbb00001000FBBBCCCCCC111110.  */
{ "divaw", 0x2808003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* divaw<.f><.cc> b,b,c 00101bbb11001000FBBBCCCCCC0QQQQQ.  */
{ "divaw", 0x28C80000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* divaw<.f> a,b,u6 00101bbb01001000FBBBuuuuuuAAAAAA.  */
{ "divaw", 0x28480000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* divaw<.f> 0,b,u6 00101bbb01001000FBBBuuuuuu111110.  */
{ "divaw", 0x2848003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* divaw<.f><.cc> b,b,u6 00101bbb11001000FBBBuuuuuu1QQQQQ.  */
{ "divaw", 0x28C80020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* divaw<.f> b,b,s12 00101bbb10001000FBBBssssssSSSSSS.  */
{ "divaw", 0x28880000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* divaw<.f> a,limm,c 0010111000001000F111CCCCCCAAAAAA.  */
{ "divaw", 0x2E087000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* divaw<.f> a,b,limm 00101bbb00001000FBBB111110AAAAAA.  */
{ "divaw", 0x28080F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* divaw<.f> 0,limm,c 0010111000001000F111CCCCCC111110.  */
{ "divaw", 0x2E08703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* divaw<.f> 0,b,limm 00101bbb00001000FBBB111110111110.  */
{ "divaw", 0x28080FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* divaw<.f><.cc> b,b,limm 00101bbb11001000FBBB1111100QQQQQ.  */
{ "divaw", 0x28C80F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* divaw<.f><.cc> 0,limm,c 0010111011001000F111CCCCCC0QQQQQ.  */
{ "divaw", 0x2EC87000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* divaw<.f> a,limm,u6 0010111001001000F111uuuuuuAAAAAA.  */
{ "divaw", 0x2E487000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* divaw<.f> 0,limm,u6 0010111001001000F111uuuuuu111110.  */
{ "divaw", 0x2E48703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* divaw<.f><.cc> 0,limm,u6 0010111011001000F111uuuuuu1QQQQQ.  */
{ "divaw", 0x2EC87020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* divaw<.f> 0,limm,s12 0010111010001000F111ssssssSSSSSS.  */
{ "divaw", 0x2E887000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* divaw<.f> a,limm,limm 0010111000001000F111111110AAAAAA.  */
{ "divaw", 0x2E087F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* divaw<.f> 0,limm,limm 0010111000001000F111111110111110.  */
{ "divaw", 0x2E087FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* divaw<.f><.cc> 0,limm,limm 0010111011001000F1111111100QQQQQ.  */
{ "divaw", 0x2EC87F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* divf<.f> a,b,c 00110bbb00010000FBBBCCCCCCAAAAAA.  */
{ "divf", 0x30100000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* divf<.f> 0,b,c 00110bbb00010000FBBBCCCCCC111110.  */
{ "divf", 0x3010003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* divf<.f><.cc> b,b,c 00110bbb11010000FBBBCCCCCC0QQQQQ.  */
{ "divf", 0x30D00000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* divf<.f> a,b,u6 00110bbb01010000FBBBuuuuuuAAAAAA.  */
{ "divf", 0x30500000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* divf<.f> 0,b,u6 00110bbb01010000FBBBuuuuuu111110.  */
{ "divf", 0x3050003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* divf<.f><.cc> b,b,u6 00110bbb11010000FBBBuuuuuu1QQQQQ.  */
{ "divf", 0x30D00020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* divf<.f> b,b,s12 00110bbb10010000FBBBssssssSSSSSS.  */
{ "divf", 0x30900000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* divf<.f> a,limm,c 0011011000010000F111CCCCCCAAAAAA.  */
{ "divf", 0x36107000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* divf<.f> a,b,limm 00110bbb00010000FBBB111110AAAAAA.  */
{ "divf", 0x30100F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* divf<.f> 0,limm,c 0011011000010000F111CCCCCC111110.  */
{ "divf", 0x3610703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* divf<.f> 0,b,limm 00110bbb00010000FBBB111110111110.  */
{ "divf", 0x30100FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* divf<.f><.cc> b,b,limm 00110bbb11010000FBBB1111100QQQQQ.  */
{ "divf", 0x30D00F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* divf<.f><.cc> 0,limm,c 0011011011010000F111CCCCCC0QQQQQ.  */
{ "divf", 0x36D07000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* divf<.f> a,limm,u6 0011011001010000F111uuuuuuAAAAAA.  */
{ "divf", 0x36507000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* divf<.f> 0,limm,u6 0011011001010000F111uuuuuu111110.  */
{ "divf", 0x3650703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* divf<.f><.cc> 0,limm,u6 0011011011010000F111uuuuuu1QQQQQ.  */
{ "divf", 0x36D07020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* divf<.f> 0,limm,s12 0011011010010000F111ssssssSSSSSS.  */
{ "divf", 0x36907000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* divf<.f> a,limm,limm 0011011000010000F111111110AAAAAA.  */
{ "divf", 0x36107F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* divf<.f> 0,limm,limm 0011011000010000F111111110111110.  */
{ "divf", 0x36107FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* divf<.f><.cc> 0,limm,limm 0011011011010000F1111111100QQQQQ.  */
{ "divf", 0x36D07F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* divu<.f> a,b,c 00101bbb00000101FBBBCCCCCCAAAAAA.  */
{ "divu", 0x28050000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, RB, RC }, { C_F }},

/* divu<.f> 0,b,c 00101bbb00000101FBBBCCCCCC111110.  */
{ "divu", 0x2805003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, RB, RC }, { C_F }},

/* divu<.f><.cc> b,b,c 00101bbb11000101FBBBCCCCCC0QQQQQ.  */
{ "divu", 0x28C50000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* divu<.f> a,b,c 00101bbb00000101FBBBCCCCCCAAAAAA.  */
{ "divu", 0x28050000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* divu<.f> 0,b,c 00101bbb00000101FBBBCCCCCC111110.  */
{ "divu", 0x2805003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* divu<.f><.cc> b,b,c 00101bbb11000101FBBBCCCCCC0QQQQQ.  */
{ "divu", 0x28C50000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* divu<.f> a,b,u6 00101bbb01000101FBBBuuuuuuAAAAAA.  */
{ "divu", 0x28450000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* divu<.f> 0,b,u6 00101bbb01000101FBBBuuuuuu111110.  */
{ "divu", 0x2845003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, RB, UIMM6_20 }, { C_F }},

/* divu<.f><.cc> b,b,u6 00101bbb11000101FBBBuuuuuu1QQQQQ.  */
{ "divu", 0x28C50020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* divu<.f> a,b,u6 00101bbb01000101FBBBuuuuuuAAAAAA.  */
{ "divu", 0x28450000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* divu<.f> 0,b,u6 00101bbb01000101FBBBuuuuuu111110.  */
{ "divu", 0x2845003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* divu<.f><.cc> b,b,u6 00101bbb11000101FBBBuuuuuu1QQQQQ.  */
{ "divu", 0x28C50020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* divu<.f> b,b,s12 00101bbb10000101FBBBssssssSSSSSS.  */
{ "divu", 0x28850000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* divu<.f> b,b,s12 00101bbb10000101FBBBssssssSSSSSS.  */
{ "divu", 0x28850000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* divu<.f> a,limm,c 0010111000000101F111CCCCCCAAAAAA.  */
{ "divu", 0x2E057000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, LIMM, RC }, { C_F }},

/* divu<.f> a,b,limm 00101bbb00000101FBBB111110AAAAAA.  */
{ "divu", 0x28050F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, RB, LIMM }, { C_F }},

/* divu<.f> 0,limm,c 0010111000000101F111CCCCCC111110.  */
{ "divu", 0x2E05703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, RC }, { C_F }},

/* divu<.f> 0,b,limm 00101bbb00000101FBBB111110111110.  */
{ "divu", 0x28050FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, RB, LIMM }, { C_F }},

/* divu<.f><.cc> b,b,limm 00101bbb11000101FBBB1111100QQQQQ.  */
{ "divu", 0x28C50F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* divu<.f><.cc> 0,limm,c 0010111011000101F111CCCCCC0QQQQQ.  */
{ "divu", 0x2EC57000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, RC }, { C_F, C_CC }},

/* divu<.f> a,limm,c 0010111000000101F111CCCCCCAAAAAA.  */
{ "divu", 0x2E057000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* divu<.f> a,b,limm 00101bbb00000101FBBB111110AAAAAA.  */
{ "divu", 0x28050F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* divu<.f> 0,limm,c 0010111000000101F111CCCCCC111110.  */
{ "divu", 0x2E05703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* divu<.f> 0,b,limm 00101bbb00000101FBBB111110111110.  */
{ "divu", 0x28050FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* divu<.f><.cc> b,b,limm 00101bbb11000101FBBB1111100QQQQQ.  */
{ "divu", 0x28C50F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* divu<.f><.cc> 0,limm,c 0010111011000101F111CCCCCC0QQQQQ.  */
{ "divu", 0x2EC57000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* divu<.f> a,limm,u6 0010111001000101F111uuuuuuAAAAAA.  */
{ "divu", 0x2E457000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* divu<.f> 0,limm,u6 0010111001000101F111uuuuuu111110.  */
{ "divu", 0x2E45703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* divu<.f><.cc> 0,limm,u6 0010111011000101F111uuuuuu1QQQQQ.  */
{ "divu", 0x2EC57020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* divu<.f> a,limm,u6 0010111001000101F111uuuuuuAAAAAA.  */
{ "divu", 0x2E457000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* divu<.f> 0,limm,u6 0010111001000101F111uuuuuu111110.  */
{ "divu", 0x2E45703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* divu<.f><.cc> 0,limm,u6 0010111011000101F111uuuuuu1QQQQQ.  */
{ "divu", 0x2EC57020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* divu<.f> 0,limm,s12 0010111010000101F111ssssssSSSSSS.  */
{ "divu", 0x2E857000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* divu<.f> 0,limm,s12 0010111010000101F111ssssssSSSSSS.  */
{ "divu", 0x2E857000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* divu<.f> a,limm,limm 0010111000000101F111111110AAAAAA.  */
{ "divu", 0x2E057F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* divu<.f> 0,limm,limm 0010111000000101F111111110111110.  */
{ "divu", 0x2E057FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, LIMMdup }, { C_F }},

/* divu<.f><.cc> 0,limm,limm 0010111011000101F1111111100QQQQQ.  */
{ "divu", 0x2EC57F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* divu<.f> a,limm,limm 0010111000000101F111111110AAAAAA.  */
{ "divu", 0x2E057F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* divu<.f> 0,limm,limm 0010111000000101F111111110111110.  */
{ "divu", 0x2E057FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* divu<.f><.cc> 0,limm,limm 0010111011000101F1111111100QQQQQ.  */
{ "divu", 0x2EC57F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmach<.f> a,b,c 00101bbb00010010FBBBCCCCCCAAAAAA.  */
{ "dmach", 0x28120000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, RB, RC }, { C_F }},

/* dmach<.f> 0,b,c 00101bbb00010010FBBBCCCCCC111110.  */
{ "dmach", 0x2812003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, RB, RC }, { C_F }},

/* dmach<.f><.cc> b,b,c 00101bbb11010010FBBBCCCCCC0QQQQQ.  */
{ "dmach", 0x28D20000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmach<.f> a,b,u6 00101bbb01010010FBBBuuuuuuAAAAAA.  */
{ "dmach", 0x28520000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmach<.f> 0,b,u6 00101bbb01010010FBBBuuuuuu111110.  */
{ "dmach", 0x2852003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmach<.f><.cc> b,b,u6 00101bbb11010010FBBBuuuuuu1QQQQQ.  */
{ "dmach", 0x28D20020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmach<.f> b,b,s12 00101bbb10010010FBBBssssssSSSSSS.  */
{ "dmach", 0x28920000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmach<.f> a,limm,c 0010111000010010F111CCCCCCAAAAAA.  */
{ "dmach", 0x2E127000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, LIMM, RC }, { C_F }},

/* dmach<.f> a,b,limm 00101bbb00010010FBBB111110AAAAAA.  */
{ "dmach", 0x28120F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, RB, LIMM }, { C_F }},

/* dmach<.f> 0,limm,c 0010111000010010F111CCCCCC111110.  */
{ "dmach", 0x2E12703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, RC }, { C_F }},

/* dmach<.f> 0,b,limm 00101bbb00010010FBBB111110111110.  */
{ "dmach", 0x28120FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, RB, LIMM }, { C_F }},

/* dmach<.f><.cc> b,b,limm 00101bbb11010010FBBB1111100QQQQQ.  */
{ "dmach", 0x28D20F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmach<.f><.cc> 0,limm,c 0010111011010010F111CCCCCC0QQQQQ.  */
{ "dmach", 0x2ED27000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmach<.f> a,limm,u6 0010111001010010F111uuuuuuAAAAAA.  */
{ "dmach", 0x2E527000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmach<.f> 0,limm,u6 0010111001010010F111uuuuuu111110.  */
{ "dmach", 0x2E52703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmach<.f><.cc> 0,limm,u6 0010111011010010F111uuuuuu1QQQQQ.  */
{ "dmach", 0x2ED27020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmach<.f> 0,limm,s12 0010111010010010F111ssssssSSSSSS.  */
{ "dmach", 0x2E927000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmach<.f> a,limm,limm 0010111000010010F111111110AAAAAA.  */
{ "dmach", 0x2E127F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmach<.f> 0,limm,limm 0010111000010010F111111110111110.  */
{ "dmach", 0x2E127FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmach<.f><.cc> 0,limm,limm 0010111011010010F1111111100QQQQQ.  */
{ "dmach", 0x2ED27F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmachbl<.f> a,b,c 00110bbb00011000FBBBCCCCCCAAAAAA.  */
{ "dmachbl", 0x30180000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* dmachbl<.f> 0,b,c 00110bbb00011000FBBBCCCCCC111110.  */
{ "dmachbl", 0x3018003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* dmachbl<.f><.cc> b,b,c 00110bbb11011000FBBBCCCCCC0QQQQQ.  */
{ "dmachbl", 0x30D80000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmachbl<.f> a,b,u6 00110bbb01011000FBBBuuuuuuAAAAAA.  */
{ "dmachbl", 0x30580000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmachbl<.f> 0,b,u6 00110bbb01011000FBBBuuuuuu111110.  */
{ "dmachbl", 0x3058003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmachbl<.f><.cc> b,b,u6 00110bbb11011000FBBBuuuuuu1QQQQQ.  */
{ "dmachbl", 0x30D80020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmachbl<.f> b,b,s12 00110bbb10011000FBBBssssssSSSSSS.  */
{ "dmachbl", 0x30980000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmachbl<.f> a,limm,c 0011011000011000F111CCCCCCAAAAAA.  */
{ "dmachbl", 0x36187000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* dmachbl<.f> a,b,limm 00110bbb00011000FBBB111110AAAAAA.  */
{ "dmachbl", 0x30180F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* dmachbl<.f> 0,limm,c 0011011000011000F111CCCCCC111110.  */
{ "dmachbl", 0x3618703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* dmachbl<.f> 0,b,limm 00110bbb00011000FBBB111110111110.  */
{ "dmachbl", 0x30180FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* dmachbl<.f><.cc> b,b,limm 00110bbb11011000FBBB1111100QQQQQ.  */
{ "dmachbl", 0x30D80F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmachbl<.f><.cc> 0,limm,c 0011011011011000F111CCCCCC0QQQQQ.  */
{ "dmachbl", 0x36D87000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmachbl<.f> a,limm,u6 0011011001011000F111uuuuuuAAAAAA.  */
{ "dmachbl", 0x36587000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmachbl<.f> 0,limm,u6 0011011001011000F111uuuuuu111110.  */
{ "dmachbl", 0x3658703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmachbl<.f><.cc> 0,limm,u6 0011011011011000F111uuuuuu1QQQQQ.  */
{ "dmachbl", 0x36D87020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmachbl<.f> 0,limm,s12 0011011010011000F111ssssssSSSSSS.  */
{ "dmachbl", 0x36987000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmachbl<.f> a,limm,limm 0011011000011000F111111110AAAAAA.  */
{ "dmachbl", 0x36187F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmachbl<.f> 0,limm,limm 0011011000011000F111111110111110.  */
{ "dmachbl", 0x36187FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmachbl<.f><.cc> 0,limm,limm 0011011011011000F1111111100QQQQQ.  */
{ "dmachbl", 0x36D87F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmachbm<.f> a,b,c 00110bbb00011001FBBBCCCCCCAAAAAA.  */
{ "dmachbm", 0x30190000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* dmachbm<.f> 0,b,c 00110bbb00011001FBBBCCCCCC111110.  */
{ "dmachbm", 0x3019003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* dmachbm<.f><.cc> b,b,c 00110bbb11011001FBBBCCCCCC0QQQQQ.  */
{ "dmachbm", 0x30D90000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmachbm<.f> a,b,u6 00110bbb01011001FBBBuuuuuuAAAAAA.  */
{ "dmachbm", 0x30590000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmachbm<.f> 0,b,u6 00110bbb01011001FBBBuuuuuu111110.  */
{ "dmachbm", 0x3059003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmachbm<.f><.cc> b,b,u6 00110bbb11011001FBBBuuuuuu1QQQQQ.  */
{ "dmachbm", 0x30D90020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmachbm<.f> b,b,s12 00110bbb10011001FBBBssssssSSSSSS.  */
{ "dmachbm", 0x30990000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmachbm<.f> a,limm,c 0011011000011001F111CCCCCCAAAAAA.  */
{ "dmachbm", 0x36197000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* dmachbm<.f> a,b,limm 00110bbb00011001FBBB111110AAAAAA.  */
{ "dmachbm", 0x30190F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* dmachbm<.f> 0,limm,c 0011011000011001F111CCCCCC111110.  */
{ "dmachbm", 0x3619703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* dmachbm<.f> 0,b,limm 00110bbb00011001FBBB111110111110.  */
{ "dmachbm", 0x30190FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* dmachbm<.f><.cc> b,b,limm 00110bbb11011001FBBB1111100QQQQQ.  */
{ "dmachbm", 0x30D90F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmachbm<.f><.cc> 0,limm,c 0011011011011001F111CCCCCC0QQQQQ.  */
{ "dmachbm", 0x36D97000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmachbm<.f> a,limm,u6 0011011001011001F111uuuuuuAAAAAA.  */
{ "dmachbm", 0x36597000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmachbm<.f> 0,limm,u6 0011011001011001F111uuuuuu111110.  */
{ "dmachbm", 0x3659703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmachbm<.f><.cc> 0,limm,u6 0011011011011001F111uuuuuu1QQQQQ.  */
{ "dmachbm", 0x36D97020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmachbm<.f> 0,limm,s12 0011011010011001F111ssssssSSSSSS.  */
{ "dmachbm", 0x36997000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmachbm<.f> a,limm,limm 0011011000011001F111111110AAAAAA.  */
{ "dmachbm", 0x36197F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmachbm<.f> 0,limm,limm 0011011000011001F111111110111110.  */
{ "dmachbm", 0x36197FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmachbm<.f><.cc> 0,limm,limm 0011011011011001F1111111100QQQQQ.  */
{ "dmachbm", 0x36D97F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmachf<.f> a,b,c 00101bbb00101100FBBBCCCCCCAAAAAA.  */
{ "dmachf", 0x282C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* dmachf<.f> 0,b,c 00101bbb00101100FBBBCCCCCC111110.  */
{ "dmachf", 0x282C003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* dmachf<.f><.cc> b,b,c 00101bbb11101100FBBBCCCCCC0QQQQQ.  */
{ "dmachf", 0x28EC0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmachf<.f> a,b,u6 00101bbb01101100FBBBuuuuuuAAAAAA.  */
{ "dmachf", 0x286C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmachf<.f> 0,b,u6 00101bbb01101100FBBBuuuuuu111110.  */
{ "dmachf", 0x286C003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmachf<.f><.cc> b,b,u6 00101bbb11101100FBBBuuuuuu1QQQQQ.  */
{ "dmachf", 0x28EC0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmachf<.f> b,b,s12 00101bbb10101100FBBBssssssSSSSSS.  */
{ "dmachf", 0x28AC0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmachf<.f> a,limm,c 0010111000101100F111CCCCCCAAAAAA.  */
{ "dmachf", 0x2E2C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* dmachf<.f> a,b,limm 00101bbb00101100FBBB111110AAAAAA.  */
{ "dmachf", 0x282C0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* dmachf<.f> 0,limm,c 0010111001101100F111CCCCCC111110.  */
{ "dmachf", 0x2E6C703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* dmachf<.f> 0,b,limm 00101bbb00101100FBBB111110111110.  */
{ "dmachf", 0x282C0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* dmachf<.f><.cc> b,b,limm 00101bbb11101100FBBB1111100QQQQQ.  */
{ "dmachf", 0x28EC0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmachf<.f><.cc> 0,limm,c 0010111011101100F111CCCCCC0QQQQQ.  */
{ "dmachf", 0x2EEC7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmachf<.f> a,limm,u6 0010111001101100F111uuuuuuAAAAAA.  */
{ "dmachf", 0x2E6C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmachf<.f> 0,limm,u6 0010111001101100F111uuuuuu111110.  */
{ "dmachf", 0x2E6C703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmachf<.f><.cc> 0,limm,u6 0010111011101100F111uuuuuu1QQQQQ.  */
{ "dmachf", 0x2EEC7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmachf<.f> 0,limm,s12 0010111010101100F111ssssssSSSSSS.  */
{ "dmachf", 0x2EAC7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmachf<.f> a,limm,limm 0010111000101100F111111110AAAAAA.  */
{ "dmachf", 0x2E2C7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmachf<.f> 0,limm,limm 0010111000101100F111111110111110.  */
{ "dmachf", 0x2E2C7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmachf<.f><.cc> 0,limm,limm 0010111011101100F1111111100QQQQQ.  */
{ "dmachf", 0x2EEC7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmachfr<.f> a,b,c 00101bbb00101101FBBBCCCCCCAAAAAA.  */
{ "dmachfr", 0x282D0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* dmachfr<.f> 0,b,c 00101bbb00101101FBBBCCCCCC111110.  */
{ "dmachfr", 0x282D003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* dmachfr<.f><.cc> b,b,c 00101bbb11101101FBBBCCCCCC0QQQQQ.  */
{ "dmachfr", 0x28ED0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmachfr<.f> a,b,u6 00101bbb01101101FBBBuuuuuuAAAAAA.  */
{ "dmachfr", 0x286D0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmachfr<.f> 0,b,u6 00101bbb01101101FBBBuuuuuu111110.  */
{ "dmachfr", 0x286D003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmachfr<.f><.cc> b,b,u6 00101bbb11101101FBBBuuuuuu1QQQQQ.  */
{ "dmachfr", 0x28ED0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmachfr<.f> b,b,s12 00101bbb10101101FBBBssssssSSSSSS.  */
{ "dmachfr", 0x28AD0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmachfr<.f> a,limm,c 0010111000101101F111CCCCCCAAAAAA.  */
{ "dmachfr", 0x2E2D7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* dmachfr<.f> a,b,limm 00101bbb00101101FBBB111110AAAAAA.  */
{ "dmachfr", 0x282D0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* dmachfr<.f> 0,limm,c 0010111001101101F111CCCCCC111110.  */
{ "dmachfr", 0x2E6D703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* dmachfr<.f> 0,b,limm 00101bbb00101101FBBB111110111110.  */
{ "dmachfr", 0x282D0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* dmachfr<.f><.cc> b,b,limm 00101bbb11101101FBBB1111100QQQQQ.  */
{ "dmachfr", 0x28ED0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmachfr<.f><.cc> 0,limm,c 0010111011101101F111CCCCCC0QQQQQ.  */
{ "dmachfr", 0x2EED7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmachfr<.f> a,limm,u6 0010111001101101F111uuuuuuAAAAAA.  */
{ "dmachfr", 0x2E6D7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmachfr<.f> 0,limm,u6 0010111001101101F111uuuuuu111110.  */
{ "dmachfr", 0x2E6D703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmachfr<.f><.cc> 0,limm,u6 0010111011101101F111uuuuuu1QQQQQ.  */
{ "dmachfr", 0x2EED7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmachfr<.f> 0,limm,s12 0010111010101101F111ssssssSSSSSS.  */
{ "dmachfr", 0x2EAD7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmachfr<.f> a,limm,limm 0010111000101101F111111110AAAAAA.  */
{ "dmachfr", 0x2E2D7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmachfr<.f> 0,limm,limm 0010111000101101F111111110111110.  */
{ "dmachfr", 0x2E2D7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmachfr<.f><.cc> 0,limm,limm 0010111011101101F1111111100QQQQQ.  */
{ "dmachfr", 0x2EED7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmachu<.f> a,b,c 00101bbb00010011FBBBCCCCCCAAAAAA.  */
{ "dmachu", 0x28130000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, RB, RC }, { C_F }},

/* dmachu<.f> 0,b,c 00101bbb00010011FBBBCCCCCC111110.  */
{ "dmachu", 0x2813003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, RB, RC }, { C_F }},

/* dmachu<.f><.cc> b,b,c 00101bbb11010011FBBBCCCCCC0QQQQQ.  */
{ "dmachu", 0x28D30000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmachu<.f> a,b,u6 00101bbb01010011FBBBuuuuuuAAAAAA.  */
{ "dmachu", 0x28530000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmachu<.f> 0,b,u6 00101bbb01010011FBBBuuuuuu111110.  */
{ "dmachu", 0x2853003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmachu<.f><.cc> b,b,u6 00101bbb11010011FBBBuuuuuu1QQQQQ.  */
{ "dmachu", 0x28D30020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmachu<.f> b,b,s12 00101bbb10010011FBBBssssssSSSSSS.  */
{ "dmachu", 0x28930000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmachu<.f> a,limm,c 0010111000010011F111CCCCCCAAAAAA.  */
{ "dmachu", 0x2E137000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, LIMM, RC }, { C_F }},

/* dmachu<.f> a,b,limm 00101bbb00010011FBBB111110AAAAAA.  */
{ "dmachu", 0x28130F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, RB, LIMM }, { C_F }},

/* dmachu<.f> 0,limm,c 0010111000010011F111CCCCCC111110.  */
{ "dmachu", 0x2E13703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, RC }, { C_F }},

/* dmachu<.f> 0,b,limm 00101bbb00010011FBBB111110111110.  */
{ "dmachu", 0x28130FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, RB, LIMM }, { C_F }},

/* dmachu<.f><.cc> b,b,limm 00101bbb11010011FBBB1111100QQQQQ.  */
{ "dmachu", 0x28D30F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmachu<.f><.cc> 0,limm,c 0010111011010011F111CCCCCC0QQQQQ.  */
{ "dmachu", 0x2ED37000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmachu<.f> a,limm,u6 0010111001010011F111uuuuuuAAAAAA.  */
{ "dmachu", 0x2E537000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmachu<.f> 0,limm,u6 0010111001010011F111uuuuuu111110.  */
{ "dmachu", 0x2E53703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmachu<.f><.cc> 0,limm,u6 0010111011010011F111uuuuuu1QQQQQ.  */
{ "dmachu", 0x2ED37020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmachu<.f> 0,limm,s12 0010111010010011F111ssssssSSSSSS.  */
{ "dmachu", 0x2E937000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmachu<.f> a,limm,limm 0010111000010011F111111110AAAAAA.  */
{ "dmachu", 0x2E137F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmachu<.f> 0,limm,limm 0010111000010011F111111110111110.  */
{ "dmachu", 0x2E137FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmachu<.f><.cc> 0,limm,limm 0010111011010011F1111111100QQQQQ.  */
{ "dmachu", 0x2ED37F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmacpf<.f> a,b,c 00101bbb00111011FBBBCCCCCCAAAAAA.  */
{ "dmacpf", 0x283B0000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* dmacpf<.f><.cc> b,b,c 00101bbb11111011FBBBCCCCCC0QQQQQ.  */
{ "dmacpf", 0x28FB0000, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmacpf<.f> 0,b,c 00101bbb00111011FBBBCCCCCC111110.  */
{ "dmacpf", 0x283B003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* dmacpf<.f> a,b,limm 00101bbb00111011FBBB111110AAAAAA.  */
{ "dmacpf", 0x283B0F80, 0xF8FF0FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* dmacpf<.f><.cc> b,b,limm 00101bbb11111011FBBB1111100QQQQQ.  */
{ "dmacpf", 0x28FB0F80, 0xF8FF0FE0, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmacwh<.f> a,b,c 00101bbb00110110FBBBCCCCCCAAAAAA.  */
{ "dmacwh", 0x28360000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, RC }, { C_F }},

/* dmacwh<.f> 0,b,c 00101bbb00110110FBBBCCCCCC111110.  */
{ "dmacwh", 0x2836003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, RC }, { C_F }},

/* dmacwh<.f><.cc> b,b,c 00101bbb11110110FBBBCCCCCC0QQQQQ.  */
{ "dmacwh", 0x28F60000, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmacwh<.f> a,b,u6 00101bbb01110110FBBBuuuuuuAAAAAA.  */
{ "dmacwh", 0x28760000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmacwh<.f> 0,b,u6 00101bbb01110110FBBBuuuuuu111110.  */
{ "dmacwh", 0x2876003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmacwh<.f><.cc> b,b,u6 00101bbb11110110FBBBuuuuuu1QQQQQ.  */
{ "dmacwh", 0x28F60020, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmacwh<.f> b,b,s12 00101bbb10110110FBBBssssssSSSSSS.  */
{ "dmacwh", 0x28B60000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmacwh<.f> a,limm,c 0010111000110110F111CCCCCCAAAAAA.  */
{ "dmacwh", 0x2E367000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, RC }, { C_F }},

/* dmacwh<.f> a,b,limm 00101bbb00110110FBBB111110AAAAAA.  */
{ "dmacwh", 0x28360F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, LIMM }, { C_F }},

/* dmacwh<.f> 0,limm,c 0010111000110110F111CCCCCC111110.  */
{ "dmacwh", 0x2E36703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F }},

/* dmacwh<.f> 0,b,limm 00101bbb00110110FBBB111110111110.  */
{ "dmacwh", 0x28360FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, LIMM }, { C_F }},

/* dmacwh<.f><.cc> b,b,limm 00101bbb11110110FBBB1111100QQQQQ.  */
{ "dmacwh", 0x28F60F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmacwh<.f><.cc> 0,limm,c 0010111011110110F111CCCCCC0QQQQQ.  */
{ "dmacwh", 0x2EF67000, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmacwh<.f> a,limm,u6 0010111001110110F111uuuuuuAAAAAA.  */
{ "dmacwh", 0x2E767000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmacwh<.f> 0,limm,u6 0010111001110110F111uuuuuu111110.  */
{ "dmacwh", 0x2E76703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmacwh<.f><.cc> 0,limm,u6 0010111011110110F111uuuuuu1QQQQQ.  */
{ "dmacwh", 0x2EF67020, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmacwh<.f> 0,limm,s12 0010111010110110F111ssssssSSSSSS.  */
{ "dmacwh", 0x2EB67000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmacwh<.f> a,limm,limm 0010111000110110F111111110AAAAAA.  */
{ "dmacwh", 0x2E367F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmacwh<.f> 0,limm,limm 0010111000110110F111111110111110.  */
{ "dmacwh", 0x2E367FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmacwh<.f><.cc> 0,limm,limm 0010111011110110F1111111100QQQQQ.  */
{ "dmacwh", 0x2EF67F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmacwhf<.f> a,b,c 00110bbb00110111FBBBCCCCCCAAAAAA.  */
{ "dmacwhf", 0x30370000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, RC }, { C_F }},

/* dmacwhf<.f> 0,b,c 00110bbb00110111FBBBCCCCCC111110.  */
{ "dmacwhf", 0x3037003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, RC }, { C_F }},

/* dmacwhf<.f><.cc> b,b,c 00110bbb11110111FBBBCCCCCC0QQQQQ.  */
{ "dmacwhf", 0x30F70000, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmacwhf<.f> a,b,u6 00110bbb01110111FBBBuuuuuuAAAAAA.  */
{ "dmacwhf", 0x30770000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmacwhf<.f> 0,b,u6 00110bbb01110111FBBBuuuuuu111110.  */
{ "dmacwhf", 0x3077003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmacwhf<.f><.cc> b,b,u6 00110bbb11110111FBBBuuuuuu1QQQQQ.  */
{ "dmacwhf", 0x30F70020, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmacwhf<.f> b,b,s12 00110bbb10110111FBBBssssssSSSSSS.  */
{ "dmacwhf", 0x30B70000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmacwhf<.f> a,limm,c 0011011000110111F111CCCCCCAAAAAA.  */
{ "dmacwhf", 0x36377000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, RC }, { C_F }},

/* dmacwhf<.f> a,b,limm 00110bbb00110111FBBB111110AAAAAA.  */
{ "dmacwhf", 0x30370F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, LIMM }, { C_F }},

/* dmacwhf<.f> 0,limm,c 0011011000110111F111CCCCCC111110.  */
{ "dmacwhf", 0x3637703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F }},

/* dmacwhf<.f> 0,b,limm 00110bbb00110111FBBB111110111110.  */
{ "dmacwhf", 0x30370FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, LIMM }, { C_F }},

/* dmacwhf<.f><.cc> b,b,limm 00110bbb11110111FBBB1111100QQQQQ.  */
{ "dmacwhf", 0x30F70F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmacwhf<.f><.cc> 0,limm,c 0011011011110111F111CCCCCC0QQQQQ.  */
{ "dmacwhf", 0x36F77000, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmacwhf<.f> a,limm,u6 0011011001110111F111uuuuuuAAAAAA.  */
{ "dmacwhf", 0x36777000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmacwhf<.f> 0,limm,u6 0011011001110111F111uuuuuu111110.  */
{ "dmacwhf", 0x3677703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmacwhf<.f><.cc> 0,limm,u6 0011011011110111F111uuuuuu1QQQQQ.  */
{ "dmacwhf", 0x36F77020, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmacwhf<.f> 0,limm,s12 0011011010110111F111ssssssSSSSSS.  */
{ "dmacwhf", 0x36B77000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmacwhf<.f> a,limm,limm 0011011000110111F111111110AAAAAA.  */
{ "dmacwhf", 0x36377F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmacwhf<.f> 0,limm,limm 0011011000110111F111111110111110.  */
{ "dmacwhf", 0x36377FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmacwhf<.f><.cc> 0,limm,limm 0011011011110111F1111111100QQQQQ.  */
{ "dmacwhf", 0x36F77F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmacwhu<.f> a,b,c 00101bbb00110111FBBBCCCCCCAAAAAA.  */
{ "dmacwhu", 0x28370000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, RC }, { C_F }},

/* dmacwhu<.f> 0,b,c 00101bbb00110111FBBBCCCCCC111110.  */
{ "dmacwhu", 0x2837003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, RC }, { C_F }},

/* dmacwhu<.f><.cc> b,b,c 00101bbb11110111FBBBCCCCCC0QQQQQ.  */
{ "dmacwhu", 0x28F70000, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmacwhu<.f> a,b,u6 00101bbb01110111FBBBuuuuuuAAAAAA.  */
{ "dmacwhu", 0x28770000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmacwhu<.f> 0,b,u6 00101bbb01110111FBBBuuuuuu111110.  */
{ "dmacwhu", 0x2877003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmacwhu<.f><.cc> b,b,u6 00101bbb11110111FBBBuuuuuu1QQQQQ.  */
{ "dmacwhu", 0x28F70020, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmacwhu<.f> b,b,s12 00101bbb10110111FBBBssssssSSSSSS.  */
{ "dmacwhu", 0x28B70000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmacwhu<.f> a,limm,c 0010111000110111F111CCCCCCAAAAAA.  */
{ "dmacwhu", 0x2E377000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, RC }, { C_F }},

/* dmacwhu<.f> a,b,limm 00101bbb00110111FBBB111110AAAAAA.  */
{ "dmacwhu", 0x28370F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, LIMM }, { C_F }},

/* dmacwhu<.f> 0,limm,c 0010111000110111F111CCCCCC111110.  */
{ "dmacwhu", 0x2E37703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F }},

/* dmacwhu<.f> 0,b,limm 00101bbb00110111FBBB111110111110.  */
{ "dmacwhu", 0x28370FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, LIMM }, { C_F }},

/* dmacwhu<.f><.cc> b,b,limm 00101bbb11110111FBBB1111100QQQQQ.  */
{ "dmacwhu", 0x28F70F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmacwhu<.f><.cc> 0,limm,c 0010111011110111F111CCCCCC0QQQQQ.  */
{ "dmacwhu", 0x2EF77000, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmacwhu<.f> a,limm,u6 0010111001110111F111uuuuuuAAAAAA.  */
{ "dmacwhu", 0x2E777000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmacwhu<.f> 0,limm,u6 0010111001110111F111uuuuuu111110.  */
{ "dmacwhu", 0x2E77703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmacwhu<.f><.cc> 0,limm,u6 0010111011110111F111uuuuuu1QQQQQ.  */
{ "dmacwhu", 0x2EF77020, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmacwhu<.f> 0,limm,s12 0010111010110111F111ssssssSSSSSS.  */
{ "dmacwhu", 0x2EB77000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmacwhu<.f> a,limm,limm 0010111000110111F111111110AAAAAA.  */
{ "dmacwhu", 0x2E377F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmacwhu<.f> 0,limm,limm 0010111000110111F111111110111110.  */
{ "dmacwhu", 0x2E377FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmacwhu<.f><.cc> 0,limm,limm 0010111011110111F1111111100QQQQQ.  */
{ "dmacwhu", 0x2EF77F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmb  00100011011011110001RRR000111111.  */
{ "dmb", 0x236F103F, 0xFFFFF1FF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { 0 }, { 0 }},

/* dmb u3 00100011011011110001RRRuuu111111.  */
{ "dmb", 0x236F103F, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { UIMM3_23 }, { 0 }},

/* dmpyh<.f> a,b,c 00101bbb00010000FBBBCCCCCCAAAAAA.  */
{ "dmpyh", 0x28100000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, RB, RC }, { C_F }},

/* dmpyh<.f> 0,b,c 00101bbb00010000FBBBCCCCCC111110.  */
{ "dmpyh", 0x2810003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, RB, RC }, { C_F }},

/* dmpyh<.f><.cc> b,b,c 00101bbb11010000FBBBCCCCCC0QQQQQ.  */
{ "dmpyh", 0x28D00000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmpyh<.f> a,b,u6 00101bbb01010000FBBBuuuuuuAAAAAA.  */
{ "dmpyh", 0x28500000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmpyh<.f> 0,b,u6 00101bbb01010000FBBBuuuuuu111110.  */
{ "dmpyh", 0x2850003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmpyh<.f><.cc> b,b,u6 00101bbb11010000FBBBuuuuuu1QQQQQ.  */
{ "dmpyh", 0x28D00020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmpyh<.f> b,b,s12 00101bbb10010000FBBBssssssSSSSSS.  */
{ "dmpyh", 0x28900000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmpyh<.f> a,limm,c 0010111000010000F111CCCCCCAAAAAA.  */
{ "dmpyh", 0x2E107000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, LIMM, RC }, { C_F }},

/* dmpyh<.f> a,b,limm 00101bbb00010000FBBB111110AAAAAA.  */
{ "dmpyh", 0x28100F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, RB, LIMM }, { C_F }},

/* dmpyh<.f> 0,limm,c 0010111000010000F111CCCCCC111110.  */
{ "dmpyh", 0x2E10703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, RC }, { C_F }},

/* dmpyh<.f> 0,b,limm 00101bbb00010000FBBB111110111110.  */
{ "dmpyh", 0x28100FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, RB, LIMM }, { C_F }},

/* dmpyh<.f><.cc> b,b,limm 00101bbb11010000FBBB1111100QQQQQ.  */
{ "dmpyh", 0x28D00F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmpyh<.f><.cc> 0,limm,c 0010111011010000F111CCCCCC0QQQQQ.  */
{ "dmpyh", 0x2ED07000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmpyh<.f> a,limm,u6 0010111001010000F111uuuuuuAAAAAA.  */
{ "dmpyh", 0x2E507000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmpyh<.f> 0,limm,u6 0010111001010000F111uuuuuu111110.  */
{ "dmpyh", 0x2E50703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmpyh<.f><.cc> 0,limm,u6 0010111011010000F111uuuuuu1QQQQQ.  */
{ "dmpyh", 0x2ED07020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmpyh<.f> 0,limm,s12 0010111010010000F111ssssssSSSSSS.  */
{ "dmpyh", 0x2E907000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmpyh<.f> a,limm,limm 0010111000010000F111111110AAAAAA.  */
{ "dmpyh", 0x2E107F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmpyh<.f> 0,limm,limm 0010111000010000F111111110111110.  */
{ "dmpyh", 0x2E107FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmpyh<.f><.cc> 0,limm,limm 0010111011010000F1111111100QQQQQ.  */
{ "dmpyh", 0x2ED07F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmpyhbl<.f> a,b,c 00110bbb00010110FBBBCCCCCCAAAAAA.  */
{ "dmpyhbl", 0x30160000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* dmpyhbl<.f> 0,b,c 00110bbb00010110FBBBCCCCCC111110.  */
{ "dmpyhbl", 0x3016003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* dmpyhbl<.f><.cc> b,b,c 00110bbb11010110FBBBCCCCCC0QQQQQ.  */
{ "dmpyhbl", 0x30D60000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmpyhbl<.f> a,b,u6 00110bbb01010110FBBBuuuuuuAAAAAA.  */
{ "dmpyhbl", 0x30560000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmpyhbl<.f> 0,b,u6 00110bbb01010110FBBBuuuuuu111110.  */
{ "dmpyhbl", 0x3056003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmpyhbl<.f><.cc> b,b,u6 00110bbb11010110FBBBuuuuuu1QQQQQ.  */
{ "dmpyhbl", 0x30D60020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmpyhbl<.f> b,b,s12 00110bbb10010110FBBBssssssSSSSSS.  */
{ "dmpyhbl", 0x30960000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmpyhbl<.f> a,limm,c 0011011000010110F111CCCCCCAAAAAA.  */
{ "dmpyhbl", 0x36167000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* dmpyhbl<.f> a,b,limm 00110bbb00010110FBBB111110AAAAAA.  */
{ "dmpyhbl", 0x30160F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* dmpyhbl<.f> 0,limm,c 0011011000010110F111CCCCCC111110.  */
{ "dmpyhbl", 0x3616703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* dmpyhbl<.f> 0,b,limm 00110bbb00010110FBBB111110111110.  */
{ "dmpyhbl", 0x30160FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* dmpyhbl<.f><.cc> b,b,limm 00110bbb11010110FBBB1111100QQQQQ.  */
{ "dmpyhbl", 0x30D60F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmpyhbl<.f><.cc> 0,limm,c 0011011011010110F111CCCCCC0QQQQQ.  */
{ "dmpyhbl", 0x36D67000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmpyhbl<.f> a,limm,u6 0011011001010110F111uuuuuuAAAAAA.  */
{ "dmpyhbl", 0x36567000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmpyhbl<.f> 0,limm,u6 0011011001010110F111uuuuuu111110.  */
{ "dmpyhbl", 0x3656703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmpyhbl<.f><.cc> 0,limm,u6 0011011011010110F111uuuuuu1QQQQQ.  */
{ "dmpyhbl", 0x36D67020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmpyhbl<.f> 0,limm,s12 0011011010010110F111ssssssSSSSSS.  */
{ "dmpyhbl", 0x36967000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmpyhbl<.f> a,limm,limm 0011011000010110F111111110AAAAAA.  */
{ "dmpyhbl", 0x36167F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmpyhbl<.f> 0,limm,limm 0011011000010110F111111110111110.  */
{ "dmpyhbl", 0x36167FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmpyhbl<.f><.cc> 0,limm,limm 0011011011010110F1111111100QQQQQ.  */
{ "dmpyhbl", 0x36D67F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmpyhbm<.f> a,b,c 00110bbb00010111FBBBCCCCCCAAAAAA.  */
{ "dmpyhbm", 0x30170000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* dmpyhbm<.f> 0,b,c 00110bbb00010111FBBBCCCCCC111110.  */
{ "dmpyhbm", 0x3017003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* dmpyhbm<.f><.cc> b,b,c 00110bbb11010111FBBBCCCCCC0QQQQQ.  */
{ "dmpyhbm", 0x30D70000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmpyhbm<.f> a,b,u6 00110bbb01010111FBBBuuuuuuAAAAAA.  */
{ "dmpyhbm", 0x30570000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmpyhbm<.f> 0,b,u6 00110bbb01010111FBBBuuuuuu111110.  */
{ "dmpyhbm", 0x3057003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmpyhbm<.f><.cc> b,b,u6 00110bbb11010111FBBBuuuuuu1QQQQQ.  */
{ "dmpyhbm", 0x30D70020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmpyhbm<.f> b,b,s12 00110bbb10010111FBBBssssssSSSSSS.  */
{ "dmpyhbm", 0x30970000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmpyhbm<.f> a,limm,c 0011011000010111F111CCCCCCAAAAAA.  */
{ "dmpyhbm", 0x36177000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* dmpyhbm<.f> a,b,limm 00110bbb00010111FBBB111110AAAAAA.  */
{ "dmpyhbm", 0x30170F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* dmpyhbm<.f> 0,limm,c 0011011000010111F111CCCCCC111110.  */
{ "dmpyhbm", 0x3617703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* dmpyhbm<.f> 0,b,limm 00110bbb00010111FBBB111110111110.  */
{ "dmpyhbm", 0x30170FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* dmpyhbm<.f><.cc> b,b,limm 00110bbb11010111FBBB1111100QQQQQ.  */
{ "dmpyhbm", 0x30D70F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmpyhbm<.f><.cc> 0,limm,c 0011011011010111F111CCCCCC0QQQQQ.  */
{ "dmpyhbm", 0x36D77000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmpyhbm<.f> a,limm,u6 0011011001010111F111uuuuuuAAAAAA.  */
{ "dmpyhbm", 0x36577000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmpyhbm<.f> 0,limm,u6 0011011001010111F111uuuuuu111110.  */
{ "dmpyhbm", 0x3657703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmpyhbm<.f><.cc> 0,limm,u6 0011011011010111F111uuuuuu1QQQQQ.  */
{ "dmpyhbm", 0x36D77020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmpyhbm<.f> 0,limm,s12 0011011010010111F111ssssssSSSSSS.  */
{ "dmpyhbm", 0x36977000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmpyhbm<.f> a,limm,limm 0011011000010111F111111110AAAAAA.  */
{ "dmpyhbm", 0x36177F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmpyhbm<.f> 0,limm,limm 0011011000010111F111111110111110.  */
{ "dmpyhbm", 0x36177FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmpyhbm<.f><.cc> 0,limm,limm 0011011011010111F1111111100QQQQQ.  */
{ "dmpyhbm", 0x36D77F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmpyhf<.f> a,b,c 00101bbb00101010FBBBCCCCCCAAAAAA.  */
{ "dmpyhf", 0x282A0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* dmpyhf<.f> 0,b,c 00101bbb00101010FBBBCCCCCC111110.  */
{ "dmpyhf", 0x282A003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* dmpyhf<.f><.cc> b,b,c 00101bbb11101010FBBBCCCCCC0QQQQQ.  */
{ "dmpyhf", 0x28EA0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmpyhf<.f> a,b,u6 00101bbb01101010FBBBuuuuuuAAAAAA.  */
{ "dmpyhf", 0x286A0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmpyhf<.f> 0,b,u6 00101bbb01101010FBBBuuuuuu111110.  */
{ "dmpyhf", 0x286A003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmpyhf<.f><.cc> b,b,u6 00101bbb11101010FBBBuuuuuu1QQQQQ.  */
{ "dmpyhf", 0x28EA0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmpyhf<.f> b,b,s12 00101bbb10101010FBBBssssssSSSSSS.  */
{ "dmpyhf", 0x28AA0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmpyhf<.f> a,limm,c 0010111000101010F111CCCCCCAAAAAA.  */
{ "dmpyhf", 0x2E2A7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* dmpyhf<.f> a,b,limm 00101bbb00101010FBBB111110AAAAAA.  */
{ "dmpyhf", 0x282A0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* dmpyhf<.f> 0,limm,c 0010111001101010F111CCCCCC111110.  */
{ "dmpyhf", 0x2E6A703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* dmpyhf<.f> 0,b,limm 00101bbb00101010FBBB111110111110.  */
{ "dmpyhf", 0x282A0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* dmpyhf<.f><.cc> b,b,limm 00101bbb11101010FBBB1111100QQQQQ.  */
{ "dmpyhf", 0x28EA0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmpyhf<.f><.cc> 0,limm,c 0010111011101010F111CCCCCC0QQQQQ.  */
{ "dmpyhf", 0x2EEA7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmpyhf<.f> a,limm,u6 0010111001101010F111uuuuuuAAAAAA.  */
{ "dmpyhf", 0x2E6A7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmpyhf<.f> 0,limm,u6 0010111001101010F111uuuuuu111110.  */
{ "dmpyhf", 0x2E6A703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmpyhf<.f><.cc> 0,limm,u6 0010111011101010F111uuuuuu1QQQQQ.  */
{ "dmpyhf", 0x2EEA7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmpyhf<.f> 0,limm,s12 0010111010101010F111ssssssSSSSSS.  */
{ "dmpyhf", 0x2EAA7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmpyhf<.f> a,limm,limm 0010111000101010F111111110AAAAAA.  */
{ "dmpyhf", 0x2E2A7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmpyhf<.f> 0,limm,limm 0010111000101010F111111110111110.  */
{ "dmpyhf", 0x2E2A7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmpyhf<.f><.cc> 0,limm,limm 0010111011101010F1111111100QQQQQ.  */
{ "dmpyhf", 0x2EEA7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmpyhfr<.f> a,b,c 00101bbb00101011FBBBCCCCCCAAAAAA.  */
{ "dmpyhfr", 0x282B0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* dmpyhfr<.f> 0,b,c 00101bbb00101011FBBBCCCCCC111110.  */
{ "dmpyhfr", 0x282B003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* dmpyhfr<.f><.cc> b,b,c 00101bbb11101011FBBBCCCCCC0QQQQQ.  */
{ "dmpyhfr", 0x28EB0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmpyhfr<.f> a,b,u6 00101bbb01101011FBBBuuuuuuAAAAAA.  */
{ "dmpyhfr", 0x286B0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmpyhfr<.f> 0,b,u6 00101bbb01101011FBBBuuuuuu111110.  */
{ "dmpyhfr", 0x286B003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmpyhfr<.f><.cc> b,b,u6 00101bbb11101011FBBBuuuuuu1QQQQQ.  */
{ "dmpyhfr", 0x28EB0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmpyhfr<.f> b,b,s12 00101bbb10101011FBBBssssssSSSSSS.  */
{ "dmpyhfr", 0x28AB0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmpyhfr<.f> a,limm,c 0010111000101011F111CCCCCCAAAAAA.  */
{ "dmpyhfr", 0x2E2B7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* dmpyhfr<.f> a,b,limm 00101bbb00101011FBBB111110AAAAAA.  */
{ "dmpyhfr", 0x282B0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* dmpyhfr<.f> 0,limm,c 0010111001101011F111CCCCCC111110.  */
{ "dmpyhfr", 0x2E6B703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* dmpyhfr<.f> 0,b,limm 00101bbb00101011FBBB111110111110.  */
{ "dmpyhfr", 0x282B0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* dmpyhfr<.f><.cc> b,b,limm 00101bbb11101011FBBB1111100QQQQQ.  */
{ "dmpyhfr", 0x28EB0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmpyhfr<.f><.cc> 0,limm,c 0010111011101011F111CCCCCC0QQQQQ.  */
{ "dmpyhfr", 0x2EEB7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmpyhfr<.f> a,limm,u6 0010111001101011F111uuuuuuAAAAAA.  */
{ "dmpyhfr", 0x2E6B7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmpyhfr<.f> 0,limm,u6 0010111001101011F111uuuuuu111110.  */
{ "dmpyhfr", 0x2E6B703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmpyhfr<.f><.cc> 0,limm,u6 0010111011101011F111uuuuuu1QQQQQ.  */
{ "dmpyhfr", 0x2EEB7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmpyhfr<.f> 0,limm,s12 0010111010101011F111ssssssSSSSSS.  */
{ "dmpyhfr", 0x2EAB7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmpyhfr<.f> a,limm,limm 0010111000101011F111111110AAAAAA.  */
{ "dmpyhfr", 0x2E2B7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmpyhfr<.f> 0,limm,limm 0010111000101011F111111110111110.  */
{ "dmpyhfr", 0x2E2B7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmpyhfr<.f><.cc> 0,limm,limm 0010111011101011F1111111100QQQQQ.  */
{ "dmpyhfr", 0x2EEB7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmpyhu<.f> a,b,c 00101bbb00010001FBBBCCCCCCAAAAAA.  */
{ "dmpyhu", 0x28110000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, RB, RC }, { C_F }},

/* dmpyhu<.f> 0,b,c 00101bbb00010001FBBBCCCCCC111110.  */
{ "dmpyhu", 0x2811003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, RB, RC }, { C_F }},

/* dmpyhu<.f><.cc> b,b,c 00101bbb11010001FBBBCCCCCC0QQQQQ.  */
{ "dmpyhu", 0x28D10000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmpyhu<.f> a,b,u6 00101bbb01010001FBBBuuuuuuAAAAAA.  */
{ "dmpyhu", 0x28510000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmpyhu<.f> 0,b,u6 00101bbb01010001FBBBuuuuuu111110.  */
{ "dmpyhu", 0x2851003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmpyhu<.f><.cc> b,b,u6 00101bbb11010001FBBBuuuuuu1QQQQQ.  */
{ "dmpyhu", 0x28D10020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmpyhu<.f> b,b,s12 00101bbb10010001FBBBssssssSSSSSS.  */
{ "dmpyhu", 0x28910000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmpyhu<.f> a,limm,c 0010111000010001F111CCCCCCAAAAAA.  */
{ "dmpyhu", 0x2E117000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, LIMM, RC }, { C_F }},

/* dmpyhu<.f> a,b,limm 00101bbb00010001FBBB111110AAAAAA.  */
{ "dmpyhu", 0x28110F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, RB, LIMM }, { C_F }},

/* dmpyhu<.f> 0,limm,c 0010111000010001F111CCCCCC111110.  */
{ "dmpyhu", 0x2E11703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, RC }, { C_F }},

/* dmpyhu<.f> 0,b,limm 00101bbb00010001FBBB111110111110.  */
{ "dmpyhu", 0x28110FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, RB, LIMM }, { C_F }},

/* dmpyhu<.f><.cc> b,b,limm 00101bbb11010001FBBB1111100QQQQQ.  */
{ "dmpyhu", 0x28D10F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmpyhu<.f><.cc> 0,limm,c 0010111011010001F111CCCCCC0QQQQQ.  */
{ "dmpyhu", 0x2ED17000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmpyhu<.f> a,limm,u6 0010111001010001F111uuuuuuAAAAAA.  */
{ "dmpyhu", 0x2E517000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmpyhu<.f> 0,limm,u6 0010111001010001F111uuuuuu111110.  */
{ "dmpyhu", 0x2E51703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmpyhu<.f><.cc> 0,limm,u6 0010111011010001F111uuuuuu1QQQQQ.  */
{ "dmpyhu", 0x2ED17020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmpyhu<.f> 0,limm,s12 0010111010010001F111ssssssSSSSSS.  */
{ "dmpyhu", 0x2E917000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmpyhu<.f> a,limm,limm 0010111000010001F111111110AAAAAA.  */
{ "dmpyhu", 0x2E117F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmpyhu<.f> 0,limm,limm 0010111000010001F111111110111110.  */
{ "dmpyhu", 0x2E117FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmpyhu<.f><.cc> 0,limm,limm 0010111011010001F1111111100QQQQQ.  */
{ "dmpyhu", 0x2ED17F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmpyhwf<.f> a,b,c 00101bbb00101000FBBBCCCCCCAAAAAA.  */
{ "dmpyhwf", 0x28280000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* dmpyhwf<.f> 0,b,c 00101bbb00101000FBBBCCCCCC111110.  */
{ "dmpyhwf", 0x2828003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* dmpyhwf<.f><.cc> b,b,c 00101bbb11101000FBBBCCCCCC0QQQQQ.  */
{ "dmpyhwf", 0x28E80000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmpyhwf<.f> a,b,u6 00101bbb01101000FBBBuuuuuuAAAAAA.  */
{ "dmpyhwf", 0x28680000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmpyhwf<.f> 0,b,u6 00101bbb01101000FBBBuuuuuu111110.  */
{ "dmpyhwf", 0x2868003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmpyhwf<.f><.cc> b,b,u6 00101bbb11101000FBBBuuuuuu1QQQQQ.  */
{ "dmpyhwf", 0x28E80020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmpyhwf<.f> b,b,s12 00101bbb10101000FBBBssssssSSSSSS.  */
{ "dmpyhwf", 0x28A80000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmpyhwf<.f> a,limm,c 0010111000101000F111CCCCCCAAAAAA.  */
{ "dmpyhwf", 0x2E287000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* dmpyhwf<.f> a,b,limm 00101bbb00101000FBBB111110AAAAAA.  */
{ "dmpyhwf", 0x28280F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* dmpyhwf<.f> 0,limm,c 0010111001101000F111CCCCCC111110.  */
{ "dmpyhwf", 0x2E68703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* dmpyhwf<.f> 0,b,limm 00101bbb00101000FBBB111110111110.  */
{ "dmpyhwf", 0x28280FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* dmpyhwf<.f><.cc> b,b,limm 00101bbb11101000FBBB1111100QQQQQ.  */
{ "dmpyhwf", 0x28E80F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmpyhwf<.f><.cc> 0,limm,c 0010111011101000F111CCCCCC0QQQQQ.  */
{ "dmpyhwf", 0x2EE87000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmpyhwf<.f> a,limm,u6 0010111001101000F111uuuuuuAAAAAA.  */
{ "dmpyhwf", 0x2E687000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmpyhwf<.f> 0,limm,u6 0010111001101000F111uuuuuu111110.  */
{ "dmpyhwf", 0x2E68703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmpyhwf<.f><.cc> 0,limm,u6 0010111011101000F111uuuuuu1QQQQQ.  */
{ "dmpyhwf", 0x2EE87020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmpyhwf<.f> 0,limm,s12 0010111010101000F111ssssssSSSSSS.  */
{ "dmpyhwf", 0x2EA87000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmpyhwf<.f> a,limm,limm 0010111000101000F111111110AAAAAA.  */
{ "dmpyhwf", 0x2E287F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmpyhwf<.f> 0,limm,limm 0010111000101000F111111110111110.  */
{ "dmpyhwf", 0x2E287FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmpyhwf<.f><.cc> 0,limm,limm 0010111011101000F1111111100QQQQQ.  */
{ "dmpyhwf", 0x2EE87F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmpywh<.f> a,b,c 00101bbb00110010FBBBCCCCCCAAAAAA.  */
{ "dmpywh", 0x28320000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, RC }, { C_F }},

/* dmpywh<.f> 0,b,c 00101bbb00110010FBBBCCCCCC111110.  */
{ "dmpywh", 0x2832003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, RC }, { C_F }},

/* dmpywh<.f><.cc> b,b,c 00101bbb11110010FBBBCCCCCC0QQQQQ.  */
{ "dmpywh", 0x28F20000, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmpywh<.f> a,b,u6 00101bbb01110010FBBBuuuuuuAAAAAA.  */
{ "dmpywh", 0x28720000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmpywh<.f> 0,b,u6 00101bbb01110010FBBBuuuuuu111110.  */
{ "dmpywh", 0x2872003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmpywh<.f><.cc> b,b,u6 00101bbb11110010FBBBuuuuuu1QQQQQ.  */
{ "dmpywh", 0x28F20020, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmpywh<.f> b,b,s12 00101bbb10110010FBBBssssssSSSSSS.  */
{ "dmpywh", 0x28B20000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmpywh<.f> a,limm,c 0010111000110010F111CCCCCCAAAAAA.  */
{ "dmpywh", 0x2E327000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, RC }, { C_F }},

/* dmpywh<.f> a,b,limm 00101bbb00110010FBBB111110AAAAAA.  */
{ "dmpywh", 0x28320F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, LIMM }, { C_F }},

/* dmpywh<.f> 0,limm,c 0010111000110010F111CCCCCC111110.  */
{ "dmpywh", 0x2E32703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F }},

/* dmpywh<.f> 0,b,limm 00101bbb00110010FBBB111110111110.  */
{ "dmpywh", 0x28320FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, LIMM }, { C_F }},

/* dmpywh<.f><.cc> b,b,limm 00101bbb11110010FBBB1111100QQQQQ.  */
{ "dmpywh", 0x28F20F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmpywh<.f><.cc> 0,limm,c 0010111011110010F111CCCCCC0QQQQQ.  */
{ "dmpywh", 0x2EF27000, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmpywh<.f> a,limm,u6 0010111001110010F111uuuuuuAAAAAA.  */
{ "dmpywh", 0x2E727000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmpywh<.f> 0,limm,u6 0010111001110010F111uuuuuu111110.  */
{ "dmpywh", 0x2E72703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmpywh<.f><.cc> 0,limm,u6 0010111011110010F111uuuuuu1QQQQQ.  */
{ "dmpywh", 0x2EF27020, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmpywh<.f> 0,limm,s12 0010111010110010F111ssssssSSSSSS.  */
{ "dmpywh", 0x2EB27000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmpywh<.f> a,limm,limm 0010111000110010F111111110AAAAAA.  */
{ "dmpywh", 0x2E327F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmpywh<.f> 0,limm,limm 0010111000110010F111111110111110.  */
{ "dmpywh", 0x2E327FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmpywh<.f><.cc> 0,limm,limm 0010111011110010F1111111100QQQQQ.  */
{ "dmpywh", 0x2EF27F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmpywhf<.f> a,b,c 00110bbb00110011FBBBCCCCCCAAAAAA.  */
{ "dmpywhf", 0x30330000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, RC }, { C_F }},

/* dmpywhf<.f> 0,b,c 00110bbb00110011FBBBCCCCCC111110.  */
{ "dmpywhf", 0x3033003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, RC }, { C_F }},

/* dmpywhf<.f><.cc> b,b,c 00110bbb11110011FBBBCCCCCC0QQQQQ.  */
{ "dmpywhf", 0x30F30000, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmpywhf<.f> a,b,u6 00110bbb01110011FBBBuuuuuuAAAAAA.  */
{ "dmpywhf", 0x30730000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmpywhf<.f> 0,b,u6 00110bbb01110011FBBBuuuuuu111110.  */
{ "dmpywhf", 0x3073003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmpywhf<.f><.cc> b,b,u6 00110bbb11110011FBBBuuuuuu1QQQQQ.  */
{ "dmpywhf", 0x30F30020, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmpywhf<.f> b,b,s12 00110bbb10110011FBBBssssssSSSSSS.  */
{ "dmpywhf", 0x30B30000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmpywhf<.f> a,limm,c 0011011000110011F111CCCCCCAAAAAA.  */
{ "dmpywhf", 0x36337000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, RC }, { C_F }},

/* dmpywhf<.f> a,b,limm 00110bbb00110011FBBB111110AAAAAA.  */
{ "dmpywhf", 0x30330F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, LIMM }, { C_F }},

/* dmpywhf<.f> 0,limm,c 0011011000110011F111CCCCCC111110.  */
{ "dmpywhf", 0x3633703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F }},

/* dmpywhf<.f> 0,b,limm 00110bbb00110011FBBB111110111110.  */
{ "dmpywhf", 0x30330FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, LIMM }, { C_F }},

/* dmpywhf<.f><.cc> b,b,limm 00110bbb11110011FBBB1111100QQQQQ.  */
{ "dmpywhf", 0x30F30F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmpywhf<.f><.cc> 0,limm,c 0011011011110011F111CCCCCC0QQQQQ.  */
{ "dmpywhf", 0x36F37000, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmpywhf<.f> a,limm,u6 0011011001110011F111uuuuuuAAAAAA.  */
{ "dmpywhf", 0x36737000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmpywhf<.f> 0,limm,u6 0011011001110011F111uuuuuu111110.  */
{ "dmpywhf", 0x3673703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmpywhf<.f><.cc> 0,limm,u6 0011011011110011F111uuuuuu1QQQQQ.  */
{ "dmpywhf", 0x36F37020, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmpywhf<.f> 0,limm,s12 0011011010110011F111ssssssSSSSSS.  */
{ "dmpywhf", 0x36B37000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmpywhf<.f> a,limm,limm 0011011000110011F111111110AAAAAA.  */
{ "dmpywhf", 0x36337F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmpywhf<.f> 0,limm,limm 0011011000110011F111111110111110.  */
{ "dmpywhf", 0x36337FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmpywhf<.f><.cc> 0,limm,limm 0011011011110011F1111111100QQQQQ.  */
{ "dmpywhf", 0x36F37F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmpywhu<.f> a,b,c 00101bbb00110011FBBBCCCCCCAAAAAA.  */
{ "dmpywhu", 0x28330000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, RC }, { C_F }},

/* dmpywhu<.f> 0,b,c 00101bbb00110011FBBBCCCCCC111110.  */
{ "dmpywhu", 0x2833003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, RC }, { C_F }},

/* dmpywhu<.f><.cc> b,b,c 00101bbb11110011FBBBCCCCCC0QQQQQ.  */
{ "dmpywhu", 0x28F30000, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmpywhu<.f> a,b,u6 00101bbb01110011FBBBuuuuuuAAAAAA.  */
{ "dmpywhu", 0x28730000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmpywhu<.f> 0,b,u6 00101bbb01110011FBBBuuuuuu111110.  */
{ "dmpywhu", 0x2873003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmpywhu<.f><.cc> b,b,u6 00101bbb11110011FBBBuuuuuu1QQQQQ.  */
{ "dmpywhu", 0x28F30020, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmpywhu<.f> b,b,s12 00101bbb10110011FBBBssssssSSSSSS.  */
{ "dmpywhu", 0x28B30000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmpywhu<.f> a,limm,c 0010111000110011F111CCCCCCAAAAAA.  */
{ "dmpywhu", 0x2E337000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, RC }, { C_F }},

/* dmpywhu<.f> a,b,limm 00101bbb00110011FBBB111110AAAAAA.  */
{ "dmpywhu", 0x28330F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, LIMM }, { C_F }},

/* dmpywhu<.f> 0,limm,c 0010111000110011F111CCCCCC111110.  */
{ "dmpywhu", 0x2E33703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F }},

/* dmpywhu<.f> 0,b,limm 00101bbb00110011FBBB111110111110.  */
{ "dmpywhu", 0x28330FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, LIMM }, { C_F }},

/* dmpywhu<.f><.cc> b,b,limm 00101bbb11110011FBBB1111100QQQQQ.  */
{ "dmpywhu", 0x28F30F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmpywhu<.f><.cc> 0,limm,c 0010111011110011F111CCCCCC0QQQQQ.  */
{ "dmpywhu", 0x2EF37000, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmpywhu<.f> a,limm,u6 0010111001110011F111uuuuuuAAAAAA.  */
{ "dmpywhu", 0x2E737000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmpywhu<.f> 0,limm,u6 0010111001110011F111uuuuuu111110.  */
{ "dmpywhu", 0x2E73703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmpywhu<.f><.cc> 0,limm,u6 0010111011110011F111uuuuuu1QQQQQ.  */
{ "dmpywhu", 0x2EF37020, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmpywhu<.f> 0,limm,s12 0010111010110011F111ssssssSSSSSS.  */
{ "dmpywhu", 0x2EB37000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmpywhu<.f> a,limm,limm 0010111000110011F111111110AAAAAA.  */
{ "dmpywhu", 0x2E337F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmpywhu<.f> 0,limm,limm 0010111000110011F111111110111110.  */
{ "dmpywhu", 0x2E337FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmpywhu<.f><.cc> 0,limm,limm 0010111011110011F1111111100QQQQQ.  */
{ "dmpywhu", 0x2EF37F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmulh11<.f> a,b,c 00110bbb00001000FBBBCCCCCCAAAAAA.  */
{ "dmulh11", 0x30080000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, RC }, { C_F }},

/* dmulh11<.f> 0,b,c 00110bbb00001000FBBBCCCCCC111110.  */
{ "dmulh11", 0x3008003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, RC }, { C_F }},

/* dmulh11<.f><.cc> b,b,c 00110bbb11001000FBBBCCCCCC0QQQQQ.  */
{ "dmulh11", 0x30C80000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, RC }, { C_F, C_CC }},

/* dmulh11<.f> a,b,c 00110bbb00110000FBBBCCCCCCAAAAAA.  */
{ "dmulh11", 0x30300000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, RC }, { C_F }},

/* dmulh11<.f> 0,b,c 00110bbb00110000FBBBCCCCCC111110.  */
{ "dmulh11", 0x3030003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, RC }, { C_F }},

/* dmulh11<.f><.cc> b,b,c 00110bbb11110000FBBBCCCCCC0QQQQQ.  */
{ "dmulh11", 0x30F00000, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, RC }, { C_F, C_CC }},

/* dmulh11<.f> a,b,u6 00110bbb01001000FBBBuuuuuuAAAAAA.  */
{ "dmulh11", 0x30480000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, UIMM6_20 }, { C_F }},

/* dmulh11<.f> 0,b,u6 00110bbb01001000FBBBuuuuuu111110.  */
{ "dmulh11", 0x3048003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmulh11<.f><.cc> b,b,u6 00110bbb11001000FBBBuuuuuu1QQQQQ.  */
{ "dmulh11", 0x30C80020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmulh11<.f> a,b,u6 00110bbb01110000FBBBuuuuuuAAAAAA.  */
{ "dmulh11", 0x30700000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, UIMM6_20 }, { C_F }},

/* dmulh11<.f> 0,b,u6 00110bbb01110000FBBBuuuuuu111110.  */
{ "dmulh11", 0x3070003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmulh11<.f><.cc> b,b,u6 00110bbb11110000FBBBuuuuuu1QQQQQ.  */
{ "dmulh11", 0x30F00020, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmulh11<.f> b,b,s12 00110bbb10001000FBBBssssssSSSSSS.  */
{ "dmulh11", 0x30880000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, SIMM12_20 }, { C_F }},

/* dmulh11<.f> b,b,s12 00110bbb10110000FBBBssssssSSSSSS.  */
{ "dmulh11", 0x30B00000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, SIMM12_20 }, { C_F }},

/* dmulh11<.f> a,limm,c 0011011000001000F111CCCCCCAAAAAA.  */
{ "dmulh11", 0x36087000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, RC }, { C_F }},

/* dmulh11<.f> a,b,limm 00110bbb00001000FBBB111110AAAAAA.  */
{ "dmulh11", 0x30080F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, LIMM }, { C_F }},

/* dmulh11<.f> 0,limm,c 0011011000001000F111CCCCCC111110.  */
{ "dmulh11", 0x3608703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F }},

/* dmulh11<.f> 0,b,limm 00110bbb00001000FBBB111110111110.  */
{ "dmulh11", 0x30080FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, LIMM }, { C_F }},

/* dmulh11<.f><.cc> 0,limm,c 0011011011001000F111CCCCCC0QQQQQ.  */
{ "dmulh11", 0x36C87000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmulh11<.f><.cc> b,b,limm 00110bbb11001000FBBB1111100QQQQQ.  */
{ "dmulh11", 0x30C80F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* dmulh11<.f> a,limm,c 0011011000110000F111CCCCCCAAAAAA.  */
{ "dmulh11", 0x36307000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, RC }, { C_F }},

/* dmulh11<.f> a,b,limm 00110bbb00110000FBBB111110AAAAAA.  */
{ "dmulh11", 0x30300F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, LIMM }, { C_F }},

/* dmulh11<.f> 0,limm,c 0011011000110000F111CCCCCC111110.  */
{ "dmulh11", 0x3630703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F }},

/* dmulh11<.f> 0,b,limm 00110bbb00110000FBBB111110111110.  */
{ "dmulh11", 0x30300FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, LIMM }, { C_F }},

/* dmulh11<.f><.cc> 0,limm,c 0011011011110000F111CCCCCC0QQQQQ.  */
{ "dmulh11", 0x36F07000, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmulh11<.f><.cc> b,b,limm 00110bbb11110000FBBB1111100QQQQQ.  */
{ "dmulh11", 0x30F00F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* dmulh11<.f> a,limm,u6 0011011001001000F111uuuuuuAAAAAA.  */
{ "dmulh11", 0x36487000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, UIMM6_20 }, { C_F }},

/* dmulh11<.f> 0,limm,u6 0011011001001000F111uuuuuu111110.  */
{ "dmulh11", 0x3648703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmulh11<.f><.cc> 0,limm,u6 0011011011001000F111uuuuuu1QQQQQ.  */
{ "dmulh11", 0x36C87020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmulh11<.f> a,limm,u6 0011011001110000F111uuuuuuAAAAAA.  */
{ "dmulh11", 0x36707000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, UIMM6_20 }, { C_F }},

/* dmulh11<.f> 0,limm,u6 0011011001110000F111uuuuuu111110.  */
{ "dmulh11", 0x3670703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmulh11<.f><.cc> 0,limm,u6 0011011011110000F111uuuuuu1QQQQQ.  */
{ "dmulh11", 0x36F07020, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmulh11<.f> 0,limm,s12 0011011010001000F111ssssssSSSSSS.  */
{ "dmulh11", 0x36887000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmulh11<.f> 0,limm,s12 0011011010110000F111ssssssSSSSSS.  */
{ "dmulh11", 0x36B07000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmulh11<.f> a,limm,limm 0011011000001000F111111110AAAAAA.  */
{ "dmulh11", 0x36087F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, LIMMdup }, { C_F }},

/* dmulh11<.f> 0,limm,limm 0011011000001000F111111110111110.  */
{ "dmulh11", 0x36087FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmulh11<.f><.cc> 0,limm,limm 0011011011001000F1111111100QQQQQ.  */
{ "dmulh11", 0x36C87F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmulh11<.f> a,limm,limm 0011011000110000F111111110AAAAAA.  */
{ "dmulh11", 0x36307F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, LIMMdup }, { C_F }},

/* dmulh11<.f> 0,limm,limm 0011011000110000F111111110111110.  */
{ "dmulh11", 0x36307FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmulh11<.f><.cc> 0,limm,limm 0011011011110000F1111111100QQQQQ.  */
{ "dmulh11", 0x36F07F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmulh12<.f> a,b,c 00110bbb00001001FBBBCCCCCCAAAAAA.  */
{ "dmulh12", 0x30090000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, RC }, { C_F }},

/* dmulh12<.f> 0,b,c 00110bbb00001001FBBBCCCCCC111110.  */
{ "dmulh12", 0x3009003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, RC }, { C_F }},

/* dmulh12<.f><.cc> b,b,c 00110bbb11001001FBBBCCCCCC0QQQQQ.  */
{ "dmulh12", 0x30C90000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, RC }, { C_F, C_CC }},

/* dmulh12<.f> a,b,c 00110bbb00110001FBBBCCCCCCAAAAAA.  */
{ "dmulh12", 0x30310000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, RC }, { C_F }},

/* dmulh12<.f> 0,b,c 00110bbb00110001FBBBCCCCCC111110.  */
{ "dmulh12", 0x3031003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, RC }, { C_F }},

/* dmulh12<.f><.cc> b,b,c 00110bbb11110001FBBBCCCCCC0QQQQQ.  */
{ "dmulh12", 0x30F10000, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, RC }, { C_F, C_CC }},

/* dmulh12<.f> a,b,u6 00110bbb01001001FBBBuuuuuuAAAAAA.  */
{ "dmulh12", 0x30490000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, UIMM6_20 }, { C_F }},

/* dmulh12<.f> 0,b,u6 00110bbb01001001FBBBuuuuuu111110.  */
{ "dmulh12", 0x3049003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmulh12<.f><.cc> b,b,u6 00110bbb11001001FBBBuuuuuu1QQQQQ.  */
{ "dmulh12", 0x30C90020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmulh12<.f> a,b,u6 00110bbb01110001FBBBuuuuuuAAAAAA.  */
{ "dmulh12", 0x30710000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, UIMM6_20 }, { C_F }},

/* dmulh12<.f> 0,b,u6 00110bbb01110001FBBBuuuuuu111110.  */
{ "dmulh12", 0x3071003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmulh12<.f><.cc> b,b,u6 00110bbb11110001FBBBuuuuuu1QQQQQ.  */
{ "dmulh12", 0x30F10020, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmulh12<.f> b,b,s12 00110bbb10001001FBBBssssssSSSSSS.  */
{ "dmulh12", 0x30890000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, SIMM12_20 }, { C_F }},

/* dmulh12<.f> b,b,s12 00110bbb10110001FBBBssssssSSSSSS.  */
{ "dmulh12", 0x30B10000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, SIMM12_20 }, { C_F }},

/* dmulh12<.f> a,limm,c 0011011000001001F111CCCCCCAAAAAA.  */
{ "dmulh12", 0x36097000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, RC }, { C_F }},

/* dmulh12<.f> a,b,limm 00110bbb00001001FBBB111110AAAAAA.  */
{ "dmulh12", 0x30090F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, LIMM }, { C_F }},

/* dmulh12<.f> 0,limm,c 0011011000001001F111CCCCCC111110.  */
{ "dmulh12", 0x3609703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F }},

/* dmulh12<.f> 0,b,limm 00110bbb00001001FBBB111110111110.  */
{ "dmulh12", 0x30090FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, LIMM }, { C_F }},

/* dmulh12<.f><.cc> 0,limm,c 0011011011001001F111CCCCCC0QQQQQ.  */
{ "dmulh12", 0x36C97000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmulh12<.f><.cc> b,b,limm 00110bbb11001001FBBB1111100QQQQQ.  */
{ "dmulh12", 0x30C90F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* dmulh12<.f> a,limm,c 0011011000110001F111CCCCCCAAAAAA.  */
{ "dmulh12", 0x36317000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, RC }, { C_F }},

/* dmulh12<.f> a,b,limm 00110bbb00110001FBBB111110AAAAAA.  */
{ "dmulh12", 0x30310F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, LIMM }, { C_F }},

/* dmulh12<.f> 0,limm,c 0011011000110001F111CCCCCC111110.  */
{ "dmulh12", 0x3631703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F }},

/* dmulh12<.f> 0,b,limm 00110bbb00110001FBBB111110111110.  */
{ "dmulh12", 0x30310FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, LIMM }, { C_F }},

/* dmulh12<.f><.cc> 0,limm,c 0011011011110001F111CCCCCC0QQQQQ.  */
{ "dmulh12", 0x36F17000, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmulh12<.f><.cc> b,b,limm 00110bbb11110001FBBB1111100QQQQQ.  */
{ "dmulh12", 0x30F10F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* dmulh12<.f> a,limm,u6 0011011001001001F111uuuuuuAAAAAA.  */
{ "dmulh12", 0x36497000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, UIMM6_20 }, { C_F }},

/* dmulh12<.f> 0,limm,u6 0011011001001001F111uuuuuu111110.  */
{ "dmulh12", 0x3649703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmulh12<.f><.cc> 0,limm,u6 0011011011001001F111uuuuuu1QQQQQ.  */
{ "dmulh12", 0x36C97020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmulh12<.f> a,limm,u6 0011011001110001F111uuuuuuAAAAAA.  */
{ "dmulh12", 0x36717000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, UIMM6_20 }, { C_F }},

/* dmulh12<.f> 0,limm,u6 0011011001110001F111uuuuuu111110.  */
{ "dmulh12", 0x3671703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmulh12<.f><.cc> 0,limm,u6 0011011011110001F111uuuuuu1QQQQQ.  */
{ "dmulh12", 0x36F17020, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmulh12<.f> 0,limm,s12 0011011010001001F111ssssssSSSSSS.  */
{ "dmulh12", 0x36897000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmulh12<.f> 0,limm,s12 0011011010110001F111ssssssSSSSSS.  */
{ "dmulh12", 0x36B17000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmulh12<.f> a,limm,limm 0011011000001001F111111110AAAAAA.  */
{ "dmulh12", 0x36097F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, LIMMdup }, { C_F }},

/* dmulh12<.f> 0,limm,limm 0011011000001001F111111110111110.  */
{ "dmulh12", 0x36097FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmulh12<.f><.cc> 0,limm,limm 0011011011001001F1111111100QQQQQ.  */
{ "dmulh12", 0x36C97F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmulh12<.f> a,limm,limm 0011011000110001F111111110AAAAAA.  */
{ "dmulh12", 0x36317F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, LIMMdup }, { C_F }},

/* dmulh12<.f> 0,limm,limm 0011011000110001F111111110111110.  */
{ "dmulh12", 0x36317FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmulh12<.f><.cc> 0,limm,limm 0011011011110001F1111111100QQQQQ.  */
{ "dmulh12", 0x36F17F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmulh21<.f> a,b,c 00110bbb00001010FBBBCCCCCCAAAAAA.  */
{ "dmulh21", 0x300A0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, RC }, { C_F }},

/* dmulh21<.f> 0,b,c 00110bbb00001010FBBBCCCCCC111110.  */
{ "dmulh21", 0x300A003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, RC }, { C_F }},

/* dmulh21<.f><.cc> b,b,c 00110bbb11001010FBBBCCCCCC0QQQQQ.  */
{ "dmulh21", 0x30CA0000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, RC }, { C_F, C_CC }},

/* dmulh21<.f> a,b,c 00110bbb00110010FBBBCCCCCCAAAAAA.  */
{ "dmulh21", 0x30320000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, RC }, { C_F }},

/* dmulh21<.f> 0,b,c 00110bbb00110010FBBBCCCCCC111110.  */
{ "dmulh21", 0x3032003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, RC }, { C_F }},

/* dmulh21<.f><.cc> b,b,c 00110bbb11110010FBBBCCCCCC0QQQQQ.  */
{ "dmulh21", 0x30F20000, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, RC }, { C_F, C_CC }},

/* dmulh21<.f> a,b,u6 00110bbb01001010FBBBuuuuuuAAAAAA.  */
{ "dmulh21", 0x304A0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, UIMM6_20 }, { C_F }},

/* dmulh21<.f> 0,b,u6 00110bbb01001010FBBBuuuuuu111110.  */
{ "dmulh21", 0x304A003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmulh21<.f><.cc> b,b,u6 00110bbb11001010FBBBuuuuuu1QQQQQ.  */
{ "dmulh21", 0x30CA0020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmulh21<.f> a,b,u6 00110bbb01110010FBBBuuuuuuAAAAAA.  */
{ "dmulh21", 0x30720000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, UIMM6_20 }, { C_F }},

/* dmulh21<.f> 0,b,u6 00110bbb01110010FBBBuuuuuu111110.  */
{ "dmulh21", 0x3072003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmulh21<.f><.cc> b,b,u6 00110bbb11110010FBBBuuuuuu1QQQQQ.  */
{ "dmulh21", 0x30F20020, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmulh21<.f> b,b,s12 00110bbb10001010FBBBssssssSSSSSS.  */
{ "dmulh21", 0x308A0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, SIMM12_20 }, { C_F }},

/* dmulh21<.f> b,b,s12 00110bbb10110010FBBBssssssSSSSSS.  */
{ "dmulh21", 0x30B20000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, SIMM12_20 }, { C_F }},

/* dmulh21<.f> a,limm,c 0011011000001010F111CCCCCCAAAAAA.  */
{ "dmulh21", 0x360A7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, RC }, { C_F }},

/* dmulh21<.f> a,b,limm 00110bbb00001010FBBB111110AAAAAA.  */
{ "dmulh21", 0x300A0F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, LIMM }, { C_F }},

/* dmulh21<.f> 0,limm,c 0011011000001010F111CCCCCC111110.  */
{ "dmulh21", 0x360A703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F }},

/* dmulh21<.f> 0,b,limm 00110bbb00001010FBBB111110111110.  */
{ "dmulh21", 0x300A0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, LIMM }, { C_F }},

/* dmulh21<.f><.cc> 0,limm,c 0011011011001010F111CCCCCC0QQQQQ.  */
{ "dmulh21", 0x36CA7000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmulh21<.f><.cc> b,b,limm 00110bbb11001010FBBB1111100QQQQQ.  */
{ "dmulh21", 0x30CA0F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* dmulh21<.f> a,limm,c 0011011000110010F111CCCCCCAAAAAA.  */
{ "dmulh21", 0x36327000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, RC }, { C_F }},

/* dmulh21<.f> a,b,limm 00110bbb00110010FBBB111110AAAAAA.  */
{ "dmulh21", 0x30320F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, LIMM }, { C_F }},

/* dmulh21<.f> 0,limm,c 0011011000110010F111CCCCCC111110.  */
{ "dmulh21", 0x3632703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F }},

/* dmulh21<.f> 0,b,limm 00110bbb00110010FBBB111110111110.  */
{ "dmulh21", 0x30320FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, LIMM }, { C_F }},

/* dmulh21<.f><.cc> 0,limm,c 0011011011110010F111CCCCCC0QQQQQ.  */
{ "dmulh21", 0x36F27000, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmulh21<.f><.cc> b,b,limm 00110bbb11110010FBBB1111100QQQQQ.  */
{ "dmulh21", 0x30F20F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* dmulh21<.f> a,limm,u6 0011011001001010F111uuuuuuAAAAAA.  */
{ "dmulh21", 0x364A7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, UIMM6_20 }, { C_F }},

/* dmulh21<.f> 0,limm,u6 0011011001001010F111uuuuuu111110.  */
{ "dmulh21", 0x364A703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmulh21<.f><.cc> 0,limm,u6 0011011011001010F111uuuuuu1QQQQQ.  */
{ "dmulh21", 0x36CA7020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmulh21<.f> a,limm,u6 0011011001110010F111uuuuuuAAAAAA.  */
{ "dmulh21", 0x36727000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, UIMM6_20 }, { C_F }},

/* dmulh21<.f> 0,limm,u6 0011011001110010F111uuuuuu111110.  */
{ "dmulh21", 0x3672703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmulh21<.f><.cc> 0,limm,u6 0011011011110010F111uuuuuu1QQQQQ.  */
{ "dmulh21", 0x36F27020, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmulh21<.f> 0,limm,s12 0011011010001010F111ssssssSSSSSS.  */
{ "dmulh21", 0x368A7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmulh21<.f> 0,limm,s12 0011011010110010F111ssssssSSSSSS.  */
{ "dmulh21", 0x36B27000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmulh21<.f> a,limm,limm 0011011000001010F111111110AAAAAA.  */
{ "dmulh21", 0x360A7F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, LIMMdup }, { C_F }},

/* dmulh21<.f> 0,limm,limm 0011011000001010F111111110111110.  */
{ "dmulh21", 0x360A7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmulh21<.f><.cc> 0,limm,limm 0011011011001010F1111111100QQQQQ.  */
{ "dmulh21", 0x36CA7F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmulh21<.f> a,limm,limm 0011011000110010F111111110AAAAAA.  */
{ "dmulh21", 0x36327F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, LIMMdup }, { C_F }},

/* dmulh21<.f> 0,limm,limm 0011011000110010F111111110111110.  */
{ "dmulh21", 0x36327FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmulh21<.f><.cc> 0,limm,limm 0011011011110010F1111111100QQQQQ.  */
{ "dmulh21", 0x36F27F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmulh22<.f> a,b,c 00110bbb00001011FBBBCCCCCCAAAAAA.  */
{ "dmulh22", 0x300B0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, RC }, { C_F }},

/* dmulh22<.f> 0,b,c 00110bbb00001011FBBBCCCCCC111110.  */
{ "dmulh22", 0x300B003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, RC }, { C_F }},

/* dmulh22<.f><.cc> b,b,c 00110bbb11001011FBBBCCCCCC0QQQQQ.  */
{ "dmulh22", 0x30CB0000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, RC }, { C_F, C_CC }},

/* dmulh22<.f> a,b,c 00110bbb00110011FBBBCCCCCCAAAAAA.  */
{ "dmulh22", 0x30330000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, RC }, { C_F }},

/* dmulh22<.f> 0,b,c 00110bbb00110011FBBBCCCCCC111110.  */
{ "dmulh22", 0x3033003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, RC }, { C_F }},

/* dmulh22<.f><.cc> b,b,c 00110bbb11110011FBBBCCCCCC0QQQQQ.  */
{ "dmulh22", 0x30F30000, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, RC }, { C_F, C_CC }},

/* dmulh22<.f> a,b,u6 00110bbb01001011FBBBuuuuuuAAAAAA.  */
{ "dmulh22", 0x304B0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, UIMM6_20 }, { C_F }},

/* dmulh22<.f> 0,b,u6 00110bbb01001011FBBBuuuuuu111110.  */
{ "dmulh22", 0x304B003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmulh22<.f><.cc> b,b,u6 00110bbb11001011FBBBuuuuuu1QQQQQ.  */
{ "dmulh22", 0x30CB0020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmulh22<.f> a,b,u6 00110bbb01110011FBBBuuuuuuAAAAAA.  */
{ "dmulh22", 0x30730000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, UIMM6_20 }, { C_F }},

/* dmulh22<.f> 0,b,u6 00110bbb01110011FBBBuuuuuu111110.  */
{ "dmulh22", 0x3073003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmulh22<.f><.cc> b,b,u6 00110bbb11110011FBBBuuuuuu1QQQQQ.  */
{ "dmulh22", 0x30F30020, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmulh22<.f> b,b,s12 00110bbb10001011FBBBssssssSSSSSS.  */
{ "dmulh22", 0x308B0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, SIMM12_20 }, { C_F }},

/* dmulh22<.f> b,b,s12 00110bbb10110011FBBBssssssSSSSSS.  */
{ "dmulh22", 0x30B30000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, SIMM12_20 }, { C_F }},

/* dmulh22<.f> a,limm,c 0011011000001011F111CCCCCCAAAAAA.  */
{ "dmulh22", 0x360B7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, RC }, { C_F }},

/* dmulh22<.f> a,b,limm 00110bbb00001011FBBB111110AAAAAA.  */
{ "dmulh22", 0x300B0F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, LIMM }, { C_F }},

/* dmulh22<.f> 0,limm,c 0011011000001011F111CCCCCC111110.  */
{ "dmulh22", 0x360B703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F }},

/* dmulh22<.f> 0,b,limm 00110bbb00001011FBBB111110111110.  */
{ "dmulh22", 0x300B0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, LIMM }, { C_F }},

/* dmulh22<.f><.cc> 0,limm,c 0011011011001011F111CCCCCC0QQQQQ.  */
{ "dmulh22", 0x36CB7000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmulh22<.f><.cc> b,b,limm 00110bbb11001011FBBB1111100QQQQQ.  */
{ "dmulh22", 0x30CB0F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* dmulh22<.f> a,limm,c 0011011000110011F111CCCCCCAAAAAA.  */
{ "dmulh22", 0x36337000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, RC }, { C_F }},

/* dmulh22<.f> a,b,limm 00110bbb00110011FBBB111110AAAAAA.  */
{ "dmulh22", 0x30330F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, LIMM }, { C_F }},

/* dmulh22<.f> 0,limm,c 0011011000110011F111CCCCCC111110.  */
{ "dmulh22", 0x3633703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F }},

/* dmulh22<.f> 0,b,limm 00110bbb00110011FBBB111110111110.  */
{ "dmulh22", 0x30330FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, LIMM }, { C_F }},

/* dmulh22<.f><.cc> 0,limm,c 0011011011110011F111CCCCCC0QQQQQ.  */
{ "dmulh22", 0x36F37000, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmulh22<.f><.cc> b,b,limm 00110bbb11110011FBBB1111100QQQQQ.  */
{ "dmulh22", 0x30F30F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* dmulh22<.f> a,limm,u6 0011011001001011F111uuuuuuAAAAAA.  */
{ "dmulh22", 0x364B7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, UIMM6_20 }, { C_F }},

/* dmulh22<.f> 0,limm,u6 0011011001001011F111uuuuuu111110.  */
{ "dmulh22", 0x364B703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmulh22<.f><.cc> 0,limm,u6 0011011011001011F111uuuuuu1QQQQQ.  */
{ "dmulh22", 0x36CB7020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmulh22<.f> a,limm,u6 0011011001110011F111uuuuuuAAAAAA.  */
{ "dmulh22", 0x36737000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, UIMM6_20 }, { C_F }},

/* dmulh22<.f> 0,limm,u6 0011011001110011F111uuuuuu111110.  */
{ "dmulh22", 0x3673703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmulh22<.f><.cc> 0,limm,u6 0011011011110011F111uuuuuu1QQQQQ.  */
{ "dmulh22", 0x36F37020, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmulh22<.f> 0,limm,s12 0011011010001011F111ssssssSSSSSS.  */
{ "dmulh22", 0x368B7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmulh22<.f> 0,limm,s12 0011011010110011F111ssssssSSSSSS.  */
{ "dmulh22", 0x36B37000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmulh22<.f> a,limm,limm 0011011000001011F111111110AAAAAA.  */
{ "dmulh22", 0x360B7F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, LIMMdup }, { C_F }},

/* dmulh22<.f> 0,limm,limm 0011011000001011F111111110111110.  */
{ "dmulh22", 0x360B7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmulh22<.f><.cc> 0,limm,limm 0011011011001011F1111111100QQQQQ.  */
{ "dmulh22", 0x36CB7F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmulh22<.f> a,limm,limm 0011011000110011F111111110AAAAAA.  */
{ "dmulh22", 0x36337F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, LIMMdup }, { C_F }},

/* dmulh22<.f> 0,limm,limm 0011011000110011F111111110111110.  */
{ "dmulh22", 0x36337FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmulh22<.f><.cc> 0,limm,limm 0011011011110011F1111111100QQQQQ.  */
{ "dmulh22", 0x36F37F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmulpf<.f> a,b,c 00101bbb00111010FBBBCCCCCCAAAAAA.  */
{ "dmulpf", 0x283A0000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* dmulpf<.f><.cc> b,b,c 00101bbb11111010FBBBCCCCCC0QQQQQ.  */
{ "dmulpf", 0x28FA0000, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmulpf<.f> 0,b,c 00101bbb00111010FBBBCCCCCC111110.  */
{ "dmulpf", 0x283A003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* dmulpf<.f> a,b,limm 00101bbb00111010FBBB111110AAAAAA.  */
{ "dmulpf", 0x283A0F80, 0xF8FF0FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* dmulpf<.f><.cc> b,b,limm 00101bbb11111010FBBB1111100QQQQQ.  */
{ "dmulpf", 0x28FA0F80, 0xF8FF0FE0, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* drsubh11<.f> a,b,c 00110bbb00010100FBBBCCCCCCAAAAAA.  */
{ "drsubh11", 0x30140000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, RC }, { C_F }},

/* drsubh11<.f> 0,b,c 00110bbb00010100FBBBCCCCCC111110.  */
{ "drsubh11", 0x3014003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, RC }, { C_F }},

/* drsubh11<.f><.cc> b,b,c 00110bbb11010100FBBBCCCCCC0QQQQQ.  */
{ "drsubh11", 0x30D40000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, RC }, { C_F, C_CC }},

/* drsubh11<.f> a,b,u6 00110bbb01010100FBBBuuuuuuAAAAAA.  */
{ "drsubh11", 0x30540000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, UIMM6_20 }, { C_F }},

/* drsubh11<.f> 0,b,u6 00110bbb01010100FBBBuuuuuu111110.  */
{ "drsubh11", 0x3054003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, UIMM6_20 }, { C_F }},

/* drsubh11<.f><.cc> b,b,u6 00110bbb11010100FBBBuuuuuu1QQQQQ.  */
{ "drsubh11", 0x30D40020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* drsubh11<.f> b,b,s12 00110bbb10010100FBBBssssssSSSSSS.  */
{ "drsubh11", 0x30940000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, SIMM12_20 }, { C_F }},

/* drsubh11<.f> a,limm,c 0011011000010100F111CCCCCCAAAAAA.  */
{ "drsubh11", 0x36147000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, RC }, { C_F }},

/* drsubh11<.f> a,b,limm 00110bbb00010100FBBB111110AAAAAA.  */
{ "drsubh11", 0x30140F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, LIMM }, { C_F }},

/* drsubh11<.f> 0,limm,c 0011011000010100F111CCCCCC111110.  */
{ "drsubh11", 0x3614703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F }},

/* drsubh11<.f> 0,b,limm 00110bbb00010100FBBB111110111110.  */
{ "drsubh11", 0x30140FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, LIMM }, { C_F }},

/* drsubh11<.f><.cc> 0,limm,c 0011011011010100F111CCCCCC0QQQQQ.  */
{ "drsubh11", 0x36D47000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F, C_CC }},

/* drsubh11<.f><.cc> b,b,limm 00110bbb11010100FBBB1111100QQQQQ.  */
{ "drsubh11", 0x30D40F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* drsubh11<.f> a,limm,u6 0011011001010100F111uuuuuuAAAAAA.  */
{ "drsubh11", 0x36547000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, UIMM6_20 }, { C_F }},

/* drsubh11<.f> 0,limm,u6 0011011001010100F111uuuuuu111110.  */
{ "drsubh11", 0x3654703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* drsubh11<.f><.cc> 0,limm,u6 0011011011010100F111uuuuuu1QQQQQ.  */
{ "drsubh11", 0x36D47020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* drsubh11<.f> 0,limm,s12 0011011010010100F111ssssssSSSSSS.  */
{ "drsubh11", 0x36947000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* drsubh11<.f> a,limm,limm 0011011000010100F111111110AAAAAA.  */
{ "drsubh11", 0x36147F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, LIMMdup }, { C_F }},

/* drsubh11<.f> 0,limm,limm 0011011000010100F111111110111110.  */
{ "drsubh11", 0x36147FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F }},

/* drsubh11<.f><.cc> 0,limm,limm 0011011011010100F1111111100QQQQQ.  */
{ "drsubh11", 0x36D47F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* drsubh12<.f> a,b,c 00110bbb00010101FBBBCCCCCCAAAAAA.  */
{ "drsubh12", 0x30150000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, RC }, { C_F }},

/* drsubh12<.f> 0,b,c 00110bbb00010101FBBBCCCCCC111110.  */
{ "drsubh12", 0x3015003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, RC }, { C_F }},

/* drsubh12<.f><.cc> b,b,c 00110bbb11010101FBBBCCCCCC0QQQQQ.  */
{ "drsubh12", 0x30D50000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, RC }, { C_F, C_CC }},

/* drsubh12<.f> a,b,u6 00110bbb01010101FBBBuuuuuuAAAAAA.  */
{ "drsubh12", 0x30550000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, UIMM6_20 }, { C_F }},

/* drsubh12<.f> 0,b,u6 00110bbb01010101FBBBuuuuuu111110.  */
{ "drsubh12", 0x3055003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, UIMM6_20 }, { C_F }},

/* drsubh12<.f><.cc> b,b,u6 00110bbb11010101FBBBuuuuuu1QQQQQ.  */
{ "drsubh12", 0x30D50020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* drsubh12<.f> b,b,s12 00110bbb10010101FBBBssssssSSSSSS.  */
{ "drsubh12", 0x30950000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, SIMM12_20 }, { C_F }},

/* drsubh12<.f> a,limm,c 0011011000010101F111CCCCCCAAAAAA.  */
{ "drsubh12", 0x36157000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, RC }, { C_F }},

/* drsubh12<.f> a,b,limm 00110bbb00010101FBBB111110AAAAAA.  */
{ "drsubh12", 0x30150F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, LIMM }, { C_F }},

/* drsubh12<.f> 0,limm,c 0011011000010101F111CCCCCC111110.  */
{ "drsubh12", 0x3615703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F }},

/* drsubh12<.f> 0,b,limm 00110bbb00010101FBBB111110111110.  */
{ "drsubh12", 0x30150FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, LIMM }, { C_F }},

/* drsubh12<.f><.cc> 0,limm,c 0011011011010101F111CCCCCC0QQQQQ.  */
{ "drsubh12", 0x36D57000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F, C_CC }},

/* drsubh12<.f><.cc> b,b,limm 00110bbb11010101FBBB1111100QQQQQ.  */
{ "drsubh12", 0x30D50F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* drsubh12<.f> a,limm,u6 0011011001010101F111uuuuuuAAAAAA.  */
{ "drsubh12", 0x36557000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, UIMM6_20 }, { C_F }},

/* drsubh12<.f> 0,limm,u6 0011011001010101F111uuuuuu111110.  */
{ "drsubh12", 0x3655703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* drsubh12<.f><.cc> 0,limm,u6 0011011011010101F111uuuuuu1QQQQQ.  */
{ "drsubh12", 0x36D57020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* drsubh12<.f> 0,limm,s12 0011011010010101F111ssssssSSSSSS.  */
{ "drsubh12", 0x36957000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* drsubh12<.f> a,limm,limm 0011011000010101F111111110AAAAAA.  */
{ "drsubh12", 0x36157F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, LIMMdup }, { C_F }},

/* drsubh12<.f> 0,limm,limm 0011011000010101F111111110111110.  */
{ "drsubh12", 0x36157FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F }},

/* drsubh12<.f><.cc> 0,limm,limm 0011011011010101F1111111100QQQQQ.  */
{ "drsubh12", 0x36D57F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* drsubh21<.f> a,b,c 00110bbb00010110FBBBCCCCCCAAAAAA.  */
{ "drsubh21", 0x30160000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, RC }, { C_F }},

/* drsubh21<.f> 0,b,c 00110bbb00010110FBBBCCCCCC111110.  */
{ "drsubh21", 0x3016003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, RC }, { C_F }},

/* drsubh21<.f><.cc> b,b,c 00110bbb11010110FBBBCCCCCC0QQQQQ.  */
{ "drsubh21", 0x30D60000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, RC }, { C_F, C_CC }},

/* drsubh21<.f> a,b,u6 00110bbb01010110FBBBuuuuuuAAAAAA.  */
{ "drsubh21", 0x30560000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, UIMM6_20 }, { C_F }},

/* drsubh21<.f> 0,b,u6 00110bbb01010110FBBBuuuuuu111110.  */
{ "drsubh21", 0x3056003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, UIMM6_20 }, { C_F }},

/* drsubh21<.f><.cc> b,b,u6 00110bbb11010110FBBBuuuuuu1QQQQQ.  */
{ "drsubh21", 0x30D60020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* drsubh21<.f> b,b,s12 00110bbb10010110FBBBssssssSSSSSS.  */
{ "drsubh21", 0x30960000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, SIMM12_20 }, { C_F }},

/* drsubh21<.f> a,limm,c 0011011000010110F111CCCCCCAAAAAA.  */
{ "drsubh21", 0x36167000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, RC }, { C_F }},

/* drsubh21<.f> a,b,limm 00110bbb00010110FBBB111110AAAAAA.  */
{ "drsubh21", 0x30160F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, LIMM }, { C_F }},

/* drsubh21<.f> 0,limm,c 0011011000010110F111CCCCCC111110.  */
{ "drsubh21", 0x3616703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F }},

/* drsubh21<.f> 0,b,limm 00110bbb00010110FBBB111110111110.  */
{ "drsubh21", 0x30160FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, LIMM }, { C_F }},

/* drsubh21<.f><.cc> 0,limm,c 0011011011010110F111CCCCCC0QQQQQ.  */
{ "drsubh21", 0x36D67000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F, C_CC }},

/* drsubh21<.f><.cc> b,b,limm 00110bbb11010110FBBB1111100QQQQQ.  */
{ "drsubh21", 0x30D60F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* drsubh21<.f> a,limm,u6 0011011001010110F111uuuuuuAAAAAA.  */
{ "drsubh21", 0x36567000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, UIMM6_20 }, { C_F }},

/* drsubh21<.f> 0,limm,u6 0011011001010110F111uuuuuu111110.  */
{ "drsubh21", 0x3656703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* drsubh21<.f><.cc> 0,limm,u6 0011011011010110F111uuuuuu1QQQQQ.  */
{ "drsubh21", 0x36D67020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* drsubh21<.f> 0,limm,s12 0011011010010110F111ssssssSSSSSS.  */
{ "drsubh21", 0x36967000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* drsubh21<.f> a,limm,limm 0011011000010110F111111110AAAAAA.  */
{ "drsubh21", 0x36167F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, LIMMdup }, { C_F }},

/* drsubh21<.f> 0,limm,limm 0011011000010110F111111110111110.  */
{ "drsubh21", 0x36167FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F }},

/* drsubh21<.f><.cc> 0,limm,limm 0011011011010110F1111111100QQQQQ.  */
{ "drsubh21", 0x36D67F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* drsubh22<.f> a,b,c 00110bbb00010111FBBBCCCCCCAAAAAA.  */
{ "drsubh22", 0x30170000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, RC }, { C_F }},

/* drsubh22<.f> 0,b,c 00110bbb00010111FBBBCCCCCC111110.  */
{ "drsubh22", 0x3017003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, RC }, { C_F }},

/* drsubh22<.f><.cc> b,b,c 00110bbb11010111FBBBCCCCCC0QQQQQ.  */
{ "drsubh22", 0x30D70000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, RC }, { C_F, C_CC }},

/* drsubh22<.f> a,b,u6 00110bbb01010111FBBBuuuuuuAAAAAA.  */
{ "drsubh22", 0x30570000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, UIMM6_20 }, { C_F }},

/* drsubh22<.f> 0,b,u6 00110bbb01010111FBBBuuuuuu111110.  */
{ "drsubh22", 0x3057003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, UIMM6_20 }, { C_F }},

/* drsubh22<.f><.cc> b,b,u6 00110bbb11010111FBBBuuuuuu1QQQQQ.  */
{ "drsubh22", 0x30D70020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* drsubh22<.f> b,b,s12 00110bbb10010111FBBBssssssSSSSSS.  */
{ "drsubh22", 0x30970000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, SIMM12_20 }, { C_F }},

/* drsubh22<.f> a,limm,c 0011011000010111F111CCCCCCAAAAAA.  */
{ "drsubh22", 0x36177000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, RC }, { C_F }},

/* drsubh22<.f> a,b,limm 00110bbb00010111FBBB111110AAAAAA.  */
{ "drsubh22", 0x30170F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, LIMM }, { C_F }},

/* drsubh22<.f> 0,limm,c 0011011000010111F111CCCCCC111110.  */
{ "drsubh22", 0x3617703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F }},

/* drsubh22<.f> 0,b,limm 00110bbb00010111FBBB111110111110.  */
{ "drsubh22", 0x30170FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, LIMM }, { C_F }},

/* drsubh22<.f><.cc> 0,limm,c 0011011011010111F111CCCCCC0QQQQQ.  */
{ "drsubh22", 0x36D77000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F, C_CC }},

/* drsubh22<.f><.cc> b,b,limm 00110bbb11010111FBBB1111100QQQQQ.  */
{ "drsubh22", 0x30D70F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* drsubh22<.f> a,limm,u6 0011011001010111F111uuuuuuAAAAAA.  */
{ "drsubh22", 0x36577000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, UIMM6_20 }, { C_F }},

/* drsubh22<.f> 0,limm,u6 0011011001010111F111uuuuuu111110.  */
{ "drsubh22", 0x3657703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* drsubh22<.f><.cc> 0,limm,u6 0011011011010111F111uuuuuu1QQQQQ.  */
{ "drsubh22", 0x36D77020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* drsubh22<.f> 0,limm,s12 0011011010010111F111ssssssSSSSSS.  */
{ "drsubh22", 0x36977000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* drsubh22<.f> a,limm,limm 0011011000010111F111111110AAAAAA.  */
{ "drsubh22", 0x36177F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, LIMMdup }, { C_F }},

/* drsubh22<.f> 0,limm,limm 0011011000010111F111111110111110.  */
{ "drsubh22", 0x36177FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F }},

/* drsubh22<.f><.cc> 0,limm,limm 0011011011010111F1111111100QQQQQ.  */
{ "drsubh22", 0x36D77F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dsubh11<.f> a,b,c 00110bbb00010000FBBBCCCCCCAAAAAA.  */
{ "dsubh11", 0x30100000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, RC }, { C_F }},

/* dsubh11<.f> 0,b,c 00110bbb00010000FBBBCCCCCC111110.  */
{ "dsubh11", 0x3010003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, RC }, { C_F }},

/* dsubh11<.f><.cc> b,b,c 00110bbb11010000FBBBCCCCCC0QQQQQ.  */
{ "dsubh11", 0x30D00000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, RC }, { C_F, C_CC }},

/* dsubh11<.f> a,b,c 00110bbb00111000FBBBCCCCCCAAAAAA.  */
{ "dsubh11", 0x30380000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, RC }, { C_F }},

/* dsubh11<.f> 0,b,c 00110bbb00111000FBBBCCCCCC111110.  */
{ "dsubh11", 0x3038003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, RC }, { C_F }},

/* dsubh11<.f><.cc> b,b,c 00110bbb11111000FBBBCCCCCC0QQQQQ.  */
{ "dsubh11", 0x30F80000, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, RC }, { C_F, C_CC }},

/* dsubh11<.f> a,b,u6 00110bbb01010000FBBBuuuuuuAAAAAA.  */
{ "dsubh11", 0x30500000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, UIMM6_20 }, { C_F }},

/* dsubh11<.f> 0,b,u6 00110bbb01010000FBBBuuuuuu111110.  */
{ "dsubh11", 0x3050003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, UIMM6_20 }, { C_F }},

/* dsubh11<.f><.cc> b,b,u6 00110bbb11010000FBBBuuuuuu1QQQQQ.  */
{ "dsubh11", 0x30D00020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dsubh11<.f> a,b,u6 00110bbb01111000FBBBuuuuuuAAAAAA.  */
{ "dsubh11", 0x30780000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, UIMM6_20 }, { C_F }},

/* dsubh11<.f> 0,b,u6 00110bbb01111000FBBBuuuuuu111110.  */
{ "dsubh11", 0x3078003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, UIMM6_20 }, { C_F }},

/* dsubh11<.f><.cc> b,b,u6 00110bbb11111000FBBBuuuuuu1QQQQQ.  */
{ "dsubh11", 0x30F80020, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dsubh11<.f> b,b,s12 00110bbb10010000FBBBssssssSSSSSS.  */
{ "dsubh11", 0x30900000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, SIMM12_20 }, { C_F }},

/* dsubh11<.f> b,b,s12 00110bbb10111000FBBBssssssSSSSSS.  */
{ "dsubh11", 0x30B80000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, SIMM12_20 }, { C_F }},

/* dsubh11<.f> a,limm,c 0011011000010000F111CCCCCCAAAAAA.  */
{ "dsubh11", 0x36107000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, RC }, { C_F }},

/* dsubh11<.f> a,b,limm 00110bbb00010000FBBB111110AAAAAA.  */
{ "dsubh11", 0x30100F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, LIMM }, { C_F }},

/* dsubh11<.f> 0,limm,c 0011011000010000F111CCCCCC111110.  */
{ "dsubh11", 0x3610703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F }},

/* dsubh11<.f> 0,b,limm 00110bbb00010000FBBB111110111110.  */
{ "dsubh11", 0x30100FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, LIMM }, { C_F }},

/* dsubh11<.f><.cc> 0,limm,c 0011011011010000F111CCCCCC0QQQQQ.  */
{ "dsubh11", 0x36D07000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dsubh11<.f><.cc> b,b,limm 00110bbb11010000FBBB1111100QQQQQ.  */
{ "dsubh11", 0x30D00F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* dsubh11<.f> a,limm,c 0011011000111000F111CCCCCCAAAAAA.  */
{ "dsubh11", 0x36387000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, RC }, { C_F }},

/* dsubh11<.f> a,b,limm 00110bbb00111000FBBB111110AAAAAA.  */
{ "dsubh11", 0x30380F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, LIMM }, { C_F }},

/* dsubh11<.f> 0,limm,c 0011011000111000F111CCCCCC111110.  */
{ "dsubh11", 0x3638703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F }},

/* dsubh11<.f> 0,b,limm 00110bbb00111000FBBB111110111110.  */
{ "dsubh11", 0x30380FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, LIMM }, { C_F }},

/* dsubh11<.f><.cc> 0,limm,c 0011011011111000F111CCCCCC0QQQQQ.  */
{ "dsubh11", 0x36F87000, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dsubh11<.f><.cc> b,b,limm 00110bbb11111000FBBB1111100QQQQQ.  */
{ "dsubh11", 0x30F80F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* dsubh11<.f> a,limm,u6 0011011001010000F111uuuuuuAAAAAA.  */
{ "dsubh11", 0x36507000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, UIMM6_20 }, { C_F }},

/* dsubh11<.f> 0,limm,u6 0011011001010000F111uuuuuu111110.  */
{ "dsubh11", 0x3650703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dsubh11<.f><.cc> 0,limm,u6 0011011011010000F111uuuuuu1QQQQQ.  */
{ "dsubh11", 0x36D07020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dsubh11<.f> a,limm,u6 0011011001111000F111uuuuuuAAAAAA.  */
{ "dsubh11", 0x36787000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, UIMM6_20 }, { C_F }},

/* dsubh11<.f> 0,limm,u6 0011011001111000F111uuuuuu111110.  */
{ "dsubh11", 0x3678703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dsubh11<.f><.cc> 0,limm,u6 0011011011111000F111uuuuuu1QQQQQ.  */
{ "dsubh11", 0x36F87020, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dsubh11<.f> 0,limm,s12 0011011010010000F111ssssssSSSSSS.  */
{ "dsubh11", 0x36907000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dsubh11<.f> 0,limm,s12 0011011010111000F111ssssssSSSSSS.  */
{ "dsubh11", 0x36B87000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dsubh11<.f> a,limm,limm 0011011000010000F111111110AAAAAA.  */
{ "dsubh11", 0x36107F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, LIMMdup }, { C_F }},

/* dsubh11<.f> 0,limm,limm 0011011000010000F111111110111110.  */
{ "dsubh11", 0x36107FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F }},

/* dsubh11<.f><.cc> 0,limm,limm 0011011011010000F1111111100QQQQQ.  */
{ "dsubh11", 0x36D07F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dsubh11<.f> a,limm,limm 0011011000111000F111111110AAAAAA.  */
{ "dsubh11", 0x36387F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, LIMMdup }, { C_F }},

/* dsubh11<.f> 0,limm,limm 0011011000111000F111111110111110.  */
{ "dsubh11", 0x36387FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F }},

/* dsubh11<.f><.cc> 0,limm,limm 0011011011111000F1111111100QQQQQ.  */
{ "dsubh11", 0x36F87F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dsubh12<.f> a,b,c 00110bbb00010001FBBBCCCCCCAAAAAA.  */
{ "dsubh12", 0x30110000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, RC }, { C_F }},

/* dsubh12<.f> 0,b,c 00110bbb00010001FBBBCCCCCC111110.  */
{ "dsubh12", 0x3011003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, RC }, { C_F }},

/* dsubh12<.f><.cc> b,b,c 00110bbb11010001FBBBCCCCCC0QQQQQ.  */
{ "dsubh12", 0x30D10000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, RC }, { C_F, C_CC }},

/* dsubh12<.f> a,b,c 00110bbb00111001FBBBCCCCCCAAAAAA.  */
{ "dsubh12", 0x30390000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, RC }, { C_F }},

/* dsubh12<.f> 0,b,c 00110bbb00111001FBBBCCCCCC111110.  */
{ "dsubh12", 0x3039003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, RC }, { C_F }},

/* dsubh12<.f><.cc> b,b,c 00110bbb11111001FBBBCCCCCC0QQQQQ.  */
{ "dsubh12", 0x30F90000, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, RC }, { C_F, C_CC }},

/* dsubh12<.f> a,b,u6 00110bbb01010001FBBBuuuuuuAAAAAA.  */
{ "dsubh12", 0x30510000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, UIMM6_20 }, { C_F }},

/* dsubh12<.f> 0,b,u6 00110bbb01010001FBBBuuuuuu111110.  */
{ "dsubh12", 0x3051003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, UIMM6_20 }, { C_F }},

/* dsubh12<.f><.cc> b,b,u6 00110bbb11010001FBBBuuuuuu1QQQQQ.  */
{ "dsubh12", 0x30D10020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dsubh12<.f> a,b,u6 00110bbb01111001FBBBuuuuuuAAAAAA.  */
{ "dsubh12", 0x30790000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, UIMM6_20 }, { C_F }},

/* dsubh12<.f> 0,b,u6 00110bbb01111001FBBBuuuuuu111110.  */
{ "dsubh12", 0x3079003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, UIMM6_20 }, { C_F }},

/* dsubh12<.f><.cc> b,b,u6 00110bbb11111001FBBBuuuuuu1QQQQQ.  */
{ "dsubh12", 0x30F90020, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dsubh12<.f> b,b,s12 00110bbb10010001FBBBssssssSSSSSS.  */
{ "dsubh12", 0x30910000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, SIMM12_20 }, { C_F }},

/* dsubh12<.f> b,b,s12 00110bbb10111001FBBBssssssSSSSSS.  */
{ "dsubh12", 0x30B90000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, SIMM12_20 }, { C_F }},

/* dsubh12<.f> a,limm,c 0011011000010001F111CCCCCCAAAAAA.  */
{ "dsubh12", 0x36117000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, RC }, { C_F }},

/* dsubh12<.f> a,b,limm 00110bbb00010001FBBB111110AAAAAA.  */
{ "dsubh12", 0x30110F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, LIMM }, { C_F }},

/* dsubh12<.f> 0,limm,c 0011011000010001F111CCCCCC111110.  */
{ "dsubh12", 0x3611703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F }},

/* dsubh12<.f> 0,b,limm 00110bbb00010001FBBB111110111110.  */
{ "dsubh12", 0x30110FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, LIMM }, { C_F }},

/* dsubh12<.f><.cc> 0,limm,c 0011011011010001F111CCCCCC0QQQQQ.  */
{ "dsubh12", 0x36D17000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dsubh12<.f><.cc> b,b,limm 00110bbb11010001FBBB1111100QQQQQ.  */
{ "dsubh12", 0x30D10F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* dsubh12<.f> a,limm,c 0011011000111001F111CCCCCCAAAAAA.  */
{ "dsubh12", 0x36397000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, RC }, { C_F }},

/* dsubh12<.f> a,b,limm 00110bbb00111001FBBB111110AAAAAA.  */
{ "dsubh12", 0x30390F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, LIMM }, { C_F }},

/* dsubh12<.f> 0,limm,c 0011011000111001F111CCCCCC111110.  */
{ "dsubh12", 0x3639703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F }},

/* dsubh12<.f> 0,b,limm 00110bbb00111001FBBB111110111110.  */
{ "dsubh12", 0x30390FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, LIMM }, { C_F }},

/* dsubh12<.f><.cc> 0,limm,c 0011011011111001F111CCCCCC0QQQQQ.  */
{ "dsubh12", 0x36F97000, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dsubh12<.f><.cc> b,b,limm 00110bbb11111001FBBB1111100QQQQQ.  */
{ "dsubh12", 0x30F90F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* dsubh12<.f> a,limm,u6 0011011001010001F111uuuuuuAAAAAA.  */
{ "dsubh12", 0x36517000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, UIMM6_20 }, { C_F }},

/* dsubh12<.f> 0,limm,u6 0011011001010001F111uuuuuu111110.  */
{ "dsubh12", 0x3651703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dsubh12<.f><.cc> 0,limm,u6 0011011011010001F111uuuuuu1QQQQQ.  */
{ "dsubh12", 0x36D17020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dsubh12<.f> a,limm,u6 0011011001111001F111uuuuuuAAAAAA.  */
{ "dsubh12", 0x36797000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, UIMM6_20 }, { C_F }},

/* dsubh12<.f> 0,limm,u6 0011011001111001F111uuuuuu111110.  */
{ "dsubh12", 0x3679703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dsubh12<.f><.cc> 0,limm,u6 0011011011111001F111uuuuuu1QQQQQ.  */
{ "dsubh12", 0x36F97020, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dsubh12<.f> 0,limm,s12 0011011010010001F111ssssssSSSSSS.  */
{ "dsubh12", 0x36917000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dsubh12<.f> 0,limm,s12 0011011010111001F111ssssssSSSSSS.  */
{ "dsubh12", 0x36B97000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dsubh12<.f> a,limm,limm 0011011000010001F111111110AAAAAA.  */
{ "dsubh12", 0x36117F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, LIMMdup }, { C_F }},

/* dsubh12<.f> 0,limm,limm 0011011000010001F111111110111110.  */
{ "dsubh12", 0x36117FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F }},

/* dsubh12<.f><.cc> 0,limm,limm 0011011011010001F1111111100QQQQQ.  */
{ "dsubh12", 0x36D17F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dsubh12<.f> a,limm,limm 0011011000111001F111111110AAAAAA.  */
{ "dsubh12", 0x36397F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, LIMMdup }, { C_F }},

/* dsubh12<.f> 0,limm,limm 0011011000111001F111111110111110.  */
{ "dsubh12", 0x36397FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F }},

/* dsubh12<.f><.cc> 0,limm,limm 0011011011111001F1111111100QQQQQ.  */
{ "dsubh12", 0x36F97F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dsubh21<.f> a,b,c 00110bbb00010010FBBBCCCCCCAAAAAA.  */
{ "dsubh21", 0x30120000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, RC }, { C_F }},

/* dsubh21<.f> 0,b,c 00110bbb00010010FBBBCCCCCC111110.  */
{ "dsubh21", 0x3012003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, RC }, { C_F }},

/* dsubh21<.f><.cc> b,b,c 00110bbb11010010FBBBCCCCCC0QQQQQ.  */
{ "dsubh21", 0x30D20000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, RC }, { C_F, C_CC }},

/* dsubh21<.f> a,b,c 00110bbb00111010FBBBCCCCCCAAAAAA.  */
{ "dsubh21", 0x303A0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, RC }, { C_F }},

/* dsubh21<.f> 0,b,c 00110bbb00111010FBBBCCCCCC111110.  */
{ "dsubh21", 0x303A003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, RC }, { C_F }},

/* dsubh21<.f><.cc> b,b,c 00110bbb11111010FBBBCCCCCC0QQQQQ.  */
{ "dsubh21", 0x30FA0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, RC }, { C_F, C_CC }},

/* dsubh21<.f> a,b,u6 00110bbb01010010FBBBuuuuuuAAAAAA.  */
{ "dsubh21", 0x30520000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, UIMM6_20 }, { C_F }},

/* dsubh21<.f> 0,b,u6 00110bbb01010010FBBBuuuuuu111110.  */
{ "dsubh21", 0x3052003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, UIMM6_20 }, { C_F }},

/* dsubh21<.f><.cc> b,b,u6 00110bbb11010010FBBBuuuuuu1QQQQQ.  */
{ "dsubh21", 0x30D20020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dsubh21<.f> a,b,u6 00110bbb01111010FBBBuuuuuuAAAAAA.  */
{ "dsubh21", 0x307A0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, UIMM6_20 }, { C_F }},

/* dsubh21<.f> 0,b,u6 00110bbb01111010FBBBuuuuuu111110.  */
{ "dsubh21", 0x307A003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, UIMM6_20 }, { C_F }},

/* dsubh21<.f><.cc> b,b,u6 00110bbb11111010FBBBuuuuuu1QQQQQ.  */
{ "dsubh21", 0x30FA0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dsubh21<.f> b,b,s12 00110bbb10010010FBBBssssssSSSSSS.  */
{ "dsubh21", 0x30920000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, SIMM12_20 }, { C_F }},

/* dsubh21<.f> b,b,s12 00110bbb10111010FBBBssssssSSSSSS.  */
{ "dsubh21", 0x30BA0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, SIMM12_20 }, { C_F }},

/* dsubh21<.f> a,limm,c 0011011000010010F111CCCCCCAAAAAA.  */
{ "dsubh21", 0x36127000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, RC }, { C_F }},

/* dsubh21<.f> a,b,limm 00110bbb00010010FBBB111110AAAAAA.  */
{ "dsubh21", 0x30120F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, LIMM }, { C_F }},

/* dsubh21<.f> 0,limm,c 0011011000010010F111CCCCCC111110.  */
{ "dsubh21", 0x3612703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F }},

/* dsubh21<.f> 0,b,limm 00110bbb00010010FBBB111110111110.  */
{ "dsubh21", 0x30120FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, LIMM }, { C_F }},

/* dsubh21<.f><.cc> 0,limm,c 0011011011010010F111CCCCCC0QQQQQ.  */
{ "dsubh21", 0x36D27000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dsubh21<.f><.cc> b,b,limm 00110bbb11010010FBBB1111100QQQQQ.  */
{ "dsubh21", 0x30D20F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* dsubh21<.f> a,limm,c 0011011000111010F111CCCCCCAAAAAA.  */
{ "dsubh21", 0x363A7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, RC }, { C_F }},

/* dsubh21<.f> a,b,limm 00110bbb00111010FBBB111110AAAAAA.  */
{ "dsubh21", 0x303A0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, LIMM }, { C_F }},

/* dsubh21<.f> 0,limm,c 0011011000111010F111CCCCCC111110.  */
{ "dsubh21", 0x363A703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F }},

/* dsubh21<.f> 0,b,limm 00110bbb00111010FBBB111110111110.  */
{ "dsubh21", 0x303A0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, LIMM }, { C_F }},

/* dsubh21<.f><.cc> 0,limm,c 0011011011111010F111CCCCCC0QQQQQ.  */
{ "dsubh21", 0x36FA7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dsubh21<.f><.cc> b,b,limm 00110bbb11111010FBBB1111100QQQQQ.  */
{ "dsubh21", 0x30FA0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* dsubh21<.f> a,limm,u6 0011011001010010F111uuuuuuAAAAAA.  */
{ "dsubh21", 0x36527000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, UIMM6_20 }, { C_F }},

/* dsubh21<.f> 0,limm,u6 0011011001010010F111uuuuuu111110.  */
{ "dsubh21", 0x3652703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dsubh21<.f><.cc> 0,limm,u6 0011011011010010F111uuuuuu1QQQQQ.  */
{ "dsubh21", 0x36D27020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dsubh21<.f> a,limm,u6 0011011001111010F111uuuuuuAAAAAA.  */
{ "dsubh21", 0x367A7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, UIMM6_20 }, { C_F }},

/* dsubh21<.f> 0,limm,u6 0011011001111010F111uuuuuu111110.  */
{ "dsubh21", 0x367A703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dsubh21<.f><.cc> 0,limm,u6 0011011011111010F111uuuuuu1QQQQQ.  */
{ "dsubh21", 0x36FA7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dsubh21<.f> 0,limm,s12 0011011010010010F111ssssssSSSSSS.  */
{ "dsubh21", 0x36927000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dsubh21<.f> 0,limm,s12 0011011010111010F111ssssssSSSSSS.  */
{ "dsubh21", 0x36BA7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dsubh21<.f> a,limm,limm 0011011000010010F111111110AAAAAA.  */
{ "dsubh21", 0x36127F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, LIMMdup }, { C_F }},

/* dsubh21<.f> 0,limm,limm 0011011000010010F111111110111110.  */
{ "dsubh21", 0x36127FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F }},

/* dsubh21<.f><.cc> 0,limm,limm 0011011011010010F1111111100QQQQQ.  */
{ "dsubh21", 0x36D27F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dsubh21<.f> a,limm,limm 0011011000111010F111111110AAAAAA.  */
{ "dsubh21", 0x363A7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, LIMMdup }, { C_F }},

/* dsubh21<.f> 0,limm,limm 0011011000111010F111111110111110.  */
{ "dsubh21", 0x363A7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F }},

/* dsubh21<.f><.cc> 0,limm,limm 0011011011111010F1111111100QQQQQ.  */
{ "dsubh21", 0x36FA7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dsubh22<.f> a,b,c 00110bbb00010011FBBBCCCCCCAAAAAA.  */
{ "dsubh22", 0x30130000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, RC }, { C_F }},

/* dsubh22<.f> 0,b,c 00110bbb00010011FBBBCCCCCC111110.  */
{ "dsubh22", 0x3013003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, RC }, { C_F }},

/* dsubh22<.f><.cc> b,b,c 00110bbb11010011FBBBCCCCCC0QQQQQ.  */
{ "dsubh22", 0x30D30000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, RC }, { C_F, C_CC }},

/* dsubh22<.f> a,b,c 00110bbb00111011FBBBCCCCCCAAAAAA.  */
{ "dsubh22", 0x303B0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, RC }, { C_F }},

/* dsubh22<.f> 0,b,c 00110bbb00111011FBBBCCCCCC111110.  */
{ "dsubh22", 0x303B003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, RC }, { C_F }},

/* dsubh22<.f><.cc> b,b,c 00110bbb11111011FBBBCCCCCC0QQQQQ.  */
{ "dsubh22", 0x30FB0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, RC }, { C_F, C_CC }},

/* dsubh22<.f> a,b,u6 00110bbb01010011FBBBuuuuuuAAAAAA.  */
{ "dsubh22", 0x30530000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, UIMM6_20 }, { C_F }},

/* dsubh22<.f> 0,b,u6 00110bbb01010011FBBBuuuuuu111110.  */
{ "dsubh22", 0x3053003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, UIMM6_20 }, { C_F }},

/* dsubh22<.f><.cc> b,b,u6 00110bbb11010011FBBBuuuuuu1QQQQQ.  */
{ "dsubh22", 0x30D30020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dsubh22<.f> a,b,u6 00110bbb01111011FBBBuuuuuuAAAAAA.  */
{ "dsubh22", 0x307B0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, UIMM6_20 }, { C_F }},

/* dsubh22<.f> 0,b,u6 00110bbb01111011FBBBuuuuuu111110.  */
{ "dsubh22", 0x307B003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, UIMM6_20 }, { C_F }},

/* dsubh22<.f><.cc> b,b,u6 00110bbb11111011FBBBuuuuuu1QQQQQ.  */
{ "dsubh22", 0x30FB0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dsubh22<.f> b,b,s12 00110bbb10010011FBBBssssssSSSSSS.  */
{ "dsubh22", 0x30930000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, SIMM12_20 }, { C_F }},

/* dsubh22<.f> b,b,s12 00110bbb10111011FBBBssssssSSSSSS.  */
{ "dsubh22", 0x30BB0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, SIMM12_20 }, { C_F }},

/* dsubh22<.f> a,limm,c 0011011000010011F111CCCCCCAAAAAA.  */
{ "dsubh22", 0x36137000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, RC }, { C_F }},

/* dsubh22<.f> a,b,limm 00110bbb00010011FBBB111110AAAAAA.  */
{ "dsubh22", 0x30130F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, RB, LIMM }, { C_F }},

/* dsubh22<.f> 0,limm,c 0011011000010011F111CCCCCC111110.  */
{ "dsubh22", 0x3613703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F }},

/* dsubh22<.f> 0,b,limm 00110bbb00010011FBBB111110111110.  */
{ "dsubh22", 0x30130FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, RB, LIMM }, { C_F }},

/* dsubh22<.f><.cc> 0,limm,c 0011011011010011F111CCCCCC0QQQQQ.  */
{ "dsubh22", 0x36D37000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dsubh22<.f><.cc> b,b,limm 00110bbb11010011FBBB1111100QQQQQ.  */
{ "dsubh22", 0x30D30F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* dsubh22<.f> a,limm,c 0011011000111011F111CCCCCCAAAAAA.  */
{ "dsubh22", 0x363B7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, RC }, { C_F }},

/* dsubh22<.f> a,b,limm 00110bbb00111011FBBB111110AAAAAA.  */
{ "dsubh22", 0x303B0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, RB, LIMM }, { C_F }},

/* dsubh22<.f> 0,limm,c 0011011000111011F111CCCCCC111110.  */
{ "dsubh22", 0x363B703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F }},

/* dsubh22<.f> 0,b,limm 00110bbb00111011FBBB111110111110.  */
{ "dsubh22", 0x303B0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, RB, LIMM }, { C_F }},

/* dsubh22<.f><.cc> 0,limm,c 0011011011111011F111CCCCCC0QQQQQ.  */
{ "dsubh22", 0x36FB7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dsubh22<.f><.cc> b,b,limm 00110bbb11111011FBBB1111100QQQQQ.  */
{ "dsubh22", 0x30FB0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* dsubh22<.f> a,limm,u6 0011011001010011F111uuuuuuAAAAAA.  */
{ "dsubh22", 0x36537000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, UIMM6_20 }, { C_F }},

/* dsubh22<.f> 0,limm,u6 0011011001010011F111uuuuuu111110.  */
{ "dsubh22", 0x3653703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dsubh22<.f><.cc> 0,limm,u6 0011011011010011F111uuuuuu1QQQQQ.  */
{ "dsubh22", 0x36D37020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dsubh22<.f> a,limm,u6 0011011001111011F111uuuuuuAAAAAA.  */
{ "dsubh22", 0x367B7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, UIMM6_20 }, { C_F }},

/* dsubh22<.f> 0,limm,u6 0011011001111011F111uuuuuu111110.  */
{ "dsubh22", 0x367B703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dsubh22<.f><.cc> 0,limm,u6 0011011011111011F111uuuuuu1QQQQQ.  */
{ "dsubh22", 0x36FB7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dsubh22<.f> 0,limm,s12 0011011010010011F111ssssssSSSSSS.  */
{ "dsubh22", 0x36937000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dsubh22<.f> 0,limm,s12 0011011010111011F111ssssssSSSSSS.  */
{ "dsubh22", 0x36BB7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dsubh22<.f> a,limm,limm 0011011000010011F111111110AAAAAA.  */
{ "dsubh22", 0x36137F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { RA, LIMM, LIMMdup }, { C_F }},

/* dsubh22<.f> 0,limm,limm 0011011000010011F111111110111110.  */
{ "dsubh22", 0x36137FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F }},

/* dsubh22<.f><.cc> 0,limm,limm 0011011011010011F1111111100QQQQQ.  */
{ "dsubh22", 0x36D37F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, DPX, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dsubh22<.f> a,limm,limm 0011011000111011F111111110AAAAAA.  */
{ "dsubh22", 0x363B7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { RA, LIMM, LIMMdup }, { C_F }},

/* dsubh22<.f> 0,limm,limm 0011011000111011F111111110111110.  */
{ "dsubh22", 0x363B7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F }},

/* dsubh22<.f><.cc> 0,limm,limm 0011011011111011F1111111100QQQQQ.  */
{ "dsubh22", 0x36FB7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM, FLOAT, DPA, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dsync  00100010011011110001RRRRRR111111.  */
{ "dsync", 0x226F103F, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { 0 }, { 0 }},

/* ei_s u10 010111uuuuuuuuuu.  */
{ "ei_s", 0x00005C00, 0x0000FC00, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, EI, CD2, { UIMM10_6_S }, { 0 }},

/* enter_s u6 110000UU111uuuu0.  */
{ "enter_s", 0x0000C0E0, 0x0000FCE1, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ENTER, CD1, { BRAKET, RRANGE_EL, FP_EL, BLINK_EL, BRAKETdup }, { 0 }},
{ "enter_s", 0x0000C0E0, 0x0000FCE1, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ENTER, CD1, { BRAKET, R13_EL, FP_EL, BLINK_EL, BRAKETdup }, { 0 }},
{ "enter_s", 0x0000C0E0, 0x0000FCE1, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ENTER, CD1, { UIMM6_11_S }, { 0 }},

/* ex<.di> b,c 00100bbb00101111DBBBCCCCCC001100.  */
{ "ex", 0x202F000C, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MEMORY, NONE, { RB, BRAKET, RC, BRAKETdup }, { C_DI16 }},

/* ex<.di> b,u6 00100bbb01101111DBBBuuuuuu001100.  */
{ "ex", 0x206F000C, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MEMORY, NONE, { RB, BRAKET, UIMM6_20, BRAKETdup }, { C_DI16 }},

/* ex<.di> b,limm 00100bbb00101111DBBB111110001100.  */
{ "ex", 0x202F0F8C, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MEMORY, NONE, { RB, BRAKET, LIMM, BRAKETdup }, { C_DI16 }},

/* ex<.di> limm,c 0010011000101111D111CCCCCC001100.  */
{ "ex", 0x262F700C, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MEMORY, NONE, { LIMM, BRAKET, RC, BRAKETdup }, { C_DI16 }},

/* ex<.di> limm,u6 0010011001101111D111uuuuuu001100.  */
{ "ex", 0x266F700C, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MEMORY, NONE, { LIMM, BRAKET, UIMM6_20, BRAKETdup }, { C_DI16 }},

/* ex<.di> limm,limm 0010011000101111D111111110001100.  */
{ "ex", 0x262F7F8C, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MEMORY, NONE, { LIMM, BRAKET, LIMMdup, BRAKETdup }, { C_DI16 }},

/* extb<.f> b,c 00100bbb00101111FBBBCCCCCC000111.  */
{ "extb", 0x202F0007, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RC }, { C_F }},

/* extb<.f> 0,c 0010011000101111F111CCCCCC000111.  */
{ "extb", 0x262F7007, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RC }, { C_F }},

/* extb<.f> b,u6 00100bbb01101111FBBBuuuuuu000111.  */
{ "extb", 0x206F0007, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* extb<.f> 0,u6 0010011001101111F111uuuuuu000111.  */
{ "extb", 0x266F7007, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* extb<.f> b,limm 00100bbb00101111FBBB111110000111.  */
{ "extb", 0x202F0F87, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, LIMM }, { C_F }},

/* extb<.f> 0,limm 0010011000101111F111111110000111.  */
{ "extb", 0x262F7F87, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* extb_s b,c 01111bbbccc01111.  */
{ "extb_s", 0x0000780F, 0x0000F81F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB_S, RC_S }, { 0 }},

/* exth<.f> b,c 00100bbb00101111FBBBCCCCCC001000.  */
{ "exth", 0x202F0008, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RC }, { C_F }},

/* exth<.f> 0,c 0010011000101111F111CCCCCC001000.  */
{ "exth", 0x262F7008, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RC }, { C_F }},

/* exth<.f> b,u6 00100bbb01101111FBBBuuuuuu001000.  */
{ "exth", 0x206F0008, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* exth<.f> 0,u6 0010011001101111F111uuuuuu001000.  */
{ "exth", 0x266F7008, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* exth<.f> b,limm 00100bbb00101111FBBB111110001000.  */
{ "exth", 0x202F0F88, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, LIMM }, { C_F }},

/* exth<.f> 0,limm 0010011000101111F111111110001000.  */
{ "exth", 0x262F7F88, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* exth_s b,c 01111bbbccc10000.  */
{ "exth_s", 0x00007810, 0x0000F81F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB_S, RC_S }, { 0 }},

/* extw<.f> b,c 00100bbb00101111FBBBCCCCCC001000.  */
{ "extw", 0x202F0008, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, RC }, { C_F }},

/* extw<.f> 0,c 0010011000101111F111CCCCCC001000.  */
{ "extw", 0x262F7008, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, RC }, { C_F }},

/* extw<.f> b,u6 00100bbb01101111FBBBuuuuuu001000.  */
{ "extw", 0x206F0008, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* extw<.f> 0,u6 0010011001101111F111uuuuuu001000.  */
{ "extw", 0x266F7008, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* extw<.f> b,limm 00100bbb00101111FBBB111110001000.  */
{ "extw", 0x202F0F88, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, LIMM }, { C_F }},

/* extw<.f> 0,limm 0010011000101111F111111110001000.  */
{ "extw", 0x262F7F88, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* extw_s b,c 01111bbbccc10000.  */
{ "extw_s", 0x00007810, 0x0000F81F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB_S, RC_S }, { 0 }},

/* fadd<.f> a,b,c 00110bbb00000001FBBBCCCCCCAAAAAA.  */
{ "fadd", 0x30010000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RA, RB, RC }, { C_F }},

/* fadd<.f> 0,b,c 00110bbb00000001FBBBCCCCCC111110.  */
{ "fadd", 0x3001003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, RB, RC }, { C_F }},

/* fadd<.f><.cc> b,b,c 00110bbb11000001FBBBCCCCCC0QQQQQ.  */
{ "fadd", 0x30C10000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RB, RBdup, RC }, { C_F, C_CC }},

/* fadd<.f> a,b,u6 00110bbb01000001FBBBuuuuuuAAAAAA.  */
{ "fadd", 0x30410000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RA, RB, UIMM6_20 }, { C_F }},

/* fadd<.f> 0,b,u6 00110bbb01000001FBBBuuuuuu111110.  */
{ "fadd", 0x3041003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, RB, UIMM6_20 }, { C_F }},

/* fadd<.f><.cc> b,b,u6 00110bbb11000001FBBBuuuuuu1QQQQQ.  */
{ "fadd", 0x30C10020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* fadd<.f> b,b,s12 00110bbb10000001FBBBssssssSSSSSS.  */
{ "fadd", 0x30810000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RB, RBdup, SIMM12_20 }, { C_F }},

/* fadd<.f> a,limm,c 0011011000000001F111CCCCCCAAAAAA.  */
{ "fadd", 0x36017000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RA, LIMM, RC }, { C_F }},

/* fadd<.f> a,b,limm 00110bbb00000001FBBB111110AAAAAA.  */
{ "fadd", 0x30010F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RA, RB, LIMM }, { C_F }},

/* fadd<.f> 0,limm,c 0011011000000001F111CCCCCC111110.  */
{ "fadd", 0x3601703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, LIMM, RC }, { C_F }},

/* fadd<.f> 0,b,limm 00110bbb00000001FBBB111110111110.  */
{ "fadd", 0x30010FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, RB, LIMM }, { C_F }},

/* fadd<.f><.cc> 0,limm,c 0011011011000001F111CCCCCC0QQQQQ.  */
{ "fadd", 0x36C17000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, LIMM, RC }, { C_F, C_CC }},

/* fadd<.f><.cc> b,b,limm 00110bbb11000001FBBB1111100QQQQQ.  */
{ "fadd", 0x30C10F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* fadd<.f> a,limm,u6 0011011001000001F111uuuuuuAAAAAA.  */
{ "fadd", 0x36417000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RA, LIMM, UIMM6_20 }, { C_F }},

/* fadd<.f> 0,limm,u6 0011011001000001F111uuuuuu111110.  */
{ "fadd", 0x3641703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* fadd<.f><.cc> 0,limm,u6 0011011011000001F111uuuuuu1QQQQQ.  */
{ "fadd", 0x36C17020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* fadd<.f> 0,limm,s12 0011011010000001F111ssssssSSSSSS.  */
{ "fadd", 0x36817000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* fadd<.f> a,limm,limm 0011011000000001F111111110AAAAAA.  */
{ "fadd", 0x36017F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RA, LIMM, LIMMdup }, { C_F }},

/* fadd<.f> 0,limm,limm 0011011000000001F111111110111110.  */
{ "fadd", 0x36017FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, LIMM, LIMMdup }, { C_F }},

/* fadd<.f><.cc> 0,limm,limm 0011011011000001F1111111100QQQQQ.  */
{ "fadd", 0x36C17F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* fbfdw<.f> b,c 00101bbb00101111FBBBCCCCCC001011.  */
{ "fbfdw", 0x282F000B, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RC }, { C_F }},

/* fbfdw<.f> 0,c 0010111000101111F111CCCCCC001011.  */
{ "fbfdw", 0x2E2F700B, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RC }, { C_F }},

/* fbfdw<.f> b,u6 00101bbb01101111FBBBuuuuuu001011.  */
{ "fbfdw", 0x286F000B, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, UIMM6_20 }, { C_F }},

/* fbfdw<.f> 0,u6 0010111001101111F111uuuuuu001011.  */
{ "fbfdw", 0x2E6F700B, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, UIMM6_20 }, { C_F }},

/* fbfdw<.f> b,limm 00101bbb00101111FBBB111110001011.  */
{ "fbfdw", 0x282F0F8B, 0xF8FF0FFF, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, LIMM }, { C_F }},

/* fbfdw<.f> 0,limm 0010111000101111F111111110001011.  */
{ "fbfdw", 0x2E2F7F8B, 0xFFFF7FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM }, { C_F }},

/* fcvt32 a,b,c 00110bbb000010000BBBCCCCCCAAAAAA.  */
{ "fcvt32", 0x30080000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, RB, RC }, { 0 }},

/* fcvt32 0,b,c 00110bbb000010000BBBCCCCCC111110.  */
{ "fcvt32", 0x3008003E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, RB, RC }, { 0 }},

/* fcvt32<.cc> b,b,c 00110bbb110010000BBBCCCCCC0QQQQQ.  */
{ "fcvt32", 0x30C80000, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RB, RBdup, RC }, { C_CC }},

/* fcvt32 a,b,u6 00110bbb010010000BBBuuuuuuAAAAAA.  */
{ "fcvt32", 0x30480000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, RB, UIMM6_20 }, { 0 }},

/* fcvt32 0,b,u6 00110bbb010010000BBBuuuuuu111110.  */
{ "fcvt32", 0x3048003E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, RB, UIMM6_20 }, { 0 }},

/* fcvt32<.cc> b,b,u6 00110bbb110010000BBBuuuuuu1QQQQQ.  */
{ "fcvt32", 0x30C80020, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RB, RBdup, UIMM6_20 }, { C_CC }},

/* fcvt32 b,b,s12 00110bbb100010000BBBssssssSSSSSS.  */
{ "fcvt32", 0x30880000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RB, RBdup, SIMM12_20 }, { 0 }},

/* fcvt32 a,limm,c 00110110000010000111CCCCCCAAAAAA.  */
{ "fcvt32", 0x36087000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, LIMM, RC }, { 0 }},

/* fcvt32 a,b,limm 00110bbb000010000BBB111110AAAAAA.  */
{ "fcvt32", 0x30080F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, RB, LIMM }, { 0 }},

/* fcvt32 0,limm,c 00110110000010000111CCCCCC111110.  */
{ "fcvt32", 0x3608703E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, RC }, { 0 }},

/* fcvt32 0,b,limm 00110bbb000010000BBB111110111110.  */
{ "fcvt32", 0x30080FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, RB, LIMM }, { 0 }},

/* fcvt32<.cc> b,b,limm 00110bbb110010000BBB1111100QQQQQ.  */
{ "fcvt32", 0x30C80F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RB, RBdup, LIMM }, { C_CC }},

/* fcvt32<.cc> 0,limm,c 00110110110010000111CCCCCC0QQQQQ.  */
{ "fcvt32", 0x36C87000, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, RC }, { C_CC }},

/* fcvt32 a,limm,u6 00110110010010000111uuuuuuAAAAAA.  */
{ "fcvt32", 0x36487000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, LIMM, UIMM6_20 }, { 0 }},

/* fcvt32 0,limm,u6 00110110010010000111uuuuuu111110.  */
{ "fcvt32", 0x3648703E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* fcvt32<.cc> 0,limm,u6 00110110110010000111uuuuuu1QQQQQ.  */
{ "fcvt32", 0x36C87020, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* fcvt32 0,limm,s12 00110110100010000111ssssssSSSSSS.  */
{ "fcvt32", 0x36887000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* fcvt32 a,limm,limm 00110110000010000111111110AAAAAA.  */
{ "fcvt32", 0x36087F80, 0xFFFFFFC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, LIMM, LIMMdup }, { 0 }},

/* fcvt32 0,limm,limm 00110110000010000111111110111110.  */
{ "fcvt32", 0x36087FBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, LIMMdup }, { 0 }},

/* fcvt32<.cc> 0,limm,limm 001101101100100001111111100QQQQQ.  */
{ "fcvt32", 0x36C87F80, 0xFFFFFFE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, LIMMdup }, { C_CC }},

/* fcvt32_64 a,b,c 00110bbb000010010BBBCCCCCCAAAAAA.  */
{ "fcvt32_64", 0x30090000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, RB, RC }, { 0 }},

/* fcvt32_64 0,b,c 00110bbb000010010BBBCCCCCC111110.  */
{ "fcvt32_64", 0x3009003E, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, RB, RC }, { 0 }},

/* fcvt32_64<.cc> b,b,c 00110bbb110010010BBBCCCCCC0QQQQQ.  */
{ "fcvt32_64", 0x30C90000, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RB, RBdup, RC }, { C_CC }},

/* fcvt32_64 a,b,u6 00110bbb010010010BBBuuuuuuAAAAAA.  */
{ "fcvt32_64", 0x30490000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, RB, UIMM6_20 }, { 0 }},

/* fcvt32_64 0,b,u6 00110bbb010010010BBBuuuuuu111110.  */
{ "fcvt32_64", 0x3049003E, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, RB, UIMM6_20 }, { 0 }},

/* fcvt32_64<.cc> b,b,u6 00110bbb110010010BBBuuuuuu1QQQQQ.  */
{ "fcvt32_64", 0x30C90020, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RB, RBdup, UIMM6_20 }, { C_CC }},

/* fcvt32_64 b,b,s12 00110bbb100010010BBBssssssSSSSSS.  */
{ "fcvt32_64", 0x30890000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RB, RBdup, SIMM12_20 }, { 0 }},

/* fcvt32_64 a,limm,c 00110110000010010111CCCCCCAAAAAA.  */
{ "fcvt32_64", 0x36097000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, LIMM, RC }, { 0 }},

/* fcvt32_64 a,b,limm 00110bbb000010010BBB111110AAAAAA.  */
{ "fcvt32_64", 0x30090F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, RB, LIMM }, { 0 }},

/* fcvt32_64 0,limm,c 00110110000010010111CCCCCC111110.  */
{ "fcvt32_64", 0x3609703E, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, RC }, { 0 }},

/* fcvt32_64 0,b,limm 00110bbb000010010BBB111110111110.  */
{ "fcvt32_64", 0x30090FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, RB, LIMM }, { 0 }},

/* fcvt32_64<.cc> b,b,limm 00110bbb110010010BBB1111100QQQQQ.  */
{ "fcvt32_64", 0x30C90F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RB, RBdup, LIMM }, { C_CC }},

/* fcvt32_64<.cc> 0,limm,c 00110110110010010111CCCCCC0QQQQQ.  */
{ "fcvt32_64", 0x36C97000, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, RC }, { C_CC }},

/* fcvt32_64 a,limm,u6 00110110010010010111uuuuuuAAAAAA.  */
{ "fcvt32_64", 0x36497000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, LIMM, UIMM6_20 }, { 0 }},

/* fcvt32_64 0,limm,u6 00110110010010010111uuuuuu111110.  */
{ "fcvt32_64", 0x3649703E, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* fcvt32_64<.cc> 0,limm,u6 00110110110010010111uuuuuu1QQQQQ.  */
{ "fcvt32_64", 0x36C97020, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* fcvt32_64 0,limm,s12 00110110100010010111ssssssSSSSSS.  */
{ "fcvt32_64", 0x36897000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* fcvt32_64 a,limm,limm 00110110000010010111111110AAAAAA.  */
{ "fcvt32_64", 0x36097F80, 0xFFFFFFC0, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, LIMM, LIMMdup }, { 0 }},

/* fcvt32_64 0,limm,limm 00110110000010010111111110111110.  */
{ "fcvt32_64", 0x36097FBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, LIMMdup }, { 0 }},

/* fcvt32_64<.cc> 0,limm,limm 001101101100100101111111100QQQQQ.  */
{ "fcvt32_64", 0x36C97F80, 0xFFFFFFE0, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, LIMMdup }, { C_CC }},

/* fcvt64 a,b,c 00110bbb001110000BBBCCCCCCAAAAAA.  */
{ "fcvt64", 0x30380000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, RB, RC }, { 0 }},

/* fcvt64 0,b,c 00110bbb001110000BBBCCCCCC111110.  */
{ "fcvt64", 0x3038003E, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, RB, RC }, { 0 }},

/* fcvt64<.cc> b,b,c 00110bbb111110000BBBCCCCCC0QQQQQ.  */
{ "fcvt64", 0x30F80000, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RB, RBdup, RC }, { C_CC }},

/* fcvt64 a,b,u6 00110bbb011110000BBBuuuuuuAAAAAA.  */
{ "fcvt64", 0x30780000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, RB, UIMM6_20 }, { 0 }},

/* fcvt64 0,b,u6 00110bbb011110000BBBuuuuuu111110.  */
{ "fcvt64", 0x3078003E, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, RB, UIMM6_20 }, { 0 }},

/* fcvt64<.cc> b,b,u6 00110bbb111110000BBBuuuuuu1QQQQQ.  */
{ "fcvt64", 0x30F80020, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RB, RBdup, UIMM6_20 }, { C_CC }},

/* fcvt64 b,b,s12 00110bbb101110000BBBssssssSSSSSS.  */
{ "fcvt64", 0x30B80000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RB, RBdup, SIMM12_20 }, { 0 }},

/* fcvt64 a,limm,c 00110110001110000111CCCCCCAAAAAA.  */
{ "fcvt64", 0x36387000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, LIMM, RC }, { 0 }},

/* fcvt64 a,b,limm 00110bbb001110000BBB111110AAAAAA.  */
{ "fcvt64", 0x30380F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, RB, LIMM }, { 0 }},

/* fcvt64 0,limm,c 00110110001110000111CCCCCC111110.  */
{ "fcvt64", 0x3638703E, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, RC }, { 0 }},

/* fcvt64 0,b,limm 00110bbb001110000BBB111110111110.  */
{ "fcvt64", 0x30380FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, RB, LIMM }, { 0 }},

/* fcvt64<.cc> b,b,limm 00110bbb111110000BBB1111100QQQQQ.  */
{ "fcvt64", 0x30F80F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RB, RBdup, LIMM }, { C_CC }},

/* fcvt64<.cc> 0,limm,c 00110110111110000111CCCCCC0QQQQQ.  */
{ "fcvt64", 0x36F87000, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, RC }, { C_CC }},

/* fcvt64 a,limm,u6 00110110011110000111uuuuuuAAAAAA.  */
{ "fcvt64", 0x36787000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, LIMM, UIMM6_20 }, { 0 }},

/* fcvt64 0,limm,u6 00110110011110000111uuuuuu111110.  */
{ "fcvt64", 0x3678703E, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* fcvt64<.cc> 0,limm,u6 00110110111110000111uuuuuu1QQQQQ.  */
{ "fcvt64", 0x36F87020, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* fcvt64 0,limm,s12 00110110101110000111ssssssSSSSSS.  */
{ "fcvt64", 0x36B87000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* fcvt64 a,limm,limm 00110110001110000111111110AAAAAA.  */
{ "fcvt64", 0x36387F80, 0xFFFFFFC0, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, LIMM, LIMMdup }, { 0 }},

/* fcvt64 0,limm,limm 00110110001110000111111110111110.  */
{ "fcvt64", 0x36387FBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, LIMMdup }, { 0 }},

/* fcvt64<.cc> 0,limm,limm 001101101111100001111111100QQQQQ.  */
{ "fcvt64", 0x36F87F80, 0xFFFFFFE0, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, LIMMdup }, { C_CC }},

/* fcvt64_32 a,b,c 00110bbb001110010BBBCCCCCCAAAAAA.  */
{ "fcvt64_32", 0x30390000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, RB, RC }, { 0 }},

/* fcvt64_32 0,b,c 00110bbb001110010BBBCCCCCC111110.  */
{ "fcvt64_32", 0x3039003E, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, RB, RC }, { 0 }},

/* fcvt64_32<.cc> b,b,c 00110bbb111110010BBBCCCCCC0QQQQQ.  */
{ "fcvt64_32", 0x30F90000, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RB, RBdup, RC }, { C_CC }},

/* fcvt64_32 a,b,u6 00110bbb011110010BBBuuuuuuAAAAAA.  */
{ "fcvt64_32", 0x30790000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, RB, UIMM6_20 }, { 0 }},

/* fcvt64_32 0,b,u6 00110bbb011110010BBBuuuuuu111110.  */
{ "fcvt64_32", 0x3079003E, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, RB, UIMM6_20 }, { 0 }},

/* fcvt64_32<.cc> b,b,u6 00110bbb111110010BBBuuuuuu1QQQQQ.  */
{ "fcvt64_32", 0x30F90020, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RB, RBdup, UIMM6_20 }, { C_CC }},

/* fcvt64_32 b,b,s12 00110bbb101110010BBBssssssSSSSSS.  */
{ "fcvt64_32", 0x30B90000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RB, RBdup, SIMM12_20 }, { 0 }},

/* fcvt64_32 a,limm,c 00110110001110010111CCCCCCAAAAAA.  */
{ "fcvt64_32", 0x36397000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, LIMM, RC }, { 0 }},

/* fcvt64_32 a,b,limm 00110bbb001110010BBB111110AAAAAA.  */
{ "fcvt64_32", 0x30390F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, RB, LIMM }, { 0 }},

/* fcvt64_32 0,limm,c 00110110001110010111CCCCCC111110.  */
{ "fcvt64_32", 0x3639703E, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, RC }, { 0 }},

/* fcvt64_32 0,b,limm 00110bbb001110010BBB111110111110.  */
{ "fcvt64_32", 0x30390FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, RB, LIMM }, { 0 }},

/* fcvt64_32<.cc> b,b,limm 00110bbb111110010BBB1111100QQQQQ.  */
{ "fcvt64_32", 0x30F90F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RB, RBdup, LIMM }, { C_CC }},

/* fcvt64_32<.cc> 0,limm,c 00110110111110010111CCCCCC0QQQQQ.  */
{ "fcvt64_32", 0x36F97000, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, RC }, { C_CC }},

/* fcvt64_32 a,limm,u6 00110110011110010111uuuuuuAAAAAA.  */
{ "fcvt64_32", 0x36797000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, LIMM, UIMM6_20 }, { 0 }},

/* fcvt64_32 0,limm,u6 00110110011110010111uuuuuu111110.  */
{ "fcvt64_32", 0x3679703E, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* fcvt64_32<.cc> 0,limm,u6 00110110111110010111uuuuuu1QQQQQ.  */
{ "fcvt64_32", 0x36F97020, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* fcvt64_32 0,limm,s12 00110110101110010111ssssssSSSSSS.  */
{ "fcvt64_32", 0x36B97000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* fcvt64_32 a,limm,limm 00110110001110010111111110AAAAAA.  */
{ "fcvt64_32", 0x36397F80, 0xFFFFFFC0, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { RA, LIMM, LIMMdup }, { 0 }},

/* fcvt64_32 0,limm,limm 00110110001110010111111110111110.  */
{ "fcvt64_32", 0x36397FBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, LIMMdup }, { 0 }},

/* fcvt64_32<.cc> 0,limm,limm 001101101111100101111111100QQQQQ.  */
{ "fcvt64_32", 0x36F97F80, 0xFFFFFFE0, ARC_OPCODE_ARCv2HS, FLOAT, CVT, { ZA, LIMM, LIMMdup }, { C_CC }},

/* fdadd a,b,c 00110bbb001100010BBBCCCCCCAAAAAA.  */
{ "fdadd", 0x30310000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, RB, RC }, { 0 }},

/* fdadd 0,b,c 00110bbb001100010BBBCCCCCC111110.  */
{ "fdadd", 0x3031003E, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, RB, RC }, { 0 }},

/* fdadd<.cc> b,b,c 00110bbb111100010BBBCCCCCC0QQQQQ.  */
{ "fdadd", 0x30F10000, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, RC }, { C_CC }},

/* fdadd a,b,u6 00110bbb011100010BBBuuuuuuAAAAAA.  */
{ "fdadd", 0x30710000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, RB, UIMM6_20 }, { 0 }},

/* fdadd 0,b,u6 00110bbb011100010BBBuuuuuu111110.  */
{ "fdadd", 0x3071003E, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, RB, UIMM6_20 }, { 0 }},

/* fdadd<.cc> b,b,u6 00110bbb111100010BBBuuuuuu1QQQQQ.  */
{ "fdadd", 0x30F10020, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, UIMM6_20 }, { C_CC }},

/* fdadd b,b,s12 00110bbb101100010BBBssssssSSSSSS.  */
{ "fdadd", 0x30B10000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, SIMM12_20 }, { 0 }},

/* fdadd a,limm,c 00110110001100010111CCCCCCAAAAAA.  */
{ "fdadd", 0x36317000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, LIMM, RC }, { 0 }},

/* fdadd a,b,limm 00110bbb001100010BBB111110AAAAAA.  */
{ "fdadd", 0x30310F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, RB, LIMM }, { 0 }},

/* fdadd 0,limm,c 00110110001100010111CCCCCC111110.  */
{ "fdadd", 0x3631703E, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, RC }, { 0 }},

/* fdadd 0,b,limm 00110bbb001100010BBB111110111110.  */
{ "fdadd", 0x30310FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, RB, LIMM }, { 0 }},

/* fdadd<.cc> b,b,limm 00110bbb111100010BBB1111100QQQQQ.  */
{ "fdadd", 0x30F10F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, LIMM }, { C_CC }},

/* fdadd<.cc> 0,limm,c 00110110111100010111CCCCCC0QQQQQ.  */
{ "fdadd", 0x36F17000, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, RC }, { C_CC }},

/* fdadd a,limm,u6 00110110011100010111uuuuuuAAAAAA.  */
{ "fdadd", 0x36717000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, LIMM, UIMM6_20 }, { 0 }},

/* fdadd 0,limm,u6 00110110011100010111uuuuuu111110.  */
{ "fdadd", 0x3671703E, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* fdadd<.cc> 0,limm,u6 00110110111100010111uuuuuu1QQQQQ.  */
{ "fdadd", 0x36F17020, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* fdadd 0,limm,s12 00110110101100010111ssssssSSSSSS.  */
{ "fdadd", 0x36B17000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* fdadd a,limm,limm 00110110001100010111111110AAAAAA.  */
{ "fdadd", 0x36317F80, 0xFFFFFFC0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, LIMM, LIMMdup }, { 0 }},

/* fdadd 0,limm,limm 00110110001100010111111110111110.  */
{ "fdadd", 0x36317FBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, LIMMdup }, { 0 }},

/* fdadd<.cc> 0,limm,limm 001101101111000101111111100QQQQQ.  */
{ "fdadd", 0x36F17F80, 0xFFFFFFE0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, LIMMdup }, { C_CC }},

/* fdcmp b,c 00110bbb001100111BBBCCCCCC000000.  */
{ "fdcmp", 0x30338000, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RC }, { 0 }},

/* fdcmp<.cc> b,c 00110bbb111100111BBBCCCCCC0QQQQQ.  */
{ "fdcmp", 0x30F38000, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RC }, { C_CC }},

/* fdcmp b,u6 00110bbb011100111BBBuuuuuu000000.  */
{ "fdcmp", 0x30738000, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, UIMM6_20 }, { 0 }},

/* fdcmp<.cc> b,u6 00110bbb111100111BBBuuuuuu1QQQQQ.  */
{ "fdcmp", 0x30F38020, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, UIMM6_20 }, { C_CC }},

/* fdcmp b,s12 00110bbb101100111BBBssssssSSSSSS.  */
{ "fdcmp", 0x30B38000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, SIMM12_20 }, { 0 }},

/* fdcmp limm,c 00110110001100111111CCCCCC000000.  */
{ "fdcmp", 0x3633F000, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { LIMM, RC }, { 0 }},

/* fdcmp b,limm 00110bbb001100111BBB111110000000.  */
{ "fdcmp", 0x30338F80, 0xF8FF8FFF, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, LIMM }, { 0 }},

/* fdcmp<.cc> b,limm 00110bbb111100111BBB1111100QQQQQ.  */
{ "fdcmp", 0x30F38F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, LIMM }, { C_CC }},

/* fdcmp<.cc> limm,c 00110110111100111111CCCCCC0QQQQQ.  */
{ "fdcmp", 0x36F3F000, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { LIMM, RC }, { C_CC }},

/* fdcmp limm,u6 00110110011100111111uuuuuu000000.  */
{ "fdcmp", 0x3673F000, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { LIMM, UIMM6_20 }, { 0 }},

/* fdcmp<.cc> limm,u6 00110110111100111111uuuuuu1QQQQQ.  */
{ "fdcmp", 0x36F3F020, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { LIMM, UIMM6_20 }, { C_CC }},

/* fdcmp limm,s12 00110110101100111111ssssssSSSSSS.  */
{ "fdcmp", 0x36B3F000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { LIMM, SIMM12_20 }, { 0 }},

/* fdcmp limm,limm 00110110001100111111111110000000.  */
{ "fdcmp", 0x3633FF80, 0xFFFFFFFF, ARC_OPCODE_ARCv2HS, FLOAT, DP, { LIMM, LIMMdup }, { 0 }},

/* fdcmp<.cc> limm,limm 001101101111001111111111100QQQQQ.  */
{ "fdcmp", 0x36F3FF80, 0xFFFFFFE0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { LIMM, LIMMdup }, { C_CC }},

/* fdcmpf b,c 00110bbb001101001BBBCCCCCC000000.  */
{ "fdcmpf", 0x30348000, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RC }, { 0 }},

/* fdcmpf<.cc> b,c 00110bbb111101001BBBCCCCCC0QQQQQ.  */
{ "fdcmpf", 0x30F48000, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RC }, { C_CC }},

/* fdcmpf b,u6 00110bbb011101001BBBuuuuuu000000.  */
{ "fdcmpf", 0x30748000, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, UIMM6_20 }, { 0 }},

/* fdcmpf<.cc> b,u6 00110bbb111101001BBBuuuuuu1QQQQQ.  */
{ "fdcmpf", 0x30F48020, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, UIMM6_20 }, { C_CC }},

/* fdcmpf b,s12 00110bbb101101001BBBssssssSSSSSS.  */
{ "fdcmpf", 0x30B48000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, SIMM12_20 }, { 0 }},

/* fdcmpf limm,c 00110110001101001111CCCCCC000000.  */
{ "fdcmpf", 0x3634F000, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { LIMM, RC }, { 0 }},

/* fdcmpf b,limm 00110bbb001101001BBB111110000000.  */
{ "fdcmpf", 0x30348F80, 0xF8FF8FFF, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, LIMM }, { 0 }},

/* fdcmpf<.cc> b,limm 00110bbb111101001BBB1111100QQQQQ.  */
{ "fdcmpf", 0x30F48F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, LIMM }, { C_CC }},

/* fdcmpf<.cc> limm,c 00110110111101001111CCCCCC0QQQQQ.  */
{ "fdcmpf", 0x36F4F000, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { LIMM, RC }, { C_CC }},

/* fdcmpf limm,u6 00110110011101001111uuuuuu000000.  */
{ "fdcmpf", 0x3674F000, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { LIMM, UIMM6_20 }, { 0 }},

/* fdcmpf<.cc> limm,u6 00110110111101001111uuuuuu1QQQQQ.  */
{ "fdcmpf", 0x36F4F020, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { LIMM, UIMM6_20 }, { C_CC }},

/* fdcmpf limm,s12 00110110101101001111ssssssSSSSSS.  */
{ "fdcmpf", 0x36B4F000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { LIMM, SIMM12_20 }, { 0 }},

/* fdcmpf limm,limm 00110110001101001111111110000000.  */
{ "fdcmpf", 0x3634FF80, 0xFFFFFFFF, ARC_OPCODE_ARCv2HS, FLOAT, DP, { LIMM, LIMMdup }, { 0 }},

/* fdcmpf<.cc> limm,limm 001101101111010011111111100QQQQQ.  */
{ "fdcmpf", 0x36F4FF80, 0xFFFFFFE0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { LIMM, LIMMdup }, { C_CC }},

/* fddiv a,b,c 00110bbb001101110BBBCCCCCCAAAAAA.  */
{ "fddiv", 0x30370000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, RB, RC }, { 0 }},

/* fddiv 0,b,c 00110bbb001101110BBBCCCCCC111110.  */
{ "fddiv", 0x3037003E, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, RB, RC }, { 0 }},

/* fddiv<.cc> b,b,c 00110bbb111101110BBBCCCCCC0QQQQQ.  */
{ "fddiv", 0x30F70000, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, RC }, { C_CC }},

/* fddiv a,b,u6 00110bbb011101110BBBuuuuuuAAAAAA.  */
{ "fddiv", 0x30770000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, RB, UIMM6_20 }, { 0 }},

/* fddiv 0,b,u6 00110bbb011101110BBBuuuuuu111110.  */
{ "fddiv", 0x3077003E, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, RB, UIMM6_20 }, { 0 }},

/* fddiv<.cc> b,b,u6 00110bbb111101110BBBuuuuuu1QQQQQ.  */
{ "fddiv", 0x30F70020, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, UIMM6_20 }, { C_CC }},

/* fddiv b,b,s12 00110bbb101101110BBBssssssSSSSSS.  */
{ "fddiv", 0x30B70000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, SIMM12_20 }, { 0 }},

/* fddiv a,limm,c 00110110001101110111CCCCCCAAAAAA.  */
{ "fddiv", 0x36377000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, LIMM, RC }, { 0 }},

/* fddiv a,b,limm 00110bbb001101110BBB111110AAAAAA.  */
{ "fddiv", 0x30370F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, RB, LIMM }, { 0 }},

/* fddiv 0,limm,c 00110110001101110111CCCCCC111110.  */
{ "fddiv", 0x3637703E, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, RC }, { 0 }},

/* fddiv 0,b,limm 00110bbb001101110BBB111110111110.  */
{ "fddiv", 0x30370FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, RB, LIMM }, { 0 }},

/* fddiv<.cc> b,b,limm 00110bbb111101110BBB1111100QQQQQ.  */
{ "fddiv", 0x30F70F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, LIMM }, { C_CC }},

/* fddiv<.cc> 0,limm,c 00110110111101110111CCCCCC0QQQQQ.  */
{ "fddiv", 0x36F77000, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, RC }, { C_CC }},

/* fddiv a,limm,u6 00110110011101110111uuuuuuAAAAAA.  */
{ "fddiv", 0x36777000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, LIMM, UIMM6_20 }, { 0 }},

/* fddiv 0,limm,u6 00110110011101110111uuuuuu111110.  */
{ "fddiv", 0x3677703E, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* fddiv<.cc> 0,limm,u6 00110110111101110111uuuuuu1QQQQQ.  */
{ "fddiv", 0x36F77020, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* fddiv 0,limm,s12 00110110101101110111ssssssSSSSSS.  */
{ "fddiv", 0x36B77000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* fddiv a,limm,limm 00110110001101110111111110AAAAAA.  */
{ "fddiv", 0x36377F80, 0xFFFFFFC0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, LIMM, LIMMdup }, { 0 }},

/* fddiv 0,limm,limm 00110110001101110111111110111110.  */
{ "fddiv", 0x36377FBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, LIMMdup }, { 0 }},

/* fddiv<.cc> 0,limm,limm 001101101111011101111111100QQQQQ.  */
{ "fddiv", 0x36F77F80, 0xFFFFFFE0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, LIMMdup }, { C_CC }},

/* fdmadd a,b,c 00110bbb001101010BBBCCCCCCAAAAAA.  */
{ "fdmadd", 0x30350000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, RB, RC }, { 0 }},

/* fdmadd 0,b,c 00110bbb001101010BBBCCCCCC111110.  */
{ "fdmadd", 0x3035003E, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, RB, RC }, { 0 }},

/* fdmadd<.cc> b,b,c 00110bbb111101010BBBCCCCCC0QQQQQ.  */
{ "fdmadd", 0x30F50000, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, RC }, { C_CC }},

/* fdmadd a,b,u6 00110bbb011101010BBBuuuuuuAAAAAA.  */
{ "fdmadd", 0x30750000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, RB, UIMM6_20 }, { 0 }},

/* fdmadd 0,b,u6 00110bbb011101010BBBuuuuuu111110.  */
{ "fdmadd", 0x3075003E, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, RB, UIMM6_20 }, { 0 }},

/* fdmadd<.cc> b,b,u6 00110bbb111101010BBBuuuuuu1QQQQQ.  */
{ "fdmadd", 0x30F50020, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, UIMM6_20 }, { C_CC }},

/* fdmadd b,b,s12 00110bbb101101010BBBssssssSSSSSS.  */
{ "fdmadd", 0x30B50000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, SIMM12_20 }, { 0 }},

/* fdmadd a,limm,c 00110110001101010111CCCCCCAAAAAA.  */
{ "fdmadd", 0x36357000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, LIMM, RC }, { 0 }},

/* fdmadd a,b,limm 00110bbb001101010BBB111110AAAAAA.  */
{ "fdmadd", 0x30350F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, RB, LIMM }, { 0 }},

/* fdmadd 0,limm,c 00110110001101010111CCCCCC111110.  */
{ "fdmadd", 0x3635703E, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, RC }, { 0 }},

/* fdmadd 0,b,limm 00110bbb001101010BBB111110111110.  */
{ "fdmadd", 0x30350FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, RB, LIMM }, { 0 }},

/* fdmadd<.cc> b,b,limm 00110bbb111101010BBB1111100QQQQQ.  */
{ "fdmadd", 0x30F50F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, LIMM }, { C_CC }},

/* fdmadd<.cc> 0,limm,c 00110110111101010111CCCCCC0QQQQQ.  */
{ "fdmadd", 0x36F57000, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, RC }, { C_CC }},

/* fdmadd a,limm,u6 00110110011101010111uuuuuuAAAAAA.  */
{ "fdmadd", 0x36757000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, LIMM, UIMM6_20 }, { 0 }},

/* fdmadd 0,limm,u6 00110110011101010111uuuuuu111110.  */
{ "fdmadd", 0x3675703E, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* fdmadd<.cc> 0,limm,u6 00110110111101010111uuuuuu1QQQQQ.  */
{ "fdmadd", 0x36F57020, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* fdmadd 0,limm,s12 00110110101101010111ssssssSSSSSS.  */
{ "fdmadd", 0x36B57000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* fdmadd a,limm,limm 00110110001101010111111110AAAAAA.  */
{ "fdmadd", 0x36357F80, 0xFFFFFFC0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, LIMM, LIMMdup }, { 0 }},

/* fdmadd 0,limm,limm 00110110001101010111111110111110.  */
{ "fdmadd", 0x36357FBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, LIMMdup }, { 0 }},

/* fdmadd<.cc> 0,limm,limm 001101101111010101111111100QQQQQ.  */
{ "fdmadd", 0x36F57F80, 0xFFFFFFE0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, LIMMdup }, { C_CC }},

/* fdmsub a,b,c 00110bbb001101100BBBCCCCCCAAAAAA.  */
{ "fdmsub", 0x30360000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, RB, RC }, { 0 }},

/* fdmsub 0,b,c 00110bbb001101100BBBCCCCCC111110.  */
{ "fdmsub", 0x3036003E, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, RB, RC }, { 0 }},

/* fdmsub<.cc> b,b,c 00110bbb111101100BBBCCCCCC0QQQQQ.  */
{ "fdmsub", 0x30F60000, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, RC }, { C_CC }},

/* fdmsub a,b,u6 00110bbb011101100BBBuuuuuuAAAAAA.  */
{ "fdmsub", 0x30760000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, RB, UIMM6_20 }, { 0 }},

/* fdmsub 0,b,u6 00110bbb011101100BBBuuuuuu111110.  */
{ "fdmsub", 0x3076003E, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, RB, UIMM6_20 }, { 0 }},

/* fdmsub<.cc> b,b,u6 00110bbb111101100BBBuuuuuu1QQQQQ.  */
{ "fdmsub", 0x30F60020, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, UIMM6_20 }, { C_CC }},

/* fdmsub b,b,s12 00110bbb101101100BBBssssssSSSSSS.  */
{ "fdmsub", 0x30B60000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, SIMM12_20 }, { 0 }},

/* fdmsub a,limm,c 00110110001101100111CCCCCCAAAAAA.  */
{ "fdmsub", 0x36367000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, LIMM, RC }, { 0 }},

/* fdmsub a,b,limm 00110bbb001101100BBB111110AAAAAA.  */
{ "fdmsub", 0x30360F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, RB, LIMM }, { 0 }},

/* fdmsub 0,limm,c 00110110001101100111CCCCCC111110.  */
{ "fdmsub", 0x3636703E, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, RC }, { 0 }},

/* fdmsub 0,b,limm 00110bbb001101100BBB111110111110.  */
{ "fdmsub", 0x30360FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, RB, LIMM }, { 0 }},

/* fdmsub<.cc> b,b,limm 00110bbb111101100BBB1111100QQQQQ.  */
{ "fdmsub", 0x30F60F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, LIMM }, { C_CC }},

/* fdmsub<.cc> 0,limm,c 00110110111101100111CCCCCC0QQQQQ.  */
{ "fdmsub", 0x36F67000, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, RC }, { C_CC }},

/* fdmsub a,limm,u6 00110110011101100111uuuuuuAAAAAA.  */
{ "fdmsub", 0x36767000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, LIMM, UIMM6_20 }, { 0 }},

/* fdmsub 0,limm,u6 00110110011101100111uuuuuu111110.  */
{ "fdmsub", 0x3676703E, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* fdmsub<.cc> 0,limm,u6 00110110111101100111uuuuuu1QQQQQ.  */
{ "fdmsub", 0x36F67020, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* fdmsub 0,limm,s12 00110110101101100111ssssssSSSSSS.  */
{ "fdmsub", 0x36B67000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* fdmsub a,limm,limm 00110110001101100111111110AAAAAA.  */
{ "fdmsub", 0x36367F80, 0xFFFFFFC0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, LIMM, LIMMdup }, { 0 }},

/* fdmsub 0,limm,limm 00110110001101100111111110111110.  */
{ "fdmsub", 0x36367FBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, LIMMdup }, { 0 }},

/* fdmsub<.cc> 0,limm,limm 001101101111011001111111100QQQQQ.  */
{ "fdmsub", 0x36F67F80, 0xFFFFFFE0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, LIMMdup }, { C_CC }},

/* fdmul a,b,c 00110bbb001100000BBBCCCCCCAAAAAA.  */
{ "fdmul", 0x30300000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, RB, RC }, { 0 }},

/* fdmul 0,b,c 00110bbb001100000BBBCCCCCC111110.  */
{ "fdmul", 0x3030003E, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, RB, RC }, { 0 }},

/* fdmul<.cc> b,b,c 00110bbb111100000BBBCCCCCC0QQQQQ.  */
{ "fdmul", 0x30F00000, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, RC }, { C_CC }},

/* fdmul a,b,u6 00110bbb011100000BBBuuuuuuAAAAAA.  */
{ "fdmul", 0x30700000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, RB, UIMM6_20 }, { 0 }},

/* fdmul 0,b,u6 00110bbb011100000BBBuuuuuu111110.  */
{ "fdmul", 0x3070003E, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, RB, UIMM6_20 }, { 0 }},

/* fdmul<.cc> b,b,u6 00110bbb111100000BBBuuuuuu1QQQQQ.  */
{ "fdmul", 0x30F00020, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, UIMM6_20 }, { C_CC }},

/* fdmul b,b,s12 00110bbb101100000BBBssssssSSSSSS.  */
{ "fdmul", 0x30B00000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, SIMM12_20 }, { 0 }},

/* fdmul a,limm,c 00110110001100000111CCCCCCAAAAAA.  */
{ "fdmul", 0x36307000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, LIMM, RC }, { 0 }},

/* fdmul a,b,limm 00110bbb001100000BBB111110AAAAAA.  */
{ "fdmul", 0x30300F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, RB, LIMM }, { 0 }},

/* fdmul 0,limm,c 00110110001100000111CCCCCC111110.  */
{ "fdmul", 0x3630703E, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, RC }, { 0 }},

/* fdmul 0,b,limm 00110bbb001100000BBB111110111110.  */
{ "fdmul", 0x30300FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, RB, LIMM }, { 0 }},

/* fdmul<.cc> b,b,limm 00110bbb111100000BBB1111100QQQQQ.  */
{ "fdmul", 0x30F00F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, LIMM }, { C_CC }},

/* fdmul<.cc> 0,limm,c 00110110111100000111CCCCCC0QQQQQ.  */
{ "fdmul", 0x36F07000, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, RC }, { C_CC }},

/* fdmul a,limm,u6 00110110011100000111uuuuuuAAAAAA.  */
{ "fdmul", 0x36707000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, LIMM, UIMM6_20 }, { 0 }},

/* fdmul 0,limm,u6 00110110011100000111uuuuuu111110.  */
{ "fdmul", 0x3670703E, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* fdmul<.cc> 0,limm,u6 00110110111100000111uuuuuu1QQQQQ.  */
{ "fdmul", 0x36F07020, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* fdmul 0,limm,s12 00110110101100000111ssssssSSSSSS.  */
{ "fdmul", 0x36B07000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* fdmul a,limm,limm 00110110001100000111111110AAAAAA.  */
{ "fdmul", 0x36307F80, 0xFFFFFFC0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, LIMM, LIMMdup }, { 0 }},

/* fdmul 0,limm,limm 00110110001100000111111110111110.  */
{ "fdmul", 0x36307FBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, LIMMdup }, { 0 }},

/* fdmul<.cc> 0,limm,limm 001101101111000001111111100QQQQQ.  */
{ "fdmul", 0x36F07F80, 0xFFFFFFE0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, LIMMdup }, { C_CC }},

/* fdsqrt b,c 00110bbb001011110BBBCCCCCC000001.  */
{ "fdsqrt", 0x302F0001, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RC }, { 0 }},

/* fdsqrt 0,c 00110110001011110111CCCCCC000001.  */
{ "fdsqrt", 0x362F7001, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, RC }, { 0 }},

/* fdsqrt b,u6 00110bbb011011110BBBuuuuuu000001.  */
{ "fdsqrt", 0x306F0001, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, UIMM6_20 }, { 0 }},

/* fdsqrt 0,u6 00110110011011110111uuuuuu000001.  */
{ "fdsqrt", 0x366F7001, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, UIMM6_20 }, { 0 }},

/* fdsqrt b,limm 00110bbb001011110BBB111110000001.  */
{ "fdsqrt", 0x302F0F81, 0xF8FF8FFF, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, LIMM }, { 0 }},

/* fdsqrt 0,limm 00110110001011110111111110000001.  */
{ "fdsqrt", 0x362F7F81, 0xFFFFFFFF, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM }, { 0 }},

/* fdsub a,b,c 00110bbb001100100BBBCCCCCCAAAAAA.  */
{ "fdsub", 0x30320000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, RB, RC }, { 0 }},

/* fdsub 0,b,c 00110bbb001100100BBBCCCCCC111110.  */
{ "fdsub", 0x3032003E, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, RB, RC }, { 0 }},

/* fdsub<.cc> b,b,c 00110bbb111100100BBBCCCCCC0QQQQQ.  */
{ "fdsub", 0x30F20000, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, RC }, { C_CC }},

/* fdsub a,b,u6 00110bbb011100100BBBuuuuuuAAAAAA.  */
{ "fdsub", 0x30720000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, RB, UIMM6_20 }, { 0 }},

/* fdsub 0,b,u6 00110bbb011100100BBBuuuuuu111110.  */
{ "fdsub", 0x3072003E, 0xF8FF803F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, RB, UIMM6_20 }, { 0 }},

/* fdsub<.cc> b,b,u6 00110bbb111100100BBBuuuuuu1QQQQQ.  */
{ "fdsub", 0x30F20020, 0xF8FF8020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, UIMM6_20 }, { C_CC }},

/* fdsub b,b,s12 00110bbb101100100BBBssssssSSSSSS.  */
{ "fdsub", 0x30B20000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, SIMM12_20 }, { 0 }},

/* fdsub a,limm,c 00110110001100100111CCCCCCAAAAAA.  */
{ "fdsub", 0x36327000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, LIMM, RC }, { 0 }},

/* fdsub a,b,limm 00110bbb001100100BBB111110AAAAAA.  */
{ "fdsub", 0x30320F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, RB, LIMM }, { 0 }},

/* fdsub 0,limm,c 00110110001100100111CCCCCC111110.  */
{ "fdsub", 0x3632703E, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, RC }, { 0 }},

/* fdsub 0,b,limm 00110bbb001100100BBB111110111110.  */
{ "fdsub", 0x30320FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, RB, LIMM }, { 0 }},

/* fdsub<.cc> b,b,limm 00110bbb111100100BBB1111100QQQQQ.  */
{ "fdsub", 0x30F20F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RB, RBdup, LIMM }, { C_CC }},

/* fdsub<.cc> 0,limm,c 00110110111100100111CCCCCC0QQQQQ.  */
{ "fdsub", 0x36F27000, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, RC }, { C_CC }},

/* fdsub a,limm,u6 00110110011100100111uuuuuuAAAAAA.  */
{ "fdsub", 0x36727000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, LIMM, UIMM6_20 }, { 0 }},

/* fdsub 0,limm,u6 00110110011100100111uuuuuu111110.  */
{ "fdsub", 0x3672703E, 0xFFFFF03F, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* fdsub<.cc> 0,limm,u6 00110110111100100111uuuuuu1QQQQQ.  */
{ "fdsub", 0x36F27020, 0xFFFFF020, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* fdsub 0,limm,s12 00110110101100100111ssssssSSSSSS.  */
{ "fdsub", 0x36B27000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* fdsub a,limm,limm 00110110001100100111111110AAAAAA.  */
{ "fdsub", 0x36327F80, 0xFFFFFFC0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { RA, LIMM, LIMMdup }, { 0 }},

/* fdsub 0,limm,limm 00110110001100100111111110111110.  */
{ "fdsub", 0x36327FBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, LIMMdup }, { 0 }},

/* fdsub<.cc> 0,limm,limm 001101101111001001111111100QQQQQ.  */
{ "fdsub", 0x36F27F80, 0xFFFFFFE0, ARC_OPCODE_ARCv2HS, FLOAT, DP, { ZA, LIMM, LIMMdup }, { C_CC }},

/* ffs<.f> b,c 00101bbb00101111FBBBCCCCCC010010.  */
{ "ffs", 0x282F0012, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { RB, RC }, { C_F }},

/* ffs<.f> 0,c 0010111000101111F111CCCCCC010010.  */
{ "ffs", 0x2E2F7012, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { ZA, RC }, { C_F }},

/* ffs<.f> b,u6 00101bbb01101111FBBBuuuuuu010010.  */
{ "ffs", 0x286F0012, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { RB, UIMM6_20 }, { C_F }},

/* ffs<.f> 0,u6 0010111001101111F111uuuuuu010010.  */
{ "ffs", 0x2E6F7012, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { ZA, UIMM6_20 }, { C_F }},

/* ffs<.f> b,limm 00101bbb00101111FBBB111110010010.  */
{ "ffs", 0x282F0F92, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { RB, LIMM }, { C_F }},

/* ffs<.f> 0,limm 0010111000101111F111111110010010.  */
{ "ffs", 0x2E2F7F92, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { ZA, LIMM }, { C_F }},

/* flag c 00100RRR001010010RRRCCCCCCRRRRRR.  */
{ "flag", 0x20290000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { RC }, { 0 }},

/* flag<.cc> c 00100RRR111010010RRRCCCCCC0QQQQQ.  */
{ "flag", 0x20E90000, 0xF8FF8020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { RC }, { C_CC }},

/* flag u6 00100RRR011010010RRRuuuuuuRRRRRR.  */
{ "flag", 0x20690000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { UIMM6_20 }, { 0 }},

/* flag<.cc> u6 00100RRR111010010RRRuuuuuu1QQQQQ.  */
{ "flag", 0x20E90020, 0xF8FF8020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { UIMM6_20 }, { C_CC }},

/* flag s12 00100RRR101010010RRRssssssSSSSSS.  */
{ "flag", 0x20A90000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { SIMM12_20 }, { 0 }},

/* flag limm 00100RRR001010010RRR111110RRRRRR.  */
{ "flag", 0x20290F80, 0xF8FF8FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { LIMM }, { 0 }},

/* flag<.cc> limm 00100RRR111010010RRR1111100QQQQQ.  */
{ "flag", 0x20E90F80, 0xF8FF8FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { LIMM }, { C_CC }},

/* flagacc c 00101100001011111000CCCCCC111111.  */
{ "flagacc", 0x2C2F803F, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RC }, { 0 }},

/* flagacc u6 00101100011011111000uuuuuu111111.  */
{ "flagacc", 0x2C6F803F, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { UIMM6_20 }, { 0 }},

/* fls<.f> b,c 00101bbb00101111FBBBCCCCCC010011.  */
{ "fls", 0x282F0013, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { RB, RC }, { C_F }},

/* fls<.f> 0,c 0010111000101111F111CCCCCC010011.  */
{ "fls", 0x2E2F7013, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { ZA, RC }, { C_F }},

/* fls<.f> b,u6 00101bbb01101111FBBBuuuuuu010011.  */
{ "fls", 0x286F0013, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { RB, UIMM6_20 }, { C_F }},

/* fls<.f> 0,u6 0010111001101111F111uuuuuu010011.  */
{ "fls", 0x2E6F7013, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { ZA, UIMM6_20 }, { C_F }},

/* fls<.f> b,limm 00101bbb00101111FBBB111110010011.  */
{ "fls", 0x282F0F93, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { RB, LIMM }, { C_F }},

/* fls<.f> 0,limm 0010111000101111F111111110010011.  */
{ "fls", 0x2E2F7F93, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { ZA, LIMM }, { C_F }},

/* fmp_adds<.f> a,b,c 00111bbb00100010FBBBCCCCCCAAAAAA.  */
{ "fmp_adds", 0x38220000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RA, RB, RC }, { C_F }},

/* fmp_adds<.f> 0,b,c 00111bbb00100010FBBBCCCCCC111110.  */
{ "fmp_adds", 0x3822003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RB, RC }, { C_F }},

/* fmp_adds<.f><.cc> b,b,c 00111bbb11100010FBBBCCCCCC0QQQQQ.  */
{ "fmp_adds", 0x38E20000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RBdup, RC }, { C_F, C_CC }},

/* fmp_adds<.f> a,b,u6 00111bbb01100010FBBBuuuuuuAAAAAA.  */
{ "fmp_adds", 0x38620000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RA, RB, UIMM6_20 }, { C_F }},

/* fmp_adds<.f> 0,b,u6 00111bbb01100010FBBBuuuuuu111110.  */
{ "fmp_adds", 0x3862003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RB, UIMM6_20 }, { C_F }},

/* fmp_adds<.f><.cc> b,b,u6 00111bbb11100010FBBBuuuuuu1QQQQQ.  */
{ "fmp_adds", 0x38E20020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* fmp_adds<.f> b,b,s12 00111bbb10100010FBBBssssssSSSSSS.  */
{ "fmp_adds", 0x38A20000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RBdup, SIMM12_20 }, { C_F }},

/* fmp_adds<.f> a,limm,c 0011111000100010F111CCCCCCAAAAAA.  */
{ "fmp_adds", 0x3E227000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RA, LIMM, RC }, { C_F }},

/* fmp_adds<.f> a,b,limm 00111bbb00100010FBBB111110AAAAAA.  */
{ "fmp_adds", 0x38220F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RA, RB, LIMM }, { C_F }},

/* fmp_adds<.f> 0,limm,c 0011111000100010F111CCCCCC111110.  */
{ "fmp_adds", 0x3E22703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM, RC }, { C_F }},

/* fmp_adds<.f> 0,b,limm 00111bbb00100010FBBB111110111110.  */
{ "fmp_adds", 0x38220FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RB, LIMM }, { C_F }},

/* fmp_adds<.f><.cc> b,b,limm 00111bbb11100010FBBB1111100QQQQQ.  */
{ "fmp_adds", 0x38E20F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* fmp_adds<.f><.cc> 0,limm,c 0011111011100010F111CCCCCC0QQQQQ.  */
{ "fmp_adds", 0x3EE27000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM, RC }, { C_F, C_CC }},

/* fmp_adds<.f> a,limm,u6 0011111001100010F111uuuuuuAAAAAA.  */
{ "fmp_adds", 0x3E627000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RA, LIMM, UIMM6_20 }, { C_F }},

/* fmp_adds<.f> 0,limm,u6 0011111001100010F111uuuuuu111110.  */
{ "fmp_adds", 0x3E62703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* fmp_adds<.f><.cc> 0,limm,u6 0011111011100010F111uuuuuu1QQQQQ.  */
{ "fmp_adds", 0x3EE27020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* fmp_adds<.f> 0,limm,s12 0011111010100010F111ssssssSSSSSS.  */
{ "fmp_adds", 0x3EA27000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* fmp_adds<.f> a,limm,limm 0011111000100010F111111110AAAAAA.  */
{ "fmp_adds", 0x3E227F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RA, LIMM, LIMMdup }, { C_F }},

/* fmp_adds<.f> 0,limm,limm 0011111000100010F111111110111110.  */
{ "fmp_adds", 0x3E227FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM, LIMMdup }, { C_F }},

/* fmp_adds<.f><.cc> 0,limm,limm 0011111011100010F1111111100QQQQQ.  */
{ "fmp_adds", 0x3EE27F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* fmp_atan<.f> b,c 00111bbb00101111FBBBCCCCCC100101.  */
{ "fmp_atan", 0x382F0025, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RC }, { C_F }},

/* fmp_atan<.f> 0,c 0011111000101111F111CCCCCC100101.  */
{ "fmp_atan", 0x3E2F7025, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RC }, { C_F }},

/* fmp_atan<.f> b,u6 00111bbb01101111FBBBuuuuuu100101.  */
{ "fmp_atan", 0x386F0025, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, UIMM6_20 }, { C_F }},

/* fmp_atan<.f> 0,u6 0011111001101111F111uuuuuu100101.  */
{ "fmp_atan", 0x3E6F7025, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, UIMM6_20 }, { C_F }},

/* fmp_atan<.f> b,limm 00111bbb00101111FBBB111110100101.  */
{ "fmp_atan", 0x382F0FA5, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, LIMM }, { C_F }},

/* fmp_atan<.f> 0,limm 0011111000101111F111111110100101.  */
{ "fmp_atan", 0x3E2F7FA5, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM }, { C_F }},

/* fmp_atan15<.f> b,c 00111bbb00101111FBBBCCCCCC101110.  */
{ "fmp_atan15", 0x382F002E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RC }, { C_F }},

/* fmp_atan15<.f> 0,c 0011111000101111F111CCCCCC101110.  */
{ "fmp_atan15", 0x3E2F702E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RC }, { C_F }},

/* fmp_atan15<.f> b,u6 00111bbb01101111FBBBuuuuuu101110.  */
{ "fmp_atan15", 0x386F002E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, UIMM6_20 }, { C_F }},

/* fmp_atan15<.f> 0,u6 0011111001101111F111uuuuuu101110.  */
{ "fmp_atan15", 0x3E6F702E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, UIMM6_20 }, { C_F }},

/* fmp_atan15<.f> b,limm 00111bbb00101111FBBB111110101110.  */
{ "fmp_atan15", 0x382F0FAE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, LIMM }, { C_F }},

/* fmp_atan15<.f> 0,limm 0011111000101111F111111110101110.  */
{ "fmp_atan15", 0x3E2F7FAE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM }, { C_F }},

/* fmp_cos<.f> b,c 00111bbb00101111FBBBCCCCCC011110.  */
{ "fmp_cos", 0x382F001E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RC }, { C_F }},

/* fmp_cos<.f> 0,c 0011111000101111F111CCCCCC011110.  */
{ "fmp_cos", 0x3E2F701E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RC }, { C_F }},

/* fmp_cos<.f> b,u6 00111bbb01101111FBBBuuuuuu011110.  */
{ "fmp_cos", 0x386F001E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, UIMM6_20 }, { C_F }},

/* fmp_cos<.f> 0,u6 0011111001101111F111uuuuuu011110.  */
{ "fmp_cos", 0x3E6F701E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, UIMM6_20 }, { C_F }},

/* fmp_cos<.f> b,limm 00111bbb00101111FBBB111110011110.  */
{ "fmp_cos", 0x382F0F9E, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, LIMM }, { C_F }},

/* fmp_cos<.f> 0,limm 0011111000101111F111111110011110.  */
{ "fmp_cos", 0x3E2F7F9E, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM }, { C_F }},

/* fmp_cos15<.f> b,c 00111bbb00101111FBBBCCCCCC101100.  */
{ "fmp_cos15", 0x382F002C, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RC }, { C_F }},

/* fmp_cos15<.f> 0,c 0011111000101111F111CCCCCC101100.  */
{ "fmp_cos15", 0x3E2F702C, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RC }, { C_F }},

/* fmp_cos15<.f> b,u6 00111bbb01101111FBBBuuuuuu101100.  */
{ "fmp_cos15", 0x386F002C, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, UIMM6_20 }, { C_F }},

/* fmp_cos15<.f> 0,u6 0011111001101111F111uuuuuu101100.  */
{ "fmp_cos15", 0x3E6F702C, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, UIMM6_20 }, { C_F }},

/* fmp_cos15<.f> b,limm 00111bbb00101111FBBB111110101100.  */
{ "fmp_cos15", 0x382F0FAC, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, LIMM }, { C_F }},

/* fmp_cos15<.f> 0,limm 0011111000101111F111111110101100.  */
{ "fmp_cos15", 0x3E2F7FAC, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM }, { C_F }},

/* fmp_divf<.f> a,b,c 00111bbb00100000FBBBCCCCCCAAAAAA.  */
{ "fmp_divf", 0x38200000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RA, RB, RC }, { C_F }},

/* fmp_divf<.f> 0,b,c 00111bbb00100000FBBBCCCCCC111110.  */
{ "fmp_divf", 0x3820003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RB, RC }, { C_F }},

/* fmp_divf<.f><.cc> b,b,c 00111bbb11100000FBBBCCCCCC0QQQQQ.  */
{ "fmp_divf", 0x38E00000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RBdup, RC }, { C_F, C_CC }},

/* fmp_divf<.f> a,b,u6 00111bbb01100000FBBBuuuuuuAAAAAA.  */
{ "fmp_divf", 0x38600000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RA, RB, UIMM6_20 }, { C_F }},

/* fmp_divf<.f> 0,b,u6 00111bbb01100000FBBBuuuuuu111110.  */
{ "fmp_divf", 0x3860003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RB, UIMM6_20 }, { C_F }},

/* fmp_divf<.f><.cc> b,b,u6 00111bbb11100000FBBBuuuuuu1QQQQQ.  */
{ "fmp_divf", 0x38E00020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* fmp_divf<.f> b,b,s12 00111bbb10100000FBBBssssssSSSSSS.  */
{ "fmp_divf", 0x38A00000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RBdup, SIMM12_20 }, { C_F }},

/* fmp_divf<.f> a,limm,c 0011111000100000F111CCCCCCAAAAAA.  */
{ "fmp_divf", 0x3E207000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RA, LIMM, RC }, { C_F }},

/* fmp_divf<.f> a,b,limm 00111bbb00100000FBBB111110AAAAAA.  */
{ "fmp_divf", 0x38200F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RA, RB, LIMM }, { C_F }},

/* fmp_divf<.f> 0,limm,c 0011111000100000F111CCCCCC111110.  */
{ "fmp_divf", 0x3E20703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM, RC }, { C_F }},

/* fmp_divf<.f> 0,b,limm 00111bbb00100000FBBB111110111110.  */
{ "fmp_divf", 0x38200FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RB, LIMM }, { C_F }},

/* fmp_divf<.f><.cc> b,b,limm 00111bbb11100000FBBB1111100QQQQQ.  */
{ "fmp_divf", 0x38E00F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* fmp_divf<.f><.cc> 0,limm,c 0011111011100000F111CCCCCC0QQQQQ.  */
{ "fmp_divf", 0x3EE07000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM, RC }, { C_F, C_CC }},

/* fmp_divf<.f> a,limm,u6 0011111001100000F111uuuuuuAAAAAA.  */
{ "fmp_divf", 0x3E607000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RA, LIMM, UIMM6_20 }, { C_F }},

/* fmp_divf<.f> 0,limm,u6 0011111001100000F111uuuuuu111110.  */
{ "fmp_divf", 0x3E60703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* fmp_divf<.f><.cc> 0,limm,u6 0011111011100000F111uuuuuu1QQQQQ.  */
{ "fmp_divf", 0x3EE07020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* fmp_divf<.f> 0,limm,s12 0011111010100000F111ssssssSSSSSS.  */
{ "fmp_divf", 0x3EA07000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* fmp_divf<.f> a,limm,limm 0011111000100000F111111110AAAAAA.  */
{ "fmp_divf", 0x3E207F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RA, LIMM, LIMMdup }, { C_F }},

/* fmp_divf<.f> 0,limm,limm 0011111000100000F111111110111110.  */
{ "fmp_divf", 0x3E207FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM, LIMMdup }, { C_F }},

/* fmp_divf<.f><.cc> 0,limm,limm 0011111011100000F1111111100QQQQQ.  */
{ "fmp_divf", 0x3EE07F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* fmp_divf15<.f> a,b,c 00111bbb00100001FBBBCCCCCCAAAAAA.  */
{ "fmp_divf15", 0x38210000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RA, RB, RC }, { C_F }},

/* fmp_divf15<.f> 0,b,c 00111bbb00100001FBBBCCCCCC111110.  */
{ "fmp_divf15", 0x3821003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RB, RC }, { C_F }},

/* fmp_divf15<.f><.cc> b,b,c 00111bbb11100001FBBBCCCCCC0QQQQQ.  */
{ "fmp_divf15", 0x38E10000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RBdup, RC }, { C_F, C_CC }},

/* fmp_divf15<.f> a,b,u6 00111bbb01100001FBBBuuuuuuAAAAAA.  */
{ "fmp_divf15", 0x38610000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RA, RB, UIMM6_20 }, { C_F }},

/* fmp_divf15<.f> 0,b,u6 00111bbb01100001FBBBuuuuuu111110.  */
{ "fmp_divf15", 0x3861003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RB, UIMM6_20 }, { C_F }},

/* fmp_divf15<.f><.cc> b,b,u6 00111bbb11100001FBBBuuuuuu1QQQQQ.  */
{ "fmp_divf15", 0x38E10020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* fmp_divf15<.f> b,b,s12 00111bbb10100001FBBBssssssSSSSSS.  */
{ "fmp_divf15", 0x38A10000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RBdup, SIMM12_20 }, { C_F }},

/* fmp_divf15<.f> a,limm,c 0011111000100001F111CCCCCCAAAAAA.  */
{ "fmp_divf15", 0x3E217000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RA, LIMM, RC }, { C_F }},

/* fmp_divf15<.f> a,b,limm 00111bbb00100001FBBB111110AAAAAA.  */
{ "fmp_divf15", 0x38210F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RA, RB, LIMM }, { C_F }},

/* fmp_divf15<.f> 0,limm,c 0011111000100001F111CCCCCC111110.  */
{ "fmp_divf15", 0x3E21703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM, RC }, { C_F }},

/* fmp_divf15<.f> 0,b,limm 00111bbb00100001FBBB111110111110.  */
{ "fmp_divf15", 0x38210FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RB, LIMM }, { C_F }},

/* fmp_divf15<.f><.cc> b,b,limm 00111bbb11100001FBBB1111100QQQQQ.  */
{ "fmp_divf15", 0x38E10F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* fmp_divf15<.f><.cc> 0,limm,c 0011111011100001F111CCCCCC0QQQQQ.  */
{ "fmp_divf15", 0x3EE17000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM, RC }, { C_F, C_CC }},

/* fmp_divf15<.f> a,limm,u6 0011111001100001F111uuuuuuAAAAAA.  */
{ "fmp_divf15", 0x3E617000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RA, LIMM, UIMM6_20 }, { C_F }},

/* fmp_divf15<.f> 0,limm,u6 0011111001100001F111uuuuuu111110.  */
{ "fmp_divf15", 0x3E61703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* fmp_divf15<.f><.cc> 0,limm,u6 0011111011100001F111uuuuuu1QQQQQ.  */
{ "fmp_divf15", 0x3EE17020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* fmp_divf15<.f> 0,limm,s12 0011111010100001F111ssssssSSSSSS.  */
{ "fmp_divf15", 0x3EA17000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* fmp_divf15<.f> a,limm,limm 0011111000100001F111111110AAAAAA.  */
{ "fmp_divf15", 0x3E217F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RA, LIMM, LIMMdup }, { C_F }},

/* fmp_divf15<.f> 0,limm,limm 0011111000100001F111111110111110.  */
{ "fmp_divf15", 0x3E217FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM, LIMMdup }, { C_F }},

/* fmp_divf15<.f><.cc> 0,limm,limm 0011111011100001F1111111100QQQQQ.  */
{ "fmp_divf15", 0x3EE17F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* fmp_exp2<.f> b,c 00111bbb00101111FBBBCCCCCC100111.  */
{ "fmp_exp2", 0x382F0027, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RC }, { C_F }},

/* fmp_exp2<.f> 0,c 0011111000101111F111CCCCCC100111.  */
{ "fmp_exp2", 0x3E2F7027, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RC }, { C_F }},

/* fmp_exp2<.f> b,u6 00111bbb01101111FBBBuuuuuu100111.  */
{ "fmp_exp2", 0x386F0027, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, UIMM6_20 }, { C_F }},

/* fmp_exp2<.f> 0,u6 0011111001101111F111uuuuuu100111.  */
{ "fmp_exp2", 0x3E6F7027, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, UIMM6_20 }, { C_F }},

/* fmp_exp2<.f> b,limm 00111bbb00101111FBBB111110100111.  */
{ "fmp_exp2", 0x382F0FA7, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, LIMM }, { C_F }},

/* fmp_exp2<.f> 0,limm 0011111000101111F111111110100111.  */
{ "fmp_exp2", 0x3E2F7FA7, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM }, { C_F }},

/* fmp_exp215<.f> b,c 00111bbb00101111FBBBCCCCCC101111.  */
{ "fmp_exp215", 0x382F002F, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RC }, { C_F }},

/* fmp_exp215<.f> 0,c 0011111000101111F111CCCCCC101111.  */
{ "fmp_exp215", 0x3E2F702F, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RC }, { C_F }},

/* fmp_exp215<.f> b,u6 00111bbb01101111FBBBuuuuuu101111.  */
{ "fmp_exp215", 0x386F002F, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, UIMM6_20 }, { C_F }},

/* fmp_exp215<.f> 0,u6 0011111001101111F111uuuuuu101111.  */
{ "fmp_exp215", 0x3E6F702F, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, UIMM6_20 }, { C_F }},

/* fmp_exp215<.f> b,limm 00111bbb00101111FBBB111110101111.  */
{ "fmp_exp215", 0x382F0FAF, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, LIMM }, { C_F }},

/* fmp_exp215<.f> 0,limm 0011111000101111F111111110101111.  */
{ "fmp_exp215", 0x3E2F7FAF, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM }, { C_F }},

/* fmp_log2<.f> b,c 00111bbb00101111FBBBCCCCCC100110.  */
{ "fmp_log2", 0x382F0026, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RC }, { C_F }},

/* fmp_log2<.f> 0,c 0011111000101111F111CCCCCC100110.  */
{ "fmp_log2", 0x3E2F7026, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RC }, { C_F }},

/* fmp_log2<.f> b,u6 00111bbb01101111FBBBuuuuuu100110.  */
{ "fmp_log2", 0x386F0026, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, UIMM6_20 }, { C_F }},

/* fmp_log2<.f> 0,u6 0011111001101111F111uuuuuu100110.  */
{ "fmp_log2", 0x3E6F7026, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, UIMM6_20 }, { C_F }},

/* fmp_log2<.f> b,limm 00111bbb00101111FBBB111110100110.  */
{ "fmp_log2", 0x382F0FA6, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, LIMM }, { C_F }},

/* fmp_log2<.f> 0,limm 0011111000101111F111111110100110.  */
{ "fmp_log2", 0x3E2F7FA6, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM }, { C_F }},

/* fmp_log215<.f> b,c 00111bbb00101111FBBBCCCCCC110000.  */
{ "fmp_log215", 0x382F0030, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RC }, { C_F }},

/* fmp_log215<.f> 0,c 0011111000101111F111CCCCCC110000.  */
{ "fmp_log215", 0x3E2F7030, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RC }, { C_F }},

/* fmp_log215<.f> b,u6 00111bbb01101111FBBBuuuuuu110000.  */
{ "fmp_log215", 0x386F0030, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, UIMM6_20 }, { C_F }},

/* fmp_log215<.f> 0,u6 0011111001101111F111uuuuuu110000.  */
{ "fmp_log215", 0x3E6F7030, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, UIMM6_20 }, { C_F }},

/* fmp_log215<.f> b,limm 00111bbb00101111FBBB111110110000.  */
{ "fmp_log215", 0x382F0FB0, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, LIMM }, { C_F }},

/* fmp_log215<.f> 0,limm 0011111000101111F111111110110000.  */
{ "fmp_log215", 0x3E2F7FB0, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM }, { C_F }},

/* fmp_recip<.f> b,c 00111bbb00101111FBBBCCCCCC101010.  */
{ "fmp_recip", 0x382F002A, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RC }, { C_F }},

/* fmp_recip<.f> 0,c 0011111000101111F111CCCCCC101010.  */
{ "fmp_recip", 0x3E2F702A, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RC }, { C_F }},

/* fmp_recip<.f> b,u6 00111bbb01101111FBBBuuuuuu101010.  */
{ "fmp_recip", 0x386F002A, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, UIMM6_20 }, { C_F }},

/* fmp_recip<.f> 0,u6 0011111001101111F111uuuuuu101010.  */
{ "fmp_recip", 0x3E6F702A, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, UIMM6_20 }, { C_F }},

/* fmp_recip<.f> b,limm 00111bbb00101111FBBB111110101010.  */
{ "fmp_recip", 0x382F0FAA, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, LIMM }, { C_F }},

/* fmp_recip<.f> 0,limm 0011111000101111F111111110101010.  */
{ "fmp_recip", 0x3E2F7FAA, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM }, { C_F }},

/* fmp_recip15<.f> b,c 00111bbb00101111FBBBCCCCCC101011.  */
{ "fmp_recip15", 0x382F002B, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RC }, { C_F }},

/* fmp_recip15<.f> 0,c 0011111000101111F111CCCCCC101011.  */
{ "fmp_recip15", 0x3E2F702B, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RC }, { C_F }},

/* fmp_recip15<.f> b,u6 00111bbb01101111FBBBuuuuuu101011.  */
{ "fmp_recip15", 0x386F002B, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, UIMM6_20 }, { C_F }},

/* fmp_recip15<.f> 0,u6 0011111001101111F111uuuuuu101011.  */
{ "fmp_recip15", 0x3E6F702B, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, UIMM6_20 }, { C_F }},

/* fmp_recip15<.f> b,limm 00111bbb00101111FBBB111110101011.  */
{ "fmp_recip15", 0x382F0FAB, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, LIMM }, { C_F }},

/* fmp_recip15<.f> 0,limm 0011111000101111F111111110101011.  */
{ "fmp_recip15", 0x3E2F7FAB, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM }, { C_F }},

/* fmp_rndh<.f> b,c 00111bbb00101111FBBBCCCCCC101001.  */
{ "fmp_rndh", 0x382F0029, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RC }, { C_F }},

/* fmp_rndh<.f> 0,c 0011111000101111F111CCCCCC101001.  */
{ "fmp_rndh", 0x3E2F7029, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RC }, { C_F }},

/* fmp_rndh<.f> b,u6 00111bbb01101111FBBBuuuuuu101001.  */
{ "fmp_rndh", 0x386F0029, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, UIMM6_20 }, { C_F }},

/* fmp_rndh<.f> 0,u6 0011111001101111F111uuuuuu101001.  */
{ "fmp_rndh", 0x3E6F7029, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, UIMM6_20 }, { C_F }},

/* fmp_rndh<.f> b,limm 00111bbb00101111FBBB111110101001.  */
{ "fmp_rndh", 0x382F0FA9, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, LIMM }, { C_F }},

/* fmp_rndh<.f> 0,limm 0011111000101111F111111110101001.  */
{ "fmp_rndh", 0x3E2F7FA9, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM }, { C_F }},

/* fmp_sath<.f> b,c 00111bbb00101111FBBBCCCCCC101000.  */
{ "fmp_sath", 0x382F0028, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RC }, { C_F }},

/* fmp_sath<.f> 0,c 0011111000101111F111CCCCCC101000.  */
{ "fmp_sath", 0x3E2F7028, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RC }, { C_F }},

/* fmp_sath<.f> b,u6 00111bbb01101111FBBBuuuuuu101000.  */
{ "fmp_sath", 0x386F0028, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, UIMM6_20 }, { C_F }},

/* fmp_sath<.f> 0,u6 0011111001101111F111uuuuuu101000.  */
{ "fmp_sath", 0x3E6F7028, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, UIMM6_20 }, { C_F }},

/* fmp_sath<.f> b,limm 00111bbb00101111FBBB111110101000.  */
{ "fmp_sath", 0x382F0FA8, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, LIMM }, { C_F }},

/* fmp_sath<.f> 0,limm 0011111000101111F111111110101000.  */
{ "fmp_sath", 0x3E2F7FA8, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM }, { C_F }},

/* fmp_sin<.f> b,c 00111bbb00101111FBBBCCCCCC011111.  */
{ "fmp_sin", 0x382F001F, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RC }, { C_F }},

/* fmp_sin<.f> 0,c 0011111000101111F111CCCCCC011111.  */
{ "fmp_sin", 0x3E2F701F, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RC }, { C_F }},

/* fmp_sin<.f> b,u6 00111bbb01101111FBBBuuuuuu011111.  */
{ "fmp_sin", 0x386F001F, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, UIMM6_20 }, { C_F }},

/* fmp_sin<.f> 0,u6 0011111001101111F111uuuuuu011111.  */
{ "fmp_sin", 0x3E6F701F, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, UIMM6_20 }, { C_F }},

/* fmp_sin<.f> b,limm 00111bbb00101111FBBB111110011111.  */
{ "fmp_sin", 0x382F0F9F, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, LIMM }, { C_F }},

/* fmp_sin<.f> 0,limm 0011111000101111F111111110011111.  */
{ "fmp_sin", 0x3E2F7F9F, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM }, { C_F }},

/* fmp_sin15<.f> b,c 00111bbb00101111FBBBCCCCCC101101.  */
{ "fmp_sin15", 0x382F002D, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RC }, { C_F }},

/* fmp_sin15<.f> 0,c 0011111000101111F111CCCCCC101101.  */
{ "fmp_sin15", 0x3E2F702D, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RC }, { C_F }},

/* fmp_sin15<.f> b,u6 00111bbb01101111FBBBuuuuuu101101.  */
{ "fmp_sin15", 0x386F002D, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, UIMM6_20 }, { C_F }},

/* fmp_sin15<.f> 0,u6 0011111001101111F111uuuuuu101101.  */
{ "fmp_sin15", 0x3E6F702D, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, UIMM6_20 }, { C_F }},

/* fmp_sin15<.f> b,limm 00111bbb00101111FBBB111110101101.  */
{ "fmp_sin15", 0x382F0FAD, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, LIMM }, { C_F }},

/* fmp_sin15<.f> 0,limm 0011111000101111F111111110101101.  */
{ "fmp_sin15", 0x3E2F7FAD, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM }, { C_F }},

/* fmp_sqrtf<.f> b,c 00111bbb00101111FBBBCCCCCC100000.  */
{ "fmp_sqrtf", 0x382F0020, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RC }, { C_F }},

/* fmp_sqrtf<.f> 0,c 0011111000101111F111CCCCCC100000.  */
{ "fmp_sqrtf", 0x3E2F7020, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RC }, { C_F }},

/* fmp_sqrtf<.f> b,u6 00111bbb01101111FBBBuuuuuu100000.  */
{ "fmp_sqrtf", 0x386F0020, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, UIMM6_20 }, { C_F }},

/* fmp_sqrtf<.f> 0,u6 0011111001101111F111uuuuuu100000.  */
{ "fmp_sqrtf", 0x3E6F7020, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, UIMM6_20 }, { C_F }},

/* fmp_sqrtf<.f> b,limm 00111bbb00101111FBBB111110100000.  */
{ "fmp_sqrtf", 0x382F0FA0, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, LIMM }, { C_F }},

/* fmp_sqrtf<.f> 0,limm 0011111000101111F111111110100000.  */
{ "fmp_sqrtf", 0x3E2F7FA0, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM }, { C_F }},

/* fmp_sqrtf15<.f> b,c 00111bbb00101111FBBBCCCCCC100001.  */
{ "fmp_sqrtf15", 0x382F0021, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, RC }, { C_F }},

/* fmp_sqrtf15<.f> 0,c 0011111000101111F111CCCCCC100001.  */
{ "fmp_sqrtf15", 0x3E2F7021, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, RC }, { C_F }},

/* fmp_sqrtf15<.f> b,u6 00111bbb01101111FBBBuuuuuu100001.  */
{ "fmp_sqrtf15", 0x386F0021, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, UIMM6_20 }, { C_F }},

/* fmp_sqrtf15<.f> 0,u6 0011111001101111F111uuuuuu100001.  */
{ "fmp_sqrtf15", 0x3E6F7021, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, UIMM6_20 }, { C_F }},

/* fmp_sqrtf15<.f> b,limm 00111bbb00101111FBBB111110100001.  */
{ "fmp_sqrtf15", 0x382F0FA1, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { RB, LIMM }, { C_F }},

/* fmp_sqrtf15<.f> 0,limm 0011111000101111F111111110100001.  */
{ "fmp_sqrtf15", 0x3E2F7FA1, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, FASTMATH, { ZA, LIMM }, { C_F }},

/* fmul<.f> a,b,c 00110bbb00000000FBBBCCCCCCAAAAAA.  */
{ "fmul", 0x30000000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RA, RB, RC }, { C_F }},

/* fmul<.f> 0,b,c 00110bbb00000000FBBBCCCCCC111110.  */
{ "fmul", 0x3000003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, RB, RC }, { C_F }},

/* fmul<.f><.cc> b,b,c 00110bbb11000000FBBBCCCCCC0QQQQQ.  */
{ "fmul", 0x30C00000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RB, RBdup, RC }, { C_F, C_CC }},

/* fmul<.f> a,b,u6 00110bbb01000000FBBBuuuuuuAAAAAA.  */
{ "fmul", 0x30400000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RA, RB, UIMM6_20 }, { C_F }},

/* fmul<.f> 0,b,u6 00110bbb01000000FBBBuuuuuu111110.  */
{ "fmul", 0x3040003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, RB, UIMM6_20 }, { C_F }},

/* fmul<.f><.cc> b,b,u6 00110bbb11000000FBBBuuuuuu1QQQQQ.  */
{ "fmul", 0x30C00020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* fmul<.f> b,b,s12 00110bbb10000000FBBBssssssSSSSSS.  */
{ "fmul", 0x30800000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RB, RBdup, SIMM12_20 }, { C_F }},

/* fmul<.f> a,limm,c 0011011000000000F111CCCCCCAAAAAA.  */
{ "fmul", 0x36007000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RA, LIMM, RC }, { C_F }},

/* fmul<.f> a,b,limm 00110bbb00000000FBBB111110AAAAAA.  */
{ "fmul", 0x30000F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RA, RB, LIMM }, { C_F }},

/* fmul<.f> 0,limm,c 0011011000000000F111CCCCCC111110.  */
{ "fmul", 0x3600703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, LIMM, RC }, { C_F }},

/* fmul<.f> 0,b,limm 00110bbb00000000FBBB111110111110.  */
{ "fmul", 0x30000FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, RB, LIMM }, { C_F }},

/* fmul<.f><.cc> 0,limm,c 0011011011000000F111CCCCCC0QQQQQ.  */
{ "fmul", 0x36C07000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, LIMM, RC }, { C_F, C_CC }},

/* fmul<.f><.cc> b,b,limm 00110bbb11000000FBBB1111100QQQQQ.  */
{ "fmul", 0x30C00F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* fmul<.f> a,limm,u6 0011011001000000F111uuuuuuAAAAAA.  */
{ "fmul", 0x36407000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RA, LIMM, UIMM6_20 }, { C_F }},

/* fmul<.f> 0,limm,u6 0011011001000000F111uuuuuu111110.  */
{ "fmul", 0x3640703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* fmul<.f><.cc> 0,limm,u6 0011011011000000F111uuuuuu1QQQQQ.  */
{ "fmul", 0x36C07020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* fmul<.f> 0,limm,s12 0011011010000000F111ssssssSSSSSS.  */
{ "fmul", 0x36807000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* fmul<.f> a,limm,limm 0011011000000000F111111110AAAAAA.  */
{ "fmul", 0x36007F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RA, LIMM, LIMMdup }, { C_F }},

/* fmul<.f> 0,limm,limm 0011011000000000F111111110111110.  */
{ "fmul", 0x36007FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, LIMM, LIMMdup }, { C_F }},

/* fmul<.f><.cc> 0,limm,limm 0011011011000000F1111111100QQQQQ.  */
{ "fmul", 0x36C07F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* fsadd a,b,c 00110bbb000000010BBBCCCCCCAAAAAA.  */
{ "fsadd", 0x30010000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, RB, RC }, { 0 }},

/* fsadd 0,b,c 00110bbb000000010BBBCCCCCC111110.  */
{ "fsadd", 0x3001003E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, RB, RC }, { 0 }},

/* fsadd<.cc> b,b,c 00110bbb110000010BBBCCCCCC0QQQQQ.  */
{ "fsadd", 0x30C10000, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, RC }, { C_CC }},

/* fsadd a,b,u6 00110bbb010000010BBBuuuuuuAAAAAA.  */
{ "fsadd", 0x30410000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, RB, UIMM6_20 }, { 0 }},

/* fsadd 0,b,u6 00110bbb010000010BBBuuuuuu111110.  */
{ "fsadd", 0x3041003E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, RB, UIMM6_20 }, { 0 }},

/* fsadd<.cc> b,b,u6 00110bbb110000010BBBuuuuuu1QQQQQ.  */
{ "fsadd", 0x30C10020, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, UIMM6_20 }, { C_CC }},

/* fsadd b,b,s12 00110bbb100000010BBBssssssSSSSSS.  */
{ "fsadd", 0x30810000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, SIMM12_20 }, { 0 }},

/* fsadd a,limm,c 00110110000000010111CCCCCCAAAAAA.  */
{ "fsadd", 0x36017000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, LIMM, RC }, { 0 }},

/* fsadd a,b,limm 00110bbb000000010BBB111110AAAAAA.  */
{ "fsadd", 0x30010F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, RB, LIMM }, { 0 }},

/* fsadd 0,limm,c 00110110000000010111CCCCCC111110.  */
{ "fsadd", 0x3601703E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, RC }, { 0 }},

/* fsadd 0,b,limm 00110bbb000000010BBB111110111110.  */
{ "fsadd", 0x30010FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, RB, LIMM }, { 0 }},

/* fsadd<.cc> b,b,limm 00110bbb110000010BBB1111100QQQQQ.  */
{ "fsadd", 0x30C10F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, LIMM }, { C_CC }},

/* fsadd<.cc> 0,limm,c 00110110110000010111CCCCCC0QQQQQ.  */
{ "fsadd", 0x36C17000, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, RC }, { C_CC }},

/* fsadd a,limm,u6 00110110010000010111uuuuuuAAAAAA.  */
{ "fsadd", 0x36417000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, LIMM, UIMM6_20 }, { 0 }},

/* fsadd 0,limm,u6 00110110010000010111uuuuuu111110.  */
{ "fsadd", 0x3641703E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* fsadd<.cc> 0,limm,u6 00110110110000010111uuuuuu1QQQQQ.  */
{ "fsadd", 0x36C17020, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* fsadd 0,limm,s12 00110110100000010111ssssssSSSSSS.  */
{ "fsadd", 0x36817000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* fsadd a,limm,limm 00110110000000010111111110AAAAAA.  */
{ "fsadd", 0x36017F80, 0xFFFFFFC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, LIMM, LIMMdup }, { 0 }},

/* fsadd 0,limm,limm 00110110000000010111111110111110.  */
{ "fsadd", 0x36017FBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, LIMMdup }, { 0 }},

/* fsadd<.cc> 0,limm,limm 001101101100000101111111100QQQQQ.  */
{ "fsadd", 0x36C17F80, 0xFFFFFFE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, LIMMdup }, { C_CC }},

/* fscmp b,c 00110bbb000000111BBBCCCCCC000000.  */
{ "fscmp", 0x30038000, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RC }, { 0 }},

/* fscmp<.cc> b,c 00110bbb110000111BBBCCCCCC0QQQQQ.  */
{ "fscmp", 0x30C38000, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RC }, { C_CC }},

/* fscmp b,u6 00110bbb010000111BBBuuuuuu000000.  */
{ "fscmp", 0x30438000, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, UIMM6_20 }, { 0 }},

/* fscmp<.cc> b,u6 00110bbb110000111BBBuuuuuu1QQQQQ.  */
{ "fscmp", 0x30C38020, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, UIMM6_20 }, { C_CC }},

/* fscmp b,s12 00110bbb100000111BBBssssssSSSSSS.  */
{ "fscmp", 0x30838000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, SIMM12_20 }, { 0 }},

/* fscmp limm,c 00110110000000111111CCCCCC000000.  */
{ "fscmp", 0x3603F000, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { LIMM, RC }, { 0 }},

/* fscmp b,limm 00110bbb000000111BBB111110000000.  */
{ "fscmp", 0x30038F80, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, LIMM }, { 0 }},

/* fscmp<.cc> b,limm 00110bbb110000111BBB1111100QQQQQ.  */
{ "fscmp", 0x30C38F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, LIMM }, { C_CC }},

/* fscmp<.cc> limm,c 00110110110000111111CCCCCC0QQQQQ.  */
{ "fscmp", 0x36C3F000, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { LIMM, RC }, { C_CC }},

/* fscmp limm,u6 00110110010000111111uuuuuu000000.  */
{ "fscmp", 0x3643F000, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { LIMM, UIMM6_20 }, { 0 }},

/* fscmp<.cc> limm,u6 00110110110000111111uuuuuu1QQQQQ.  */
{ "fscmp", 0x36C3F020, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { LIMM, UIMM6_20 }, { C_CC }},

/* fscmp limm,s12 00110110100000111111ssssssSSSSSS.  */
{ "fscmp", 0x3683F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { LIMM, SIMM12_20 }, { 0 }},

/* fscmp limm,limm 00110110000000111111111110000000.  */
{ "fscmp", 0x3603FF80, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { LIMM, LIMMdup }, { 0 }},

/* fscmp<.cc> limm,limm 001101101100001111111111100QQQQQ.  */
{ "fscmp", 0x36C3FF80, 0xFFFFFFE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { LIMM, LIMMdup }, { C_CC }},

/* fscmpf b,c 00110bbb000001001BBBCCCCCC000000.  */
{ "fscmpf", 0x30048000, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RC }, { 0 }},

/* fscmpf<.cc> b,c 00110bbb110001001BBBCCCCCC0QQQQQ.  */
{ "fscmpf", 0x30C48000, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RC }, { C_CC }},

/* fscmpf b,u6 00110bbb010001001BBBuuuuuu000000.  */
{ "fscmpf", 0x30448000, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, UIMM6_20 }, { 0 }},

/* fscmpf<.cc> b,u6 00110bbb110001001BBBuuuuuu1QQQQQ.  */
{ "fscmpf", 0x30C48020, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, UIMM6_20 }, { C_CC }},

/* fscmpf b,s12 00110bbb100001001BBBssssssSSSSSS.  */
{ "fscmpf", 0x30848000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, SIMM12_20 }, { 0 }},

/* fscmpf limm,c 00110110000001001111CCCCCC000000.  */
{ "fscmpf", 0x3604F000, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { LIMM, RC }, { 0 }},

/* fscmpf b,limm 00110bbb000001001BBB111110000000.  */
{ "fscmpf", 0x30048F80, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, LIMM }, { 0 }},

/* fscmpf<.cc> b,limm 00110bbb110001001BBB1111100QQQQQ.  */
{ "fscmpf", 0x30C48F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, LIMM }, { C_CC }},

/* fscmpf<.cc> limm,c 00110110110001001111CCCCCC0QQQQQ.  */
{ "fscmpf", 0x36C4F000, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { LIMM, RC }, { C_CC }},

/* fscmpf limm,u6 00110110010001001111uuuuuu000000.  */
{ "fscmpf", 0x3644F000, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { LIMM, UIMM6_20 }, { 0 }},

/* fscmpf<.cc> limm,u6 00110110110001001111uuuuuu1QQQQQ.  */
{ "fscmpf", 0x36C4F020, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { LIMM, UIMM6_20 }, { C_CC }},

/* fscmpf limm,s12 00110110100001001111ssssssSSSSSS.  */
{ "fscmpf", 0x3684F000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { LIMM, SIMM12_20 }, { 0 }},

/* fscmpf limm,limm 00110110000001001111111110000000.  */
{ "fscmpf", 0x3604FF80, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { LIMM, LIMMdup }, { 0 }},

/* fscmpf<.cc> limm,limm 001101101100010011111111100QQQQQ.  */
{ "fscmpf", 0x36C4FF80, 0xFFFFFFE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { LIMM, LIMMdup }, { C_CC }},

/* fsdiv a,b,c 00110bbb000001110BBBCCCCCCAAAAAA.  */
{ "fsdiv", 0x30070000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, RB, RC }, { 0 }},

/* fsdiv 0,b,c 00110bbb000001110BBBCCCCCC111110.  */
{ "fsdiv", 0x3007003E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, RB, RC }, { 0 }},

/* fsdiv<.cc> b,b,c 00110bbb110001110BBBCCCCCC0QQQQQ.  */
{ "fsdiv", 0x30C70000, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, RC }, { C_CC }},

/* fsdiv a,b,u6 00110bbb010001110BBBuuuuuuAAAAAA.  */
{ "fsdiv", 0x30470000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, RB, UIMM6_20 }, { 0 }},

/* fsdiv 0,b,u6 00110bbb010001110BBBuuuuuu111110.  */
{ "fsdiv", 0x3047003E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, RB, UIMM6_20 }, { 0 }},

/* fsdiv<.cc> b,b,u6 00110bbb110001110BBBuuuuuu1QQQQQ.  */
{ "fsdiv", 0x30C70020, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, UIMM6_20 }, { C_CC }},

/* fsdiv b,b,s12 00110bbb100001110BBBssssssSSSSSS.  */
{ "fsdiv", 0x30870000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, SIMM12_20 }, { 0 }},

/* fsdiv a,limm,c 00110110000001110111CCCCCCAAAAAA.  */
{ "fsdiv", 0x36077000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, LIMM, RC }, { 0 }},

/* fsdiv a,b,limm 00110bbb000001110BBB111110AAAAAA.  */
{ "fsdiv", 0x30070F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, RB, LIMM }, { 0 }},

/* fsdiv 0,limm,c 00110110000001110111CCCCCC111110.  */
{ "fsdiv", 0x3607703E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, RC }, { 0 }},

/* fsdiv 0,b,limm 00110bbb000001110BBB111110111110.  */
{ "fsdiv", 0x30070FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, RB, LIMM }, { 0 }},

/* fsdiv<.cc> b,b,limm 00110bbb110001110BBB1111100QQQQQ.  */
{ "fsdiv", 0x30C70F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, LIMM }, { C_CC }},

/* fsdiv<.cc> 0,limm,c 00110110110001110111CCCCCC0QQQQQ.  */
{ "fsdiv", 0x36C77000, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, RC }, { C_CC }},

/* fsdiv a,limm,u6 00110110010001110111uuuuuuAAAAAA.  */
{ "fsdiv", 0x36477000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, LIMM, UIMM6_20 }, { 0 }},

/* fsdiv 0,limm,u6 00110110010001110111uuuuuu111110.  */
{ "fsdiv", 0x3647703E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* fsdiv<.cc> 0,limm,u6 00110110110001110111uuuuuu1QQQQQ.  */
{ "fsdiv", 0x36C77020, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* fsdiv 0,limm,s12 00110110100001110111ssssssSSSSSS.  */
{ "fsdiv", 0x36877000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* fsdiv a,limm,limm 00110110000001110111111110AAAAAA.  */
{ "fsdiv", 0x36077F80, 0xFFFFFFC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, LIMM, LIMMdup }, { 0 }},

/* fsdiv 0,limm,limm 00110110000001110111111110111110.  */
{ "fsdiv", 0x36077FBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, LIMMdup }, { 0 }},

/* fsdiv<.cc> 0,limm,limm 001101101100011101111111100QQQQQ.  */
{ "fsdiv", 0x36C77F80, 0xFFFFFFE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, LIMMdup }, { C_CC }},

/* fsmadd a,b,c 00110bbb000001010BBBCCCCCCAAAAAA.  */
{ "fsmadd", 0x30050000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, RB, RC }, { 0 }},

/* fsmadd 0,b,c 00110bbb000001010BBBCCCCCC111110.  */
{ "fsmadd", 0x3005003E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, RB, RC }, { 0 }},

/* fsmadd<.cc> b,b,c 00110bbb110001010BBBCCCCCC0QQQQQ.  */
{ "fsmadd", 0x30C50000, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, RC }, { C_CC }},

/* fsmadd a,b,u6 00110bbb010001010BBBuuuuuuAAAAAA.  */
{ "fsmadd", 0x30450000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, RB, UIMM6_20 }, { 0 }},

/* fsmadd 0,b,u6 00110bbb010001010BBBuuuuuu111110.  */
{ "fsmadd", 0x3045003E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, RB, UIMM6_20 }, { 0 }},

/* fsmadd<.cc> b,b,u6 00110bbb110001010BBBuuuuuu1QQQQQ.  */
{ "fsmadd", 0x30C50020, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, UIMM6_20 }, { C_CC }},

/* fsmadd b,b,s12 00110bbb100001010BBBssssssSSSSSS.  */
{ "fsmadd", 0x30850000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, SIMM12_20 }, { 0 }},

/* fsmadd a,limm,c 00110110000001010111CCCCCCAAAAAA.  */
{ "fsmadd", 0x36057000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, LIMM, RC }, { 0 }},

/* fsmadd a,b,limm 00110bbb000001010BBB111110AAAAAA.  */
{ "fsmadd", 0x30050F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, RB, LIMM }, { 0 }},

/* fsmadd 0,limm,c 00110110000001010111CCCCCC111110.  */
{ "fsmadd", 0x3605703E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, RC }, { 0 }},

/* fsmadd 0,b,limm 00110bbb000001010BBB111110111110.  */
{ "fsmadd", 0x30050FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, RB, LIMM }, { 0 }},

/* fsmadd<.cc> b,b,limm 00110bbb110001010BBB1111100QQQQQ.  */
{ "fsmadd", 0x30C50F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, LIMM }, { C_CC }},

/* fsmadd<.cc> 0,limm,c 00110110110001010111CCCCCC0QQQQQ.  */
{ "fsmadd", 0x36C57000, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, RC }, { C_CC }},

/* fsmadd a,limm,u6 00110110010001010111uuuuuuAAAAAA.  */
{ "fsmadd", 0x36457000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, LIMM, UIMM6_20 }, { 0 }},

/* fsmadd 0,limm,u6 00110110010001010111uuuuuu111110.  */
{ "fsmadd", 0x3645703E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* fsmadd<.cc> 0,limm,u6 00110110110001010111uuuuuu1QQQQQ.  */
{ "fsmadd", 0x36C57020, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* fsmadd 0,limm,s12 00110110100001010111ssssssSSSSSS.  */
{ "fsmadd", 0x36857000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* fsmadd a,limm,limm 00110110000001010111111110AAAAAA.  */
{ "fsmadd", 0x36057F80, 0xFFFFFFC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, LIMM, LIMMdup }, { 0 }},

/* fsmadd 0,limm,limm 00110110000001010111111110111110.  */
{ "fsmadd", 0x36057FBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, LIMMdup }, { 0 }},

/* fsmadd<.cc> 0,limm,limm 001101101100010101111111100QQQQQ.  */
{ "fsmadd", 0x36C57F80, 0xFFFFFFE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, LIMMdup }, { C_CC }},

/* fsmsub a,b,c 00110bbb000001100BBBCCCCCCAAAAAA.  */
{ "fsmsub", 0x30060000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, RB, RC }, { 0 }},

/* fsmsub 0,b,c 00110bbb000001100BBBCCCCCC111110.  */
{ "fsmsub", 0x3006003E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, RB, RC }, { 0 }},

/* fsmsub<.cc> b,b,c 00110bbb110001100BBBCCCCCC0QQQQQ.  */
{ "fsmsub", 0x30C60000, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, RC }, { C_CC }},

/* fsmsub a,b,u6 00110bbb010001100BBBuuuuuuAAAAAA.  */
{ "fsmsub", 0x30460000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, RB, UIMM6_20 }, { 0 }},

/* fsmsub 0,b,u6 00110bbb010001100BBBuuuuuu111110.  */
{ "fsmsub", 0x3046003E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, RB, UIMM6_20 }, { 0 }},

/* fsmsub<.cc> b,b,u6 00110bbb110001100BBBuuuuuu1QQQQQ.  */
{ "fsmsub", 0x30C60020, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, UIMM6_20 }, { C_CC }},

/* fsmsub b,b,s12 00110bbb100001100BBBssssssSSSSSS.  */
{ "fsmsub", 0x30860000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, SIMM12_20 }, { 0 }},

/* fsmsub a,limm,c 00110110000001100111CCCCCCAAAAAA.  */
{ "fsmsub", 0x36067000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, LIMM, RC }, { 0 }},

/* fsmsub a,b,limm 00110bbb000001100BBB111110AAAAAA.  */
{ "fsmsub", 0x30060F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, RB, LIMM }, { 0 }},

/* fsmsub 0,limm,c 00110110000001100111CCCCCC111110.  */
{ "fsmsub", 0x3606703E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, RC }, { 0 }},

/* fsmsub 0,b,limm 00110bbb000001100BBB111110111110.  */
{ "fsmsub", 0x30060FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, RB, LIMM }, { 0 }},

/* fsmsub<.cc> b,b,limm 00110bbb110001100BBB1111100QQQQQ.  */
{ "fsmsub", 0x30C60F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, LIMM }, { C_CC }},

/* fsmsub<.cc> 0,limm,c 00110110110001100111CCCCCC0QQQQQ.  */
{ "fsmsub", 0x36C67000, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, RC }, { C_CC }},

/* fsmsub a,limm,u6 00110110010001100111uuuuuuAAAAAA.  */
{ "fsmsub", 0x36467000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, LIMM, UIMM6_20 }, { 0 }},

/* fsmsub 0,limm,u6 00110110010001100111uuuuuu111110.  */
{ "fsmsub", 0x3646703E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* fsmsub<.cc> 0,limm,u6 00110110110001100111uuuuuu1QQQQQ.  */
{ "fsmsub", 0x36C67020, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* fsmsub 0,limm,s12 00110110100001100111ssssssSSSSSS.  */
{ "fsmsub", 0x36867000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* fsmsub a,limm,limm 00110110000001100111111110AAAAAA.  */
{ "fsmsub", 0x36067F80, 0xFFFFFFC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, LIMM, LIMMdup }, { 0 }},

/* fsmsub 0,limm,limm 00110110000001100111111110111110.  */
{ "fsmsub", 0x36067FBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, LIMMdup }, { 0 }},

/* fsmsub<.cc> 0,limm,limm 001101101100011001111111100QQQQQ.  */
{ "fsmsub", 0x36C67F80, 0xFFFFFFE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, LIMMdup }, { C_CC }},

/* fsmul a,b,c 00110bbb000000000BBBCCCCCCAAAAAA.  */
{ "fsmul", 0x30000000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, RB, RC }, { 0 }},

/* fsmul 0,b,c 00110bbb000000000BBBCCCCCC111110.  */
{ "fsmul", 0x3000003E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, RB, RC }, { 0 }},

/* fsmul<.cc> b,b,c 00110bbb110000000BBBCCCCCC0QQQQQ.  */
{ "fsmul", 0x30C00000, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, RC }, { C_CC }},

/* fsmul a,b,u6 00110bbb010000000BBBuuuuuuAAAAAA.  */
{ "fsmul", 0x30400000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, RB, UIMM6_20 }, { 0 }},

/* fsmul 0,b,u6 00110bbb010000000BBBuuuuuu111110.  */
{ "fsmul", 0x3040003E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, RB, UIMM6_20 }, { 0 }},

/* fsmul<.cc> b,b,u6 00110bbb110000000BBBuuuuuu1QQQQQ.  */
{ "fsmul", 0x30C00020, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, UIMM6_20 }, { C_CC }},

/* fsmul b,b,s12 00110bbb100000000BBBssssssSSSSSS.  */
{ "fsmul", 0x30800000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, SIMM12_20 }, { 0 }},

/* fsmul a,limm,c 00110110000000000111CCCCCCAAAAAA.  */
{ "fsmul", 0x36007000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, LIMM, RC }, { 0 }},

/* fsmul a,b,limm 00110bbb000000000BBB111110AAAAAA.  */
{ "fsmul", 0x30000F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, RB, LIMM }, { 0 }},

/* fsmul 0,limm,c 00110110000000000111CCCCCC111110.  */
{ "fsmul", 0x3600703E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, RC }, { 0 }},

/* fsmul 0,b,limm 00110bbb000000000BBB111110111110.  */
{ "fsmul", 0x30000FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, RB, LIMM }, { 0 }},

/* fsmul<.cc> b,b,limm 00110bbb110000000BBB1111100QQQQQ.  */
{ "fsmul", 0x30C00F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, LIMM }, { C_CC }},

/* fsmul<.cc> 0,limm,c 00110110110000000111CCCCCC0QQQQQ.  */
{ "fsmul", 0x36C07000, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, RC }, { C_CC }},

/* fsmul a,limm,u6 00110110010000000111uuuuuuAAAAAA.  */
{ "fsmul", 0x36407000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, LIMM, UIMM6_20 }, { 0 }},

/* fsmul 0,limm,u6 00110110010000000111uuuuuu111110.  */
{ "fsmul", 0x3640703E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* fsmul<.cc> 0,limm,u6 00110110110000000111uuuuuu1QQQQQ.  */
{ "fsmul", 0x36C07020, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* fsmul 0,limm,s12 00110110100000000111ssssssSSSSSS.  */
{ "fsmul", 0x36807000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* fsmul a,limm,limm 00110110000000000111111110AAAAAA.  */
{ "fsmul", 0x36007F80, 0xFFFFFFC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, LIMM, LIMMdup }, { 0 }},

/* fsmul 0,limm,limm 00110110000000000111111110111110.  */
{ "fsmul", 0x36007FBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, LIMMdup }, { 0 }},

/* fsmul<.cc> 0,limm,limm 001101101100000001111111100QQQQQ.  */
{ "fsmul", 0x36C07F80, 0xFFFFFFE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, LIMMdup }, { C_CC }},

/* fssqrt b,c 00110bbb001011110BBBCCCCCC000000.  */
{ "fssqrt", 0x302F0000, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RC }, { 0 }},

/* fssqrt 0,c 00110110001011110111CCCCCC000000.  */
{ "fssqrt", 0x362F7000, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, RC }, { 0 }},

/* fssqrt b,u6 00110bbb011011110BBBuuuuuu000000.  */
{ "fssqrt", 0x306F0000, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, UIMM6_20 }, { 0 }},

/* fssqrt 0,u6 00110110011011110111uuuuuu000000.  */
{ "fssqrt", 0x366F7000, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, UIMM6_20 }, { 0 }},

/* fssqrt b,limm 00110bbb001011110BBB111110000000.  */
{ "fssqrt", 0x302F0F80, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, LIMM }, { 0 }},

/* fssqrt 0,limm 00110110001011110111111110000000.  */
{ "fssqrt", 0x362F7F80, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM }, { 0 }},

/* fssub a,b,c 00110bbb000000100BBBCCCCCCAAAAAA.  */
{ "fssub", 0x30020000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, RB, RC }, { 0 }},

/* fssub 0,b,c 00110bbb000000100BBBCCCCCC111110.  */
{ "fssub", 0x3002003E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, RB, RC }, { 0 }},

/* fssub<.cc> b,b,c 00110bbb110000100BBBCCCCCC0QQQQQ.  */
{ "fssub", 0x30C20000, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, RC }, { C_CC }},

/* fssub a,b,u6 00110bbb010000100BBBuuuuuuAAAAAA.  */
{ "fssub", 0x30420000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, RB, UIMM6_20 }, { 0 }},

/* fssub 0,b,u6 00110bbb010000100BBBuuuuuu111110.  */
{ "fssub", 0x3042003E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, RB, UIMM6_20 }, { 0 }},

/* fssub<.cc> b,b,u6 00110bbb110000100BBBuuuuuu1QQQQQ.  */
{ "fssub", 0x30C20020, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, UIMM6_20 }, { C_CC }},

/* fssub b,b,s12 00110bbb100000100BBBssssssSSSSSS.  */
{ "fssub", 0x30820000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, SIMM12_20 }, { 0 }},

/* fssub a,limm,c 00110110000000100111CCCCCCAAAAAA.  */
{ "fssub", 0x36027000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, LIMM, RC }, { 0 }},

/* fssub a,b,limm 00110bbb000000100BBB111110AAAAAA.  */
{ "fssub", 0x30020F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, RB, LIMM }, { 0 }},

/* fssub 0,limm,c 00110110000000100111CCCCCC111110.  */
{ "fssub", 0x3602703E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, RC }, { 0 }},

/* fssub 0,b,limm 00110bbb000000100BBB111110111110.  */
{ "fssub", 0x30020FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, RB, LIMM }, { 0 }},

/* fssub<.cc> b,b,limm 00110bbb110000100BBB1111100QQQQQ.  */
{ "fssub", 0x30C20F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RB, RBdup, LIMM }, { C_CC }},

/* fssub<.cc> 0,limm,c 00110110110000100111CCCCCC0QQQQQ.  */
{ "fssub", 0x36C27000, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, RC }, { C_CC }},

/* fssub a,limm,u6 00110110010000100111uuuuuuAAAAAA.  */
{ "fssub", 0x36427000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, LIMM, UIMM6_20 }, { 0 }},

/* fssub 0,limm,u6 00110110010000100111uuuuuu111110.  */
{ "fssub", 0x3642703E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* fssub<.cc> 0,limm,u6 00110110110000100111uuuuuu1QQQQQ.  */
{ "fssub", 0x36C27020, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* fssub 0,limm,s12 00110110100000100111ssssssSSSSSS.  */
{ "fssub", 0x36827000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* fssub a,limm,limm 00110110000000100111111110AAAAAA.  */
{ "fssub", 0x36027F80, 0xFFFFFFC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { RA, LIMM, LIMMdup }, { 0 }},

/* fssub 0,limm,limm 00110110000000100111111110111110.  */
{ "fssub", 0x36027FBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, LIMMdup }, { 0 }},

/* fssub<.cc> 0,limm,limm 001101101100001001111111100QQQQQ.  */
{ "fssub", 0x36C27F80, 0xFFFFFFE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, FLOAT, SP, { ZA, LIMM, LIMMdup }, { C_CC }},

/* fsub<.f> a,b,c 00110bbb00000010FBBBCCCCCCAAAAAA.  */
{ "fsub", 0x30020000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RA, RB, RC }, { C_F }},

/* fsub<.f> 0,b,c 00110bbb00000010FBBBCCCCCC111110.  */
{ "fsub", 0x3002003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, RB, RC }, { C_F }},

/* fsub<.f><.cc> b,b,c 00110bbb11000010FBBBCCCCCC0QQQQQ.  */
{ "fsub", 0x30C20000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RB, RBdup, RC }, { C_F, C_CC }},

/* fsub<.f> a,b,u6 00110bbb01000010FBBBuuuuuuAAAAAA.  */
{ "fsub", 0x30420000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RA, RB, UIMM6_20 }, { C_F }},

/* fsub<.f> 0,b,u6 00110bbb01000010FBBBuuuuuu111110.  */
{ "fsub", 0x3042003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, RB, UIMM6_20 }, { C_F }},

/* fsub<.f><.cc> b,b,u6 00110bbb11000010FBBBuuuuuu1QQQQQ.  */
{ "fsub", 0x30C20020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* fsub<.f> b,b,s12 00110bbb10000010FBBBssssssSSSSSS.  */
{ "fsub", 0x30820000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RB, RBdup, SIMM12_20 }, { C_F }},

/* fsub<.f> a,limm,c 0011011000000010F111CCCCCCAAAAAA.  */
{ "fsub", 0x36027000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RA, LIMM, RC }, { C_F }},

/* fsub<.f> a,b,limm 00110bbb00000010FBBB111110AAAAAA.  */
{ "fsub", 0x30020F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RA, RB, LIMM }, { C_F }},

/* fsub<.f> 0,limm,c 0011011000000010F111CCCCCC111110.  */
{ "fsub", 0x3602703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, LIMM, RC }, { C_F }},

/* fsub<.f> 0,b,limm 00110bbb00000010FBBB111110111110.  */
{ "fsub", 0x30020FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, RB, LIMM }, { C_F }},

/* fsub<.f><.cc> 0,limm,c 0011011011000010F111CCCCCC0QQQQQ.  */
{ "fsub", 0x36C27000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, LIMM, RC }, { C_F, C_CC }},

/* fsub<.f><.cc> b,b,limm 00110bbb11000010FBBB1111100QQQQQ.  */
{ "fsub", 0x30C20F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* fsub<.f> a,limm,u6 0011011001000010F111uuuuuuAAAAAA.  */
{ "fsub", 0x36427000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RA, LIMM, UIMM6_20 }, { C_F }},

/* fsub<.f> 0,limm,u6 0011011001000010F111uuuuuu111110.  */
{ "fsub", 0x3642703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* fsub<.f><.cc> 0,limm,u6 0011011011000010F111uuuuuu1QQQQQ.  */
{ "fsub", 0x36C27020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* fsub<.f> 0,limm,s12 0011011010000010F111ssssssSSSSSS.  */
{ "fsub", 0x36827000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* fsub<.f> a,limm,limm 0011011000000010F111111110AAAAAA.  */
{ "fsub", 0x36027F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { RA, LIMM, LIMMdup }, { C_F }},

/* fsub<.f> 0,limm,limm 0011011000000010F111111110111110.  */
{ "fsub", 0x36027FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, LIMM, LIMMdup }, { C_F }},

/* fsub<.f><.cc> 0,limm,limm 0011011011000010F1111111100QQQQQ.  */
{ "fsub", 0x36C27F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, FLOAT, SPX, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* fxtr<.f> a,b,c 00110bbb00100110FBBBCCCCCCAAAAAA.  */
{ "fxtr", 0x30260000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* fxtr<.f><.cc> b,b,c 00110bbb11100110FBBBCCCCCC0QQQQQ.  */
{ "fxtr", 0x30E60000, 0xF8FF0020, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* fxtr<.f> a,b,u6 00110bbb01100110FBBBuuuuuuAAAAAA.  */
{ "fxtr", 0x30660000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* fxtr<.f><.cc> b,b,u6 00110bbb11100110FBBBuuuuuu1QQQQQ.  */
{ "fxtr", 0x30E60020, 0xF8FF0020, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* fxtr<.f> b,b,s12 00110bbb10100110FBBBssssssSSSSSS.  */
{ "fxtr", 0x30A60000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* fxtr<.f> a,limm,c 0011011000100110F111CCCCCCAAAAAA.  */
{ "fxtr", 0x36267000, 0xFFFF7000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* fxtr<.f> a,b,limm 00110bbb00100110FBBB111110AAAAAA.  */
{ "fxtr", 0x30260F80, 0xF8FF0FC0, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* fxtr<.f><.cc> b,b,limm 00110bbb11100110FBBB1111100QQQQQ.  */
{ "fxtr", 0x30E60F80, 0xF8FF0FE0, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* getacc b,c 00101bbb001011110BBBCCCCCC011000.  */
{ "getacc", 0x282F0018, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RC }, { 0 }},

/* getacc 0,c 00101110001011110111CCCCCC011000.  */
{ "getacc", 0x2E2F7018, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RC }, { 0 }},

/* getacc b,u6 00101bbb011011110BBBuuuuuu011000.  */
{ "getacc", 0x286F0018, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, UIMM6_20 }, { 0 }},

/* getacc 0,u6 00101110011011110111uuuuuu011000.  */
{ "getacc", 0x2E6F7018, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, UIMM6_20 }, { 0 }},

/* getacc b,limm 00101bbb001011110BBB111110011000.  */
{ "getacc", 0x282F0F98, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, LIMM }, { 0 }},

/* getacc 0,limm 00101110001011110111111110011000.  */
{ "getacc", 0x2E2F7F98, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM }, { 0 }},

/* iaddr<.f> a,b,c 00110bbb00100111FBBBCCCCCCAAAAAA.  */
{ "iaddr", 0x30270000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* iaddr<.f><.cc> b,b,c 00110bbb11100111FBBBCCCCCC0QQQQQ.  */
{ "iaddr", 0x30E70000, 0xF8FF0020, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* iaddr<.f> a,b,u6 00110bbb01100111FBBBuuuuuuAAAAAA.  */
{ "iaddr", 0x30670000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* iaddr<.f><.cc> b,b,u6 00110bbb11100111FBBBuuuuuu1QQQQQ.  */
{ "iaddr", 0x30E70020, 0xF8FF0020, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* iaddr<.f> b,b,s12 00110bbb10100111FBBBssssssSSSSSS.  */
{ "iaddr", 0x30A70000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* iaddr<.f> a,limm,c 0011011000100111F111CCCCCCAAAAAA.  */
{ "iaddr", 0x36277000, 0xFFFF7000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* iaddr<.f> a,b,limm 00110bbb00100111FBBB111110AAAAAA.  */
{ "iaddr", 0x30270F80, 0xF8FF0FC0, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* iaddr<.f><.cc> b,b,limm 00110bbb11100111FBBB1111100QQQQQ.  */
{ "iaddr", 0x30E70F80, 0xF8FF0FE0, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* j c 00100RRR001000000RRRCCCCCCRRRRRR.  */
{ "j", 0x20200000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { BRAKET, RC, BRAKETdup }, { 0 }},

/* j BLINK 00100RRR001000000RRR011111RRRRRR.  */
{ "j", 0x202007C0, 0xF8FF8FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { BRAKET, BLINK, BRAKETdup }, { 0 }},

/* j.F ILINK1 00100RRR001000001RRR011101RRRRRR.  */
{ "j", 0x20208740, 0xF8FF8FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { BRAKET, ILINK1, BRAKETdup }, { C_FHARD }},

/* j.F ILINK2 00100RRR001000001RRR011110RRRRRR.  */
{ "j", 0x20208780, 0xF8FF8FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { BRAKET, ILINK2, BRAKETdup }, { C_FHARD }},

/* jcc c 00100RRR111000000RRRCCCCCC0QQQQQ.  */
{ "j", 0x20E00000, 0xF8FF8020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, COND, { BRAKET, RC, BRAKETdup }, { C_CC }},

/* jcc BLINK 00100RRR111000000RRR0111110QQQQQ.  */
{ "j", 0x20E007C0, 0xF8FF8FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, COND, { BRAKET, BLINK, BRAKETdup }, { C_CC }},

/* j.Fcc ILINK1 00100RRR111000001RRR0111010QQQQQ.  */
{ "j", 0x20E08740, 0xF8FF8FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, COND, { BRAKET, ILINK1, BRAKETdup }, { C_FHARD, C_CC }},

/* j.Fcc ILINK2 00100RRR111000001RRR0111100QQQQQ.  */
{ "j", 0x20E08780, 0xF8FF8FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, COND, { BRAKET, ILINK2, BRAKETdup }, { C_FHARD, C_CC }},

/* j.D c 00100RRR001000010RRRCCCCCCRRRRRR.  */
{ "j", 0x20210000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { BRAKET, RC, BRAKETdup }, { C_DHARD }},

/* j.D BLINK 00100RRR001000010RRR011111RRRRRR.  */
{ "j", 0x202107C0, 0xF8FF8FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { BRAKET, BLINK, BRAKETdup }, { C_DHARD }},

/* j.Dcc c 00100RRR111000010RRRCCCCCC0QQQQQ.  */
{ "j", 0x20E10000, 0xF8FF8020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, COND, { BRAKET, RC, BRAKETdup }, { C_CC, C_DHARD }},

/* j.Dcc BLINK 00100RRR111000010RRR0111110QQQQQ.  */
{ "j", 0x20E107C0, 0xF8FF8FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, COND, { BRAKET, BLINK, BRAKETdup }, { C_CC, C_DHARD }},

/* j c 00100RRR00100000RRRRCCCCCCRRRRRR.  */
{ "j", 0x20200000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { BRAKET, RC, BRAKETdup }, { 0 }},

/* j BLINK 00100RRR00100000RRRR011111RRRRRR.  */
{ "j", 0x202007C0, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { BRAKET, BLINK, BRAKETdup }, { 0 }},

/* jcc c 00100RRR11100000RRRRCCCCCC0QQQQQ.  */
{ "j", 0x20E00000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, COND, { BRAKET, RC, BRAKETdup }, { C_CC }},

/* jcc BLINK 00100RRR11100000RRRR0111110QQQQQ.  */
{ "j", 0x20E007C0, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, COND, { BRAKET, BLINK, BRAKETdup }, { C_CC }},

/* j.D c 00100RRR00100001RRRRCCCCCCRRRRRR.  */
{ "j", 0x20210000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { BRAKET, RC, BRAKETdup }, { C_DHARD }},

/* j.D BLINK 00100RRR00100001RRRR011111RRRRRR.  */
{ "j", 0x202107C0, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { BRAKET, BLINK, BRAKETdup }, { C_DHARD }},

/* j.Dcc c 00100RRR11100001RRRRCCCCCC0QQQQQ.  */
{ "j", 0x20E10000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, COND, { BRAKET, RC, BRAKETdup }, { C_CC, C_DHARD }},

/* j.Dcc BLINK 00100RRR11100001RRRR0111110QQQQQ.  */
{ "j", 0x20E107C0, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, COND, { BRAKET, BLINK, BRAKETdup }, { C_CC, C_DHARD }},

/* j s12 00100RRR101000000RRRssssssSSSSSS.  */
{ "j", 0x20A00000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { SIMM12_20 }, { 0 }},

/* j.D s12 00100RRR101000010RRRssssssSSSSSS.  */
{ "j", 0x20A10000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { SIMM12_20 }, { C_DHARD }},

/* j s12 00100RRR10100000RRRRssssssSSSSSS.  */
{ "j", 0x20A00000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { SIMM12_20 }, { 0 }},

/* j.D s12 00100RRR10100001RRRRssssssSSSSSS.  */
{ "j", 0x20A10000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { SIMM12_20 }, { C_DHARD }},

/* j u6 00100RRR011000000RRRuuuuuuRRRRRR.  */
{ "j", 0x20600000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { UIMM6_20 }, { 0 }},

/* jcc u6 00100RRR111000000RRRuuuuuu1QQQQQ.  */
{ "j", 0x20E00020, 0xF8FF8020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, COND, { UIMM6_20 }, { C_CC }},

/* j.D u6 00100RRR011000010RRRuuuuuuRRRRRR.  */
{ "j", 0x20610000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { UIMM6_20 }, { C_DHARD }},

/* j.Dcc u6 00100RRR111000010RRRuuuuuu1QQQQQ.  */
{ "j", 0x20E10020, 0xF8FF8020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, COND, { UIMM6_20 }, { C_CC, C_DHARD }},

/* j u6 00100RRR01100000RRRRuuuuuuRRRRRR.  */
{ "j", 0x20600000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { UIMM6_20 }, { 0 }},

/* jcc u6 00100RRR11100000RRRRuuuuuu1QQQQQ.  */
{ "j", 0x20E00020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, COND, { UIMM6_20 }, { C_CC }},

/* j.D u6 00100RRR01100001RRRRuuuuuuRRRRRR.  */
{ "j", 0x20610000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { UIMM6_20 }, { C_DHARD }},

/* j.Dcc u6 00100RRR11100001RRRRuuuuuu1QQQQQ.  */
{ "j", 0x20E10020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, COND, { UIMM6_20 }, { C_CC, C_DHARD }},

/* j limm 00100RRR001000000RRR111110RRRRRR.  */
{ "j", 0x20200F80, 0xF8FF8FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { LIMM }, { 0 }},

/* jcc limm 00100RRR111000000RRR1111100QQQQQ.  */
{ "j", 0x20E00F80, 0xF8FF8FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, COND, { LIMM }, { C_CC }},

/* j limm 00100RRR00100000RRRR111110RRRRRR.  */
{ "j", 0x20200F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { LIMM }, { 0 }},

/* jcc limm 00100RRR11100000RRRR1111100QQQQQ.  */
{ "j", 0x20E00F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, COND, { LIMM }, { C_CC }},

/* jeq_sCC_EQ BLINK 0111110011100000.  */
{ "jeq_s", 0x00007CE0, 0x0000FFFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, COND, { BRAKET, BLINK_S, BRAKETdup }, { C_CC_EQ }},

/* jeq_sCC_EQ BLINK 0111110011100000.  */
{ "jeq_s", 0x00007CE0, 0x0000FFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, COND, { BRAKET, BLINK_S, BRAKETdup }, { C_CC_EQ }},

/* jl c 00100RRR001000100RRRCCCCCCRRRRRR.  */
{ "jl", 0x20220000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { BRAKET, RC, BRAKETdup }, { 0 }},

/* jlcc c 00100RRR111000100RRRCCCCCC0QQQQQ.  */
{ "jl", 0x20E20000, 0xF8FF8020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, COND, { BRAKET, RC, BRAKETdup }, { C_CC }},

/* jl.D c 00100RRR001000110RRRCCCCCCRRRRRR.  */
{ "jl", 0x20230000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { BRAKET, RC, BRAKETdup }, { C_DHARD }},

/* jl.Dcc c 00100RRR111000110RRRCCCCCC0QQQQQ.  */
{ "jl", 0x20E30000, 0xF8FF8020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, COND, { BRAKET, RC, BRAKETdup }, { C_CC, C_DHARD }},

/* jl c 00100RRR00100010RRRRCCCCCCRRRRRR.  */
{ "jl", 0x20220000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { BRAKET, RC, BRAKETdup }, { 0 }},

/* jlcc c 00100RRR11100010RRRRCCCCCC0QQQQQ.  */
{ "jl", 0x20E20000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { BRAKET, RC, BRAKETdup }, { C_CC }},

/* jl.D c 00100RRR00100011RRRRCCCCCCRRRRRR.  */
{ "jl", 0x20230000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { BRAKET, RC, BRAKETdup }, { C_DHARD }},

/* jl.Dcc c 00100RRR11100011RRRRCCCCCC0QQQQQ.  */
{ "jl", 0x20E30000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { BRAKET, RC, BRAKETdup }, { C_CC, C_DHARD }},

/* jl s12 00100RRR101000100RRRssssssSSSSSS.  */
{ "jl", 0x20A20000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { SIMM12_20 }, { 0 }},

/* jl.D s12 00100RRR101000110RRRssssssSSSSSS.  */
{ "jl", 0x20A30000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { SIMM12_20 }, { C_DHARD }},

/* jl s12 00100RRR10100010RRRRssssssSSSSSS.  */
{ "jl", 0x20A20000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { SIMM12_20 }, { 0 }},

/* jl.D s12 00100RRR10100011RRRRssssssSSSSSS.  */
{ "jl", 0x20A30000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { SIMM12_20 }, { C_DHARD }},

/* jl u6 00100RRR011000100RRRuuuuuuRRRRRR.  */
{ "jl", 0x20620000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { UIMM6_20 }, { 0 }},

/* jlcc u6 00100RRR111000100RRRuuuuuu1QQQQQ.  */
{ "jl", 0x20E20020, 0xF8FF8020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, COND, { UIMM6_20 }, { C_CC }},

/* jl.D u6 00100RRR011000110RRRuuuuuuRRRRRR.  */
{ "jl", 0x20630000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { UIMM6_20 }, { C_DHARD }},

/* jl.Dcc u6 00100RRR111000110RRRuuuuuu1QQQQQ.  */
{ "jl", 0x20E30020, 0xF8FF8020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, COND, { UIMM6_20 }, { C_CC, C_DHARD }},

/* jl u6 00100RRR01100010RRRRuuuuuuRRRRRR.  */
{ "jl", 0x20620000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { UIMM6_20 }, { 0 }},

/* jlcc u6 00100RRR11100010RRRRuuuuuu1QQQQQ.  */
{ "jl", 0x20E20020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { UIMM6_20 }, { C_CC }},

/* jl.D u6 00100RRR01100011RRRRuuuuuuRRRRRR.  */
{ "jl", 0x20630000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { UIMM6_20 }, { C_DHARD }},

/* jl.Dcc u6 00100RRR11100011RRRRuuuuuu1QQQQQ.  */
{ "jl", 0x20E30020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { UIMM6_20 }, { C_CC, C_DHARD }},

/* jl limm 00100RRR001000100RRR111110RRRRRR.  */
{ "jl", 0x20220F80, 0xF8FF8FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { LIMM }, { 0 }},

/* jlcc limm 00100RRR111000100RRR1111100QQQQQ.  */
{ "jl", 0x20E20F80, 0xF8FF8FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, COND, { LIMM }, { C_CC }},

/* jl limm 00100RRR00100010RRRR111110RRRRRR.  */
{ "jl", 0x20220F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { LIMM }, { 0 }},

/* jlcc limm 00100RRR11100010RRRR1111100QQQQQ.  */
{ "jl", 0x20E20F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { LIMM }, { C_CC }},

/* jli_s u10 010110uuuuuuuuuu.  */
{ "jli_s", 0x00005800, 0x0000FC00, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JLI, CD1, { UIMM10_6_S }, { 0 }},
{ "jli_s", 0x00005800, 0x0000FC00, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JLI, CD1, { UIMM10_6_S_JLIOFF }, { 0 }},

/* jl_s b 01111bbb01000000.  */
{ "jl_s", 0x00007840, 0x0000F8FF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { BRAKET, RB_S, BRAKETdup }, { 0 }},

/* jl_s.D b 01111bbb01100000.  */
{ "jl_s", 0x00007860, 0x0000F8FF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { BRAKET, RB_S, BRAKETdup }, { C_DHARD }},

/* jl_s b 01111bbb01000000.  */
{ "jl_s", 0x00007840, 0x0000F8FF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { BRAKET, RB_S, BRAKETdup }, { 0 }},

/* jl_s.D b 01111bbb01100000.  */
{ "jl_s", 0x00007860, 0x0000F8FF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { BRAKET, RB_S, BRAKETdup }, { C_DHARD }},

/* jne_sCC_NE BLINK 0111110111100000.  */
{ "jne_s", 0x00007DE0, 0x0000FFFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, COND, { BRAKET, BLINK_S, BRAKETdup }, { C_CC_NE }},

/* jne_sCC_NE BLINK 0111110111100000.  */
{ "jne_s", 0x00007DE0, 0x0000FFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, COND, { BRAKET, BLINK_S, BRAKETdup }, { C_CC_NE }},

/* j_s b 01111bbb00000000.  */
{ "j_s", 0x00007800, 0x0000F8FF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { BRAKET, RB_S, BRAKETdup }, { 0 }},

/* j_s.D b 01111bbb00100000.  */
{ "j_s", 0x00007820, 0x0000F8FF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { BRAKET, RB_S, BRAKETdup }, { C_DHARD }},

/* j_s BLINK 0111111011100000.  */
{ "j_s", 0x00007EE0, 0x0000FFFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { BRAKET, BLINK_S, BRAKETdup }, { 0 }},

/* j_s.D BLINK 0111111111100000.  */
{ "j_s", 0x00007FE0, 0x0000FFFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, JUMP, NONE, { BRAKET, BLINK_S, BRAKETdup }, { C_DHARD }},

/* j_s b 01111bbb00000000.  */
{ "j_s", 0x00007800, 0x0000F8FF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { BRAKET, RB_S, BRAKETdup }, { 0 }},

/* j_s.D b 01111bbb00100000.  */
{ "j_s", 0x00007820, 0x0000F8FF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { BRAKET, RB_S, BRAKETdup }, { C_DHARD }},

/* j_s BLINK 0111111011100000.  */
{ "j_s", 0x00007EE0, 0x0000FFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { BRAKET, BLINK_S, BRAKETdup }, { 0 }},

/* j_s.D BLINK 0111111111100000.  */
{ "j_s", 0x00007FE0, 0x0000FFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, JUMP, NONE, { BRAKET, BLINK_S, BRAKETdup }, { C_DHARD }},

/* kflag c 00100RRR001010011RRRCCCCCCRRRRRR.  */
{ "kflag", 0x20298000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { RC }, { 0 }},

/* kflag<.cc> c 00100RRR111010011RRRCCCCCC0QQQQQ.  */
{ "kflag", 0x20E98000, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { RC }, { C_CC }},

/* kflag u6 00100RRR011010011RRRuuuuuuRRRRRR.  */
{ "kflag", 0x20698000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { UIMM6_20 }, { 0 }},

/* kflag<.cc> u6 00100RRR111010011RRRuuuuuu1QQQQQ.  */
{ "kflag", 0x20E98020, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { UIMM6_20 }, { C_CC }},

/* kflag s12 00100RRR101010011RRRssssssSSSSSS.  */
{ "kflag", 0x20A98000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { SIMM12_20 }, { 0 }},

/* kflag limm 00100RRR001010011RRR111110RRRRRR.  */
{ "kflag", 0x20298F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { LIMM }, { 0 }},

/* kflag<.cc> limm 00100RRR111010011RRR1111100QQQQQ.  */
{ "kflag", 0x20E98F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { LIMM }, { C_CC }},

/* prealloc<.aa> b,c 00100bbbaa1100010BBBCCCCCC111110.  */
{ "prealloc", 0x2031003E, 0xF83F803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MEMORY, NONE, { BRAKET, RB, RC, BRAKETdup }, { C_AA8 }},

/* prealloc<.aa> b,s9 00010bbbssssssssSBBB0aa001111110.  */
{ "prealloc", 0x1000007E, 0xF80009FF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MEMORY, NONE, { BRAKET, RB, SIMM9_8, BRAKETdup }, { C_AA21 }},

/* prealloc<.aa> b,limm 00100bbbaa1100010BBB111110111110.  */
{ "prealloc", 0x20310FBE, 0xF83F8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MEMORY, NONE, { BRAKET, RB, LIMM, BRAKETdup }, { C_AA8 }},

/* prealloc limm,c 00100110RR1100010111CCCCCC111110.  */
{ "prealloc", 0x2631703E, 0xFF3FF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MEMORY, NONE, { BRAKET, LIMM, RC, BRAKETdup }, { 0 }},

/* prealloc limm 000101100000000001110RR001111110.  */
{ "prealloc", 0x1600707E, 0xFFFFF9FF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MEMORY, NONE, { BRAKET, LIMM, BRAKETdup }, { 0 }},

/* prealloc limm,s9 00010110ssssssssS1110RR001111110.  */
{ "prealloc", 0x1600707E, 0xFF0079FF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MEMORY, NONE, { BRAKET, LIMM, SIMM9_8, BRAKETdup }, { 0 }},

/* prefetch<.aa> b,c 00100bbbaa1100000BBBCCCCCC111110.  */
{ "prefetch", 0x2030003E, 0xF83F803F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MEMORY, NONE, { BRAKET, RB, RC, BRAKETdup }, { C_AA8 }},

/* prefetch b 00010bbb000000000BBB0RR000111110.  */
{ "prefetch", 0x1000003E, 0xF8FF89FF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, MEMORY, NONE, { BRAKET, RB, BRAKETdup }, { 0 }},

/* prefetch<.aa> b,s9 00010bbbssssssssSBBB0aa000111110.  */
{ "prefetch", 0x1000003E, 0xF80009FF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MEMORY, NONE, { BRAKET, RB, SIMM9_8, BRAKETdup }, { C_AA21 }},

/* prefetch<.aa> b,limm 00100bbbaa1100000BBB111110111110.  */
{ "prefetch", 0x20300FBE, 0xF83F8FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MEMORY, NONE, { BRAKET, RB, LIMM, BRAKETdup }, { C_AA8 }},

/* prefetch<.aa> limm,c 00100110aa1100000111CCCCCC111110.  */
{ "prefetch", 0x2630703E, 0xFF3FF03F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MEMORY, NONE, { BRAKET, LIMM, RC, BRAKETdup }, { C_AA8 }},

/* prefetch limm,c 00100110RR1100000111CCCCCC111110.  */
{ "prefetch", 0x2630703E, 0xFF3FF03F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MEMORY, NONE, { BRAKET, LIMM, RC, BRAKETdup }, { 0 }},

/* prefetch limm 000101100000000001110RR000111110.  */
{ "prefetch", 0x1600703E, 0xFFFFF9FF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MEMORY, NONE, { BRAKET, LIMM, BRAKETdup }, { 0 }},

/* prefetch<.aa> limm,s9 00010110ssssssssS1110aa000111110.  */
{ "prefetch", 0x1600703E, 0xFF0079FF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, MEMORY, NONE, { BRAKET, LIMM, SIMM9_8, BRAKETdup }, { C_AA21 }},

/* prefetch limm,s9 00010110ssssssssS1110RR000111110.  */
{ "prefetch", 0x1600703E, 0xFF0079FF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MEMORY, NONE, { BRAKET, LIMM, SIMM9_8, BRAKETdup }, { 0 }},

/* prefetch<.aa> limm,limm 00100110aa1100000111111110111110.  */
{ "prefetch", 0x26307FBE, 0xFF3FFFFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, MEMORY, NONE, { BRAKET, LIMM, LIMMdup, BRAKETdup }, { C_AA8 }},

/* prefetchw<.aa> b,c 00100bbbaa1100001BBBCCCCCC111110.  */
{ "prefetchw", 0x2030803E, 0xF83F803F, ARC_OPCODE_ARCv2HS, MEMORY, NONE, { BRAKET, RB, RC, BRAKETdup }, { C_AA8 }},

/* prefetchw<.aa> b,s9 00010bbbssssssssSBBB1aa000111110.  */
{ "prefetchw", 0x1000083E, 0xF80009FF, ARC_OPCODE_ARCv2HS, MEMORY, NONE, { BRAKET, RB, SIMM9_8, BRAKETdup }, { C_AA21 }},

/* prefetchw<.aa> b,limm 00100bbbaa1100001BBB111110111110.  */
{ "prefetchw", 0x20308FBE, 0xF83F8FFF, ARC_OPCODE_ARCv2HS, MEMORY, NONE, { BRAKET, RB, LIMM, BRAKETdup }, { C_AA8 }},

/* prefetchw limm,c 00100110RR1100001111CCCCCC111110.  */
{ "prefetchw", 0x2630F03E, 0xFF3FF03F, ARC_OPCODE_ARCv2HS, MEMORY, NONE, { BRAKET, LIMM, RC, BRAKETdup }, { 0 }},

/* prefetchw limm 000101100000000001111RR000111110.  */
{ "prefetchw", 0x1600783E, 0xFFFFF9FF, ARC_OPCODE_ARCv2HS, MEMORY, NONE, { BRAKET, LIMM, BRAKETdup }, { 0 }},

/* prefetchw limm,s9 00010110ssssssssS1111RR000111110.  */
{ "prefetchw", 0x1600783E, 0xFF0079FF, ARC_OPCODE_ARCv2HS, MEMORY, NONE, { BRAKET, LIMM, SIMM9_8, BRAKETdup }, { 0 }},

/* ld<.di><.aa><.x><zz> a,b 00010bbb000000000BBBDaaZZXAAAAAA.  */
{ "ld", 0x10000000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { RA_CHK, BRAKET, RB, BRAKETdup }, { C_ZZ23, C_DI20, C_AA21, C_X25 }},

/* ld<.di><.aa><.x><zz> a,b,c 00100bbbaa110ZZXDBBBCCCCCCAAAAAA.  */
{ "ld", 0x20300000, 0xF8380000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { RA_CHK, BRAKET, RB, RC, BRAKETdup }, { C_ZZ13, C_DI16, C_AA8, C_X15 }},

/* ld<.di><.aa><.x><zz> 0,b 00010bbb000000000BBBDaaZZX111110.  */
{ "ld", 0x1000003E, 0xF8FF803F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { ZA, BRAKET, RB, BRAKETdup }, { C_ZZ23, C_DI20, C_AA21, C_X25 }},

/* ld<.di><.aa><.x><zz> 0,b,c 00100bbbaa110ZZXDBBBCCCCCC111110.  */
{ "ld", 0x2030003E, 0xF838003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { ZA, BRAKET, RB, RC, BRAKETdup }, { C_ZZ13, C_DI16, C_AA8, C_X15 }},

/* ld<.di><.aa><.x><zz> a,b,s9 00010bbbssssssssSBBBDaaZZXAAAAAA.  */
{ "ld", 0x10000000, 0xF8000000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { RA_CHK, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_ZZ23, C_DI20, C_AA21, C_X25 }},

/* ld<.di><.aa><.x><zz> 0,b,s9 00010bbbssssssssSBBBDaaZZX111110.  */
{ "ld", 0x1000003E, 0xF800003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { ZA, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_ZZ23, C_DI20, C_AA21, C_X25 }},

/* ld<.di><.x><zz> a,limm 00010110000000000111DRRZZXAAAAAA.  */
{ "ld", 0x16007000, 0xFFFFF000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { RA_CHK, BRAKET, LIMM, BRAKETdup }, { C_ZZ23, C_DI20, C_X25 }},

/* ld<.di><.aa><.x><zz> a,b,limm 00100bbbaa110ZZXDBBB111110AAAAAA.  */
{ "ld", 0x20300F80, 0xF8380FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { RA_CHK, BRAKET, RB, LIMM, BRAKETdup }, { C_ZZ13, C_DI16, C_AA8, C_X15 }},

/* ld<.di><.aa><.x><zz> a,limm,c 00100110aa110ZZXD111CCCCCCAAAAAA.  */
{ "ld", 0x26307000, 0xFF387000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { RA_CHK, BRAKET, LIMM, RC, BRAKETdup }, { C_ZZ13, C_DI16, C_AA8, C_X15 }},

/* ld<.di><.x><zz> a,limm,c 00100110RR110ZZXD111CCCCCCAAAAAA.  */
{ "ld", 0x26307000, 0xFF387000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { RA_CHK, BRAKET, LIMM, RC, BRAKETdup }, { C_ZZ13, C_DI16, C_X15 }},

/* ld<.di><.x><zz> 0,limm 00010110000000000111DRRZZX111110.  */
{ "ld", 0x1600703E, 0xFFFFF03F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { ZA, BRAKET, LIMM, BRAKETdup }, { C_ZZ23, C_DI20, C_X25 }},

/* ld<.di><.aa><.x><zz> 0,b,limm 00100bbbaa110ZZXDBBB111110111110.  */
{ "ld", 0x20300FBE, 0xF8380FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { ZA, BRAKET, RB, LIMM, BRAKETdup }, { C_ZZ13, C_DI16, C_AA8, C_X15 }},

/* ld<.di><.aa><.x><zz> 0,limm,c 00100110aa110ZZXD111CCCCCC111110.  */
{ "ld", 0x2630703E, 0xFF38703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { ZA, BRAKET, LIMM, RC, BRAKETdup }, { C_ZZ13, C_DI16, C_AA8, C_X15 }},

/* ld<.di><.x><zz> 0,limm,c 00100110RR110ZZXD111CCCCCC111110.  */
{ "ld", 0x2630703E, 0xFF38703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { ZA, BRAKET, LIMM, RC, BRAKETdup }, { C_ZZ13, C_DI16, C_X15 }},

/* ld<.di><.aa><.x><zz> a,limm,s9 00010110ssssssssS111DaaZZXAAAAAA.  */
{ "ld", 0x16007000, 0xFF007000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { RA_CHK, BRAKET, LIMM, SIMM9_8, BRAKETdup }, { C_ZZ23, C_DI20, C_AA21, C_X25 }},

/* ld<.di><.aa><.x><zz> 0,limm,s9 00010110ssssssssS111DaaZZX111110.  */
{ "ld", 0x1600703E, 0xFF00703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { ZA, BRAKET, LIMM, SIMM9_8, BRAKETdup }, { C_ZZ23, C_DI20, C_AA21, C_X25 }},

/* ld<.di><.aa><.x><zz> a,limm,limm 00100110aa110ZZXD111111110AAAAAA.  */
{ "ld", 0x26307F80, 0xFF387FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { RA_CHK, BRAKET, LIMM, LIMMdup, BRAKETdup }, { C_ZZ13, C_DI16, C_AA8, C_X15 }},

/* ld<.di><.aa><.x><zz> 0,limm,limm 00100110aa110ZZXD111111110111110.  */
{ "ld", 0x26307FBE, 0xFF387FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { ZA, BRAKET, LIMM, LIMMdup, BRAKETdup }, { C_ZZ13, C_DI16, C_AA8, C_X15 }},

/* ldb_s a,b,c 01100bbbccc01aaa.  */
{ "ldb_s", 0x00006008, 0x0000F818, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { RA_S, BRAKET, RB_S, RC_S, BRAKETdup }, { C_ZZ_B }},

/* ldb_s c,b,u5 10001bbbcccuuuuu.  */
{ "ldb_s", 0x00008800, 0x0000F800, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { RC_S, BRAKET, RB_S, UIMM5_11_S, BRAKETdup }, { C_ZZ_B }},

/* ldb_s b,SP,u7 11000bbb001uuuuu.  */
{ "ldb_s", 0x0000C020, 0x0000F8E0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { RB_S, BRAKET, SP_S, UIMM7_A32_11_S, BRAKETdup }, { C_ZZ_B }},

/* ldb_s R0,GP,s9 1100101sssssssss.  */
{ "ldb_s", 0x0000CA00, 0x0000FE00, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { R0_S, BRAKET, GP_S, SIMM9_7_S, BRAKETdup }, { C_ZZ_B }},

/* ldd<.di><.aa> a,b 00010bbb000000000BBBDaa110AAAAAA.  */
{ "ldd", 0x10000180, 0xF8FF81C0, ARC_OPCODE_ARCv2HS, LOAD, LL64, { RAD, BRAKET, RB, BRAKETdup }, { C_DI20, C_AA21, C_ZZ_D }},

/* ldd<.di><.aa> a,b,c 00100bbbaa110110DBBBCCCCCCAAAAAA.  */
{ "ldd", 0x20360000, 0xF83F0000, ARC_OPCODE_ARCv2HS, LOAD, LL64, { RAD, BRAKET, RB, RC, BRAKETdup }, { C_DI16, C_AA8, C_ZZ_D }},

/* ldd<.di><.aa> 0,b 00010bbb000000000BBBDaa110111110.  */
{ "ldd", 0x100001BE, 0xF8FF81FF, ARC_OPCODE_ARCv2HS, LOAD, LL64, { ZA, BRAKET, RB, BRAKETdup }, { C_DI20, C_AA21, C_ZZ_D }},

/* ldd<.di><.aa> 0,b,c 00100bbbaa110110DBBBCCCCCC111110.  */
{ "ldd", 0x2036003E, 0xF83F003F, ARC_OPCODE_ARCv2HS, LOAD, LL64, { ZA, BRAKET, RB, RC, BRAKETdup }, { C_DI16, C_AA8, C_ZZ_D }},

/* ldd<.di><.aa> a,b,s9 00010bbbssssssssSBBBDaa110AAAAAA.  */
{ "ldd", 0x10000180, 0xF80001C0, ARC_OPCODE_ARCv2HS, LOAD, LL64, { RAD, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_DI20, C_AA21, C_ZZ_D }},

/* ldd<.di><.aa> 0,b,s9 00010bbbssssssssSBBBDaa110111110.  */
{ "ldd", 0x100001BE, 0xF80001FF, ARC_OPCODE_ARCv2HS, LOAD, LL64, { ZA, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_DI20, C_AA21, C_ZZ_D }},

/* ldd<.di> a,limm 00010110000000000111DRR110AAAAAA.  */
{ "ldd", 0x16007180, 0xFFFFF1C0, ARC_OPCODE_ARCv2HS, LOAD, LL64, { RAD, BRAKET, LIMM, BRAKETdup }, { C_DI20, C_ZZ_D }},

/* ldd<.di><.aa> a,b,limm 00100bbbaa110110DBBB111110AAAAAA.  */
{ "ldd", 0x20360F80, 0xF83F0FC0, ARC_OPCODE_ARCv2HS, LOAD, LL64, { RAD, BRAKET, RB, LIMM, BRAKETdup }, { C_DI16, C_AA8, C_ZZ_D }},

/* ldd<.di> a,limm,c 00100110RR110110D111CCCCCCAAAAAA.  */
{ "ldd", 0x26367000, 0xFF3F7000, ARC_OPCODE_ARCv2HS, LOAD, LL64, { RAD, BRAKET, LIMM, RC, BRAKETdup }, { C_DI16, C_ZZ_D }},

/* ldd<.di> 0,limm 00010110000000000111DRR110111110.  */
{ "ldd", 0x160071BE, 0xFFFFF1FF, ARC_OPCODE_ARCv2HS, LOAD, LL64, { ZA, BRAKET, LIMM, BRAKETdup }, { C_DI20, C_ZZ_D }},

/* ldd<.di><.aa> 0,b,limm 00100bbbaa110110DBBB111110111110.  */
{ "ldd", 0x20360FBE, 0xF83F0FFF, ARC_OPCODE_ARCv2HS, LOAD, LL64, { ZA, BRAKET, RB, LIMM, BRAKETdup }, { C_DI16, C_AA8, C_ZZ_D }},

/* ldd<.di> 0,limm,c 00100110RR110110D111CCCCCC111110.  */
{ "ldd", 0x2636703E, 0xFF3F703F, ARC_OPCODE_ARCv2HS, LOAD, LL64, { ZA, BRAKET, LIMM, RC, BRAKETdup }, { C_DI16, C_ZZ_D }},

/* ldd<.di><.aa> a,limm,s9 00010110ssssssssS111Daa110AAAAAA.  */
{ "ldd", 0x16007180, 0xFF0071C0, ARC_OPCODE_ARCv2HS, LOAD, LL64, { RAD, BRAKET, LIMM, SIMM9_8, BRAKETdup }, { C_DI20, C_AA21, C_ZZ_D }},

/* ldd<.di><.aa> 0,limm,s9 00010110ssssssssS111Daa110111110.  */
{ "ldd", 0x160071BE, 0xFF0071FF, ARC_OPCODE_ARCv2HS, LOAD, LL64, { ZA, BRAKET, LIMM, SIMM9_8, BRAKETdup }, { C_DI20, C_AA21, C_ZZ_D }},

/* ldh_s a,b,c 01100bbbccc10aaa.  */
{ "ldh_s", 0x00006010, 0x0000F818, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { RA_S, BRAKET, RB_S, RC_S, BRAKETdup }, { C_ZZ_H }},

/* ldh_s c,b,u6 10010bbbcccuuuuu.  */
{ "ldh_s", 0x00009000, 0x0000F800, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { RC_S, BRAKET, RB_S, UIMM6_A16_11_S, BRAKETdup }, { C_ZZ_H }},

/* ldh_sZZ_H.X c,b,u6 10011bbbcccuuuuu.  */
{ "ldh_s", 0x00009800, 0x0000F800, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { RC_S, BRAKET, RB_S, UIMM6_A16_11_S, BRAKETdup }, { C_XHARD, C_ZZ_H }},

/* ldh_s R0,GP,s10 1100110sssssssss.  */
{ "ldh_s", 0x0000CC00, 0x0000FE00, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { R0_S, BRAKET, GP_S, SIMM10_A16_7_Sbis, BRAKETdup }, { C_ZZ_H }},

/* ldi b,c 00100bbb00100110RBBBCCCCCCRRRRRR.  */
{ "ldi", 0x20260000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, CD2, { RB_CHK, BRAKET, RC, BRAKETdup }, { 0 }},

/* ldi 0,c 0010011000100110R111CCCCCCRRRRRR.  */
{ "ldi", 0x26267000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, CD2, { ZA, BRAKET, RC, BRAKETdup }, { 0 }},

/* ldi b,u6 00100bbb01100110RBBBuuuuuu000000.  */
{ "ldi", 0x20660000, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, CD2, { RB_CHK, BRAKET, UIMM6_20, BRAKETdup }, { 0 }},

/* ldi 0,u6 0010011001100110R111uuuuuu000000.  */
{ "ldi", 0x26667000, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, CD2, { ZA, BRAKET, UIMM6_20, BRAKETdup }, { 0 }},

/* ldi<.cc> b,u6 00100bbb11100110RBBBuuuuuu1QQQQQ.  */
{ "ldi", 0x20E60020, 0xF8FF0020, ARC_OPCODE_ARCv2EM, LOAD, CD2, { RB_CHK, BRAKET, UIMM6_20, BRAKETdup }, { C_CC }},

/* ldi<.cc> 0,u6 0010011011100110R111uuuuuu1QQQQQ.  */
{ "ldi", 0x26E67020, 0xFFFF7020, ARC_OPCODE_ARCv2EM, LOAD, CD2, { ZA, BRAKET, UIMM6_20, BRAKETdup }, { C_CC }},

/* ldi b,s12 00100bbb10100110RBBBssssssSSSSSS.  */
{ "ldi", 0x20A60000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, CD2, { RB_CHK, BRAKET, SIMM12_20, BRAKETdup }, { 0 }},

/* ldi 0,s12 0010011010100110R111ssssssSSSSSS.  */
{ "ldi", 0x26A67000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, CD2, { ZA, BRAKET, SIMM12_20, BRAKETdup }, { 0 }},

/* ldi b,limm 00100bbb00100110RBBB111110RRRRRR.  */
{ "ldi", 0x20260F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, CD2, { RB_CHK, BRAKET, LIMM, BRAKETdup }, { 0 }},

/* ldi 0,limm 0010011000100110R111111110RRRRRR.  */
{ "ldi", 0x26267F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, CD2, { ZA, BRAKET, LIMM, BRAKETdup }, { 0 }},

/* ldi_s b,u7 01010bbbUUUU1uuu.  */
{ "ldi_s", 0x00005008, 0x0000F808, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, CD2, { RB_S, BRAKET, UIMM7_13_S, BRAKETdup }, { 0 }},

/* ldw_sZZ_H a,b,c 01100bbbccc10aaa.  */
{ "ldw_s", 0x00006010, 0x0000F818, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, LOAD, NONE, { RA_S, BRAKET, RB_S, RC_S, BRAKETdup }, { C_ZZ_H }},

/* ldw_sZZ_H c,b,u6 10010bbbcccuuuuu.  */
{ "ldw_s", 0x00009000, 0x0000F800, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, LOAD, NONE, { RC_S, BRAKET, RB_S, UIMM6_A16_11_S, BRAKETdup }, { C_ZZ_H }},

/* ldw_sZZ_H.X c,b,u6 10011bbbcccuuuuu.  */
{ "ldw_s", 0x00009800, 0x0000F800, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, LOAD, NONE, { RC_S, BRAKET, RB_S, UIMM6_A16_11_S, BRAKETdup }, { C_XHARD, C_ZZ_H }},

/* ldw_s R0,GP,s10 1100110sssssssss.  */
{ "ldw_s", 0x0000CC00, 0x0000FE00, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, LOAD, NONE, { R0_S, BRAKET, GP_S, SIMM10_A16_7_Sbis, BRAKETdup }, { C_ZZ_H }},

/* ld_s a,b,c 01100bbbccc00aaa.  */
{ "ld_s", 0x00006000, 0x0000F818, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { RA_S, BRAKET, RB_S, RC_S, BRAKETdup }, { 0 }},

/* ld_s.AS a,b,c 01001bbbccc00aaa.  */
{ "ld_s", 0x00004800, 0x0000F818, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, CD2, { RA_S, BRAKET, RB_S, RC_S, BRAKETdup }, { C_AS }},

/* ld_s R0,h,u5 01000U00hhhuu1HH.  */
{ "ld_s", 0x00004004, 0x0000FB04, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, CD2, { R0_S, BRAKET, RH_S, UIMM5_A32_11_S, BRAKETdup }, { 0 }},

/* ld_s R1,h,u5 01000U01hhhuu1HH.  */
{ "ld_s", 0x00004104, 0x0000FB04, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, CD2, { R1_S, BRAKET, RH_S, UIMM5_A32_11_S, BRAKETdup }, { 0 }},

/* ld_s R2,h,u5 01000U10hhhuu1HH.  */
{ "ld_s", 0x00004204, 0x0000FB04, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, CD2, { R2_S, BRAKET, RH_S, UIMM5_A32_11_S, BRAKETdup }, { 0 }},

/* ld_s R3,h,u5 01000U11hhhuu1HH.  */
{ "ld_s", 0x00004304, 0x0000FB04, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, CD2, { R3_S, BRAKET, RH_S, UIMM5_A32_11_S, BRAKETdup }, { 0 }},

/* ld_s b,SP,u7 11000bbb000uuuuu.  */
{ "ld_s", 0x0000C000, 0x0000F8E0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { RB_S, BRAKET, SP_S, UIMM7_A32_11_S, BRAKETdup }, { 0 }},

/* ld_s c,b,u7 10000bbbcccuuuuu.  */
{ "ld_s", 0x00008000, 0x0000F800, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { RC_S, BRAKET, RB_S, UIMM7_A32_11_S, BRAKETdup }, { 0 }},

/* ld_s b,PCL,u10 11010bbbuuuuuuuu.  */
{ "ld_s", 0x0000D000, 0x0000F800, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { RB_S, BRAKET, PCL_S, UIMM10_A32_8_S, BRAKETdup }, { 0 }},

/* ld_s R0,GP,s11 1100100sssssssss.  */
{ "ld_s", 0x0000C800, 0x0000FE00, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, NONE, { R0_S, BRAKET, GP_S, SIMM11_A32_7_S, BRAKETdup }, { 0 }},

/* ld_s R1,GP,s11 01010SSSSSS00sss.  */
{ "ld_s", 0x00005000, 0x0000F818, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOAD, CD2, { R1_S, BRAKET, GP_S, SIMM11_A32_13_S, BRAKETdup }, { 0 }},

/* leave_s u7 11000UUU110uuuu0.  */
{ "leave_s", 0x0000C0C0, 0x0000F8E1, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LEAVE, CD1, { BRAKET, RRANGE_EL, FP_EL, BLINK_EL, PCL_EL, BRAKETdup }, { 0 }},
{ "leave_s", 0x0000C0C0, 0x0000F8E1, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LEAVE, CD1, { BRAKET, R13_EL, FP_EL, BLINK_EL, PCL_EL, BRAKETdup }, { 0 }},
{ "leave_s", 0x0000C0C0, 0x0000F8E1, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LEAVE, CD1, { UIMM7_11_S }, { 0 }},

/* llock<.di> b,c 00100bbb00101111DBBBCCCCCC010000.  */
{ "llock", 0x202F0010, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LLOCK, NONE, { RB, BRAKET, RC, BRAKETdup }, { C_DI16 }},

/* llock<.di> 0,c 0010011000101111D111CCCCCC010000.  */
{ "llock", 0x262F7010, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LLOCK, NONE, { ZA, BRAKET, RC, BRAKETdup }, { C_DI16 }},

/* llock<.di> b,u6 00100bbb01101111DBBBuuuuuu010000.  */
{ "llock", 0x206F0010, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LLOCK, NONE, { RB, BRAKET, UIMM6_20, BRAKETdup }, { C_DI16 }},

/* llock<.di> 0,u6 0010011001101111D111uuuuuu010000.  */
{ "llock", 0x266F7010, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LLOCK, NONE, { ZA, BRAKET, UIMM6_20, BRAKETdup }, { C_DI16 }},

/* llock<.di> b,limm 00100bbb00101111DBBB111110010000.  */
{ "llock", 0x202F0F90, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LLOCK, NONE, { RB, BRAKET, LIMM, BRAKETdup }, { C_DI16 }},

/* llock<.di> 0,limm 0010011000101111D111111110010000.  */
{ "llock", 0x262F7F90, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LLOCK, NONE, { ZA, BRAKET, LIMM, BRAKETdup }, { C_DI16 }},

/* llockd<.di> b,c 00100bbb00101111DBBBCCCCCC010010.  */
{ "llockd", 0x202F0012, 0xF8FF003F, ARC_OPCODE_ARCv2HS, LLOCK, NONE, { RB, BRAKET, RC, BRAKETdup }, { C_DI16, C_ZZ_D }},

/* llockd<.di> 0,c 0010011000101111D111CCCCCC010010.  */
{ "llockd", 0x262F7012, 0xFFFF703F, ARC_OPCODE_ARCv2HS, LLOCK, NONE, { ZA, BRAKET, RC, BRAKETdup }, { C_DI16, C_ZZ_D }},

/* llockd<.di> b,u6 00100bbb01101111DBBBuuuuuu010010.  */
{ "llockd", 0x206F0012, 0xF8FF003F, ARC_OPCODE_ARCv2HS, LLOCK, NONE, { RB, BRAKET, UIMM6_20, BRAKETdup }, { C_DI16, C_ZZ_D }},

/* llockd<.di> 0,u6 0010011001101111D111uuuuuu010010.  */
{ "llockd", 0x266F7012, 0xFFFF703F, ARC_OPCODE_ARCv2HS, LLOCK, NONE, { ZA, BRAKET, UIMM6_20, BRAKETdup }, { C_DI16, C_ZZ_D }},

/* llockd<.di> b,limm 00100bbb00101111DBBB111110010010.  */
{ "llockd", 0x202F0F92, 0xF8FF0FFF, ARC_OPCODE_ARCv2HS, LLOCK, NONE, { RB, BRAKET, LIMM, BRAKETdup }, { C_DI16, C_ZZ_D }},

/* llockd<.di> 0,limm 0010011000101111D111111110010010.  */
{ "llockd", 0x262F7F92, 0xFFFF7FFF, ARC_OPCODE_ARCv2HS, LLOCK, NONE, { ZA, BRAKET, LIMM, BRAKETdup }, { C_DI16, C_ZZ_D }},

/* lp s13 00100RRR101010000RRRssssssSSSSSS.  */
{ "lp", 0x20A80000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, LOOP, NONE, { SIMM13_A16_20 }, { 0 }},

/* lp s13 00100RRR10101000RRRRssssssSSSSSS.  */
{ "lp", 0x20A80000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOOP, NONE, { SIMM13_A16_20 }, { 0 }},

/* lp<cc> u7 00100RRR111010000RRRuuuuuu1QQQQQ.  */
{ "lp", 0x20E80020, 0xF8FF8020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, LOOP, NONE, { UIMM7_A16_20 }, { C_CC }},

/* lp u7 00100RRR011010000RRRuuuuuuRRRRRR.  */
{ "lp", 0x20680000, 0xF8FF8000, ARC_OPCODE_ARC600, LOOP, NONE, { UIMM7_A16_20 }, { 0 }},

/* lp<cc> u7 00100RRR11101000RRRRuuuuuu1QQQQQ.  */
{ "lp", 0x20E80020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOOP, NONE, { UIMM7_A16_20 }, { C_CC }},

/* lp u7 00100RRR01101000RRRRuuuuuuRRRRRR.  */
{ "lp", 0x20680000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOOP, NONE, { UIMM7_A16_20 }, { 0 }},

/* lr b,c 00100bbb001010100BBBCCCCCCRRRRRR.  */
{ "lr", 0x202A0000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, AUXREG, NONE, { RB_CHK, BRAKET, RC, BRAKETdup }, { 0 }},

/* lr 0,c 00100110001010100111CCCCCCRRRRRR.  */
{ "lr", 0x262A7000, 0xFFFFF000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, AUXREG, NONE, { ZA, BRAKET, RC, BRAKETdup }, { 0 }},

/* lr b,c 00100bbb00101010RBBBCCCCCCRRRRRR.  */
{ "lr", 0x202A0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { RB_CHK, BRAKET, RC, BRAKETdup }, { 0 }},

/* lr 0,c 0010011000101010R111CCCCCCRRRRRR.  */
{ "lr", 0x262A7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { ZA, BRAKET, RC, BRAKETdup }, { 0 }},

/* lr b,u6 00100bbb011010100BBBuuuuuu000000.  */
{ "lr", 0x206A0000, 0xF8FF803F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, AUXREG, NONE, { RB_CHK, BRAKET, UIMM6_20, BRAKETdup }, { 0 }},

/* lr 0,u6 00100110011010100111uuuuuu000000.  */
{ "lr", 0x266A7000, 0xFFFFF03F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, AUXREG, NONE, { ZA, BRAKET, UIMM6_20, BRAKETdup }, { 0 }},

/* lr b,u6 00100bbb01101010RBBBuuuuuu000000.  */
{ "lr", 0x206A0000, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { RB_CHK, BRAKET, UIMM6_20, BRAKETdup }, { 0 }},

/* lr 0,u6 0010011001101010R111uuuuuu000000.  */
{ "lr", 0x266A7000, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { ZA, BRAKET, UIMM6_20, BRAKETdup }, { 0 }},

/* lr b,s12 00100bbb101010100BBBssssssSSSSSS.  */
{ "lr", 0x20AA0000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, AUXREG, NONE, { RB_CHK, BRAKET, SIMM12_20, BRAKETdup }, { 0 }},

/* lr 0,s12 00100110101010100111ssssssSSSSSS.  */
{ "lr", 0x26AA7000, 0xFFFFF000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, AUXREG, NONE, { ZA, BRAKET, SIMM12_20, BRAKETdup }, { 0 }},

/* lr b,s12 00100bbb10101010RBBBssssssSSSSSS.  */
{ "lr", 0x20AA0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { RB_CHK, BRAKET, SIMM12_20, BRAKETdup }, { 0 }},

/* lr 0,s12 0010011010101010R111ssssssSSSSSS.  */
{ "lr", 0x26AA7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { ZA, BRAKET, SIMM12_20, BRAKETdup }, { 0 }},

/* lr b,limm 00100bbb001010100BBB111110RRRRRR.  */
{ "lr", 0x202A0F80, 0xF8FF8FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, AUXREG, NONE, { RB_CHK, BRAKET, LIMM, BRAKETdup }, { 0 }},

/* lr 0,limm 00100110001010100111111110RRRRRR.  */
{ "lr", 0x262A7F80, 0xFFFFFFC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, AUXREG, NONE, { ZA, BRAKET, LIMM, BRAKETdup }, { 0 }},

/* lr b,limm 00100bbb00101010RBBB111110RRRRRR.  */
{ "lr", 0x202A0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { RB_CHK, BRAKET, LIMM, BRAKETdup }, { 0 }},

/* lr 0,limm 0010011000101010R111111110RRRRRR.  */
{ "lr", 0x262A7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, AUXREG, NONE, { ZA, BRAKET, LIMM, BRAKETdup }, { 0 }},

/* lsl16<.f> b,c 00101bbb00101111FBBBCCCCCC001010.  */
{ "lsl16", 0x282F000A, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SWAP, { RB, RC }, { C_F }},

/* lsl16<.f> 0,c 0010111000101111F111CCCCCC001010.  */
{ "lsl16", 0x2E2F700A, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SWAP, { ZA, RC }, { C_F }},

/* lsl16<.f> b,u6 00101bbb01101111FBBBuuuuuu001010.  */
{ "lsl16", 0x286F000A, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SWAP, { RB, UIMM6_20 }, { C_F }},

/* lsl16<.f> 0,u6 0010111001101111F111uuuuuu001010.  */
{ "lsl16", 0x2E6F700A, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SWAP, { ZA, UIMM6_20 }, { C_F }},

/* lsl16<.f> b,limm 00101bbb00101111FBBB111110001010.  */
{ "lsl16", 0x282F0F8A, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SWAP, { RB, LIMM }, { C_F }},

/* lsl16<.f> 0,limm 0010111000101111F111111110001010.  */
{ "lsl16", 0x2E2F7F8A, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SWAP, { ZA, LIMM }, { C_F }},

/* lsl8<.f> b,c 00101bbb00101111FBBBCCCCCC001111.  */
{ "lsl8", 0x282F000F, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { RB, RC }, { C_F }},

/* lsl8<.f> 0,c 0010111000101111F111CCCCCC001111.  */
{ "lsl8", 0x2E2F700F, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { ZA, RC }, { C_F }},

/* lsl8<.f> b,u6 00101bbb01101111FBBBuuuuuu001111.  */
{ "lsl8", 0x286F000F, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { RB, UIMM6_20 }, { C_F }},

/* lsl8<.f> 0,u6 0010111001101111F111uuuuuu001111.  */
{ "lsl8", 0x2E6F700F, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { ZA, UIMM6_20 }, { C_F }},

/* lsl8<.f> b,limm 00101bbb00101111FBBB111110001111.  */
{ "lsl8", 0x282F0F8F, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { RB, LIMM }, { C_F }},

/* lsl8<.f> 0,limm 0010111000101111F111111110001111.  */
{ "lsl8", 0x2E2F7F8F, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { ZA, LIMM }, { C_F }},

/* lsr<.f> b,c 00100bbb00101111FBBBCCCCCC000010.  */
{ "lsr", 0x202F0002, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RC }, { C_F }},

/* lsr<.f> 0,c 0010011000101111F111CCCCCC000010.  */
{ "lsr", 0x262F7002, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RC }, { C_F }},

/* lsr<.f> a,b,c 00101bbb00000001FBBBCCCCCCAAAAAA.  */
{ "lsr", 0x28010000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, RB, RC }, { C_F }},

/* lsr<.f> 0,b,c 00101bbb00000001FBBBCCCCCC111110.  */
{ "lsr", 0x2801003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, RB, RC }, { C_F }},

/* lsr<.f><.cc> b,b,c 00101bbb11000001FBBBCCCCCC0QQQQQ.  */
{ "lsr", 0x28C10000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB, RBdup, RC }, { C_F, C_CC }},

/* lsr<.f> b,u6 00100bbb01101111FBBBuuuuuu000010.  */
{ "lsr", 0x206F0002, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, UIMM6_20 }, { C_F }},

/* lsr<.f> 0,u6 0010011001101111F111uuuuuu000010.  */
{ "lsr", 0x266F7002, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, UIMM6_20 }, { C_F }},

/* lsr<.f> a,b,u6 00101bbb01000001FBBBuuuuuuAAAAAA.  */
{ "lsr", 0x28410000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, RB, UIMM6_20 }, { C_F }},

/* lsr<.f> 0,b,u6 00101bbb01000001FBBBuuuuuu111110.  */
{ "lsr", 0x2841003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, RB, UIMM6_20 }, { C_F }},

/* lsr<.f><.cc> b,b,u6 00101bbb11000001FBBBuuuuuu1QQQQQ.  */
{ "lsr", 0x28C10020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* lsr<.f> b,b,s12 00101bbb10000001FBBBssssssSSSSSS.  */
{ "lsr", 0x28810000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB, RBdup, SIMM12_20 }, { C_F }},

/* lsr<.f> b,limm 00100bbb00101111FBBB111110000010.  */
{ "lsr", 0x202F0F82, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, LIMM }, { C_F }},

/* lsr<.f> 0,limm 0010011000101111F111111110000010.  */
{ "lsr", 0x262F7F82, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM }, { C_F }},

/* lsr<.f> a,limm,c 0010111000000001F111CCCCCCAAAAAA.  */
{ "lsr", 0x2E017000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, LIMM, RC }, { C_F }},

/* lsr<.f> a,b,limm 00101bbb00000001FBBB111110AAAAAA.  */
{ "lsr", 0x28010F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, RB, LIMM }, { C_F }},

/* lsr<.f> 0,limm,c 0010111000000001F111CCCCCC111110.  */
{ "lsr", 0x2E01703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, RC }, { C_F }},

/* lsr<.f> 0,b,limm 00101bbb00000001FBBB111110111110.  */
{ "lsr", 0x28010FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, RB, LIMM }, { C_F }},

/* lsr<.f><.cc> b,b,limm 00101bbb11000001FBBB1111100QQQQQ.  */
{ "lsr", 0x28C10F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* lsr<.f><.cc> 0,limm,c 0010111011000001F111CCCCCC0QQQQQ.  */
{ "lsr", 0x2EC17000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, RC }, { C_F, C_CC }},

/* lsr<.f> a,limm,u6 0010111001000001F111uuuuuuAAAAAA.  */
{ "lsr", 0x2E417000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, LIMM, UIMM6_20 }, { C_F }},

/* lsr<.f> 0,limm,u6 0010111001000001F111uuuuuu111110.  */
{ "lsr", 0x2E41703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* lsr<.f><.cc> 0,limm,u6 0010111011000001F111uuuuuu1QQQQQ.  */
{ "lsr", 0x2EC17020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* lsr<.f> 0,limm,s12 0010111010000001F111ssssssSSSSSS.  */
{ "lsr", 0x2E817000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* lsr<.f> a,limm,limm 0010111000000001F111111110AAAAAA.  */
{ "lsr", 0x2E017F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, LIMM, LIMMdup }, { C_F }},

/* lsr<.f> 0,limm,limm 0010111000000001F111111110111110.  */
{ "lsr", 0x2E017FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, LIMMdup }, { C_F }},

/* lsr<.f><.cc> 0,limm,limm 0010111011000001F1111111100QQQQQ.  */
{ "lsr", 0x2EC17F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* lsr16<.f> b,c 00101bbb00101111FBBBCCCCCC001011.  */
{ "lsr16", 0x282F000B, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SWAP, { RB, RC }, { C_F }},

/* lsr16<.f> 0,c 0010111000101111F111CCCCCC001011.  */
{ "lsr16", 0x2E2F700B, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SWAP, { ZA, RC }, { C_F }},

/* lsr16<.f> b,u6 00101bbb01101111FBBBuuuuuu001011.  */
{ "lsr16", 0x286F000B, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SWAP, { RB, UIMM6_20 }, { C_F }},

/* lsr16<.f> 0,u6 0010111001101111F111uuuuuu001011.  */
{ "lsr16", 0x2E6F700B, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SWAP, { ZA, UIMM6_20 }, { C_F }},

/* lsr16<.f> b,limm 00101bbb00101111FBBB111110001011.  */
{ "lsr16", 0x282F0F8B, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SWAP, { RB, LIMM }, { C_F }},

/* lsr16<.f> 0,limm 0010111000101111F111111110001011.  */
{ "lsr16", 0x2E2F7F8B, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SWAP, { ZA, LIMM }, { C_F }},

/* lsr8<.f> b,c 00101bbb00101111FBBBCCCCCC001110.  */
{ "lsr8", 0x282F000E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { RB, RC }, { C_F }},

/* lsr8<.f> 0,c 0010111000101111F111CCCCCC001110.  */
{ "lsr8", 0x2E2F700E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { ZA, RC }, { C_F }},

/* lsr8<.f> b,u6 00101bbb01101111FBBBuuuuuu001110.  */
{ "lsr8", 0x286F000E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { RB, UIMM6_20 }, { C_F }},

/* lsr8<.f> 0,u6 0010111001101111F111uuuuuu001110.  */
{ "lsr8", 0x2E6F700E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { ZA, UIMM6_20 }, { C_F }},

/* lsr8<.f> b,limm 00101bbb00101111FBBB111110001110.  */
{ "lsr8", 0x282F0F8E, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { RB, LIMM }, { C_F }},

/* lsr8<.f> 0,limm 0010111000101111F111111110001110.  */
{ "lsr8", 0x2E2F7F8E, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, SHFT1, { ZA, LIMM }, { C_F }},

/* lsrdw<.f> a,b,c 00101bbb00100011FBBBCCCCCCAAAAAA.  */
{ "lsrdw", 0x28230000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* lsrdw<.f> 0,b,c 00101bbb00100011FBBBCCCCCC111110.  */
{ "lsrdw", 0x2823003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* lsrdw<.f><.cc> b,b,c 00101bbb11100011FBBBCCCCCC0QQQQQ.  */
{ "lsrdw", 0x28E30000, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* lsrdw<.f> a,b,u6 00101bbb01100011FBBBuuuuuuAAAAAA.  */
{ "lsrdw", 0x28630000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* lsrdw<.f> 0,b,u6 00101bbb01100011FBBBuuuuuu111110.  */
{ "lsrdw", 0x2863003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* lsrdw<.f><.cc> b,b,u6 00101bbb11100011FBBBuuuuuu1QQQQQ.  */
{ "lsrdw", 0x28E30020, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* lsrdw<.f> b,b,s12 00101bbb10100011FBBBssssssSSSSSS.  */
{ "lsrdw", 0x28A30000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* lsrdw<.f> a,limm,c 0010111000100011F111CCCCCCAAAAAA.  */
{ "lsrdw", 0x2E237000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* lsrdw<.f> a,b,limm 00101bbb00100011FBBB111110AAAAAA.  */
{ "lsrdw", 0x28230F80, 0xF8FF0FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* lsrdw<.f> 0,limm,c 0010111000100011F111CCCCCC111110.  */
{ "lsrdw", 0x2E23703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* lsrdw<.f> 0,b,limm 00101bbb00100011FBBB111110111110.  */
{ "lsrdw", 0x28230FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* lsrdw<.f><.cc> 0,limm,c 0010111011100011F111CCCCCC0QQQQQ.  */
{ "lsrdw", 0x2EE37000, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* lsrdw<.f><.cc> b,b,limm 00101bbb11100011FBBB1111100QQQQQ.  */
{ "lsrdw", 0x28E30F80, 0xF8FF0FE0, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* lsrdw<.f> a,limm,u6 0010111001100011F111uuuuuuAAAAAA.  */
{ "lsrdw", 0x2E637000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* lsrdw<.f> 0,limm,u6 0010111001100011F111uuuuuu111110.  */
{ "lsrdw", 0x2E63703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* lsrdw<.f><.cc> 0,limm,u6 0010111011100011F111uuuuuu1QQQQQ.  */
{ "lsrdw", 0x2EE37020, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* lsrdw<.f> 0,limm,s12 0010111010100011F111ssssssSSSSSS.  */
{ "lsrdw", 0x2EA37000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* lsrdw<.f> a,limm,limm 0010111000100011F111111110AAAAAA.  */
{ "lsrdw", 0x2E237F80, 0xFFFF7FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* lsrdw<.f> 0,limm,limm 0010111000100011F111111110111110.  */
{ "lsrdw", 0x2E237FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* lsrdw<.f><.cc> 0,limm,limm 0010111011100011F1111111100QQQQQ.  */
{ "lsrdw", 0x2EE37F80, 0xFFFF7FE0, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* lsr_s b,c 01111bbbccc11101.  */
{ "lsr_s", 0x0000781D, 0x0000F81F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB_S, RC_S }, { 0 }},

/* lsr_s b,b,c 01111bbbccc11001.  */
{ "lsr_s", 0x00007819, 0x0000F81F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* lsr_s b,b,u5 10111bbb001uuuuu.  */
{ "lsr_s", 0x0000B820, 0x0000F8E0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB_S, RB_Sdup, UIMM5_11_S }, { 0 }},

/* mac<.f> a,b,c 00101bbb00001110FBBBCCCCCCAAAAAA.  */
{ "mac", 0x280E0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, RB, RC }, { C_F }},

/* mac<.f> 0,b,c 00101bbb00001110FBBBCCCCCC111110.  */
{ "mac", 0x280E003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, RB, RC }, { C_F }},

/* mac<.f><.cc> b,b,c 00101bbb11001110FBBBCCCCCC0QQQQQ.  */
{ "mac", 0x28CE0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mac<.f> a,b,u6 00101bbb01001110FBBBuuuuuuAAAAAA.  */
{ "mac", 0x284E0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mac<.f> 0,b,u6 00101bbb01001110FBBBuuuuuu111110.  */
{ "mac", 0x284E003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, RB, UIMM6_20 }, { C_F }},

/* mac<.f><.cc> b,b,u6 00101bbb11001110FBBBuuuuuu1QQQQQ.  */
{ "mac", 0x28CE0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mac<.f> b,b,s12 00101bbb10001110FBBBssssssSSSSSS.  */
{ "mac", 0x288E0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mac<.f> a,limm,c 0010111000001110F111CCCCCCAAAAAA.  */
{ "mac", 0x2E0E7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, LIMM, RC }, { C_F }},

/* mac<.f> a,b,limm 00101bbb00001110FBBB111110AAAAAA.  */
{ "mac", 0x280E0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, RB, LIMM }, { C_F }},

/* mac<.f> 0,limm,c 0010111000001110F111CCCCCC111110.  */
{ "mac", 0x2E0E703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, RC }, { C_F }},

/* mac<.f> 0,b,limm 00101bbb00001110FBBB111110111110.  */
{ "mac", 0x280E0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, RB, LIMM }, { C_F }},

/* mac<.f><.cc> b,b,limm 00101bbb11001110FBBB1111100QQQQQ.  */
{ "mac", 0x28CE0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mac<.f><.cc> 0,limm,c 0010111011001110F111CCCCCC0QQQQQ.  */
{ "mac", 0x2ECE7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mac<.f> a,limm,u6 0010111001001110F111uuuuuuAAAAAA.  */
{ "mac", 0x2E4E7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mac<.f> 0,limm,u6 0010111001001110F111uuuuuu111110.  */
{ "mac", 0x2E4E703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mac<.f><.cc> 0,limm,u6 0010111011001110F111uuuuuu1QQQQQ.  */
{ "mac", 0x2ECE7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mac<.f> 0,limm,s12 0010111010001110F111ssssssSSSSSS.  */
{ "mac", 0x2E8E7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mac<.f> a,limm,limm 0010111000001110F111111110AAAAAA.  */
{ "mac", 0x2E0E7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mac<.f> 0,limm,limm 0010111000001110F111111110111110.  */
{ "mac", 0x2E0E7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F }},

/* mac<.f><.cc> 0,limm,limm 0010111011001110F1111111100QQQQQ.  */
{ "mac", 0x2ECE7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macd<.f> a,b,c 00101bbb00011010FBBBCCCCCCAAAAAA.  */
{ "macd", 0x281A0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, RB, RC }, { C_F }},

/* macd<.f> 0,b,c 00101bbb00011010FBBBCCCCCC111110.  */
{ "macd", 0x281A003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, RB, RC }, { C_F }},

/* macd<.f><.cc> b,b,c 00101bbb11011010FBBBCCCCCC0QQQQQ.  */
{ "macd", 0x28DA0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macd<.f> a,b,u6 00101bbb01011010FBBBuuuuuuAAAAAA.  */
{ "macd", 0x285A0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macd<.f> 0,b,u6 00101bbb01011010FBBBuuuuuu111110.  */
{ "macd", 0x285A003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, RB, UIMM6_20 }, { C_F }},

/* macd<.f><.cc> b,b,u6 00101bbb11011010FBBBuuuuuu1QQQQQ.  */
{ "macd", 0x28DA0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macd<.f> b,b,s12 00101bbb10011010FBBBssssssSSSSSS.  */
{ "macd", 0x289A0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macd<.f> a,limm,c 0010111000011010F111CCCCCCAAAAAA.  */
{ "macd", 0x2E1A7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, LIMM, RC }, { C_F }},

/* macd<.f> a,b,limm 00101bbb00011010FBBB111110AAAAAA.  */
{ "macd", 0x281A0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, RB, LIMM }, { C_F }},

/* macd<.f> 0,limm,c 0010111000011010F111CCCCCC111110.  */
{ "macd", 0x2E1A703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, RC }, { C_F }},

/* macd<.f> 0,b,limm 00101bbb00011010FBBB111110111110.  */
{ "macd", 0x281A0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, RB, LIMM }, { C_F }},

/* macd<.f><.cc> b,b,limm 00101bbb11011010FBBB1111100QQQQQ.  */
{ "macd", 0x28DA0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macd<.f><.cc> 0,limm,c 0010111011011010F111CCCCCC0QQQQQ.  */
{ "macd", 0x2EDA7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macd<.f> a,limm,u6 0010111001011010F111uuuuuuAAAAAA.  */
{ "macd", 0x2E5A7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macd<.f> 0,limm,u6 0010111001011010F111uuuuuu111110.  */
{ "macd", 0x2E5A703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macd<.f><.cc> 0,limm,u6 0010111011011010F111uuuuuu1QQQQQ.  */
{ "macd", 0x2EDA7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macd<.f> 0,limm,s12 0010111010011010F111ssssssSSSSSS.  */
{ "macd", 0x2E9A7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macd<.f> a,limm,limm 0010111000011010F111111110AAAAAA.  */
{ "macd", 0x2E1A7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macd<.f> 0,limm,limm 0010111000011010F111111110111110.  */
{ "macd", 0x2E1A7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, LIMMdup }, { C_F }},

/* macd<.f><.cc> 0,limm,limm 0010111011011010F1111111100QQQQQ.  */
{ "macd", 0x2EDA7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macdf<.f> a,b,c 00110bbb00010011FBBBCCCCCCAAAAAA.  */
{ "macdf", 0x30130000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { RA_CHK, RB, RC }, { C_F }},

/* macdf<.f> 0,b,c 00110bbb00010011FBBBCCCCCC111110.  */
{ "macdf", 0x3013003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { ZA, RB, RC }, { C_F }},

/* macdf<.f><.cc> b,b,c 00110bbb11010011FBBBCCCCCC0QQQQQ.  */
{ "macdf", 0x30D30000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macdf<.f> a,b,u6 00110bbb01010011FBBBuuuuuuAAAAAA.  */
{ "macdf", 0x30530000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macdf<.f> 0,b,u6 00110bbb01010011FBBBuuuuuu111110.  */
{ "macdf", 0x3053003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* macdf<.f><.cc> b,b,u6 00110bbb11010011FBBBuuuuuu1QQQQQ.  */
{ "macdf", 0x30D30020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macdf<.f> b,b,s12 00110bbb10010011FBBBssssssSSSSSS.  */
{ "macdf", 0x30930000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macdf<.f> a,limm,c 0011011000010011F111CCCCCCAAAAAA.  */
{ "macdf", 0x36137000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* macdf<.f> a,b,limm 00110bbb00010011FBBB111110AAAAAA.  */
{ "macdf", 0x30130F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* macdf<.f> 0,limm,c 0011011000010011F111CCCCCC111110.  */
{ "macdf", 0x3613703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { ZA, LIMM, RC }, { C_F }},

/* macdf<.f> 0,b,limm 00110bbb00010011FBBB111110111110.  */
{ "macdf", 0x30130FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { ZA, RB, LIMM }, { C_F }},

/* macdf<.f><.cc> b,b,limm 00110bbb11010011FBBB1111100QQQQQ.  */
{ "macdf", 0x30D30F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macdf<.f><.cc> 0,limm,c 0011011011010011F111CCCCCC0QQQQQ.  */
{ "macdf", 0x36D37000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macdf<.f> a,limm,u6 0011011001010011F111uuuuuuAAAAAA.  */
{ "macdf", 0x36537000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macdf<.f> 0,limm,u6 0011011001010011F111uuuuuu111110.  */
{ "macdf", 0x3653703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macdf<.f><.cc> 0,limm,u6 0011011011010011F111uuuuuu1QQQQQ.  */
{ "macdf", 0x36D37020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macdf<.f> 0,limm,s12 0011011010010011F111ssssssSSSSSS.  */
{ "macdf", 0x36937000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macdf<.f> a,limm,limm 0011011000010011F111111110AAAAAA.  */
{ "macdf", 0x36137F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macdf<.f> 0,limm,limm 0011011000010011F111111110111110.  */
{ "macdf", 0x36137FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* macdf<.f><.cc> 0,limm,limm 0011011011010011F1111111100QQQQQ.  */
{ "macdf", 0x36D37F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macdu<.f> a,b,c 00101bbb00011011FBBBCCCCCCAAAAAA.  */
{ "macdu", 0x281B0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, RB, RC }, { C_F }},

/* macdu<.f> 0,b,c 00101bbb00011011FBBBCCCCCC111110.  */
{ "macdu", 0x281B003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, RB, RC }, { C_F }},

/* macdu<.f><.cc> b,b,c 00101bbb11011011FBBBCCCCCC0QQQQQ.  */
{ "macdu", 0x28DB0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macdu<.f> a,b,u6 00101bbb01011011FBBBuuuuuuAAAAAA.  */
{ "macdu", 0x285B0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macdu<.f> 0,b,u6 00101bbb01011011FBBBuuuuuu111110.  */
{ "macdu", 0x285B003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, RB, UIMM6_20 }, { C_F }},

/* macdu<.f><.cc> b,b,u6 00101bbb11011011FBBBuuuuuu1QQQQQ.  */
{ "macdu", 0x28DB0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macdu<.f> b,b,s12 00101bbb10011011FBBBssssssSSSSSS.  */
{ "macdu", 0x289B0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macdu<.f> a,limm,c 0010111000011011F111CCCCCCAAAAAA.  */
{ "macdu", 0x2E1B7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, LIMM, RC }, { C_F }},

/* macdu<.f> a,b,limm 00101bbb00011011FBBB111110AAAAAA.  */
{ "macdu", 0x281B0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, RB, LIMM }, { C_F }},

/* macdu<.f> 0,limm,c 0010111000011011F111CCCCCC111110.  */
{ "macdu", 0x2E1B703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, RC }, { C_F }},

/* macdu<.f> 0,b,limm 00101bbb00011011FBBB111110111110.  */
{ "macdu", 0x281B0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, RB, LIMM }, { C_F }},

/* macdu<.f><.cc> b,b,limm 00101bbb11011011FBBB1111100QQQQQ.  */
{ "macdu", 0x28DB0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macdu<.f><.cc> 0,limm,c 0010111011011011F111CCCCCC0QQQQQ.  */
{ "macdu", 0x2EDB7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macdu<.f> a,limm,u6 0010111001011011F111uuuuuuAAAAAA.  */
{ "macdu", 0x2E5B7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macdu<.f> 0,limm,u6 0010111001011011F111uuuuuu111110.  */
{ "macdu", 0x2E5B703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macdu<.f><.cc> 0,limm,u6 0010111011011011F111uuuuuu1QQQQQ.  */
{ "macdu", 0x2EDB7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macdu<.f> 0,limm,s12 0010111010011011F111ssssssSSSSSS.  */
{ "macdu", 0x2E9B7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macdu<.f> a,limm,limm 0010111000011011F111111110AAAAAA.  */
{ "macdu", 0x2E1B7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macdu<.f> 0,limm,limm 0010111000011011F111111110111110.  */
{ "macdu", 0x2E1B7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, LIMMdup }, { C_F }},

/* macdu<.f><.cc> 0,limm,limm 0010111011011011F1111111100QQQQQ.  */
{ "macdu", 0x2EDB7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macdw<.f> a,b,c 00101bbb00010000FBBBCCCCCCAAAAAA.  */
{ "macdw", 0x28100000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* macdw<.f> 0,b,c 00101bbb00010000FBBBCCCCCC111110.  */
{ "macdw", 0x2810003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* macdw<.f><.cc> b,b,c 00101bbb11010000FBBBCCCCCC0QQQQQ.  */
{ "macdw", 0x28D00000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macdw<.f> a,b,u6 00101bbb01010000FBBBuuuuuuAAAAAA.  */
{ "macdw", 0x28500000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macdw<.f> 0,b,u6 00101bbb01010000FBBBuuuuuu111110.  */
{ "macdw", 0x2850003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* macdw<.f><.cc> b,b,u6 00101bbb11010000FBBBuuuuuu1QQQQQ.  */
{ "macdw", 0x28D00020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macdw<.f> b,b,s12 00101bbb10010000FBBBssssssSSSSSS.  */
{ "macdw", 0x28900000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macdw<.f> a,limm,c 0010111000010000F111CCCCCCAAAAAA.  */
{ "macdw", 0x2E107000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* macdw<.f> a,b,limm 00101bbb00010000FBBB111110AAAAAA.  */
{ "macdw", 0x28100F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* macdw<.f> 0,limm,c 0010111000010000F111CCCCCC111110.  */
{ "macdw", 0x2E10703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* macdw<.f> 0,b,limm 00101bbb00010000FBBB111110111110.  */
{ "macdw", 0x28100FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* macdw<.f><.cc> 0,limm,c 0010111011010000F111CCCCCC0QQQQQ.  */
{ "macdw", 0x2ED07000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macdw<.f><.cc> b,b,limm 00101bbb11010000FBBB1111100QQQQQ.  */
{ "macdw", 0x28D00F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macdw<.f> a,limm,u6 0010111001010000F111uuuuuuAAAAAA.  */
{ "macdw", 0x2E507000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macdw<.f> 0,limm,u6 0010111001010000F111uuuuuu111110.  */
{ "macdw", 0x2E50703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macdw<.f><.cc> 0,limm,u6 0010111011010000F111uuuuuu1QQQQQ.  */
{ "macdw", 0x2ED07020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macdw<.f> 0,limm,s12 0010111010010000F111ssssssSSSSSS.  */
{ "macdw", 0x2E907000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macdw<.f> a,limm,limm 0010111000010000F111111110AAAAAA.  */
{ "macdw", 0x2E107F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macdw<.f> 0,limm,limm 0010111000010000F111111110111110.  */
{ "macdw", 0x2E107FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* macdw<.f><.cc> 0,limm,limm 0010111011010000F1111111100QQQQQ.  */
{ "macdw", 0x2ED07F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macf<.f> a,b,c 00110bbb00001100FBBBCCCCCCAAAAAA.  */
{ "macf", 0x300C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* macf<.f> 0,b,c 00110bbb00001100FBBBCCCCCC111110.  */
{ "macf", 0x300C003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* macf<.f><.cc> b,b,c 00110bbb11001100FBBBCCCCCC0QQQQQ.  */
{ "macf", 0x30CC0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macf<.f> a,b,u6 00110bbb01001100FBBBuuuuuuAAAAAA.  */
{ "macf", 0x304C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macf<.f> 0,b,u6 00110bbb01001100FBBBuuuuuu111110.  */
{ "macf", 0x304C003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* macf<.f><.cc> b,b,u6 00110bbb11001100FBBBuuuuuu1QQQQQ.  */
{ "macf", 0x30CC0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macf<.f> b,b,s12 00110bbb10001100FBBBssssssSSSSSS.  */
{ "macf", 0x308C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macf<.f> a,limm,c 0011011000001100F111CCCCCCAAAAAA.  */
{ "macf", 0x360C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* macf<.f> a,b,limm 00110bbb00001100FBBB111110AAAAAA.  */
{ "macf", 0x300C0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* macf<.f> 0,limm,c 0011011000001100F111CCCCCC111110.  */
{ "macf", 0x360C703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* macf<.f> 0,b,limm 00110bbb00001100FBBB111110111110.  */
{ "macf", 0x300C0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* macf<.f><.cc> b,b,limm 00110bbb11001100FBBB1111100QQQQQ.  */
{ "macf", 0x30CC0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macf<.f><.cc> 0,limm,c 0011011011001100F111CCCCCC0QQQQQ.  */
{ "macf", 0x36CC7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macf<.f> a,limm,u6 0011011001001100F111uuuuuuAAAAAA.  */
{ "macf", 0x364C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macf<.f> 0,limm,u6 0011011001001100F111uuuuuu111110.  */
{ "macf", 0x364C703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macf<.f><.cc> 0,limm,u6 0011011011001100F111uuuuuu1QQQQQ.  */
{ "macf", 0x36CC7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macf<.f> 0,limm,s12 0011011010001100F111ssssssSSSSSS.  */
{ "macf", 0x368C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macf<.f> a,limm,limm 0011011000001100F111111110AAAAAA.  */
{ "macf", 0x360C7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macf<.f> 0,limm,limm 0011011000001100F111111110111110.  */
{ "macf", 0x360C7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* macf<.f><.cc> 0,limm,limm 0011011011001100F1111111100QQQQQ.  */
{ "macf", 0x36CC7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macflw<.f> a,b,c 00101bbb00110100FBBBCCCCCCAAAAAA.  */
{ "macflw", 0x28340000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* macflw<.f> 0,b,c 00101bbb00110100FBBBCCCCCC111110.  */
{ "macflw", 0x2834003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* macflw<.f><.cc> b,b,c 00101bbb11110100FBBBCCCCCC0QQQQQ.  */
{ "macflw", 0x28F40000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macflw<.f> a,b,u6 00101bbb01110100FBBBuuuuuuAAAAAA.  */
{ "macflw", 0x28740000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macflw<.f> 0,b,u6 00101bbb01110100FBBBuuuuuu111110.  */
{ "macflw", 0x2874003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* macflw<.f><.cc> b,b,u6 00101bbb11110100FBBBuuuuuu1QQQQQ.  */
{ "macflw", 0x28F40020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macflw<.f> b,b,s12 00101bbb10110100FBBBssssssSSSSSS.  */
{ "macflw", 0x28B40000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macflw<.f> a,limm,c 0010111000110100F111CCCCCCAAAAAA.  */
{ "macflw", 0x2E347000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* macflw<.f> a,b,limm 00101bbb00110100FBBB111110AAAAAA.  */
{ "macflw", 0x28340F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* macflw<.f> 0,limm,c 0010111000110100F111CCCCCC111110.  */
{ "macflw", 0x2E34703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* macflw<.f> 0,b,limm 00101bbb00110100FBBB111110111110.  */
{ "macflw", 0x28340FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* macflw<.f><.cc> 0,limm,c 0010111011110100F111CCCCCC0QQQQQ.  */
{ "macflw", 0x2EF47000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macflw<.f><.cc> b,b,limm 00101bbb11110100FBBB1111100QQQQQ.  */
{ "macflw", 0x28F40F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macflw<.f> a,limm,u6 0010111001110100F111uuuuuuAAAAAA.  */
{ "macflw", 0x2E747000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macflw<.f> 0,limm,u6 0010111001110100F111uuuuuu111110.  */
{ "macflw", 0x2E74703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macflw<.f><.cc> 0,limm,u6 0010111011110100F111uuuuuu1QQQQQ.  */
{ "macflw", 0x2EF47020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macflw<.f> 0,limm,s12 0010111010110100F111ssssssSSSSSS.  */
{ "macflw", 0x2EB47000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macflw<.f> a,limm,limm 0010111000110100F111111110AAAAAA.  */
{ "macflw", 0x2E347F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macflw<.f> 0,limm,limm 0010111000110100F111111110111110.  */
{ "macflw", 0x2E347FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* macflw<.f><.cc> 0,limm,limm 0010111011110100F1111111100QQQQQ.  */
{ "macflw", 0x2EF47F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macfr<.f> a,b,c 00110bbb00001101FBBBCCCCCCAAAAAA.  */
{ "macfr", 0x300D0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* macfr<.f> 0,b,c 00110bbb00001101FBBBCCCCCC111110.  */
{ "macfr", 0x300D003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* macfr<.f><.cc> b,b,c 00110bbb11001101FBBBCCCCCC0QQQQQ.  */
{ "macfr", 0x30CD0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macfr<.f> a,b,u6 00110bbb01001101FBBBuuuuuuAAAAAA.  */
{ "macfr", 0x304D0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macfr<.f> 0,b,u6 00110bbb01001101FBBBuuuuuu111110.  */
{ "macfr", 0x304D003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* macfr<.f><.cc> b,b,u6 00110bbb11001101FBBBuuuuuu1QQQQQ.  */
{ "macfr", 0x30CD0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macfr<.f> b,b,s12 00110bbb10001101FBBBssssssSSSSSS.  */
{ "macfr", 0x308D0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macfr<.f> a,limm,c 0011011000001101F111CCCCCCAAAAAA.  */
{ "macfr", 0x360D7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* macfr<.f> a,b,limm 00110bbb00001101FBBB111110AAAAAA.  */
{ "macfr", 0x300D0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* macfr<.f> 0,limm,c 0011011000001101F111CCCCCC111110.  */
{ "macfr", 0x360D703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* macfr<.f> 0,b,limm 00110bbb00001101FBBB111110111110.  */
{ "macfr", 0x300D0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* macfr<.f><.cc> b,b,limm 00110bbb11001101FBBB1111100QQQQQ.  */
{ "macfr", 0x30CD0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macfr<.f><.cc> 0,limm,c 0011011011001101F111CCCCCC0QQQQQ.  */
{ "macfr", 0x36CD7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macfr<.f> a,limm,u6 0011011001001101F111uuuuuuAAAAAA.  */
{ "macfr", 0x364D7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macfr<.f> 0,limm,u6 0011011001001101F111uuuuuu111110.  */
{ "macfr", 0x364D703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macfr<.f><.cc> 0,limm,u6 0011011011001101F111uuuuuu1QQQQQ.  */
{ "macfr", 0x36CD7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macfr<.f> 0,limm,s12 0011011010001101F111ssssssSSSSSS.  */
{ "macfr", 0x368D7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macfr<.f> a,limm,limm 0011011000001101F111111110AAAAAA.  */
{ "macfr", 0x360D7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macfr<.f> 0,limm,limm 0011011000001101F111111110111110.  */
{ "macfr", 0x360D7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* macfr<.f><.cc> 0,limm,limm 0011011011001101F1111111100QQQQQ.  */
{ "macfr", 0x36CD7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* machflw<.f> a,b,c 00101bbb00110111FBBBCCCCCCAAAAAA.  */
{ "machflw", 0x28370000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* machflw<.f> 0,b,c 00101bbb00110111FBBBCCCCCC111110.  */
{ "machflw", 0x2837003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* machflw<.f><.cc> b,b,c 00101bbb11110111FBBBCCCCCC0QQQQQ.  */
{ "machflw", 0x28F70000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* machflw<.f> a,b,u6 00101bbb01110111FBBBuuuuuuAAAAAA.  */
{ "machflw", 0x28770000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* machflw<.f> 0,b,u6 00101bbb01110111FBBBuuuuuu111110.  */
{ "machflw", 0x2877003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* machflw<.f><.cc> b,b,u6 00101bbb11110111FBBBuuuuuu1QQQQQ.  */
{ "machflw", 0x28F70020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* machflw<.f> b,b,s12 00101bbb10110111FBBBssssssSSSSSS.  */
{ "machflw", 0x28B70000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* machflw<.f> a,limm,c 0010111000110111F111CCCCCCAAAAAA.  */
{ "machflw", 0x2E377000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* machflw<.f> a,b,limm 00101bbb00110111FBBB111110AAAAAA.  */
{ "machflw", 0x28370F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* machflw<.f> 0,limm,c 0010111000110111F111CCCCCC111110.  */
{ "machflw", 0x2E37703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* machflw<.f> 0,b,limm 00101bbb00110111FBBB111110111110.  */
{ "machflw", 0x28370FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* machflw<.f><.cc> 0,limm,c 0010111011110111F111CCCCCC0QQQQQ.  */
{ "machflw", 0x2EF77000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* machflw<.f><.cc> b,b,limm 00101bbb11110111FBBB1111100QQQQQ.  */
{ "machflw", 0x28F70F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* machflw<.f> a,limm,u6 0010111001110111F111uuuuuuAAAAAA.  */
{ "machflw", 0x2E777000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* machflw<.f> 0,limm,u6 0010111001110111F111uuuuuu111110.  */
{ "machflw", 0x2E77703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* machflw<.f><.cc> 0,limm,u6 0010111011110111F111uuuuuu1QQQQQ.  */
{ "machflw", 0x2EF77020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* machflw<.f> 0,limm,s12 0010111010110111F111ssssssSSSSSS.  */
{ "machflw", 0x2EB77000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* machflw<.f> a,limm,limm 0010111000110111F111111110AAAAAA.  */
{ "machflw", 0x2E377F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* machflw<.f> 0,limm,limm 0010111000110111F111111110111110.  */
{ "machflw", 0x2E377FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* machflw<.f><.cc> 0,limm,limm 0010111011110111F1111111100QQQQQ.  */
{ "machflw", 0x2EF77F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* machlw<.f> a,b,c 00101bbb00110110FBBBCCCCCCAAAAAA.  */
{ "machlw", 0x28360000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* machlw<.f> 0,b,c 00101bbb00110110FBBBCCCCCC111110.  */
{ "machlw", 0x2836003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* machlw<.f><.cc> b,b,c 00101bbb11110110FBBBCCCCCC0QQQQQ.  */
{ "machlw", 0x28F60000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* machlw<.f> a,b,u6 00101bbb01110110FBBBuuuuuuAAAAAA.  */
{ "machlw", 0x28760000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* machlw<.f> 0,b,u6 00101bbb01110110FBBBuuuuuu111110.  */
{ "machlw", 0x2876003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* machlw<.f><.cc> b,b,u6 00101bbb11110110FBBBuuuuuu1QQQQQ.  */
{ "machlw", 0x28F60020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* machlw<.f> b,b,s12 00101bbb10110110FBBBssssssSSSSSS.  */
{ "machlw", 0x28B60000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* machlw<.f> a,limm,c 0010111000110110F111CCCCCCAAAAAA.  */
{ "machlw", 0x2E367000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* machlw<.f> a,b,limm 00101bbb00110110FBBB111110AAAAAA.  */
{ "machlw", 0x28360F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* machlw<.f> 0,limm,c 0010111000110110F111CCCCCC111110.  */
{ "machlw", 0x2E36703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* machlw<.f> 0,b,limm 00101bbb00110110FBBB111110111110.  */
{ "machlw", 0x28360FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* machlw<.f><.cc> 0,limm,c 0010111011110110F111CCCCCC0QQQQQ.  */
{ "machlw", 0x2EF67000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* machlw<.f><.cc> b,b,limm 00101bbb11110110FBBB1111100QQQQQ.  */
{ "machlw", 0x28F60F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* machlw<.f> a,limm,u6 0010111001110110F111uuuuuuAAAAAA.  */
{ "machlw", 0x2E767000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* machlw<.f> 0,limm,u6 0010111001110110F111uuuuuu111110.  */
{ "machlw", 0x2E76703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* machlw<.f><.cc> 0,limm,u6 0010111011110110F111uuuuuu1QQQQQ.  */
{ "machlw", 0x2EF67020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* machlw<.f> 0,limm,s12 0010111010110110F111ssssssSSSSSS.  */
{ "machlw", 0x2EB67000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* machlw<.f> a,limm,limm 0010111000110110F111111110AAAAAA.  */
{ "machlw", 0x2E367F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* machlw<.f> 0,limm,limm 0010111000110110F111111110111110.  */
{ "machlw", 0x2E367FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* machlw<.f><.cc> 0,limm,limm 0010111011110110F1111111100QQQQQ.  */
{ "machlw", 0x2EF67F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* machulw<.f> a,b,c 00101bbb00110101FBBBCCCCCCAAAAAA.  */
{ "machulw", 0x28350000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* machulw<.f> 0,b,c 00101bbb00110101FBBBCCCCCC111110.  */
{ "machulw", 0x2835003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* machulw<.f><.cc> b,b,c 00101bbb11110101FBBBCCCCCC0QQQQQ.  */
{ "machulw", 0x28F50000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* machulw<.f> a,b,u6 00101bbb01110101FBBBuuuuuuAAAAAA.  */
{ "machulw", 0x28750000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* machulw<.f> 0,b,u6 00101bbb01110101FBBBuuuuuu111110.  */
{ "machulw", 0x2875003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* machulw<.f><.cc> b,b,u6 00101bbb11110101FBBBuuuuuu1QQQQQ.  */
{ "machulw", 0x28F50020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* machulw<.f> b,b,s12 00101bbb10110101FBBBssssssSSSSSS.  */
{ "machulw", 0x28B50000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* machulw<.f> a,limm,c 0010111000110101F111CCCCCCAAAAAA.  */
{ "machulw", 0x2E357000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* machulw<.f> a,b,limm 00101bbb00110101FBBB111110AAAAAA.  */
{ "machulw", 0x28350F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* machulw<.f> 0,limm,c 0010111000110101F111CCCCCC111110.  */
{ "machulw", 0x2E35703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* machulw<.f> 0,b,limm 00101bbb00110101FBBB111110111110.  */
{ "machulw", 0x28350FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* machulw<.f><.cc> 0,limm,c 0010111011110101F111CCCCCC0QQQQQ.  */
{ "machulw", 0x2EF57000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* machulw<.f><.cc> b,b,limm 00101bbb11110101FBBB1111100QQQQQ.  */
{ "machulw", 0x28F50F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* machulw<.f> a,limm,u6 0010111001110101F111uuuuuuAAAAAA.  */
{ "machulw", 0x2E757000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* machulw<.f> 0,limm,u6 0010111001110101F111uuuuuu111110.  */
{ "machulw", 0x2E75703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* machulw<.f><.cc> 0,limm,u6 0010111011110101F111uuuuuu1QQQQQ.  */
{ "machulw", 0x2EF57020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* machulw<.f> 0,limm,s12 0010111010110101F111ssssssSSSSSS.  */
{ "machulw", 0x2EB57000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* machulw<.f> a,limm,limm 0010111000110101F111111110AAAAAA.  */
{ "machulw", 0x2E357F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* machulw<.f> 0,limm,limm 0010111000110101F111111110111110.  */
{ "machulw", 0x2E357FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* machulw<.f><.cc> 0,limm,limm 0010111011110101F1111111100QQQQQ.  */
{ "machulw", 0x2EF57F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* maclw<.f> a,b,c 00101bbb00110011FBBBCCCCCCAAAAAA.  */
{ "maclw", 0x28330000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* maclw<.f> 0,b,c 00101bbb00110011FBBBCCCCCC111110.  */
{ "maclw", 0x2833003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* maclw<.f><.cc> b,b,c 00101bbb11110011FBBBCCCCCC0QQQQQ.  */
{ "maclw", 0x28F30000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* maclw<.f> a,b,u6 00101bbb01110011FBBBuuuuuuAAAAAA.  */
{ "maclw", 0x28730000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* maclw<.f> 0,b,u6 00101bbb01110011FBBBuuuuuu111110.  */
{ "maclw", 0x2873003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* maclw<.f><.cc> b,b,u6 00101bbb11110011FBBBuuuuuu1QQQQQ.  */
{ "maclw", 0x28F30020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* maclw<.f> b,b,s12 00101bbb10110011FBBBssssssSSSSSS.  */
{ "maclw", 0x28B30000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* maclw<.f> a,limm,c 0010111000110011F111CCCCCCAAAAAA.  */
{ "maclw", 0x2E337000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* maclw<.f> a,b,limm 00101bbb00110011FBBB111110AAAAAA.  */
{ "maclw", 0x28330F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* maclw<.f> 0,limm,c 0010111000110011F111CCCCCC111110.  */
{ "maclw", 0x2E33703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* maclw<.f> 0,b,limm 00101bbb00110011FBBB111110111110.  */
{ "maclw", 0x28330FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* maclw<.f><.cc> 0,limm,c 0010111011110011F111CCCCCC0QQQQQ.  */
{ "maclw", 0x2EF37000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* maclw<.f><.cc> b,b,limm 00101bbb11110011FBBB1111100QQQQQ.  */
{ "maclw", 0x28F30F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* maclw<.f> a,limm,u6 0010111001110011F111uuuuuuAAAAAA.  */
{ "maclw", 0x2E737000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* maclw<.f> 0,limm,u6 0010111001110011F111uuuuuu111110.  */
{ "maclw", 0x2E73703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* maclw<.f><.cc> 0,limm,u6 0010111011110011F111uuuuuu1QQQQQ.  */
{ "maclw", 0x2EF37020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* maclw<.f> 0,limm,s12 0010111010110011F111ssssssSSSSSS.  */
{ "maclw", 0x2EB37000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* maclw<.f> a,limm,limm 0010111000110011F111111110AAAAAA.  */
{ "maclw", 0x2E337F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* maclw<.f> 0,limm,limm 0010111000110011F111111110111110.  */
{ "maclw", 0x2E337FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* maclw<.f><.cc> 0,limm,limm 0010111011110011F1111111100QQQQQ.  */
{ "maclw", 0x2EF37F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macrdw<.f> a,b,c 00101bbb00010010FBBBCCCCCCAAAAAA.  */
{ "macrdw", 0x28120000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* macrdw<.f> 0,b,c 00101bbb00010010FBBBCCCCCC111110.  */
{ "macrdw", 0x2812003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* macrdw<.f><.cc> b,b,c 00101bbb11010010FBBBCCCCCC0QQQQQ.  */
{ "macrdw", 0x28D20000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macrdw<.f> a,b,u6 00101bbb01010010FBBBuuuuuuAAAAAA.  */
{ "macrdw", 0x28520000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macrdw<.f> 0,b,u6 00101bbb01010010FBBBuuuuuu111110.  */
{ "macrdw", 0x2852003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* macrdw<.f><.cc> b,b,u6 00101bbb11010010FBBBuuuuuu1QQQQQ.  */
{ "macrdw", 0x28D20020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macrdw<.f> b,b,s12 00101bbb10010010FBBBssssssSSSSSS.  */
{ "macrdw", 0x28920000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macrdw<.f> a,limm,c 0010111000010010F111CCCCCCAAAAAA.  */
{ "macrdw", 0x2E127000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* macrdw<.f> a,b,limm 00101bbb00010010FBBB111110AAAAAA.  */
{ "macrdw", 0x28120F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* macrdw<.f> 0,limm,c 0010111000010010F111CCCCCC111110.  */
{ "macrdw", 0x2E12703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* macrdw<.f> 0,b,limm 00101bbb00010010FBBB111110111110.  */
{ "macrdw", 0x28120FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* macrdw<.f><.cc> 0,limm,c 0010111011010010F111CCCCCC0QQQQQ.  */
{ "macrdw", 0x2ED27000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macrdw<.f><.cc> b,b,limm 00101bbb11010010FBBB1111100QQQQQ.  */
{ "macrdw", 0x28D20F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macrdw<.f> a,limm,u6 0010111001010010F111uuuuuuAAAAAA.  */
{ "macrdw", 0x2E527000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macrdw<.f> 0,limm,u6 0010111001010010F111uuuuuu111110.  */
{ "macrdw", 0x2E52703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macrdw<.f><.cc> 0,limm,u6 0010111011010010F111uuuuuu1QQQQQ.  */
{ "macrdw", 0x2ED27020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macrdw<.f> 0,limm,s12 0010111010010010F111ssssssSSSSSS.  */
{ "macrdw", 0x2E927000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macrdw<.f> a,limm,limm 0010111000010010F111111110AAAAAA.  */
{ "macrdw", 0x2E127F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macrdw<.f> 0,limm,limm 0010111000010010F111111110111110.  */
{ "macrdw", 0x2E127FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* macrdw<.f><.cc> 0,limm,limm 0010111011010010F1111111100QQQQQ.  */
{ "macrdw", 0x2ED27F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macrt<.f> a,b,c 00101bbb00011110FBBBCCCCCCAAAAAA.  */
{ "macrt", 0x281E0000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* macrt<.f> 0,b,c 00101bbb00011110FBBBCCCCCC111110.  */
{ "macrt", 0x281E003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* macrt<.f><.cc> b,b,c 00101bbb11011110FBBBCCCCCC0QQQQQ.  */
{ "macrt", 0x28DE0000, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macrt<.f> a,b,u6 00101bbb01011110FBBBuuuuuuAAAAAA.  */
{ "macrt", 0x285E0000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macrt<.f> 0,b,u6 00101bbb01011110FBBBuuuuuu111110.  */
{ "macrt", 0x285E003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* macrt<.f><.cc> b,b,u6 00101bbb11011110FBBBuuuuuu1QQQQQ.  */
{ "macrt", 0x28DE0020, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macrt<.f> b,b,s12 00101bbb10011110FBBBssssssSSSSSS.  */
{ "macrt", 0x289E0000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macrt<.f> a,limm,c 0010111000011110F111CCCCCCAAAAAA.  */
{ "macrt", 0x2E1E7000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* macrt<.f> a,b,limm 00101bbb00011110FBBB111110AAAAAA.  */
{ "macrt", 0x281E0F80, 0xF8FF0FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* macrt<.f> 0,limm,c 0010111000011110F111CCCCCC111110.  */
{ "macrt", 0x2E1E703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* macrt<.f> 0,b,limm 00101bbb00011110FBBB111110111110.  */
{ "macrt", 0x281E0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* macrt<.f><.cc> 0,limm,c 0010111011011110F111CCCCCC0QQQQQ.  */
{ "macrt", 0x2EDE7000, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macrt<.f><.cc> b,b,limm 00101bbb11011110FBBB1111100QQQQQ.  */
{ "macrt", 0x28DE0F80, 0xF8FF0FE0, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macrt<.f> a,limm,u6 0010111001011110F111uuuuuuAAAAAA.  */
{ "macrt", 0x2E5E7000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macrt<.f> 0,limm,u6 0010111001011110F111uuuuuu111110.  */
{ "macrt", 0x2E5E703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macrt<.f><.cc> 0,limm,u6 0010111011011110F111uuuuuu1QQQQQ.  */
{ "macrt", 0x2EDE7020, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macrt<.f> 0,limm,s12 0010111010011110F111ssssssSSSSSS.  */
{ "macrt", 0x2E9E7000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macrt<.f> a,limm,limm 0010111000011110F111111110AAAAAA.  */
{ "macrt", 0x2E1E7F80, 0xFFFF7FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macrt<.f> 0,limm,limm 0010111000011110F111111110111110.  */
{ "macrt", 0x2E1E7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* macrt<.f><.cc> 0,limm,limm 0010111011011110F1111111100QQQQQ.  */
{ "macrt", 0x2EDE7F80, 0xFFFF7FE0, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mact<.f> a,b,c 00101bbb00011100FBBBCCCCCCAAAAAA.  */
{ "mact", 0x281C0000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mact<.f> 0,b,c 00101bbb00011100FBBBCCCCCC111110.  */
{ "mact", 0x281C003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* mact<.f><.cc> b,b,c 00101bbb11011100FBBBCCCCCC0QQQQQ.  */
{ "mact", 0x28DC0000, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mact<.f> a,b,u6 00101bbb01011100FBBBuuuuuuAAAAAA.  */
{ "mact", 0x285C0000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mact<.f> 0,b,u6 00101bbb01011100FBBBuuuuuu111110.  */
{ "mact", 0x285C003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mact<.f><.cc> b,b,u6 00101bbb11011100FBBBuuuuuu1QQQQQ.  */
{ "mact", 0x28DC0020, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mact<.f> b,b,s12 00101bbb10011100FBBBssssssSSSSSS.  */
{ "mact", 0x289C0000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mact<.f> a,limm,c 0010111000011100F111CCCCCCAAAAAA.  */
{ "mact", 0x2E1C7000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mact<.f> a,b,limm 00101bbb00011100FBBB111110AAAAAA.  */
{ "mact", 0x281C0F80, 0xF8FF0FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mact<.f> 0,limm,c 0010111000011100F111CCCCCC111110.  */
{ "mact", 0x2E1C703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* mact<.f> 0,b,limm 00101bbb00011100FBBB111110111110.  */
{ "mact", 0x281C0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* mact<.f><.cc> 0,limm,c 0010111011011100F111CCCCCC0QQQQQ.  */
{ "mact", 0x2EDC7000, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mact<.f><.cc> b,b,limm 00101bbb11011100FBBB1111100QQQQQ.  */
{ "mact", 0x28DC0F80, 0xF8FF0FE0, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mact<.f> a,limm,u6 0010111001011100F111uuuuuuAAAAAA.  */
{ "mact", 0x2E5C7000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mact<.f> 0,limm,u6 0010111001011100F111uuuuuu111110.  */
{ "mact", 0x2E5C703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mact<.f><.cc> 0,limm,u6 0010111011011100F111uuuuuu1QQQQQ.  */
{ "mact", 0x2EDC7020, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mact<.f> 0,limm,s12 0010111010011100F111ssssssSSSSSS.  */
{ "mact", 0x2E9C7000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mact<.f> a,limm,limm 0010111000011100F111111110AAAAAA.  */
{ "mact", 0x2E1C7F80, 0xFFFF7FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mact<.f> 0,limm,limm 0010111000011100F111111110111110.  */
{ "mact", 0x2E1C7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mact<.f><.cc> 0,limm,limm 0010111011011100F1111111100QQQQQ.  */
{ "mact", 0x2EDC7F80, 0xFFFF7FE0, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macu<.f> a,b,c 00101bbb00001111FBBBCCCCCCAAAAAA.  */
{ "macu", 0x280F0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, RB, RC }, { C_F }},

/* macu<.f> 0,b,c 00101bbb00001111FBBBCCCCCC111110.  */
{ "macu", 0x280F003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, RB, RC }, { C_F }},

/* macu<.f><.cc> b,b,c 00101bbb11001111FBBBCCCCCC0QQQQQ.  */
{ "macu", 0x28CF0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macu<.f> a,b,u6 00101bbb01001111FBBBuuuuuuAAAAAA.  */
{ "macu", 0x284F0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macu<.f> 0,b,u6 00101bbb01001111FBBBuuuuuu111110.  */
{ "macu", 0x284F003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, RB, UIMM6_20 }, { C_F }},

/* macu<.f><.cc> b,b,u6 00101bbb11001111FBBBuuuuuu1QQQQQ.  */
{ "macu", 0x28CF0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macu<.f> b,b,s12 00101bbb10001111FBBBssssssSSSSSS.  */
{ "macu", 0x288F0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macu<.f> a,limm,c 0010111000001111F111CCCCCCAAAAAA.  */
{ "macu", 0x2E0F7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, LIMM, RC }, { C_F }},

/* macu<.f> a,b,limm 00101bbb00001111FBBB111110AAAAAA.  */
{ "macu", 0x280F0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, RB, LIMM }, { C_F }},

/* macu<.f> 0,limm,c 0010111000001111F111CCCCCC111110.  */
{ "macu", 0x2E0F703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, RC }, { C_F }},

/* macu<.f> 0,b,limm 00101bbb00001111FBBB111110111110.  */
{ "macu", 0x280F0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, RB, LIMM }, { C_F }},

/* macu<.f><.cc> b,b,limm 00101bbb11001111FBBB1111100QQQQQ.  */
{ "macu", 0x28CF0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macu<.f><.cc> 0,limm,c 0010111011001111F111CCCCCC0QQQQQ.  */
{ "macu", 0x2ECF7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macu<.f> a,limm,u6 0010111001001111F111uuuuuuAAAAAA.  */
{ "macu", 0x2E4F7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macu<.f> 0,limm,u6 0010111001001111F111uuuuuu111110.  */
{ "macu", 0x2E4F703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macu<.f><.cc> 0,limm,u6 0010111011001111F111uuuuuu1QQQQQ.  */
{ "macu", 0x2ECF7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macu<.f> 0,limm,s12 0010111010001111F111ssssssSSSSSS.  */
{ "macu", 0x2E8F7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macu<.f> a,limm,limm 0010111000001111F111111110AAAAAA.  */
{ "macu", 0x2E0F7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macu<.f> 0,limm,limm 0010111000001111F111111110111110.  */
{ "macu", 0x2E0F7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F }},

/* macu<.f><.cc> 0,limm,limm 0010111011001111F1111111100QQQQQ.  */
{ "macu", 0x2ECF7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macudw<.f> a,b,c 00101bbb00010001FBBBCCCCCCAAAAAA.  */
{ "macudw", 0x28110000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* macudw<.f> 0,b,c 00101bbb00010001FBBBCCCCCC111110.  */
{ "macudw", 0x2811003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* macudw<.f><.cc> b,b,c 00101bbb11010001FBBBCCCCCC0QQQQQ.  */
{ "macudw", 0x28D10000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macudw<.f> a,b,u6 00101bbb01010001FBBBuuuuuuAAAAAA.  */
{ "macudw", 0x28510000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macudw<.f> 0,b,u6 00101bbb01010001FBBBuuuuuu111110.  */
{ "macudw", 0x2851003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* macudw<.f><.cc> b,b,u6 00101bbb11010001FBBBuuuuuu1QQQQQ.  */
{ "macudw", 0x28D10020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macudw<.f> b,b,s12 00101bbb10010001FBBBssssssSSSSSS.  */
{ "macudw", 0x28910000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macudw<.f> a,limm,c 0010111000010001F111CCCCCCAAAAAA.  */
{ "macudw", 0x2E117000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* macudw<.f> a,b,limm 00101bbb00010001FBBB111110AAAAAA.  */
{ "macudw", 0x28110F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* macudw<.f> 0,limm,c 0010111000010001F111CCCCCC111110.  */
{ "macudw", 0x2E11703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* macudw<.f> 0,b,limm 00101bbb00010001FBBB111110111110.  */
{ "macudw", 0x28110FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* macudw<.f><.cc> 0,limm,c 0010111011010001F111CCCCCC0QQQQQ.  */
{ "macudw", 0x2ED17000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macudw<.f><.cc> b,b,limm 00101bbb11010001FBBB1111100QQQQQ.  */
{ "macudw", 0x28D10F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macudw<.f> a,limm,u6 0010111001010001F111uuuuuuAAAAAA.  */
{ "macudw", 0x2E517000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macudw<.f> 0,limm,u6 0010111001010001F111uuuuuu111110.  */
{ "macudw", 0x2E51703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macudw<.f><.cc> 0,limm,u6 0010111011010001F111uuuuuu1QQQQQ.  */
{ "macudw", 0x2ED17020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macudw<.f> 0,limm,s12 0010111010010001F111ssssssSSSSSS.  */
{ "macudw", 0x2E917000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macudw<.f> a,limm,limm 0010111000010001F111111110AAAAAA.  */
{ "macudw", 0x2E117F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macudw<.f> 0,limm,limm 0010111000010001F111111110111110.  */
{ "macudw", 0x2E117FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* macudw<.f><.cc> 0,limm,limm 0010111011010001F1111111100QQQQQ.  */
{ "macudw", 0x2ED17F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macwhfl<.f> a,b,c 00110bbb00100110FBBBCCCCCCAAAAAA.  */
{ "macwhfl", 0x30260000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* macwhfl<.f> 0,b,c 00110bbb00100110FBBBCCCCCC111110.  */
{ "macwhfl", 0x3026003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* macwhfl<.f><.cc> b,b,c 00110bbb11100110FBBBCCCCCC0QQQQQ.  */
{ "macwhfl", 0x30E60000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macwhfl<.f> a,b,u6 00110bbb01100110FBBBuuuuuuAAAAAA.  */
{ "macwhfl", 0x30660000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macwhfl<.f> 0,b,u6 00110bbb01100110FBBBuuuuuu111110.  */
{ "macwhfl", 0x3066003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* macwhfl<.f><.cc> b,b,u6 00110bbb11100110FBBBuuuuuu1QQQQQ.  */
{ "macwhfl", 0x30E60020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macwhfl<.f> b,b,s12 00110bbb10100110FBBBssssssSSSSSS.  */
{ "macwhfl", 0x30A60000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macwhfl<.f> a,limm,c 0011011000100110F111CCCCCCAAAAAA.  */
{ "macwhfl", 0x36267000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* macwhfl<.f> a,b,limm 00110bbb00100110FBBB111110AAAAAA.  */
{ "macwhfl", 0x30260F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* macwhfl<.f> 0,limm,c 0011011001100110F111CCCCCC111110.  */
{ "macwhfl", 0x3666703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* macwhfl<.f> 0,b,limm 00110bbb00100110FBBB111110111110.  */
{ "macwhfl", 0x30260FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* macwhfl<.f><.cc> b,b,limm 00110bbb11100110FBBB1111100QQQQQ.  */
{ "macwhfl", 0x30E60F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macwhfl<.f><.cc> 0,limm,c 0011011011100110F111CCCCCC0QQQQQ.  */
{ "macwhfl", 0x36E67000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macwhfl<.f> a,limm,u6 0011011001100110F111uuuuuuAAAAAA.  */
{ "macwhfl", 0x36667000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macwhfl<.f> 0,limm,u6 0011011001100110F111uuuuuu111110.  */
{ "macwhfl", 0x3666703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macwhfl<.f><.cc> 0,limm,u6 0011011011100110F111uuuuuu1QQQQQ.  */
{ "macwhfl", 0x36E67020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macwhfl<.f> 0,limm,s12 0011011010100110F111ssssssSSSSSS.  */
{ "macwhfl", 0x36A67000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macwhfl<.f> a,limm,limm 0011011000100110F111111110AAAAAA.  */
{ "macwhfl", 0x36267F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macwhfl<.f> 0,limm,limm 0011011000100110F111111110111110.  */
{ "macwhfl", 0x36267FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* macwhfl<.f><.cc> 0,limm,limm 0011011011100110F1111111100QQQQQ.  */
{ "macwhfl", 0x36E67F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macwhflr<.f> a,b,c 00110bbb00100111FBBBCCCCCCAAAAAA.  */
{ "macwhflr", 0x30270000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* macwhflr<.f> 0,b,c 00110bbb00100111FBBBCCCCCC111110.  */
{ "macwhflr", 0x3027003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* macwhflr<.f><.cc> b,b,c 00110bbb11100111FBBBCCCCCC0QQQQQ.  */
{ "macwhflr", 0x30E70000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macwhflr<.f> a,b,u6 00110bbb01100111FBBBuuuuuuAAAAAA.  */
{ "macwhflr", 0x30670000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macwhflr<.f> 0,b,u6 00110bbb01100111FBBBuuuuuu111110.  */
{ "macwhflr", 0x3067003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* macwhflr<.f><.cc> b,b,u6 00110bbb11100111FBBBuuuuuu1QQQQQ.  */
{ "macwhflr", 0x30E70020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macwhflr<.f> b,b,s12 00110bbb10100111FBBBssssssSSSSSS.  */
{ "macwhflr", 0x30A70000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macwhflr<.f> a,limm,c 0011011000100111F111CCCCCCAAAAAA.  */
{ "macwhflr", 0x36277000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* macwhflr<.f> a,b,limm 00110bbb00100111FBBB111110AAAAAA.  */
{ "macwhflr", 0x30270F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* macwhflr<.f> 0,limm,c 0011011001100111F111CCCCCC111110.  */
{ "macwhflr", 0x3667703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* macwhflr<.f> 0,b,limm 00110bbb00100111FBBB111110111110.  */
{ "macwhflr", 0x30270FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* macwhflr<.f><.cc> b,b,limm 00110bbb11100111FBBB1111100QQQQQ.  */
{ "macwhflr", 0x30E70F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macwhflr<.f><.cc> 0,limm,c 0011011011100111F111CCCCCC0QQQQQ.  */
{ "macwhflr", 0x36E77000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macwhflr<.f> a,limm,u6 0011011001100111F111uuuuuuAAAAAA.  */
{ "macwhflr", 0x36677000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macwhflr<.f> 0,limm,u6 0011011001100111F111uuuuuu111110.  */
{ "macwhflr", 0x3667703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macwhflr<.f><.cc> 0,limm,u6 0011011011100111F111uuuuuu1QQQQQ.  */
{ "macwhflr", 0x36E77020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macwhflr<.f> 0,limm,s12 0011011010100111F111ssssssSSSSSS.  */
{ "macwhflr", 0x36A77000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macwhflr<.f> a,limm,limm 0011011000100111F111111110AAAAAA.  */
{ "macwhflr", 0x36277F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macwhflr<.f> 0,limm,limm 0011011000100111F111111110111110.  */
{ "macwhflr", 0x36277FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* macwhflr<.f><.cc> 0,limm,limm 0011011011100111F1111111100QQQQQ.  */
{ "macwhflr", 0x36E77F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macwhfm<.f> a,b,c 00110bbb00100010FBBBCCCCCCAAAAAA.  */
{ "macwhfm", 0x30220000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* macwhfm<.f> 0,b,c 00110bbb00100010FBBBCCCCCC111110.  */
{ "macwhfm", 0x3022003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* macwhfm<.f><.cc> b,b,c 00110bbb11100010FBBBCCCCCC0QQQQQ.  */
{ "macwhfm", 0x30E20000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macwhfm<.f> a,b,u6 00110bbb01100010FBBBuuuuuuAAAAAA.  */
{ "macwhfm", 0x30620000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macwhfm<.f> 0,b,u6 00110bbb01100010FBBBuuuuuu111110.  */
{ "macwhfm", 0x3062003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* macwhfm<.f><.cc> b,b,u6 00110bbb11100010FBBBuuuuuu1QQQQQ.  */
{ "macwhfm", 0x30E20020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macwhfm<.f> b,b,s12 00110bbb10100010FBBBssssssSSSSSS.  */
{ "macwhfm", 0x30A20000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macwhfm<.f> a,limm,c 0011011000100010F111CCCCCCAAAAAA.  */
{ "macwhfm", 0x36227000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* macwhfm<.f> a,b,limm 00110bbb00100010FBBB111110AAAAAA.  */
{ "macwhfm", 0x30220F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* macwhfm<.f> 0,limm,c 0011011001100010F111CCCCCC111110.  */
{ "macwhfm", 0x3662703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* macwhfm<.f> 0,b,limm 00110bbb00100010FBBB111110111110.  */
{ "macwhfm", 0x30220FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* macwhfm<.f><.cc> b,b,limm 00110bbb11100010FBBB1111100QQQQQ.  */
{ "macwhfm", 0x30E20F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macwhfm<.f><.cc> 0,limm,c 0011011011100010F111CCCCCC0QQQQQ.  */
{ "macwhfm", 0x36E27000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macwhfm<.f> a,limm,u6 0011011001100010F111uuuuuuAAAAAA.  */
{ "macwhfm", 0x36627000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macwhfm<.f> 0,limm,u6 0011011001100010F111uuuuuu111110.  */
{ "macwhfm", 0x3662703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macwhfm<.f><.cc> 0,limm,u6 0011011011100010F111uuuuuu1QQQQQ.  */
{ "macwhfm", 0x36E27020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macwhfm<.f> 0,limm,s12 0011011010100010F111ssssssSSSSSS.  */
{ "macwhfm", 0x36A27000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macwhfm<.f> a,limm,limm 0011011000100010F111111110AAAAAA.  */
{ "macwhfm", 0x36227F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macwhfm<.f> 0,limm,limm 0011011000100010F111111110111110.  */
{ "macwhfm", 0x36227FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* macwhfm<.f><.cc> 0,limm,limm 0011011011100010F1111111100QQQQQ.  */
{ "macwhfm", 0x36E27F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macwhfmr<.f> a,b,c 00110bbb00100011FBBBCCCCCCAAAAAA.  */
{ "macwhfmr", 0x30230000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* macwhfmr<.f> 0,b,c 00110bbb00100011FBBBCCCCCC111110.  */
{ "macwhfmr", 0x3023003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* macwhfmr<.f><.cc> b,b,c 00110bbb11100011FBBBCCCCCC0QQQQQ.  */
{ "macwhfmr", 0x30E30000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macwhfmr<.f> a,b,u6 00110bbb01100011FBBBuuuuuuAAAAAA.  */
{ "macwhfmr", 0x30630000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macwhfmr<.f> 0,b,u6 00110bbb01100011FBBBuuuuuu111110.  */
{ "macwhfmr", 0x3063003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* macwhfmr<.f><.cc> b,b,u6 00110bbb11100011FBBBuuuuuu1QQQQQ.  */
{ "macwhfmr", 0x30E30020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macwhfmr<.f> b,b,s12 00110bbb10100011FBBBssssssSSSSSS.  */
{ "macwhfmr", 0x30A30000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macwhfmr<.f> a,limm,c 0011011000100011F111CCCCCCAAAAAA.  */
{ "macwhfmr", 0x36237000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* macwhfmr<.f> a,b,limm 00110bbb00100011FBBB111110AAAAAA.  */
{ "macwhfmr", 0x30230F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* macwhfmr<.f> 0,limm,c 0011011001100011F111CCCCCC111110.  */
{ "macwhfmr", 0x3663703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* macwhfmr<.f> 0,b,limm 00110bbb00100011FBBB111110111110.  */
{ "macwhfmr", 0x30230FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* macwhfmr<.f><.cc> b,b,limm 00110bbb11100011FBBB1111100QQQQQ.  */
{ "macwhfmr", 0x30E30F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macwhfmr<.f><.cc> 0,limm,c 0011011011100011F111CCCCCC0QQQQQ.  */
{ "macwhfmr", 0x36E37000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macwhfmr<.f> a,limm,u6 0011011001100011F111uuuuuuAAAAAA.  */
{ "macwhfmr", 0x36637000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macwhfmr<.f> 0,limm,u6 0011011001100011F111uuuuuu111110.  */
{ "macwhfmr", 0x3663703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macwhfmr<.f><.cc> 0,limm,u6 0011011011100011F111uuuuuu1QQQQQ.  */
{ "macwhfmr", 0x36E37020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macwhfmr<.f> 0,limm,s12 0011011010100011F111ssssssSSSSSS.  */
{ "macwhfmr", 0x36A37000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macwhfmr<.f> a,limm,limm 0011011000100011F111111110AAAAAA.  */
{ "macwhfmr", 0x36237F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macwhfmr<.f> 0,limm,limm 0011011000100011F111111110111110.  */
{ "macwhfmr", 0x36237FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* macwhfmr<.f><.cc> 0,limm,limm 0011011011100011F1111111100QQQQQ.  */
{ "macwhfmr", 0x36E37F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macwhkl<.f> a,b,c 00110bbb00101000FBBBCCCCCCAAAAAA.  */
{ "macwhkl", 0x30280000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* macwhkl<.f> 0,b,c 00110bbb00101000FBBBCCCCCC111110.  */
{ "macwhkl", 0x3028003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* macwhkl<.f><.cc> b,b,c 00110bbb11101000FBBBCCCCCC0QQQQQ.  */
{ "macwhkl", 0x30E80000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macwhkl<.f> a,b,u6 00110bbb01101000FBBBuuuuuuAAAAAA.  */
{ "macwhkl", 0x30680000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macwhkl<.f> 0,b,u6 00110bbb01101000FBBBuuuuuu111110.  */
{ "macwhkl", 0x3068003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* macwhkl<.f><.cc> b,b,u6 00110bbb11101000FBBBuuuuuu1QQQQQ.  */
{ "macwhkl", 0x30E80020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macwhkl<.f> b,b,s12 00110bbb10101000FBBBssssssSSSSSS.  */
{ "macwhkl", 0x30A80000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macwhkl<.f> a,limm,c 0011011000101000F111CCCCCCAAAAAA.  */
{ "macwhkl", 0x36287000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* macwhkl<.f> a,b,limm 00110bbb00101000FBBB111110AAAAAA.  */
{ "macwhkl", 0x30280F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* macwhkl<.f> 0,limm,c 0011011001101000F111CCCCCC111110.  */
{ "macwhkl", 0x3668703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* macwhkl<.f> 0,b,limm 00110bbb00101000FBBB111110111110.  */
{ "macwhkl", 0x30280FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* macwhkl<.f><.cc> b,b,limm 00110bbb11101000FBBB1111100QQQQQ.  */
{ "macwhkl", 0x30E80F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macwhkl<.f><.cc> 0,limm,c 0011011011101000F111CCCCCC0QQQQQ.  */
{ "macwhkl", 0x36E87000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macwhkl<.f> a,limm,u6 0011011001101000F111uuuuuuAAAAAA.  */
{ "macwhkl", 0x36687000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macwhkl<.f> 0,limm,u6 0011011001101000F111uuuuuu111110.  */
{ "macwhkl", 0x3668703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macwhkl<.f><.cc> 0,limm,u6 0011011011101000F111uuuuuu1QQQQQ.  */
{ "macwhkl", 0x36E87020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macwhkl<.f> 0,limm,s12 0011011010101000F111ssssssSSSSSS.  */
{ "macwhkl", 0x36A87000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macwhkl<.f> a,limm,limm 0011011000101000F111111110AAAAAA.  */
{ "macwhkl", 0x36287F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macwhkl<.f> 0,limm,limm 0011011000101000F111111110111110.  */
{ "macwhkl", 0x36287FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* macwhkl<.f><.cc> 0,limm,limm 0011011011101000F1111111100QQQQQ.  */
{ "macwhkl", 0x36E87F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macwhkul<.f> a,b,c 00110bbb00101001FBBBCCCCCCAAAAAA.  */
{ "macwhkul", 0x30290000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* macwhkul<.f> 0,b,c 00110bbb00101001FBBBCCCCCC111110.  */
{ "macwhkul", 0x3029003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* macwhkul<.f><.cc> b,b,c 00110bbb11101001FBBBCCCCCC0QQQQQ.  */
{ "macwhkul", 0x30E90000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macwhkul<.f> a,b,u6 00110bbb01101001FBBBuuuuuuAAAAAA.  */
{ "macwhkul", 0x30690000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macwhkul<.f> 0,b,u6 00110bbb01101001FBBBuuuuuu111110.  */
{ "macwhkul", 0x3069003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* macwhkul<.f><.cc> b,b,u6 00110bbb11101001FBBBuuuuuu1QQQQQ.  */
{ "macwhkul", 0x30E90020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macwhkul<.f> b,b,s12 00110bbb10101001FBBBssssssSSSSSS.  */
{ "macwhkul", 0x30A90000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macwhkul<.f> a,limm,c 0011011000101001F111CCCCCCAAAAAA.  */
{ "macwhkul", 0x36297000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* macwhkul<.f> a,b,limm 00110bbb00101001FBBB111110AAAAAA.  */
{ "macwhkul", 0x30290F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* macwhkul<.f> 0,limm,c 0011011001101001F111CCCCCC111110.  */
{ "macwhkul", 0x3669703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* macwhkul<.f> 0,b,limm 00110bbb00101001FBBB111110111110.  */
{ "macwhkul", 0x30290FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* macwhkul<.f><.cc> b,b,limm 00110bbb11101001FBBB1111100QQQQQ.  */
{ "macwhkul", 0x30E90F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macwhkul<.f><.cc> 0,limm,c 0011011011101001F111CCCCCC0QQQQQ.  */
{ "macwhkul", 0x36E97000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macwhkul<.f> a,limm,u6 0011011001101001F111uuuuuuAAAAAA.  */
{ "macwhkul", 0x36697000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macwhkul<.f> 0,limm,u6 0011011001101001F111uuuuuu111110.  */
{ "macwhkul", 0x3669703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macwhkul<.f><.cc> 0,limm,u6 0011011011101001F111uuuuuu1QQQQQ.  */
{ "macwhkul", 0x36E97020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macwhkul<.f> 0,limm,s12 0011011010101001F111ssssssSSSSSS.  */
{ "macwhkul", 0x36A97000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macwhkul<.f> a,limm,limm 0011011000101001F111111110AAAAAA.  */
{ "macwhkul", 0x36297F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macwhkul<.f> 0,limm,limm 0011011000101001F111111110111110.  */
{ "macwhkul", 0x36297FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* macwhkul<.f><.cc> 0,limm,limm 0011011011101001F1111111100QQQQQ.  */
{ "macwhkul", 0x36E97F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macwhl<.f> a,b,c 00110bbb00011101FBBBCCCCCCAAAAAA.  */
{ "macwhl", 0x301D0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* macwhl<.f> 0,b,c 00110bbb00011101FBBBCCCCCC111110.  */
{ "macwhl", 0x301D003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* macwhl<.f><.cc> b,b,c 00110bbb11011101FBBBCCCCCC0QQQQQ.  */
{ "macwhl", 0x30DD0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macwhl<.f> a,b,u6 00110bbb01011101FBBBuuuuuuAAAAAA.  */
{ "macwhl", 0x305D0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macwhl<.f> 0,b,u6 00110bbb01011101FBBBuuuuuu111110.  */
{ "macwhl", 0x305D003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* macwhl<.f><.cc> b,b,u6 00110bbb11011101FBBBuuuuuu1QQQQQ.  */
{ "macwhl", 0x30DD0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macwhl<.f> b,b,s12 00110bbb10011101FBBBssssssSSSSSS.  */
{ "macwhl", 0x309D0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macwhl<.f> a,limm,c 0011011000011101F111CCCCCCAAAAAA.  */
{ "macwhl", 0x361D7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* macwhl<.f> a,b,limm 00110bbb00011101FBBB111110AAAAAA.  */
{ "macwhl", 0x301D0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* macwhl<.f> 0,limm,c 0011011000011101F111CCCCCC111110.  */
{ "macwhl", 0x361D703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* macwhl<.f> 0,b,limm 00110bbb00011101FBBB111110111110.  */
{ "macwhl", 0x301D0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* macwhl<.f><.cc> b,b,limm 00110bbb11011101FBBB1111100QQQQQ.  */
{ "macwhl", 0x30DD0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macwhl<.f><.cc> 0,limm,c 0011011011011101F111CCCCCC0QQQQQ.  */
{ "macwhl", 0x36DD7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macwhl<.f> a,limm,u6 0011011001011101F111uuuuuuAAAAAA.  */
{ "macwhl", 0x365D7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macwhl<.f> 0,limm,u6 0011011001011101F111uuuuuu111110.  */
{ "macwhl", 0x365D703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macwhl<.f><.cc> 0,limm,u6 0011011011011101F111uuuuuu1QQQQQ.  */
{ "macwhl", 0x36DD7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macwhl<.f> 0,limm,s12 0011011010011101F111ssssssSSSSSS.  */
{ "macwhl", 0x369D7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macwhl<.f> a,limm,limm 0011011000011101F111111110AAAAAA.  */
{ "macwhl", 0x361D7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macwhl<.f> 0,limm,limm 0011011000011101F111111110111110.  */
{ "macwhl", 0x361D7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* macwhl<.f><.cc> 0,limm,limm 0011011011011101F1111111100QQQQQ.  */
{ "macwhl", 0x36DD7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macwhul<.f> a,b,c 00110bbb00011111FBBBCCCCCCAAAAAA.  */
{ "macwhul", 0x301F0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* macwhul<.f> 0,b,c 00110bbb00011111FBBBCCCCCC111110.  */
{ "macwhul", 0x301F003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* macwhul<.f><.cc> b,b,c 00110bbb11011111FBBBCCCCCC0QQQQQ.  */
{ "macwhul", 0x30DF0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macwhul<.f> a,b,u6 00110bbb01011111FBBBuuuuuuAAAAAA.  */
{ "macwhul", 0x305F0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macwhul<.f> 0,b,u6 00110bbb01011111FBBBuuuuuu111110.  */
{ "macwhul", 0x305F003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* macwhul<.f><.cc> b,b,u6 00110bbb11011111FBBBuuuuuu1QQQQQ.  */
{ "macwhul", 0x30DF0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macwhul<.f> b,b,s12 00110bbb10011111FBBBssssssSSSSSS.  */
{ "macwhul", 0x309F0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macwhul<.f> a,limm,c 0011011000011111F111CCCCCCAAAAAA.  */
{ "macwhul", 0x361F7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* macwhul<.f> a,b,limm 00110bbb00011111FBBB111110AAAAAA.  */
{ "macwhul", 0x301F0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* macwhul<.f> 0,limm,c 0011011000011111F111CCCCCC111110.  */
{ "macwhul", 0x361F703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* macwhul<.f> 0,b,limm 00110bbb00011111FBBB111110111110.  */
{ "macwhul", 0x301F0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* macwhul<.f><.cc> b,b,limm 00110bbb11011111FBBB1111100QQQQQ.  */
{ "macwhul", 0x30DF0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macwhul<.f><.cc> 0,limm,c 0011011011011111F111CCCCCC0QQQQQ.  */
{ "macwhul", 0x36DF7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macwhul<.f> a,limm,u6 0011011001011111F111uuuuuuAAAAAA.  */
{ "macwhul", 0x365F7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macwhul<.f> 0,limm,u6 0011011001011111F111uuuuuu111110.  */
{ "macwhul", 0x365F703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macwhul<.f><.cc> 0,limm,u6 0011011011011111F111uuuuuu1QQQQQ.  */
{ "macwhul", 0x36DF7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macwhul<.f> 0,limm,s12 0011011010011111F111ssssssSSSSSS.  */
{ "macwhul", 0x369F7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macwhul<.f> a,limm,limm 0011011000011111F111111110AAAAAA.  */
{ "macwhul", 0x361F7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macwhul<.f> 0,limm,limm 0011011000011111F111111110111110.  */
{ "macwhul", 0x361F7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* macwhul<.f><.cc> 0,limm,limm 0011011011011111F1111111100QQQQQ.  */
{ "macwhul", 0x36DF7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* max<.f> a,b,c 00100bbb00001000FBBBCCCCCCAAAAAA.  */
{ "max", 0x20080000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* max<.f> 0,b,c 00100bbb00001000FBBBCCCCCC111110.  */
{ "max", 0x2008003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* max<.f><.cc> b,b,c 00100bbb11001000FBBBCCCCCC0QQQQQ.  */
{ "max", 0x20C80000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* max<.f> a,b,u6 00100bbb01001000FBBBuuuuuuAAAAAA.  */
{ "max", 0x20480000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* max<.f> 0,b,u6 00100bbb01001000FBBBuuuuuu111110.  */
{ "max", 0x2048003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* max<.f><.cc> b,b,u6 00100bbb11001000FBBBuuuuuu1QQQQQ.  */
{ "max", 0x20C80020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* max<.f> b,b,s12 00100bbb10001000FBBBssssssSSSSSS.  */
{ "max", 0x20880000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* max<.f> a,limm,c 0010011000001000F111CCCCCCAAAAAA.  */
{ "max", 0x26087000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* max<.f> a,b,limm 00100bbb00001000FBBB111110AAAAAA.  */
{ "max", 0x20080F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* max<.f> 0,limm,c 0010011000001000F111CCCCCC111110.  */
{ "max", 0x2608703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* max<.f> 0,b,limm 00100bbb00001000FBBB111110111110.  */
{ "max", 0x20080FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* max<.f><.cc> b,b,limm 00100bbb11001000FBBB1111100QQQQQ.  */
{ "max", 0x20C80F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* max<.f><.cc> 0,limm,c 0010011011001000F111CCCCCC0QQQQQ.  */
{ "max", 0x26C87000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* max<.f> a,limm,u6 0010011001001000F111uuuuuuAAAAAA.  */
{ "max", 0x26487000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* max<.f> 0,limm,u6 0010011001001000F111uuuuuu111110.  */
{ "max", 0x2648703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* max<.f><.cc> 0,limm,u6 0010011011001000F111uuuuuu1QQQQQ.  */
{ "max", 0x26C87020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* max<.f> 0,limm,s12 0010011010001000F111ssssssSSSSSS.  */
{ "max", 0x26887000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* max<.f> a,limm,limm 0010011000001000F111111110AAAAAA.  */
{ "max", 0x26087F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* max<.f> 0,limm,limm 0010011000001000F111111110111110.  */
{ "max", 0x26087FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* max<.f><.cc> 0,limm,limm 0010011011001000F1111111100QQQQQ.  */
{ "max", 0x26C87F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* maxabssdw<.f> a,b,c 00101bbb00101011FBBBCCCCCCAAAAAA.  */
{ "maxabssdw", 0x282B0000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* maxabssdw<.f> 0,b,c 00101bbb00101011FBBBCCCCCC111110.  */
{ "maxabssdw", 0x282B003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* maxabssdw<.f><.cc> b,b,c 00101bbb11101011FBBBCCCCCC0QQQQQ.  */
{ "maxabssdw", 0x28EB0000, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* maxabssdw<.f> a,b,u6 00101bbb01101011FBBBuuuuuuAAAAAA.  */
{ "maxabssdw", 0x286B0000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* maxabssdw<.f> 0,b,u6 00101bbb01101011FBBBuuuuuu111110.  */
{ "maxabssdw", 0x286B003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* maxabssdw<.f><.cc> b,b,u6 00101bbb11101011FBBBuuuuuu1QQQQQ.  */
{ "maxabssdw", 0x28EB0020, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* maxabssdw<.f> b,b,s12 00101bbb10101011FBBBssssssSSSSSS.  */
{ "maxabssdw", 0x28AB0000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* maxabssdw<.f> a,limm,c 0010111000101011F111CCCCCCAAAAAA.  */
{ "maxabssdw", 0x2E2B7000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* maxabssdw<.f> a,b,limm 00101bbb00101011FBBB111110AAAAAA.  */
{ "maxabssdw", 0x282B0F80, 0xF8FF0FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* maxabssdw<.f> 0,limm,c 0010111000101011F111CCCCCC111110.  */
{ "maxabssdw", 0x2E2B703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* maxabssdw<.f> 0,b,limm 00101bbb00101011FBBB111110111110.  */
{ "maxabssdw", 0x282B0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* maxabssdw<.f><.cc> 0,limm,c 0010111011101011F111CCCCCC0QQQQQ.  */
{ "maxabssdw", 0x2EEB7000, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* maxabssdw<.f><.cc> b,b,limm 00101bbb11101011FBBB1111100QQQQQ.  */
{ "maxabssdw", 0x28EB0F80, 0xF8FF0FE0, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* maxabssdw<.f> a,limm,u6 0010111001101011F111uuuuuuAAAAAA.  */
{ "maxabssdw", 0x2E6B7000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* maxabssdw<.f> 0,limm,u6 0010111001101011F111uuuuuu111110.  */
{ "maxabssdw", 0x2E6B703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* maxabssdw<.f><.cc> 0,limm,u6 0010111011101011F111uuuuuu1QQQQQ.  */
{ "maxabssdw", 0x2EEB7020, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* maxabssdw<.f> 0,limm,s12 0010111010101011F111ssssssSSSSSS.  */
{ "maxabssdw", 0x2EAB7000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* maxabssdw<.f> a,limm,limm 0010111000101011F111111110AAAAAA.  */
{ "maxabssdw", 0x2E2B7F80, 0xFFFF7FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* maxabssdw<.f> 0,limm,limm 0010111000101011F111111110111110.  */
{ "maxabssdw", 0x2E2B7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* maxabssdw<.f><.cc> 0,limm,limm 0010111011101011F1111111100QQQQQ.  */
{ "maxabssdw", 0x2EEB7F80, 0xFFFF7FE0, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* maxidl<.f> a,b,c 00101bbb00001111FBBBCCCCCCAAAAAA.  */
{ "maxidl", 0x280F0000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* maxidl<.f> 0,b,c 00101bbb00001111FBBBCCCCCC111110.  */
{ "maxidl", 0x280F003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* maxidl<.f><.cc> b,b,c 00101bbb11001111FBBBCCCCCC0QQQQQ.  */
{ "maxidl", 0x28CF0000, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* maxidl<.f> a,b,u6 00101bbb01001111FBBBuuuuuuAAAAAA.  */
{ "maxidl", 0x284F0000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* maxidl<.f> 0,b,u6 00101bbb01001111FBBBuuuuuu111110.  */
{ "maxidl", 0x284F003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* maxidl<.f><.cc> b,b,u6 00101bbb11001111FBBBuuuuuu1QQQQQ.  */
{ "maxidl", 0x28CF0020, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* maxidl<.f> b,b,s12 00101bbb10001111FBBBssssssSSSSSS.  */
{ "maxidl", 0x288F0000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* maxidl<.f> a,limm,c 0010111000001111F111CCCCCCAAAAAA.  */
{ "maxidl", 0x2E0F7000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* maxidl<.f> a,b,limm 00101bbb00001111FBBB111110AAAAAA.  */
{ "maxidl", 0x280F0F80, 0xF8FF0FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* maxidl<.f> 0,limm,c 0010111000001111F111CCCCCC111110.  */
{ "maxidl", 0x2E0F703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* maxidl<.f> 0,b,limm 00101bbb00001111FBBB111110111110.  */
{ "maxidl", 0x280F0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* maxidl<.f><.cc> 0,limm,c 0010111011001111F111CCCCCC0QQQQQ.  */
{ "maxidl", 0x2ECF7000, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* maxidl<.f><.cc> b,b,limm 00101bbb11001111FBBB1111100QQQQQ.  */
{ "maxidl", 0x28CF0F80, 0xF8FF0FE0, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* maxidl<.f> a,limm,u6 0010111001001111F111uuuuuuAAAAAA.  */
{ "maxidl", 0x2E4F7000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* maxidl<.f> 0,limm,u6 0010111001001111F111uuuuuu111110.  */
{ "maxidl", 0x2E4F703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* maxidl<.f><.cc> 0,limm,u6 0010111011001111F111uuuuuu1QQQQQ.  */
{ "maxidl", 0x2ECF7020, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* maxidl<.f> 0,limm,s12 0010111010001111F111ssssssSSSSSS.  */
{ "maxidl", 0x2E8F7000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* maxidl<.f> a,limm,limm 0010111000001111F111111110AAAAAA.  */
{ "maxidl", 0x2E0F7F80, 0xFFFF7FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* maxidl<.f> 0,limm,limm 0010111000001111F111111110111110.  */
{ "maxidl", 0x2E0F7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* maxidl<.f><.cc> 0,limm,limm 0010111011001111F1111111100QQQQQ.  */
{ "maxidl", 0x2ECF7F80, 0xFFFF7FE0, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* min<.f> a,b,c 00100bbb00001001FBBBCCCCCCAAAAAA.  */
{ "min", 0x20090000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* min<.f> 0,b,c 00100bbb00001001FBBBCCCCCC111110.  */
{ "min", 0x2009003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* min<.f><.cc> b,b,c 00100bbb11001001FBBBCCCCCC0QQQQQ.  */
{ "min", 0x20C90000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* min<.f> a,b,u6 00100bbb01001001FBBBuuuuuuAAAAAA.  */
{ "min", 0x20490000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* min<.f> 0,b,u6 00100bbb01001001FBBBuuuuuu111110.  */
{ "min", 0x2049003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* min<.f><.cc> b,b,u6 00100bbb11001001FBBBuuuuuu1QQQQQ.  */
{ "min", 0x20C90020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* min<.f> b,b,s12 00100bbb10001001FBBBssssssSSSSSS.  */
{ "min", 0x20890000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* min<.f> a,limm,c 0010011000001001F111CCCCCCAAAAAA.  */
{ "min", 0x26097000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* min<.f> a,b,limm 00100bbb00001001FBBB111110AAAAAA.  */
{ "min", 0x20090F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* min<.f> 0,limm,c 0010011000001001F111CCCCCC111110.  */
{ "min", 0x2609703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* min<.f> 0,b,limm 00100bbb00001001FBBB111110111110.  */
{ "min", 0x20090FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* min<.f><.cc> b,b,limm 00100bbb11001001FBBB1111100QQQQQ.  */
{ "min", 0x20C90F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* min<.f><.cc> 0,limm,c 0010011011001001F111CCCCCC0QQQQQ.  */
{ "min", 0x26C97000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* min<.f> a,limm,u6 0010011001001001F111uuuuuuAAAAAA.  */
{ "min", 0x26497000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* min<.f> 0,limm,u6 0010011001001001F111uuuuuu111110.  */
{ "min", 0x2649703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* min<.f><.cc> 0,limm,u6 0010011011001001F111uuuuuu1QQQQQ.  */
{ "min", 0x26C97020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* min<.f> 0,limm,s12 0010011010001001F111ssssssSSSSSS.  */
{ "min", 0x26897000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* min<.f> a,limm,limm 0010011000001001F111111110AAAAAA.  */
{ "min", 0x26097F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* min<.f> 0,limm,limm 0010011000001001F111111110111110.  */
{ "min", 0x26097FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* min<.f><.cc> 0,limm,limm 0010011011001001F1111111100QQQQQ.  */
{ "min", 0x26C97F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* minidl<.f> a,b,c 00101bbb00001001FBBBCCCCCCAAAAAA.  */
{ "minidl", 0x28090000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* minidl<.f> 0,b,c 00101bbb00001001FBBBCCCCCC111110.  */
{ "minidl", 0x2809003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* minidl<.f><.cc> b,b,c 00101bbb11001001FBBBCCCCCC0QQQQQ.  */
{ "minidl", 0x28C90000, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* minidl<.f> a,b,u6 00101bbb01001001FBBBuuuuuuAAAAAA.  */
{ "minidl", 0x28490000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* minidl<.f> 0,b,u6 00101bbb01001001FBBBuuuuuu111110.  */
{ "minidl", 0x2849003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* minidl<.f><.cc> b,b,u6 00101bbb11001001FBBBuuuuuu1QQQQQ.  */
{ "minidl", 0x28C90020, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* minidl<.f> b,b,s12 00101bbb10001001FBBBssssssSSSSSS.  */
{ "minidl", 0x28890000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* minidl<.f> a,limm,c 0010111000001001F111CCCCCCAAAAAA.  */
{ "minidl", 0x2E097000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* minidl<.f> a,b,limm 00101bbb00001001FBBB111110AAAAAA.  */
{ "minidl", 0x28090F80, 0xF8FF0FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* minidl<.f> 0,limm,c 0010111000001001F111CCCCCC111110.  */
{ "minidl", 0x2E09703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* minidl<.f> 0,b,limm 00101bbb00001001FBBB111110111110.  */
{ "minidl", 0x28090FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* minidl<.f><.cc> 0,limm,c 0010111011001001F111CCCCCC0QQQQQ.  */
{ "minidl", 0x2EC97000, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* minidl<.f><.cc> b,b,limm 00101bbb11001001FBBB1111100QQQQQ.  */
{ "minidl", 0x28C90F80, 0xF8FF0FE0, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* minidl<.f> a,limm,u6 0010111001001001F111uuuuuuAAAAAA.  */
{ "minidl", 0x2E497000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* minidl<.f> 0,limm,u6 0010111001001001F111uuuuuu111110.  */
{ "minidl", 0x2E49703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* minidl<.f><.cc> 0,limm,u6 0010111011001001F111uuuuuu1QQQQQ.  */
{ "minidl", 0x2EC97020, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* minidl<.f> 0,limm,s12 0010111010001001F111ssssssSSSSSS.  */
{ "minidl", 0x2E897000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* minidl<.f> a,limm,limm 0010111000001001F111111110AAAAAA.  */
{ "minidl", 0x2E097F80, 0xFFFF7FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* minidl<.f> 0,limm,limm 0010111000001001F111111110111110.  */
{ "minidl", 0x2E097FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* minidl<.f><.cc> 0,limm,limm 0010111011001001F1111111100QQQQQ.  */
{ "minidl", 0x2EC97F80, 0xFFFF7FE0, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* modapp b,c 00101bbb001011110BBBCCCCCC111110.  */
{ "modapp", 0x282F003E, 0xF8FF803F, ARC_OPCODE_ARCv2EM, XY, NONE, { RB, RC }, { 0 }},

/* modapp 0,c 00101110001011110111CCCCCC111110.  */
{ "modapp", 0x2E2F703E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM, XY, NONE, { ZA, RC }, { 0 }},

/* modapp b,u6 00101bbb011011110BBBuuuuuu111110.  */
{ "modapp", 0x286F003E, 0xF8FF803F, ARC_OPCODE_ARCv2EM, XY, NONE, { RB, UIMM6_20 }, { 0 }},

/* modapp 0,u6 00101110011011110111uuuuuu111110.  */
{ "modapp", 0x2E6F703E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM, XY, NONE, { ZA, UIMM6_20 }, { 0 }},

/* modapp b,limm 00101bbb001011110BBB111110111110.  */
{ "modapp", 0x282F0FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM, XY, NONE, { RB, LIMM }, { 0 }},

/* modapp 0,limm 00101110001011110111111110111110.  */
{ "modapp", 0x2E2F7FBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM, XY, NONE, { ZA, LIMM }, { 0 }},

/* modif c 00101101001011110000CCCCCC111111.  */
{ "modif", 0x2D2F003F, 0xFFFFF03F, ARC_OPCODE_ARCv2EM, XY, NONE, { RC }, { 0 }},

/* modif u6 00101101011011110000uuuuuu111111.  */
{ "modif", 0x2D6F003F, 0xFFFFF03F, ARC_OPCODE_ARCv2EM, XY, NONE, { UIMM6_20 }, { 0 }},

/* nop  00100110010010100111000000000000.  */
{ "nop", 0x264A7000, 0xFFFFFFFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { 0 }, { 0 }},

/* mov<.f> b,c 00100bbb00001010FBBBCCCCCCRRRRRR.  */
{ "mov", 0x200A0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { RB, RC }, { C_F }},

/* mov<.f> 0,c 0010011000001010F111CCCCCCRRRRRR.  */
{ "mov", 0x260A7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { ZA, RC }, { C_F }},

/* mov<.f><.cc> b,c 00100bbb11001010FBBBCCCCCC0QQQQQ.  */
{ "mov", 0x20CA0000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { RB, RC }, { C_F, C_CC }},

/* mov<.f><.cc> 0,c 0010011011001010F111CCCCCC0QQQQQ.  */
{ "mov", 0x26CA7000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { ZA, RC }, { C_F, C_CC }},

/* mov<.f> b,u6 00100bbb01001010FBBBuuuuuuRRRRRR.  */
{ "mov", 0x204A0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { RB, UIMM6_20 }, { C_F }},

/* mov<.f> 0,u6 0010011001001010F111uuuuuuRRRRRR.  */
{ "mov", 0x264A7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { ZA, UIMM6_20 }, { C_F }},

/* mov<.f><.cc> b,u6 00100bbb11001010FBBBuuuuuu1QQQQQ.  */
{ "mov", 0x20CA0020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { RB, UIMM6_20 }, { C_F, C_CC }},

/* mov<.f><.cc> 0,u6 0010011011001010F111uuuuuu1QQQQQ.  */
{ "mov", 0x26CA7020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { ZA, UIMM6_20 }, { C_F, C_CC }},

/* mov<.f> b,s12 00100bbb10001010FBBBssssssSSSSSS.  */
{ "mov", 0x208A0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { RB, SIMM12_20 }, { C_F }},

/* mov<.f> 0,s12 0010011010001010F111ssssssSSSSSS.  */
{ "mov", 0x268A7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { ZA, SIMM12_20 }, { C_F }},

/* mov<.f> b,limm 00100bbb00001010FBBB111110RRRRRR.  */
{ "mov", 0x200A0F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { RB, LIMM }, { C_F }},

/* mov<.f> 0,limm 0010011000001010F111111110RRRRRR.  */
{ "mov", 0x260A7F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { ZA, LIMM }, { C_F }},

/* mov<.f><.cc> b,limm 00100bbb11001010FBBB1111100QQQQQ.  */
{ "mov", 0x20CA0F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { RB, LIMM }, { C_F, C_CC }},

/* mov<.f><.cc> 0,limm 0010011011001010F1111111100QQQQQ.  */
{ "mov", 0x26CA7F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { ZA, LIMM }, { C_F, C_CC }},

/* mov_s b,h 01110bbbhhh01HHH.  */
{ "mov_s", 0x00007008, 0x0000F818, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, MOVE, NONE, { RB_S, R6H }, { 0 }},

/* mov_s b,h 01110bbbhhh010HH.  */
{ "mov_s", 0x00007008, 0x0000F81C, 0, MOVE, NONE, { RB_S, RH_S }, { 0 }},

/* mov_s h,b 01110bbbhhh11HHH.  */
{ "mov_s", 0x00007018, 0x0000F818, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, MOVE, NONE, { R6H, RB_S }, { 0 }},

/* mov_s h,b 01110bbbhhh110HH.  */
{ "mov_s", 0x00007018, 0x0000F81C, 0, MOVE, NONE, { RH_S, RB_S }, { 0 }},

/* mov_s 0,b 01110bbb1101111H.  */
{ "mov_s", 0x000070DE, 0x0000F8FE, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, MOVE, NONE, { ZA_S, RB_S }, { 0 }},

/* mov_s 0,b 01110bbb11011011.  */
{ "mov_s", 0x000070DB, 0x0000F8FF, 0, MOVE, NONE, { ZA_S, RB_S }, { 0 }},

/* mov_s g,h 01000ggghhhGG0HH.  */
{ "mov_s", 0x00004000, 0x0000F804, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { G_S, RH_S }, { 0 }},

/* mov_s 0,h 01000110hhh110HH.  */
{ "mov_s", 0x00004618, 0x0000FF1C, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { ZA_S, RH_S }, { 0 }},

/* mov_s h,s3 01110ssshhh011HH.  */
{ "mov_s", 0x0000700C, 0x0000F81C, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { RH_S, SIMM3_5_S }, { 0 }},

/* mov_s 0,s3 01110sss11001111.  */
{ "mov_s", 0x000070CF, 0x0000F8FF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { ZA_S, SIMM3_5_S }, { 0 }},

/* mov_s b,u8 11011bbbuuuuuuuu.  */
{ "mov_s", 0x0000D800, 0x0000F800, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { RB_S, UIMM8_8_S }, { 0 }},

/* mov_s b,limm 01110bbb11001111.  */
{ "mov_s", 0x000070CF, 0x0000F8FF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, MOVE, NONE, { RB_S, LIMM_S }, { 0 }},

/* mov_s b,limm 01110bbb11001011.  */
{ "mov_s", 0x000070CB, 0x0000F8FF, 0, MOVE, NONE, { RB_S, LIMM_S }, { 0 }},

/* mov_s g,limm 01000ggg110GG011.  */
{ "mov_s", 0x000040C3, 0x0000F8E7, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { G_S, LIMM_S }, { 0 }},

/* mov_s 0,limm 0100011011011011.  */
{ "mov_s", 0x000046DB, 0x0000FFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { ZA_S, LIMM_S }, { 0 }},

/* mov_s.ne b,h 01110bbbhhh111HH.  */
{ "mov_s", 0x0000701C, 0x0000F81C, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { RB_S, RH_S }, { C_NE, C_CC_NE }},

/* mov_s.ne b,limm 01110bbb11011111.  */
{ "mov_s", 0x000070DF, 0x0000F8FF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MOVE, NONE, { RB_S, LIMM_S }, { C_NE, C_CC_NE }},

/* mpy<.f> a,b,c 00100bbb00011010FBBBCCCCCCAAAAAA.  */
{ "mpy", 0x201A0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, RB, RC }, { C_F }},

/* mpy<.f> 0,b,c 00100bbb00011010FBBBCCCCCC111110.  */
{ "mpy", 0x201A003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, RB, RC }, { C_F }},

/* mpy<.f><.cc> b,b,c 00100bbb11011010FBBBCCCCCC0QQQQQ.  */
{ "mpy", 0x20DA0000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpy<.f> a,b,u6 00100bbb01011010FBBBuuuuuuAAAAAA.  */
{ "mpy", 0x205A0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpy<.f> 0,b,u6 00100bbb01011010FBBBuuuuuu111110.  */
{ "mpy", 0x205A003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpy<.f><.cc> b,b,u6 00100bbb11011010FBBBuuuuuu1QQQQQ.  */
{ "mpy", 0x20DA0020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpy<.f> b,b,s12 00100bbb10011010FBBBssssssSSSSSS.  */
{ "mpy", 0x209A0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpy<.f> a,limm,c 0010011000011010F111CCCCCCAAAAAA.  */
{ "mpy", 0x261A7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, LIMM, RC }, { C_F }},

/* mpy<.f> a,b,limm 00100bbb00011010FBBB111110AAAAAA.  */
{ "mpy", 0x201A0F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, RB, LIMM }, { C_F }},

/* mpy<.f> 0,limm,c 0010011000011010F111CCCCCC111110.  */
{ "mpy", 0x261A703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, RC }, { C_F }},

/* mpy<.f> 0,b,limm 00100bbb00011010FBBB111110111110.  */
{ "mpy", 0x201A0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, RB, LIMM }, { C_F }},

/* mpy<.f><.cc> b,b,limm 00100bbb11011010FBBB1111100QQQQQ.  */
{ "mpy", 0x20DA0F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpy<.f><.cc> 0,limm,c 0010011011011010F111CCCCCC0QQQQQ.  */
{ "mpy", 0x26DA7000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpy<.f> a,limm,u6 0010011001011010F111uuuuuuAAAAAA.  */
{ "mpy", 0x265A7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpy<.f> 0,limm,u6 0010011001011010F111uuuuuu111110.  */
{ "mpy", 0x265A703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpy<.f><.cc> 0,limm,u6 0010011011011010F111uuuuuu1QQQQQ.  */
{ "mpy", 0x26DA7020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpy<.f> 0,limm,s12 0010011010011010F111ssssssSSSSSS.  */
{ "mpy", 0x269A7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpy<.f> a,limm,limm 0010011000011010F111111110AAAAAA.  */
{ "mpy", 0x261A7F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpy<.f> 0,limm,limm 0010011000011010F111111110111110.  */
{ "mpy", 0x261A7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpy<.f><.cc> 0,limm,limm 0010011011011010F1111111100QQQQQ.  */
{ "mpy", 0x26DA7F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpyd<.f> a,b,c 00101bbb00011000FBBBCCCCCCAAAAAA.  */
{ "mpyd", 0x28180000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, RB, RC }, { C_F }},

/* mpyd<.f> 0,b,c 00101bbb00011000FBBBCCCCCC111110.  */
{ "mpyd", 0x2818003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, RB, RC }, { C_F }},

/* mpyd<.f><.cc> b,b,c 00101bbb11011000FBBBCCCCCC0QQQQQ.  */
{ "mpyd", 0x28D80000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpyd<.f> a,b,u6 00101bbb01011000FBBBuuuuuuAAAAAA.  */
{ "mpyd", 0x28580000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpyd<.f> 0,b,u6 00101bbb01011000FBBBuuuuuu111110.  */
{ "mpyd", 0x2858003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpyd<.f><.cc> b,b,u6 00101bbb11011000FBBBuuuuuu1QQQQQ.  */
{ "mpyd", 0x28D80020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpyd<.f> b,b,s12 00101bbb10011000FBBBssssssSSSSSS.  */
{ "mpyd", 0x28980000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpyd<.f> a,limm,c 0010111000011000F111CCCCCCAAAAAA.  */
{ "mpyd", 0x2E187000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, LIMM, RC }, { C_F }},

/* mpyd<.f> a,b,limm 00101bbb00011000FBBB111110AAAAAA.  */
{ "mpyd", 0x28180F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, RB, LIMM }, { C_F }},

/* mpyd<.f> 0,limm,c 0010111000011000F111CCCCCC111110.  */
{ "mpyd", 0x2E18703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, RC }, { C_F }},

/* mpyd<.f> 0,b,limm 00101bbb00011000FBBB111110111110.  */
{ "mpyd", 0x28180FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, RB, LIMM }, { C_F }},

/* mpyd<.f><.cc> b,b,limm 00101bbb11011000FBBB1111100QQQQQ.  */
{ "mpyd", 0x28D80F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpyd<.f><.cc> 0,limm,c 0010111011011000F111CCCCCC0QQQQQ.  */
{ "mpyd", 0x2ED87000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpyd<.f> a,limm,u6 0010111001011000F111uuuuuuAAAAAA.  */
{ "mpyd", 0x2E587000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpyd<.f> 0,limm,u6 0010111001011000F111uuuuuu111110.  */
{ "mpyd", 0x2E58703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpyd<.f><.cc> 0,limm,u6 0010111011011000F111uuuuuu1QQQQQ.  */
{ "mpyd", 0x2ED87020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpyd<.f> 0,limm,s12 0010111010011000F111ssssssSSSSSS.  */
{ "mpyd", 0x2E987000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpyd<.f> a,limm,limm 0010111000011000F111111110AAAAAA.  */
{ "mpyd", 0x2E187F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpyd<.f> 0,limm,limm 0010111000011000F111111110111110.  */
{ "mpyd", 0x2E187FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpyd<.f><.cc> 0,limm,limm 0010111011011000F1111111100QQQQQ.  */
{ "mpyd", 0x2ED87F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpydf<.f> a,b,c 00110bbb00010010FBBBCCCCCCAAAAAA.  */
{ "mpydf", 0x30120000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mpydf<.f> 0,b,c 00110bbb00010010FBBBCCCCCC111110.  */
{ "mpydf", 0x3012003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { ZA, RB, RC }, { C_F }},

/* mpydf<.f><.cc> b,b,c 00110bbb11010010FBBBCCCCCC0QQQQQ.  */
{ "mpydf", 0x30D20000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpydf<.f> a,b,u6 00110bbb01010010FBBBuuuuuuAAAAAA.  */
{ "mpydf", 0x30520000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpydf<.f> 0,b,u6 00110bbb01010010FBBBuuuuuu111110.  */
{ "mpydf", 0x3052003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpydf<.f><.cc> b,b,u6 00110bbb11010010FBBBuuuuuu1QQQQQ.  */
{ "mpydf", 0x30D20020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpydf<.f> b,b,s12 00110bbb10010010FBBBssssssSSSSSS.  */
{ "mpydf", 0x30920000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpydf<.f> a,limm,c 0011011000010010F111CCCCCCAAAAAA.  */
{ "mpydf", 0x36127000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mpydf<.f> a,b,limm 00110bbb00010010FBBB111110AAAAAA.  */
{ "mpydf", 0x30120F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mpydf<.f> 0,limm,c 0011011000010010F111CCCCCC111110.  */
{ "mpydf", 0x3612703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { ZA, LIMM, RC }, { C_F }},

/* mpydf<.f> 0,b,limm 00110bbb00010010FBBB111110111110.  */
{ "mpydf", 0x30120FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { ZA, RB, LIMM }, { C_F }},

/* mpydf<.f><.cc> b,b,limm 00110bbb11010010FBBB1111100QQQQQ.  */
{ "mpydf", 0x30D20F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpydf<.f><.cc> 0,limm,c 0011011011010010F111CCCCCC0QQQQQ.  */
{ "mpydf", 0x36D27000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpydf<.f> a,limm,u6 0011011001010010F111uuuuuuAAAAAA.  */
{ "mpydf", 0x36527000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpydf<.f> 0,limm,u6 0011011001010010F111uuuuuu111110.  */
{ "mpydf", 0x3652703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpydf<.f><.cc> 0,limm,u6 0011011011010010F111uuuuuu1QQQQQ.  */
{ "mpydf", 0x36D27020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpydf<.f> 0,limm,s12 0011011010010010F111ssssssSSSSSS.  */
{ "mpydf", 0x36927000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpydf<.f> a,limm,limm 0011011000010010F111111110AAAAAA.  */
{ "mpydf", 0x36127F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpydf<.f> 0,limm,limm 0011011000010010F111111110111110.  */
{ "mpydf", 0x36127FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpydf<.f><.cc> 0,limm,limm 0011011011010010F1111111100QQQQQ.  */
{ "mpydf", 0x36D27F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpydu<.f> a,b,c 00101bbb00011001FBBBCCCCCCAAAAAA.  */
{ "mpydu", 0x28190000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, RB, RC }, { C_F }},

/* mpydu<.f> 0,b,c 00101bbb00011001FBBBCCCCCC111110.  */
{ "mpydu", 0x2819003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, RB, RC }, { C_F }},

/* mpydu<.f><.cc> b,b,c 00101bbb11011001FBBBCCCCCC0QQQQQ.  */
{ "mpydu", 0x28D90000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpydu<.f> a,b,u6 00101bbb01011001FBBBuuuuuuAAAAAA.  */
{ "mpydu", 0x28590000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpydu<.f> 0,b,u6 00101bbb01011001FBBBuuuuuu111110.  */
{ "mpydu", 0x2859003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpydu<.f><.cc> b,b,u6 00101bbb11011001FBBBuuuuuu1QQQQQ.  */
{ "mpydu", 0x28D90020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpydu<.f> b,b,s12 00101bbb10011001FBBBssssssSSSSSS.  */
{ "mpydu", 0x28990000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpydu<.f> a,limm,c 0010111000011001F111CCCCCCAAAAAA.  */
{ "mpydu", 0x2E197000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, LIMM, RC }, { C_F }},

/* mpydu<.f> a,b,limm 00101bbb00011001FBBB111110AAAAAA.  */
{ "mpydu", 0x28190F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, RB, LIMM }, { C_F }},

/* mpydu<.f> 0,limm,c 0010111000011001F111CCCCCC111110.  */
{ "mpydu", 0x2E19703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, RC }, { C_F }},

/* mpydu<.f> 0,b,limm 00101bbb00011001FBBB111110111110.  */
{ "mpydu", 0x28190FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, RB, LIMM }, { C_F }},

/* mpydu<.f><.cc> b,b,limm 00101bbb11011001FBBB1111100QQQQQ.  */
{ "mpydu", 0x28D90F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpydu<.f><.cc> 0,limm,c 0010111011011001F111CCCCCC0QQQQQ.  */
{ "mpydu", 0x2ED97000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpydu<.f> a,limm,u6 0010111001011001F111uuuuuuAAAAAA.  */
{ "mpydu", 0x2E597000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpydu<.f> 0,limm,u6 0010111001011001F111uuuuuu111110.  */
{ "mpydu", 0x2E59703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpydu<.f><.cc> 0,limm,u6 0010111011011001F111uuuuuu1QQQQQ.  */
{ "mpydu", 0x2ED97020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpydu<.f> 0,limm,s12 0010111010011001F111ssssssSSSSSS.  */
{ "mpydu", 0x2E997000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpydu<.f> a,limm,limm 0010111000011001F111111110AAAAAA.  */
{ "mpydu", 0x2E197F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpydu<.f> 0,limm,limm 0010111000011001F111111110111110.  */
{ "mpydu", 0x2E197FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpydu<.f><.cc> 0,limm,limm 0010111011011001F1111111100QQQQQ.  */
{ "mpydu", 0x2ED97F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY8E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpyf<.f> a,b,c 00110bbb00001010FBBBCCCCCCAAAAAA.  */
{ "mpyf", 0x300A0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mpyf<.f> 0,b,c 00110bbb00001010FBBBCCCCCC111110.  */
{ "mpyf", 0x300A003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* mpyf<.f><.cc> b,b,c 00110bbb11001010FBBBCCCCCC0QQQQQ.  */
{ "mpyf", 0x30CA0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpyf<.f> a,b,u6 00110bbb01001010FBBBuuuuuuAAAAAA.  */
{ "mpyf", 0x304A0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpyf<.f> 0,b,u6 00110bbb01001010FBBBuuuuuu111110.  */
{ "mpyf", 0x304A003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpyf<.f><.cc> b,b,u6 00110bbb11001010FBBBuuuuuu1QQQQQ.  */
{ "mpyf", 0x30CA0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpyf<.f> b,b,s12 00110bbb10001010FBBBssssssSSSSSS.  */
{ "mpyf", 0x308A0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpyf<.f> a,limm,c 0011011000001010F111CCCCCCAAAAAA.  */
{ "mpyf", 0x360A7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mpyf<.f> a,b,limm 00110bbb00001010FBBB111110AAAAAA.  */
{ "mpyf", 0x300A0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mpyf<.f> 0,limm,c 0011011000001010F111CCCCCC111110.  */
{ "mpyf", 0x360A703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* mpyf<.f> 0,b,limm 00110bbb00001010FBBB111110111110.  */
{ "mpyf", 0x300A0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* mpyf<.f><.cc> b,b,limm 00110bbb11001010FBBB1111100QQQQQ.  */
{ "mpyf", 0x30CA0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpyf<.f><.cc> 0,limm,c 0011011011001010F111CCCCCC0QQQQQ.  */
{ "mpyf", 0x36CA7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpyf<.f> a,limm,u6 0011011001001010F111uuuuuuAAAAAA.  */
{ "mpyf", 0x364A7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpyf<.f> 0,limm,u6 0011011001001010F111uuuuuu111110.  */
{ "mpyf", 0x364A703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpyf<.f><.cc> 0,limm,u6 0011011011001010F111uuuuuu1QQQQQ.  */
{ "mpyf", 0x36CA7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpyf<.f> 0,limm,s12 0011011010001010F111ssssssSSSSSS.  */
{ "mpyf", 0x368A7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpyf<.f> a,limm,limm 0011011000001010F111111110AAAAAA.  */
{ "mpyf", 0x360A7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpyf<.f> 0,limm,limm 0011011000001010F111111110111110.  */
{ "mpyf", 0x360A7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpyf<.f><.cc> 0,limm,limm 0011011011001010F1111111100QQQQQ.  */
{ "mpyf", 0x36CA7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpyfr<.f> a,b,c 00110bbb00001011FBBBCCCCCCAAAAAA.  */
{ "mpyfr", 0x300B0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mpyfr<.f> 0,b,c 00110bbb00001011FBBBCCCCCC111110.  */
{ "mpyfr", 0x300B003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* mpyfr<.f><.cc> b,b,c 00110bbb11001011FBBBCCCCCC0QQQQQ.  */
{ "mpyfr", 0x30CB0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpyfr<.f> a,b,u6 00110bbb01001011FBBBuuuuuuAAAAAA.  */
{ "mpyfr", 0x304B0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpyfr<.f> 0,b,u6 00110bbb01001011FBBBuuuuuu111110.  */
{ "mpyfr", 0x304B003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpyfr<.f><.cc> b,b,u6 00110bbb11001011FBBBuuuuuu1QQQQQ.  */
{ "mpyfr", 0x30CB0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpyfr<.f> b,b,s12 00110bbb10001011FBBBssssssSSSSSS.  */
{ "mpyfr", 0x308B0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpyfr<.f> a,limm,c 0011011000001011F111CCCCCCAAAAAA.  */
{ "mpyfr", 0x360B7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mpyfr<.f> a,b,limm 00110bbb00001011FBBB111110AAAAAA.  */
{ "mpyfr", 0x300B0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mpyfr<.f> 0,limm,c 0011011000001011F111CCCCCC111110.  */
{ "mpyfr", 0x360B703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* mpyfr<.f> 0,b,limm 00110bbb00001011FBBB111110111110.  */
{ "mpyfr", 0x300B0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* mpyfr<.f><.cc> b,b,limm 00110bbb11001011FBBB1111100QQQQQ.  */
{ "mpyfr", 0x30CB0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpyfr<.f><.cc> 0,limm,c 0011011011001011F111CCCCCC0QQQQQ.  */
{ "mpyfr", 0x36CB7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpyfr<.f> a,limm,u6 0011011001001011F111uuuuuuAAAAAA.  */
{ "mpyfr", 0x364B7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpyfr<.f> 0,limm,u6 0011011001001011F111uuuuuu111110.  */
{ "mpyfr", 0x364B703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpyfr<.f><.cc> 0,limm,u6 0011011011001011F111uuuuuu1QQQQQ.  */
{ "mpyfr", 0x36CB7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpyfr<.f> 0,limm,s12 0011011010001011F111ssssssSSSSSS.  */
{ "mpyfr", 0x368B7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpyfr<.f> a,limm,limm 0011011000001011F111111110AAAAAA.  */
{ "mpyfr", 0x360B7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpyfr<.f> 0,limm,limm 0011011000001011F111111110111110.  */
{ "mpyfr", 0x360B7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpyfr<.f><.cc> 0,limm,limm 0011011011001011F1111111100QQQQQ.  */
{ "mpyfr", 0x36CB7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpyh<.f> a,b,c 00100bbb00011011FBBBCCCCCCAAAAAA.  */
{ "mpyh", 0x201B0000, 0xF8FF0000, ARC_OPCODE_ARC700, MPY, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mpyh<.f> 0,b,c 00100bbb00011011FBBBCCCCCC111110.  */
{ "mpyh", 0x201B003E, 0xF8FF003F, ARC_OPCODE_ARC700, MPY, NONE, { ZA, RB, RC }, { C_F }},

/* mpyh<.f><.cc> b,b,c 00100bbb11011011FBBBCCCCCC0QQQQQ.  */
{ "mpyh", 0x20DB0000, 0xF8FF0020, ARC_OPCODE_ARC700, MPY, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpyh<.f> a,b,u6 00100bbb01011011FBBBuuuuuuAAAAAA.  */
{ "mpyh", 0x205B0000, 0xF8FF0000, ARC_OPCODE_ARC700, MPY, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpyh<.f> 0,b,u6 00100bbb01011011FBBBuuuuuu111110.  */
{ "mpyh", 0x205B003E, 0xF8FF003F, ARC_OPCODE_ARC700, MPY, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpyh<.f><.cc> b,b,u6 00100bbb11011011FBBBuuuuuu1QQQQQ.  */
{ "mpyh", 0x20DB0020, 0xF8FF0020, ARC_OPCODE_ARC700, MPY, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpyh<.f> b,b,s12 00100bbb10011011FBBBssssssSSSSSS.  */
{ "mpyh", 0x209B0000, 0xF8FF0000, ARC_OPCODE_ARC700, MPY, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpyh<.f> a,limm,c 0010011000011011F111CCCCCCAAAAAA.  */
{ "mpyh", 0x261B7000, 0xFFFF7000, ARC_OPCODE_ARC700, MPY, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mpyh<.f> a,b,limm 00100bbb00011011FBBB111110AAAAAA.  */
{ "mpyh", 0x201B0F80, 0xF8FF0FC0, ARC_OPCODE_ARC700, MPY, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mpyh<.f> 0,limm,c 0010011000011011F111CCCCCC111110.  */
{ "mpyh", 0x261B703E, 0xFFFF703F, ARC_OPCODE_ARC700, MPY, NONE, { ZA, LIMM, RC }, { C_F }},

/* mpyh<.f> 0,b,limm 00100bbb00011011FBBB111110111110.  */
{ "mpyh", 0x201B0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700, MPY, NONE, { ZA, RB, LIMM }, { C_F }},

/* mpyh<.f><.cc> b,b,limm 00100bbb11011011FBBB1111100QQQQQ.  */
{ "mpyh", 0x20DB0F80, 0xF8FF0FE0, ARC_OPCODE_ARC700, MPY, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpyh<.f><.cc> 0,limm,c 0010011011011011F111CCCCCC0QQQQQ.  */
{ "mpyh", 0x26DB7000, 0xFFFF7020, ARC_OPCODE_ARC700, MPY, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpyh<.f> a,limm,u6 0010011001011011F111uuuuuuAAAAAA.  */
{ "mpyh", 0x265B7000, 0xFFFF7000, ARC_OPCODE_ARC700, MPY, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpyh<.f> 0,limm,u6 0010011001011011F111uuuuuu111110.  */
{ "mpyh", 0x265B703E, 0xFFFF703F, ARC_OPCODE_ARC700, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpyh<.f><.cc> 0,limm,u6 0010011011011011F111uuuuuu1QQQQQ.  */
{ "mpyh", 0x26DB7020, 0xFFFF7020, ARC_OPCODE_ARC700, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpyh<.f> 0,limm,s12 0010011010011011F111ssssssSSSSSS.  */
{ "mpyh", 0x269B7000, 0xFFFF7000, ARC_OPCODE_ARC700, MPY, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpyh<.f> a,limm,limm 0010011000011011F111111110AAAAAA.  */
{ "mpyh", 0x261B7F80, 0xFFFF7FC0, ARC_OPCODE_ARC700, MPY, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpyh<.f> 0,limm,limm 0010011000011011F111111110111110.  */
{ "mpyh", 0x261B7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700, MPY, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpyh<.f><.cc> 0,limm,limm 0010011011011011F1111111100QQQQQ.  */
{ "mpyh", 0x26DB7F80, 0xFFFF7FE0, ARC_OPCODE_ARC700, MPY, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpyhu<.f> a,b,c 00100bbb00011100FBBBCCCCCCAAAAAA.  */
{ "mpyhu", 0x201C0000, 0xF8FF0000, ARC_OPCODE_ARC700, MPY, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mpyhu<.f> 0,b,c 00100bbb00011100FBBBCCCCCC111110.  */
{ "mpyhu", 0x201C003E, 0xF8FF003F, ARC_OPCODE_ARC700, MPY, NONE, { ZA, RB, RC }, { C_F }},

/* mpyhu<.f><.cc> b,b,c 00100bbb11011100FBBBCCCCCC0QQQQQ.  */
{ "mpyhu", 0x20DC0000, 0xF8FF0020, ARC_OPCODE_ARC700, MPY, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpyhu<.f> a,b,u6 00100bbb01011100FBBBuuuuuuAAAAAA.  */
{ "mpyhu", 0x205C0000, 0xF8FF0000, ARC_OPCODE_ARC700, MPY, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpyhu<.f> 0,b,u6 00100bbb01011100FBBBuuuuuu111110.  */
{ "mpyhu", 0x205C003E, 0xF8FF003F, ARC_OPCODE_ARC700, MPY, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpyhu<.f><.cc> b,b,u6 00100bbb11011100FBBBuuuuuu1QQQQQ.  */
{ "mpyhu", 0x20DC0020, 0xF8FF0020, ARC_OPCODE_ARC700, MPY, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpyhu<.f> b,b,s12 00100bbb10011100FBBBssssssSSSSSS.  */
{ "mpyhu", 0x209C0000, 0xF8FF0000, ARC_OPCODE_ARC700, MPY, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpyhu<.f> a,limm,c 0010011000011100F111CCCCCCAAAAAA.  */
{ "mpyhu", 0x261C7000, 0xFFFF7000, ARC_OPCODE_ARC700, MPY, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mpyhu<.f> a,b,limm 00100bbb00011100FBBB111110AAAAAA.  */
{ "mpyhu", 0x201C0F80, 0xF8FF0FC0, ARC_OPCODE_ARC700, MPY, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mpyhu<.f> 0,limm,c 0010011000011100F111CCCCCC111110.  */
{ "mpyhu", 0x261C703E, 0xFFFF703F, ARC_OPCODE_ARC700, MPY, NONE, { ZA, LIMM, RC }, { C_F }},

/* mpyhu<.f> 0,b,limm 00100bbb00011100FBBB111110111110.  */
{ "mpyhu", 0x201C0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700, MPY, NONE, { ZA, RB, LIMM }, { C_F }},

/* mpyhu<.f><.cc> b,b,limm 00100bbb11011100FBBB1111100QQQQQ.  */
{ "mpyhu", 0x20DC0F80, 0xF8FF0FE0, ARC_OPCODE_ARC700, MPY, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpyhu<.f><.cc> 0,limm,c 0010011011011100F111CCCCCC0QQQQQ.  */
{ "mpyhu", 0x26DC7000, 0xFFFF7020, ARC_OPCODE_ARC700, MPY, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpyhu<.f> a,limm,u6 0010011001011100F111uuuuuuAAAAAA.  */
{ "mpyhu", 0x265C7000, 0xFFFF7000, ARC_OPCODE_ARC700, MPY, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpyhu<.f> 0,limm,u6 0010011001011100F111uuuuuu111110.  */
{ "mpyhu", 0x265C703E, 0xFFFF703F, ARC_OPCODE_ARC700, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpyhu<.f><.cc> 0,limm,u6 0010011011011100F111uuuuuu1QQQQQ.  */
{ "mpyhu", 0x26DC7020, 0xFFFF7020, ARC_OPCODE_ARC700, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpyhu<.f> 0,limm,s12 0010011010011100F111ssssssSSSSSS.  */
{ "mpyhu", 0x269C7000, 0xFFFF7000, ARC_OPCODE_ARC700, MPY, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpyhu<.f> a,limm,limm 0010011000011100F111111110AAAAAA.  */
{ "mpyhu", 0x261C7F80, 0xFFFF7FC0, ARC_OPCODE_ARC700, MPY, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpyhu<.f> 0,limm,limm 0010011000011100F111111110111110.  */
{ "mpyhu", 0x261C7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700, MPY, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpyhu<.f><.cc> 0,limm,limm 0010011011011100F1111111100QQQQQ.  */
{ "mpyhu", 0x26DC7F80, 0xFFFF7FE0, ARC_OPCODE_ARC700, MPY, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpym<.f> a,b,c 00100bbb00011011FBBBCCCCCCAAAAAA.  */
{ "mpym", 0x201B0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, RB, RC }, { C_F }},

/* mpym<.f> 0,b,c 00100bbb00011011FBBBCCCCCC111110.  */
{ "mpym", 0x201B003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, RB, RC }, { C_F }},

/* mpym<.f><.cc> b,b,c 00100bbb11011011FBBBCCCCCC0QQQQQ.  */
{ "mpym", 0x20DB0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpym<.f> a,b,u6 00100bbb01011011FBBBuuuuuuAAAAAA.  */
{ "mpym", 0x205B0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpym<.f> 0,b,u6 00100bbb01011011FBBBuuuuuu111110.  */
{ "mpym", 0x205B003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpym<.f><.cc> b,b,u6 00100bbb11011011FBBBuuuuuu1QQQQQ.  */
{ "mpym", 0x20DB0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpym<.f> b,b,s12 00100bbb10011011FBBBssssssSSSSSS.  */
{ "mpym", 0x209B0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpym<.f> a,limm,c 0010011000011011F111CCCCCCAAAAAA.  */
{ "mpym", 0x261B7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, LIMM, RC }, { C_F }},

/* mpym<.f> a,b,limm 00100bbb00011011FBBB111110AAAAAA.  */
{ "mpym", 0x201B0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, RB, LIMM }, { C_F }},

/* mpym<.f> 0,limm,c 0010011000011011F111CCCCCC111110.  */
{ "mpym", 0x261B703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, RC }, { C_F }},

/* mpym<.f> 0,b,limm 00100bbb00011011FBBB111110111110.  */
{ "mpym", 0x201B0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, RB, LIMM }, { C_F }},

/* mpym<.f><.cc> b,b,limm 00100bbb11011011FBBB1111100QQQQQ.  */
{ "mpym", 0x20DB0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpym<.f><.cc> 0,limm,c 0010011011011011F111CCCCCC0QQQQQ.  */
{ "mpym", 0x26DB7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpym<.f> a,limm,u6 0010011001011011F111uuuuuuAAAAAA.  */
{ "mpym", 0x265B7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpym<.f> 0,limm,u6 0010011001011011F111uuuuuu111110.  */
{ "mpym", 0x265B703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpym<.f><.cc> 0,limm,u6 0010011011011011F111uuuuuu1QQQQQ.  */
{ "mpym", 0x26DB7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpym<.f> 0,limm,s12 0010011010011011F111ssssssSSSSSS.  */
{ "mpym", 0x269B7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpym<.f> a,limm,limm 0010011000011011F111111110AAAAAA.  */
{ "mpym", 0x261B7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpym<.f> 0,limm,limm 0010011000011011F111111110111110.  */
{ "mpym", 0x261B7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpym<.f><.cc> 0,limm,limm 0010011011011011F1111111100QQQQQ.  */
{ "mpym", 0x26DB7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpymu<.f> a,b,c 00100bbb00011100FBBBCCCCCCAAAAAA.  */
{ "mpymu", 0x201C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, RB, RC }, { C_F }},

/* mpymu<.f> 0,b,c 00100bbb00011100FBBBCCCCCC111110.  */
{ "mpymu", 0x201C003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, RB, RC }, { C_F }},

/* mpymu<.f><.cc> b,b,c 00100bbb11011100FBBBCCCCCC0QQQQQ.  */
{ "mpymu", 0x20DC0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpymu<.f> a,b,u6 00100bbb01011100FBBBuuuuuuAAAAAA.  */
{ "mpymu", 0x205C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpymu<.f> 0,b,u6 00100bbb01011100FBBBuuuuuu111110.  */
{ "mpymu", 0x205C003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpymu<.f><.cc> b,b,u6 00100bbb11011100FBBBuuuuuu1QQQQQ.  */
{ "mpymu", 0x20DC0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpymu<.f> b,b,s12 00100bbb10011100FBBBssssssSSSSSS.  */
{ "mpymu", 0x209C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpymu<.f> a,limm,c 0010011000011100F111CCCCCCAAAAAA.  */
{ "mpymu", 0x261C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, LIMM, RC }, { C_F }},

/* mpymu<.f> a,b,limm 00100bbb00011100FBBB111110AAAAAA.  */
{ "mpymu", 0x201C0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, RB, LIMM }, { C_F }},

/* mpymu<.f> 0,limm,c 0010011000011100F111CCCCCC111110.  */
{ "mpymu", 0x261C703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, RC }, { C_F }},

/* mpymu<.f> 0,b,limm 00100bbb00011100FBBB111110111110.  */
{ "mpymu", 0x201C0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, RB, LIMM }, { C_F }},

/* mpymu<.f><.cc> b,b,limm 00100bbb11011100FBBB1111100QQQQQ.  */
{ "mpymu", 0x20DC0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpymu<.f><.cc> 0,limm,c 0010011011011100F111CCCCCC0QQQQQ.  */
{ "mpymu", 0x26DC7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpymu<.f> a,limm,u6 0010011001011100F111uuuuuuAAAAAA.  */
{ "mpymu", 0x265C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpymu<.f> 0,limm,u6 0010011001011100F111uuuuuu111110.  */
{ "mpymu", 0x265C703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpymu<.f><.cc> 0,limm,u6 0010011011011100F111uuuuuu1QQQQQ.  */
{ "mpymu", 0x26DC7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpymu<.f> 0,limm,s12 0010011010011100F111ssssssSSSSSS.  */
{ "mpymu", 0x269C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpymu<.f> a,limm,limm 0010011000011100F111111110AAAAAA.  */
{ "mpymu", 0x261C7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpymu<.f> 0,limm,limm 0010011000011100F111111110111110.  */
{ "mpymu", 0x261C7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpymu<.f><.cc> 0,limm,limm 0010011011011100F1111111100QQQQQ.  */
{ "mpymu", 0x26DC7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpyqb<.f><.cc> b,b,c 00110bbb11100101FBBBCCCCCC0QQQQQ.  */
{ "mpyqb", 0x30E50000, 0xF8FF0020, ARC_OPCODE_ARC700, MPY, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpyqb<.f> a,b,u6 00110bbb01100101FBBBuuuuuuAAAAAA.  */
{ "mpyqb", 0x30650000, 0xF8FF0000, ARC_OPCODE_ARC700, MPY, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpyqb<.f><.cc> b,b,u6 00110bbb11100101FBBBuuuuuu1QQQQQ.  */
{ "mpyqb", 0x30E50020, 0xF8FF0020, ARC_OPCODE_ARC700, MPY, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpyqb<.f> b,b,s12 00110bbb10100101FBBBssssssSSSSSS.  */
{ "mpyqb", 0x30A50000, 0xF8FF0000, ARC_OPCODE_ARC700, MPY, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpyqb<.f> a,limm,c 0011011000100101F111CCCCCCAAAAAA.  */
{ "mpyqb", 0x36257000, 0xFFFF7000, ARC_OPCODE_ARC700, MPY, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mpyqb<.f> a,b,limm 00110bbb00100101FBBB111110AAAAAA.  */
{ "mpyqb", 0x30250F80, 0xF8FF0FC0, ARC_OPCODE_ARC700, MPY, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mpyqb<.f><.cc> b,b,limm 00110bbb11100101FBBB1111100QQQQQ.  */
{ "mpyqb", 0x30E50F80, 0xF8FF0FE0, ARC_OPCODE_ARC700, MPY, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpyu<.f> a,b,c 00100bbb00011101FBBBCCCCCCAAAAAA.  */
{ "mpyu", 0x201D0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, RB, RC }, { C_F }},

/* mpyu<.f> 0,b,c 00100bbb00011101FBBBCCCCCC111110.  */
{ "mpyu", 0x201D003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, RB, RC }, { C_F }},

/* mpyu<.f><.cc> b,b,c 00100bbb11011101FBBBCCCCCC0QQQQQ.  */
{ "mpyu", 0x20DD0000, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpyu<.f> a,b,u6 00100bbb01011101FBBBuuuuuuAAAAAA.  */
{ "mpyu", 0x205D0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpyu<.f> 0,b,u6 00100bbb01011101FBBBuuuuuu111110.  */
{ "mpyu", 0x205D003E, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpyu<.f><.cc> b,b,u6 00100bbb11011101FBBBuuuuuu1QQQQQ.  */
{ "mpyu", 0x20DD0020, 0xF8FF0020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpyu<.f> b,b,s12 00100bbb10011101FBBBssssssSSSSSS.  */
{ "mpyu", 0x209D0000, 0xF8FF0000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpyu<.f> a,limm,c 0010011000011101F111CCCCCCAAAAAA.  */
{ "mpyu", 0x261D7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, LIMM, RC }, { C_F }},

/* mpyu<.f> a,b,limm 00100bbb00011101FBBB111110AAAAAA.  */
{ "mpyu", 0x201D0F80, 0xF8FF0FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, RB, LIMM }, { C_F }},

/* mpyu<.f> 0,limm,c 0010011000011101F111CCCCCC111110.  */
{ "mpyu", 0x261D703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, RC }, { C_F }},

/* mpyu<.f> 0,b,limm 00100bbb00011101FBBB111110111110.  */
{ "mpyu", 0x201D0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, RB, LIMM }, { C_F }},

/* mpyu<.f><.cc> b,b,limm 00100bbb11011101FBBB1111100QQQQQ.  */
{ "mpyu", 0x20DD0F80, 0xF8FF0FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpyu<.f><.cc> 0,limm,c 0010011011011101F111CCCCCC0QQQQQ.  */
{ "mpyu", 0x26DD7000, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpyu<.f> a,limm,u6 0010011001011101F111uuuuuuAAAAAA.  */
{ "mpyu", 0x265D7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpyu<.f> 0,limm,u6 0010011001011101F111uuuuuu111110.  */
{ "mpyu", 0x265D703E, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpyu<.f><.cc> 0,limm,u6 0010011011011101F111uuuuuu1QQQQQ.  */
{ "mpyu", 0x26DD7020, 0xFFFF7020, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpyu<.f> 0,limm,s12 0010011010011101F111ssssssSSSSSS.  */
{ "mpyu", 0x269D7000, 0xFFFF7000, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpyu<.f> a,limm,limm 0010011000011101F111111110AAAAAA.  */
{ "mpyu", 0x261D7F80, 0xFFFF7FC0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpyu<.f> 0,limm,limm 0010011000011101F111111110111110.  */
{ "mpyu", 0x261D7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpyu<.f><.cc> 0,limm,limm 0010011011011101F1111111100QQQQQ.  */
{ "mpyu", 0x26DD7F80, 0xFFFF7FE0, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpyuw<.f> a,b,c 00100bbb00111111FBBBCCCCCCAAAAAA.  */
{ "mpyuw", 0x203F0000, 0xF8FF0000, ARC_OPCODE_ARC600, MPY, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mpyuw<.f> 0,b,c 00100bbb00111111FBBBCCCCCC111110.  */
{ "mpyuw", 0x203F003E, 0xF8FF003F, ARC_OPCODE_ARC600, MPY, NONE, { ZA, RB, RC }, { C_F }},

/* mpyuw<.f><.cc> b,b,c 00100bbb11111111FBBBCCCCCC0QQQQQ.  */
{ "mpyuw", 0x20FF0000, 0xF8FF0020, ARC_OPCODE_ARC600, MPY, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpyuw<.f> a,b,c 00100bbb00011111FBBBCCCCCCAAAAAA.  */
{ "mpyuw", 0x201F0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RA_CHK, RB, RC }, { C_F }},

/* mpyuw<.f> 0,b,c 00100bbb00011111FBBBCCCCCC111110.  */
{ "mpyuw", 0x201F003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { ZA, RB, RC }, { C_F }},

/* mpyuw<.f><.cc> b,b,c 00100bbb11011111FBBBCCCCCC0QQQQQ.  */
{ "mpyuw", 0x20DF0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpyuw<.f> a,b,u6 00100bbb01111111FBBBuuuuuuAAAAAA.  */
{ "mpyuw", 0x207F0000, 0xF8FF0000, ARC_OPCODE_ARC600, MPY, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpyuw<.f> 0,b,u6 00100bbb01111111FBBBuuuuuu111110.  */
{ "mpyuw", 0x207F003E, 0xF8FF003F, ARC_OPCODE_ARC600, MPY, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpyuw<.f><.cc> b,b,u6 00100bbb11111111FBBBuuuuuu1QQQQQ.  */
{ "mpyuw", 0x20FF0020, 0xF8FF0020, ARC_OPCODE_ARC600, MPY, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpyuw<.f> a,b,u6 00100bbb01011111FBBBuuuuuuAAAAAA.  */
{ "mpyuw", 0x205F0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpyuw<.f> 0,b,u6 00100bbb01011111FBBBuuuuuu111110.  */
{ "mpyuw", 0x205F003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpyuw<.f><.cc> b,b,u6 00100bbb11011111FBBBuuuuuu1QQQQQ.  */
{ "mpyuw", 0x20DF0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpyuw<.f> b,b,s12 00100bbb10111111FBBBssssssSSSSSS.  */
{ "mpyuw", 0x20BF0000, 0xF8FF0000, ARC_OPCODE_ARC600, MPY, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpyuw<.f> b,b,s12 00100bbb10011111FBBBssssssSSSSSS.  */
{ "mpyuw", 0x209F0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpyuw<.f> a,limm,c 0010011000111111F111CCCCCCAAAAAA.  */
{ "mpyuw", 0x263F7000, 0xFFFF7000, ARC_OPCODE_ARC600, MPY, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mpyuw<.f> a,b,limm 00100bbb00111111FBBB111110AAAAAA.  */
{ "mpyuw", 0x203F0F80, 0xF8FF0FC0, ARC_OPCODE_ARC600, MPY, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mpyuw<.f> 0,limm,c 0010011000111111F111CCCCCC111110.  */
{ "mpyuw", 0x263F703E, 0xFFFF703F, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, RC }, { C_F }},

/* mpyuw<.f> 0,b,limm 00100bbb00111111FBBB111110111110.  */
{ "mpyuw", 0x203F0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600, MPY, NONE, { ZA, RB, LIMM }, { C_F }},

/* mpyuw<.f><.cc> b,b,limm 00100bbb11111111FBBB1111100QQQQQ.  */
{ "mpyuw", 0x20FF0F80, 0xF8FF0FE0, ARC_OPCODE_ARC600, MPY, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpyuw<.f><.cc> 0,limm,c 0010011011111111F111CCCCCC0QQQQQ.  */
{ "mpyuw", 0x26FF7000, 0xFFFF7020, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpyuw<.f> a,limm,c 0010011000011111F111CCCCCCAAAAAA.  */
{ "mpyuw", 0x261F7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RA_CHK, LIMM, RC }, { C_F }},

/* mpyuw<.f> a,b,limm 00100bbb00011111FBBB111110AAAAAA.  */
{ "mpyuw", 0x201F0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RA_CHK, RB, LIMM }, { C_F }},

/* mpyuw<.f> 0,limm,c 0010011000011111F111CCCCCC111110.  */
{ "mpyuw", 0x261F703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { ZA, LIMM, RC }, { C_F }},

/* mpyuw<.f> 0,b,limm 00100bbb00011111FBBB111110111110.  */
{ "mpyuw", 0x201F0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { ZA, RB, LIMM }, { C_F }},

/* mpyuw<.f><.cc> b,b,limm 00100bbb11011111FBBB1111100QQQQQ.  */
{ "mpyuw", 0x20DF0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpyuw<.f><.cc> 0,limm,c 0010011011011111F111CCCCCC0QQQQQ.  */
{ "mpyuw", 0x26DF7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpyuw<.f> a,limm,u6 0010011001111111F111uuuuuuAAAAAA.  */
{ "mpyuw", 0x267F7000, 0xFFFF7000, ARC_OPCODE_ARC600, MPY, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpyuw<.f> 0,limm,u6 0010011001111111F111uuuuuu111110.  */
{ "mpyuw", 0x267F703E, 0xFFFF703F, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpyuw<.f><.cc> 0,limm,u6 0010011011111111F111uuuuuu1QQQQQ.  */
{ "mpyuw", 0x26FF7020, 0xFFFF7020, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpyuw<.f> a,limm,u6 0010011001011111F111uuuuuuAAAAAA.  */
{ "mpyuw", 0x265F7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpyuw<.f> 0,limm,u6 0010011001011111F111uuuuuu111110.  */
{ "mpyuw", 0x265F703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpyuw<.f><.cc> 0,limm,u6 0010011011011111F111uuuuuu1QQQQQ.  */
{ "mpyuw", 0x26DF7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpyuw<.f> 0,limm,s12 0010011010111111F111ssssssSSSSSS.  */
{ "mpyuw", 0x26BF7000, 0xFFFF7000, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpyuw<.f> 0,limm,s12 0010011010011111F111ssssssSSSSSS.  */
{ "mpyuw", 0x269F7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpyuw<.f> a,limm,limm 0010011000111111F111111110AAAAAA.  */
{ "mpyuw", 0x263F7F80, 0xFFFF7FC0, ARC_OPCODE_ARC600, MPY, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpyuw<.f> 0,limm,limm 0010011000111111F111111110111110.  */
{ "mpyuw", 0x263F7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpyuw<.f><.cc> 0,limm,limm 0010011011111111F1111111100QQQQQ.  */
{ "mpyuw", 0x26FF7F80, 0xFFFF7FE0, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpyuw<.f> a,limm,limm 0010011000011111F111111110AAAAAA.  */
{ "mpyuw", 0x261F7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpyuw<.f> 0,limm,limm 0010011000011111F111111110111110.  */
{ "mpyuw", 0x261F7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpyuw<.f><.cc> 0,limm,limm 0010011011011111F1111111100QQQQQ.  */
{ "mpyuw", 0x26DF7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpyuw_s b,b,c 01111bbbccc01010.  */
{ "mpyuw_s", 0x0000780A, 0x0000F81F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* mpyw<.f> a,b,c 00100bbb00111110FBBBCCCCCCAAAAAA.  */
{ "mpyw", 0x203E0000, 0xF8FF0000, ARC_OPCODE_ARC600, MPY, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mpyw<.f> 0,b,c 00100bbb00111110FBBBCCCCCC111110.  */
{ "mpyw", 0x203E003E, 0xF8FF003F, ARC_OPCODE_ARC600, MPY, NONE, { ZA, RB, RC }, { C_F }},

/* mpyw<.f><.cc> b,b,c 00100bbb11111110FBBBCCCCCC0QQQQQ.  */
{ "mpyw", 0x20FE0000, 0xF8FF0020, ARC_OPCODE_ARC600, MPY, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpyw<.f> a,b,c 00100bbb00011110FBBBCCCCCCAAAAAA.  */
{ "mpyw", 0x201E0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RA_CHK, RB, RC }, { C_F }},

/* mpyw<.f> 0,b,c 00100bbb00011110FBBBCCCCCC111110.  */
{ "mpyw", 0x201E003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { ZA, RB, RC }, { C_F }},

/* mpyw<.f><.cc> b,b,c 00100bbb11011110FBBBCCCCCC0QQQQQ.  */
{ "mpyw", 0x20DE0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpyw<.f> a,b,u6 00100bbb01111110FBBBuuuuuuAAAAAA.  */
{ "mpyw", 0x207E0000, 0xF8FF0000, ARC_OPCODE_ARC600, MPY, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpyw<.f> 0,b,u6 00100bbb01111110FBBBuuuuuu111110.  */
{ "mpyw", 0x207E003E, 0xF8FF003F, ARC_OPCODE_ARC600, MPY, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpyw<.f><.cc> b,b,u6 00100bbb11111110FBBBuuuuuu1QQQQQ.  */
{ "mpyw", 0x20FE0020, 0xF8FF0020, ARC_OPCODE_ARC600, MPY, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpyw<.f> a,b,u6 00100bbb01011110FBBBuuuuuuAAAAAA.  */
{ "mpyw", 0x205E0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpyw<.f> 0,b,u6 00100bbb01011110FBBBuuuuuu111110.  */
{ "mpyw", 0x205E003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpyw<.f><.cc> b,b,u6 00100bbb11011110FBBBuuuuuu1QQQQQ.  */
{ "mpyw", 0x20DE0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpyw<.f> b,b,s12 00100bbb10111110FBBBssssssSSSSSS.  */
{ "mpyw", 0x20BE0000, 0xF8FF0000, ARC_OPCODE_ARC600, MPY, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpyw<.f> b,b,s12 00100bbb10011110FBBBssssssSSSSSS.  */
{ "mpyw", 0x209E0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpyw<.f> a,limm,c 0010011000111110F111CCCCCCAAAAAA.  */
{ "mpyw", 0x263E7000, 0xFFFF7000, ARC_OPCODE_ARC600, MPY, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mpyw<.f> a,b,limm 00100bbb00111110FBBB111110AAAAAA.  */
{ "mpyw", 0x203E0F80, 0xF8FF0FC0, ARC_OPCODE_ARC600, MPY, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mpyw<.f> 0,limm,c 0010011000111110F111CCCCCC111110.  */
{ "mpyw", 0x263E703E, 0xFFFF703F, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, RC }, { C_F }},

/* mpyw<.f> 0,b,limm 00100bbb00111110FBBB111110111110.  */
{ "mpyw", 0x203E0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600, MPY, NONE, { ZA, RB, LIMM }, { C_F }},

/* mpyw<.f><.cc> b,b,limm 00100bbb11111110FBBB1111100QQQQQ.  */
{ "mpyw", 0x20FE0F80, 0xF8FF0FE0, ARC_OPCODE_ARC600, MPY, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpyw<.f><.cc> 0,limm,c 0010011011111110F111CCCCCC0QQQQQ.  */
{ "mpyw", 0x26FE7000, 0xFFFF7020, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpyw<.f> a,limm,c 0010011000011110F111CCCCCCAAAAAA.  */
{ "mpyw", 0x261E7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RA_CHK, LIMM, RC }, { C_F }},

/* mpyw<.f> a,b,limm 00100bbb00011110FBBB111110AAAAAA.  */
{ "mpyw", 0x201E0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RA_CHK, RB, LIMM }, { C_F }},

/* mpyw<.f> 0,limm,c 0010011000011110F111CCCCCC111110.  */
{ "mpyw", 0x261E703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { ZA, LIMM, RC }, { C_F }},

/* mpyw<.f> 0,b,limm 00100bbb00011110FBBB111110111110.  */
{ "mpyw", 0x201E0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { ZA, RB, LIMM }, { C_F }},

/* mpyw<.f><.cc> b,b,limm 00100bbb11011110FBBB1111100QQQQQ.  */
{ "mpyw", 0x20DE0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpyw<.f><.cc> 0,limm,c 0010011011011110F111CCCCCC0QQQQQ.  */
{ "mpyw", 0x26DE7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpyw<.f> a,limm,u6 0010011001111110F111uuuuuuAAAAAA.  */
{ "mpyw", 0x267E7000, 0xFFFF7000, ARC_OPCODE_ARC600, MPY, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpyw<.f> 0,limm,u6 0010011001111110F111uuuuuu111110.  */
{ "mpyw", 0x267E703E, 0xFFFF703F, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpyw<.f><.cc> 0,limm,u6 0010011011111110F111uuuuuu1QQQQQ.  */
{ "mpyw", 0x26FE7020, 0xFFFF7020, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpyw<.f> a,limm,u6 0010011001011110F111uuuuuuAAAAAA.  */
{ "mpyw", 0x265E7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpyw<.f> 0,limm,u6 0010011001011110F111uuuuuu111110.  */
{ "mpyw", 0x265E703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpyw<.f><.cc> 0,limm,u6 0010011011011110F111uuuuuu1QQQQQ.  */
{ "mpyw", 0x26DE7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpyw<.f> 0,limm,s12 0010011010111110F111ssssssSSSSSS.  */
{ "mpyw", 0x26BE7000, 0xFFFF7000, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpyw<.f> 0,limm,s12 0010011010011110F111ssssssSSSSSS.  */
{ "mpyw", 0x269E7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpyw<.f> a,limm,limm 0010011000111110F111111110AAAAAA.  */
{ "mpyw", 0x263E7F80, 0xFFFF7FC0, ARC_OPCODE_ARC600, MPY, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpyw<.f> 0,limm,limm 0010011000111110F111111110111110.  */
{ "mpyw", 0x263E7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpyw<.f><.cc> 0,limm,limm 0010011011111110F1111111100QQQQQ.  */
{ "mpyw", 0x26FE7F80, 0xFFFF7FE0, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpyw<.f> a,limm,limm 0010011000011110F111111110AAAAAA.  */
{ "mpyw", 0x261E7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpyw<.f> 0,limm,limm 0010011000011110F111111110111110.  */
{ "mpyw", 0x261E7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpyw<.f><.cc> 0,limm,limm 0010011011011110F1111111100QQQQQ.  */
{ "mpyw", 0x26DE7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpywhfl<.f> a,b,c 00110bbb00100100FBBBCCCCCCAAAAAA.  */
{ "mpywhfl", 0x30240000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mpywhfl<.f> 0,b,c 00110bbb00100100FBBBCCCCCC111110.  */
{ "mpywhfl", 0x3024003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* mpywhfl<.f><.cc> b,b,c 00110bbb11100100FBBBCCCCCC0QQQQQ.  */
{ "mpywhfl", 0x30E40000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpywhfl<.f> a,b,u6 00110bbb01100100FBBBuuuuuuAAAAAA.  */
{ "mpywhfl", 0x30640000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpywhfl<.f> 0,b,u6 00110bbb01100100FBBBuuuuuu111110.  */
{ "mpywhfl", 0x3064003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpywhfl<.f><.cc> b,b,u6 00110bbb11100100FBBBuuuuuu1QQQQQ.  */
{ "mpywhfl", 0x30E40020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpywhfl<.f> b,b,s12 00110bbb10100100FBBBssssssSSSSSS.  */
{ "mpywhfl", 0x30A40000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpywhfl<.f> a,limm,c 0011011000100100F111CCCCCCAAAAAA.  */
{ "mpywhfl", 0x36247000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mpywhfl<.f> a,b,limm 00110bbb00100100FBBB111110AAAAAA.  */
{ "mpywhfl", 0x30240F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mpywhfl<.f> 0,limm,c 0011011001100100F111CCCCCC111110.  */
{ "mpywhfl", 0x3664703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* mpywhfl<.f> 0,b,limm 00110bbb00100100FBBB111110111110.  */
{ "mpywhfl", 0x30240FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* mpywhfl<.f><.cc> b,b,limm 00110bbb11100100FBBB1111100QQQQQ.  */
{ "mpywhfl", 0x30E40F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpywhfl<.f><.cc> 0,limm,c 0011011011100100F111CCCCCC0QQQQQ.  */
{ "mpywhfl", 0x36E47000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpywhfl<.f> a,limm,u6 0011011001100100F111uuuuuuAAAAAA.  */
{ "mpywhfl", 0x36647000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpywhfl<.f> 0,limm,u6 0011011001100100F111uuuuuu111110.  */
{ "mpywhfl", 0x3664703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpywhfl<.f><.cc> 0,limm,u6 0011011011100100F111uuuuuu1QQQQQ.  */
{ "mpywhfl", 0x36E47020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpywhfl<.f> 0,limm,s12 0011011010100100F111ssssssSSSSSS.  */
{ "mpywhfl", 0x36A47000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpywhfl<.f> a,limm,limm 0011011000100100F111111110AAAAAA.  */
{ "mpywhfl", 0x36247F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpywhfl<.f> 0,limm,limm 0011011000100100F111111110111110.  */
{ "mpywhfl", 0x36247FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpywhfl<.f><.cc> 0,limm,limm 0011011011100100F1111111100QQQQQ.  */
{ "mpywhfl", 0x36E47F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpywhflr<.f> a,b,c 00110bbb00100101FBBBCCCCCCAAAAAA.  */
{ "mpywhflr", 0x30250000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mpywhflr<.f> 0,b,c 00110bbb00100101FBBBCCCCCC111110.  */
{ "mpywhflr", 0x3025003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* mpywhflr<.f><.cc> b,b,c 00110bbb11100101FBBBCCCCCC0QQQQQ.  */
{ "mpywhflr", 0x30E50000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpywhflr<.f> a,b,u6 00110bbb01100101FBBBuuuuuuAAAAAA.  */
{ "mpywhflr", 0x30650000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpywhflr<.f> 0,b,u6 00110bbb01100101FBBBuuuuuu111110.  */
{ "mpywhflr", 0x3065003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpywhflr<.f><.cc> b,b,u6 00110bbb11100101FBBBuuuuuu1QQQQQ.  */
{ "mpywhflr", 0x30E50020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpywhflr<.f> b,b,s12 00110bbb10100101FBBBssssssSSSSSS.  */
{ "mpywhflr", 0x30A50000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpywhflr<.f> a,limm,c 0011011000100101F111CCCCCCAAAAAA.  */
{ "mpywhflr", 0x36257000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mpywhflr<.f> a,b,limm 00110bbb00100101FBBB111110AAAAAA.  */
{ "mpywhflr", 0x30250F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mpywhflr<.f> 0,limm,c 0011011001100101F111CCCCCC111110.  */
{ "mpywhflr", 0x3665703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* mpywhflr<.f> 0,b,limm 00110bbb00100101FBBB111110111110.  */
{ "mpywhflr", 0x30250FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* mpywhflr<.f><.cc> b,b,limm 00110bbb11100101FBBB1111100QQQQQ.  */
{ "mpywhflr", 0x30E50F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpywhflr<.f><.cc> 0,limm,c 0011011011100101F111CCCCCC0QQQQQ.  */
{ "mpywhflr", 0x36E57000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpywhflr<.f> a,limm,u6 0011011001100101F111uuuuuuAAAAAA.  */
{ "mpywhflr", 0x36657000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpywhflr<.f> 0,limm,u6 0011011001100101F111uuuuuu111110.  */
{ "mpywhflr", 0x3665703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpywhflr<.f><.cc> 0,limm,u6 0011011011100101F111uuuuuu1QQQQQ.  */
{ "mpywhflr", 0x36E57020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpywhflr<.f> 0,limm,s12 0011011010100101F111ssssssSSSSSS.  */
{ "mpywhflr", 0x36A57000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpywhflr<.f> a,limm,limm 0011011000100101F111111110AAAAAA.  */
{ "mpywhflr", 0x36257F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpywhflr<.f> 0,limm,limm 0011011000100101F111111110111110.  */
{ "mpywhflr", 0x36257FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpywhflr<.f><.cc> 0,limm,limm 0011011011100101F1111111100QQQQQ.  */
{ "mpywhflr", 0x36E57F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpywhfm<.f> a,b,c 00110bbb00100000FBBBCCCCCCAAAAAA.  */
{ "mpywhfm", 0x30200000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mpywhfm<.f> 0,b,c 00110bbb00100000FBBBCCCCCC111110.  */
{ "mpywhfm", 0x3020003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* mpywhfm<.f><.cc> b,b,c 00110bbb11100000FBBBCCCCCC0QQQQQ.  */
{ "mpywhfm", 0x30E00000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpywhfm<.f> a,b,u6 00110bbb01100000FBBBuuuuuuAAAAAA.  */
{ "mpywhfm", 0x30600000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpywhfm<.f> 0,b,u6 00110bbb01100000FBBBuuuuuu111110.  */
{ "mpywhfm", 0x3060003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpywhfm<.f><.cc> b,b,u6 00110bbb11100000FBBBuuuuuu1QQQQQ.  */
{ "mpywhfm", 0x30E00020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpywhfm<.f> b,b,s12 00110bbb10100000FBBBssssssSSSSSS.  */
{ "mpywhfm", 0x30A00000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpywhfm<.f> a,limm,c 0011011000100000F111CCCCCCAAAAAA.  */
{ "mpywhfm", 0x36207000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mpywhfm<.f> a,b,limm 00110bbb00100000FBBB111110AAAAAA.  */
{ "mpywhfm", 0x30200F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mpywhfm<.f> 0,limm,c 0011011001100000F111CCCCCC111110.  */
{ "mpywhfm", 0x3660703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* mpywhfm<.f> 0,b,limm 00110bbb00100000FBBB111110111110.  */
{ "mpywhfm", 0x30200FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* mpywhfm<.f><.cc> b,b,limm 00110bbb11100000FBBB1111100QQQQQ.  */
{ "mpywhfm", 0x30E00F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpywhfm<.f><.cc> 0,limm,c 0011011011100000F111CCCCCC0QQQQQ.  */
{ "mpywhfm", 0x36E07000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpywhfm<.f> a,limm,u6 0011011001100000F111uuuuuuAAAAAA.  */
{ "mpywhfm", 0x36607000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpywhfm<.f> 0,limm,u6 0011011001100000F111uuuuuu111110.  */
{ "mpywhfm", 0x3660703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpywhfm<.f><.cc> 0,limm,u6 0011011011100000F111uuuuuu1QQQQQ.  */
{ "mpywhfm", 0x36E07020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpywhfm<.f> 0,limm,s12 0011011010100000F111ssssssSSSSSS.  */
{ "mpywhfm", 0x36A07000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpywhfm<.f> a,limm,limm 0011011000100000F111111110AAAAAA.  */
{ "mpywhfm", 0x36207F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpywhfm<.f> 0,limm,limm 0011011000100000F111111110111110.  */
{ "mpywhfm", 0x36207FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpywhfm<.f><.cc> 0,limm,limm 0011011011100000F1111111100QQQQQ.  */
{ "mpywhfm", 0x36E07F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpywhfmr<.f> a,b,c 00110bbb00100001FBBBCCCCCCAAAAAA.  */
{ "mpywhfmr", 0x30210000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mpywhfmr<.f> 0,b,c 00110bbb00100001FBBBCCCCCC111110.  */
{ "mpywhfmr", 0x3021003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* mpywhfmr<.f><.cc> b,b,c 00110bbb11100001FBBBCCCCCC0QQQQQ.  */
{ "mpywhfmr", 0x30E10000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpywhfmr<.f> a,b,u6 00110bbb01100001FBBBuuuuuuAAAAAA.  */
{ "mpywhfmr", 0x30610000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpywhfmr<.f> 0,b,u6 00110bbb01100001FBBBuuuuuu111110.  */
{ "mpywhfmr", 0x3061003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpywhfmr<.f><.cc> b,b,u6 00110bbb11100001FBBBuuuuuu1QQQQQ.  */
{ "mpywhfmr", 0x30E10020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpywhfmr<.f> b,b,s12 00110bbb10100001FBBBssssssSSSSSS.  */
{ "mpywhfmr", 0x30A10000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpywhfmr<.f> a,limm,c 0011011000100001F111CCCCCCAAAAAA.  */
{ "mpywhfmr", 0x36217000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mpywhfmr<.f> a,b,limm 00110bbb00100001FBBB111110AAAAAA.  */
{ "mpywhfmr", 0x30210F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mpywhfmr<.f> 0,limm,c 0011011001100001F111CCCCCC111110.  */
{ "mpywhfmr", 0x3661703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* mpywhfmr<.f> 0,b,limm 00110bbb00100001FBBB111110111110.  */
{ "mpywhfmr", 0x30210FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* mpywhfmr<.f><.cc> b,b,limm 00110bbb11100001FBBB1111100QQQQQ.  */
{ "mpywhfmr", 0x30E10F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpywhfmr<.f><.cc> 0,limm,c 0011011011100001F111CCCCCC0QQQQQ.  */
{ "mpywhfmr", 0x36E17000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpywhfmr<.f> a,limm,u6 0011011001100001F111uuuuuuAAAAAA.  */
{ "mpywhfmr", 0x36617000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpywhfmr<.f> 0,limm,u6 0011011001100001F111uuuuuu111110.  */
{ "mpywhfmr", 0x3661703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpywhfmr<.f><.cc> 0,limm,u6 0011011011100001F111uuuuuu1QQQQQ.  */
{ "mpywhfmr", 0x36E17020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpywhfmr<.f> 0,limm,s12 0011011010100001F111ssssssSSSSSS.  */
{ "mpywhfmr", 0x36A17000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpywhfmr<.f> a,limm,limm 0011011000100001F111111110AAAAAA.  */
{ "mpywhfmr", 0x36217F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpywhfmr<.f> 0,limm,limm 0011011000100001F111111110111110.  */
{ "mpywhfmr", 0x36217FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpywhfmr<.f><.cc> 0,limm,limm 0011011011100001F1111111100QQQQQ.  */
{ "mpywhfmr", 0x36E17F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpywhkl<.f> a,b,c 00110bbb00101010FBBBCCCCCCAAAAAA.  */
{ "mpywhkl", 0x302A0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mpywhkl<.f> 0,b,c 00110bbb00101010FBBBCCCCCC111110.  */
{ "mpywhkl", 0x302A003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* mpywhkl<.f><.cc> b,b,c 00110bbb11101010FBBBCCCCCC0QQQQQ.  */
{ "mpywhkl", 0x30EA0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpywhkl<.f> a,b,u6 00110bbb01101010FBBBuuuuuuAAAAAA.  */
{ "mpywhkl", 0x306A0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpywhkl<.f> 0,b,u6 00110bbb01101010FBBBuuuuuu111110.  */
{ "mpywhkl", 0x306A003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpywhkl<.f><.cc> b,b,u6 00110bbb11101010FBBBuuuuuu1QQQQQ.  */
{ "mpywhkl", 0x30EA0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpywhkl<.f> b,b,s12 00110bbb10101010FBBBssssssSSSSSS.  */
{ "mpywhkl", 0x30AA0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpywhkl<.f> a,limm,c 0011011000101010F111CCCCCCAAAAAA.  */
{ "mpywhkl", 0x362A7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mpywhkl<.f> a,b,limm 00110bbb00101010FBBB111110AAAAAA.  */
{ "mpywhkl", 0x302A0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mpywhkl<.f> 0,limm,c 0011011001101010F111CCCCCC111110.  */
{ "mpywhkl", 0x366A703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* mpywhkl<.f> 0,b,limm 00110bbb00101010FBBB111110111110.  */
{ "mpywhkl", 0x302A0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* mpywhkl<.f><.cc> b,b,limm 00110bbb11101010FBBB1111100QQQQQ.  */
{ "mpywhkl", 0x30EA0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpywhkl<.f><.cc> 0,limm,c 0011011011101010F111CCCCCC0QQQQQ.  */
{ "mpywhkl", 0x36EA7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpywhkl<.f> a,limm,u6 0011011001101010F111uuuuuuAAAAAA.  */
{ "mpywhkl", 0x366A7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpywhkl<.f> 0,limm,u6 0011011001101010F111uuuuuu111110.  */
{ "mpywhkl", 0x366A703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpywhkl<.f><.cc> 0,limm,u6 0011011011101010F111uuuuuu1QQQQQ.  */
{ "mpywhkl", 0x36EA7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpywhkl<.f> 0,limm,s12 0011011010101010F111ssssssSSSSSS.  */
{ "mpywhkl", 0x36AA7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpywhkl<.f> a,limm,limm 0011011000101010F111111110AAAAAA.  */
{ "mpywhkl", 0x362A7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpywhkl<.f> 0,limm,limm 0011011000101010F111111110111110.  */
{ "mpywhkl", 0x362A7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpywhkl<.f><.cc> 0,limm,limm 0011011011101010F1111111100QQQQQ.  */
{ "mpywhkl", 0x36EA7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpywhkul<.f> a,b,c 00110bbb00101011FBBBCCCCCCAAAAAA.  */
{ "mpywhkul", 0x302B0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mpywhkul<.f> 0,b,c 00110bbb00101011FBBBCCCCCC111110.  */
{ "mpywhkul", 0x302B003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* mpywhkul<.f><.cc> b,b,c 00110bbb11101011FBBBCCCCCC0QQQQQ.  */
{ "mpywhkul", 0x30EB0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpywhkul<.f> a,b,u6 00110bbb01101011FBBBuuuuuuAAAAAA.  */
{ "mpywhkul", 0x306B0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpywhkul<.f> 0,b,u6 00110bbb01101011FBBBuuuuuu111110.  */
{ "mpywhkul", 0x306B003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpywhkul<.f><.cc> b,b,u6 00110bbb11101011FBBBuuuuuu1QQQQQ.  */
{ "mpywhkul", 0x30EB0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpywhkul<.f> b,b,s12 00110bbb10101011FBBBssssssSSSSSS.  */
{ "mpywhkul", 0x30AB0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpywhkul<.f> a,limm,c 0011011000101011F111CCCCCCAAAAAA.  */
{ "mpywhkul", 0x362B7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mpywhkul<.f> a,b,limm 00110bbb00101011FBBB111110AAAAAA.  */
{ "mpywhkul", 0x302B0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mpywhkul<.f> 0,limm,c 0011011001101011F111CCCCCC111110.  */
{ "mpywhkul", 0x366B703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* mpywhkul<.f> 0,b,limm 00110bbb00101011FBBB111110111110.  */
{ "mpywhkul", 0x302B0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* mpywhkul<.f><.cc> b,b,limm 00110bbb11101011FBBB1111100QQQQQ.  */
{ "mpywhkul", 0x30EB0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpywhkul<.f><.cc> 0,limm,c 0011011011101011F111CCCCCC0QQQQQ.  */
{ "mpywhkul", 0x36EB7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpywhkul<.f> a,limm,u6 0011011001101011F111uuuuuuAAAAAA.  */
{ "mpywhkul", 0x366B7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpywhkul<.f> 0,limm,u6 0011011001101011F111uuuuuu111110.  */
{ "mpywhkul", 0x366B703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpywhkul<.f><.cc> 0,limm,u6 0011011011101011F111uuuuuu1QQQQQ.  */
{ "mpywhkul", 0x36EB7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpywhkul<.f> 0,limm,s12 0011011010101011F111ssssssSSSSSS.  */
{ "mpywhkul", 0x36AB7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpywhkul<.f> a,limm,limm 0011011000101011F111111110AAAAAA.  */
{ "mpywhkul", 0x362B7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpywhkul<.f> 0,limm,limm 0011011000101011F111111110111110.  */
{ "mpywhkul", 0x362B7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpywhkul<.f><.cc> 0,limm,limm 0011011011101011F1111111100QQQQQ.  */
{ "mpywhkul", 0x36EB7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpywhl<.f> a,b,c 00110bbb00011100FBBBCCCCCCAAAAAA.  */
{ "mpywhl", 0x301C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mpywhl<.f> 0,b,c 00110bbb00011100FBBBCCCCCC111110.  */
{ "mpywhl", 0x301C003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* mpywhl<.f><.cc> b,b,c 00110bbb11011100FBBBCCCCCC0QQQQQ.  */
{ "mpywhl", 0x30DC0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpywhl<.f> a,b,u6 00110bbb01011100FBBBuuuuuuAAAAAA.  */
{ "mpywhl", 0x305C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpywhl<.f> 0,b,u6 00110bbb01011100FBBBuuuuuu111110.  */
{ "mpywhl", 0x305C003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpywhl<.f><.cc> b,b,u6 00110bbb11011100FBBBuuuuuu1QQQQQ.  */
{ "mpywhl", 0x30DC0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpywhl<.f> b,b,s12 00110bbb10011100FBBBssssssSSSSSS.  */
{ "mpywhl", 0x309C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpywhl<.f> a,limm,c 0011011000011100F111CCCCCCAAAAAA.  */
{ "mpywhl", 0x361C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mpywhl<.f> a,b,limm 00110bbb00011100FBBB111110AAAAAA.  */
{ "mpywhl", 0x301C0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mpywhl<.f> 0,limm,c 0011011000011100F111CCCCCC111110.  */
{ "mpywhl", 0x361C703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* mpywhl<.f> 0,b,limm 00110bbb00011100FBBB111110111110.  */
{ "mpywhl", 0x301C0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* mpywhl<.f><.cc> b,b,limm 00110bbb11011100FBBB1111100QQQQQ.  */
{ "mpywhl", 0x30DC0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpywhl<.f><.cc> 0,limm,c 0011011011011100F111CCCCCC0QQQQQ.  */
{ "mpywhl", 0x36DC7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpywhl<.f> a,limm,u6 0011011001011100F111uuuuuuAAAAAA.  */
{ "mpywhl", 0x365C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpywhl<.f> 0,limm,u6 0011011001011100F111uuuuuu111110.  */
{ "mpywhl", 0x365C703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpywhl<.f><.cc> 0,limm,u6 0011011011011100F111uuuuuu1QQQQQ.  */
{ "mpywhl", 0x36DC7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpywhl<.f> 0,limm,s12 0011011010011100F111ssssssSSSSSS.  */
{ "mpywhl", 0x369C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpywhl<.f> a,limm,limm 0011011000011100F111111110AAAAAA.  */
{ "mpywhl", 0x361C7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpywhl<.f> 0,limm,limm 0011011000011100F111111110111110.  */
{ "mpywhl", 0x361C7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpywhl<.f><.cc> 0,limm,limm 0011011011011100F1111111100QQQQQ.  */
{ "mpywhl", 0x36DC7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpywhul<.f> a,b,c 00110bbb00011110FBBBCCCCCCAAAAAA.  */
{ "mpywhul", 0x301E0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mpywhul<.f> 0,b,c 00110bbb00011110FBBBCCCCCC111110.  */
{ "mpywhul", 0x301E003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* mpywhul<.f><.cc> b,b,c 00110bbb11011110FBBBCCCCCC0QQQQQ.  */
{ "mpywhul", 0x30DE0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpywhul<.f> a,b,u6 00110bbb01011110FBBBuuuuuuAAAAAA.  */
{ "mpywhul", 0x305E0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpywhul<.f> 0,b,u6 00110bbb01011110FBBBuuuuuu111110.  */
{ "mpywhul", 0x305E003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpywhul<.f><.cc> b,b,u6 00110bbb11011110FBBBuuuuuu1QQQQQ.  */
{ "mpywhul", 0x30DE0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpywhul<.f> b,b,s12 00110bbb10011110FBBBssssssSSSSSS.  */
{ "mpywhul", 0x309E0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpywhul<.f> a,limm,c 0011011000011110F111CCCCCCAAAAAA.  */
{ "mpywhul", 0x361E7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mpywhul<.f> a,b,limm 00110bbb00011110FBBB111110AAAAAA.  */
{ "mpywhul", 0x301E0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mpywhul<.f> 0,limm,c 0011011000011110F111CCCCCC111110.  */
{ "mpywhul", 0x361E703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* mpywhul<.f> 0,b,limm 00110bbb00011110FBBB111110111110.  */
{ "mpywhul", 0x301E0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* mpywhul<.f><.cc> b,b,limm 00110bbb11011110FBBB1111100QQQQQ.  */
{ "mpywhul", 0x30DE0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpywhul<.f><.cc> 0,limm,c 0011011011011110F111CCCCCC0QQQQQ.  */
{ "mpywhul", 0x36DE7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpywhul<.f> a,limm,u6 0011011001011110F111uuuuuuAAAAAA.  */
{ "mpywhul", 0x365E7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpywhul<.f> 0,limm,u6 0011011001011110F111uuuuuu111110.  */
{ "mpywhul", 0x365E703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpywhul<.f><.cc> 0,limm,u6 0011011011011110F111uuuuuu1QQQQQ.  */
{ "mpywhul", 0x36DE7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpywhul<.f> 0,limm,s12 0011011010011110F111ssssssSSSSSS.  */
{ "mpywhul", 0x369E7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpywhul<.f> a,limm,limm 0011011000011110F111111110AAAAAA.  */
{ "mpywhul", 0x361E7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpywhul<.f> 0,limm,limm 0011011000011110F111111110111110.  */
{ "mpywhul", 0x361E7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpywhul<.f><.cc> 0,limm,limm 0011011011011110F1111111100QQQQQ.  */
{ "mpywhul", 0x36DE7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpyw_s b,b,c 01111bbbccc01001.  */
{ "mpyw_s", 0x00007809, 0x0000F81F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY1E, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* mpy_s b,b,c 01111bbbccc01100.  */
{ "mpy_s", 0x0000780C, 0x0000F81F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, MPY, MPY6E, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* msubdf<.f> a,b,c 00110bbb00010101FBBBCCCCCCAAAAAA.  */
{ "msubdf", 0x30150000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* msubdf<.f> 0,b,c 00110bbb00010101FBBBCCCCCC111110.  */
{ "msubdf", 0x3015003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* msubdf<.f><.cc> b,b,c 00110bbb11010101FBBBCCCCCC0QQQQQ.  */
{ "msubdf", 0x30D50000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* msubdf<.f> a,b,u6 00110bbb01010101FBBBuuuuuuAAAAAA.  */
{ "msubdf", 0x30550000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* msubdf<.f> 0,b,u6 00110bbb01010101FBBBuuuuuu111110.  */
{ "msubdf", 0x3055003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* msubdf<.f><.cc> b,b,u6 00110bbb11010101FBBBuuuuuu1QQQQQ.  */
{ "msubdf", 0x30D50020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* msubdf<.f> b,b,s12 00110bbb10010101FBBBssssssSSSSSS.  */
{ "msubdf", 0x30950000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* msubdf<.f> a,limm,c 0011011000010101F111CCCCCCAAAAAA.  */
{ "msubdf", 0x36157000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* msubdf<.f> a,b,limm 00110bbb00010101FBBB111110AAAAAA.  */
{ "msubdf", 0x30150F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* msubdf<.f> 0,limm,c 0011011000010101F111CCCCCC111110.  */
{ "msubdf", 0x3615703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* msubdf<.f> 0,b,limm 00110bbb00010101FBBB111110111110.  */
{ "msubdf", 0x30150FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* msubdf<.f><.cc> b,b,limm 00110bbb11010101FBBB1111100QQQQQ.  */
{ "msubdf", 0x30D50F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* msubdf<.f><.cc> 0,limm,c 0011011011010101F111CCCCCC0QQQQQ.  */
{ "msubdf", 0x36D57000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* msubdf<.f> a,limm,u6 0011011001010101F111uuuuuuAAAAAA.  */
{ "msubdf", 0x36557000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* msubdf<.f> 0,limm,u6 0011011001010101F111uuuuuu111110.  */
{ "msubdf", 0x3655703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* msubdf<.f><.cc> 0,limm,u6 0011011011010101F111uuuuuu1QQQQQ.  */
{ "msubdf", 0x36D57020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* msubdf<.f> 0,limm,s12 0011011010010101F111ssssssSSSSSS.  */
{ "msubdf", 0x36957000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* msubdf<.f> a,limm,limm 0011011000010101F111111110AAAAAA.  */
{ "msubdf", 0x36157F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* msubdf<.f> 0,limm,limm 0011011000010101F111111110111110.  */
{ "msubdf", 0x36157FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* msubdf<.f><.cc> 0,limm,limm 0011011011010101F1111111100QQQQQ.  */
{ "msubdf", 0x36D57F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* msubdw<.f> a,b,c 00101bbb00010100FBBBCCCCCCAAAAAA.  */
{ "msubdw", 0x28140000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* msubdw<.f> 0,b,c 00101bbb00010100FBBBCCCCCC111110.  */
{ "msubdw", 0x2814003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* msubdw<.f><.cc> b,b,c 00101bbb11010100FBBBCCCCCC0QQQQQ.  */
{ "msubdw", 0x28D40000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* msubdw<.f> a,b,u6 00101bbb01010100FBBBuuuuuuAAAAAA.  */
{ "msubdw", 0x28540000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* msubdw<.f> 0,b,u6 00101bbb01010100FBBBuuuuuu111110.  */
{ "msubdw", 0x2854003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* msubdw<.f><.cc> b,b,u6 00101bbb11010100FBBBuuuuuu1QQQQQ.  */
{ "msubdw", 0x28D40020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* msubdw<.f> b,b,s12 00101bbb10010100FBBBssssssSSSSSS.  */
{ "msubdw", 0x28940000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* msubdw<.f> a,limm,c 0010111000010100F111CCCCCCAAAAAA.  */
{ "msubdw", 0x2E147000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* msubdw<.f> a,b,limm 00101bbb00010100FBBB111110AAAAAA.  */
{ "msubdw", 0x28140F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* msubdw<.f> 0,limm,c 0010111000010100F111CCCCCC111110.  */
{ "msubdw", 0x2E14703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* msubdw<.f> 0,b,limm 00101bbb00010100FBBB111110111110.  */
{ "msubdw", 0x28140FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* msubdw<.f><.cc> 0,limm,c 0010111011010100F111CCCCCC0QQQQQ.  */
{ "msubdw", 0x2ED47000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* msubdw<.f><.cc> b,b,limm 00101bbb11010100FBBB1111100QQQQQ.  */
{ "msubdw", 0x28D40F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* msubdw<.f> a,limm,u6 0010111001010100F111uuuuuuAAAAAA.  */
{ "msubdw", 0x2E547000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* msubdw<.f> 0,limm,u6 0010111001010100F111uuuuuu111110.  */
{ "msubdw", 0x2E54703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* msubdw<.f><.cc> 0,limm,u6 0010111011010100F111uuuuuu1QQQQQ.  */
{ "msubdw", 0x2ED47020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* msubdw<.f> 0,limm,s12 0010111010010100F111ssssssSSSSSS.  */
{ "msubdw", 0x2E947000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* msubdw<.f> a,limm,limm 0010111000010100F111111110AAAAAA.  */
{ "msubdw", 0x2E147F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* msubdw<.f> 0,limm,limm 0010111000010100F111111110111110.  */
{ "msubdw", 0x2E147FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* msubdw<.f><.cc> 0,limm,limm 0010111011010100F1111111100QQQQQ.  */
{ "msubdw", 0x2ED47F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* msubf<.f> a,b,c 00110bbb00001110FBBBCCCCCCAAAAAA.  */
{ "msubf", 0x300E0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* msubf<.f> 0,b,c 00110bbb00001110FBBBCCCCCC111110.  */
{ "msubf", 0x300E003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* msubf<.f><.cc> b,b,c 00110bbb11001110FBBBCCCCCC0QQQQQ.  */
{ "msubf", 0x30CE0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* msubf<.f> a,b,u6 00110bbb01001110FBBBuuuuuuAAAAAA.  */
{ "msubf", 0x304E0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* msubf<.f> 0,b,u6 00110bbb01001110FBBBuuuuuu111110.  */
{ "msubf", 0x304E003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* msubf<.f><.cc> b,b,u6 00110bbb11001110FBBBuuuuuu1QQQQQ.  */
{ "msubf", 0x30CE0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* msubf<.f> b,b,s12 00110bbb10001110FBBBssssssSSSSSS.  */
{ "msubf", 0x308E0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* msubf<.f> a,limm,c 0011011000001110F111CCCCCCAAAAAA.  */
{ "msubf", 0x360E7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* msubf<.f> a,b,limm 00110bbb00001110FBBB111110AAAAAA.  */
{ "msubf", 0x300E0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* msubf<.f> 0,limm,c 0011011000001110F111CCCCCC111110.  */
{ "msubf", 0x360E703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* msubf<.f> 0,b,limm 00110bbb00001110FBBB111110111110.  */
{ "msubf", 0x300E0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* msubf<.f><.cc> b,b,limm 00110bbb11001110FBBB1111100QQQQQ.  */
{ "msubf", 0x30CE0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* msubf<.f><.cc> 0,limm,c 0011011011001110F111CCCCCC0QQQQQ.  */
{ "msubf", 0x36CE7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* msubf<.f> a,limm,u6 0011011001001110F111uuuuuuAAAAAA.  */
{ "msubf", 0x364E7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* msubf<.f> 0,limm,u6 0011011001001110F111uuuuuu111110.  */
{ "msubf", 0x364E703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* msubf<.f><.cc> 0,limm,u6 0011011011001110F111uuuuuu1QQQQQ.  */
{ "msubf", 0x36CE7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* msubf<.f> 0,limm,s12 0011011010001110F111ssssssSSSSSS.  */
{ "msubf", 0x368E7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* msubf<.f> a,limm,limm 0011011000001110F111111110AAAAAA.  */
{ "msubf", 0x360E7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* msubf<.f> 0,limm,limm 0011011000001110F111111110111110.  */
{ "msubf", 0x360E7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* msubf<.f><.cc> 0,limm,limm 0011011011001110F1111111100QQQQQ.  */
{ "msubf", 0x36CE7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* msubfr<.f> a,b,c 00110bbb00001111FBBBCCCCCCAAAAAA.  */
{ "msubfr", 0x300F0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* msubfr<.f> 0,b,c 00110bbb00001111FBBBCCCCCC111110.  */
{ "msubfr", 0x300F003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* msubfr<.f><.cc> b,b,c 00110bbb11001111FBBBCCCCCC0QQQQQ.  */
{ "msubfr", 0x30CF0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* msubfr<.f> a,b,u6 00110bbb01001111FBBBuuuuuuAAAAAA.  */
{ "msubfr", 0x304F0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* msubfr<.f> 0,b,u6 00110bbb01001111FBBBuuuuuu111110.  */
{ "msubfr", 0x304F003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* msubfr<.f><.cc> b,b,u6 00110bbb11001111FBBBuuuuuu1QQQQQ.  */
{ "msubfr", 0x30CF0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* msubfr<.f> b,b,s12 00110bbb10001111FBBBssssssSSSSSS.  */
{ "msubfr", 0x308F0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* msubfr<.f> a,limm,c 0011011000001111F111CCCCCCAAAAAA.  */
{ "msubfr", 0x360F7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* msubfr<.f> a,b,limm 00110bbb00001111FBBB111110AAAAAA.  */
{ "msubfr", 0x300F0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* msubfr<.f> 0,limm,c 0011011000001111F111CCCCCC111110.  */
{ "msubfr", 0x360F703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* msubfr<.f> 0,b,limm 00110bbb00001111FBBB111110111110.  */
{ "msubfr", 0x300F0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* msubfr<.f><.cc> b,b,limm 00110bbb11001111FBBB1111100QQQQQ.  */
{ "msubfr", 0x30CF0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* msubfr<.f><.cc> 0,limm,c 0011011011001111F111CCCCCC0QQQQQ.  */
{ "msubfr", 0x36CF7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* msubfr<.f> a,limm,u6 0011011001001111F111uuuuuuAAAAAA.  */
{ "msubfr", 0x364F7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* msubfr<.f> 0,limm,u6 0011011001001111F111uuuuuu111110.  */
{ "msubfr", 0x364F703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* msubfr<.f><.cc> 0,limm,u6 0011011011001111F111uuuuuu1QQQQQ.  */
{ "msubfr", 0x36CF7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* msubfr<.f> 0,limm,s12 0011011010001111F111ssssssSSSSSS.  */
{ "msubfr", 0x368F7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* msubfr<.f> a,limm,limm 0011011000001111F111111110AAAAAA.  */
{ "msubfr", 0x360F7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* msubfr<.f> 0,limm,limm 0011011000001111F111111110111110.  */
{ "msubfr", 0x360F7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* msubfr<.f><.cc> 0,limm,limm 0011011011001111F1111111100QQQQQ.  */
{ "msubfr", 0x36CF7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* msubt<.f> a,b,c 00101bbb00100000FBBBCCCCCCAAAAAA.  */
{ "msubt", 0x28200000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* msubt<.f> 0,b,c 00101bbb00100000FBBBCCCCCC111110.  */
{ "msubt", 0x2820003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* msubt<.f><.cc> b,b,c 00101bbb11100000FBBBCCCCCC0QQQQQ.  */
{ "msubt", 0x28E00000, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* msubt<.f> a,b,u6 00101bbb01100000FBBBuuuuuuAAAAAA.  */
{ "msubt", 0x28600000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* msubt<.f> 0,b,u6 00101bbb01100000FBBBuuuuuu111110.  */
{ "msubt", 0x2860003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* msubt<.f><.cc> b,b,u6 00101bbb11100000FBBBuuuuuu1QQQQQ.  */
{ "msubt", 0x28E00020, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* msubt<.f> b,b,s12 00101bbb10100000FBBBssssssSSSSSS.  */
{ "msubt", 0x28A00000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* msubt<.f> a,limm,c 0010111000100000F111CCCCCCAAAAAA.  */
{ "msubt", 0x2E207000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* msubt<.f> a,b,limm 00101bbb00100000FBBB111110AAAAAA.  */
{ "msubt", 0x28200F80, 0xF8FF0FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* msubt<.f> 0,limm,c 0010111000100000F111CCCCCC111110.  */
{ "msubt", 0x2E20703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* msubt<.f> 0,b,limm 00101bbb00100000FBBB111110111110.  */
{ "msubt", 0x28200FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* msubt<.f><.cc> 0,limm,c 0010111011100000F111CCCCCC0QQQQQ.  */
{ "msubt", 0x2EE07000, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* msubt<.f><.cc> b,b,limm 00101bbb11100000FBBB1111100QQQQQ.  */
{ "msubt", 0x28E00F80, 0xF8FF0FE0, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* msubt<.f> a,limm,u6 0010111001100000F111uuuuuuAAAAAA.  */
{ "msubt", 0x2E607000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* msubt<.f> 0,limm,u6 0010111001100000F111uuuuuu111110.  */
{ "msubt", 0x2E60703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* msubt<.f><.cc> 0,limm,u6 0010111011100000F111uuuuuu1QQQQQ.  */
{ "msubt", 0x2EE07020, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* msubt<.f> 0,limm,s12 0010111010100000F111ssssssSSSSSS.  */
{ "msubt", 0x2EA07000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* msubt<.f> a,limm,limm 0010111000100000F111111110AAAAAA.  */
{ "msubt", 0x2E207F80, 0xFFFF7FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* msubt<.f> 0,limm,limm 0010111000100000F111111110111110.  */
{ "msubt", 0x2E207FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* msubt<.f><.cc> 0,limm,limm 0010111011100000F1111111100QQQQQ.  */
{ "msubt", 0x2EE07F80, 0xFFFF7FE0, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* msubwhfl<.f> a,b,c 00110bbb00010100FBBBCCCCCCAAAAAA.  */
{ "msubwhfl", 0x30140000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* msubwhfl<.f> 0,b,c 00110bbb00010100FBBBCCCCCC111110.  */
{ "msubwhfl", 0x3014003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* msubwhfl<.f><.cc> b,b,c 00110bbb11010100FBBBCCCCCC0QQQQQ.  */
{ "msubwhfl", 0x30D40000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* msubwhfl<.f> a,b,u6 00110bbb01010100FBBBuuuuuuAAAAAA.  */
{ "msubwhfl", 0x30540000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* msubwhfl<.f> 0,b,u6 00110bbb01010100FBBBuuuuuu111110.  */
{ "msubwhfl", 0x3054003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* msubwhfl<.f><.cc> b,b,u6 00110bbb11010100FBBBuuuuuu1QQQQQ.  */
{ "msubwhfl", 0x30D40020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* msubwhfl<.f> b,b,s12 00110bbb10010100FBBBssssssSSSSSS.  */
{ "msubwhfl", 0x30940000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* msubwhfl<.f> a,limm,c 0011011000010100F111CCCCCCAAAAAA.  */
{ "msubwhfl", 0x36147000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* msubwhfl<.f> a,b,limm 00110bbb00010100FBBB111110AAAAAA.  */
{ "msubwhfl", 0x30140F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* msubwhfl<.f> 0,limm,c 0011011000010100F111CCCCCC111110.  */
{ "msubwhfl", 0x3614703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* msubwhfl<.f> 0,b,limm 00110bbb00010100FBBB111110111110.  */
{ "msubwhfl", 0x30140FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* msubwhfl<.f><.cc> b,b,limm 00110bbb11010100FBBB1111100QQQQQ.  */
{ "msubwhfl", 0x30D40F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* msubwhfl<.f><.cc> 0,limm,c 0011011011010100F111CCCCCC0QQQQQ.  */
{ "msubwhfl", 0x36D47000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* msubwhfl<.f> a,limm,u6 0011011001010100F111uuuuuuAAAAAA.  */
{ "msubwhfl", 0x36547000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* msubwhfl<.f> 0,limm,u6 0011011001010100F111uuuuuu111110.  */
{ "msubwhfl", 0x3654703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* msubwhfl<.f><.cc> 0,limm,u6 0011011011010100F111uuuuuu1QQQQQ.  */
{ "msubwhfl", 0x36D47020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* msubwhfl<.f> 0,limm,s12 0011011010010100F111ssssssSSSSSS.  */
{ "msubwhfl", 0x36947000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* msubwhfl<.f> a,limm,limm 0011011000010100F111111110AAAAAA.  */
{ "msubwhfl", 0x36147F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* msubwhfl<.f> 0,limm,limm 0011011000010100F111111110111110.  */
{ "msubwhfl", 0x36147FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* msubwhfl<.f><.cc> 0,limm,limm 0011011011010100F1111111100QQQQQ.  */
{ "msubwhfl", 0x36D47F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* msubwhflr<.f> a,b,c 00110bbb00011010FBBBCCCCCCAAAAAA.  */
{ "msubwhflr", 0x301A0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* msubwhflr<.f> 0,b,c 00110bbb00011010FBBBCCCCCC111110.  */
{ "msubwhflr", 0x301A003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* msubwhflr<.f><.cc> b,b,c 00110bbb11011010FBBBCCCCCC0QQQQQ.  */
{ "msubwhflr", 0x30DA0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* msubwhflr<.f> a,b,u6 00110bbb01011010FBBBuuuuuuAAAAAA.  */
{ "msubwhflr", 0x305A0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* msubwhflr<.f> 0,b,u6 00110bbb01011010FBBBuuuuuu111110.  */
{ "msubwhflr", 0x305A003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* msubwhflr<.f><.cc> b,b,u6 00110bbb11011010FBBBuuuuuu1QQQQQ.  */
{ "msubwhflr", 0x30DA0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* msubwhflr<.f> b,b,s12 00110bbb10011010FBBBssssssSSSSSS.  */
{ "msubwhflr", 0x309A0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* msubwhflr<.f> a,limm,c 0011011000011010F111CCCCCCAAAAAA.  */
{ "msubwhflr", 0x361A7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* msubwhflr<.f> a,b,limm 00110bbb00011010FBBB111110AAAAAA.  */
{ "msubwhflr", 0x301A0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* msubwhflr<.f> 0,limm,c 0011011000011010F111CCCCCC111110.  */
{ "msubwhflr", 0x361A703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* msubwhflr<.f> 0,b,limm 00110bbb00011010FBBB111110111110.  */
{ "msubwhflr", 0x301A0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* msubwhflr<.f><.cc> b,b,limm 00110bbb11011010FBBB1111100QQQQQ.  */
{ "msubwhflr", 0x30DA0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* msubwhflr<.f><.cc> 0,limm,c 0011011011011010F111CCCCCC0QQQQQ.  */
{ "msubwhflr", 0x36DA7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* msubwhflr<.f> a,limm,u6 0011011001011010F111uuuuuuAAAAAA.  */
{ "msubwhflr", 0x365A7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* msubwhflr<.f> 0,limm,u6 0011011001011010F111uuuuuu111110.  */
{ "msubwhflr", 0x365A703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* msubwhflr<.f><.cc> 0,limm,u6 0011011011011010F111uuuuuu1QQQQQ.  */
{ "msubwhflr", 0x36DA7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* msubwhflr<.f> 0,limm,s12 0011011010011010F111ssssssSSSSSS.  */
{ "msubwhflr", 0x369A7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* msubwhflr<.f> a,limm,limm 0011011000011010F111111110AAAAAA.  */
{ "msubwhflr", 0x361A7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* msubwhflr<.f> 0,limm,limm 0011011000011010F111111110111110.  */
{ "msubwhflr", 0x361A7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* msubwhflr<.f><.cc> 0,limm,limm 0011011011011010F1111111100QQQQQ.  */
{ "msubwhflr", 0x36DA7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* msubwhfm<.f> a,b,c 00110bbb00101100FBBBCCCCCCAAAAAA.  */
{ "msubwhfm", 0x302C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* msubwhfm<.f> 0,b,c 00110bbb00101100FBBBCCCCCC111110.  */
{ "msubwhfm", 0x302C003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* msubwhfm<.f><.cc> b,b,c 00110bbb11101100FBBBCCCCCC0QQQQQ.  */
{ "msubwhfm", 0x30EC0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* msubwhfm<.f> a,b,u6 00110bbb01101100FBBBuuuuuuAAAAAA.  */
{ "msubwhfm", 0x306C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* msubwhfm<.f> 0,b,u6 00110bbb01101100FBBBuuuuuu111110.  */
{ "msubwhfm", 0x306C003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* msubwhfm<.f><.cc> b,b,u6 00110bbb11101100FBBBuuuuuu1QQQQQ.  */
{ "msubwhfm", 0x30EC0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* msubwhfm<.f> b,b,s12 00110bbb10101100FBBBssssssSSSSSS.  */
{ "msubwhfm", 0x30AC0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* msubwhfm<.f> a,limm,c 0011011000101100F111CCCCCCAAAAAA.  */
{ "msubwhfm", 0x362C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* msubwhfm<.f> a,b,limm 00110bbb00101100FBBB111110AAAAAA.  */
{ "msubwhfm", 0x302C0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* msubwhfm<.f> 0,limm,c 0011011001101100F111CCCCCC111110.  */
{ "msubwhfm", 0x366C703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* msubwhfm<.f> 0,b,limm 00110bbb00101100FBBB111110111110.  */
{ "msubwhfm", 0x302C0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* msubwhfm<.f><.cc> b,b,limm 00110bbb11101100FBBB1111100QQQQQ.  */
{ "msubwhfm", 0x30EC0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* msubwhfm<.f><.cc> 0,limm,c 0011011011101100F111CCCCCC0QQQQQ.  */
{ "msubwhfm", 0x36EC7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* msubwhfm<.f> a,limm,u6 0011011001101100F111uuuuuuAAAAAA.  */
{ "msubwhfm", 0x366C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* msubwhfm<.f> 0,limm,u6 0011011001101100F111uuuuuu111110.  */
{ "msubwhfm", 0x366C703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* msubwhfm<.f><.cc> 0,limm,u6 0011011011101100F111uuuuuu1QQQQQ.  */
{ "msubwhfm", 0x36EC7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* msubwhfm<.f> 0,limm,s12 0011011010101100F111ssssssSSSSSS.  */
{ "msubwhfm", 0x36AC7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* msubwhfm<.f> a,limm,limm 0011011000101100F111111110AAAAAA.  */
{ "msubwhfm", 0x362C7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* msubwhfm<.f> 0,limm,limm 0011011000101100F111111110111110.  */
{ "msubwhfm", 0x362C7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* msubwhfm<.f><.cc> 0,limm,limm 0011011011101100F1111111100QQQQQ.  */
{ "msubwhfm", 0x36EC7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* msubwhfmr<.f> a,b,c 00110bbb00101101FBBBCCCCCCAAAAAA.  */
{ "msubwhfmr", 0x302D0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* msubwhfmr<.f> 0,b,c 00110bbb00101101FBBBCCCCCC111110.  */
{ "msubwhfmr", 0x302D003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* msubwhfmr<.f><.cc> b,b,c 00110bbb11101101FBBBCCCCCC0QQQQQ.  */
{ "msubwhfmr", 0x30ED0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* msubwhfmr<.f> a,b,u6 00110bbb01101101FBBBuuuuuuAAAAAA.  */
{ "msubwhfmr", 0x306D0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* msubwhfmr<.f> 0,b,u6 00110bbb01101101FBBBuuuuuu111110.  */
{ "msubwhfmr", 0x306D003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* msubwhfmr<.f><.cc> b,b,u6 00110bbb11101101FBBBuuuuuu1QQQQQ.  */
{ "msubwhfmr", 0x30ED0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* msubwhfmr<.f> b,b,s12 00110bbb10101101FBBBssssssSSSSSS.  */
{ "msubwhfmr", 0x30AD0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* msubwhfmr<.f> a,limm,c 0011011000101101F111CCCCCCAAAAAA.  */
{ "msubwhfmr", 0x362D7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* msubwhfmr<.f> a,b,limm 00110bbb00101101FBBB111110AAAAAA.  */
{ "msubwhfmr", 0x302D0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* msubwhfmr<.f> 0,limm,c 0011011001101101F111CCCCCC111110.  */
{ "msubwhfmr", 0x366D703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* msubwhfmr<.f> 0,b,limm 00110bbb00101101FBBB111110111110.  */
{ "msubwhfmr", 0x302D0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* msubwhfmr<.f><.cc> b,b,limm 00110bbb11101101FBBB1111100QQQQQ.  */
{ "msubwhfmr", 0x30ED0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* msubwhfmr<.f><.cc> 0,limm,c 0011011011101101F111CCCCCC0QQQQQ.  */
{ "msubwhfmr", 0x36ED7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* msubwhfmr<.f> a,limm,u6 0011011001101101F111uuuuuuAAAAAA.  */
{ "msubwhfmr", 0x366D7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* msubwhfmr<.f> 0,limm,u6 0011011001101101F111uuuuuu111110.  */
{ "msubwhfmr", 0x366D703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* msubwhfmr<.f><.cc> 0,limm,u6 0011011011101101F111uuuuuu1QQQQQ.  */
{ "msubwhfmr", 0x36ED7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* msubwhfmr<.f> 0,limm,s12 0011011010101101F111ssssssSSSSSS.  */
{ "msubwhfmr", 0x36AD7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* msubwhfmr<.f> a,limm,limm 0011011000101101F111111110AAAAAA.  */
{ "msubwhfmr", 0x362D7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* msubwhfmr<.f> 0,limm,limm 0011011000101101F111111110111110.  */
{ "msubwhfmr", 0x362D7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* msubwhfmr<.f><.cc> 0,limm,limm 0011011011101101F1111111100QQQQQ.  */
{ "msubwhfmr", 0x36ED7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mul64 0,b,c 00101bbb000001000BBBCCCCCC111110.  */
{ "mul64", 0x2804003E, 0xF8FF803F, ARC_OPCODE_ARC600, MPY, NONE, { ZA, RB, RC }, { 0 }},

/* mul64<.cc> 0,b,c 00101bbb110001000BBBCCCCCC0QQQQQ.  */
{ "mul64", 0x28C40000, 0xF8FF8020, ARC_OPCODE_ARC600, MPY, NONE, { ZA, RB, RC }, { C_CC }},

/* mul64 0,b,u6 00101bbb010001000BBBuuuuuu111110.  */
{ "mul64", 0x2844003E, 0xF8FF803F, ARC_OPCODE_ARC600, MPY, NONE, { ZA, RB, UIMM6_20 }, { 0 }},

/* mul64<.cc> 0,b,u6 00101bbb110001000BBBuuuuuu1QQQQQ.  */
{ "mul64", 0x28C40020, 0xF8FF8020, ARC_OPCODE_ARC600, MPY, NONE, { ZA, RB, UIMM6_20 }, { C_CC }},

/* mul64 0,b,s12 00101bbb100001000BBBssssssSSSSSS.  */
{ "mul64", 0x28840000, 0xF8FF8000, ARC_OPCODE_ARC600, MPY, NONE, { ZA, RB, SIMM12_20 }, { 0 }},

/* mul64 0,limm,c 00101110000001000111CCCCCC111110.  */
{ "mul64", 0x2E04703E, 0xFFFFF03F, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, RC }, { 0 }},

/* mul64 0,b,limm 00101bbb000001000BBB111110111110.  */
{ "mul64", 0x28040FBE, 0xF8FF8FFF, ARC_OPCODE_ARC600, MPY, NONE, { ZA, RB, LIMM }, { 0 }},

/* mul64<.cc> 0,limm,c 00101110110001000111CCCCCC0QQQQQ.  */
{ "mul64", 0x2EC47000, 0xFFFFF020, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, RC }, { C_CC }},

/* mul64<.cc> 0,b,limm 00101bbb110001000BBB1111100QQQQQ.  */
{ "mul64", 0x28C40F80, 0xF8FF8FE0, ARC_OPCODE_ARC600, MPY, NONE, { ZA, RB, LIMM }, { C_CC }},

/* mul64 0,limm,u6 00101110010001000111uuuuuu111110.  */
{ "mul64", 0x2E44703E, 0xFFFFF03F, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* mul64<.cc> 0,limm,u6 00101110110001000111uuuuuu1QQQQQ.  */
{ "mul64", 0x2EC47020, 0xFFFFF020, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* mul64 0,limm,s12 00101110100001000111ssssssSSSSSS.  */
{ "mul64", 0x2E847000, 0xFFFFF000, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* mul64 0,limm,limm 00101110000001000111111110111110.  */
{ "mul64", 0x2E047FBE, 0xFFFFFFFF, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, LIMMdup }, { 0 }},

/* mul64<.cc> 0,limm,limm 001011101100010001111111100QQQQQ.  */
{ "mul64", 0x2EC47F80, 0xFFFFFFE0, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, LIMMdup }, { C_CC }},

/* mul64 0,b,c 00101bbb000001000BBBCCCCCC111110.  */
{ "mul64", 0x2804003E, 0xF8FF803F, ARC_OPCODE_ARC600, MPY, NONE, { RB, RC }, { 0 }},

/* mul64<.cc> 0,b,c 00101bbb110001000BBBCCCCCC0QQQQQ.  */
{ "mul64", 0x28C40000, 0xF8FF8020, ARC_OPCODE_ARC600, MPY, NONE, { RB, RC }, { C_CC }},

/* mul64 0,b,u6 00101bbb010001000BBBuuuuuu111110.  */
{ "mul64", 0x2844003E, 0xF8FF803F, ARC_OPCODE_ARC600, MPY, NONE, { RB, UIMM6_20 }, { 0 }},

/* mul64<.cc> 0,b,u6 00101bbb110001000BBBuuuuuu1QQQQQ.  */
{ "mul64", 0x28C40020, 0xF8FF8020, ARC_OPCODE_ARC600, MPY, NONE, { RB, UIMM6_20 }, { C_CC }},

/* mul64 0,b,s12 00101bbb100001000BBBssssssSSSSSS.  */
{ "mul64", 0x28840000, 0xF8FF8000, ARC_OPCODE_ARC600, MPY, NONE, { RB, SIMM12_20 }, { 0 }},

/* mul64 0,limm,c 00101110000001000111CCCCCC111110.  */
{ "mul64", 0x2E04703E, 0xFFFFF03F, ARC_OPCODE_ARC600, MPY, NONE, { LIMM, RC }, { 0 }},

/* mul64 0,b,limm 00101bbb000001000BBB111110111110.  */
{ "mul64", 0x28040FBE, 0xF8FF8FFF, ARC_OPCODE_ARC600, MPY, NONE, { RB, LIMM }, { 0 }},

/* mul64<.cc> 0,limm,c 00101110110001000111CCCCCC0QQQQQ.  */
{ "mul64", 0x2EC47000, 0xFFFFF020, ARC_OPCODE_ARC600, MPY, NONE, { LIMM, RC }, { C_CC }},

/* mul64<.cc> 0,b,limm 00101bbb110001000BBB1111100QQQQQ.  */
{ "mul64", 0x28C40F80, 0xF8FF8FE0, ARC_OPCODE_ARC600, MPY, NONE, { RB, LIMM }, { C_CC }},

/* mul64 0,limm,u6 00101110010001000111uuuuuu111110.  */
{ "mul64", 0x2E44703E, 0xFFFFF03F, ARC_OPCODE_ARC600, MPY, NONE, { LIMM, UIMM6_20 }, { 0 }},

/* mul64<.cc> 0,limm,u6 00101110110001000111uuuuuu1QQQQQ.  */
{ "mul64", 0x2EC47020, 0xFFFFF020, ARC_OPCODE_ARC600, MPY, NONE, { LIMM, UIMM6_20 }, { C_CC }},

/* mul64 0,limm,s12 00101110100001000111ssssssSSSSSS.  */
{ "mul64", 0x2E847000, 0xFFFFF000, ARC_OPCODE_ARC600, MPY, NONE, { LIMM, SIMM12_20 }, { 0 }},

/* mul64 0,limm,limm 00101110000001000111111110111110.  */
{ "mul64", 0x2E047FBE, 0xFFFFFFFF, ARC_OPCODE_ARC600, MPY, NONE, { LIMM, LIMMdup }, { 0 }},

/* mul64<.cc> 0,limm,limm 001011101100010001111111100QQQQQ.  */
{ "mul64", 0x2EC47F80, 0xFFFFFFE0, ARC_OPCODE_ARC600, MPY, NONE, { LIMM, LIMMdup }, { C_CC }},

/* mul64_s 0,b,c 01111bbbccc01100.  */
{ "mul64_s", 0x0000780C, 0x0000F81F, ARC_OPCODE_ARC600, MPY, NONE, { ZA_S, RB_S, RC_S }, { 0 }},

/* mul64_s 0,b,c 01111bbbccc01100.  */
{ "mul64_s", 0x0000780C, 0x0000F81F, ARC_OPCODE_ARC600, MPY, NONE, { RB_S, RC_S }, { 0 }},

/* muldw<.f> a,b,c 00101bbb00001100FBBBCCCCCCAAAAAA.  */
{ "muldw", 0x280C0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* muldw<.f> 0,b,c 00101bbb00001100FBBBCCCCCC111110.  */
{ "muldw", 0x280C003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* muldw<.f><.cc> b,b,c 00101bbb11001100FBBBCCCCCC0QQQQQ.  */
{ "muldw", 0x28CC0000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* muldw<.f> a,b,u6 00101bbb01001100FBBBuuuuuuAAAAAA.  */
{ "muldw", 0x284C0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* muldw<.f> 0,b,u6 00101bbb01001100FBBBuuuuuu111110.  */
{ "muldw", 0x284C003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* muldw<.f><.cc> b,b,u6 00101bbb11001100FBBBuuuuuu1QQQQQ.  */
{ "muldw", 0x28CC0020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* muldw<.f> b,b,s12 00101bbb10001100FBBBssssssSSSSSS.  */
{ "muldw", 0x288C0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* muldw<.f> a,limm,c 0010111000001100F111CCCCCCAAAAAA.  */
{ "muldw", 0x2E0C7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* muldw<.f> a,b,limm 00101bbb00001100FBBB111110AAAAAA.  */
{ "muldw", 0x280C0F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* muldw<.f> 0,limm,c 0010111000001100F111CCCCCC111110.  */
{ "muldw", 0x2E0C703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* muldw<.f> 0,b,limm 00101bbb00001100FBBB111110111110.  */
{ "muldw", 0x280C0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* muldw<.f><.cc> 0,limm,c 0010111011001100F111CCCCCC0QQQQQ.  */
{ "muldw", 0x2ECC7000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* muldw<.f><.cc> b,b,limm 00101bbb11001100FBBB1111100QQQQQ.  */
{ "muldw", 0x28CC0F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* muldw<.f> a,limm,u6 0010111001001100F111uuuuuuAAAAAA.  */
{ "muldw", 0x2E4C7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* muldw<.f> 0,limm,u6 0010111001001100F111uuuuuu111110.  */
{ "muldw", 0x2E4C703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* muldw<.f><.cc> 0,limm,u6 0010111011001100F111uuuuuu1QQQQQ.  */
{ "muldw", 0x2ECC7020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* muldw<.f> 0,limm,s12 0010111010001100F111ssssssSSSSSS.  */
{ "muldw", 0x2E8C7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* muldw<.f> a,limm,limm 0010111000001100F111111110AAAAAA.  */
{ "muldw", 0x2E0C7F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* muldw<.f> 0,limm,limm 0010111000001100F111111110111110.  */
{ "muldw", 0x2E0C7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* muldw<.f><.cc> 0,limm,limm 0010111011001100F1111111100QQQQQ.  */
{ "muldw", 0x2ECC7F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mulflw<.f> a,b,c 00101bbb00110010FBBBCCCCCCAAAAAA.  */
{ "mulflw", 0x28320000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mulflw<.f> 0,b,c 00101bbb00110010FBBBCCCCCC111110.  */
{ "mulflw", 0x2832003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* mulflw<.f><.cc> b,b,c 00101bbb11110010FBBBCCCCCC0QQQQQ.  */
{ "mulflw", 0x28F20000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mulflw<.f> a,b,u6 00101bbb01110010FBBBuuuuuuAAAAAA.  */
{ "mulflw", 0x28720000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mulflw<.f> 0,b,u6 00101bbb01110010FBBBuuuuuu111110.  */
{ "mulflw", 0x2872003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mulflw<.f><.cc> b,b,u6 00101bbb11110010FBBBuuuuuu1QQQQQ.  */
{ "mulflw", 0x28F20020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mulflw<.f> b,b,s12 00101bbb10110010FBBBssssssSSSSSS.  */
{ "mulflw", 0x28B20000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mulflw<.f> a,limm,c 0010111000110010F111CCCCCCAAAAAA.  */
{ "mulflw", 0x2E327000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mulflw<.f> a,b,limm 00101bbb00110010FBBB111110AAAAAA.  */
{ "mulflw", 0x28320F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mulflw<.f> 0,limm,c 0010111000110010F111CCCCCC111110.  */
{ "mulflw", 0x2E32703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* mulflw<.f> 0,b,limm 00101bbb00110010FBBB111110111110.  */
{ "mulflw", 0x28320FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* mulflw<.f><.cc> 0,limm,c 0010111011110010F111CCCCCC0QQQQQ.  */
{ "mulflw", 0x2EF27000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mulflw<.f><.cc> b,b,limm 00101bbb11110010FBBB1111100QQQQQ.  */
{ "mulflw", 0x28F20F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mulflw<.f> a,limm,u6 0010111001110010F111uuuuuuAAAAAA.  */
{ "mulflw", 0x2E727000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mulflw<.f> 0,limm,u6 0010111001110010F111uuuuuu111110.  */
{ "mulflw", 0x2E72703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mulflw<.f><.cc> 0,limm,u6 0010111011110010F111uuuuuu1QQQQQ.  */
{ "mulflw", 0x2EF27020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mulflw<.f> 0,limm,s12 0010111010110010F111ssssssSSSSSS.  */
{ "mulflw", 0x2EB27000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mulflw<.f> a,limm,limm 0010111000110010F111111110AAAAAA.  */
{ "mulflw", 0x2E327F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mulflw<.f> 0,limm,limm 0010111000110010F111111110111110.  */
{ "mulflw", 0x2E327FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mulflw<.f><.cc> 0,limm,limm 0010111011110010F1111111100QQQQQ.  */
{ "mulflw", 0x2EF27F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mulhflw<.f> a,b,c 00101bbb00111001FBBBCCCCCCAAAAAA.  */
{ "mulhflw", 0x28390000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mulhflw<.f> 0,b,c 00101bbb00111001FBBBCCCCCC111110.  */
{ "mulhflw", 0x2839003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* mulhflw<.f><.cc> b,b,c 00101bbb11111001FBBBCCCCCC0QQQQQ.  */
{ "mulhflw", 0x28F90000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mulhflw<.f> a,b,u6 00101bbb01111001FBBBuuuuuuAAAAAA.  */
{ "mulhflw", 0x28790000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mulhflw<.f> 0,b,u6 00101bbb01111001FBBBuuuuuu111110.  */
{ "mulhflw", 0x2879003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mulhflw<.f><.cc> b,b,u6 00101bbb11111001FBBBuuuuuu1QQQQQ.  */
{ "mulhflw", 0x28F90020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mulhflw<.f> b,b,s12 00101bbb10111001FBBBssssssSSSSSS.  */
{ "mulhflw", 0x28B90000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mulhflw<.f> a,limm,c 0010111000111001F111CCCCCCAAAAAA.  */
{ "mulhflw", 0x2E397000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mulhflw<.f> a,b,limm 00101bbb00111001FBBB111110AAAAAA.  */
{ "mulhflw", 0x28390F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mulhflw<.f> 0,limm,c 0010111000111001F111CCCCCC111110.  */
{ "mulhflw", 0x2E39703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* mulhflw<.f> 0,b,limm 00101bbb00111001FBBB111110111110.  */
{ "mulhflw", 0x28390FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* mulhflw<.f><.cc> 0,limm,c 0010111011111001F111CCCCCC0QQQQQ.  */
{ "mulhflw", 0x2EF97000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mulhflw<.f><.cc> b,b,limm 00101bbb11111001FBBB1111100QQQQQ.  */
{ "mulhflw", 0x28F90F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mulhflw<.f> a,limm,u6 0010111001111001F111uuuuuuAAAAAA.  */
{ "mulhflw", 0x2E797000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mulhflw<.f> 0,limm,u6 0010111001111001F111uuuuuu111110.  */
{ "mulhflw", 0x2E79703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mulhflw<.f><.cc> 0,limm,u6 0010111011111001F111uuuuuu1QQQQQ.  */
{ "mulhflw", 0x2EF97020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mulhflw<.f> 0,limm,s12 0010111010111001F111ssssssSSSSSS.  */
{ "mulhflw", 0x2EB97000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mulhflw<.f> a,limm,limm 0010111000111001F111111110AAAAAA.  */
{ "mulhflw", 0x2E397F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mulhflw<.f> 0,limm,limm 0010111000111001F111111110111110.  */
{ "mulhflw", 0x2E397FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mulhflw<.f><.cc> 0,limm,limm 0010111011111001F1111111100QQQQQ.  */
{ "mulhflw", 0x2EF97F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mulhlw<.f> a,b,c 00101bbb00111000FBBBCCCCCCAAAAAA.  */
{ "mulhlw", 0x28380000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mulhlw<.f> 0,b,c 00101bbb00111000FBBBCCCCCC111110.  */
{ "mulhlw", 0x2838003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* mulhlw<.f><.cc> b,b,c 00101bbb11111000FBBBCCCCCC0QQQQQ.  */
{ "mulhlw", 0x28F80000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mulhlw<.f> a,b,u6 00101bbb01111000FBBBuuuuuuAAAAAA.  */
{ "mulhlw", 0x28780000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mulhlw<.f> 0,b,u6 00101bbb01111000FBBBuuuuuu111110.  */
{ "mulhlw", 0x2878003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mulhlw<.f><.cc> b,b,u6 00101bbb11111000FBBBuuuuuu1QQQQQ.  */
{ "mulhlw", 0x28F80020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mulhlw<.f> b,b,s12 00101bbb10111000FBBBssssssSSSSSS.  */
{ "mulhlw", 0x28B80000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mulhlw<.f> a,limm,c 0010111000111000F111CCCCCCAAAAAA.  */
{ "mulhlw", 0x2E387000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mulhlw<.f> a,b,limm 00101bbb00111000FBBB111110AAAAAA.  */
{ "mulhlw", 0x28380F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mulhlw<.f> 0,limm,c 0010111000111000F111CCCCCC111110.  */
{ "mulhlw", 0x2E38703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* mulhlw<.f> 0,b,limm 00101bbb00111000FBBB111110111110.  */
{ "mulhlw", 0x28380FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* mulhlw<.f><.cc> 0,limm,c 0010111011111000F111CCCCCC0QQQQQ.  */
{ "mulhlw", 0x2EF87000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mulhlw<.f><.cc> b,b,limm 00101bbb11111000FBBB1111100QQQQQ.  */
{ "mulhlw", 0x28F80F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mulhlw<.f> a,limm,u6 0010111001111000F111uuuuuuAAAAAA.  */
{ "mulhlw", 0x2E787000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mulhlw<.f> 0,limm,u6 0010111001111000F111uuuuuu111110.  */
{ "mulhlw", 0x2E78703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mulhlw<.f><.cc> 0,limm,u6 0010111011111000F111uuuuuu1QQQQQ.  */
{ "mulhlw", 0x2EF87020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mulhlw<.f> 0,limm,s12 0010111010111000F111ssssssSSSSSS.  */
{ "mulhlw", 0x2EB87000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mulhlw<.f> a,limm,limm 0010111000111000F111111110AAAAAA.  */
{ "mulhlw", 0x2E387F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mulhlw<.f> 0,limm,limm 0010111000111000F111111110111110.  */
{ "mulhlw", 0x2E387FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mulhlw<.f><.cc> 0,limm,limm 0010111011111000F1111111100QQQQQ.  */
{ "mulhlw", 0x2EF87F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mullw<.f> a,b,c 00101bbb00110001FBBBCCCCCCAAAAAA.  */
{ "mullw", 0x28310000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mullw<.f> 0,b,c 00101bbb00110001FBBBCCCCCC111110.  */
{ "mullw", 0x2831003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* mullw<.f><.cc> b,b,c 00101bbb11110001FBBBCCCCCC0QQQQQ.  */
{ "mullw", 0x28F10000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mullw<.f> a,b,u6 00101bbb01110001FBBBuuuuuuAAAAAA.  */
{ "mullw", 0x28710000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mullw<.f> 0,b,u6 00101bbb01110001FBBBuuuuuu111110.  */
{ "mullw", 0x2871003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mullw<.f><.cc> b,b,u6 00101bbb11110001FBBBuuuuuu1QQQQQ.  */
{ "mullw", 0x28F10020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mullw<.f> b,b,s12 00101bbb10110001FBBBssssssSSSSSS.  */
{ "mullw", 0x28B10000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mullw<.f> a,limm,c 0010111000110001F111CCCCCCAAAAAA.  */
{ "mullw", 0x2E317000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mullw<.f> a,b,limm 00101bbb00110001FBBB111110AAAAAA.  */
{ "mullw", 0x28310F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mullw<.f> 0,limm,c 0010111000110001F111CCCCCC111110.  */
{ "mullw", 0x2E31703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* mullw<.f> 0,b,limm 00101bbb00110001FBBB111110111110.  */
{ "mullw", 0x28310FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* mullw<.f><.cc> 0,limm,c 0010111011110001F111CCCCCC0QQQQQ.  */
{ "mullw", 0x2EF17000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mullw<.f><.cc> b,b,limm 00101bbb11110001FBBB1111100QQQQQ.  */
{ "mullw", 0x28F10F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mullw<.f> a,limm,u6 0010111001110001F111uuuuuuAAAAAA.  */
{ "mullw", 0x2E717000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mullw<.f> 0,limm,u6 0010111001110001F111uuuuuu111110.  */
{ "mullw", 0x2E71703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mullw<.f><.cc> 0,limm,u6 0010111011110001F111uuuuuu1QQQQQ.  */
{ "mullw", 0x2EF17020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mullw<.f> 0,limm,s12 0010111010110001F111ssssssSSSSSS.  */
{ "mullw", 0x2EB17000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mullw<.f> a,limm,limm 0010111000110001F111111110AAAAAA.  */
{ "mullw", 0x2E317F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mullw<.f> 0,limm,limm 0010111000110001F111111110111110.  */
{ "mullw", 0x2E317FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mullw<.f><.cc> 0,limm,limm 0010111011110001F1111111100QQQQQ.  */
{ "mullw", 0x2EF17F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mulrdw<.f> a,b,c 00101bbb00001110FBBBCCCCCCAAAAAA.  */
{ "mulrdw", 0x280E0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mulrdw<.f> 0,b,c 00101bbb00001110FBBBCCCCCC111110.  */
{ "mulrdw", 0x280E003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* mulrdw<.f><.cc> b,b,c 00101bbb11001110FBBBCCCCCC0QQQQQ.  */
{ "mulrdw", 0x28CE0000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mulrdw<.f> a,b,u6 00101bbb01001110FBBBuuuuuuAAAAAA.  */
{ "mulrdw", 0x284E0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mulrdw<.f> 0,b,u6 00101bbb01001110FBBBuuuuuu111110.  */
{ "mulrdw", 0x284E003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mulrdw<.f><.cc> b,b,u6 00101bbb11001110FBBBuuuuuu1QQQQQ.  */
{ "mulrdw", 0x28CE0020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mulrdw<.f> b,b,s12 00101bbb10001110FBBBssssssSSSSSS.  */
{ "mulrdw", 0x288E0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mulrdw<.f> a,limm,c 0010111000001110F111CCCCCCAAAAAA.  */
{ "mulrdw", 0x2E0E7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mulrdw<.f> a,b,limm 00101bbb00001110FBBB111110AAAAAA.  */
{ "mulrdw", 0x280E0F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mulrdw<.f> 0,limm,c 0010111000001110F111CCCCCC111110.  */
{ "mulrdw", 0x2E0E703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* mulrdw<.f> 0,b,limm 00101bbb00001110FBBB111110111110.  */
{ "mulrdw", 0x280E0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* mulrdw<.f><.cc> 0,limm,c 0010111011001110F111CCCCCC0QQQQQ.  */
{ "mulrdw", 0x2ECE7000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mulrdw<.f><.cc> b,b,limm 00101bbb11001110FBBB1111100QQQQQ.  */
{ "mulrdw", 0x28CE0F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mulrdw<.f> a,limm,u6 0010111001001110F111uuuuuuAAAAAA.  */
{ "mulrdw", 0x2E4E7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mulrdw<.f> 0,limm,u6 0010111001001110F111uuuuuu111110.  */
{ "mulrdw", 0x2E4E703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mulrdw<.f><.cc> 0,limm,u6 0010111011001110F111uuuuuu1QQQQQ.  */
{ "mulrdw", 0x2ECE7020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mulrdw<.f> 0,limm,s12 0010111010001110F111ssssssSSSSSS.  */
{ "mulrdw", 0x2E8E7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mulrdw<.f> a,limm,limm 0010111000001110F111111110AAAAAA.  */
{ "mulrdw", 0x2E0E7F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mulrdw<.f> 0,limm,limm 0010111000001110F111111110111110.  */
{ "mulrdw", 0x2E0E7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mulrdw<.f><.cc> 0,limm,limm 0010111011001110F1111111100QQQQQ.  */
{ "mulrdw", 0x2ECE7F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mulrt<.f> a,b,c 00101bbb00011010FBBBCCCCCCAAAAAA.  */
{ "mulrt", 0x281A0000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mulrt<.f> 0,b,c 00101bbb00011010FBBBCCCCCC111110.  */
{ "mulrt", 0x281A003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* mulrt<.f><.cc> b,b,c 00101bbb11011010FBBBCCCCCC0QQQQQ.  */
{ "mulrt", 0x28DA0000, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mulrt<.f> a,b,u6 00101bbb01011010FBBBuuuuuuAAAAAA.  */
{ "mulrt", 0x285A0000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mulrt<.f> 0,b,u6 00101bbb01011010FBBBuuuuuu111110.  */
{ "mulrt", 0x285A003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mulrt<.f><.cc> b,b,u6 00101bbb11011010FBBBuuuuuu1QQQQQ.  */
{ "mulrt", 0x28DA0020, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mulrt<.f> b,b,s12 00101bbb10011010FBBBssssssSSSSSS.  */
{ "mulrt", 0x289A0000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mulrt<.f> a,limm,c 0010111000011010F111CCCCCCAAAAAA.  */
{ "mulrt", 0x2E1A7000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mulrt<.f> a,b,limm 00101bbb00011010FBBB111110AAAAAA.  */
{ "mulrt", 0x281A0F80, 0xF8FF0FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mulrt<.f> 0,limm,c 0010111000011010F111CCCCCC111110.  */
{ "mulrt", 0x2E1A703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* mulrt<.f> 0,b,limm 00101bbb00011010FBBB111110111110.  */
{ "mulrt", 0x281A0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* mulrt<.f><.cc> 0,limm,c 0010111011011010F111CCCCCC0QQQQQ.  */
{ "mulrt", 0x2EDA7000, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mulrt<.f><.cc> b,b,limm 00101bbb11011010FBBB1111100QQQQQ.  */
{ "mulrt", 0x28DA0F80, 0xF8FF0FE0, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mulrt<.f> a,limm,u6 0010111001011010F111uuuuuuAAAAAA.  */
{ "mulrt", 0x2E5A7000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mulrt<.f> 0,limm,u6 0010111001011010F111uuuuuu111110.  */
{ "mulrt", 0x2E5A703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mulrt<.f><.cc> 0,limm,u6 0010111011011010F111uuuuuu1QQQQQ.  */
{ "mulrt", 0x2EDA7020, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mulrt<.f> 0,limm,s12 0010111010011010F111ssssssSSSSSS.  */
{ "mulrt", 0x2E9A7000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mulrt<.f> a,limm,limm 0010111000011010F111111110AAAAAA.  */
{ "mulrt", 0x2E1A7F80, 0xFFFF7FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mulrt<.f> 0,limm,limm 0010111000011010F111111110111110.  */
{ "mulrt", 0x2E1A7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mulrt<.f><.cc> 0,limm,limm 0010111011011010F1111111100QQQQQ.  */
{ "mulrt", 0x2EDA7F80, 0xFFFF7FE0, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mult<.f> a,b,c 00101bbb00011000FBBBCCCCCCAAAAAA.  */
{ "mult", 0x28180000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mult<.f> 0,b,c 00101bbb00011000FBBBCCCCCC111110.  */
{ "mult", 0x2818003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* mult<.f><.cc> b,b,c 00101bbb11011000FBBBCCCCCC0QQQQQ.  */
{ "mult", 0x28D80000, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mult<.f> a,b,u6 00101bbb01011000FBBBuuuuuuAAAAAA.  */
{ "mult", 0x28580000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mult<.f> 0,b,u6 00101bbb01011000FBBBuuuuuu111110.  */
{ "mult", 0x2858003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mult<.f><.cc> b,b,u6 00101bbb11011000FBBBuuuuuu1QQQQQ.  */
{ "mult", 0x28D80020, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mult<.f> b,b,s12 00101bbb10011000FBBBssssssSSSSSS.  */
{ "mult", 0x28980000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mult<.f> a,limm,c 0010111000011000F111CCCCCCAAAAAA.  */
{ "mult", 0x2E187000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mult<.f> a,b,limm 00101bbb00011000FBBB111110AAAAAA.  */
{ "mult", 0x28180F80, 0xF8FF0FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mult<.f> 0,limm,c 0010111000011000F111CCCCCC111110.  */
{ "mult", 0x2E18703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* mult<.f> 0,b,limm 00101bbb00011000FBBB111110111110.  */
{ "mult", 0x28180FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* mult<.f><.cc> 0,limm,c 0010111011011000F111CCCCCC0QQQQQ.  */
{ "mult", 0x2ED87000, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mult<.f><.cc> b,b,limm 00101bbb11011000FBBB1111100QQQQQ.  */
{ "mult", 0x28D80F80, 0xF8FF0FE0, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mult<.f> a,limm,u6 0010111001011000F111uuuuuuAAAAAA.  */
{ "mult", 0x2E587000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mult<.f> 0,limm,u6 0010111001011000F111uuuuuu111110.  */
{ "mult", 0x2E58703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mult<.f><.cc> 0,limm,u6 0010111011011000F111uuuuuu1QQQQQ.  */
{ "mult", 0x2ED87020, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mult<.f> 0,limm,s12 0010111010011000F111ssssssSSSSSS.  */
{ "mult", 0x2E987000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mult<.f> a,limm,limm 0010111000011000F111111110AAAAAA.  */
{ "mult", 0x2E187F80, 0xFFFF7FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mult<.f> 0,limm,limm 0010111000011000F111111110111110.  */
{ "mult", 0x2E187FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mult<.f><.cc> 0,limm,limm 0010111011011000F1111111100QQQQQ.  */
{ "mult", 0x2ED87F80, 0xFFFF7FE0, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mulu64 0,b,c 00101bbb000001010BBBCCCCCC111110.  */
{ "mulu64", 0x2805003E, 0xF8FF803F, ARC_OPCODE_ARC600, MPY, NONE, { ZA, RB, RC }, { 0 }},

/* mulu64<.cc> 0,b,c 00101bbb110001010BBBCCCCCC0QQQQQ.  */
{ "mulu64", 0x28C50000, 0xF8FF8020, ARC_OPCODE_ARC600, MPY, NONE, { ZA, RB, RC }, { C_CC }},

/* mulu64 0,b,u6 00101bbb010001010BBBuuuuuu111110.  */
{ "mulu64", 0x2845003E, 0xF8FF803F, ARC_OPCODE_ARC600, MPY, NONE, { ZA, RB, UIMM6_20 }, { 0 }},

/* mulu64<.cc> 0,b,u6 00101bbb110001010BBBuuuuuu1QQQQQ.  */
{ "mulu64", 0x28C50020, 0xF8FF8020, ARC_OPCODE_ARC600, MPY, NONE, { ZA, RB, UIMM6_20 }, { C_CC }},

/* mulu64 0,b,s12 00101bbb100001010BBBssssssSSSSSS.  */
{ "mulu64", 0x28850000, 0xF8FF8000, ARC_OPCODE_ARC600, MPY, NONE, { ZA, RB, SIMM12_20 }, { 0 }},

/* mulu64 0,limm,c 00101110000001010111CCCCCC111110.  */
{ "mulu64", 0x2E05703E, 0xFFFFF03F, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, RC }, { 0 }},

/* mulu64 0,b,limm 00101bbb000001010BBB111110111110.  */
{ "mulu64", 0x28050FBE, 0xF8FF8FFF, ARC_OPCODE_ARC600, MPY, NONE, { ZA, RB, LIMM }, { 0 }},

/* mulu64<.cc> 0,limm,c 00101110110001010111CCCCCC0QQQQQ.  */
{ "mulu64", 0x2EC57000, 0xFFFFF020, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, RC }, { C_CC }},

/* mulu64<.cc> 0,b,limm 00101bbb110001010BBB1111100QQQQQ.  */
{ "mulu64", 0x28C50F80, 0xF8FF8FE0, ARC_OPCODE_ARC600, MPY, NONE, { ZA, RB, LIMM }, { C_CC }},

/* mulu64 0,limm,u6 00101110010001010111uuuuuu111110.  */
{ "mulu64", 0x2E45703E, 0xFFFFF03F, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* mulu64<.cc> 0,limm,u6 00101110110001010111uuuuuu1QQQQQ.  */
{ "mulu64", 0x2EC57020, 0xFFFFF020, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* mulu64 0,limm,s12 00101110100001010111ssssssSSSSSS.  */
{ "mulu64", 0x2E857000, 0xFFFFF000, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* mulu64 0,limm,limm 00101110000001010111111110111110.  */
{ "mulu64", 0x2E057FBE, 0xFFFFFFFF, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, LIMMdup }, { 0 }},

/* mulu64<.cc> 0,limm,limm 001011101100010101111111100QQQQQ.  */
{ "mulu64", 0x2EC57F80, 0xFFFFFFE0, ARC_OPCODE_ARC600, MPY, NONE, { ZA, LIMM, LIMMdup }, { C_CC }},

/* mulu64 0,b,c 00101bbb000001010BBBCCCCCC111110.  */
{ "mulu64", 0x2805003E, 0xF8FF803F, ARC_OPCODE_ARC600, MPY, NONE, { RB, RC }, { 0 }},

/* mulu64<.cc> 0,b,c 00101bbb110001010BBBCCCCCC0QQQQQ.  */
{ "mulu64", 0x28C50000, 0xF8FF8020, ARC_OPCODE_ARC600, MPY, NONE, { RB, RC }, { C_CC }},

/* mulu64 0,b,u6 00101bbb010001010BBBuuuuuu111110.  */
{ "mulu64", 0x2845003E, 0xF8FF803F, ARC_OPCODE_ARC600, MPY, NONE, { RB, UIMM6_20 }, { 0 }},

/* mulu64<.cc> 0,b,u6 00101bbb110001010BBBuuuuuu1QQQQQ.  */
{ "mulu64", 0x28C50020, 0xF8FF8020, ARC_OPCODE_ARC600, MPY, NONE, { RB, UIMM6_20 }, { C_CC }},

/* mulu64 0,b,s12 00101bbb100001010BBBssssssSSSSSS.  */
{ "mulu64", 0x28850000, 0xF8FF8000, ARC_OPCODE_ARC600, MPY, NONE, { RB, SIMM12_20 }, { 0 }},

/* mulu64 0,limm,c 00101110000001010111CCCCCC111110.  */
{ "mulu64", 0x2E05703E, 0xFFFFF03F, ARC_OPCODE_ARC600, MPY, NONE, { LIMM, RC }, { 0 }},

/* mulu64 0,b,limm 00101bbb000001010BBB111110111110.  */
{ "mulu64", 0x28050FBE, 0xF8FF8FFF, ARC_OPCODE_ARC600, MPY, NONE, { RB, LIMM }, { 0 }},

/* mulu64<.cc> 0,limm,c 00101110110001010111CCCCCC0QQQQQ.  */
{ "mulu64", 0x2EC57000, 0xFFFFF020, ARC_OPCODE_ARC600, MPY, NONE, { LIMM, RC }, { C_CC }},

/* mulu64<.cc> 0,b,limm 00101bbb110001010BBB1111100QQQQQ.  */
{ "mulu64", 0x28C50F80, 0xF8FF8FE0, ARC_OPCODE_ARC600, MPY, NONE, { RB, LIMM }, { C_CC }},

/* mulu64 0,limm,u6 00101110010001010111uuuuuu111110.  */
{ "mulu64", 0x2E45703E, 0xFFFFF03F, ARC_OPCODE_ARC600, MPY, NONE, { LIMM, UIMM6_20 }, { 0 }},

/* mulu64<.cc> 0,limm,u6 00101110110001010111uuuuuu1QQQQQ.  */
{ "mulu64", 0x2EC57020, 0xFFFFF020, ARC_OPCODE_ARC600, MPY, NONE, { LIMM, UIMM6_20 }, { C_CC }},

/* mulu64 0,limm,s12 00101110100001010111ssssssSSSSSS.  */
{ "mulu64", 0x2E857000, 0xFFFFF000, ARC_OPCODE_ARC600, MPY, NONE, { LIMM, SIMM12_20 }, { 0 }},

/* mulu64 0,limm,limm 00101110000001010111111110111110.  */
{ "mulu64", 0x2E057FBE, 0xFFFFFFFF, ARC_OPCODE_ARC600, MPY, NONE, { LIMM, LIMMdup }, { 0 }},

/* mulu64<.cc> 0,limm,limm 001011101100010101111111100QQQQQ.  */
{ "mulu64", 0x2EC57F80, 0xFFFFFFE0, ARC_OPCODE_ARC600, MPY, NONE, { LIMM, LIMMdup }, { C_CC }},

/* muludw<.f> a,b,c 00101bbb00001101FBBBCCCCCCAAAAAA.  */
{ "muludw", 0x280D0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* muludw<.f> 0,b,c 00101bbb00001101FBBBCCCCCC111110.  */
{ "muludw", 0x280D003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* muludw<.f><.cc> b,b,c 00101bbb11001101FBBBCCCCCC0QQQQQ.  */
{ "muludw", 0x28CD0000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* muludw<.f> a,b,u6 00101bbb01001101FBBBuuuuuuAAAAAA.  */
{ "muludw", 0x284D0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* muludw<.f> 0,b,u6 00101bbb01001101FBBBuuuuuu111110.  */
{ "muludw", 0x284D003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* muludw<.f><.cc> b,b,u6 00101bbb11001101FBBBuuuuuu1QQQQQ.  */
{ "muludw", 0x28CD0020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* muludw<.f> b,b,s12 00101bbb10001101FBBBssssssSSSSSS.  */
{ "muludw", 0x288D0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* muludw<.f> a,limm,c 0010111000001101F111CCCCCCAAAAAA.  */
{ "muludw", 0x2E0D7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* muludw<.f> a,b,limm 00101bbb00001101FBBB111110AAAAAA.  */
{ "muludw", 0x280D0F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* muludw<.f> 0,limm,c 0010111000001101F111CCCCCC111110.  */
{ "muludw", 0x2E0D703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* muludw<.f> 0,b,limm 00101bbb00001101FBBB111110111110.  */
{ "muludw", 0x280D0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* muludw<.f><.cc> 0,limm,c 0010111011001101F111CCCCCC0QQQQQ.  */
{ "muludw", 0x2ECD7000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* muludw<.f><.cc> b,b,limm 00101bbb11001101FBBB1111100QQQQQ.  */
{ "muludw", 0x28CD0F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* muludw<.f> a,limm,u6 0010111001001101F111uuuuuuAAAAAA.  */
{ "muludw", 0x2E4D7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* muludw<.f> 0,limm,u6 0010111001001101F111uuuuuu111110.  */
{ "muludw", 0x2E4D703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* muludw<.f><.cc> 0,limm,u6 0010111011001101F111uuuuuu1QQQQQ.  */
{ "muludw", 0x2ECD7020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* muludw<.f> 0,limm,s12 0010111010001101F111ssssssSSSSSS.  */
{ "muludw", 0x2E8D7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* muludw<.f> a,limm,limm 0010111000001101F111111110AAAAAA.  */
{ "muludw", 0x2E0D7F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* muludw<.f> 0,limm,limm 0010111000001101F111111110111110.  */
{ "muludw", 0x2E0D7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* muludw<.f><.cc> 0,limm,limm 0010111011001101F1111111100QQQQQ.  */
{ "muludw", 0x2ECD7F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mululw<.f> a,b,c 00101bbb00110000FBBBCCCCCCAAAAAA.  */
{ "mululw", 0x28300000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mululw<.f> 0,b,c 00101bbb00110000FBBBCCCCCC111110.  */
{ "mululw", 0x2830003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* mululw<.f><.cc> b,b,c 00101bbb11110000FBBBCCCCCC0QQQQQ.  */
{ "mululw", 0x28F00000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mululw<.f> a,b,u6 00101bbb01110000FBBBuuuuuuAAAAAA.  */
{ "mululw", 0x28700000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mululw<.f> 0,b,u6 00101bbb01110000FBBBuuuuuu111110.  */
{ "mululw", 0x2870003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mululw<.f><.cc> b,b,u6 00101bbb11110000FBBBuuuuuu1QQQQQ.  */
{ "mululw", 0x28F00020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mululw<.f> b,b,s12 00101bbb10110000FBBBssssssSSSSSS.  */
{ "mululw", 0x28B00000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mululw<.f> a,limm,c 0010111000110000F111CCCCCCAAAAAA.  */
{ "mululw", 0x2E307000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mululw<.f> a,b,limm 00101bbb00110000FBBB111110AAAAAA.  */
{ "mululw", 0x28300F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mululw<.f> 0,limm,c 0010111000110000F111CCCCCC111110.  */
{ "mululw", 0x2E30703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* mululw<.f> 0,b,limm 00101bbb00110000FBBB111110111110.  */
{ "mululw", 0x28300FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* mululw<.f><.cc> 0,limm,c 0010111011110000F111CCCCCC0QQQQQ.  */
{ "mululw", 0x2EF07000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mululw<.f><.cc> b,b,limm 00101bbb11110000FBBB1111100QQQQQ.  */
{ "mululw", 0x28F00F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mululw<.f> a,limm,u6 0010111001110000F111uuuuuuAAAAAA.  */
{ "mululw", 0x2E707000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mululw<.f> 0,limm,u6 0010111001110000F111uuuuuu111110.  */
{ "mululw", 0x2E70703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mululw<.f><.cc> 0,limm,u6 0010111011110000F111uuuuuu1QQQQQ.  */
{ "mululw", 0x2EF07020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mululw<.f> 0,limm,s12 0010111010110000F111ssssssSSSSSS.  */
{ "mululw", 0x2EB07000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mululw<.f> a,limm,limm 0010111000110000F111111110AAAAAA.  */
{ "mululw", 0x2E307F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mululw<.f> 0,limm,limm 0010111000110000F111111110111110.  */
{ "mululw", 0x2E307FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mululw<.f><.cc> 0,limm,limm 0010111011110000F1111111100QQQQQ.  */
{ "mululw", 0x2EF07F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mulut<.f> a,b,c 00101bbb00011001FBBBCCCCCCAAAAAA.  */
{ "mulut", 0x28190000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mulut<.f> 0,b,c 00101bbb00011001FBBBCCCCCC111110.  */
{ "mulut", 0x2819003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, RC }, { C_F }},

/* mulut<.f><.cc> b,b,c 00101bbb11011001FBBBCCCCCC0QQQQQ.  */
{ "mulut", 0x28D90000, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mulut<.f> a,b,u6 00101bbb01011001FBBBuuuuuuAAAAAA.  */
{ "mulut", 0x28590000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mulut<.f> 0,b,u6 00101bbb01011001FBBBuuuuuu111110.  */
{ "mulut", 0x2859003E, 0xF8FF003F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mulut<.f><.cc> b,b,u6 00101bbb11011001FBBBuuuuuu1QQQQQ.  */
{ "mulut", 0x28D90020, 0xF8FF0020, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mulut<.f> b,b,s12 00101bbb10011001FBBBssssssSSSSSS.  */
{ "mulut", 0x28990000, 0xF8FF0000, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mulut<.f> a,limm,c 0010111000011001F111CCCCCCAAAAAA.  */
{ "mulut", 0x2E197000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mulut<.f> a,b,limm 00101bbb00011001FBBB111110AAAAAA.  */
{ "mulut", 0x28190F80, 0xF8FF0FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mulut<.f> 0,limm,c 0010111000011001F111CCCCCC111110.  */
{ "mulut", 0x2E19703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F }},

/* mulut<.f> 0,b,limm 00101bbb00011001FBBB111110111110.  */
{ "mulut", 0x28190FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, RB, LIMM }, { C_F }},

/* mulut<.f><.cc> 0,limm,c 0010111011011001F111CCCCCC0QQQQQ.  */
{ "mulut", 0x2ED97000, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mulut<.f><.cc> b,b,limm 00101bbb11011001FBBB1111100QQQQQ.  */
{ "mulut", 0x28D90F80, 0xF8FF0FE0, ARC_OPCODE_ARC600, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mulut<.f> a,limm,u6 0010111001011001F111uuuuuuAAAAAA.  */
{ "mulut", 0x2E597000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mulut<.f> 0,limm,u6 0010111001011001F111uuuuuu111110.  */
{ "mulut", 0x2E59703E, 0xFFFF703F, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mulut<.f><.cc> 0,limm,u6 0010111011011001F111uuuuuu1QQQQQ.  */
{ "mulut", 0x2ED97020, 0xFFFF7020, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mulut<.f> 0,limm,s12 0010111010011001F111ssssssSSSSSS.  */
{ "mulut", 0x2E997000, 0xFFFF7000, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mulut<.f> a,limm,limm 0010111000011001F111111110AAAAAA.  */
{ "mulut", 0x2E197F80, 0xFFFF7FC0, ARC_OPCODE_ARC600, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mulut<.f> 0,limm,limm 0010111000011001F111111110111110.  */
{ "mulut", 0x2E197FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mulut<.f><.cc> 0,limm,limm 0010111011011001F1111111100QQQQQ.  */
{ "mulut", 0x2ED97F80, 0xFFFF7FE0, ARC_OPCODE_ARC600, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* neg<.f> a,b 00100bbb01001110FBBB000000AAAAAA.  */
{ "neg", 0x204E0000, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB }, { C_F }},

/* neg<.f> 0,b 00100bbb01001110FBBB000000111110.  */
{ "neg", 0x204E0000, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB }, { C_F }},

/* neg<.f><.cc> b,b 00100bbb11001110FBBB0000001QQQQQ.  */
{ "neg", 0x20CE0020, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup }, { C_F, C_CC }},

/* neg<.f> a,limm 0010011001001110F111000000AAAAAA.  */
{ "neg", 0x264E7000, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM }, { C_F }},

/* neg<.f><.cc> 0,limm 0010011011001110F1110000001QQQQQ.  */
{ "neg", 0x26CE7020, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM }, { C_F, C_CC }},

/* negs<.f> b,c 00101bbb00101111FBBBCCCCCC000111.  */
{ "negs", 0x282F0007, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RC }, { C_F }},

/* negs<.f> 0,c 0010111000101111F111CCCCCC000111.  */
{ "negs", 0x2E2F7007, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RC }, { C_F }},

/* negs<.f> b,u6 00101bbb01101111FBBBuuuuuu000111.  */
{ "negs", 0x286F0007, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* negs<.f> 0,u6 0010111001101111F111uuuuuu000111.  */
{ "negs", 0x2E6F7007, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* negs<.f> b,limm 00101bbb00101111FBBB111110000111.  */
{ "negs", 0x282F0F87, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, LIMM }, { C_F }},

/* negs<.f> 0,limm 0010111000101111F111111110000111.  */
{ "negs", 0x2E2F7F87, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* negsh<.f> b,c 00101bbb00101111FBBBCCCCCC000110.  */
{ "negsh", 0x282F0006, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RC }, { C_F }},

/* negsh<.f> 0,c 0010111000101111F111CCCCCC000110.  */
{ "negsh", 0x2E2F7006, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RC }, { C_F }},

/* negsh<.f> b,u6 00101bbb01101111FBBBuuuuuu000110.  */
{ "negsh", 0x286F0006, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, UIMM6_20 }, { C_F }},

/* negsh<.f> 0,u6 0010111001101111F111uuuuuu000110.  */
{ "negsh", 0x2E6F7006, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, UIMM6_20 }, { C_F }},

/* negsh<.f> b,limm 00101bbb00101111FBBB111110000110.  */
{ "negsh", 0x282F0F86, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, LIMM }, { C_F }},

/* negsh<.f> 0,limm 0010111000101111F111111110000110.  */
{ "negsh", 0x2E2F7F86, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM }, { C_F }},

/* negsw<.f> b,c 00101bbb00101111FBBBCCCCCC000110.  */
{ "negsw", 0x282F0006, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, RC }, { C_F }},

/* negsw<.f> 0,c 0010111000101111F111CCCCCC000110.  */
{ "negsw", 0x2E2F7006, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, RC }, { C_F }},

/* negsw<.f> b,u6 00101bbb01101111FBBBuuuuuu000110.  */
{ "negsw", 0x286F0006, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* negsw<.f> 0,u6 0010111001101111F111uuuuuu000110.  */
{ "negsw", 0x2E6F7006, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* negsw<.f> b,limm 00101bbb00101111FBBB111110000110.  */
{ "negsw", 0x282F0F86, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, LIMM }, { C_F }},

/* negsw<.f> 0,limm 0010111000101111F111111110000110.  */
{ "negsw", 0x2E2F7F86, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* neg_s b,c 01111bbbccc10011.  */
{ "neg_s", 0x00007813, 0x0000F81F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB_S, RC_S }, { 0 }},

/* nexttask c 00100000001011110011CCCCCC111111.  */
{ "nexttask", 0x202F303F, 0xFFFFF03F, ARC_OPCODE_ARCv2EM, SWITCH, NONE, { RC }, { 0 }},

/* nexttask u6 00100000011011110011uuuuuu111111.  */
{ "nexttask", 0x206F303F, 0xFFFFF03F, ARC_OPCODE_ARCv2EM, SWITCH, NONE, { UIMM6_20 }, { 0 }},

/* nop_s  0111100011100000.  */
{ "nop_s", 0x000078E0, 0x0000FFFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { 0 }, { 0 }},

/* norm<.f> b,c 00101bbb00101111FBBBCCCCCC000001.  */
{ "norm", 0x282F0001, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { RB, RC }, { C_F }},

/* norm<.f> 0,c 0010111000101111F111CCCCCC000001.  */
{ "norm", 0x2E2F7001, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { ZA, RC }, { C_F }},

/* norm<.f> b,u6 00101bbb01101111FBBBuuuuuu000001.  */
{ "norm", 0x286F0001, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { RB, UIMM6_20 }, { C_F }},

/* norm<.f> 0,u6 0010111001101111F111uuuuuu000001.  */
{ "norm", 0x2E6F7001, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { ZA, UIMM6_20 }, { C_F }},

/* norm<.f> b,limm 00101bbb00101111FBBB111110000001.  */
{ "norm", 0x282F0F81, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { RB, LIMM }, { C_F }},

/* norm<.f> 0,limm 0010111000101111F111111110000001.  */
{ "norm", 0x2E2F7F81, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { ZA, LIMM }, { C_F }},

/* normacc b,c 00101bbb001011110BBBCCCCCC011001.  */
{ "normacc", 0x282F0019, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RC }, { 0 }},

/* normacc 0,c 00101110001011110111CCCCCC011001.  */
{ "normacc", 0x2E2F7019, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RC }, { 0 }},

/* normacc b,u6 00101bbb011011110BBBuuuuuu011001.  */
{ "normacc", 0x286F0019, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, UIMM6_20 }, { 0 }},

/* normacc 0,u6 00101110011011110111uuuuuu011001.  */
{ "normacc", 0x2E6F7019, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, UIMM6_20 }, { 0 }},

/* normacc b,limm 00101bbb001011110BBB111110011001.  */
{ "normacc", 0x282F0F99, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, LIMM }, { 0 }},

/* normacc 0,limm 00101110001011110111111110011001.  */
{ "normacc", 0x2E2F7F99, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM }, { 0 }},

/* normh<.f> b,c 00101bbb00101111FBBBCCCCCC001000.  */
{ "normh", 0x282F0008, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { RB, RC }, { C_F }},

/* normh<.f> 0,c 0010111000101111F111CCCCCC001000.  */
{ "normh", 0x2E2F7008, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { ZA, RC }, { C_F }},

/* normh<.f> b,u6 00101bbb01101111FBBBuuuuuu001000.  */
{ "normh", 0x286F0008, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { RB, UIMM6_20 }, { C_F }},

/* normh<.f> 0,u6 0010111001101111F111uuuuuu001000.  */
{ "normh", 0x2E6F7008, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { ZA, UIMM6_20 }, { C_F }},

/* normh<.f> b,limm 00101bbb00101111FBBB111110001000.  */
{ "normh", 0x282F0F88, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { RB, LIMM }, { C_F }},

/* normh<.f> 0,limm 0010111000101111F111111110001000.  */
{ "normh", 0x2E2F7F88, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, BTSCN, { ZA, LIMM }, { C_F }},

/* normw<.f> b,c 00101bbb00101111FBBBCCCCCC001000.  */
{ "normw", 0x282F0008, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, BTSCN, { RB, RC }, { C_F }},

/* normw<.f> 0,c 0010111000101111F111CCCCCC001000.  */
{ "normw", 0x2E2F7008, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, BTSCN, { ZA, RC }, { C_F }},

/* normw<.f> b,u6 00101bbb01101111FBBBuuuuuu001000.  */
{ "normw", 0x286F0008, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, BTSCN, { RB, UIMM6_20 }, { C_F }},

/* normw<.f> 0,u6 0010111001101111F111uuuuuu001000.  */
{ "normw", 0x2E6F7008, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, BTSCN, { ZA, UIMM6_20 }, { C_F }},

/* normw<.f> b,limm 00101bbb00101111FBBB111110001000.  */
{ "normw", 0x282F0F88, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, BTSCN, { RB, LIMM }, { C_F }},

/* normw<.f> 0,limm 0010111000101111F111111110001000.  */
{ "normw", 0x2E2F7F88, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, BTSCN, { ZA, LIMM }, { C_F }},

/* not<.f> b,c 00100bbb00101111FBBBCCCCCC001010.  */
{ "not", 0x202F000A, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RC }, { C_F }},

/* not<.f> 0,c 0010011000101111F111CCCCCC001010.  */
{ "not", 0x262F700A, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RC }, { C_F }},

/* not<.f> b,u6 00100bbb01101111FBBBuuuuuu001010.  */
{ "not", 0x206F000A, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, UIMM6_20 }, { C_F }},

/* not<.f> 0,u6 0010011001101111F111uuuuuu001010.  */
{ "not", 0x266F700A, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, UIMM6_20 }, { C_F }},

/* not<.f> b,limm 00100bbb00101111FBBB111110001010.  */
{ "not", 0x202F0F8A, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, LIMM }, { C_F }},

/* not<.f> 0,limm 0010011000101111F111111110001010.  */
{ "not", 0x262F7F8A, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM }, { C_F }},

/* not_s b,c 01111bbbccc10010.  */
{ "not_s", 0x00007812, 0x0000F81F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB_S, RC_S }, { 0 }},

/* or<.f> a,b,c 00100bbb00000101FBBBCCCCCCAAAAAA.  */
{ "or", 0x20050000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* or<.f> 0,b,c 00100bbb00000101FBBBCCCCCC111110.  */
{ "or", 0x2005003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* or<.f><.cc> b,b,c 00100bbb11000101FBBBCCCCCC0QQQQQ.  */
{ "or", 0x20C50000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* or<.f> a,b,u6 00100bbb01000101FBBBuuuuuuAAAAAA.  */
{ "or", 0x20450000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* or<.f> 0,b,u6 00100bbb01000101FBBBuuuuuu111110.  */
{ "or", 0x2045003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* or<.f><.cc> b,b,u6 00100bbb11000101FBBBuuuuuu1QQQQQ.  */
{ "or", 0x20C50020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* or<.f> b,b,s12 00100bbb10000101FBBBssssssSSSSSS.  */
{ "or", 0x20850000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* or<.f> a,limm,c 0010011000000101F111CCCCCCAAAAAA.  */
{ "or", 0x26057000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* or<.f> a,b,limm 00100bbb00000101FBBB111110AAAAAA.  */
{ "or", 0x20050F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* or<.f> 0,limm,c 0010011000000101F111CCCCCC111110.  */
{ "or", 0x2605703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* or<.f> 0,b,limm 00100bbb00000101FBBB111110111110.  */
{ "or", 0x20050FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* or<.f><.cc> b,b,limm 00100bbb11000101FBBB1111100QQQQQ.  */
{ "or", 0x20C50F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* or<.f><.cc> 0,limm,c 0010011011000101F111CCCCCC0QQQQQ.  */
{ "or", 0x26C57000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* or<.f> a,limm,u6 0010011001000101F111uuuuuuAAAAAA.  */
{ "or", 0x26457000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* or<.f> 0,limm,u6 0010011001000101F111uuuuuu111110.  */
{ "or", 0x2645703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* or<.f><.cc> 0,limm,u6 0010011011000101F111uuuuuu1QQQQQ.  */
{ "or", 0x26C57020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* or<.f> 0,limm,s12 0010011010000101F111ssssssSSSSSS.  */
{ "or", 0x26857000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* or<.f> a,limm,limm 0010011000000101F111111110AAAAAA.  */
{ "or", 0x26057F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* or<.f> 0,limm,limm 0010011000000101F111111110111110.  */
{ "or", 0x26057FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* or<.f><.cc> 0,limm,limm 0010011011000101F1111111100QQQQQ.  */
{ "or", 0x26C57F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* or_s b,b,c 01111bbbccc00101.  */
{ "or_s", 0x00007805, 0x0000F81F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* pkqb<.f> a,b,c 00110bbb00100000FBBBCCCCCCAAAAAA.  */
{ "pkqb", 0x30200000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* pkqb<.f><.cc> b,b,c 00110bbb11100000FBBBCCCCCC0QQQQQ.  */
{ "pkqb", 0x30E00000, 0xF8FF0020, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* pkqb<.f> a,b,u6 00110bbb01100000FBBBuuuuuuAAAAAA.  */
{ "pkqb", 0x30600000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* pkqb<.f><.cc> b,b,u6 00110bbb11100000FBBBuuuuuu1QQQQQ.  */
{ "pkqb", 0x30E00020, 0xF8FF0020, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* pkqb<.f> b,b,s12 00110bbb10100000FBBBssssssSSSSSS.  */
{ "pkqb", 0x30A00000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* pkqb<.f> a,limm,c 0011011000100000F111CCCCCCAAAAAA.  */
{ "pkqb", 0x36207000, 0xFFFF7000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* pkqb<.f> a,b,limm 00110bbb00100000FBBB111110AAAAAA.  */
{ "pkqb", 0x30200F80, 0xF8FF0FC0, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* pkqb<.f><.cc> b,b,limm 00110bbb11100000FBBB1111100QQQQQ.  */
{ "pkqb", 0x30E00F80, 0xF8FF0FE0, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* pop_sAA_AB b 11000bbb11000001.  */
{ "pop_s", 0x0000C0C1, 0x0000F8FF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, POP, NONE, { RB_S }, { C_AA_AB }},

/* pop_sAA_AB BLINK 11000RRR11010001.  */
{ "pop_s", 0x0000C0D1, 0x0000F8FF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, POP, NONE, { BLINK_S }, { C_AA_AB }},

/* push_sAA_AW b 11000bbb11100001.  */
{ "push_s", 0x0000C0E1, 0x0000F8FF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, PUSH, NONE, { RB_S }, { C_AA_AW }},

/* push_sAA_AW blink 11000RRR11110001.  */
{ "push_s", 0x0000C0F1, 0x0000F8FF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, PUSH, NONE, { BLINK_S }, { C_AA_AW }},

/* qmach<.f> a,b,c 00101bbb00110100FBBBCCCCCCAAAAAA.  */
{ "qmach", 0x28340000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, RC }, { C_F }},

/* qmach<.f> 0,b,c 00101bbb00110100FBBBCCCCCC111110.  */
{ "qmach", 0x2834003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, RC }, { C_F }},

/* qmach<.f><.cc> b,b,c 00101bbb11110100FBBBCCCCCC0QQQQQ.  */
{ "qmach", 0x28F40000, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* qmach<.f> a,b,u6 00101bbb01110100FBBBuuuuuuAAAAAA.  */
{ "qmach", 0x28740000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* qmach<.f> 0,b,u6 00101bbb01110100FBBBuuuuuu111110.  */
{ "qmach", 0x2874003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { C_F }},

/* qmach<.f><.cc> b,b,u6 00101bbb11110100FBBBuuuuuu1QQQQQ.  */
{ "qmach", 0x28F40020, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* qmach<.f> b,b,s12 00101bbb10110100FBBBssssssSSSSSS.  */
{ "qmach", 0x28B40000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* qmach<.f> a,limm,c 0010111000110100F111CCCCCCAAAAAA.  */
{ "qmach", 0x2E347000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, RC }, { C_F }},

/* qmach<.f> a,b,limm 00101bbb00110100FBBB111110AAAAAA.  */
{ "qmach", 0x28340F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, LIMM }, { C_F }},

/* qmach<.f> 0,limm,c 0010111000110100F111CCCCCC111110.  */
{ "qmach", 0x2E34703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F }},

/* qmach<.f> 0,b,limm 00101bbb00110100FBBB111110111110.  */
{ "qmach", 0x28340FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, LIMM }, { C_F }},

/* qmach<.f><.cc> b,b,limm 00101bbb11110100FBBB1111100QQQQQ.  */
{ "qmach", 0x28F40F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* qmach<.f><.cc> 0,limm,c 0010111011110100F111CCCCCC0QQQQQ.  */
{ "qmach", 0x2EF47000, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* qmach<.f> a,limm,u6 0010111001110100F111uuuuuuAAAAAA.  */
{ "qmach", 0x2E747000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* qmach<.f> 0,limm,u6 0010111001110100F111uuuuuu111110.  */
{ "qmach", 0x2E74703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* qmach<.f><.cc> 0,limm,u6 0010111011110100F111uuuuuu1QQQQQ.  */
{ "qmach", 0x2EF47020, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* qmach<.f> 0,limm,s12 0010111010110100F111ssssssSSSSSS.  */
{ "qmach", 0x2EB47000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* qmach<.f> a,limm,limm 0010111000110100F111111110AAAAAA.  */
{ "qmach", 0x2E347F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* qmach<.f> 0,limm,limm 0010111000110100F111111110111110.  */
{ "qmach", 0x2E347FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F }},

/* qmach<.f><.cc> 0,limm,limm 0010111011110100F1111111100QQQQQ.  */
{ "qmach", 0x2EF47F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* qmachf<.f> a,b,c 00110bbb00110101FBBBCCCCCCAAAAAA.  */
{ "qmachf", 0x30350000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, RC }, { C_F }},

/* qmachf<.f> 0,b,c 00110bbb00110101FBBBCCCCCC111110.  */
{ "qmachf", 0x3035003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, RC }, { C_F }},

/* qmachf<.f><.cc> b,b,c 00110bbb11110101FBBBCCCCCC0QQQQQ.  */
{ "qmachf", 0x30F50000, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* qmachf<.f> a,b,u6 00110bbb01110101FBBBuuuuuuAAAAAA.  */
{ "qmachf", 0x30750000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* qmachf<.f> 0,b,u6 00110bbb01110101FBBBuuuuuu111110.  */
{ "qmachf", 0x3075003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { C_F }},

/* qmachf<.f><.cc> b,b,u6 00110bbb11110101FBBBuuuuuu1QQQQQ.  */
{ "qmachf", 0x30F50020, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* qmachf<.f> b,b,s12 00110bbb10110101FBBBssssssSSSSSS.  */
{ "qmachf", 0x30B50000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* qmachf<.f> a,limm,c 0011011000110101F111CCCCCCAAAAAA.  */
{ "qmachf", 0x36357000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, RC }, { C_F }},

/* qmachf<.f> a,b,limm 00110bbb00110101FBBB111110AAAAAA.  */
{ "qmachf", 0x30350F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, LIMM }, { C_F }},

/* qmachf<.f> 0,limm,c 0011011000110101F111CCCCCC111110.  */
{ "qmachf", 0x3635703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F }},

/* qmachf<.f> 0,b,limm 00110bbb00110101FBBB111110111110.  */
{ "qmachf", 0x30350FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, LIMM }, { C_F }},

/* qmachf<.f><.cc> b,b,limm 00110bbb11110101FBBB1111100QQQQQ.  */
{ "qmachf", 0x30F50F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* qmachf<.f><.cc> 0,limm,c 0011011011110101F111CCCCCC0QQQQQ.  */
{ "qmachf", 0x36F57000, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* qmachf<.f> a,limm,u6 0011011001110101F111uuuuuuAAAAAA.  */
{ "qmachf", 0x36757000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* qmachf<.f> 0,limm,u6 0011011001110101F111uuuuuu111110.  */
{ "qmachf", 0x3675703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* qmachf<.f><.cc> 0,limm,u6 0011011011110101F111uuuuuu1QQQQQ.  */
{ "qmachf", 0x36F57020, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* qmachf<.f> 0,limm,s12 0011011010110101F111ssssssSSSSSS.  */
{ "qmachf", 0x36B57000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* qmachf<.f> a,limm,limm 0011011000110101F111111110AAAAAA.  */
{ "qmachf", 0x36357F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* qmachf<.f> 0,limm,limm 0011011000110101F111111110111110.  */
{ "qmachf", 0x36357FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F }},

/* qmachf<.f><.cc> 0,limm,limm 0011011011110101F1111111100QQQQQ.  */
{ "qmachf", 0x36F57F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* qmachu<.f> a,b,c 00101bbb00110101FBBBCCCCCCAAAAAA.  */
{ "qmachu", 0x28350000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, RC }, { C_F }},

/* qmachu<.f> 0,b,c 00101bbb00110101FBBBCCCCCC111110.  */
{ "qmachu", 0x2835003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, RC }, { C_F }},

/* qmachu<.f><.cc> b,b,c 00101bbb11110101FBBBCCCCCC0QQQQQ.  */
{ "qmachu", 0x28F50000, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* qmachu<.f> a,b,u6 00101bbb01110101FBBBuuuuuuAAAAAA.  */
{ "qmachu", 0x28750000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* qmachu<.f> 0,b,u6 00101bbb01110101FBBBuuuuuu111110.  */
{ "qmachu", 0x2875003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { C_F }},

/* qmachu<.f><.cc> b,b,u6 00101bbb11110101FBBBuuuuuu1QQQQQ.  */
{ "qmachu", 0x28F50020, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* qmachu<.f> b,b,s12 00101bbb10110101FBBBssssssSSSSSS.  */
{ "qmachu", 0x28B50000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* qmachu<.f> a,limm,c 0010111000110101F111CCCCCCAAAAAA.  */
{ "qmachu", 0x2E357000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, RC }, { C_F }},

/* qmachu<.f> a,b,limm 00101bbb00110101FBBB111110AAAAAA.  */
{ "qmachu", 0x28350F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, LIMM }, { C_F }},

/* qmachu<.f> 0,limm,c 0010111000110101F111CCCCCC111110.  */
{ "qmachu", 0x2E35703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F }},

/* qmachu<.f> 0,b,limm 00101bbb00110101FBBB111110111110.  */
{ "qmachu", 0x28350FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, LIMM }, { C_F }},

/* qmachu<.f><.cc> b,b,limm 00101bbb11110101FBBB1111100QQQQQ.  */
{ "qmachu", 0x28F50F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* qmachu<.f><.cc> 0,limm,c 0010111011110101F111CCCCCC0QQQQQ.  */
{ "qmachu", 0x2EF57000, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* qmachu<.f> a,limm,u6 0010111001110101F111uuuuuuAAAAAA.  */
{ "qmachu", 0x2E757000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* qmachu<.f> 0,limm,u6 0010111001110101F111uuuuuu111110.  */
{ "qmachu", 0x2E75703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* qmachu<.f><.cc> 0,limm,u6 0010111011110101F111uuuuuu1QQQQQ.  */
{ "qmachu", 0x2EF57020, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* qmachu<.f> 0,limm,s12 0010111010110101F111ssssssSSSSSS.  */
{ "qmachu", 0x2EB57000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* qmachu<.f> a,limm,limm 0010111000110101F111111110AAAAAA.  */
{ "qmachu", 0x2E357F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* qmachu<.f> 0,limm,limm 0010111000110101F111111110111110.  */
{ "qmachu", 0x2E357FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F }},

/* qmachu<.f><.cc> 0,limm,limm 0010111011110101F1111111100QQQQQ.  */
{ "qmachu", 0x2EF57F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* qmpyh<.f> a,b,c 00101bbb00110000FBBBCCCCCCAAAAAA.  */
{ "qmpyh", 0x28300000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, RC }, { C_F }},

/* qmpyh<.f> 0,b,c 00101bbb00110000FBBBCCCCCC111110.  */
{ "qmpyh", 0x2830003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, RC }, { C_F }},

/* qmpyh<.f><.cc> b,b,c 00101bbb11110000FBBBCCCCCC0QQQQQ.  */
{ "qmpyh", 0x28F00000, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* qmpyh<.f> a,b,u6 00101bbb01110000FBBBuuuuuuAAAAAA.  */
{ "qmpyh", 0x28700000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* qmpyh<.f> 0,b,u6 00101bbb01110000FBBBuuuuuu111110.  */
{ "qmpyh", 0x2870003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { C_F }},

/* qmpyh<.f><.cc> b,b,u6 00101bbb11110000FBBBuuuuuu1QQQQQ.  */
{ "qmpyh", 0x28F00020, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* qmpyh<.f> b,b,s12 00101bbb10110000FBBBssssssSSSSSS.  */
{ "qmpyh", 0x28B00000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* qmpyh<.f> a,limm,c 0010111000110000F111CCCCCCAAAAAA.  */
{ "qmpyh", 0x2E307000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, RC }, { C_F }},

/* qmpyh<.f> a,b,limm 00101bbb00110000FBBB111110AAAAAA.  */
{ "qmpyh", 0x28300F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, LIMM }, { C_F }},

/* qmpyh<.f> 0,limm,c 0010111000110000F111CCCCCC111110.  */
{ "qmpyh", 0x2E30703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F }},

/* qmpyh<.f> 0,b,limm 00101bbb00110000FBBB111110111110.  */
{ "qmpyh", 0x28300FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, LIMM }, { C_F }},

/* qmpyh<.f><.cc> b,b,limm 00101bbb11110000FBBB1111100QQQQQ.  */
{ "qmpyh", 0x28F00F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* qmpyh<.f><.cc> 0,limm,c 0010111011110000F111CCCCCC0QQQQQ.  */
{ "qmpyh", 0x2EF07000, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* qmpyh<.f> a,limm,u6 0010111001110000F111uuuuuuAAAAAA.  */
{ "qmpyh", 0x2E707000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* qmpyh<.f> 0,limm,u6 0010111001110000F111uuuuuu111110.  */
{ "qmpyh", 0x2E70703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* qmpyh<.f><.cc> 0,limm,u6 0010111011110000F111uuuuuu1QQQQQ.  */
{ "qmpyh", 0x2EF07020, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* qmpyh<.f> 0,limm,s12 0010111010110000F111ssssssSSSSSS.  */
{ "qmpyh", 0x2EB07000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* qmpyh<.f> a,limm,limm 0010111000110000F111111110AAAAAA.  */
{ "qmpyh", 0x2E307F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* qmpyh<.f> 0,limm,limm 0010111000110000F111111110111110.  */
{ "qmpyh", 0x2E307FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F }},

/* qmpyh<.f><.cc> 0,limm,limm 0010111011110000F1111111100QQQQQ.  */
{ "qmpyh", 0x2EF07F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* qmpyhf<.f> a,b,c 00110bbb00110001FBBBCCCCCCAAAAAA.  */
{ "qmpyhf", 0x30310000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, RC }, { C_F }},

/* qmpyhf<.f> 0,b,c 00110bbb00110001FBBBCCCCCC111110.  */
{ "qmpyhf", 0x3031003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, RC }, { C_F }},

/* qmpyhf<.f><.cc> b,b,c 00110bbb11110001FBBBCCCCCC0QQQQQ.  */
{ "qmpyhf", 0x30F10000, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* qmpyhf<.f> a,b,u6 00110bbb01110001FBBBuuuuuuAAAAAA.  */
{ "qmpyhf", 0x30710000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* qmpyhf<.f> 0,b,u6 00110bbb01110001FBBBuuuuuu111110.  */
{ "qmpyhf", 0x3071003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { C_F }},

/* qmpyhf<.f><.cc> b,b,u6 00110bbb11110001FBBBuuuuuu1QQQQQ.  */
{ "qmpyhf", 0x30F10020, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* qmpyhf<.f> b,b,s12 00110bbb10110001FBBBssssssSSSSSS.  */
{ "qmpyhf", 0x30B10000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* qmpyhf<.f> a,limm,c 0011011000110001F111CCCCCCAAAAAA.  */
{ "qmpyhf", 0x36317000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, RC }, { C_F }},

/* qmpyhf<.f> a,b,limm 00110bbb00110001FBBB111110AAAAAA.  */
{ "qmpyhf", 0x30310F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, LIMM }, { C_F }},

/* qmpyhf<.f> 0,limm,c 0011011000110001F111CCCCCC111110.  */
{ "qmpyhf", 0x3631703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F }},

/* qmpyhf<.f> 0,b,limm 00110bbb00110001FBBB111110111110.  */
{ "qmpyhf", 0x30310FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, LIMM }, { C_F }},

/* qmpyhf<.f><.cc> b,b,limm 00110bbb11110001FBBB1111100QQQQQ.  */
{ "qmpyhf", 0x30F10F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* qmpyhf<.f><.cc> 0,limm,c 0011011011110001F111CCCCCC0QQQQQ.  */
{ "qmpyhf", 0x36F17000, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* qmpyhf<.f> a,limm,u6 0011011001110001F111uuuuuuAAAAAA.  */
{ "qmpyhf", 0x36717000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* qmpyhf<.f> 0,limm,u6 0011011001110001F111uuuuuu111110.  */
{ "qmpyhf", 0x3671703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* qmpyhf<.f><.cc> 0,limm,u6 0011011011110001F111uuuuuu1QQQQQ.  */
{ "qmpyhf", 0x36F17020, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* qmpyhf<.f> 0,limm,s12 0011011010110001F111ssssssSSSSSS.  */
{ "qmpyhf", 0x36B17000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* qmpyhf<.f> a,limm,limm 0011011000110001F111111110AAAAAA.  */
{ "qmpyhf", 0x36317F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* qmpyhf<.f> 0,limm,limm 0011011000110001F111111110111110.  */
{ "qmpyhf", 0x36317FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F }},

/* qmpyhf<.f><.cc> 0,limm,limm 0011011011110001F1111111100QQQQQ.  */
{ "qmpyhf", 0x36F17F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* qmpyhu<.f> a,b,c 00101bbb00110001FBBBCCCCCCAAAAAA.  */
{ "qmpyhu", 0x28310000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, RC }, { C_F }},

/* qmpyhu<.f> 0,b,c 00101bbb00110001FBBBCCCCCC111110.  */
{ "qmpyhu", 0x2831003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, RC }, { C_F }},

/* qmpyhu<.f><.cc> b,b,c 00101bbb11110001FBBBCCCCCC0QQQQQ.  */
{ "qmpyhu", 0x28F10000, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* qmpyhu<.f> a,b,u6 00101bbb01110001FBBBuuuuuuAAAAAA.  */
{ "qmpyhu", 0x28710000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* qmpyhu<.f> 0,b,u6 00101bbb01110001FBBBuuuuuu111110.  */
{ "qmpyhu", 0x2871003E, 0xF8FF003F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { C_F }},

/* qmpyhu<.f><.cc> b,b,u6 00101bbb11110001FBBBuuuuuu1QQQQQ.  */
{ "qmpyhu", 0x28F10020, 0xF8FF0020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* qmpyhu<.f> b,b,s12 00101bbb10110001FBBBssssssSSSSSS.  */
{ "qmpyhu", 0x28B10000, 0xF8FF0000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* qmpyhu<.f> a,limm,c 0010111000110001F111CCCCCCAAAAAA.  */
{ "qmpyhu", 0x2E317000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, RC }, { C_F }},

/* qmpyhu<.f> a,b,limm 00101bbb00110001FBBB111110AAAAAA.  */
{ "qmpyhu", 0x28310F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, RB, LIMM }, { C_F }},

/* qmpyhu<.f> 0,limm,c 0010111000110001F111CCCCCC111110.  */
{ "qmpyhu", 0x2E31703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F }},

/* qmpyhu<.f> 0,b,limm 00101bbb00110001FBBB111110111110.  */
{ "qmpyhu", 0x28310FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, RB, LIMM }, { C_F }},

/* qmpyhu<.f><.cc> b,b,limm 00101bbb11110001FBBB1111100QQQQQ.  */
{ "qmpyhu", 0x28F10F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* qmpyhu<.f><.cc> 0,limm,c 0010111011110001F111CCCCCC0QQQQQ.  */
{ "qmpyhu", 0x2EF17000, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* qmpyhu<.f> a,limm,u6 0010111001110001F111uuuuuuAAAAAA.  */
{ "qmpyhu", 0x2E717000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* qmpyhu<.f> 0,limm,u6 0010111001110001F111uuuuuu111110.  */
{ "qmpyhu", 0x2E71703E, 0xFFFF703F, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* qmpyhu<.f><.cc> 0,limm,u6 0010111011110001F111uuuuuu1QQQQQ.  */
{ "qmpyhu", 0x2EF17020, 0xFFFF7020, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* qmpyhu<.f> 0,limm,s12 0010111010110001F111ssssssSSSSSS.  */
{ "qmpyhu", 0x2EB17000, 0xFFFF7000, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* qmpyhu<.f> a,limm,limm 0010111000110001F111111110AAAAAA.  */
{ "qmpyhu", 0x2E317F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* qmpyhu<.f> 0,limm,limm 0010111000110001F111111110111110.  */
{ "qmpyhu", 0x2E317FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F }},

/* qmpyhu<.f><.cc> 0,limm,limm 0010111011110001F1111111100QQQQQ.  */
{ "qmpyhu", 0x2EF17F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2HS, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* rcmp b,c 00100bbb000011011BBBCCCCCCRRRRRR.  */
{ "rcmp", 0x200D8000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RC }, { 0 }},

/* rcmp b,c 00100bbb000011011BBBCCCCCC000000.  */
{ "rcmp", 0x200D8000, 0xF8FF803F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, ARITH, NONE, { RB, RC }, { 0 }},

/* rcmp<.cc> b,c 00100bbb110011011BBBCCCCCC0QQQQQ.  */
{ "rcmp", 0x20CD8000, 0xF8FF8020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RC }, { C_CC }},

/* rcmp b,u6 00100bbb010011011BBBuuuuuuRRRRRR.  */
{ "rcmp", 0x204D8000, 0xF8FF8000, ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, UIMM6_20 }, { 0 }},

/* rcmp b,u6 00100bbb010011011BBBuuuuuu000000.  */
{ "rcmp", 0x204D8000, 0xF8FF803F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, ARITH, NONE, { RB, UIMM6_20 }, { 0 }},

/* rcmp<.cc> b,u6 00100bbb110011011BBBuuuuuu1QQQQQ.  */
{ "rcmp", 0x20CD8020, 0xF8FF8020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, UIMM6_20 }, { C_CC }},

/* rcmp b,s12 00100bbb100011011BBBssssssSSSSSS.  */
{ "rcmp", 0x208D8000, 0xF8FF8000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, SIMM12_20 }, { 0 }},

/* rcmp limm,c 00100110000011011111CCCCCCRRRRRR.  */
{ "rcmp", 0x260DF000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, ARITH, NONE, { LIMM, RC }, { 0 }},

/* rcmp b,limm 00100bbb000011011BBB111110RRRRRR.  */
{ "rcmp", 0x200D8F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, LIMM }, { 0 }},

/* rcmp limm,c 00100110000011011111CCCCCC000000.  */
{ "rcmp", 0x260DF000, 0xFFFFF03F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, ARITH, NONE, { LIMM, RC }, { 0 }},

/* rcmp b,limm 00100bbb000011011BBB111110000000.  */
{ "rcmp", 0x200D8F80, 0xF8FF8FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, ARITH, NONE, { RB, LIMM }, { 0 }},

/* rcmp<.cc> limm,c 00100110110011011111CCCCCC0QQQQQ.  */
{ "rcmp", 0x26CDF000, 0xFFFFF020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { LIMM, RC }, { C_CC }},

/* rcmp<.cc> b,limm 00100bbb110011011BBB1111100QQQQQ.  */
{ "rcmp", 0x20CD8F80, 0xF8FF8FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, LIMM }, { C_CC }},

/* rcmp limm,u6 00100110010011011111uuuuuuRRRRRR.  */
{ "rcmp", 0x264DF000, 0xFFFFF000, ARC_OPCODE_ARCv2HS, ARITH, NONE, { LIMM, UIMM6_20 }, { 0 }},

/* rcmp limm,u6 00100110010011011111uuuuuu000000.  */
{ "rcmp", 0x264DF000, 0xFFFFF03F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, ARITH, NONE, { LIMM, UIMM6_20 }, { 0 }},

/* rcmp<.cc> limm,u6 00100110110011011111uuuuuu1QQQQQ.  */
{ "rcmp", 0x26CDF020, 0xFFFFF020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { LIMM, UIMM6_20 }, { C_CC }},

/* rcmp limm,s12 00100110100011011111ssssssSSSSSS.  */
{ "rcmp", 0x268DF000, 0xFFFFF000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { LIMM, SIMM12_20 }, { 0 }},

/* rcmp limm,limm 00100110000011011111111110RRRRRR.  */
{ "rcmp", 0x260DFF80, 0xFFFFFFC0, ARC_OPCODE_ARCv2HS, ARITH, NONE, { LIMM, LIMMdup }, { 0 }},

/* rcmp limm,limm 00100110000011011111111110000000.  */
{ "rcmp", 0x260DFF80, 0xFFFFFFFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, ARITH, NONE, { LIMM, LIMMdup }, { 0 }},

/* rcmp<.cc> limm,limm 001001101100110111111111100QQQQQ.  */
{ "rcmp", 0x26CDFF80, 0xFFFFFFE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { LIMM, LIMMdup }, { C_CC }},

/* rem<.f> a,b,c 00101bbb00001000FBBBCCCCCCAAAAAA.  */
{ "rem", 0x28080000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, RB, RC }, { C_F }},

/* rem<.f> 0,b,c 00101bbb00001000FBBBCCCCCC111110.  */
{ "rem", 0x2808003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, RB, RC }, { C_F }},

/* rem<.f><.cc> b,b,c 00101bbb11001000FBBBCCCCCC0QQQQQ.  */
{ "rem", 0x28C80000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* rem<.f> a,b,c 00101bbb00001000FBBBCCCCCCAAAAAA.  */
{ "rem", 0x28080000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RA_CHK, RB, RC }, { C_F }},

/* rem<.f> 0,b,c 00101bbb00001000FBBBCCCCCC111110.  */
{ "rem", 0x2808003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, RB, RC }, { C_F }},

/* rem<.f><.cc> b,b,c 00101bbb11001000FBBBCCCCCC0QQQQQ.  */
{ "rem", 0x28C80000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* rem<.f> a,b,u6 00101bbb01001000FBBBuuuuuuAAAAAA.  */
{ "rem", 0x28480000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* rem<.f> 0,b,u6 00101bbb01001000FBBBuuuuuu111110.  */
{ "rem", 0x2848003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, RB, UIMM6_20 }, { C_F }},

/* rem<.f><.cc> b,b,u6 00101bbb11001000FBBBuuuuuu1QQQQQ.  */
{ "rem", 0x28C80020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* rem<.f> a,b,u6 00101bbb01001000FBBBuuuuuuAAAAAA.  */
{ "rem", 0x28480000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* rem<.f> 0,b,u6 00101bbb01001000FBBBuuuuuu111110.  */
{ "rem", 0x2848003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, RB, UIMM6_20 }, { C_F }},

/* rem<.f><.cc> b,b,u6 00101bbb11001000FBBBuuuuuu1QQQQQ.  */
{ "rem", 0x28C80020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* rem<.f> b,b,s12 00101bbb10001000FBBBssssssSSSSSS.  */
{ "rem", 0x28880000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* rem<.f> b,b,s12 00101bbb10001000FBBBssssssSSSSSS.  */
{ "rem", 0x28880000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* rem<.f> a,limm,c 0010111000001000F111CCCCCCAAAAAA.  */
{ "rem", 0x2E087000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, LIMM, RC }, { C_F }},

/* rem<.f> a,b,limm 00101bbb00001000FBBB111110AAAAAA.  */
{ "rem", 0x28080F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, RB, LIMM }, { C_F }},

/* rem<.f> 0,limm,c 0010111000001000F111CCCCCC111110.  */
{ "rem", 0x2E08703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, RC }, { C_F }},

/* rem<.f> 0,b,limm 00101bbb00001000FBBB111110111110.  */
{ "rem", 0x28080FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, RB, LIMM }, { C_F }},

/* rem<.f><.cc> b,b,limm 00101bbb11001000FBBB1111100QQQQQ.  */
{ "rem", 0x28C80F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* rem<.f><.cc> 0,limm,c 0010111011001000F111CCCCCC0QQQQQ.  */
{ "rem", 0x2EC87000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, RC }, { C_F, C_CC }},

/* rem<.f> a,limm,c 0010111000001000F111CCCCCCAAAAAA.  */
{ "rem", 0x2E087000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RA_CHK, LIMM, RC }, { C_F }},

/* rem<.f> a,b,limm 00101bbb00001000FBBB111110AAAAAA.  */
{ "rem", 0x28080F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RA_CHK, RB, LIMM }, { C_F }},

/* rem<.f> 0,limm,c 0010111000001000F111CCCCCC111110.  */
{ "rem", 0x2E08703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, LIMM, RC }, { C_F }},

/* rem<.f> 0,b,limm 00101bbb00001000FBBB111110111110.  */
{ "rem", 0x28080FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, RB, LIMM }, { C_F }},

/* rem<.f><.cc> b,b,limm 00101bbb11001000FBBB1111100QQQQQ.  */
{ "rem", 0x28C80F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* rem<.f><.cc> 0,limm,c 0010111011001000F111CCCCCC0QQQQQ.  */
{ "rem", 0x2EC87000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, LIMM, RC }, { C_F, C_CC }},

/* rem<.f> a,limm,u6 0010111001001000F111uuuuuuAAAAAA.  */
{ "rem", 0x2E487000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* rem<.f> 0,limm,u6 0010111001001000F111uuuuuu111110.  */
{ "rem", 0x2E48703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* rem<.f><.cc> 0,limm,u6 0010111011001000F111uuuuuu1QQQQQ.  */
{ "rem", 0x2EC87020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* rem<.f> a,limm,u6 0010111001001000F111uuuuuuAAAAAA.  */
{ "rem", 0x2E487000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* rem<.f> 0,limm,u6 0010111001001000F111uuuuuu111110.  */
{ "rem", 0x2E48703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* rem<.f><.cc> 0,limm,u6 0010111011001000F111uuuuuu1QQQQQ.  */
{ "rem", 0x2EC87020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* rem<.f> 0,limm,s12 0010111010001000F111ssssssSSSSSS.  */
{ "rem", 0x2E887000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* rem<.f> 0,limm,s12 0010111010001000F111ssssssSSSSSS.  */
{ "rem", 0x2E887000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* rem<.f> a,limm,limm 0010111000001000F111111110AAAAAA.  */
{ "rem", 0x2E087F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* rem<.f> 0,limm,limm 0010111000001000F111111110111110.  */
{ "rem", 0x2E087FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, LIMMdup }, { C_F }},

/* rem<.f><.cc> 0,limm,limm 0010111011001000F1111111100QQQQQ.  */
{ "rem", 0x2EC87F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* rem<.f> a,limm,limm 0010111000001000F111111110AAAAAA.  */
{ "rem", 0x2E087F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* rem<.f> 0,limm,limm 0010111000001000F111111110111110.  */
{ "rem", 0x2E087FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, LIMM, LIMMdup }, { C_F }},

/* rem<.f><.cc> 0,limm,limm 0010111011001000F1111111100QQQQQ.  */
{ "rem", 0x2EC87F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* remu<.f> a,b,c 00101bbb00001001FBBBCCCCCCAAAAAA.  */
{ "remu", 0x28090000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, RB, RC }, { C_F }},

/* remu<.f> 0,b,c 00101bbb00001001FBBBCCCCCC111110.  */
{ "remu", 0x2809003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, RB, RC }, { C_F }},

/* remu<.f><.cc> b,b,c 00101bbb11001001FBBBCCCCCC0QQQQQ.  */
{ "remu", 0x28C90000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* remu<.f> a,b,c 00101bbb00001001FBBBCCCCCCAAAAAA.  */
{ "remu", 0x28090000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RA_CHK, RB, RC }, { C_F }},

/* remu<.f> 0,b,c 00101bbb00001001FBBBCCCCCC111110.  */
{ "remu", 0x2809003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, RB, RC }, { C_F }},

/* remu<.f><.cc> b,b,c 00101bbb11001001FBBBCCCCCC0QQQQQ.  */
{ "remu", 0x28C90000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* remu<.f> a,b,u6 00101bbb01001001FBBBuuuuuuAAAAAA.  */
{ "remu", 0x28490000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* remu<.f> 0,b,u6 00101bbb01001001FBBBuuuuuu111110.  */
{ "remu", 0x2849003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, RB, UIMM6_20 }, { C_F }},

/* remu<.f><.cc> b,b,u6 00101bbb11001001FBBBuuuuuu1QQQQQ.  */
{ "remu", 0x28C90020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* remu<.f> a,b,u6 00101bbb01001001FBBBuuuuuuAAAAAA.  */
{ "remu", 0x28490000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* remu<.f> 0,b,u6 00101bbb01001001FBBBuuuuuu111110.  */
{ "remu", 0x2849003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, RB, UIMM6_20 }, { C_F }},

/* remu<.f><.cc> b,b,u6 00101bbb11001001FBBBuuuuuu1QQQQQ.  */
{ "remu", 0x28C90020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* remu<.f> b,b,s12 00101bbb10001001FBBBssssssSSSSSS.  */
{ "remu", 0x28890000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* remu<.f> b,b,s12 00101bbb10001001FBBBssssssSSSSSS.  */
{ "remu", 0x28890000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* remu<.f> a,limm,c 0010111000001001F111CCCCCCAAAAAA.  */
{ "remu", 0x2E097000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, LIMM, RC }, { C_F }},

/* remu<.f> a,b,limm 00101bbb00001001FBBB111110AAAAAA.  */
{ "remu", 0x28090F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, RB, LIMM }, { C_F }},

/* remu<.f> 0,limm,c 0010111000001001F111CCCCCC111110.  */
{ "remu", 0x2E09703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, RC }, { C_F }},

/* remu<.f> 0,b,limm 00101bbb00001001FBBB111110111110.  */
{ "remu", 0x28090FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, RB, LIMM }, { C_F }},

/* remu<.f><.cc> b,b,limm 00101bbb11001001FBBB1111100QQQQQ.  */
{ "remu", 0x28C90F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* remu<.f><.cc> 0,limm,c 0010111011001001F111CCCCCC0QQQQQ.  */
{ "remu", 0x2EC97000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, RC }, { C_F, C_CC }},

/* remu<.f> a,limm,c 0010111000001001F111CCCCCCAAAAAA.  */
{ "remu", 0x2E097000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RA_CHK, LIMM, RC }, { C_F }},

/* remu<.f> a,b,limm 00101bbb00001001FBBB111110AAAAAA.  */
{ "remu", 0x28090F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RA_CHK, RB, LIMM }, { C_F }},

/* remu<.f> 0,limm,c 0010111000001001F111CCCCCC111110.  */
{ "remu", 0x2E09703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, LIMM, RC }, { C_F }},

/* remu<.f> 0,b,limm 00101bbb00001001FBBB111110111110.  */
{ "remu", 0x28090FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, RB, LIMM }, { C_F }},

/* remu<.f><.cc> b,b,limm 00101bbb11001001FBBB1111100QQQQQ.  */
{ "remu", 0x28C90F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* remu<.f><.cc> 0,limm,c 0010111011001001F111CCCCCC0QQQQQ.  */
{ "remu", 0x2EC97000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, LIMM, RC }, { C_F, C_CC }},

/* remu<.f> a,limm,u6 0010111001001001F111uuuuuuAAAAAA.  */
{ "remu", 0x2E497000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* remu<.f> 0,limm,u6 0010111001001001F111uuuuuu111110.  */
{ "remu", 0x2E49703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* remu<.f><.cc> 0,limm,u6 0010111011001001F111uuuuuu1QQQQQ.  */
{ "remu", 0x2EC97020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* remu<.f> a,limm,u6 0010111001001001F111uuuuuuAAAAAA.  */
{ "remu", 0x2E497000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* remu<.f> 0,limm,u6 0010111001001001F111uuuuuu111110.  */
{ "remu", 0x2E49703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* remu<.f><.cc> 0,limm,u6 0010111011001001F111uuuuuu1QQQQQ.  */
{ "remu", 0x2EC97020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* remu<.f> 0,limm,s12 0010111010001001F111ssssssSSSSSS.  */
{ "remu", 0x2E897000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* remu<.f> 0,limm,s12 0010111010001001F111ssssssSSSSSS.  */
{ "remu", 0x2E897000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* remu<.f> a,limm,limm 0010111000001001F111111110AAAAAA.  */
{ "remu", 0x2E097F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* remu<.f> 0,limm,limm 0010111000001001F111111110111110.  */
{ "remu", 0x2E097FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, LIMMdup }, { C_F }},

/* remu<.f><.cc> 0,limm,limm 0010111011001001F1111111100QQQQQ.  */
{ "remu", 0x2EC97F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DIVREM, DIV, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* remu<.f> a,limm,limm 0010111000001001F111111110AAAAAA.  */
{ "remu", 0x2E097F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* remu<.f> 0,limm,limm 0010111000001001F111111110111110.  */
{ "remu", 0x2E097FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, LIMM, LIMMdup }, { C_F }},

/* remu<.f><.cc> 0,limm,limm 0010111011001001F1111111100QQQQQ.  */
{ "remu", 0x2EC97F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, DIV, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* rlc<.f> b,c 00100bbb00101111FBBBCCCCCC001011.  */
{ "rlc", 0x202F000B, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RC }, { C_F }},

/* rlc<.f> 0,c 0010011000101111F111CCCCCC001011.  */
{ "rlc", 0x262F700B, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RC }, { C_F }},

/* rlc<.f> b,u6 00100bbb01101111FBBBuuuuuu001011.  */
{ "rlc", 0x206F000B, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, UIMM6_20 }, { C_F }},

/* rlc<.f> 0,u6 0010011001101111F111uuuuuu001011.  */
{ "rlc", 0x266F700B, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, UIMM6_20 }, { C_F }},

/* rlc<.f> b,limm 00100bbb00101111FBBB111110001011.  */
{ "rlc", 0x202F0F8B, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, LIMM }, { C_F }},

/* rlc<.f> 0,limm 0010011000101111F111111110001011.  */
{ "rlc", 0x262F7F8B, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM }, { C_F }},

/* rnd16<.f> b,c 00101bbb00101111FBBBCCCCCC000011.  */
{ "rnd16", 0x282F0003, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, RC }, { C_F }},

/* rnd16<.f> 0,c 0010111000101111F111CCCCCC000011.  */
{ "rnd16", 0x2E2F7003, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, RC }, { C_F }},

/* rnd16<.f> b,u6 00101bbb01101111FBBBuuuuuu000011.  */
{ "rnd16", 0x286F0003, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* rnd16<.f> 0,u6 0010111001101111F111uuuuuu000011.  */
{ "rnd16", 0x2E6F7003, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* rnd16<.f> b,limm 00101bbb00101111FBBB111110000011.  */
{ "rnd16", 0x282F0F83, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, LIMM }, { C_F }},

/* rnd16<.f> 0,limm 0010111000101111F111111110000011.  */
{ "rnd16", 0x2E2F7F83, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* rndh<.f> b,c 00101bbb00101111FBBBCCCCCC000011.  */
{ "rndh", 0x282F0003, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RC }, { C_F }},

/* rndh<.f> 0,c 0010111000101111F111CCCCCC000011.  */
{ "rndh", 0x2E2F7003, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RC }, { C_F }},

/* rndh<.f> b,u6 00101bbb01101111FBBBuuuuuu000011.  */
{ "rndh", 0x286F0003, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, UIMM6_20 }, { C_F }},

/* rndh<.f> 0,u6 0010111001101111F111uuuuuu000011.  */
{ "rndh", 0x2E6F7003, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, UIMM6_20 }, { C_F }},

/* rndh<.f> b,limm 00101bbb00101111FBBB111110000011.  */
{ "rndh", 0x282F0F83, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, LIMM }, { C_F }},

/* rndh<.f> 0,limm 0010111000101111F111111110000011.  */
{ "rndh", 0x2E2F7F83, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM }, { C_F }},

/* rol<.f> b,c 00100bbb00101111FBBBCCCCCC001101.  */
{ "rol", 0x202F000D, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RC }, { C_F }},

/* rol<.f> 0,c 0010011000101111F111CCCCCC001101.  */
{ "rol", 0x262F700D, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RC }, { C_F }},

/* rol<.f> b,u6 00100bbb01101111FBBBuuuuuu001101.  */
{ "rol", 0x206F000D, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, UIMM6_20 }, { C_F }},

/* rol<.f> 0,u6 0010011001101111F111uuuuuu001101.  */
{ "rol", 0x266F700D, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, UIMM6_20 }, { C_F }},

/* rol<.f> b,limm 00100bbb00101111FBBB111110001101.  */
{ "rol", 0x202F0F8D, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, LIMM }, { C_F }},

/* rol<.f> 0,limm 0010011000101111F111111110001101.  */
{ "rol", 0x262F7F8D, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM }, { C_F }},

/* rol8<.f> b,c 00101bbb00101111FBBBCCCCCC010000.  */
{ "rol8", 0x282F0010, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT1, { RB, RC }, { C_F }},

/* rol8<.f> 0,c 0010111000101111F111CCCCCC010000.  */
{ "rol8", 0x2E2F7010, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT1, { ZA, RC }, { C_F }},

/* rol8<.f> b,u6 00101bbb01101111FBBBuuuuuu010000.  */
{ "rol8", 0x286F0010, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT1, { RB, UIMM6_20 }, { C_F }},

/* rol8<.f> 0,u6 0010111001101111F111uuuuuu010000.  */
{ "rol8", 0x2E6F7010, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT1, { ZA, UIMM6_20 }, { C_F }},

/* rol8<.f> b,limm 00101bbb00101111FBBB111110010000.  */
{ "rol8", 0x282F0F90, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT1, { RB, LIMM }, { C_F }},

/* rol8<.f> 0,limm 0010111000101111F111111110010000.  */
{ "rol8", 0x2E2F7F90, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT1, { ZA, LIMM }, { C_F }},

/* ror<.f> b,c 00100bbb00101111FBBBCCCCCC000011.  */
{ "ror", 0x202F0003, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RC }, { C_F }},

/* ror<.f> 0,c 0010011000101111F111CCCCCC000011.  */
{ "ror", 0x262F7003, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RC }, { C_F }},

/* ror<.f> a,b,c 00101bbb00000011FBBBCCCCCCAAAAAA.  */
{ "ror", 0x28030000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, RB, RC }, { C_F }},

/* ror<.f> 0,b,c 00101bbb00000011FBBBCCCCCC111110.  */
{ "ror", 0x2803003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, RB, RC }, { C_F }},

/* ror<.f><.cc> b,b,c 00101bbb11000011FBBBCCCCCC0QQQQQ.  */
{ "ror", 0x28C30000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB, RBdup, RC }, { C_F, C_CC }},

/* ror<.f> b,u6 00100bbb01101111FBBBuuuuuu000011.  */
{ "ror", 0x206F0003, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, UIMM6_20 }, { C_F }},

/* ror<.f> 0,u6 0010011001101111F111uuuuuu000011.  */
{ "ror", 0x266F7003, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, UIMM6_20 }, { C_F }},

/* ror<.f> a,b,u6 00101bbb01000011FBBBuuuuuuAAAAAA.  */
{ "ror", 0x28430000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, RB, UIMM6_20 }, { C_F }},

/* ror<.f> 0,b,u6 00101bbb01000011FBBBuuuuuu111110.  */
{ "ror", 0x2843003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, RB, UIMM6_20 }, { C_F }},

/* ror<.f><.cc> b,b,u6 00101bbb11000011FBBBuuuuuu1QQQQQ.  */
{ "ror", 0x28C30020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* ror<.f> b,b,s12 00101bbb10000011FBBBssssssSSSSSS.  */
{ "ror", 0x28830000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB, RBdup, SIMM12_20 }, { C_F }},

/* ror<.f> b,limm 00100bbb00101111FBBB111110000011.  */
{ "ror", 0x202F0F83, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, LIMM }, { C_F }},

/* ror<.f> 0,limm 0010011000101111F111111110000011.  */
{ "ror", 0x262F7F83, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM }, { C_F }},

/* ror<.f> a,limm,c 0010111000000011F111CCCCCCAAAAAA.  */
{ "ror", 0x2E037000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, LIMM, RC }, { C_F }},

/* ror<.f> a,b,limm 00101bbb00000011FBBB111110AAAAAA.  */
{ "ror", 0x28030F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, RB, LIMM }, { C_F }},

/* ror<.f> 0,limm,c 0010111000000011F111CCCCCC111110.  */
{ "ror", 0x2E03703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, RC }, { C_F }},

/* ror<.f> 0,b,limm 00101bbb00000011FBBB111110111110.  */
{ "ror", 0x28030FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, RB, LIMM }, { C_F }},

/* ror<.f><.cc> b,b,limm 00101bbb11000011FBBB1111100QQQQQ.  */
{ "ror", 0x28C30F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* ror<.f><.cc> 0,limm,c 0010111011000011F111CCCCCC0QQQQQ.  */
{ "ror", 0x2EC37000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, RC }, { C_F, C_CC }},

/* ror<.f> a,limm,u6 0010111001000011F111uuuuuuAAAAAA.  */
{ "ror", 0x2E437000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, LIMM, UIMM6_20 }, { C_F }},

/* ror<.f> 0,limm,u6 0010111001000011F111uuuuuu111110.  */
{ "ror", 0x2E43703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* ror<.f><.cc> 0,limm,u6 0010111011000011F111uuuuuu1QQQQQ.  */
{ "ror", 0x2EC37020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* ror<.f> 0,limm,s12 0010111010000011F111ssssssSSSSSS.  */
{ "ror", 0x2E837000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* ror<.f> a,limm,limm 0010111000000011F111111110AAAAAA.  */
{ "ror", 0x2E037F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { RA, LIMM, LIMMdup }, { C_F }},

/* ror<.f> 0,limm,limm 0010111000000011F111111110111110.  */
{ "ror", 0x2E037FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, LIMMdup }, { C_F }},

/* ror<.f><.cc> 0,limm,limm 0010111011000011F1111111100QQQQQ.  */
{ "ror", 0x2EC37F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT2, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* ror8<.f> b,c 00101bbb00101111FBBBCCCCCC010001.  */
{ "ror8", 0x282F0011, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT1, { RB, RC }, { C_F }},

/* ror8<.f> 0,c 0010111000101111F111CCCCCC010001.  */
{ "ror8", 0x2E2F7011, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT1, { ZA, RC }, { C_F }},

/* ror8<.f> b,u6 00101bbb01101111FBBBuuuuuu010001.  */
{ "ror8", 0x286F0011, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT1, { RB, UIMM6_20 }, { C_F }},

/* ror8<.f> 0,u6 0010111001101111F111uuuuuu010001.  */
{ "ror8", 0x2E6F7011, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT1, { ZA, UIMM6_20 }, { C_F }},

/* ror8<.f> b,limm 00101bbb00101111FBBB111110010001.  */
{ "ror8", 0x282F0F91, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT1, { RB, LIMM }, { C_F }},

/* ror8<.f> 0,limm 0010111000101111F111111110010001.  */
{ "ror8", 0x2E2F7F91, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, SHFT1, { ZA, LIMM }, { C_F }},

/* rrc<.f> b,c 00100bbb00101111FBBBCCCCCC000100.  */
{ "rrc", 0x202F0004, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, RC }, { C_F }},

/* rrc<.f> 0,c 0010011000101111F111CCCCCC000100.  */
{ "rrc", 0x262F7004, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, RC }, { C_F }},

/* rrc<.f> b,u6 00100bbb01101111FBBBuuuuuu000100.  */
{ "rrc", 0x206F0004, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, UIMM6_20 }, { C_F }},

/* rrc<.f> 0,u6 0010011001101111F111uuuuuu000100.  */
{ "rrc", 0x266F7004, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, UIMM6_20 }, { C_F }},

/* rrc<.f> b,limm 00100bbb00101111FBBB111110000100.  */
{ "rrc", 0x202F0F84, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { RB, LIMM }, { C_F }},

/* rrc<.f> 0,limm 0010011000101111F111111110000100.  */
{ "rrc", 0x262F7F84, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, NONE, { ZA, LIMM }, { C_F }},

/* rsub<.f> a,b,c 00100bbb00001110FBBBCCCCCCAAAAAA.  */
{ "rsub", 0x200E0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* rsub<.f> 0,b,c 00100bbb00001110FBBBCCCCCC111110.  */
{ "rsub", 0x200E003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* rsub<.f><.cc> b,b,c 00100bbb11001110FBBBCCCCCC0QQQQQ.  */
{ "rsub", 0x20CE0000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* rsub<.f> a,b,u6 00100bbb01001110FBBBuuuuuuAAAAAA.  */
{ "rsub", 0x204E0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* rsub<.f> 0,b,u6 00100bbb01001110FBBBuuuuuu111110.  */
{ "rsub", 0x204E003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* rsub<.f><.cc> b,b,u6 00100bbb11001110FBBBuuuuuu1QQQQQ.  */
{ "rsub", 0x20CE0020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* rsub<.f> b,b,s12 00100bbb10001110FBBBssssssSSSSSS.  */
{ "rsub", 0x208E0000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* rsub<.f> a,limm,c 0010011000001110F111CCCCCCAAAAAA.  */
{ "rsub", 0x260E7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* rsub<.f> a,b,limm 00100bbb00001110FBBB111110AAAAAA.  */
{ "rsub", 0x200E0F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* rsub<.f> 0,limm,c 0010011000001110F111CCCCCC111110.  */
{ "rsub", 0x260E703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* rsub<.f> 0,b,limm 00100bbb00001110FBBB111110111110.  */
{ "rsub", 0x200E0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* rsub<.f><.cc> b,b,limm 00100bbb11001110FBBB1111100QQQQQ.  */
{ "rsub", 0x20CE0F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* rsub<.f><.cc> 0,limm,c 0010011011001110F111CCCCCC0QQQQQ.  */
{ "rsub", 0x26CE7000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* rsub<.f> a,limm,u6 0010011001001110F111uuuuuuAAAAAA.  */
{ "rsub", 0x264E7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* rsub<.f> 0,limm,u6 0010011001001110F111uuuuuu111110.  */
{ "rsub", 0x264E703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* rsub<.f><.cc> 0,limm,u6 0010011011001110F111uuuuuu1QQQQQ.  */
{ "rsub", 0x26CE7020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* rsub<.f> 0,limm,s12 0010011010001110F111ssssssSSSSSS.  */
{ "rsub", 0x268E7000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* rsub<.f> a,limm,limm 0010011000001110F111111110AAAAAA.  */
{ "rsub", 0x260E7F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* rsub<.f> 0,limm,limm 0010011000001110F111111110111110.  */
{ "rsub", 0x260E7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* rsub<.f><.cc> 0,limm,limm 0010011011001110F1111111100QQQQQ.  */
{ "rsub", 0x26CE7F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* rtie  00100100011011110000000000111111.  */
{ "rtie", 0x246F003F, 0xFFFFFFFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, KERNEL, NONE, { 0 }, { 0 }},

/* rtsc b,0 00110bbb01101111RBBB000000011010.  */
{ "rtsc", 0x306F001A, 0xF8FF0FFF, ARC_OPCODE_ARC700, CONTROL, NONE, { RB, ZB }, { 0 }},

/* rtsc 0,0 0011011001101111R111000000011010.  */
{ "rtsc", 0x366F701A, 0xFFFF7FFF, ARC_OPCODE_ARC700, CONTROL, NONE, { ZA, ZB }, { 0 }},

/* rtsc b,c 00110bbb00101111RBBBCCCCCC011010.  */
{ "rtsc", 0x302F001A, 0xF8FF003F, ARC_OPCODE_ARC700, CONTROL, NONE, { RB, RC }, { 0 }},

/* rtsc 0,c 0011011000101111R111CCCCCC011010.  */
{ "rtsc", 0x362F701A, 0xFFFF703F, ARC_OPCODE_ARC700, CONTROL, NONE, { ZA, RC }, { 0 }},

/* rtsc b,u6 00110bbb01101111RBBBuuuuuu011010.  */
{ "rtsc", 0x306F001A, 0xF8FF003F, ARC_OPCODE_ARC700, CONTROL, NONE, { RB, UIMM6_20 }, { 0 }},

/* rtsc 0,u6 0011011001101111R111uuuuuu011010.  */
{ "rtsc", 0x366F701A, 0xFFFF703F, ARC_OPCODE_ARC700, CONTROL, NONE, { ZA, UIMM6_20 }, { 0 }},

/* rtsc b,limm 00110bbb00101111RBBB111110011010.  */
{ "rtsc", 0x302F0F9A, 0xF8FF0FFF, ARC_OPCODE_ARC700, CONTROL, NONE, { RB, LIMM }, { 0 }},

/* rtsc 0,limm 0011011000101111R111111110011010.  */
{ "rtsc", 0x362F7F9A, 0xFFFF7FFF, ARC_OPCODE_ARC700, CONTROL, NONE, { ZA, LIMM }, { 0 }},

/* rtsc 0011011001101111R111000000011010.  */
{ "rtsc", 0x366F701A, 0xFFFF7FFF, ARC_OPCODE_ARC700, CONTROL, NONE, { 0 }, { 0 }},

/* sat16<.f> b,c 00101bbb00101111FBBBCCCCCC000010.  */
{ "sat16", 0x282F0002, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, RC }, { C_F }},

/* sat16<.f> 0,c 0010111000101111F111CCCCCC000010.  */
{ "sat16", 0x2E2F7002, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, RC }, { C_F }},

/* sat16<.f> b,u6 00101bbb01101111FBBBuuuuuu000010.  */
{ "sat16", 0x286F0002, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* sat16<.f> 0,u6 0010111001101111F111uuuuuu000010.  */
{ "sat16", 0x2E6F7002, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* sat16<.f> b,limm 00101bbb00101111FBBB111110000010.  */
{ "sat16", 0x282F0F82, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, LIMM }, { C_F }},

/* sat16<.f> 0,limm 0010111000101111F111111110000010.  */
{ "sat16", 0x2E2F7F82, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* satf<.f> b,c 00101bbb00101111FBBBCCCCCC011010.  */
{ "satf", 0x282F001A, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RC }, { C_F }},

/* satf<.f> 0,c 0010111000101111F111CCCCCC011010.  */
{ "satf", 0x2E2F701A, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RC }, { C_F }},

/* satf<.f> b,u6 00101bbb01101111FBBBuuuuuu011010.  */
{ "satf", 0x286F001A, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, UIMM6_20 }, { C_F }},

/* satf<.f> 0,u6 0010111001101111F111uuuuuu011010.  */
{ "satf", 0x2E6F701A, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, UIMM6_20 }, { C_F }},

/* satf<.f> b,limm 00101bbb00101111FBBB111110011010.  */
{ "satf", 0x282F0F9A, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, LIMM }, { C_F }},

/* satf<.f> 0,limm 0010111000101111F111111110011010.  */
{ "satf", 0x2E2F7F9A, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM }, { C_F }},

/* sath<.f> b,c 00101bbb00101111FBBBCCCCCC000010.  */
{ "sath", 0x282F0002, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RC }, { C_F }},

/* sath<.f> 0,c 0010111000101111F111CCCCCC000010.  */
{ "sath", 0x2E2F7002, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RC }, { C_F }},

/* sath<.f> b,u6 00101bbb01101111FBBBuuuuuu000010.  */
{ "sath", 0x286F0002, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, UIMM6_20 }, { C_F }},

/* sath<.f> 0,u6 0010111001101111F111uuuuuu000010.  */
{ "sath", 0x2E6F7002, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, UIMM6_20 }, { C_F }},

/* sath<.f> b,limm 00101bbb00101111FBBB111110000010.  */
{ "sath", 0x282F0F82, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, LIMM }, { C_F }},

/* sath<.f> 0,limm 0010111000101111F111111110000010.  */
{ "sath", 0x2E2F7F82, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM }, { C_F }},

/* sbc<.f> a,b,c 00100bbb00000011FBBBCCCCCCAAAAAA.  */
{ "sbc", 0x20030000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* sbc<.f> 0,b,c 00100bbb00000011FBBBCCCCCC111110.  */
{ "sbc", 0x2003003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* sbc<.f><.cc> b,b,c 00100bbb11000011FBBBCCCCCC0QQQQQ.  */
{ "sbc", 0x20C30000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* sbc<.f> a,b,u6 00100bbb01000011FBBBuuuuuuAAAAAA.  */
{ "sbc", 0x20430000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* sbc<.f> 0,b,u6 00100bbb01000011FBBBuuuuuu111110.  */
{ "sbc", 0x2043003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* sbc<.f><.cc> b,b,u6 00100bbb11000011FBBBuuuuuu1QQQQQ.  */
{ "sbc", 0x20C30020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* sbc<.f> b,b,s12 00100bbb10000011FBBBssssssSSSSSS.  */
{ "sbc", 0x20830000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* sbc<.f> a,limm,c 0010011000000011F111CCCCCCAAAAAA.  */
{ "sbc", 0x26037000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* sbc<.f> a,b,limm 00100bbb00000011FBBB111110AAAAAA.  */
{ "sbc", 0x20030F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* sbc<.f> 0,limm,c 0010011000000011F111CCCCCC111110.  */
{ "sbc", 0x2603703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* sbc<.f> 0,b,limm 00100bbb00000011FBBB111110111110.  */
{ "sbc", 0x20030FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* sbc<.f><.cc> b,b,limm 00100bbb11000011FBBB1111100QQQQQ.  */
{ "sbc", 0x20C30F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* sbc<.f><.cc> 0,limm,c 0010011011000011F111CCCCCC0QQQQQ.  */
{ "sbc", 0x26C37000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* sbc<.f> a,limm,u6 0010011001000011F111uuuuuuAAAAAA.  */
{ "sbc", 0x26437000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* sbc<.f> 0,limm,u6 0010011001000011F111uuuuuu111110.  */
{ "sbc", 0x2643703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* sbc<.f><.cc> 0,limm,u6 0010011011000011F111uuuuuu1QQQQQ.  */
{ "sbc", 0x26C37020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* sbc<.f> 0,limm,s12 0010011010000011F111ssssssSSSSSS.  */
{ "sbc", 0x26837000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* sbc<.f> a,limm,limm 0010011000000011F111111110AAAAAA.  */
{ "sbc", 0x26037F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* sbc<.f> 0,limm,limm 0010011000000011F111111110111110.  */
{ "sbc", 0x26037FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* sbc<.f><.cc> 0,limm,limm 0010011011000011F1111111100QQQQQ.  */
{ "sbc", 0x26C37F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* sbcs<.f> a,b,c 00101bbb00100111FBBBCCCCCCAAAAAA.  */
{ "sbcs", 0x28270000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* sbcs<.f> 0,b,c 00101bbb00100111FBBBCCCCCC111110.  */
{ "sbcs", 0x2827003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* sbcs<.f><.cc> b,b,c 00101bbb11100111FBBBCCCCCC0QQQQQ.  */
{ "sbcs", 0x28E70000, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* sbcs<.f> a,b,u6 00101bbb01100111FBBBuuuuuuAAAAAA.  */
{ "sbcs", 0x28670000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* sbcs<.f> 0,b,u6 00101bbb01100111FBBBuuuuuu111110.  */
{ "sbcs", 0x2867003E, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* sbcs<.f><.cc> b,b,u6 00101bbb11100111FBBBuuuuuu1QQQQQ.  */
{ "sbcs", 0x28E70020, 0xF8FF0020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* sbcs<.f> b,b,s12 00101bbb10100111FBBBssssssSSSSSS.  */
{ "sbcs", 0x28A70000, 0xF8FF0000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* sbcs<.f> a,limm,c 0010111000100111F111CCCCCCAAAAAA.  */
{ "sbcs", 0x2E277000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* sbcs<.f> a,b,limm 00101bbb00100111FBBB111110AAAAAA.  */
{ "sbcs", 0x28270F80, 0xF8FF0FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* sbcs<.f> 0,limm,c 0010111001100111F111CCCCCC111110.  */
{ "sbcs", 0x2E67703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* sbcs<.f> 0,b,limm 00101bbb00100111FBBB111110111110.  */
{ "sbcs", 0x28270FBE, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* sbcs<.f><.cc> b,b,limm 00101bbb11100111FBBB1111100QQQQQ.  */
{ "sbcs", 0x28E70F80, 0xF8FF0FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* sbcs<.f><.cc> 0,limm,c 0010111011100111F111CCCCCC0QQQQQ.  */
{ "sbcs", 0x2EE77000, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* sbcs<.f> a,limm,u6 0010111001100111F111uuuuuuAAAAAA.  */
{ "sbcs", 0x2E677000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* sbcs<.f> 0,limm,u6 0010111001100111F111uuuuuu111110.  */
{ "sbcs", 0x2E67703E, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* sbcs<.f><.cc> 0,limm,u6 0010111011100111F111uuuuuu1QQQQQ.  */
{ "sbcs", 0x2EE77020, 0xFFFF7020, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* sbcs<.f> 0,limm,s12 0010111010100111F111ssssssSSSSSS.  */
{ "sbcs", 0x2EA77000, 0xFFFF7000, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* sbcs<.f> a,limm,limm 0010111000100111F111111110AAAAAA.  */
{ "sbcs", 0x2E277F80, 0xFFFF7FC0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* sbcs<.f> 0,limm,limm 0010111000100111F111111110111110.  */
{ "sbcs", 0x2E277FBE, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* sbcs<.f><.cc> 0,limm,limm 0010111011100111F1111111100QQQQQ.  */
{ "sbcs", 0x2EE77F80, 0xFFFF7FE0, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* scond<.di> b,c 00100bbb00101111DBBBCCCCCC010001.  */
{ "scond", 0x202F0011, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, SCOND, NONE, { RB, BRAKET, RC, BRAKETdup }, { C_DI16 }},

/* scond<.di> b,u6 00100bbb01101111DBBBuuuuuu010001.  */
{ "scond", 0x206F0011, 0xF8FF003F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, SCOND, NONE, { RB, BRAKET, UIMM6_20, BRAKETdup }, { C_DI16 }},

/* scond<.di> b,limm 00100bbb00101111DBBB111110010001.  */
{ "scond", 0x202F0F91, 0xF8FF0FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, SCOND, NONE, { RB, BRAKET, LIMM, BRAKETdup }, { C_DI16 }},

/* scond<.di> limm,c 0010011000101111D111CCCCCC010001.  */
{ "scond", 0x262F7011, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, SCOND, NONE, { LIMM, BRAKET, RC, BRAKETdup }, { C_DI16 }},

/* scond<.di> limm,u6 0010011001101111D111uuuuuu010001.  */
{ "scond", 0x266F7011, 0xFFFF703F, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, SCOND, NONE, { LIMM, BRAKET, UIMM6_20, BRAKETdup }, { C_DI16 }},

/* scond<.di> limm,limm 0010011000101111D111111110010001.  */
{ "scond", 0x262F7F91, 0xFFFF7FFF, ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM, SCOND, NONE, { LIMM, BRAKET, LIMMdup, BRAKETdup }, { C_DI16 }},

/* scondd<.di> b,c 00100bbb00101111DBBBCCCCCC010011.  */
{ "scondd", 0x202F0013, 0xF8FF003F, ARC_OPCODE_ARCv2HS, SCOND, NONE, { RB, BRAKET, RC, BRAKETdup }, { C_DI16, C_ZZ_D }},

/* scondd<.di> b,u6 00100bbb01101111DBBBuuuuuu010011.  */
{ "scondd", 0x206F0013, 0xF8FF003F, ARC_OPCODE_ARCv2HS, SCOND, NONE, { RB, BRAKET, UIMM6_20, BRAKETdup }, { C_DI16, C_ZZ_D }},

/* scondd<.di> b,limm 00100bbb00101111DBBB111110010011.  */
{ "scondd", 0x202F0F93, 0xF8FF0FFF, ARC_OPCODE_ARCv2HS, SCOND, NONE, { RB, BRAKET, LIMM, BRAKETdup }, { C_DI16, C_ZZ_D }},

/* setacc a,b,c 00101bbb000011011BBBCCCCCCAAAAAA.  */
{ "setacc", 0x280D8000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, RC }, { 0 }},

/* setacc 0,b,c 00101bbb000011011BBBCCCCCC111110.  */
{ "setacc", 0x280D803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, RC }, { 0 }},

/* setacc<.cc> b,b,c 00101bbb110011011BBBCCCCCC0QQQQQ.  */
{ "setacc", 0x28CD8000, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, RC }, { C_CC }},

/* setacc a,b,u6 00101bbb010011011BBBuuuuuuAAAAAA.  */
{ "setacc", 0x284D8000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* setacc 0,b,u6 00101bbb010011011BBBuuuuuu111110.  */
{ "setacc", 0x284D803E, 0xF8FF803F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, UIMM6_20 }, { 0 }},

/* setacc<.cc> b,b,u6 00101bbb110011011BBBuuuuuu1QQQQQ.  */
{ "setacc", 0x28CD8020, 0xF8FF8020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* setacc b,b,s12 00101bbb100011011BBBssssssSSSSSS.  */
{ "setacc", 0x288D8000, 0xF8FF8000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* setacc a,limm,c 00101110000011011111CCCCCCAAAAAA.  */
{ "setacc", 0x2E0DF000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, RC }, { 0 }},

/* setacc a,b,limm 00101bbb000011011BBB111110AAAAAA.  */
{ "setacc", 0x280D8F80, 0xF8FF8FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, RB, LIMM }, { 0 }},

/* setacc 0,limm,c 00101110000011011111CCCCCC111110.  */
{ "setacc", 0x2E0DF03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { 0 }},

/* setacc 0,b,limm 00101bbb000011011BBB111110111110.  */
{ "setacc", 0x280D8FBE, 0xF8FF8FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, RB, LIMM }, { 0 }},

/* setacc<.cc> b,b,limm 00101bbb110011011BBB1111100QQQQQ.  */
{ "setacc", 0x28CD8F80, 0xF8FF8FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* setacc<.cc> 0,limm,c 00101110110011011111CCCCCC0QQQQQ.  */
{ "setacc", 0x2ECDF000, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, RC }, { C_CC }},

/* setacc a,limm,u6 00101110010011011111uuuuuuAAAAAA.  */
{ "setacc", 0x2E4DF000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* setacc 0,limm,u6 00101110010011011111uuuuuu111110.  */
{ "setacc", 0x2E4DF03E, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* setacc<.cc> 0,limm,u6 00101110110011011111uuuuuu1QQQQQ.  */
{ "setacc", 0x2ECDF020, 0xFFFFF020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* setacc 0,limm,s12 00101110100011011111ssssssSSSSSS.  */
{ "setacc", 0x2E8DF000, 0xFFFFF000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* setacc a,limm,limm 00101110000011011111111110AAAAAA.  */
{ "setacc", 0x2E0DFF80, 0xFFFFFFC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* setacc 0,limm,limm 00101110000011011111111110111110.  */
{ "setacc", 0x2E0DFFBE, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { 0 }},

/* setacc<.cc> 0,limm,limm 001011101100110111111111100QQQQQ.  */
{ "setacc", 0x2ECDFF80, 0xFFFFFFE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { ZA, LIMM, LIMMdup }, { C_CC }},

/* seteq<.f> a,b,c 00100bbb00111000FBBBCCCCCCAAAAAA.  */
{ "seteq", 0x20380000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, RC }, { C_F }},

/* seteq<.f> 0,b,c 00100bbb00111000FBBBCCCCCC111110.  */
{ "seteq", 0x2038003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, RC }, { C_F }},

/* seteq<.f><.cc> b,b,c 00100bbb11111000FBBBCCCCCC0QQQQQ.  */
{ "seteq", 0x20F80000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, RC }, { C_F, C_CC }},

/* seteq<.f> a,b,u6 00100bbb01111000FBBBuuuuuuAAAAAA.  */
{ "seteq", 0x20780000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, UIMM6_20 }, { C_F }},

/* seteq<.f> 0,b,u6 00100bbb01111000FBBBuuuuuu111110.  */
{ "seteq", 0x2078003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, UIMM6_20 }, { C_F }},

/* seteq<.f><.cc> b,b,u6 00100bbb11111000FBBBuuuuuu1QQQQQ.  */
{ "seteq", 0x20F80020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* seteq<.f> b,b,s12 00100bbb10111000FBBBssssssSSSSSS.  */
{ "seteq", 0x20B80000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, SIMM12_20 }, { C_F }},

/* seteq<.f> a,limm,c 0010011000111000F111CCCCCCAAAAAA.  */
{ "seteq", 0x26387000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, RC }, { C_F }},

/* seteq<.f> a,b,limm 00100bbb00111000FBBB111110AAAAAA.  */
{ "seteq", 0x20380F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, LIMM }, { C_F }},

/* seteq<.f> 0,limm,c 0010011000111000F111CCCCCC111110.  */
{ "seteq", 0x2638703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, RC }, { C_F }},

/* seteq<.f> 0,b,limm 00100bbb00111000FBBB111110111110.  */
{ "seteq", 0x20380FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, LIMM }, { C_F }},

/* seteq<.f><.cc> b,b,limm 00100bbb11111000FBBB1111100QQQQQ.  */
{ "seteq", 0x20F80F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* seteq<.f><.cc> 0,limm,c 0010011011111000F111CCCCCC0QQQQQ.  */
{ "seteq", 0x26F87000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, RC }, { C_F, C_CC }},

/* seteq<.f> a,limm,u6 0010011001111000F111uuuuuuAAAAAA.  */
{ "seteq", 0x26787000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, UIMM6_20 }, { C_F }},

/* seteq<.f> 0,limm,u6 0010011001111000F111uuuuuu111110.  */
{ "seteq", 0x2678703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* seteq<.f><.cc> 0,limm,u6 0010011011111000F111uuuuuu1QQQQQ.  */
{ "seteq", 0x26F87020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* seteq<.f> 0,limm,s12 0010011010111000F111ssssssSSSSSS.  */
{ "seteq", 0x26B87000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* seteq<.f> a,limm,limm 0010011000111000F111111110AAAAAA.  */
{ "seteq", 0x26387F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, LIMMdup }, { C_F }},

/* seteq<.f> 0,limm,limm 0010011000111000F111111110111110.  */
{ "seteq", 0x26387FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, LIMMdup }, { C_F }},

/* seteq<.f><.cc> 0,limm,limm 0010011011111000F1111111100QQQQQ.  */
{ "seteq", 0x26F87F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* setge<.f> a,b,c 00100bbb00111011FBBBCCCCCCAAAAAA.  */
{ "setge", 0x203B0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, RC }, { C_F }},

/* setge<.f> 0,b,c 00100bbb00111011FBBBCCCCCC111110.  */
{ "setge", 0x203B003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, RC }, { C_F }},

/* setge<.f><.cc> b,b,c 00100bbb11111011FBBBCCCCCC0QQQQQ.  */
{ "setge", 0x20FB0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, RC }, { C_F, C_CC }},

/* setge<.f> a,b,u6 00100bbb01111011FBBBuuuuuuAAAAAA.  */
{ "setge", 0x207B0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, UIMM6_20 }, { C_F }},

/* setge<.f> 0,b,u6 00100bbb01111011FBBBuuuuuu111110.  */
{ "setge", 0x207B003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, UIMM6_20 }, { C_F }},

/* setge<.f><.cc> b,b,u6 00100bbb11111011FBBBuuuuuu1QQQQQ.  */
{ "setge", 0x20FB0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* setge<.f> b,b,s12 00100bbb10111011FBBBssssssSSSSSS.  */
{ "setge", 0x20BB0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, SIMM12_20 }, { C_F }},

/* setge<.f> a,limm,c 0010011000111011F111CCCCCCAAAAAA.  */
{ "setge", 0x263B7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, RC }, { C_F }},

/* setge<.f> a,b,limm 00100bbb00111011FBBB111110AAAAAA.  */
{ "setge", 0x203B0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, LIMM }, { C_F }},

/* setge<.f> 0,limm,c 0010011000111011F111CCCCCC111110.  */
{ "setge", 0x263B703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, RC }, { C_F }},

/* setge<.f> 0,b,limm 00100bbb00111011FBBB111110111110.  */
{ "setge", 0x203B0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, LIMM }, { C_F }},

/* setge<.f><.cc> b,b,limm 00100bbb11111011FBBB1111100QQQQQ.  */
{ "setge", 0x20FB0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* setge<.f><.cc> 0,limm,c 0010011011111011F111CCCCCC0QQQQQ.  */
{ "setge", 0x26FB7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, RC }, { C_F, C_CC }},

/* setge<.f> a,limm,u6 0010011001111011F111uuuuuuAAAAAA.  */
{ "setge", 0x267B7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, UIMM6_20 }, { C_F }},

/* setge<.f> 0,limm,u6 0010011001111011F111uuuuuu111110.  */
{ "setge", 0x267B703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* setge<.f><.cc> 0,limm,u6 0010011011111011F111uuuuuu1QQQQQ.  */
{ "setge", 0x26FB7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* setge<.f> 0,limm,s12 0010011010111011F111ssssssSSSSSS.  */
{ "setge", 0x26BB7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* setge<.f> a,limm,limm 0010011000111011F111111110AAAAAA.  */
{ "setge", 0x263B7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, LIMMdup }, { C_F }},

/* setge<.f> 0,limm,limm 0010011000111011F111111110111110.  */
{ "setge", 0x263B7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, LIMMdup }, { C_F }},

/* setge<.f><.cc> 0,limm,limm 0010011011111011F1111111100QQQQQ.  */
{ "setge", 0x26FB7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* setgt<.f> a,b,c 00100bbb00111111FBBBCCCCCCAAAAAA.  */
{ "setgt", 0x203F0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, RC }, { C_F }},

/* setgt<.f> 0,b,c 00100bbb00111111FBBBCCCCCC111110.  */
{ "setgt", 0x203F003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, RC }, { C_F }},

/* setgt<.f><.cc> b,b,c 00100bbb11111111FBBBCCCCCC0QQQQQ.  */
{ "setgt", 0x20FF0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, RC }, { C_F, C_CC }},

/* setgt<.f> a,b,u6 00100bbb01111111FBBBuuuuuuAAAAAA.  */
{ "setgt", 0x207F0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, UIMM6_20 }, { C_F }},

/* setgt<.f> 0,b,u6 00100bbb01111111FBBBuuuuuu111110.  */
{ "setgt", 0x207F003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, UIMM6_20 }, { C_F }},

/* setgt<.f><.cc> b,b,u6 00100bbb11111111FBBBuuuuuu1QQQQQ.  */
{ "setgt", 0x20FF0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* setgt<.f> b,b,s12 00100bbb10111111FBBBssssssSSSSSS.  */
{ "setgt", 0x20BF0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, SIMM12_20 }, { C_F }},

/* setgt<.f> a,limm,c 0010011000111111F111CCCCCCAAAAAA.  */
{ "setgt", 0x263F7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, RC }, { C_F }},

/* setgt<.f> a,b,limm 00100bbb00111111FBBB111110AAAAAA.  */
{ "setgt", 0x203F0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, LIMM }, { C_F }},

/* setgt<.f> 0,limm,c 0010011000111111F111CCCCCC111110.  */
{ "setgt", 0x263F703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, RC }, { C_F }},

/* setgt<.f> 0,b,limm 00100bbb00111111FBBB111110111110.  */
{ "setgt", 0x203F0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, LIMM }, { C_F }},

/* setgt<.f><.cc> b,b,limm 00100bbb11111111FBBB1111100QQQQQ.  */
{ "setgt", 0x20FF0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* setgt<.f><.cc> 0,limm,c 0010011011111111F111CCCCCC0QQQQQ.  */
{ "setgt", 0x26FF7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, RC }, { C_F, C_CC }},

/* setgt<.f> a,limm,u6 0010011001111111F111uuuuuuAAAAAA.  */
{ "setgt", 0x267F7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, UIMM6_20 }, { C_F }},

/* setgt<.f> 0,limm,u6 0010011001111111F111uuuuuu111110.  */
{ "setgt", 0x267F703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* setgt<.f><.cc> 0,limm,u6 0010011011111111F111uuuuuu1QQQQQ.  */
{ "setgt", 0x26FF7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* setgt<.f> 0,limm,s12 0010011010111111F111ssssssSSSSSS.  */
{ "setgt", 0x26BF7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* setgt<.f> a,limm,limm 0010011000111111F111111110AAAAAA.  */
{ "setgt", 0x263F7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, LIMMdup }, { C_F }},

/* setgt<.f> 0,limm,limm 0010011000111111F111111110111110.  */
{ "setgt", 0x263F7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, LIMMdup }, { C_F }},

/* setgt<.f><.cc> 0,limm,limm 0010011011111111F1111111100QQQQQ.  */
{ "setgt", 0x26FF7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* seths<.f> a,b,c 00100bbb00111101FBBBCCCCCCAAAAAA.  */
{ "seths", 0x203D0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, RC }, { C_F }},

/* seths<.f> 0,b,c 00100bbb00111101FBBBCCCCCC111110.  */
{ "seths", 0x203D003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, RC }, { C_F }},

/* seths<.f><.cc> b,b,c 00100bbb11111101FBBBCCCCCC0QQQQQ.  */
{ "seths", 0x20FD0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, RC }, { C_F, C_CC }},

/* seths<.f> a,b,u6 00100bbb01111101FBBBuuuuuuAAAAAA.  */
{ "seths", 0x207D0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, UIMM6_20 }, { C_F }},

/* seths<.f> 0,b,u6 00100bbb01111101FBBBuuuuuu111110.  */
{ "seths", 0x207D003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, UIMM6_20 }, { C_F }},

/* seths<.f><.cc> b,b,u6 00100bbb11111101FBBBuuuuuu1QQQQQ.  */
{ "seths", 0x20FD0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* seths<.f> b,b,s12 00100bbb10111101FBBBssssssSSSSSS.  */
{ "seths", 0x20BD0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, SIMM12_20 }, { C_F }},

/* seths<.f> a,limm,c 0010011000111101F111CCCCCCAAAAAA.  */
{ "seths", 0x263D7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, RC }, { C_F }},

/* seths<.f> a,b,limm 00100bbb00111101FBBB111110AAAAAA.  */
{ "seths", 0x203D0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, LIMM }, { C_F }},

/* seths<.f> 0,limm,c 0010011000111101F111CCCCCC111110.  */
{ "seths", 0x263D703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, RC }, { C_F }},

/* seths<.f> 0,b,limm 00100bbb00111101FBBB111110111110.  */
{ "seths", 0x203D0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, LIMM }, { C_F }},

/* seths<.f><.cc> b,b,limm 00100bbb11111101FBBB1111100QQQQQ.  */
{ "seths", 0x20FD0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* seths<.f><.cc> 0,limm,c 0010011011111101F111CCCCCC0QQQQQ.  */
{ "seths", 0x26FD7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, RC }, { C_F, C_CC }},

/* seths<.f> a,limm,u6 0010011001111101F111uuuuuuAAAAAA.  */
{ "seths", 0x267D7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, UIMM6_20 }, { C_F }},

/* seths<.f> 0,limm,u6 0010011001111101F111uuuuuu111110.  */
{ "seths", 0x267D703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* seths<.f><.cc> 0,limm,u6 0010011011111101F111uuuuuu1QQQQQ.  */
{ "seths", 0x26FD7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* seths<.f> 0,limm,s12 0010011010111101F111ssssssSSSSSS.  */
{ "seths", 0x26BD7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* seths<.f> a,limm,limm 0010011000111101F111111110AAAAAA.  */
{ "seths", 0x263D7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, LIMMdup }, { C_F }},

/* seths<.f> 0,limm,limm 0010011000111101F111111110111110.  */
{ "seths", 0x263D7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, LIMMdup }, { C_F }},

/* seths<.f><.cc> 0,limm,limm 0010011011111101F1111111100QQQQQ.  */
{ "seths", 0x26FD7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* seti c 00100110001011110000CCCCCC111111.  */
{ "seti", 0x262F003F, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { RC }, { 0 }},

/* seti u6 00100110011011110000uuuuuu111111.  */
{ "seti", 0x266F003F, 0xFFFFF03F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { UIMM6_20 }, { 0 }},

/* seti limm 00100110001011110000111110111111.  */
{ "seti", 0x262F0FBF, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { LIMM }, { 0 }},

/* seti 00100110011011110000uuuuuu111111.  */
{ "seti", 0x266F003F, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, CONTROL, NONE, { 0 }, { 0 }},

/* setle<.f> a,b,c 00100bbb00111110FBBBCCCCCCAAAAAA.  */
{ "setle", 0x203E0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, RC }, { C_F }},

/* setle<.f> 0,b,c 00100bbb00111110FBBBCCCCCC111110.  */
{ "setle", 0x203E003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, RC }, { C_F }},

/* setle<.f><.cc> b,b,c 00100bbb11111110FBBBCCCCCC0QQQQQ.  */
{ "setle", 0x20FE0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, RC }, { C_F, C_CC }},

/* setle<.f> a,b,u6 00100bbb01111110FBBBuuuuuuAAAAAA.  */
{ "setle", 0x207E0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, UIMM6_20 }, { C_F }},

/* setle<.f> 0,b,u6 00100bbb01111110FBBBuuuuuu111110.  */
{ "setle", 0x207E003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, UIMM6_20 }, { C_F }},

/* setle<.f><.cc> b,b,u6 00100bbb11111110FBBBuuuuuu1QQQQQ.  */
{ "setle", 0x20FE0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* setle<.f> b,b,s12 00100bbb10111110FBBBssssssSSSSSS.  */
{ "setle", 0x20BE0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, SIMM12_20 }, { C_F }},

/* setle<.f> a,limm,c 0010011000111110F111CCCCCCAAAAAA.  */
{ "setle", 0x263E7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, RC }, { C_F }},

/* setle<.f> a,b,limm 00100bbb00111110FBBB111110AAAAAA.  */
{ "setle", 0x203E0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, LIMM }, { C_F }},

/* setle<.f> 0,limm,c 0010011000111110F111CCCCCC111110.  */
{ "setle", 0x263E703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, RC }, { C_F }},

/* setle<.f> 0,b,limm 00100bbb00111110FBBB111110111110.  */
{ "setle", 0x203E0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, LIMM }, { C_F }},

/* setle<.f><.cc> b,b,limm 00100bbb11111110FBBB1111100QQQQQ.  */
{ "setle", 0x20FE0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* setle<.f><.cc> 0,limm,c 0010011011111110F111CCCCCC0QQQQQ.  */
{ "setle", 0x26FE7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, RC }, { C_F, C_CC }},

/* setle<.f> a,limm,u6 0010011001111110F111uuuuuuAAAAAA.  */
{ "setle", 0x267E7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, UIMM6_20 }, { C_F }},

/* setle<.f> 0,limm,u6 0010011001111110F111uuuuuu111110.  */
{ "setle", 0x267E703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* setle<.f><.cc> 0,limm,u6 0010011011111110F111uuuuuu1QQQQQ.  */
{ "setle", 0x26FE7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* setle<.f> 0,limm,s12 0010011010111110F111ssssssSSSSSS.  */
{ "setle", 0x26BE7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* setle<.f> a,limm,limm 0010011000111110F111111110AAAAAA.  */
{ "setle", 0x263E7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, LIMMdup }, { C_F }},

/* setle<.f> 0,limm,limm 0010011000111110F111111110111110.  */
{ "setle", 0x263E7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, LIMMdup }, { C_F }},

/* setle<.f><.cc> 0,limm,limm 0010011011111110F1111111100QQQQQ.  */
{ "setle", 0x26FE7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* setlo<.f> a,b,c 00100bbb00111100FBBBCCCCCCAAAAAA.  */
{ "setlo", 0x203C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, RC }, { C_F }},

/* setlo<.f> 0,b,c 00100bbb00111100FBBBCCCCCC111110.  */
{ "setlo", 0x203C003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, RC }, { C_F }},

/* setlo<.f><.cc> b,b,c 00100bbb11111100FBBBCCCCCC0QQQQQ.  */
{ "setlo", 0x20FC0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, RC }, { C_F, C_CC }},

/* setlo<.f> a,b,u6 00100bbb01111100FBBBuuuuuuAAAAAA.  */
{ "setlo", 0x207C0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, UIMM6_20 }, { C_F }},

/* setlo<.f> 0,b,u6 00100bbb01111100FBBBuuuuuu111110.  */
{ "setlo", 0x207C003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, UIMM6_20 }, { C_F }},

/* setlo<.f><.cc> b,b,u6 00100bbb11111100FBBBuuuuuu1QQQQQ.  */
{ "setlo", 0x20FC0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* setlo<.f> b,b,s12 00100bbb10111100FBBBssssssSSSSSS.  */
{ "setlo", 0x20BC0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, SIMM12_20 }, { C_F }},

/* setlo<.f> a,limm,c 0010011000111100F111CCCCCCAAAAAA.  */
{ "setlo", 0x263C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, RC }, { C_F }},

/* setlo<.f> a,b,limm 00100bbb00111100FBBB111110AAAAAA.  */
{ "setlo", 0x203C0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, LIMM }, { C_F }},

/* setlo<.f> 0,limm,c 0010011000111100F111CCCCCC111110.  */
{ "setlo", 0x263C703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, RC }, { C_F }},

/* setlo<.f> 0,b,limm 00100bbb00111100FBBB111110111110.  */
{ "setlo", 0x203C0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, LIMM }, { C_F }},

/* setlo<.f><.cc> b,b,limm 00100bbb11111100FBBB1111100QQQQQ.  */
{ "setlo", 0x20FC0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* setlo<.f><.cc> 0,limm,c 0010011011111100F111CCCCCC0QQQQQ.  */
{ "setlo", 0x26FC7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, RC }, { C_F, C_CC }},

/* setlo<.f> a,limm,u6 0010011001111100F111uuuuuuAAAAAA.  */
{ "setlo", 0x267C7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, UIMM6_20 }, { C_F }},

/* setlo<.f> 0,limm,u6 0010011001111100F111uuuuuu111110.  */
{ "setlo", 0x267C703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* setlo<.f><.cc> 0,limm,u6 0010011011111100F111uuuuuu1QQQQQ.  */
{ "setlo", 0x26FC7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* setlo<.f> 0,limm,s12 0010011010111100F111ssssssSSSSSS.  */
{ "setlo", 0x26BC7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* setlo<.f> a,limm,limm 0010011000111100F111111110AAAAAA.  */
{ "setlo", 0x263C7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, LIMMdup }, { C_F }},

/* setlo<.f> 0,limm,limm 0010011000111100F111111110111110.  */
{ "setlo", 0x263C7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, LIMMdup }, { C_F }},

/* setlo<.f><.cc> 0,limm,limm 0010011011111100F1111111100QQQQQ.  */
{ "setlo", 0x26FC7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* setlt<.f> a,b,c 00100bbb00111010FBBBCCCCCCAAAAAA.  */
{ "setlt", 0x203A0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, RC }, { C_F }},

/* setlt<.f> 0,b,c 00100bbb00111010FBBBCCCCCC111110.  */
{ "setlt", 0x203A003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, RC }, { C_F }},

/* setlt<.f><.cc> b,b,c 00100bbb11111010FBBBCCCCCC0QQQQQ.  */
{ "setlt", 0x20FA0000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, RC }, { C_F, C_CC }},

/* setlt<.f> a,b,u6 00100bbb01111010FBBBuuuuuuAAAAAA.  */
{ "setlt", 0x207A0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, UIMM6_20 }, { C_F }},

/* setlt<.f> 0,b,u6 00100bbb01111010FBBBuuuuuu111110.  */
{ "setlt", 0x207A003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, UIMM6_20 }, { C_F }},

/* setlt<.f><.cc> b,b,u6 00100bbb11111010FBBBuuuuuu1QQQQQ.  */
{ "setlt", 0x20FA0020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* setlt<.f> b,b,s12 00100bbb10111010FBBBssssssSSSSSS.  */
{ "setlt", 0x20BA0000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, SIMM12_20 }, { C_F }},

/* setlt<.f> a,limm,c 0010011000111010F111CCCCCCAAAAAA.  */
{ "setlt", 0x263A7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, RC }, { C_F }},

/* setlt<.f> a,b,limm 00100bbb00111010FBBB111110AAAAAA.  */
{ "setlt", 0x203A0F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, LIMM }, { C_F }},

/* setlt<.f> 0,limm,c 0010011000111010F111CCCCCC111110.  */
{ "setlt", 0x263A703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, RC }, { C_F }},

/* setlt<.f> 0,b,limm 00100bbb00111010FBBB111110111110.  */
{ "setlt", 0x203A0FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, LIMM }, { C_F }},

/* setlt<.f><.cc> b,b,limm 00100bbb11111010FBBB1111100QQQQQ.  */
{ "setlt", 0x20FA0F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* setlt<.f><.cc> 0,limm,c 0010011011111010F111CCCCCC0QQQQQ.  */
{ "setlt", 0x26FA7000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, RC }, { C_F, C_CC }},

/* setlt<.f> a,limm,u6 0010011001111010F111uuuuuuAAAAAA.  */
{ "setlt", 0x267A7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, UIMM6_20 }, { C_F }},

/* setlt<.f> 0,limm,u6 0010011001111010F111uuuuuu111110.  */
{ "setlt", 0x267A703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* setlt<.f><.cc> 0,limm,u6 0010011011111010F111uuuuuu1QQQQQ.  */
{ "setlt", 0x26FA7020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* setlt<.f> 0,limm,s12 0010011010111010F111ssssssSSSSSS.  */
{ "setlt", 0x26BA7000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* setlt<.f> a,limm,limm 0010011000111010F111111110AAAAAA.  */
{ "setlt", 0x263A7F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, LIMMdup }, { C_F }},

/* setlt<.f> 0,limm,limm 0010011000111010F111111110111110.  */
{ "setlt", 0x263A7FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, LIMMdup }, { C_F }},

/* setlt<.f><.cc> 0,limm,limm 0010011011111010F1111111100QQQQQ.  */
{ "setlt", 0x26FA7F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* setne<.f> a,b,c 00100bbb00111001FBBBCCCCCCAAAAAA.  */
{ "setne", 0x20390000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, RC }, { C_F }},

/* setne<.f> 0,b,c 00100bbb00111001FBBBCCCCCC111110.  */
{ "setne", 0x2039003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, RC }, { C_F }},

/* setne<.f><.cc> b,b,c 00100bbb11111001FBBBCCCCCC0QQQQQ.  */
{ "setne", 0x20F90000, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, RC }, { C_F, C_CC }},

/* setne<.f> a,b,u6 00100bbb01111001FBBBuuuuuuAAAAAA.  */
{ "setne", 0x20790000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, UIMM6_20 }, { C_F }},

/* setne<.f> 0,b,u6 00100bbb01111001FBBBuuuuuu111110.  */
{ "setne", 0x2079003E, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, UIMM6_20 }, { C_F }},

/* setne<.f><.cc> b,b,u6 00100bbb11111001FBBBuuuuuu1QQQQQ.  */
{ "setne", 0x20F90020, 0xF8FF0020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* setne<.f> b,b,s12 00100bbb10111001FBBBssssssSSSSSS.  */
{ "setne", 0x20B90000, 0xF8FF0000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, SIMM12_20 }, { C_F }},

/* setne<.f> a,limm,c 0010011000111001F111CCCCCCAAAAAA.  */
{ "setne", 0x26397000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, RC }, { C_F }},

/* setne<.f> a,b,limm 00100bbb00111001FBBB111110AAAAAA.  */
{ "setne", 0x20390F80, 0xF8FF0FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, RB, LIMM }, { C_F }},

/* setne<.f> 0,limm,c 0010011000111001F111CCCCCC111110.  */
{ "setne", 0x2639703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, RC }, { C_F }},

/* setne<.f> 0,b,limm 00100bbb00111001FBBB111110111110.  */
{ "setne", 0x20390FBE, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, RB, LIMM }, { C_F }},

/* setne<.f><.cc> b,b,limm 00100bbb11111001FBBB1111100QQQQQ.  */
{ "setne", 0x20F90F80, 0xF8FF0FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* setne<.f><.cc> 0,limm,c 0010011011111001F111CCCCCC0QQQQQ.  */
{ "setne", 0x26F97000, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, RC }, { C_F, C_CC }},

/* setne<.f> a,limm,u6 0010011001111001F111uuuuuuAAAAAA.  */
{ "setne", 0x26797000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, UIMM6_20 }, { C_F }},

/* setne<.f> 0,limm,u6 0010011001111001F111uuuuuu111110.  */
{ "setne", 0x2679703E, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* setne<.f><.cc> 0,limm,u6 0010011011111001F111uuuuuu1QQQQQ.  */
{ "setne", 0x26F97020, 0xFFFF7020, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* setne<.f> 0,limm,s12 0010011010111001F111ssssssSSSSSS.  */
{ "setne", 0x26B97000, 0xFFFF7000, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* setne<.f> a,limm,limm 0010011000111001F111111110AAAAAA.  */
{ "setne", 0x26397F80, 0xFFFF7FC0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { RA, LIMM, LIMMdup }, { C_F }},

/* setne<.f> 0,limm,limm 0010011000111001F111111110111110.  */
{ "setne", 0x26397FBE, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, LIMMdup }, { C_F }},

/* setne<.f><.cc> 0,limm,limm 0010011011111001F1111111100QQQQQ.  */
{ "setne", 0x26F97F80, 0xFFFF7FE0, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, LOGICAL, CD1, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* setcc<.f> a,b,c 00100bbb00iiiiiiFBBBCCCCCCAAAAAA.  */
{ "setcc", 0x20000000, 0xF8C00000, 0, LOGICAL, CD1, { RA, RB, RC }, { C_F }},

/* setcc<.f> 0,b,c 00100bbb00iiiiiiFBBBCCCCCC111110.  */
{ "setcc", 0x2000003E, 0xF8C0003F, 0, LOGICAL, CD1, { ZA, RB, RC }, { C_F }},

/* setcc<.f><.cc> b,b,c 00100bbb11iiiiiiFBBBCCCCCC0QQQQQ.  */
{ "setcc", 0x20C00000, 0xF8C00020, 0, LOGICAL, CD1, { RB, RBdup, RC }, { C_F, C_CC }},

/* setcc<.f> a,b,u6 00100bbb01iiiiiiFBBBuuuuuuAAAAAA.  */
{ "setcc", 0x20400000, 0xF8C00000, 0, LOGICAL, CD1, { RA, RB, UIMM6_20 }, { C_F }},

/* setcc<.f> 0,b,u6 00100bbb01iiiiiiFBBBuuuuuu111110.  */
{ "setcc", 0x2040003E, 0xF8C0003F, 0, LOGICAL, CD1, { ZA, RB, UIMM6_20 }, { C_F }},

/* setcc<.f><.cc> b,b,u6 00100bbb11iiiiiiFBBBuuuuuu1QQQQQ.  */
{ "setcc", 0x20C00020, 0xF8C00020, 0, LOGICAL, CD1, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* setcc<.f> b,b,s12 00100bbb10iiiiiiFBBBssssssSSSSSS.  */
{ "setcc", 0x20800000, 0xF8C00000, 0, LOGICAL, CD1, { RB, RBdup, SIMM12_20 }, { C_F }},

/* setcc<.f> a,limm,c 0010011000iiiiiiF111CCCCCCAAAAAA.  */
{ "setcc", 0x26007000, 0xFFC07000, 0, LOGICAL, CD1, { RA, LIMM, RC }, { C_F }},

/* setcc<.f> a,b,limm 00100bbb00iiiiiiFBBB111110AAAAAA.  */
{ "setcc", 0x20000F80, 0xF8C00FC0, 0, LOGICAL, CD1, { RA, RB, LIMM }, { C_F }},

/* setcc<.f> 0,limm,c 0010011000iiiiiiF111CCCCCC111110.  */
{ "setcc", 0x2600703E, 0xFFC0703F, 0, LOGICAL, CD1, { ZA, LIMM, RC }, { C_F }},

/* setcc<.f> 0,b,limm 00100bbb00iiiiiiFBBB111110111110.  */
{ "setcc", 0x20000FBE, 0xF8C00FFF, 0, LOGICAL, CD1, { ZA, RB, LIMM }, { C_F }},

/* setcc<.f><.cc> b,b,limm 00100bbb11iiiiiiFBBB1111100QQQQQ.  */
{ "setcc", 0x20C00F80, 0xF8C00FE0, 0, LOGICAL, CD1, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* setcc<.f><.cc> 0,limm,c 0010011011iiiiiiF111CCCCCC0QQQQQ.  */
{ "setcc", 0x26C07000, 0xFFC07020, 0, LOGICAL, CD1, { ZA, LIMM, RC }, { C_F, C_CC }},

/* setcc<.f> a,limm,u6 0010011001iiiiiiF111uuuuuuAAAAAA.  */
{ "setcc", 0x26407000, 0xFFC07000, 0, LOGICAL, CD1, { RA, LIMM, UIMM6_20 }, { C_F }},

/* setcc<.f> 0,limm,u6 0010011001iiiiiiF111uuuuuu111110.  */
{ "setcc", 0x2640703E, 0xFFC0703F, 0, LOGICAL, CD1, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* setcc<.f><.cc> 0,limm,u6 0010011011iiiiiiF111uuuuuu1QQQQQ.  */
{ "setcc", 0x26C07020, 0xFFC07020, 0, LOGICAL, CD1, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* setcc<.f> 0,limm,s12 0010011010iiiiiiF111ssssssSSSSSS.  */
{ "setcc", 0x26807000, 0xFFC07000, 0, LOGICAL, CD1, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* setcc<.f> a,limm,limm 0010011000iiiiiiF111111110AAAAAA.  */
{ "setcc", 0x26007F80, 0xFFC07FC0, 0, LOGICAL, CD1, { RA, LIMM, LIMMdup }, { C_F }},

/* setcc<.f> 0,limm,limm 0010011000iiiiiiF111111110111110.  */
{ "setcc", 0x26007FBE, 0xFFC07FFF, 0, LOGICAL, CD1, { ZA, LIMM, LIMMdup }, { C_F }},

/* setcc<.f><.cc> 0,limm,limm 0010011011iiiiiiF1111111100QQQQQ.  */
{ "setcc", 0x26C07F80, 0xFFC07FE0, 0, LOGICAL, CD1, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* sexb<.f> b,c 00100bbb00101111FBBBCCCCCC000101.  */
{ "sexb", 0x202F0005, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RC }, { C_F }},

/* sexb<.f> 0,c 0010011000101111F111CCCCCC000101.  */
{ "sexb", 0x262F7005, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RC }, { C_F }},

/* sexb<.f> b,u6 00100bbb01101111FBBBuuuuuu000101.  */
{ "sexb", 0x206F0005, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* sexb<.f> 0,u6 0010011001101111F111uuuuuu000101.  */
{ "sexb", 0x266F7005, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* sexb<.f> b,limm 00100bbb00101111FBBB111110000101.  */
{ "sexb", 0x202F0F85, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, LIMM }, { C_F }},

/* sexb<.f> 0,limm 0010011000101111F111111110000101.  */
{ "sexb", 0x262F7F85, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* sexb_s b,c 01111bbbccc01101.  */
{ "sexb_s", 0x0000780D, 0x0000F81F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB_S, RC_S }, { 0 }},

/* sexh<.f> b,c 00100bbb00101111FBBBCCCCCC000110.  */
{ "sexh", 0x202F0006, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, RC }, { C_F }},

/* sexh<.f> 0,c 0010011000101111F111CCCCCC000110.  */
{ "sexh", 0x262F7006, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, RC }, { C_F }},

/* sexh<.f> b,u6 00100bbb01101111FBBBuuuuuu000110.  */
{ "sexh", 0x206F0006, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* sexh<.f> 0,u6 0010011001101111F111uuuuuu000110.  */
{ "sexh", 0x266F7006, 0xFFFF703F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* sexh<.f> b,limm 00100bbb00101111FBBB111110000110.  */
{ "sexh", 0x202F0F86, 0xF8FF0FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB, LIMM }, { C_F }},

/* sexh<.f> 0,limm 0010011000101111F111111110000110.  */
{ "sexh", 0x262F7F86, 0xFFFF7FFF, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* sexh_s b,c 01111bbbccc01110.  */
{ "sexh_s", 0x0000780E, 0x0000F81F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, ARITH, NONE, { RB_S, RC_S }, { 0 }},

/* sexw<.f> b,c 00100bbb00101111FBBBCCCCCC000110.  */
{ "sexw", 0x202F0006, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, RC }, { C_F }},

/* sexw<.f> 0,c 0010011000101111F111CCCCCC000110.  */
{ "sexw", 0x262F7006, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, RC }, { C_F }},

/* sexw<.f> b,u6 00100bbb01101111FBBBuuuuuu000110.  */
{ "sexw", 0x206F0006, 0xF8FF003F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* sexw<.f> 0,u6 0010011001101111F111uuuuuu000110.  */
{ "sexw", 0x266F7006, 0xFFFF703F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* sexw<.f> b,limm 00100bbb00101111FBBB111110000110.  */
{ "sexw", 0x202F0F86, 0xF8FF0FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB, LIMM }, { C_F }},

/* sexw<.f> 0,limm 0010011000101111F111111110000110.  */
{ "sexw", 0x262F7F86, 0xFFFF7FFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* sexw_s b,c 01111bbbccc01110.  */
{ "sexw_s", 0x0000780E, 0x0000F81F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700, ARITH, NONE, { RB_S, RC_S }, { 0 }},

/* sflag c 00110000001011110000CCCCCC111111.  */
{ "sflag", 0x302F003F, 0xFFFFF03F, ARC_OPCODE_ARCv2EM, CONTROL, NONE, { RC }, { 0 }},

/* sflag u6 00110000011011110000uuuuuu111111.  */
{ "sflag", 0x306F003F, 0xFFFFF03F, ARC_OPCODE_ARCv2EM, CONTROL, NONE, { UIMM6_20 }, { 0 }},

/* sflag limm 00110000001011110000111110111111.  */
{ "sflag", 0x302F0FBF, 0xFFFFFFFF, ARC_OPCODE_ARCv2EM, CONTROL, NONE, { LIMM }, { 0 }},

/* sfxtr<.f> a,b,c 00110bbb00101001FBBBCCCCCCAAAAAA.  */
{ "sfxtr", 0x30290000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* sfxtr<.f><.cc> b,b,c 00110bbb11101001FBBBCCCCCC0QQQQQ.  */
{ "sfxtr", 0x30E90000, 0xF8FF0020, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* sfxtr<.f> a,b,u6 00110bbb01101001FBBBuuuuuuAAAAAA.  */
{ "sfxtr", 0x30690000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* sfxtr<.f><.cc> b,b,u6 00110bbb11101001FBBBuuuuuu1QQQQQ.  */
{ "sfxtr", 0x30E90020, 0xF8FF0020, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* sfxtr<.f> b,b,s12 00110bbb10101001FBBBssssssSSSSSS.  */
{ "sfxtr", 0x30A90000, 0xF8FF0000, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* sfxtr<.f> a,limm,c 0011011000101001F111CCCCCCAAAAAA.  */
{ "sfxtr", 0x36297000, 0xFFFF7000, ARC_OPCODE_ARC700, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* sfxtr<.f> a,b,limm 00110bbb00101001FBBB111110AAAAAA.  */
{ "sfxtr", 0x30290F80, 0xF8FF0FC0, ARC_OPCODE_ARC700, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* sfxtr<.f><.cc> b,b,limm 00110bbb11101001FBBB1111100QQQQQ.  */
{ "sfxtr", 0x30E90F80, 0xF8FF0FE0, ARC_OPCODE_ARC700, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* sjli u12 00101000101000001000uuuuuuUUUUUU.  */
{ "sjli", 0x28A08000, 0xFFFFF000, ARC_OPCODE_ARCv2EM, SJLI, CD1, { UIMM12_20 }, { 0 }},

/* sleep c 00100001001011110000CCCCCC111111.  */
{ "sleep", 0x212F003F, 0xFFFFF03F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, KERNEL, NONE, { RC }, { 0 }},

/* sleep u6 00100001011011110000uuuuuu111111.  */
{ "sleep", 0x216F003F, 0xFFFFF03F, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, KERNEL, NONE, { UIMM6_20 }, { 0 }},

/* sleep limm 00100001001011110000111110111111.  */
{ "sleep", 0x212F0FBF, 0xFFFFFFFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, KERNEL, NONE, { LIMM }, { 0 }},

/* sleep 00100001011011110000uuuuuu111111.  */
{ "sleep", 0x216F003F, 0xFFFFFFFF, ARC_OPCODE_ARC600 | ARC_OPCODE_ARC700 | ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, KERNEL, NONE, { 0 }, { 0 }},

/* sqrt<.f> b,c 00101bbb00101111FBBBCCCCCC110000.  */
{ "sqrt", 0x282F0030, 0xF8FF003F, ARC_OPCODE_ARCv2EM | ARC_OPCODE_ARCv2HS, DSP, NONE, { RB_CHK, RC }, { C_F }},

/* sqrt<.f> 0,c 0010111000101111F111CCCCCC110000.  */
{ "sqrt", 0x2E2F7030, 0xFFFF703F, ARC_OPCODE_ARCv2EM |