/*
 *	glyph1.C -- A simple glyph demo program.
 */

/*
 *	glyph1 is a dead simple program that shows how to create
 *	various glyphs that behave in a reasonable mannor.
 *
 *	The first glyph is a simple glyph.  No bells, no whistles.  It uses the ParcPlace Logo.
 *
 *	The second glyph is a refinement of the first.  It adds highlighting on mouse clicks.
 *
 *	The third glyph shows two different bitmaps.  One for when it is in its normal state.  And another for its
 *	active state (when you click on the icon).  It uses the flagup and flagdown bitmaps from xbif.
 *
 *	The forth glyph shows a 3-d stlyized ParcPlace logo.
 *
 *	The last glyph shows how to use the 3-d support in glyphs to make a multi-color glyph that uses the current
 *	background.  It is the ParcPlace logo in color.
 *
 * Functions used:
 *	OIIntro (3O)
 *		OI_begin_interaction()
 *		OI_end_interaction()
 *		OI_init()
 *	OI_app_window (3O)
 *	OI_connection (3))
 *		is_color()
 *		str_color()
 *	OI_d_tech (3O)
 *		set_associated_object()
 *		set_click()
 *		set_layout()	
 *	OI_glyph
 *		oi_create_pic_mask_file()
 */

/* Header Files */

# include <OI/oi.H>
#if defined(ultrix) || defined(SVR4) || defined(hpux)
#include <unistd.h>
#else
#include <sysent.h>
#endif

/* Macro Definitions */

/* Variable Definitions */

/* Function Declarations */

void null_click_fn (OI_d_tech * /* objp */, void * /* argp */, OI_number /* clicks */, OI_number /* btn */, OI_number /* mod */,
		    OI_number /* x */ , OI_number /* y */)
{
}

int main(int argc, char *argv[])
{
	OI_connection		*conp;
	OI_app_window		*top_level;
	OI_glyph		*gp;
	int			row = 0;
	int			col = 0;
	OI_pic_spec_mask	*masks[7];
	PIXEL			black_pxl;
	PIXEL			blue_pxl;

	/*
	 *	Open a connection.
	 */
	if (conp = OI_init (&argc, argv, "glyph demo number 1"))
	{
		/*
		 *	Create the OI_tests main window.  Make it row layout.
		 */
		top_level = oi_create_app_window("topLevel",1,1,"template");
		top_level->set_layout (OI_layout_row);

		/*
		 *	Create our first glyph.  This is a simple glyph from a file
		 */
		gp = oi_create_glyph ("glyph1", "../bitmaps/pps-logo.xbm", "ignored", OI_PIC_MASK, OI_NO, OI_YES);
		gp->layout_associated_object (top_level, col++, row, OI_ACTIVE);

		/*
		 *	Create the second glyph.  This is just like the first one, except it will highligh on clicks.
		 *	However, we need to have a click function set.
		 */
		gp = oi_create_glyph ("glyph2", "../bitmaps/pps-logo.xbm", "ignored", OI_PIC_MASK, OI_YES, OI_YES);
		gp->set_click (&null_click_fn);
		gp->layout_associated_object (top_level, col++, row, OI_ACTIVE);
		
		/*
		 *	Create a glyph that is the mailbox from xbiff with the no mail glyph as the normal
		 *	glyph and the new mail glyph for the active icon.
		 */
		gp = oi_create_glyph ("glyph3", "/usr/include/X11/bitmaps/flagdown", "/usr/include/X11/bitmaps/flagup",
				      "ignored", OI_PIC_MASK, OI_NO, OI_YES);
		gp->set_click (&null_click_fn);
		gp->layout_associated_object (top_level, col++, row, OI_ACTIVE);
		
		/*
		 *	A 3-d version of the ParcPlace logo.  For 3-d icons, we need to create a series of masks that
		 *	will be used to paint the object.  Each of these masks have two states.  The first OI_PIC_PIXEL
		 *	value will be used to paint the glyph when in the up position.  The second will be used to
		 *	paint the glyph when it has been clicked (or in the down position).  See the glyph man
		 *	page for a description of OI_PIC_* values and how they are calculated.
		 */
		masks[0] = oi_create_pic_file_mask ("../bitmaps/3dlogo1.xbm", OI_PIC_TOP, OI_PIC_BOTTOM, 0, 0);
		masks[1] = oi_create_pic_file_mask ("../bitmaps/3dlogo2.xbm", OI_PIC_TOP, OI_PIC_BOTTOM, 0, 0);
		masks[2] = oi_create_pic_file_mask ("../bitmaps/3dlogo3.xbm", OI_PIC_BOTTOM, OI_PIC_TOP, 0, 0);
		masks[3] = oi_create_pic_file_mask ("../bitmaps/3dlogo4.xbm", OI_PIC_BG, OI_PIC_DOWN, 0, 0);
		gp = oi_create_glyph ("ParcPlaceLogo", 4, masks, "ParcPlace", 32, 32, OI_YES, OI_YES);
		gp->set_click (&null_click_fn, NULL);
		gp->layout_associated_object (top_level, col++, row, OI_ACTIVE);
	
		/*
		 *	Create a color icon.  This glyph demonstrates how to use the 3-d glyph stuff to create color icons.
		 *	There are a couple of new functions here.  OI_connection::is_color() returns true if we are
		 *	connected to a color display.  OI_connection::str_color() allocates a pixel for us in the "default"
		 *	colormap so we do not have to worry about using Xlib even for custom color calls.  Finally, we
		 *	create the masks and glyph in much the same way as we did in the 3-d ParcPlace logo above.
		 */
		if (conp->is_color ()) {
			conp->str_color ("blue", &blue_pxl);
			conp->str_color ("black", &black_pxl);
			masks[0]=oi_create_pic_file_mask("../bitmaps/colorlogo1.xbm",OI_PIC_NONE,OI_PIC_NONE,blue_pxl,black_pxl);
			masks[1]=oi_create_pic_file_mask("../bitmaps/colorlogo2.xbm",OI_PIC_NONE,OI_PIC_NONE,black_pxl,blue_pxl);
			gp = oi_create_glyph ("ParcPlaceColorLogo", 2, masks, "ParcPlace", 32, 32, OI_NO, OI_YES);
			gp->set_click (&null_click_fn, NULL);
			gp->layout_associated_object (top_level, col++, row, OI_ACTIVE);
		}
		
		/*
		 *	OK, display main window.
		 */
		top_level->set_associated_object(top_level->root(),OI_DEF_LOC, OI_DEF_LOC,OI_ACTIVE);
		OI_begin_interaction();
	}

	/*
	 *	Cleanup.  Make sure that we cleanup the library.
	 */
	OI_fini();
}
