#include <OI/oi.H>

/*
 *	translations - using C++ member functions as callbacks
 *
 *	This program demonstrates the use of the translation mechanism
 *	to add callbacks to Mouse events.  This program shows how
 *	to get member function callbacks on a non-OI object.
 *
 *	The reader should refer back to the README file for
 *	other translations examples.
 *
 *	The reader should refer to the OI documentation for
 *	information on the following member functions.
 *		- OIIntro
 *			OI_init()
 *			OI_begin_interaction()
 *			OI_fini()
 *			OI_add_actions()
 *		- OI_d_tech
 *			layout_associated_object()
 *			set_associated_object()
 *		- OI_app_window
 *			oi_create_app_window()
 *		- OI_static_text
 *			oi_create_static_text()
 *			disallow_cut_paste()
 */


/*
 *	MY_object class
 *
 *	contains the press, drag, and release member functions.
 */
class MY_object : public OI_callback {
	protected:
	public:
			MY_object(OI_d_tech *);
		void	press(OI_d_tech*, XEvent*, char **, unsigned int*);
		void	drag(OI_d_tech*, XEvent*, char **, unsigned int*);
		void	release(OI_d_tech*, XEvent*, char **, unsigned int*);
};

/*
 *	MY_object constructor
 */
MY_object::MY_object(OI_d_tech *eventObject) {
	static OI_actions_rec myactions[] = {
		{"press",	NULL,	NULL, (OI_translation_memfn *)&MY_object::press	},
		{"drag",	NULL,	NULL, (OI_translation_memfn *)&MY_object::drag	},
		{"release",	NULL,	NULL, (OI_translation_memfn *)&MY_object::release },
	};
	static char *stringTranslations = "#override \n\
		<ButtonPress>:		press() \n\
		<BtnMotion>:		drag() \n\
		<ButtonRelease>:	release() \n";

	int	i;

	/*
	 *	Loop through the myactions array and insert "this" as the object pointer
	 *	on whose behalf the member functions will be called.  After putting in
	 *	the object pointer, register the actions on the object where the events
	 *	will occur and add the needed translations.
	 */
	for (i = 0; i < (sizeof(myactions)/sizeof(OI_actions_rec)); i++)
		myactions[i].objp = this;
	eventObject->push_actions(myactions, OI_count(myactions));
	eventObject->override_translations(stringTranslations);
}

main (int argc, char **argv)
{
	OI_connection	*conp;				/* the connection to the server */
	OI_app_window	*appWindow;			/* the enclosing app window */
	
	/*
	 *	Open a connection.
	 */
	if ((conp = OI_init(&argc, argv, "actions", "Actions"))) {

		/*
		 *	create application window.
		 */
		appWindow = oi_create_app_window("myapp", 200, 200, "C++ Translations");

		/*
		 *	create a MY_object and pass in the appWindow as the object where
		 *		the mouse events will happen.
		 */
		new MY_object(appWindow);

		/*
		 *	Display application window.
		 *	Begin interaction.
		 */
		appWindow->set_associated_object(conp->root(), OI_DEF_LOC, OI_DEF_LOC, OI_ACTIVE);
		OI_begin_interaction();
	}

	/*
	 *	Cleanup.  Make sure that we cleanup the library.
	 */
	OI_fini();
}


/*
 *	on ButtonPress
 *		simply print out the window coordinates of the event
 */
void
MY_object::press(OI_d_tech *, XEvent *eventp, char **, unsigned int *)
{
	if (eventp->type == ButtonPress)
		fprintf(stderr, "ButtonPress:   %d, %d\n", eventp->xbutton.x, eventp->xbutton.y);
}


/*
 *	on MotionNotify (drag event)
 *		simply print out the window coordinates of the event
 */
void
MY_object::drag(OI_d_tech *, XEvent *eventp, char **, unsigned int *)
{
	if (eventp->type == MotionNotify)
		fprintf(stderr, "MotionNotify:  %d, %d\n", eventp->xmotion.x, eventp->xmotion.y);
}


/*
 *	on ButtonRelease
 *		simply print out the window coordinates of the event
 */
void
MY_object::release(OI_d_tech *, XEvent *eventp, char **, unsigned int *)
{
	if (eventp->type == ButtonRelease)
		fprintf(stderr, "ButtonRelease: %d, %d\n", eventp->xbutton.x, eventp->xbutton.y);
}
