/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	arbtn.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_arrow_button class header
 *
 *	RCSid = "$Id: arbtn.H,v 4.5.1.1 1993/06/01 22:52:46 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_arbtn_H
#define OI_arbtn_H

#ifndef OI_wldtech_H
#include <OI/wldtech.H>
#endif /* OI_wldtech_H */

#define OI_ARROW_BUTTON_IN		0x01L			/* the button is pressed in */
#define OI_ARROW_BUTTON_PAINTED		0x02L			/* the button has been painted */

	enum OI_direction {			/* state of a object, exclusive bits to allow checking for combinations easily */
		OI_direction_up		= 0,
		OI_direction_down	= 1,
		OI_direction_left	= 2,
		OI_direction_right	= 3
	} ;

	// class forward reference declaration
	class	OI_arrow_button;
	class	OI_mdl_arrow_button;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Definitions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	END OF DOCUMENTED SECTION
		//
		//-------------------------------------------------------------------------------------------------		

	class OI_arrow_button : public OI_wl_d_tech {
			OI_mdl_arrow_button	*mdl_dep ;	/* ptr to model dependent aspects of OI_arrow_button object */
			unsigned long	ctl_bits;
			OI_direction	dir;
			Time		tim;			/* time stamp of mouse button press */
		protected:
					OI_arrow_button(OI_class*, const char*, OI_direction);
		virtual	void		new_model(OI_model_type) ;
		public:
		static	OI_class		*clsp ;			/* ptr to class record */
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
					OI_arrow_button(const char*, OI_direction);
					~OI_arrow_button() ;
			void		allow_in()			{ ctl_bits |= OI_ARROW_BUTTON_IN; paint(NULL); }
			void		allow_painted()			{ ctl_bits |= OI_ARROW_BUTTON_PAINTED; }
			void		construct(OI_direction);
			OI_direction	direction()			{ return (dir); }
			void		disallow_in()			{ ctl_bits &= ~OI_ARROW_BUTTON_IN; paint(NULL); }
			void		disallow_painted()		{ ctl_bits &= ~OI_ARROW_BUTTON_PAINTED; }
		virtual	void		expose_reset();
		static	OI_bool		init(OI_connection*);
			OI_bool		is_in()				{ return ((ctl_bits&OI_ARROW_BUTTON_IN)?OI_YES:OI_NO); }
			OI_bool		is_painted()			{ return ((ctl_bits&OI_ARROW_BUTTON_PAINTED)?OI_YES:OI_NO); }
		virtual	void		paint(const XEvent*, void* =NULL) ;
		virtual	void		paint_outline(Window,int,int);			/* paint in a window */
		virtual	void		paint_arrow(Window,int,int);			/* paint in a window */
			Time		time()				{ return (tim); }

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			// OI_stat		set_state(OI_state) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED TRANSLATIONS FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under the
		//		translations available for this object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
 		virtual	void		activate(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
 		virtual	void		deactivate(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		

	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
		OI_arrow_button	*oi_create_arrow_button(const char *, OI_direction);

#endif /* OI_arbtn_H */
