/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	connect.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_connection class header
 *
 *	RCSid = "$Id: connect.H,v 4.48.1.3 1993/06/22 14:48:57 garya Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_connect_H
#define OI_connect_H

#ifndef OI_defs_H
#include <OI/defs.H>
#endif /* OI_defs_H */

#ifndef OI_key_H
#include <OI/key.H>
#endif /* OI_key_H */

#ifndef OI_dragdrop_H
#include <OI/dragdrop.H>
#endif /* OI_dragdrop_H */

	// class forward reference declarations
	class OI_action_table_rec;
	class OI_attr_colors;
	class OI_attr_layout;
	class OI_attr_misc;
	class OI_connection;
	class OI_cvt;
	class OI_dispatch;
	class OI_dispatch_entry;
	class OI_help;
	class OI_lang_server;
	class OI_model;
	class OI_ol_win_attr;
	class OI_pixmap;
	class OI_pointer_array;
	class OI_quark_pointer_array;
	class OI_rmgr;
	class OI_selection_owner;
	class OI_translation_table;
	class OI_quark_pointer_array;
	class OI_quark_pointer;
	class OI_last_quark;
	class OIG_output_device;

	struct OI_resource;
	struct OI_xlate_key;
	struct _OINameValueRec;

 /* ctl_bits */
#define		OI_CONN_HAS_FOCUS		0x1	/* 1 => application has input focus */
#define		OI_CONN_DOWN_IS_BKG		0x2	/* 1 => down pixel is to be background pixel */
#define		OI_NO_OBJECT_RESOURCES		0x4	/* 1 => we should not fetch object resources */
#define		OI_NO_HELP			0x8	/* 1 => do not perform grabs on help keys */
#define		OI_CONN_REVERSE			0x10	/* 1 => foreground and background pixels have been reversed */
#define		OI_CONN_POINTER_GRABBED		0x20	/* 1 => Connection has the pointer grabbed. */
#define		OI_IGNORE_MOUSE_LOCK		0x40	/* 1 => Ignore shift lock bit on mouse events */
#define		OI_UNGRABBED_SERVER		0x80	/* 1 => Server has been ungrabbed but not flushed ###KR - Doesn't appear to be useful*/
#define		OI_WM_IGNORES_PPOSITION		0x100	/* 1 => window manager ignores PPosition */
#define		OI_MOTIF_PUSHPINS		0x200	/* 1 => OK to put pushpins on motif dialog boxes */
#define		OI_CONN_HAS_SHAPE		0x400	/* 1 => the X server understands the SHAPE extension */
#define		OI_CONN_DRAGDROP_UPDATE		0x800	/* 1 => the dragdrop update timer has been added */
#define		OI_CONN_USING_OLWM3		0x1000	/* 1 => the user is using olwm 3.0 */
#define		OI_CONN_USING_MWM		0x1000	/* 1 => the user is using mwm */
#define		OI_CONN_EVENT_PROPAGATION	0x2000	/* 1 => allow event propagation */
#define		OI_CONN_LOST			0x4000  /* 1 => Connection lost via XKillClient */
#define		OI_CONN_DO_OLWM_HINTS		0x8000  /* 1 => set olwm specific hints */
#define		OI_CONN_DO_MWM_HINTS		0x10000 /* 1 => set mwm specific hints */
#define		OI_CONN_NAMED_OBJECTS		0x20000 /* 1 => set WM_NAME on all objects */
#define		OI_CONN_ACCEL_UPDATE		0x40000 /* 1 => the accelerators update timer has been added */
#define		OI_CONN_SERVER_GRABBED		0x80000 /* 1 => if the server is grabbed. */


#define OI_RESOURCE_SIZE	100
 class OI_resource_record {
	static	XrmBinding		bnd[OI_RESOURCE_SIZE];
	static	XrmQuark		qrk[OI_RESOURCE_SIZE];
		char			*val;
		XrmQuark		*q;
		XrmBinding		*b;
		short			siz;
	public:
					OI_resource_record()			{ }
					OI_resource_record(XrmDatabase *, const char *);
		int			contains(XrmQuark);
		OI_resource_record	*clone();
		void			replace(XrmQuark, XrmQuark);
		char			*value()				{ return (val); }
		XrmQuark		*quarks()				{ return (q); }
		void			set_quark(int i, XrmQuark quark)	{ q[i] = quark; }
		XrmBinding		*bindings()				{ return (b); }
		void			put(XrmDatabase *db)			{ XrmQPutStringResource(db, b, q, val); }
		short			size()					{ return (siz); }
 };

 class OI_resource_entry {
		OI_resource_entry	*nxt;
		OI_resource_record	*rec;
	public:
					OI_resource_entry(OI_resource_entry *n, OI_resource_record *e)		{ nxt = n; rec = e; }
		OI_resource_entry	*next()			{ return (nxt); }
		OI_resource_record	*record()		{ return (rec); }
 };

 class OI_resource_cache {
		unsigned		tries;
		unsigned		hits;
		unsigned		misses;
		unsigned		siz;
		OI_resource_entry	**buckets;
	public:
					OI_resource_cache(unsigned);
					~OI_resource_cache();
		void			add(OI_resource_record *);
		unsigned		hash_index(unsigned q)		{ return (q % siz); }
		void			replace(XrmDatabase *, XrmQuark, XrmQuark);
 };
	enum OI_rm_db {
		OI_set_database		= 1,
		OI_SET_DATABASE		= OI_set_database,
		OI_app_database		= 2,
		OI_APP_DATABASE		= OI_app_database,
		OI_user_database	= 4,
		OI_USER_DATABASE	= OI_user_database,
		OI_default_database	= 8,
		OI_DEFAULT_DATABASE	= OI_default_database
	} ;
#define OI_NUM_DATABASES	4

#define OI_RM_DATABASE_ENABLE		0x100		/* should be greater than the OI_rm_db bits above */
class OI_rm_database {
		XrmDatabase		database;
		unsigned long		ctl_bits;
	public:
					OI_rm_database()		{ database = 0; ctl_bits = OI_RM_DATABASE_ENABLE; }
		void			allow_set_database()		{ ctl_bits |= OI_set_database; }
		void			disallow_set_database()		{ ctl_bits &= ~OI_set_database; }
		OI_bool			is_set_database()		{ return ((ctl_bits&OI_set_database)?OI_yes:OI_no); }

		void			allow_app_database()		{ ctl_bits |= OI_app_database; }
		void			disallow_app_database()		{ ctl_bits &= ~OI_app_database; }
		OI_bool			is_app_database()		{ return ((ctl_bits&OI_app_database)?OI_yes:OI_no); }

		void			allow_user_database()		{ ctl_bits |= OI_user_database; }
		void			disallow_user_database()	{ ctl_bits &= ~OI_user_database; }
		OI_bool			is_user_database()		{ return ((ctl_bits&OI_user_database)?OI_yes:OI_no); }

		void			allow_default_database()	{ ctl_bits |= OI_default_database; }
		void			disallow_default_database()	{ ctl_bits &= ~OI_default_database; }
		OI_bool			is_default_database()		{ return ((ctl_bits&OI_default_database)?OI_yes:OI_no); }

		unsigned long		control()			{ return (ctl_bits); }
		XrmDatabase		db()				{ return (database); }
		XrmDatabase*		dbp()				{ return (&database); }
		void			set_db(XrmDatabase new_db)	{ database = new_db; }
		void			disable()			{ ctl_bits &= ~OI_RM_DATABASE_ENABLE; }
		void			enable()			{ ctl_bits |= OI_RM_DATABASE_ENABLE; }
		OI_bool			is_enable()			{ return ((ctl_bits&OI_RM_DATABASE_ENABLE)?OI_yes:OI_no); }
};

	enum OI_super_caret_position {
		OI_super_caret_last,
		OI_super_caret_left,
		OI_super_caret_below
	};

 /* these definitions needed to allow macros to work */
		extern	OI_d_tech		*OI_Primary ;	/* application primary object */
		extern	OI_connection		*OI_def_conp ;

 /* structures for cacheing server resources between clients */
	struct OI_conn_cache {					/* cache stored between applications as a property on the root window */
	} ;

	class OI_gc_attr {
		PIXEL		bkg_pxl ;		/* background pixel */
		PIXEL		fg_pxl ;		/* foreground pixel */
		OI_font	*fntp ;			/* ptr to font info in font cache */
	 public:
		PIXEL		bkg_pixel()			{return(bkg_pxl);}
		void		new_bkg_pixel(PIXEL p)		{bkg_pxl=p;}
		PIXEL		fg_pixel()			{return(fg_pxl);}
		void		new_fg_pixel(PIXEL p)		{fg_pxl=p;}
		OI_font	*font()				{return(fntp);}
		void		new_font(OI_font *fp)	{fntp=fp;}
	} ;

 	struct OI_grab_pointer_arg {			/* Argument list for XGrabPointer call . */
 		Window	w;
 		Bool	owner_events;
 	       	long	event_mask;
 		int	pointer_mode;
 		int	keyboard_mode;
 		Window	confine_to;
 		Cursor	cursor;
 		Time	time;
		OI_bool	roll_stack;
 	} ;

	struct OI_mod_to_keysym {
		unsigned long	mask;
		int		count;
		int		index;
	} ;

	enum OI_focus_policy {
		OI_focus_follows_pointer	= 0,
		OI_FOCUS_FOLLOWS_POINTER	= OI_focus_follows_pointer,
		OI_focus_click_to_type		= 1,
		OI_FOCUS_CLICK_TO_TYPE		= OI_focus_click_to_type
	};

 /* class definition for connection to server/display */
	class OI_connection : public OI_callback {	/* X server connection */
		/***********************************************************************
		 *  connection resources
		 **********************************************************************/
			XrmQuark	langq;			/* the language for the object */
			OI_attr_colors	*attrcolors;		/* default color packet */
			OI_attr_layout	*attrlayout;		/* default layout attributes */
			OI_attr_misc	*attrmisc;		/* misc attributes */
			OI_quark_pointer_array *attr;		/* generic attributes */
			OI_font_bounds 	*fntbnds ;		/* ptr to font bounds and font list for text object */
			OI_font	*fntp ;			/* ptr to font info in font cache */
			OI_bool		bkg_is_dn;		/* background is the down pixel */
			char		**bitmapFilePath;	/* bitmap file search path */
			char		**subclassFilePath;	/* subclass file search path */
			char		**appFilePath;		/* .cf config file search path */
			char		**appDefaults;		/* resources to prepend "app*" to the front of */
			OI_focus_policy	focs;			/* focus policy */
			char		*defaultKey;		/* keysym to fire default cell */
			OI_mnemonic_style mnstyle;		/* style of mnemonic display */
			OI_translation_table *help_trans;	/* help translations */
			OI_bool		dynamic_resources;	/* should we update dynamically? */
			OI_focus_indicator focus_indicator;	/* how should we show the input focus (OpenLook) */
			long		click_dlta;		/* time between click */
			long		multi_click_dlta;	/* time between multi-click */
			OI_bool		mdl_specific_hints;	/* should we set model specific wm hints? */
			OI_number	drag_right;		/* drag right threshold for OL menus */
			unsigned int	ignore_msk;		/* modifier mask to ignore for mouse events */
//			Colormap	cm ;			/* colormap */
//		static	OI_resource	conn_resources[];	/* descriptions of all the connection resources */
//		static	OI_resource	color_resources[];	/* descriptions of all the color resources */
		/**********************************************************************
		 *  end of connection resources
		 **********************************************************************/
			OI_connection		*fwd_lnk ;	/* link to next connection in connection list */
			char			*hstnam ;	/* host name, no display/screen # */
			int			dpynum ;	/* number of display */
			int			scnnum ;	/* number of screen */
			Display			*dpy ;		/* X display connection */
			OI_d_tech		*wl_ptr_objp;	/* the windowless object that last had the pointer */
			OI_rmgr			*rmgr;		/* resource manager object */
			OI_number		push_cnt;	/* resource manager push count */
			OI_action_table_rec	*actions;	/* list of action routines */
			OI_resource_cache	*rescache;	/* cache/hash of default resources */
			OI_rm_database		**dbs;		/* various resource databases */
			OI_number		num_dbs;	/* how many databases are there */
			Cursor			bsy_cursor;	/* model dependent busy cursor */
			Atom			clr_map_typ ;	/* atom representing the colormap type */
			XStandardColormap	std_clr_map ;	/* colormap info */
			XStandardColormap	last_clr_map;	/* cached last standard colormap info */
			OI_bool			clr_map_wrt ;	/* OI_YES if colormap is writeable */
			OI_bool			clr_display ;	/* OI_YES if DisplayCells > 2 */
			unsigned long		ctl_bits;	/* control bits */
			OI_d_tech		*abs_rt ;	/* ptr to absolute root window object for display */
			OI_d_tech		*vir_rt ;	/* ptr to virtual root window object */
			OI_d_tech		*old_vir_rt ;	/* ptr to old virtual root object (prior to change_root() call) */
			OI_d_tech		*orph ;		/* ptr to orphanage object for display */
			OI_d_tech		*_Primary ;	/* ptr to primary object */
			OI_d_tech		*lst_focus;	/* the last object that had input focus */
			OI_d_tech		*def_focus;	/* the default object to get input focus */
			OI_dispatch		*dispatchp ;	/* ptr to dispatch table */
			GC			bitmap_gc;	/* GC to use for create_bitmap_from_data */
			GC			nrm_gc ;	/* GC for normal operations */
			GC			use_gc ;	/* GC actually used in operations, is either def_gc or attrib_def_gc */
			OI_gc_attr		def_gc_val ;	/* current attributes for def_gc */
			OI_pixmap		*pix_lstp;	/* user pixmaps for this connection */
			OI_lang_server		*lngsrv_lstp ;	/* ptr to list of language servers */
			struct {
				GC		def_gc ;	/* default GC, contains default font */
				PIXEL		def_fg_pxl ;	/* fg/bkg pixel for default GC */
				PIXEL		def_bkg_pxl ;
			} attrib ;
			OI_bool			drawfast ;	/* OI_YES => do fast drawing optimizations */
			struct {				/* atoms required on each connection */
				Atom		clipboard ;		/* selection property for the clipboard */
				Atom		cutbuffer ;	/* cutbuffer to use */
				Atom		length;
				Atom		wm_protocols ;
				Atom		wm_client_machine ;
				Atom		wm_delete_window ;
				Atom		wm_shutdown ;
				Atom		wm_save_yourself ;
				Atom		wm_take_focus ;
				Atom		wm_command ;
				Atom		wm_change_state ;
				Atom		wm_change_display ;
				Atom		resource_manager;
				Atom		screen_resources;
//				Atom		_oi_time ;
//				Atom		xv_do_drag_load ;
//				Atom		xv_do_drag_copy ;
//				Atom		xv_do_drag_move ;
//				Atom		_ol_dflt_btn ;
//				Atom		_ol_protocols ;
//				Atom		_ol_win_attr ;
//				Atom		_ol_pin_state ;
//				Atom		_ol_win_colors ;
//				Atom		_ol_wsm_queue ;
//				Atom		_ol_fm_queue ;
//				Atom		_ol_wt_base ;
//				Atom		_ol_wt_cmd ;
//				Atom		_ol_wt_help ;
//				Atom		_ol_wt_notice ;
//				Atom		_ol_wt_other ;
//				Atom		_ol_menu_full ;
//				Atom		_ol_menu_limited ;
//				Atom		_ol_none ;
//				Atom		_ol_save_cfg ;
//				Atom		_ol_scale ;
//				Atom		_ol_show_info ;
//				Atom		_ol_decor_add ;
//				Atom		_ol_decor_del ;
//				Atom		_ol_decor_resize ;
//				Atom		_ol_decor_pin ;
//				Atom		_ol_decor_header ;
//				Atom		_ol_pin_in ;
//				Atom		_ol_pin_out ;
//				Atom		_ol_win_busy;
				Atom		_swm_root ;
//				Atom		_swm_version ;
//				Atom		_oi_conn_cache ;	/* cache of connection data */
//				Atom		_sun_dragdrop_trigger;
//				Atom		_sun_dragdrop_preview;
//				Atom		_sun_dragdrop_ack;
//				Atom		_sun_dragdrop_done;
//				Atom		_sun_dragdrop_interest;
//				Atom		_sun_dragdrop_dsdm;
			} atoms ;
			OI_quark_pointer_array	*atom_cache;			/* cache for atoms */
			OI_number		btn ;				/* btn # for clicks */
			OI_number		n_click ;			/* # clicks which have occurred */
			Time			tim ;				/* time of last button press/release event */
			Time			lst_tim ;			/* last known timestamp */
			Time			lst_fcs_tim;			/* last focus change time */
			OI_click_fnp		click_fnp ;			/* callback function to dispatch on click */
			OI_callback		*click_objp ;			/* object ptr for click user member function */
			OI_click_memfnp		click_memfnp ;			/* callback memfn to dispatch on click */
			void			*click_argp ;			/* arg to pass to callback */
			Pixmap			pm_inactive ;			/* inactive object clip mask */
			Pixmap			pm_busy ;			/* busy object clip mask */
			Pixmap			gray ;				/* gray pixmap for monochrome 3D bevels */
			OI_d_tech		*scaret_objp;			/* the object that the super caret is pointing at */
			OI_xy			scaret_loc;			/* the last location of the super_caret */
			Window			scaret_win;			/* the last X window the super caret was parented to */
			OI_super_caret_position	scaret_pos;			/* how it is positioned on the scaret_objp */
			Pixmap			scaret_up_pm;			/* Pixmap for the XView-like SuperCaret pointing up */
			Pixmap			scaret_right_pm;		/* Pixmap for the XView-like SuperCaret pointeing right */
			Window			scaret;				/* the current SuperCaret */
			Window			scaret_up;			/* the XView-like SuperCaret pointing up */
			Window			scaret_right;			/* the XView-like SuperCaret pointeing right */
			void			*usr_dat ;			/* user data to stuff in *usrdatp when we switch to this connection */
			void			**usr_datp ;			/* place to stuff usr_dat when we switch to this connection */
			unsigned char		chk_X_err_code ;		/* error code to for and allow to pass */
			unsigned char		X_err_code ;			/* X error code which actually occurred, 0 => none */
			struct {
				KeySym			*kbmap ;
				XModifierKeymap		*kbmodmap ;
				int     		syms_p_code ;
				OI_number		n_translate ;		/* # entries in translate_table */
				OI_xlate_key		*translate_table ;	/* user=>internal translations */
				unsigned char 		*check_key_table ;	/* idx by low 8 bits of KeySym; != 0 => idx to translate_table+1, possible translation; 0=> none */
			} key ;
			OI_help			*hyp_hlp ;		/* ptr to help object, if help activated */
//			OI_conn_cache		*cachep ;		/* ptr to connection cache retrieved from root window */
 			OI_number		grabp_size;		/* Pointer grab stack size. */
 			OI_number		grabp_index;		/* Current element on grab stack. */
 			OI_grab_pointer_arg	*grabp_stack;		/* pointer grab stack */
			OI_char_encode_type	char_encode_typ ;	/* encoding type for literal strings */
// **********************************************************************
// Translation Manager data
// **********************************************************************
			KeySym			*keysyms;		/* keycode to keysym table */
			int			keysyms_per_keycode;	/* number of keysyms for each keycode */
			int			min_keycode;		/* range of keycodes */
			int			max_keycode;
			KeySym			*mod_keysyms;		/* keysym values for mods_to_keysysms */
			OI_mod_to_keysym	*mods_to_keysyms;	/* modifiers to Keysysms index table*/
			unsigned char		is_modifier[32];	/* key-is-modifier-p bit table */
			KeySym			lock_meaning;		/* Lock modifier meaning */
			unsigned long		mode_switch;		/* keyboard group modifiers */
// **********************************************************************
			OI_pointer_array	*selections;		/* list of selections owned */
			unsigned long		prop_btn_mask;		/* event propagation button mask */
			OIG_output_device	*outdev;		/* Pointer to output device. */
			VisualID		def_visual_id;		/* default visual id */
			OI_last_quark		*last_font_quarks;	/* the last "n" font names to be converted to quarks */
	private:
			void		get_rgb_map(Atom) ;
			void		vir_rt_destroy(const XEvent*) ;				/* virtual root destroy notify callback */
			void		paint_super_caret(const XEvent*); 			/* handle an expose event of the super caret */
			OI_bool		key_init() ;						/* initialize keyboard interface */
			void		parse_translate_table() ;				/* parse keyboard translation table */
			void		build_translate_table(OI_xlate_key*,int) ;		/* build keyboard translation table */
			OI_key		translate_key(OI_number,OI_key) ;
			void		set_click_cb(OI_click_fnp fp, OI_callback *objp, OI_click_memfnp mfp, void *argp) ;
			void		set_key_help_cb(OI_help_fnp fp, OI_callback *objp, OI_help_memfnp mfp, void *argp) ;
			void		init_for_swm() ;					/* initialize for swm virtual root */
			void		property_notify(const XEvent*, void*) ;			/* root window property change */
	public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
					OI_connection(Display*,const char*,OI_number,OI_number,OI_dispatch*) ;	/* constructor */
		virtual			~OI_connection() ;
		virtual	void		*redirect_0(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_1(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_2(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_3(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_4(void*, void*, void*, void*, void*, void*);
			OI_action_table_rec *action_table()		{ return (actions); }
			void		activate_help(long,long) ;				/* put the help object on the screen */
			void		add_key_translation(OI_key,OI_key) ;
			OI_bool		add_resources(const char*, OI_number);
			OI_bool		add_resources(const char*, XrmDatabase*);
			void		accelerators_update();
			void		allow_accelerators_update();
			void		allow_dragdrop_update();
			void		allow_event_propagation()	{ ctl_bits |= OI_CONN_EVENT_PROPAGATION; }
			void		allow_help()			{ ctl_bits &= ~OI_NO_HELP; }
			void		allow_ignore_mouse_lock()	{ ctl_bits |= OI_IGNORE_MOUSE_LOCK; }
			void		allow_lost()			{ ctl_bits |= OI_CONN_LOST; }
			void		allow_motif_pushpins()		{ ctl_bits |= OI_MOTIF_PUSHPINS; }
			void		allow_mwm_hints()		{ ctl_bits |= OI_CONN_DO_MWM_HINTS; }
			void		allow_named_objects()		{ ctl_bits |= OI_CONN_NAMED_OBJECTS; }
			void		allow_olwm_hints()		{ ctl_bits |= OI_CONN_DO_OLWM_HINTS; }
			void		allow_server_grabbed()		{ ctl_bits |= OI_CONN_SERVER_GRABBED; }
			void		allow_ungrabbed_server()	{ ctl_bits |= OI_UNGRABBED_SERVER; }
			void		allow_using_mwm()		{ ctl_bits |= OI_CONN_USING_MWM; }
			void		allow_using_olwm3()		{ ctl_bits |= OI_CONN_USING_OLWM3; }
			void		allow_wm_ignores_pposition()	{ ctl_bits |= OI_WM_IGNORES_PPOSITION; }
			XrmDatabase	app_database()			{ return (database(OI_app_database)); }
			OI_number	app_database_index()		{ return (database_index(OI_app_database)); }
			char		**app_file_path()		{ return (appFilePath); }
			Atom		atom_primary() ;
			Atom		atom_secondary() ;
			Atom		atom_string() ;
			Atom		atom_clipboard()		{return(atoms.clipboard);}
			Atom		atom_cutbuffer()		{return(atoms.cutbuffer);}
			Atom		atom_length()			{return(atoms.length); }
			Atom		atom_resource_manager()		{return(atoms.resource_manager); }
			Atom		atom_screen_resources()		{return(atoms.screen_resources); }
			Atom		atom_wm_change_display()	{return(atoms.wm_change_display);}
			Atom		atom_wm_change_state()		{return(atoms.wm_change_state);}
			Atom		atom_wm_command()		{return(atoms.wm_command);}
			Atom		atom_wm_delete_window()		{return(atoms.wm_delete_window);}
			Atom		atom_wm_protocols()		{return(atoms.wm_protocols);}
			Atom		atom_wm_save_yourself()		{return(atoms.wm_save_yourself);}
			Atom		atom_wm_shutdown()		{return(atoms.wm_shutdown);}
			Atom		atom_wm_take_focus()		{return(atoms.wm_take_focus);}
//			Atom		atom_xv_do_drag_load()		{return(atoms.xv_do_drag_load);}
//			Atom		atom_xv_do_drag_copy()		{return(atoms.xv_do_drag_copy);}
//			Atom		atom_xv_do_drag_move()		{return(atoms.xv_do_drag_move);}
//			Atom		atom_oi_time()			{return(atoms._oi_time);}
//			Atom		atom_ol_decor_add()		{return(atoms._ol_decor_add);}
//			Atom		atom_ol_decor_del()		{return(atoms._ol_decor_del);}
//			Atom		atom_ol_decor_pin()		{return(atoms._ol_decor_pin);}
//			Atom		atom_ol_decor_header()		{return(atoms._ol_decor_header);}
//			Atom		atom_ol_decor_resize()		{return(atoms._ol_decor_resize);}
//			Atom		atom_ol_fm_queue()		{return(atoms._ol_fm_queue);}
//			Atom		atom_ol_menu_full()		{return(atoms._ol_menu_full);}
//			Atom		atom_ol_menu_limited()		{return(atoms._ol_menu_limited);}
//			Atom		atom_ol_none()			{return(atoms._ol_none);}
//			Atom		atom_ol_pin_in()		{return(atoms._ol_pin_in);}
//			Atom		atom_ol_pin_out()		{return(atoms._ol_pin_out);}
//			Atom		atom_ol_pin_state()		{return(atoms._ol_pin_state);}
//			Atom		atom_ol_dflt_btn()		{return(atoms._ol_dflt_btn);}
//			Atom		atom_ol_protocols()		{return(atoms._ol_protocols);}
//			Atom		atom_ol_win_attr()		{return(atoms._ol_win_attr);}
//			Atom		atom_ol_win_colors()		{return(atoms._ol_win_colors);}
//			Atom		atom_ol_wsm_queue()		{return(atoms._ol_wsm_queue);}
//			Atom		atom_ol_wt_base()		{return(atoms._ol_wt_base);}
//			Atom		atom_ol_wt_cmd()		{return(atoms._ol_wt_cmd);}
//			Atom		atom_ol_wt_help()		{return(atoms._ol_wt_help);}
//			Atom		atom_ol_wt_notice()		{return(atoms._ol_wt_notice);}
//			Atom		atom_ol_wt_other()		{return(atoms._ol_wt_other);}
//			Atom		atom_ol_save_cfg()		{return(atoms._ol_save_cfg);}
//			Atom		atom_ol_scale()			{return(atoms._ol_scale);}
//			Atom		atom_ol_show_info()		{return(atoms._ol_show_info);}
//			Atom		atom_ol_win_busy()		{return(atoms._ol_win_busy); }
			Atom		atom_swm_root()			{return(atoms._swm_root);}
//			Atom		atom_swm_version()		{return(atoms._swm_version);}
//			Atom		atom_sun_dragdrop_trigger()	{return(atoms._sun_dragdrop_trigger); }
//			Atom		atom_sun_dragdrop_preview()	{return(atoms._sun_dragdrop_preview); }
//			Atom		atom_sun_dragdrop_ack()		{return(atoms._sun_dragdrop_ack); }
//			Atom		atom_sun_dragdrop_done()	{return(atoms._sun_dragdrop_done); }
//			Atom		atom_sun_dragdrop_interest()	{return(atoms._sun_dragdrop_interest); }
//			Atom		atom_sun_dragdrop_dsdm()	{return(atoms._sun_dragdrop_dsdm); }
			PIXEL		attrib_def_bkg_pxl()		{return(attrib.def_bkg_pxl);}
			PIXEL		attrib_def_fg_pxl()		{return(attrib.def_fg_pxl);}
			GC		attrib_def_gc()			{return(attrib.def_gc);}
			OI_quark_pointer *attribute(XrmQuark q)			{ return (is_attribute(q)); }
			void		attribute_del(XrmQuark q)		{ del_attribute(q); }
			void		*attribute_get(XrmQuark q)		{ return (get_attribute(q)); }
			OI_quark_pointer *attribute_set(XrmQuark q, void *p)	{ return (set_attribute(q, p)); }
			char		**bitmap_file_path()		{ return (bitmapFilePath); }
			Pixmap		busy_clip()			{return(pm_busy);}
			Cursor		busy_cursor()			{ return (bsy_cursor); }
			void		calc_3d_pixels(PIXEL, PIXEL*, PIXEL*, PIXEL*);
			void		change_root(Window,OI_d_tech*) ;			/* change virtual root */
			void		char_to_keyevent(XKeyEvent*,char) ;
			void		check_for_mwm();
			void		check_for_olwm3();
			void		clear_has_focus()		{ctl_bits &= ~OI_CONN_HAS_FOCUS;}
			void		clear_pointer_grabbed()		{ctl_bits &= ~OI_CONN_POINTER_GRABBED;}
			Time		click_delta()			{ return ((Time)click_dlta); }
			void		close_classes(OI_class*) ;
			OI_attr_colors	*color_attributes()		{ return (attrcolors); }
			void		connection_lost() ;
			XStandardColormap	*create_rgb_map(Atom) ;
			Pixmap		create_bitmap_from_data(char*, unsigned int, unsigned int);
			void		create_motif_dnd_cursors(OI_d_tech *, const char*, OI_dnd_operation, Cursor*, Cursor*);
			void		create_ol_dnd_cursors(OI_d_tech *, const char*, OI_dnd_operation, Cursor*, Cursor*);
			void		create_text_dnd_cursors(OI_d_tech *, const char*, OI_dnd_operation, Cursor*, Cursor*);
			GC		def_gc()			{return(nrm_gc);}
			XrmDatabase	default_database()		{ return (database(OI_default_database)); }
			OI_number	default_database_index()	{ return (database_index(OI_default_database)); }
			OI_font		*default_font()			{ return (fntp); }
			XrmDatabase	database(OI_rm_db);
			XrmDatabase	database(OI_number i)		{ return (dbs[i]->db()); }
			OI_rm_database	*database_class(OI_rm_db);
			OI_rm_database	*database_class(OI_number i)	{ return (dbs[i]); }
			void		database_disable(OI_rm_db);
			void		database_disable(OI_number i)	{ dbs[i]->disable(); }
			void		database_disable(XrmDatabase db){ database_disable(database_index(db)); }
			void		database_enable(OI_rm_db);
			void		database_enable(OI_number i)	{ dbs[i]->enable(); }
			void		database_enable(XrmDatabase db)	{ database_enable(database_index(db)); }
			OI_number	database_index(OI_rm_db);
			OI_number	database_index(XrmDatabase);
			OI_number	database_insert_before(OI_rm_db d, XrmDatabase db=0)	{ return (database_insert_before(database_index(d), db)); }
			OI_number	database_insert_before(OI_number, XrmDatabase db=0);
			OI_number	database_insert_after(OI_rm_db d, XrmDatabase db=0);
			OI_number	database_insert_after(OI_number i, XrmDatabase db=0);
			OI_bool		database_is_enable(OI_rm_db d)	{ return(dbs[database_index(d)]->is_enable()); }
			OI_bool		database_is_enable(OI_number i)	{ return(dbs[i]->is_enable()); }
			OI_bool		database_is_enable(XrmDatabase db)	{ return(dbs[database_index(db)]->is_enable()); }
			XrmDatabase	*database_pointer(OI_rm_db);
			XrmDatabase	*database_pointer(OI_number i)	{ return (dbs[i]->dbp()); }
			void		database_set(OI_rm_db, XrmDatabase);
			void		database_set(OI_number i, XrmDatabase db)	{ dbs[i]->set_db(db); }
			OI_font_bounds *default_font_bounds()	{ return (fntbnds); }
			char		*default_key()			{ return (defaultKey); }
			void		del_attribute(XrmQuark);
			void		destroy_resources(OI_rm_db) ;				/* destroy a database */
			void		destroy_resources(OI_number) ;				/* destroy a database */
			void		disable_connection();
			void		disable_specific_resources(const char* const *, unsigned int);
			void		disallow_event_propagation()	{ ctl_bits &= ~OI_CONN_EVENT_PROPAGATION; }
			void		disallow_help()			{ ctl_bits |= OI_NO_HELP; }
			void		disallow_ignore_mouse_lock()	{ ctl_bits &= ~OI_IGNORE_MOUSE_LOCK; }
			void		disallow_lost()			{ ctl_bits &= ~OI_CONN_LOST; }
			void		disallow_motif_pushpins()	{ ctl_bits &= ~OI_MOTIF_PUSHPINS; }
			void		disallow_mwm_hints()		{ ctl_bits &= ~OI_CONN_DO_MWM_HINTS; }
			void		disallow_named_objects()	{ ctl_bits &= ~OI_CONN_NAMED_OBJECTS; }
			void		disallow_olwm_hints()		{ ctl_bits &= ~OI_CONN_DO_OLWM_HINTS; }
			void		disallow_server_grabbed()	{ ctl_bits &= ~OI_CONN_SERVER_GRABBED; }
			void		disallow_ungrabbed_server()	{ ctl_bits &= ~OI_UNGRABBED_SERVER; }
			void		disallow_using_mwm()		{ ctl_bits &= ~OI_CONN_USING_MWM; }
			void		disallow_using_olwm3()		{ ctl_bits &= ~OI_CONN_USING_OLWM3; }
			void		disallow_wm_ignores_pposition()	{ ctl_bits &= ~OI_WM_IGNORES_PPOSITION; }
			OI_dispatch	*dispatch() ;
			void		dispatch_insert(Window w,unsigned long em,OI_event_fnp fp,void *argp=NULL, OI_number p= -1) ;
			void		dispatch_insert(Window w,unsigned long em,OI_callback *objp,OI_event_memfnp mfp,void *argp=NULL,
						OI_number p= -1) ;
			void		dispatch_remove(Window w,unsigned long em,OI_event_fnp fp,void *argp=NULL) ;
			void		dispatch_remove(Window w,unsigned long em,OI_callback *objp,OI_event_memfnp mfp,void *argp=NULL) ;
			OI_bool		down_is_bkg()			{return(OI_bool)((ctl_bits&OI_CONN_DOWN_IS_BKG) != 0);}
			OI_number	drag_right_distance()			{ return (drag_right); }
			void		dragdrop_update();
			unsigned long	event_propagation_button_mask()		{ return (prop_btn_mask); }
			OI_stat		expand_grab_stack();
			void		flush()				{ XFlush(dpy); disallow_ungrabbed_server(); }
			OI_focus_policy	focus_policy()			{return(focs);}
			GC		gc()				{return(use_gc);}
			OI_gc_attr	*gc_attr()			{return(&def_gc_val);}
//			OI_bool		get_cache() ;					/* retrieve cache of initialization data */
			void		get_colors();					/* fetch color resources */
			void		get_openwindows_resources();
			int		grab_pointer(Window, Bool, long, int, int, Window, Cursor, Time);
			OI_bool		selection_aquire(Atom, OI_d_tech *, Time);
			void		selection_release(Atom);
			OI_d_tech	*selection_owner(Atom);
			OI_selection_owner *selection_owner_class(Atom);
			Time		selection_time(Atom);
			void		*get_attribute(XrmQuark);
			void		grab_server()			{ XGrabServer(dpy); allow_server_grabbed();}
			Pixmap		gray_mask()			{return(gray);} ;
			OI_bool		has_focus()			{return(OI_bool)((ctl_bits&OI_CONN_HAS_FOCUS) != 0);}
			OI_bool		help_allowed()			{ return ((OI_bool)((ctl_bits&OI_NO_HELP)?OI_NO:OI_YES)); }
			OI_translation_table *help_translations()	{ return (help_trans); }
			OI_help		*hyper_help()			{return(hyp_hlp);}
			unsigned int	ignore_modifier_mask()		{ return (ignore_msk); }
			Pixmap		inactive_clip()			{return(pm_inactive);}
			void		inherit_resources(XrmQuark, XrmQuark);			/* inherit base class resources */
			OI_bool		init_obj() ;						/* initialize OI objects & attributes */
			void		init_res(int*,char**,const char*,const char*,XrmOptionDescRec*,int) ;
			OI_quark_pointer *is_attribute(XrmQuark);
			OI_bool		is_event_propagation(const XEvent*);
			OI_bool		is_ignore_mouse_lock()		{ return ((OI_bool)((ctl_bits&OI_IGNORE_MOUSE_LOCK)?OI_YES:OI_NO)); }
			OI_bool		is_lost()			{ return ((OI_bool)((ctl_bits&OI_CONN_LOST)?OI_YES:OI_NO)); }
			OI_bool		is_motif_pushpins()		{ return ((OI_bool)((ctl_bits&OI_MOTIF_PUSHPINS)?OI_YES:OI_NO)); }
			OI_bool		is_mwm_hints()			{ return ((OI_bool)((ctl_bits&OI_CONN_DO_MWM_HINTS)?OI_YES:OI_NO)); }
			OI_bool		is_olwm_hints()			{ return ((OI_bool)((ctl_bits&OI_CONN_DO_OLWM_HINTS)?OI_YES:OI_NO)); }
			OI_bool		is_my_window(Window) ;					/* determine if window belongs to this client */
			OI_bool		is_named_objects()		{ return ((OI_bool)(ctl_bits&OI_CONN_NAMED_OBJECTS)); }
			OI_bool		is_valid_X_error_code(unsigned char) ;			/* check for error allowed to pass */
			OI_bool		is_ungrabbed_server()		{ return ((ctl_bits&OI_UNGRABBED_SERVER)?OI_YES:OI_NO); }
			OI_bool		is_using_mwm()			{ return ((ctl_bits&OI_CONN_USING_MWM)?OI_YES:OI_NO); }
			OI_bool		is_using_olwm3()		{ return ((ctl_bits&OI_CONN_USING_OLWM3)?OI_YES:OI_NO); }
			OI_bool		is_wm_ignores_pposition()	{ return ((ctl_bits&OI_WM_IGNORES_PPOSITION)?OI_YES:OI_NO); }
			OI_lang_server	*lang_server_list()		{ return(lngsrv_lstp); }
			XrmQuark	language()			{ return (langq); }
/*KNOWN*/		OI_d_tech	*last_focus()			{return(lst_focus);}	
			Time		last_focus_time()		{ return(lst_fcs_tim); }
			OI_attr_layout	*layout_attributes()		{ return (attrlayout); }
			void		lock_attributes() ;					/* lock attributes for connection */
			void		lost_display() ;
			OI_key		map_key(const XKeyEvent*,char*,XComposeStatus*) ;
			void		map_super_caret(OI_d_tech *, OI_super_caret_position=OI_super_caret_last);
			void		merge_resources(const char* const*, unsigned int, XrmDatabase *);
			OI_attr_misc	*misc_attributes()		{ return (attrmisc); }
			OI_model	*model_obj();
			OI_mnemonic_style mnemonic_style()		{return (mnstyle);}
			Time		multi_click_delta()			{ return ((Time)multi_click_dlta); }
			OI_font		*new_font(XrmQuark) ;					/* allocate new font */
			OI_font		*new_font(const char*f) ;
			OI_lang_server	*new_lang_server(XrmQuark) ;				/* register new language server */
//			OI_lang_server	*new_lang_server(const char *l)	{ return(new_lang_server(XrmStringToQuark(l)); }
			OI_ol_win_attr	*new_ol_win_attr();
			OI_pixmap	*new_pixmap(Pixmap,OI_bool=OI_YES,OI_number=0,OI_number=0,OI_number=1) ;	/* allocate new pixmap */
			OI_pixmap	*new_pixmap(XrmQuark,OI_bool=OI_YES,OI_number=1,PIXEL=0,PIXEL=0) ;	/* allocate new pixmap */
			OI_pixmap	*new_pixmap(const char*f,OI_bool=OI_YES,OI_number=1,PIXEL=0,PIXEL=0) ;
			OI_connection	*next()				{return(fwd_lnk);}
			OI_number	num_database()			{return(num_dbs);}
			OI_d_tech	*oi_object() ;			/* for user derived classes */
			OIG_output_device *output_device()		{return(outdev);}
			void		pixmap_deref(OI_pixmap*) ;			/* dereference a pixmap */
			OI_pixmap	*pixmap_list()			{return(pix_lstp);}
			void		pixmap_ref(OI_pixmap*) ;
			OI_bool		pointer_grabbed()		{return((OI_bool) ((ctl_bits&OI_CONN_POINTER_GRABBED) != 0));}
			void		purge_grab_pointer(Window) ;
//			OI_bool		put_cache() ;						/* write cache of initialization data */
			OI_stat		rgb_color(XColor *, Colormap, OI_bool) ;
			void		resource_stack_init() ;					/* initialize top of resource stack */
			OI_bool		reverse()			{ return((OI_bool) ((ctl_bits&OI_CONN_REVERSE) != 0)); }
			OI_number	reverse_key_translate(OI_key,OI_key**) ;
			OI_rmgr		*rm()				{return(rmgr);}		/* get resource manager object */
			void		select(const XEvent*) ;					/* process clicks */
			void		set_abs_model(OI_model_type) ;				/* Set the model as specified */
			void		set_action_table(OI_action_table_rec *a)	{ actions=a; }
			void		set_app_database( XrmDatabase db )	{ database_set(OI_app_database, db); }
			void		set_atom_cutbuffer(Atom a)	{atoms.cutbuffer=a;}
			void		set_attrib_def_bkg_pxl(PIXEL p)	{attrib.def_bkg_pxl = p;}
			void		set_attrib_def_fg_pxl(PIXEL p)	{attrib.def_fg_pxl = p;}
			void		set_attrib_def_gc(GC dgc)	{attrib.def_gc = dgc;}
			OI_quark_pointer *set_attribute(XrmQuark, void*);
			void		set_chk_X_error_code(unsigned char k)	{chk_X_err_code=k;}
			void		set_command(int,char**) ;				/* change WM_COMMAND property */
			XrmDatabase	set_database()			{ return (database(OI_set_database)); }
			OI_number	set_database_index()		{ return (database_index(OI_set_database)); }
			void		set_event_propagation_button_mask(unsigned long m)	{ prop_btn_mask = m; }
			void		set_gc(GC g)			{use_gc=g;}
												/* not {return(rt->attrib());} because circular *.H defs */
			void		set_has_focus()			{ctl_bits |= OI_CONN_HAS_FOCUS;}
			void		set_last_focus(OI_d_tech *d)	{lst_focus = d; }	/* set the default focus object */
			void		set_last_time(Time t)		{ lst_tim=t; }
			void		set_last_focus_time(Time t)	{ lst_fcs_tim=t; if (lst_tim < t)  lst_tim = t;}

			void		set_output_device(OIG_output_device *od)	{outdev = od;}
			void		set_pointer_grabbed()		{ctl_bits |= OI_CONN_POINTER_GRABBED;}
			void		set_primary(OI_d_tech *p)	{_Primary=OI_Primary=p;}
			void		set_reverse();
			void		set_rm(OI_rmgr *r)		{rmgr = r;}		/* set resource manager object */
			void		set_user_data()			{if (usr_datp) *usr_datp=usr_dat;}
			void		set_wl_pointer_object(OI_d_tech *, const XEvent*);
//			OI_bool		setup_from_cache(OI_type) ;			/* use data from cache */
			char		**subclass_file_path()		{ return (subclassFilePath); }
			Window		super_caret()			{ return (scaret); }
			OI_d_tech	*super_caret_object()		{ return (scaret_objp); }
			Window		super_caret_up()		{ return (scaret_up); }
			Window		super_caret_right()		{ return (scaret_right); }
			void		tm_init();
			KeySym		*tm_keysyms()			{ return(keysyms); }
			int		tm_keysyms_per_keycode()	{ return(keysyms_per_keycode); }
			int		tm_min_keycode()		{ return(min_keycode); }
			int		tm_max_keycode()		{ return(max_keycode); }
			KeySym		*tm_mod_keysyms()		{ return(mod_keysyms); }
			OI_mod_to_keysym *tm_mods_to_keysyms()		{ return(mods_to_keysyms); }
			unsigned char	*tm_is_modifier()		{ return(is_modifier); }
			KeySym		tm_lock_meaning()		{ return(lock_meaning); }
			unsigned long	tm_mode_switch()		{ return(mode_switch); }
			int		ungrab_pointer(Time, OI_bool =OI_YES);
			void		ungrab_server()			{ XUngrabServer(dpy); XFlush(dpy); allow_ungrabbed_server();
									disallow_server_grabbed();}
			void		unmap_super_caret();
			OI_number	update_targets(Atom *);
//			int		valid_window(Window);			/* THIS FUNCTION NEEDS TO BE IMPLEMENTED. Return 1 if window valid. */
			OI_d_tech	*wl_pointer_object()		{return(wl_ptr_objp); }
			unsigned char	X_error_code()			{return(X_err_code);}

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			PIXEL		bdr_pixel() ;
			OI_number	bdr_width() ;
			PIXEL		bkg_pixel() ;
			OI_number	bvl_width() ;
			PIXEL		bottom_pixel() ;
			PIXEL		down_pixel() ;
			PIXEL		fg_pixel() ;
			char		*help_file() ;						/* retrieve help file */
			char		*help_topic() ;						/* retrieve help topic */
			OI_stat		pop_help(const char *top=NULL, const char *fil=NULL) ;		/* pop help context */
			OI_stat		push_help(const char *top, const char *fil=NULL) ;			/* set help context */

			OI_stat		set_help(const char *top, const char *fil=NULL) ;			/* set help context */
			void		set_key_help(OI_help_fnp fp, void *argp=NULL) ;
			void		set_key_help(OI_callback *objp, OI_help_memfnp mfp, void *argp=NULL) ;
			PIXEL		top_pixel() ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			OI_d_tech	*abs_root()			{return(abs_rt);}	/* get absolute root object */
			void		add_actions(OI_compiled_action_table);
			void		add_actions(OI_actions_rec *a, unsigned int n) ;
			OI_bool		add_resources(const char*, OI_rm_db=OI_app_database) ; /* add extra .Xdefaults style resources from a file */
			void		allow_object_resources()	{ ctl_bits &= ~OI_NO_OBJECT_RESOURCES; }
			void		app_resources(const char * const*r, unsigned int c)
									{ merge_resources(r, c, database_pointer(OI_app_database)); }
			Atom		atom(const char *);
			OI_d_tech	**build_from_configuration_file(const char*, OI_bool = OI_yes);
			OI_bool		call_action_proc(OI_d_tech *, XrmQuark, const XEvent *, const char* const *, unsigned int);
			OI_bool		call_action_proc(OI_d_tech *o, const char *a, const XEvent *e, const char* const *p, unsigned int np) ;
			OI_char_encode_type	char_encode_type()	{ return(char_encode_typ); }
			Colormap	colormap()			{return(std_clr_map.colormap);}
			Atom		colormap_type()			{return(clr_map_typ);}
			OI_bool		convert(XrmQuark f, XrmValue *fv, XrmQuark t, XrmValue *tv) ;
			OI_bool		convert(const char *f, XrmValue *fv, const char *t, XrmValue *tv) ;
			void		*data()				{return(usr_dat);}
			OI_d_tech	*default_focus()		{return(def_focus);}	
			void		default_resources(const char * const*r, unsigned int c)
									{ merge_resources(r, c, database_pointer(OI_default_database)); }
			void		disallow_object_resources()	{ ctl_bits |= OI_NO_OBJECT_RESOURCES; }
			void		dispatch_discard(Window w) ;
			void		dispatch_group_insert(Window w,OI_number n,OI_dispatch_entry *tp) ;
			void		dispatch_group_remove(Window w,OI_number n,OI_dispatch_entry *tp) ;
			void		dispatch_ignore(const XEvent *ep) ;
			void		dispatch_insert(Window w,int e,unsigned long em,OI_event_fnp fp,void *argp=NULL, OI_number p= -1) ;
			void		dispatch_insert(Window w,int e,unsigned long em,OI_callback *objp,OI_event_memfnp mfp,
						void *argp=NULL, OI_number p= -1);
			void		dispatch_remove(Window w,int e,unsigned long em,OI_event_fnp fp,void *argp=NULL) ;
			void		dispatch_remove(Window w,int e,unsigned long em,OI_callback *objp,OI_event_memfnp mfp,
						void *argp=NULL) ;
			Display		*display()			{return(dpy);}		/* get X display variable ptr */
			char		*display_name();		/* returns hostname:display.screen */
			int		display_num()			{return(dpynum);}	/* get display number */
			OI_bool		draw_fast()			{ return(drawfast); }
			OI_d_tech	*find_obj(const XEvent*,OI_number=0,OI_d_tech** =NULL,OI_bool=OI_no) ;	/* find object under pointer */
			OI_bool		get_resource(const char*, const char**, const char**,OI_bool=OI_yes) ;
		const	char		*get_resource(XrmQuark n, XrmQuark c) ;
		const	char		*get_resource(const char *n, const char *c) ;
			OI_bool		get_resource_cvt(XrmQuark n, XrmQuark c, XrmQuark t, void *tv) ;
			OI_bool		get_resource_cvt(const char *n, const char *c, const char *t, void *tv) ;
			void		get_resources(OI_resource *r, unsigned int c, void *b, XrmQuark *s = NULL, OI_d_tech *o = NULL) ;
			OI_bool		has_shape()			{ return((OI_bool)((ctl_bits&OI_CONN_HAS_SHAPE)?OI_yes:OI_no)); }
			char		*hostname()			{return(hstnam);}	/* get host name */
			OI_bool		is_color()			{return(clr_display);}	/* is this a color display */
			OI_bool		is_converter(XrmQuark f, XrmQuark t) ;
			OI_bool		is_converter(const char *f, const char *t) ;
			OI_bool		is_server_grabbed()		{ return ((ctl_bits&OI_CONN_SERVER_GRABBED)?OI_YES:OI_NO); }
			Time		last_time()			{ return(lst_tim); }
			Cursor		make_cursor(int) ;					/* make a cursor */
			Cursor		make_cursor(const char *, const char *) ;		/* make a cursor */
			Cursor		make_cursor(Pixmap, Pixmap, unsigned int, unsigned int);	/* make a cursor */
			void		make_default()			{OI_def_conp=this;}	/* establish this connection as OI_def_conp */
			OI_d_tech	**make_top_level(const char * = NULL, const char * = NULL, OI_number * = NULL );
			OI_model_type	model();
			int		num_screens() ;						/* # screens available */
			OI_bool		object_resources()		{ return ((OI_bool)((ctl_bits&OI_NO_OBJECT_RESOURCES)?OI_no:OI_yes)); }
			OI_connection	*open_screen(OI_number) ;				/* open new screen on existing connection */
			OI_d_tech	*orphanage()			{return(orph);}		/* get orphanage object */
			long		pixmap_series(OI_animate_item**,const char*,OI_bool=OI_yes,long=0,long=1) ;	/* pixmaps from series of files */
			void		pop_resource();						/* pop a name and class off of the resource prefix */
			void		push_resource(XrmQuark, XrmQuark);			/* push a name and class onto the resource prefix */
			void		push_resource(const char *n, const char *c)	;
			// a Solaris C++ compiler bug prevents this from being an inline
			void            register_converter(XrmQuark f, XrmQuark t, OI_cvt *fn); 
			void		register_converter(const char *f, const char *t, OI_cvt *fn) ;
			OI_d_tech	*root()				{return(vir_rt);}	/* get logical root object */
			int		screen_num()			{return(scnnum);}	/* get screen number */
			void		set_char_encode_type(OI_char_encode_type t)	{ char_encode_typ=t; }
			void		set_click(OI_click_fnp fp, void *argp=NULL) ;
			void		set_click(OI_callback *objp, OI_click_memfnp mfp, void *argp=NULL) ;
			void		set_colormap(Colormap,unsigned long=0,unsigned long=0,unsigned long=0,unsigned long=0,unsigned long=0,unsigned long=0,unsigned long=0) ;
			void		set_data(void *ud, void **udp=NULL)	{usr_dat=ud; usr_datp=udp;}
			void		set_default_focus(OI_d_tech *d) {def_focus = d; }	/* set the default focus object */
			void		set_model(OI_model_type) ;				/* Set the model as specified */
			void		set_resources(const char * const*r, unsigned int c)	{ merge_resources(r, c, database_pointer(OI_set_database)); }
			void		set_standard_colormap(Atom) ;
			OI_stat		str_color(const char*,PIXEL*,Colormap=None) ;			/* convert string to PIXEL value in clr_map */
			Time		time() ;						/* get current server time */
			long		uniform_pixmap_series(Pixmap**,const char*,OI_bool=OI_yes,long=0,long=1) ;	/* pixmaps from files, uniform */
			VisualID	visual_id()					{ return (def_visual_id); }
	} ;
//
//
//			END OF CONNECTION MEMBER FUNCTIONS
//
//


#define OI_OL_WIN_ATTR_WIN_TYPE		0x01
#define OI_OL_WIN_ATTR_MENU_TYPE	0x02
#define OI_OL_WIN_ATTR_PIN_STATE	0x04
#define OI_OL_WIN_ATTR_CANCEL		0x08

	// definitions for the _OL_WIN_ATTR property depending on what version of olwm we are running
	class OI_ol_win_attr : public OI_callback {
		public:
					OI_ol_win_attr()	{ }
		virtual			~OI_ol_win_attr();
		virtual	void		apply(OI_connection *, Window) = 0;
		virtual	void		set_win_type(Atom) = 0;
		virtual	void		set_menu_type(Atom) = 0;
		virtual	void		set_pin_state(unsigned long) = 0;
		virtual	void		set_cancel(unsigned long) = 0;
	};

	class OI_ol_win_attr_3 : public OI_ol_win_attr {
			Atom		win_type;
			Atom		menu_type;
			Atom		pin_state;
		public:
					OI_ol_win_attr_3()	{ win_type=0; menu_type=0; pin_state=0; }
		virtual			~OI_ol_win_attr_3();
		virtual	void		apply(OI_connection *, Window);
		virtual	void		set_win_type(Atom);
		virtual	void		set_menu_type(Atom);
		virtual	void		set_pin_state(unsigned long);
		virtual	void		set_cancel(unsigned long);
	};

	class OI_ol_win_attr_5 : public OI_ol_win_attr {
			unsigned long	flags;
			Atom		win_type;
			Atom		menu_type;
			unsigned long	pin_state;
			unsigned long	cancel;
		public:
					OI_ol_win_attr_5()	{ flags=0; win_type=0; menu_type=0; pin_state=0; cancel=0; }
		virtual			~OI_ol_win_attr_5();
		virtual	void		apply(OI_connection *, Window);
		virtual	void		set_win_type(Atom);
		virtual	void		set_menu_type(Atom);
		virtual	void		set_pin_state(unsigned long);
		virtual	void		set_cancel(unsigned long);
	};


//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		


//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

	OI_connection *oi_create_connection(int*,char**,const char* =NULL,const char* =NULL,XrmOptionDescRec* =NULL,int=0) ;
	OI_connection *oi_create_connection(Display*,int*,char**,const char* =NULL,const char* =NULL,XrmOptionDescRec* =NULL,int=0) ;

#endif /* OI_connect_H */
