/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	exmnu.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_excl_menu class header
 *
 *      RCSid = "$Id: exmnu.H,v 4.9.1.1 1993/06/01 22:54:20 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_exmnu_H
#define OI_exmnu_H

#ifndef OI_basmnu_H
#include <OI/basmnu.H>
#endif /* OI_basmnu_H */

	// class forward reference declaration
	class OI_mdl_excl_menu;
	class OI_excl_check_menu;
	class OI_excl_rect_menu;

 /* object specific control bits */
#define	OI_EXCL_MENU_UNSEL			0x1000L		/* menu allows deselecting exclusive items */
#define	OI_EXCL_MENU_UNSEL_CELLS		0x2000L		/* is this is set when allow_unsel is called, unselect the cell */
#define	OI_EXCL_MENU_RESEL			0x4000L		/* allow reselecting an already selected cell */

	class OI_excl_menu : public OI_basic_menu {
			OI_mdl_excl_menu	*mdl_dep ;
			unsigned long		ctl_bits ;					/* object specific control bits */
	 public:
		static	OI_class		*clsp ;						/* ptr to class record */
	 private:
			void			construct() ;
	 protected:
						OI_excl_menu(OI_class*, const char*, OI_orient=OI_VERTICAL, const char* =NULL) ;
						~OI_excl_menu() ;
			void			init_selections() ;				/* initialize preselected cells */
		virtual	void			new_model(OI_model_type) ;
	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_menu_cell		*abbr_cell() ;
			void			allow_unselect_cells()		{ ctl_bits |= OI_EXCL_MENU_UNSEL_CELLS; }
		virtual	void			cell_pre_unparent(OI_menu_cell*) ;
		virtual	OI_menu_cell		*cell_to_fire(OI_menu_cell*,OI_bool=OI_NO) ;
		virtual	void			choose_cell(OI_menu_cell*, OI_bool=OI_YES);
		virtual	void			clear_selected_cell(OI_menu_cell *);
		virtual	void			clone_adjust(OI_d_tech*) ;
			void			disallow_unselect_cells()	{ ctl_bits &= ~OI_EXCL_MENU_UNSEL_CELLS; }
			void			get_resources();
		static	OI_bool			init(OI_connection*) ;
			OI_bool			is_unselect_cells()		{ return ((ctl_bits&OI_EXCL_MENU_UNSEL_CELLS)?OI_YES:OI_NO); }
		virtual	void			leave_menu();
		static	OI_excl_menu		*make_minimal(const char*,OI_minimal_type) ;
		virtual	OI_number		num_abbr_cell() ;
		virtual	OI_stat			num_set_abbr_cell(OI_number n) ;
			void			res_unsel (void *ptr);
		virtual	OI_stat			set_abbr_cell(const char *np) ;
		virtual	void			set_selected_cell(OI_menu_cell *);
		virtual	OI_stat			set_trigger(OI_number, OI_number=0) ;
		virtual	OI_stat			select_cell(OI_bool on_off, OI_menu_cell *cp, OI_bool=OI_NO, OI_bool=OI_YES) ;
			void			touch(OI_menu_cell*, OI_bool=OI_YES) ;		/* touch a cell as the current selection */
			void			fire_cell(OI_menu_cell *);

 		virtual	void			original_state(OI_bool = OI_YES);				/* Reset to before interaction start*/

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void			add_cell(OI_menu_cell*, OI_number, OI_bool=OI_YES) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void			allow_resel() ;
		virtual	void			allow_unsel() ;
		virtual	void			disallow_resel() ;
		virtual	void			disallow_unsel() ;
		virtual	OI_bool			is_resel() ;
		virtual	OI_bool			is_unsel() ;
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	OBSOLETED FUNCTIONS	
//		Functions below this point were once documented in the programmer's manual under
//		this object, but are now obsolete and will be removed in a future release.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_excl_rect_menu	*oi_excl_rect_menu(const char*, OI_number, OI_menu_cell**, OI_orient=OI_VERTICAL, const char* =NULL) ;
	OI_excl_check_menu	*oi_excl_check_menu(const char*, OI_number, OI_menu_cell**, OI_orient=OI_VERTICAL, const char* =NULL) ;
	OI_excl_menu		*oi_excl_menu(const char *np, OI_number nc, OI_menu_cell **cpp, OI_orient o=OI_VERTICAL,
					const char *t=NULL) ;

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_excl_rect_menu	*oi_create_excl_rect_menu(const char*, OI_number,OI_cell_spec*,OI_orient=OI_VERTICAL,const char* =NULL) ;
	OI_excl_rect_menu	*oi_create_excl_rect_menu(const char*, OI_number,OI_menu_cell**,OI_orient=OI_VERTICAL,const char* =NULL) ;

	OI_excl_check_menu	*oi_create_excl_check_menu(const char*, OI_number,OI_cell_spec*,OI_orient=OI_VERTICAL,const char* =NULL) ;
	OI_excl_check_menu	*oi_create_excl_check_menu(const char*, OI_number,OI_menu_cell**,OI_orient=OI_VERTICAL,const char* =NULL) ;

	OI_excl_menu		*oi_create_excl_menu(const char*, OI_number,OI_cell_spec*,OI_orient=OI_VERTICAL,const char* =NULL) ;
	OI_excl_menu		*oi_create_excl_menu(const char *np, OI_number nc, OI_menu_cell **cpp, OI_orient o=OI_VERTICAL,
							const char *t=NULL) ;

#endif /* OI_exmnu_H */
