/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	scroll.H
 *
 *	Functions(s):
 *
 *	Description:
 *		Definitions for use by scrolling objects
 *
 *	RCSid = "$Id: scroll.H,v 4.1.1.1 1993/06/01 22:56:41 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_scroll_H
#define OI_scroll_H

	//-------------------------------------------------------------------------------------------------		
	//		
	//	RESTRICTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
	//		definitions in this section are not documented in the programmer's manual and are
	//		restricted to internal use by the toolkit.
	//		Definitions not contained in user documentation are subject to change without notice
	//		and should never be used by toolkit users.
	//
	//-------------------------------------------------------------------------------------------------		

#define	OI_SCROLL_INTERVAL	200	/* scroll interval (ms) when button down on scroll button */


// GA get rid of all of these after panner is converted for translations.  Need to modify entfld.OI cursor_key and its callers first
 /* key definitions */
#define	OI_SCROLL_KEY_UNIT		0					/* unit scroll (nomodifiers) */
#define	OI_SCROLL_KEY_VIEW		OI_K_SHIFT				/* viewport scroll */
#define	OI_SCROLL_KEY_EXTREME		OI_K_CTRL				/* scroll to extreme */
#define	OI_SCROLL_KEY_POSITION		OI_K_META				/* scroll to specified position */
#define OI_SCROLL_KEY_UNIT_LEFT		OI_K_LEFT				/* Scroll by single unit left */
#define OI_SCROLL_KEY_UNIT_RIGHT	OI_K_RIGHT				/* Scroll by single unit Right */
#define OI_SCROLL_KEY_UNIT_UP		OI_K_UP					/* Scroll by single unit Up */
#define OI_SCROLL_KEY_UNIT_DOWN		OI_K_DOWN				/* Scroll by single unit Down */
#define OI_SCROLL_KEY_VIEW_LEFT		(OI_SCROLL_KEY_VIEW|OI_K_LEFT)		/* Scroll by Viewport size left */
#define OI_SCROLL_KEY_VIEW_RIGHT	(OI_SCROLL_KEY_VIEW|OI_K_RIGHT)		/* Scroll by Viewport size Right */
#define OI_SCROLL_KEY_VIEW_UP		(OI_SCROLL_KEY_VIEW|OI_K_UP)		/* Scroll by Viewport size Up */
#define OI_SCROLL_KEY_VIEW_DOWN		(OI_SCROLL_KEY_VIEW|OI_K_DOWN)		/* Scroll by Viewport size Down */
#define OI_SCROLL_KEY_MAX_LEFT		(OI_SCROLL_KEY_EXTREME|OI_K_LEFT)	/* Scroll as far as possible left */
#define OI_SCROLL_KEY_MAX_RIGHT		(OI_SCROLL_KEY_EXTREME|OI_K_RIGHT)	/* Scroll as far as possible Right */
#define OI_SCROLL_KEY_MAX_UP		(OI_SCROLL_KEY_EXTREME|OI_K_UP)		/* Scroll as far as possible Up */
#define OI_SCROLL_KEY_MAX_DOWN		(OI_SCROLL_KEY_EXTREME|OI_K_DOWN)	/* Scroll as far as possible Down */
#define OI_SCROLL_BTN_UNIT_LEFT		OI_PTR_LEFT_BTN				/* Scroll by single unit left */
#define OI_SCROLL_BTN_UNIT_RIGHT	OI_PTR_RIGHT_BTN			/* Scroll by single unit Right */
#define OI_SCROLL_BTN_UNIT_UP		OI_PTR_UP_BTN				/* Scroll by single unit Up */
#define OI_SCROLL_BTN_UNIT_DOWN		OI_PTR_DOWN_BTN				/* Scroll by single unit Down */
#define OI_SCROLL_BTN_VIEW_LEFT		(OI_PTR_SHIFT|OI_PTR_LEFT_BTN)		/* Scroll by Viewport size left */
#define OI_SCROLL_BTN_VIEW_RIGHT	(OI_PTR_SHIFT|OI_PTR_RIGHT_BTN)		/* Scroll by Viewport size Right */
#define OI_SCROLL_BTN_VIEW_UP		(OI_PTR_SHIFT|OI_PTR_UP_BTN)		/* Scroll by Viewport size Up */
#define OI_SCROLL_BTN_VIEW_DOWN		(OI_PTR_SHIFT|OI_PTR_DOWN_BTN)		/* Scroll by Viewport size Down */
#define OI_SCROLL_BTN_MAX_LEFT		(OI_PTR_CTRL|OI_PTR_LEFT_BTN)		/* Scroll as far as possible left */
#define OI_SCROLL_BTN_MAX_RIGHT		(OI_PTR_CTRL|OI_PTR_RIGHT_BTN)		/* Scroll as far as possible Right */
#define OI_SCROLL_BTN_MAX_UP		(OI_PTR_CTRL|OI_PTR_UP_BTN)		/* Scroll as far as possible Up */
#define OI_SCROLL_BTN_MAX_DOWN		(OI_PTR_CTRL|OI_PTR_DOWN_BTN)		/* Scroll as far as possible Down */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		
/*
	Units are the user's arbitrary measure.
	Scroll task is called as follows:
		void scroll_task(user_arg,OI_scroll_event,num) ;
	If event is OI_SCROLL_UNIT:
		num is # units controller has been moved in the specified direction;
		num < 0 implies toward the beginning, num > 0 implies toward the end.
*/

	enum OI_scroll_event {		/* Events returned to user task */
		OI_scroll_unit		= 1,			/* Move by units, towards beginning/end of object */
		OI_SCROLL_UNIT		= OI_scroll_unit,
		OI_scroll_viewport	= 2,			/* Move by viewports, towards beginning/end of object */
		OI_SCROLL_VIEWPORT	= OI_scroll_viewport,
		OI_scroll_extreme	= 3,			/* Move beginning/end of object into viewport */
		OI_SCROLL_EXTREME	= OI_scroll_extreme,
		OI_scroll_position	= 4,			/* Reposition viewport at location in object */
		OI_SCROLL_POSITION	= OI_scroll_position
	} ;

/* definitions for scroll object constructors */
#define	OI_SCROLL_NONE			0x000	/* for user defined controllers */
#define OI_SCROLL_1D			0x00F	/* scrollbar */
#define OI_SCROLL_2D			0xF00	/* panner */
#define OI_scroll_panner		0x100	/* panner */
#define OI_scroll_bar_top		0x001	/* scrollbar at top of box */
#define OI_scroll_bar_bottom		0x002	/* scrollbar at bottom of box */
#define OI_scroll_bar_horizontal	(OI_scroll_bar_top|OI_scroll_bar_bottom)
#define OI_scroll_bar_left		0x004	/* scrollbar at left of box */
#define OI_scroll_bar_right		0x008	/* scrollbar at right of box */
#define OI_scroll_bar_vertical		(OI_scroll_bar_left|OI_scroll_bar_right)
#define OI_scroll_bar_both		(OI_scroll_bar_vertical|OI_scroll_bar_horizontal)
#define OI_SCROLL_PANNER		OI_scroll_panner
#define OI_SCROLL_BAR_TOP		OI_scroll_bar_top
#define OI_SCROLL_BAR_BOTTOM		OI_scroll_bar_bottom
#define OI_SCROLL_BAR_HORIZONTAL	OI_scroll_bar_horizontal
#define OI_SCROLL_BAR_LEFT		OI_scroll_bar_left
#define OI_SCROLL_BAR_RIGHT		OI_scroll_bar_right
#define OI_SCROLL_BAR_VERTICAL		OI_scroll_bar_vertical
#define OI_SCROLL_BAR_BOTH		OI_scroll_bar_both

		//-------------------------------------------------------------------------------------------------		
		//		
		//	END OF DOCUMENTED SECTION
		//
		//-------------------------------------------------------------------------------------------------		

#endif /* OI_scroll_H */
