/*
 * dip		A program for handling dialup IP connecions.
 *
 * Author:      Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *		Copyright 1988-1993 MicroWalt Corporation
 *
 *		This program is free software; you can redistribute it
 *		and/or  modify it under  the terms of  the GNU General
 *		Public  License as  published  by  the  Free  Software
 *		Foundation;  either  version 2 of the License, or  (at
 *		your option) any later version.
 */
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <arpa/inet.h>
#include <arpa/nameser.h>
#include <netinet/in.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <netdb.h>
#include <pwd.h>
#include <resolv.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <termios.h>
#include <unistd.h>
#include <stdio.h>
#include "../pathnames.h"


/* DIP definitions. */
#define DIP_SFX		".dip"
#define DIP_SLIP	1		/* we support the SLIP protocol	*/
#define DIP_PPP		0		/* we support the PPP protocol	*/

/* SLIP/PPP/ASK initial protocol configuration. */
#define DEF_MTU		296
#define DEF_PROT	"SLIP"
#define DEF_MODEM	"HAYES"
#define DEF_SPEED	19200
#define DEF_PORT	""

/* Function prototyping according to ANSI. */
#ifndef _PROTOTYPE
#    if _MINIX
#	include <ansi.h>
#    else
#	define _ANSI		0
#	ifdef __STDC__		
#	    if (__STDC__ == 1)	
#	    	undef _ANSI
#	    	define _ANSI	1
#	    endif
#	endif
#	if _ANSI
#	    define	_PROTOTYPE(function, params)	function params
#	else
#	    define	_PROTOTYPE(function, params)	function()
#	endif /* _ANSI */
#    endif /* _MINIX */
#endif	/* _PROTOTYPE */

/* Define some IP layer stuff.  Not all systems have it. */
#define	IP_VERSION	4		/* version# of our IP software	*/
#define	IPF_F_OFFSET	0x1fff		/* Offset field			*/
#define	IPF_DF		0x4000		/* Don't fragment flag		*/
#define	IPF_MF		0x2000		/* More Fragments flag		*/
#define	IP_OF_COPIED	0x80		/* Copied-on-fragmentation flag	*/
#define	IP_OF_CLASS	0x60		/* Option class			*/
#define	IP_OF_NUMBER	0x1f		/* Option number		*/


struct dip {
  /* Login info. */
  char			name[16];		/* login name of host	*/
  char			passwd[10];		/* any external passwd	*/

  /* Misc protocol info. */
  char			comment[128];		/* any comments		*/
  char			protocol[16];		/* protocol to use	*/
  int			proto;			/* decoded protocol #	*/
  int			mtu;			/* MTU to use for conn.	*/

  /* Connection info. */
  char			local[128];		/* local host name	*/
  struct in_addr	loc_ip;			/* mapped IP address	*/
  char			remote[128];		/* remote host name	*/
  struct in_addr	rmt_ip;			/* mapped IP address	*/
  char			gateway[128];		/* remote gateway name	*/
  struct in_addr	rmt_gw;			/* mapped IP address	*/
  char			netmask[32];		/* netmask of route	*/
  char			route[128];		/* name of rmt network	*/
  struct in_addr	rmt_rt;			/* mapped IP address	*/
};


/* DIP protocol switcher definitions. */
struct protosw {
  char	*name;
  int	type;
  _PROTOTYPE( int (*func), (int, struct dip *) );
};


/* DIP global variables. */
#ifndef GLOBAL
#   define GLOBAL	extern
#endif
GLOBAL int	opt_i;			/* flag: incoming connection	*/
GLOBAL int	opt_t;			/* flag: dump incoming IP packs */
GLOBAL int	opt_v;			/* flag: be verbose!		*/
GLOBAL char	var_modem[128];		/* name of modem we are using	*/
GLOBAL char	var_port[PATH_MAX];	/* terminal line used		*/
GLOBAL long	var_speed;		/* terminal line speed		*/
GLOBAL struct dip mydip;		/* global DIP entry		*/
extern struct protosw protosw[];	/* table with protocol info	*/

/* Global functions. */
_PROTOTYPE( int  do_command, (FILE *file)				);

_PROTOTYPE( int  do_login, (char *user, char **argp)			);

_PROTOTYPE( void do_term, (void)					);

_PROTOTYPE( int  get_prot, (char *name)					);

_PROTOTYPE( void ip_dump, (char *ptr, int len)				);

_PROTOTYPE( int  mdm_dial, (char *number)				);
_PROTOTYPE( int  mdm_reset, (void)					);
_PROTOTYPE( int  mdm_type, (char *modem)				);

_PROTOTYPE( int  attach, (char *name, struct dip *dip)			);
_PROTOTYPE( void detach, (char *name)					);

_PROTOTYPE( int  tty_askfd, (void)					);
_PROTOTYPE( int  tty_can, (int fd)					);
_PROTOTYPE( int  tty_getc, (void)					);
_PROTOTYPE( int  tty_init, (char *tty_name)				);
_PROTOTYPE( int  tty_putc, (int c)					);
_PROTOTYPE( void tty_puts, (char *bufp)					);
_PROTOTYPE( int  tty_raw, (int fd, int speed, char *mode)		);
_PROTOTYPE( int  tty_speed, (int speed)					);
_PROTOTYPE( void tty_stop, (void)					);

_PROTOTYPE( int	 do_ppp, (int fd, struct dip *dip)			);
_PROTOTYPE( int	 do_slip, (int fd, struct dip *dip)			);

/* End of DIP.H */
