head	1.4;
access;
symbols;
locks
	PTI:1.4; strict;
comment	@ * @;


1.4
date	96.08.05.20.54.59;	author PTI;	state Exp;
branches;
next	1.3;

1.3
date	96.08.04.11.54.06;	author PTI;	state Exp;
branches;
next	1.2;

1.2
date	96.08.01.23.35.16;	author PTI;	state Exp;
branches;
next	1.1;

1.1
date	96.07.24.20.45.47;	author PTI;	state Exp;
branches;
next	;


desc
@Client frontend
@


1.4
log
@Fixed 'notepad-bug'. Notepad was called with system. However 'system'
returns control immediately to msql, so the edits are not used.
Changed caal to system by a 'spawnlp'(_P_WAIT,...'
@
text
@/*
**      msql.c  -
**
**
** Copyright (c) 1993-95  David J. Hughes
** Copyright (c) 1995   Hughes Technologies Pty Ltd
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
**
** This software is provided "as is" without any expressed or implied warranty.
**
** ID = "$Id:"
**
*/


#ifndef lint
static char RCS_id[] =
        "msql.c,v 1.3 1994/08/19 08:03:09 bambi Exp";
#endif


#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#ifdef OS2
#  include <string.h>
#endif
#ifdef WINNT
#  include <string.h>
#endif
#ifdef UNIX
#  include <string.h>
#endif
#ifdef WINSOCK
#  include <winsock.h>
#  include <process.h>
#  undef SOCKET_ERROR
#  undef APIENTRY
#  define APIENTRY 
#endif
#include <common/site.h>
#include <common/portable.h>

#include "version.h"
#include "msql.h"

#define MAX_LEN 15 * 1024


usage()
{
        (void)fprintf(stderr,"\n\nUsage : msql [-h host] database\n\n");
}



help()
{
        (void)printf("\n\nMiniSQL Help!\n\n");
        (void)printf("The following commands are available :- \n\n");
        (void)printf("\t\\q     Quit\n");
        (void)printf("\t\\g     Go (Send query to database)\n");
                  (void)printf("\t\\e     Edit (Edit previous query)\n");
        (void)printf("\t\\p     Print (Print the query buffer)\n");
}

#ifndef max
int max(v1,v2)
                  int     v1,
                                         v2;
{
                  if (v1 > v2)
                                         return(v1);
                  else
                                         return(v2);
}
#endif

bufFill(buf,length,max,filler)
                  char    *buf;
        int     length,
                                         max;
        char    filler;
{
        int     count;
        char    tmpBuf[2];

        tmpBuf[0] = filler;
        tmpBuf[1] = 0;
        count = max - length;
        while (count-- >= 0)
        {
                strcat(buf,tmpBuf);
        }
}



fill(length,max,filler)
        int     length,
                max;
        char    filler;
{
        int     count;

        count = max - length;
        while (count-- >= 0)
                  {
                                         printf("%c",filler);
        }
        fflush( stdout );
}



handleQuery(sock, q)
        int     sock;
        char    *q;
{
        char    *nq,
                                         sepBuf[MAX_LEN];
        int     off,
                maxLen,
                length;
        m_result *result;
        m_row   cur;
        m_field *curField;

        if (!q)
        {
                printf("No query specified !!\n");
                return;
        }
                  if (!*q)
        {
                printf("No query specified !!\n");
                return;
        }

        if (msqlQuery(sock,q) < 0)
        {
                printf("\n\nERROR : %s\n\n",msqlErrMsg);
                return;
        }
        printf("\nQuery OK.\n\n");

                  result = msqlStoreResult();
        if (!result)
        {
                printf("\n\n");
                return;
        }

        printf("%d rows matched.\n\n",msqlNumRows(result));

        /*
        ** Print a pretty header ....
        */
        (void)bzero(sepBuf,sizeof(sepBuf));
                  strcat(sepBuf," +");
        maxLen = 1;
                  while((curField = msqlFetchField(result)))
        {
                switch(curField->type)
                {
                        case REAL_TYPE:
                                length = strlen(curField->name);
                                if (length < 12)
                                {
                                        length = 12;
                                }
                                break;

                        case INT_TYPE:
                                length = strlen(curField->name);
                                if (length < 8)
                                {
                                        length = 8;
                                }
                                break;

                        case CHAR_TYPE:
                                length = max(strlen(curField->name),
                                                                                                                                curField->length);
                                break;
                                         }
                maxLen += length;
                if (maxLen >= MAX_LEN)
                {
                        printf("\n\nRow length is too long to be displayed\n");
                        msqlFreeResult(result);
                        return;
                }
                                         bufFill(sepBuf,0,length,'-');
                strcat(sepBuf,"-+");
        }
        strcat(sepBuf,"\n");
        printf(sepBuf);
                  msqlFieldSeek(result,0);

        printf(" |");
        while((curField = msqlFetchField(result)))
        {
                switch(curField->type)
                {
                        case INT_TYPE:
                                length = strlen(curField->name);
                                if (length < 8)
                                {
                                        length = 8;
                                }
                                                                                  break;

                        case REAL_TYPE:
                                length = strlen(curField->name);
                                if (length < 12)
                                {
                                        length = 12;
                                }
                                break;

                        case CHAR_TYPE:
                                length = max(strlen(curField->name),
                                                                                                                                curField->length);
                                                                                  break;
                }
                printf(" %s",curField->name);
                fill(strlen(curField->name),length,' ');
                printf("|");
        }
        printf("\n");
        msqlFieldSeek(result,0);
        printf(sepBuf);



        /*
                  ** Print the returned data
        */
                  while ((cur = msqlFetchRow(result)))
        {
                off = 0;
                printf(" |");
                while(off < msqlNumFields(result))
                {
                        curField = msqlFetchField(result);
                        switch(curField->type)
                        {
                            case INT_TYPE:
                                length = strlen(curField->name);
                                                                                  if (length < 8)
                                {
                                        length = 8;
                                }
                                break;

                            case REAL_TYPE:
                                length = strlen(curField->name);
                                if (length < 12)
                                {
                                        length = 12;
                                }
                                break;

                            case CHAR_TYPE:
                                length = max(strlen(curField->name),
                                                                                                                                curField->length);
                                break;
                        }
                        if (cur[off])
                        {
                                printf(" %s",cur[off]);
                                fill(strlen(cur[off]),length,' ');
                        }
                        else
                        {
                                                                                  printf(" NULL");
                                fill(4,length,' ');
                        }
                        printf("|");
                        off++;
                }
                printf("\n");
                msqlFieldSeek(result,0);
        }
        printf(sepBuf);
        msqlFreeResult(result);
        printf("\n\n");
}



editQuery(q)
        char    *q;
{
        char    *filename,
                *editor,
                combuf[1024];
        int     fd;

                  filename = (char *)msql_tmpnam(".");
        if( NULL != strrchr(filename, '\\') )
                                         filename = strrchr( filename, '\\' );
        if( NULL != strrchr(filename, '/') )
                filename = strrchr( filename, '/' );
                  fd = open(filename,O_CREAT | O_WRONLY, 0777);
        editor = (char *)getenv("VISUAL");
        if (!editor)
        {
                editor = (char *)getenv("EDITOR");
        }
        if (!editor)
        {
#ifdef OS2
                editor = "e";
#endif
#ifdef WINNT
                editor = "notepad";
#endif
#ifdef UNIX
                editor = "vi";
#endif
        }
                  write(fd,q,strlen(q));
        close(fd);
#ifdef WINNT
		_spawnlp( _P_WAIT, editor, editor, filename, NULL );
#else
        sprintf(combuf,"%s %s",editor,filename);
		system(combuf);
#endif
                  fd = open(filename,O_RDONLY, 0777);
                  bzero(q,MAX_LEN);
        read(fd,q,MAX_LEN);
        close(fd);
        unlink(filename);
#ifndef UNIX
        /*
        ** filter all EOFs (EOF --> SPACE)                *** OS2 & WINNT ***
        */
        editor = q;
        fd     = MAX_LEN;
        while( 0 < fd )
        {
                if( 0x1A == *editor )
                                                                *editor = ' ';
                                         editor++;
                fd--;
        }
#endif
}



main(argc,argv)
        int     argc;
        char    *argv[];
{
                  char    qbuf[MAX_LEN],
                                         *cp,
                *host = NULL;
        int     newQ = 1,
                prompt = 1,
                sock,
                                         inString = 0,
                c,
                argsLeft,
                errFlag = 0,
                qLen = 0;
                  register u_int inchar;
#ifdef OS2
                  int optind = 1;

                  if( 3     < argc                  &&
                                0    == strcmp(argv[1], "-h") )
                  { host    = argv[2];
                         optind += 2;
                  }

        printf("\n");
        if ( argc <= optind )
        {
                                         usage();
                exit(1);
                  }
#endif
#ifdef WINNT
                  int optind = 1;

                  if( 3     < argc                  &&
                                0    == strcmp(argv[1], "-h") )
                  { host    = argv[2];
                         optind += 2;
                  }

                  printf("\n");
                  if ( argc <= optind )
                  {
                                         usage();
                                         exit(1);
                  }
#endif
#ifdef UNIX
                  extern  int optind;
        extern  char *optarg;

                  while((c=getopt(argc,argv,"h:"))!= -1)
        {
                                         switch(c)
                {
                        case 'h':
                                                                                  if (host)
                                                                                                         errFlag++;
                                                                                  else
                                                                                                         host = optarg;
                                                                                  break;
                                                                case '?':
                                                                                  errFlag++;
                                                                                  break;
                                         }
                  }

                  argsLeft = argc - optind;

                  printf("\n");
                  if (argsLeft != 1)
                  {
                                         usage();
                                         exit(1);
                  }
#endif

                  /*
                  ** If we don't have a hostname have a look at MSQL_HOST
                  */
                  if (!host)
                  {
                                         host = (char *)getenv("MSQL_HOST");
                  }

                  if ((sock = msqlConnect(host)) < 0)
                  {
                                         printf("ERROR : %s\n",msqlErrMsg);
                                         exit(1);
                  }

                  if (msqlSelectDB(sock, argv[optind]) < 0)
                  {
                                         printf("ERROR : %s\n",msqlErrMsg);
                                         exit(1);
                  }

                  /*
                  **  Run in interactive mode like the ingres/postgres monitor
                  */

                  printf("Welcome to the miniSQL monitor.  Type \\h for help.\n\n");

                  inchar = EOF+1;
                  (void)bzero(qbuf,sizeof(qbuf));
                  cp = qbuf;
        printf("\nmSQL > ");
        fflush( stdout );
        while(!feof(stdin))
        {
                inchar = fgetc(stdin);
                qLen ++;
                if (qLen == MAX_LEN)
                {
                        printf("\n\n\nError : Query text too long ( > %d bytes!)\n\n", MAX_LEN);
                        printf("Check your query to ensure that there isn't an unclosed text field.\n\n");
                                                                exit(1);
                }
                                         if (inchar == '\\')
                {
                        if (inString)
                        {
                                *cp++ = inchar;
                                inchar = fgetc(stdin);
                                                                                  *cp++ = inchar;
                                continue;
                        }

                        inchar = fgetc(stdin);
                        if (inchar == EOF)
                                continue;
                                                                switch(inchar)
                        {
                                case 'h':
                                        help();
                                        newQ = 1;
                                        printf("\nmSQL > ");
                                        fflush( stdout );
                                        prompt=0;
                                        break;
                                case 'g':
                                        handleQuery(sock,qbuf);
                                        newQ = 1;
                                        qLen = 0;
                                                                                                         inString = 0;
                                        printf("\nmSQL > ");
                                        fflush( stdout );
                                        prompt=0;
                                        break;
                                case 'e':
                                        editQuery(qbuf);
                                        printf("Query buffer\n");
                                        printf("------------\n");
                                        printf("%s\n[continue]\n",qbuf);
                                        printf("    -> ");
                                        fflush( stdout );
                                        prompt=0;
                                                                                                         cp = qbuf + strlen(qbuf);
                                        qLen = strlen(qbuf);
                                        break;
                                case 'q':
                                        msqlClose(sock);
                                        printf("\n\nBye!\n\n");
                                                                                                         exit(0);

                                case 'p':
                                        printf("\nQuery buffer\n");
                                        printf("------------\n");
                                        printf("%s\n[continue]\n",qbuf);
                                        printf("    -> ");
                                                                                                         fflush( stdout );
                                        prompt=0;
                                        break;
                                default:
                                        printf("\n\nUnknown command.\n\n");
                                        newQ = 1;
                                        printf("\nmSQL > ");
                                        fflush( stdout );
                                        prompt=0;
                                        break;
                        }
                }
                else
                                         {
                        if (inchar == '\'')
                        {
                                if (inString)
                                        inString = 0;
                                else
                                        inString = 1;
                        }
                        if (inString)
                        {
                                *cp++ = inchar;
                                continue;
                        }
                                                                if ((newQ )&& (inchar != '\n'))
                        {
                                newQ = 0;
                                cp = qbuf;
                                (void)bzero(qbuf,sizeof(qbuf));
                        }
                        if (inchar == '#')
                        {
                                while(!feof(stdin))
                                {
                                        inchar = fgetc(stdin);
                                        if (inchar == '\n')
                                        {
                                                                                                                                break;
                                        }
                                }
                                continue;
                        }
                        if (inchar == '\n')
                        {
                                if (prompt)
                                {
                                        printf("    -> ");
                                        fflush( stdout );
                                }
                                else
                                                                                  {
                                        prompt++;
                                        continue;
                                }
                        }
                                                                *cp++ = inchar;
                }
        }
        msqlClose(sock);
        printf("\nBye!\n\n");
                  exit(0);
}
@


1.3
log
@added #undef to remove redefinition errors with WATCOM
@
text
@d40 1
d330 3
d334 2
a335 1
                  system(combuf);
@


1.2
log
@Removed references to WSACleanUp and WSAStartUp
@
text
@d40 2
d66 1
a66 1
		  (void)printf("\t\\e     Edit (Edit previous query)\n");
d72 2
a73 2
		  int     v1,
					 v2;
d75 4
a78 4
		  if (v1 > v2)
					 return(v1);
		  else
					 return(v2);
d83 1
a83 1
		  char    *buf;
d85 1
a85 1
					 max;
d111 2
a112 2
		  {
					 printf("%c",filler);
d124 1
a124 1
					 sepBuf[MAX_LEN];
d137 1
a137 1
		  if (!*q)
d150 1
a150 1
		  result = msqlStoreResult();
d163 1
a163 1
		  strcat(sepBuf," +");
d165 1
a165 1
		  while((curField = msqlFetchField(result)))
d187 1
a187 1
																curField->length);
d189 1
a189 1
					 }
d197 1
a197 1
					 bufFill(sepBuf,0,length,'-');
d202 1
a202 1
		  msqlFieldSeek(result,0);
d215 1
a215 1
										  break;
d227 2
a228 2
																curField->length);
										  break;
d241 1
a241 1
		  ** Print the returned data
d243 1
a243 1
		  while ((cur = msqlFetchRow(result)))
d254 1
a254 1
										  if (length < 8)
d270 1
a270 1
																curField->length);
d280 1
a280 1
										  printf(" NULL");
d304 1
a304 1
		  filename = (char *)msql_tmpnam(".");
d306 1
a306 1
					 filename = strrchr( filename, '\\' );
d309 1
a309 1
		  fd = open(filename,O_CREAT | O_WRONLY, 0777);
d327 1
a327 1
		  write(fd,q,strlen(q));
d330 3
a332 3
		  system(combuf);
		  fd = open(filename,O_RDONLY, 0777);
		  bzero(q,MAX_LEN);
d345 2
a346 2
								*editor = ' ';
					 editor++;
d358 2
a359 2
		  char    qbuf[MAX_LEN],
					 *cp,
d364 1
a364 1
					 inString = 0,
d369 1
a369 1
		  register u_int inchar;
d371 1
a371 1
		  int optind = 1;
d373 5
a377 5
		  if( 3     < argc                  &&
				0    == strcmp(argv[1], "-h") )
		  { host    = argv[2];
			 optind += 2;
		  }
d382 1
a382 1
					 usage();
d384 1
a384 1
		  }
d387 1
a387 1
		  int optind = 1;
d389 12
a400 12
		  if( 3     < argc                  &&
				0    == strcmp(argv[1], "-h") )
		  { host    = argv[2];
			 optind += 2;
		  }

		  printf("\n");
		  if ( argc <= optind )
		  {
					 usage();
					 exit(1);
		  }
d403 1
a403 1
		  extern  int optind;
d406 1
a406 1
		  while((c=getopt(argc,argv,"h:"))!= -1)
d408 1
a408 1
					 switch(c)
d411 19
a429 19
										  if (host)
													 errFlag++;
										  else
													 host = optarg;
										  break;
								case '?':
										  errFlag++;
										  break;
					 }
		  }

		  argsLeft = argc - optind;

		  printf("\n");
		  if (argsLeft != 1)
		  {
					 usage();
					 exit(1);
		  }
d432 29
a460 29
		  /*
		  ** If we don't have a hostname have a look at MSQL_HOST
		  */
		  if (!host)
		  {
					 host = (char *)getenv("MSQL_HOST");
		  }

		  if ((sock = msqlConnect(host)) < 0)
		  {
					 printf("ERROR : %s\n",msqlErrMsg);
					 exit(1);
		  }

		  if (msqlSelectDB(sock, argv[optind]) < 0)
		  {
					 printf("ERROR : %s\n",msqlErrMsg);
					 exit(1);
		  }

		  /*
		  **  Run in interactive mode like the ingres/postgres monitor
		  */

		  printf("Welcome to the miniSQL monitor.  Type \\h for help.\n\n");

		  inchar = EOF+1;
		  (void)bzero(qbuf,sizeof(qbuf));
		  cp = qbuf;
d471 1
a471 1
								exit(1);
d473 1
a473 1
					 if (inchar == '\\')
d479 1
a479 1
										  *cp++ = inchar;
d486 1
a486 1
								switch(inchar)
d499 1
a499 1
													 inString = 0;
d512 1
a512 1
													 cp = qbuf + strlen(qbuf);
d518 1
a518 1
													 exit(0);
d525 1
a525 1
													 fflush( stdout );
d538 1
a538 1
					 {
d551 1
a551 1
								if ((newQ )&& (inchar != '\n'))
d564 1
a564 1
																break;
d577 1
a577 1
										  {
d582 1
a582 1
								*cp++ = inchar;
d587 1
a587 1
		  exit(0);
@


1.1
log
@Initial revision
@
text
@a367 5
#ifdef WINSOCK
		  WORD wVersionRequired = MAKEWORD(1,1);  /* winsock 1.1 required */
		  WSADATA	wsaData;
		  int nErrorStatus;
#endif
d382 1
a382 1
        }
d404 1
a404 1
        while((c=getopt(argc,argv,"h:"))!= -1)
a437 7
#ifdef WINSOCK
		  if (WSAStartup(wVersionRequired, &wsaData) != 0)
		  {
			 printf("Error : Unable to initialise WINSOCK\n");
			 exit(1);
		  }
#endif
a440 3
#ifdef WINSOCK
					 WSACleanup();
#endif
a446 3
#ifdef WINSOCK
					 WSACleanup();
#endif
a584 3
#ifdef WINSOCK
		  WSACleanup();
#endif
@
