/*
** sqbcoseu.c
**
** Klaus Thiele (kth@oblib.teuto.de) - May '95
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sql.h>
#include <errsql.h>

#ifndef HOST
#define HOST NULL
#endif

typedef struct {
   SQLTCUR c;              /* sql cursor */
   char *text;             /* corresponding statement */
} SqlData;

SqlData sql[2];            /* SQLBASE cursors */

char   nr[5];
char   name[46];
int    age;
double money;
char   flag;

char   ddcFeld[13];
char   ddcName[13];
char   procName[13];

int main( void ) {

SQLTRCD   rcd;
SQLTNSI   nsi;
SQLTNBV   nbv;
SQLTROW   nrr;

char      errmsg[SQLMERR];

   /*
   ** connect cursor[0] to first database
   */
   if( (rcd = sqlcnc(&sql[0].c, "SQLBASE/SYSADM/SYSADM", 0, (SQLTDAP)HOST )) ) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
         return( 1 );
   }

   /*
   ** connect cursor[1] to second database
   */
   if( (rcd = sqlcnc(&sql[1].c, "COSEU", 0, (SQLTDAP)HOST)) ) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
         return( 1 );
   }

      /*
      ** a simple query
      */
      strcpy(procName,"esexgen");
      strcpy(ddcName,"PERSGROUP");

      sql[1].text = "SELECT DDC_NAME,DDC_FELD,PROC_NAME FROM PROC_DDC_FELDER "
                        "WHERE PROC_NAME = :1 AND DDC_NAME = :2 "
                        "ORDER BY DDC_FELD";

      if((rcd=sqlcom(sql[1].c, sql[1].text, 0))) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
      }

      if((rcd=sqlbnn(sql[1].c, 1, procName, sizeof(procName), 0, SQLPSTR)) ||
           (rcd=sqlbnn(sql[1].c, 2, ddcName, sizeof(ddcName), 0, SQLPSTR)) ) {
           sqlerr(rcd, (SQLTDAP)&errmsg);
           printf("%d: %s\n", rcd, errmsg);
      }


      if((rcd=sqlssb(sql[1].c, 1, SQLPSTR, ddcName, sizeof(ddcName), 0, SQLNPTR, SQLNPTR)) ||
         (rcd=sqlssb(sql[1].c, 2, SQLPSTR, ddcFeld, sizeof(ddcFeld), 0, SQLNPTR, SQLNPTR)) ||
         (rcd=sqlssb(sql[1].c, 3, SQLPSTR, procName, sizeof(procName), 0, SQLNPTR, SQLNPTR))) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
      }         

      if((rcd=sqlexe(sql[1].c))) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
      }

      /*
      */
      if((rcd=sqlnsi(sql[1].c,&nsi))) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
      } else
         printf("Number of select items: %d\n", nsi);

      if((rcd=sqlnbv(sql[1].c,&nbv))) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
      } else
         printf("Number of bind variables: %d\n", nbv);

      if((rcd=sqlnrr(sql[1].c,&nrr))) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
      } else
         printf("Number of fetched rows: %ld\n", nrr);

      /*
      */
      while( (rcd = sqlfet(sql[1].c)) == 0 ) {
         printf("sqlfet: %s, %s, %s\n", procName, ddcName, ddcFeld);
      }


      sql[0].text = "CREATE TABLE TESTIT ("
                      "NR INTEGER NOT NULL PRIMARY KEY, "
                      "NAME CHAR(128), "
                      "TEL CHAR(32) )";


      if ((rcd=sqlcex(sql[0].c, sql[0].text, 0))) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
      } else
         printf("Table created.\n");


      sql[0].text = "DROP TABLE TESTIT";

      if((rcd=sqlcex(sql[0].c, sql[0].text, 0))) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
      } else
         printf("Table droped.\n");

   /*
   ** disconnect cursors
   */
   sqldis(sql[0].c);
   sqldis(sql[1].c);

   return(0);
}
