.*------------------------------------------------------------------------------
.* CLI for mSQL (OS/2)
.*------------------------------------------------------------------------------
:userdoc.
:title.Call Level Interface (CLI) for mSQL (OS/2)

.*------------------------------------------------------------------------------
.* 'Info'
.*------------------------------------------------------------------------------
:h1 id=info clear.Info
:lines align=left.
:hp4.Call Level Interface (CLI) for mSQL (OS/2):ehp4.
* standardisation of database access *
:elines.
:artwork name='cli_logo.bmp' align=center.
:lines align=center.
:hp8.All programs included in this package are provided "as is", without
any warranty! Try them on your own risk.
:ehp8.
:elines.
:p.This documentation is based on various documentations and own expiriences.
:p.(c) 1996 by Dirk Ohme - all rights reserved

.*------------------------------------------------------------------------------
.* 'Introduction'
.*------------------------------------------------------------------------------
:h1 id=introduction clear.Introduction
:p.The :hp4.C:ehp4. :hp4.L:ehp4.ibrary :hp4.I:ehp4.nterface is an C-API for
writing portable database applications. It is meant to be database independent.
The sources are drawn a bit from ODBC (Open DataBase Connection - a firm
specific standard invented by the Microsoft Corporation) and CLI specified
by the ISO/ANSI comitee.

.*------------------------------------------------------------------------------
.* 'Definitions and Common Data Types'
.*------------------------------------------------------------------------------
:h1 id=definitions clear.Definitions and Common Data Types
:p.This section contains the definitions used within the Call-Level
Interface as there set in :hp1.sqlcli_.h:ehp1.. For better understanding,
notice, that (under OS/2!)&colon.
:lm margin=5.:ul.
:li. a :hp1.character:ehp1. has a size of 8 bits,
:li. a :hp1.word:ehp1. has a size of 16 bits,
:li. a :hp1.short integer:ehp1. has a size of 16 bits,
:li. a :hp1.double word:ehp1. has a size of 32 bits,
:li. a :hp1.long integer:ehp1. has a size of 32 bits.
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'Data Qualifier FAR, NEAR'
.*------------------------------------------------------------------------------
:h2 id=data_qualifier_far clear.Data Qualifier FAR, NEAR
:xmp.
  FAR
  NEAR
:exmp.
:p.The purpose of this qualifiers is to specify if a pointer is used
within this data segment (:hp1.NEAR:ehp1.) or not (:hp1.FAR:ehp1.). Under
OS/2 2.x or above it is not necessary to use this.
:note.
This is implemented for migration of software from platforms, where the
determination of :hp1.FAR:ehp1. and :hp1.NEAR:ehp1. pointers is necessary.

.*------------------------------------------------------------------------------
.*   'Data Type BOOL'
.*------------------------------------------------------------------------------
:h2 id=data_type_bool clear.Data Type BOOL
:xmp.
  BOOL                   { FALSE, TRUE }
:exmp.
:p.This defines a boolean data type with it's two possible values
:lm margin=5.:ul.
:li.:hp4.FALSE:ehp4.
:li.:hp4.TRUE:ehp4.
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'Data Type CHAR, UCHAR'
.*------------------------------------------------------------------------------
:h2 id=data_type_char clear.Data Type CHAR, UCHAR
:xmp.
  CHAR                   - signed char
  UCHAR                  - unsigned char
:exmp.
:p.This defines a data type for storing signed / unsigned integer values,
i.e. characters.

.*------------------------------------------------------------------------------
.*   'Data Type DWORD, SDWORD, UDWORD'
.*------------------------------------------------------------------------------
:h2 id=data_type_dword clear.Data Type DWORD, SDWORD, UDWORD
:xmp.
  DWORD                  - double word
  SDWORD                 - signed double word
  UDWORD                 - unsigned double word
:exmp.
:p.This defines a data type for storing signed / unsigned double words.

.*------------------------------------------------------------------------------
.*   'Data Type HANDLE'
.*------------------------------------------------------------------------------
:h2 id=data_type_handle clear.Data Type HANDLE
:xmp.
  HANDLE                 - (unqualified) handle
:exmp.
:p.The purpose of this data type is to store a unqualified handle to
"anything".

.*------------------------------------------------------------------------------
.*   'Data Type HWND'
.*------------------------------------------------------------------------------
:h2 id=data_type_hwnd clear.Data Type HWND
:xmp.
  HWND                   - handle (for) window
:exmp.
:p.The purpose of this data type is to store a handle for window manipulation.

.*------------------------------------------------------------------------------
.*   'Data Type LONG, ULONG'
.*------------------------------------------------------------------------------
:h2 id=data_type_long clear.Data Type LONG, ULONG
:xmp.
  LONG                   - signed long integer
  ULONG                  - unsigned long integer
:exmp.
:p.This defines a data type for storing signed / unsigned long integer
values.

.*------------------------------------------------------------------------------
.*   'Data Type PTR'
.*------------------------------------------------------------------------------
:h2 id=data_type_ptr clear.Data Type PTR
:xmp.
  PTR                    - (unqualified) pointer
:exmp.
:p.This data type is intended to be used for unqualified pointer
specification. It is comparable with the ANSI-C data type :hp1.void *:ehp1..

.*------------------------------------------------------------------------------
.*   'Data Type RETCODE'
.*------------------------------------------------------------------------------
:h2 id=data_type_retcode clear.Data Type RETCODE
:xmp.
  RETCODE                - (unqualified) program return code
:exmp.
:p.This data type is intended to be used to specify an unqualified
program return code, i.e. a return code of "something".

.*------------------------------------------------------------------------------
.*   'Data Type SHORT, USHORT'
.*------------------------------------------------------------------------------
:h2 id=data_type_short clear.Data Type SHORT, USHORT
:xmp.
  SHORT                  - signed short integer
  USHORT                 - unsigned short integer
:exmp.
:p.This defines a data type for storing signed / unsigned short integer
values.

.*------------------------------------------------------------------------------
.*   'Data Type WORD, SWORD, UWORD'
.*------------------------------------------------------------------------------
:h2 id=data_type_word clear.Data Type WORD, SWORD, UWORD
:xmp.
  WORD                   - word
  SWORD                  - signed word
  UWORD                  - unsigned word
:exmp.
:p.This defines a data type for storing signed / unsigned words.

.*------------------------------------------------------------------------------
.*   'Data Type UINT'
.*------------------------------------------------------------------------------
:h2 id=data_type_uint clear.Data Type INT
:xmp.
  UINT                   - unsigned integer
:exmp.
:p.This defines a data type for storing unsigned integer values.

.*------------------------------------------------------------------------------
.*   'Function Qualifier PASCAL'
.*------------------------------------------------------------------------------
:h2 id=function_qualifier_pascal clear.Function Qualifier PASCAL
:xmp.
  PASCAL
:exmp.
:p.The intention of this function qualifier is to distinguish between
function with "C" and "PASCAL" parameter/calling convention. For
example&colon.
:xmp.
  void funcProto(int a, int b );       /* C calling convention      */
  void PASCAL funcProto(int a, int b); /* PASCAL calling convention */
:exmp.
:lm margin=5.:ul.
:li. "C" calling stores first :hp1.b:ehp1., then :hp1.a:ehp1. to the head
:li. "PASCAL" calling stores first :hp1.a:ehp1., then :hp1.b:ehp1. to the head
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'Function Qualifier SQL_API'
.*------------------------------------------------------------------------------
:h2 id=function_qualifier_sql_api clear.Function Qualifier SQL_API
:xmp.
  SQL_API
:exmp.
:p.This qualifier is used for specification of a public call-level
interface routine (procedure).

.*------------------------------------------------------------------------------
.*   'Function Qualifier SQL_LOCAL_API'
.*------------------------------------------------------------------------------
:h2 id=function_qualifier_sql_local_api clear.Function Qualifier SQL_LOCAL_API
:xmp.
  SQL_LOCAL_API
:exmp.
:p.This qualifier is used for specification of a non-public (private)
call-level interface routine (procedure).

.*------------------------------------------------------------------------------
.*   'Function Macro MAX, MIN'
.*------------------------------------------------------------------------------
:h2 id=function_macro_max_min clear.Function Macro MAX, MIN
:xmp.
  MAX(x,y)               ((x > y) ? x : y)
  MIN(x,y)               ((x < y) ? x : y)
:exmp.
:p.These macros can be used for checking two numbers (numerical values)
against. :hp1.MAX:ehp1. returns the greater number, :hp1.MIN:ehp1. the
minor number of the two given ones.

.*------------------------------------------------------------------------------
.* 'SQL Data Types'
.*------------------------------------------------------------------------------
:h1 id=sql_data_types clear.SQL Data Types
:p.Accessing the database through the Call-Level Interface requires an
abstraction of the data types. The 'C' programming language and the structured
query language (SQL) have different names and types for certain data objects.
So there are data types defined in the header file :hp1.sqlcli_.h:ehp1. for
interactions between 'C' code and SQL database.

:p.First there are the following definitions (constants)&colon.
:table cols='25 54'.
:row.:c.SQL_DATE_LEN              :c.maximum length of date strings
:row.:c.SQL_MAX_ID_LENGTH         :c.maximum length of identifiers
:row.:c.SQL_MAX_MESSAGE_LENGTH    :c.maximum length of messages
:row.:c.SQL_SQLSTATE_SIZE         :c.maximum length of status codes
:row.:c.SQL_TIME_LEN              :c.maximum length of time strings
:row.:c.SQL_TIMESTAMP_LEN         :c.maxmimum length of a timestamp
:row.:c.SQLPOINTER                :c.:link reftype=hd refid=data_type_ptr.PTR:elink.
:row.:c.SQLRETURN                 :c.:link reftype=hd refid=data_type_retcode.RETCODE:elink. :link reftype=hd refid=function_qualifier_sql_api.SQL_API:elink.
:row.:c.SQLUINTEGER               :c.:link reftype=hd refid=data_type_uint.UINT:elink.
:row.:c.SQLUSMALLINT              :c.:link reftype=hd refid=data_type_short.USHORT:elink.
:etable.

:p.And now the SQL data types&colon.
:table cols='19 21 17 21'.
:row.:c.***SQL native***:c.identifier:c.'C'           :c.***comment***
:row.:c.SQLBINARY  :c.SQL_C_BINARY:c.unsigned char    :c.bit field of 8 bits
:row.:c.SQLBIT     :c.SQL_C_BIT   :c.:link reftype=hd refid=data_type_bool.BOOL:elink.:c.
:row.:c.SQLBLOBLOCATOR:c.SQL_C_BLOB_LOCATOR:c.long    :c.reference
:row.:c.SQLCHAR    :c.SQL_C_CHAR  :c.unsigned char    :c.
:row.:c.SQLCLOBLOCATOR:c.SQL_C_CLOB_LOCATOR:c.long    :c.reference
:row.:c.SQLDATE    :c.-           :c.unsigned char    :c.pointer to string
:row.:c.SQLDBCHAR  :c.SQL_C_DBCHAR:c.unsigned char    :c.character
:row.:c.SQLDBCLOBLOCATOR:c.SQL_C_DBCLOB_LOCATOR:c.long:c.reference
:row.:c.SQLDECIMAL :c.-           :c.unsigned char    :c.pointer to string
:row.:c.SQLDOUBLE  :c.SQL_C_DOUBLE:c.double           :c.
:row.:c.SQLINTEGER :c.SQL_C_LONG  :c.long             :c.
:row.:c.SQLNUMERIC :c.-           :c.unsigned char    :c.pointer to string
:row.:c.SQLREAL    :c.SQL_C_FLOAT :c.float            :c.
:row.:c.SQLSCHAR   :c.SQL_C_TINYINT:c.signed char     :c.
:row.:c.SQLSHORT   :c.SQL_C_SHORT :c.short            :c.
:row.:c.SQLSMALLINT:c.SQL_C_SHORT :c.short            :c.
:row.:c.SQLTIME    :c.-           :c.unsigned char    :c.pointer to string
:row.:c.SQLTIMESTAMP:c.-          :c.unsigned char    :c.pointer to string
:row.:c.SQLTINYINT :c.SQL_C_TINYINT:c.signed char     :c.
:row.
:row.:c.***SQL native***:c.identifier:c.sub-entries   :c.***comment***
:row.:c.SQLDATE    :c.SQL_C_DATE  :c.DATE_STRUCT      :c.date structure
:row.:c.           :c.            :c.:hp1.year:ehp1.  :c.:hp1.year:ehp1.
:row.:c.           :c.            :c.:hp1.month:ehp1. :c.:hp1.month:ehp1.
:row.:c.           :c.            :c.:hp1.day:ehp1.   :c.:hp1.day:ehp1.
:row.:c.SQLTIME    :c.SQL_C_TIME  :c.TIME_STRUCT      :c.time structure
:row.:c.           :c.            :c.:hp1.hour:ehp1.  :c.:hp1.hour:ehp1.
:row.:c.           :c.            :c.:hp1.minute:ehp1.:c.:hp1.minute:ehp1.
:row.:c.           :c.            :c.:hp1.second:ehp1.:c.:hp1.second:ehp1.
:row.:c.SQLTIMESTAMP:c.SQL_C_TIMESTAMP:c.TIMESTAMP_STRUCT:c.time stamp
:row.:c.           :c.            :c.:hp1.year:ehp1.  :c.:hp1.year:ehp1.
:row.:c.           :c.            :c.:hp1.month:ehp1. :c.:hp1.month:ehp1.
:row.:c.           :c.            :c.:hp1.day:ehp1.   :c.:hp1.day:ehp1.
:row.:c.           :c.            :c.:hp1.hour:ehp1.  :c.:hp1.hour:ehp1.
:row.:c.           :c.            :c.:hp1.minute:ehp1.:c.:hp1.minute:ehp1.
:row.:c.           :c.            :c.:hp1.second:ehp1.:c.:hp1.second:ehp1.
:row.:c.           :c.            :c.:hp1.fraction:ehp1.:c.:hp1.???:ehp1.
:row.
:row.:c.***SQL***  :c.Handle/Pointer:c.'C'            :c.***comment***
:row.:c.SQLHDBC    :c.HDBC, LPDBC :c.DBC              :c.CLI database context
:row.:c.SQLHDESC   :c.HDESC, LPDESC:c.DESC            :c.CLI descriptor
:row.:c.SQLHENV    :c.HENV, LPENV :c.ENV              :c.CLI environment
:row.:c.SQLHSTMT   :c.HSTMT, LPSTMT:c.STMT            :c.CLI statement
:etable.

:note.
.br
:hp1.BLOB:ehp1. stands for :hp1.binary large object block:ehp1..
.br
:hp1.CLOB:ehp1. stands for :hp1.character large object block:ehp1..

.*------------------------------------------------------------------------------
.* 'CLI Function Calls'
.*------------------------------------------------------------------------------
:h1 id=cli_function_calls clear.CLI Function Calls
:p.The following chapters and pages deal with the functions provided by this
package. For a better overview have a look at the lists.

:p.:hp2.Catalogue (Tables, Columns, etc.):ehp2.
:lm margin=5.:ul.
:li.:link reftype=hd refid=cli_SQLColumnPrivileges.SQLColumnPrivileges:elink.
:li.:link reftype=hd refid=cli_SQLColumns.SQLColumns:elink.
:li.:link reftype=hd refid=cli_SQLForeignKeys.SQLForeignKeys:elink.
:li.:link reftype=hd refid=cli_SQLPrimaryKeys.SQLPrimaryKeys:elink.
:li.:link reftype=hd refid=cli_SQLProcedureColumns.SQLProcedureColumns:elink.
:li.:link reftype=hd refid=cli_SQLProcedures.SQLProcedures:elink.
:li.:link reftype=hd refid=cli_SQLSpecialColumns.SQLSpecialColumns:elink.
:li.:link reftype=hd refid=cli_SQLStatistics.SQLStatistics:elink.
:li.:link reftype=hd refid=cli_SQLTablePrivileges.SQLTablePrivileges:elink.
:li.:link reftype=hd refid=cli_SQLTables.SQLTables:elink.
:eul.:lm margin=1.

:p.:hp2.Connection to Database:ehp2.
:lm margin=5.:ul.
:li.:link reftype=hd refid=cli_SQLAllocConnect.SQLAllocConnect:elink.
:li.:link reftype=hd refid=cli_SQLAllocEnv.SQLAllocEnv:elink.
:li.:link reftype=hd refid=cli_SQLBrowseConnect.SQLBrowseConnect:elink.
:li.:link reftype=hd refid=cli_SQLConnect.SQLConnect:elink.
:li.:link reftype=hd refid=cli_SQLDisconnect.SQLDisconnect:elink.
:li.:link reftype=hd refid=cli_SQLDriverConnect.SQLDriverConnect:elink.
:li.:link reftype=hd refid=cli_SQLFreeConnect.SQLFreeConnect:elink.
:li.:link reftype=hd refid=cli_SQLFreeEnv.SQLFreeEnv:elink.
:eul.:lm margin=1.

:p.:hp2.Execution of SQL Statements:ehp2.
:lm margin=5.:ul.
:li.:link reftype=hd refid=cli_SQLCancel.SQLCancel:elink.
:li.:link reftype=hd refid=cli_SQLExecDirect.SQLExecDirect:elink.
:li.:link reftype=hd refid=cli_SQLExecute.SQLExecute:elink.
:li.:link reftype=hd refid=cli_SQLNativeSql.SQLNativeSql:elink.
:li.:link reftype=hd refid=cli_SQLParamData.SQLParamData:elink.
:li.:link reftype=hd refid=cli_SQLPutData.SQLPutData:elink.
:eul.:lm margin=1.

:p.:hp2.Information about CLI:ehp2.
:lm margin=5.:ul.
:li.:link reftype=hd refid=cli_SQLGetInfo.SQLGetInfo:elink.
:li.:link reftype=hd refid=cli_SQLGetTypeInfo.SQLGetTypeInfo:elink.
:eul.:lm margin=1.

:p.:hp2.Options:ehp2.
:lm margin=5.:ul.
:li.:link reftype=hd refid=cli_SQLGetConnectOption.SQLGetConnectOption:elink.
:li.:link reftype=hd refid=cli_SQLGetStmtOption.SQLGetStmtOption:elink.
:li.:link reftype=hd refid=cli_SQLSetConnectOption.SQLSetConnectOption:elink.
:li.:link reftype=hd refid=cli_SQLSetStmtOption.SQLSetStmtOption:elink.
:eul.:lm margin=1.

:p.:hp2.Preparation of SQL Statements:ehp2.
:lm margin=5.:ul.
:li.:link reftype=hd refid=cli_SQLAllocStmt.SQLAllocStmt:elink.
:li.:link reftype=hd refid=cli_SQLDescribeParam.SQLDescribeParam:elink.
:li.:link reftype=hd refid=cli_SQLFreeStmt.SQLFreeStmt:elink.
:li.:link reftype=hd refid=cli_SQLGetCursorName.SQLGetCursorName:elink.
:li.:link reftype=hd refid=cli_SQLNumParams.SQLNumParams:elink.
:li.:link reftype=hd refid=cli_SQLParamOptions.SQLParamOptions:elink.
:li.:link reftype=hd refid=cli_SQLPrepare.SQLPrepare:elink.
:li.:link reftype=hd refid=cli_SQLSetCursorName.SQLSetCursorName:elink.
:li.:link reftype=hd refid=cli_SQLSetParam.SQLSetParam:elink.
:li.:link reftype=hd refid=cli_SQLSetScrollOptions.SQLSetScrollOptions:elink.
:eul.:lm margin=1.

:p.:hp2.Results of a SQL Statement:ehp2.
:lm margin=5.:ul.
:li.:link reftype=hd refid=cli_SQLBindCol.SQLBindCol:elink.
:li.:link reftype=hd refid=cli_SQLColAttributes.SQLColAttributes:elink.
:li.:link reftype=hd refid=cli_SQLDescribeCol.SQLDescribeCol:elink.
:li.:link reftype=hd refid=cli_SQLError.SQLError:elink.
:li.:link reftype=hd refid=cli_SQLExtendedFetch.SQLExtendedFetch:elink.
:li.:link reftype=hd refid=cli_SQLFetch.SQLFetch:elink.
:li.:link reftype=hd refid=cli_SQLGetData.SQLGetData:elink.
:li.:link reftype=hd refid=cli_SQLMoreResults.SQLMoreResults:elink.
:li.:link reftype=hd refid=cli_SQLNumResultCols.SQLNumResultCols:elink.
:li.:link reftype=hd refid=cli_SQLRowCount.SQLRowCount:elink.
:li.:link reftype=hd refid=cli_SQLSetPos.SQLSetPos:elink.
:eul.:lm margin=1.

:p.:hp2.Transaction Handling:ehp2.
:lm margin=5.:ul.
:li.:link reftype=hd refid=cli_SQLTransact.SQLTransact:elink.
:eul.:lm margin=1.

:p.:hp2.Other calls (portability, compatibility):ehp2.
:lm margin=5.:ul.
:li.:link reftype=hd refid=cli_SQLAllocHandle.SQLAllocHandle:elink.
:li.:link reftype=hd refid=cli_SQLBindParam.SQLBindParam:elink.
:li.:link reftype=hd refid=cli_SQLCloseCursor.SQLCloseCursor:elink.
:li.:link reftype=hd refid=cli_SQLCopyDesc.SQLCopyDesc:elink.
:li.:link reftype=hd refid=cli_SQLEndTran.SQLEndTran:elink.
:li.:link reftype=hd refid=cli_SQLFreeHandle.SQLFreeHandle:elink.
:li.:link reftype=hd refid=cli_SQLGetCol.SQLGetCol:elink.
:li.:link reftype=hd refid=cli_SQLGetConnectAttr.SQLGetConnectAttr:elink.
:li.:link reftype=hd refid=cli_SQLGetDescField.SQLGetDescField:elink.
:li.:link reftype=hd refid=cli_SQLGetDescRec.SQLGetDescRec:elink.
:li.:link reftype=hd refid=cli_SQLGetDiagField.SQLGetDiagField:elink.
:li.:link reftype=hd refid=cli_SQLGetDiagRec.SQLGetDiagRec:elink.
:li.:link reftype=hd refid=cli_SQLGetEnvAttr.SQLGetEnvAttr:elink.
:li.:link reftype=hd refid=cli_SQLGetStmtAttr.SQLGetStmtAttr:elink.
:li.:link reftype=hd refid=cli_SQLLanguages.SQLLanguages:elink.
:li.:link reftype=hd refid=cli_SQLReleaseEnv.SQLReleaseEnv:elink.
:li.:link reftype=hd refid=cli_SQLServerInfo.SQLServerInfo:elink.
:li.:link reftype=hd refid=cli_SQLSetDescField.SQLSetDescField:elink.
:li.:link reftype=hd refid=cli_SQLSetDescRec.SQLSetDescRec:elink.
:li.:link reftype=hd refid=cli_SQLSetEnvAttr.SQLSetEnvAttr:elink.
:li.:link reftype=hd refid=cli_SQLSetStmtAttr.SQLSetStmtAttr:elink.
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'SQLAllocConnect'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLAllocConnect clear.SQLAllocConnect
:xmp.
  RETCODE SQL_API SQLAllocConnect(
                               LPENV               lpenv,
                               HDBC FAR           *phdbc
                                 );
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpenv:ehp1. - handle to CLI environment block
:li.:hp1.phdbc:ehp1. - pointer to handle for database context block
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.S1001  :c.memory allocation error
:row.:c.                     :c.S1009  :c.invalid pointer :hp1.phdbc:ehp1.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid pointer :hp1.lpenv:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.context successfully allocated
:etable.

:p.The call provides the allocation of a database context structure, that is
used for database connection and transactions. It takes the handle returned
by :hp1.:link reftype=hd refid=cli_SQLAllocEnv.SQLAllocEnv():elink.:ehp1. as
input parameter.

.*------------------------------------------------------------------------------
.*   'SQLAllocEnv'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLAllocEnv clear.SQLAllocEnv
:xmp.
  RETCODE SQL_API SQLAllocEnv( SQLHENV FAR   *phenv
                             );
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.phenv:ehp1. - pointer to handle for environment block
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.-      :c.internal error (memory problems?)
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid pointer :hp1.phenv:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.environment successfully allocated
:etable.

:p.This function has to be called at start of the program in order to create a
environment where the CLI could work. :hp1.phenv:ehp1. has to point to the
variable used as handle to the environment block.

:note.
There is no error message (see :hp2.SQLError:ehp2.) available.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLAllocHandle clear.SQLAllocHandle
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLAllocStmt'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLAllocStmt clear.SQLAllocStmt
:xmp.
  RETCODE SQL_API SQLAllocStmt(
          LPDBC   lpdbc,
          HSTMT FAR *phstmt);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpdbc:ehp1. handle for database context
:li.:hp1.phstmt:ehp1. pointer to variable storing statement handle
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.S1001  :c.memory allocation failure
:row.:c.                     :c.S1009  :c.invalid pointer :hp1.phstmt:ehp1.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpdbc:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.statment handle created successfully
:etable.

:p.Allocation of a statement handle, which is used for database interactions
(queries, insertions, deletes, etc.). This function requires an open database
context handle. After the last interaction and before freeing the database
context, all allocated statement handles have to be closed via
:link reftype=hd refid=cli_SQLFreeStmt.SQLFreeStmt():elink..

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLBindCol clear.SQLBindCol
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLBindParam clear.SQLBindParam
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLBrowseConnect clear.SQLBrowseConnect
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLCancel clear.SQLCancel
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLCloseCursor clear.SQLCloseCursor
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLColAttributes clear.SQLColAttributes
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLColumnPrivileges clear.SQLColumnPrivileges
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLColumns clear.SQLColumns
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLConnect'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLConnect clear.SQLConnect
:xmp.
  RETCODE SQL_API SQLConnect(  LPDBC               lpdbc,
                               UCHAR FAR          *szDSN,
                               SWORD               cbDSN,
                               UCHAR FAR          *szUID,
                               SWORD               cbUID,
                               UCHAR FAR          *szAuthStr,
                               SWORD               cbAuthStr
                            );
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpdbc:ehp1. - handle to already allocated database context
:li.:hp1.szDSN:ehp1. - pointer to string containing database source (table)
:li.:hp1.cbDSN:ehp1. - size of string :hp1.szDSN:ehp1. or :hp2.SQL_NTS:ehp2.
if string is \0 (NUL) terminated
:li.:hp1.szUID:ehp1. - pointer to string containing user identifier (user name)
for database access
:li.:hp1.cbUID:ehp1. - size of string :hp1.szUID:ehp1. or :hp2.SQL_NTS:ehp2.
if string is \0 (NUL) terminated
:li.:hp1.szAuthStr:ehp1. - pointer to string containing password for database
access
:li.:hp1.cbAuthStr:ehp1. - size of string :hp1.szAuthStr:ehp1. or
:hp2.SQL_NTS:ehp2. if string is \0 (NUL) terminated
:eul.:lm margin=1.

:note.
.br
This special implementation for :hp4.mSQL:ehp4. may have a different use of
:hp1.szDSN:ehp1. as known by other CLIs or ODBC. You may specify :hp1.user
name:ehp1., :hp1.database name:ehp1. and :hp1.host (system name or IP):ehp1.
within this entry. Examples&colon.
:xmp.
  szDSN = <database name>                        "sample"
          <user name>.<database name>            "kim.sample"
          <database name>@<host>                 "sample@minerva.edu.au"
          <user name>.<database name>@<host>     "kim.sample@127.0.0.1"
:exmp.
:note.
.br
If a :hp1.host:ehp1. isn't specified, a connection to the server on the local
machine (:hp1.localhost:ehp1.) is tried to be established.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.08001  :c.can't connect to server
:row.:c.                     :c.08002  :c.connection already established
:row.:c.                     :c.08004  :c.can't connect to database
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid database context handle
:row.:c.SQL_SUCCESS          :c.-      :c.connection established
:etable.

:p.This function has to be called after
:link reftype=hd refid=cli_SQLAllocConnect.SQLAllocConnect():elink.. It tries
to connect to a database source (:hp1.mSQL:ehp1.&colon. host/database). After
successful connection database activities may start.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLCopyDesc clear.SQLCopyDesc
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLDescribeCol clear.SQLDescribeCol
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLDescribeParam clear.SQLDescribeParam
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLDisconnect'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLDisconnect clear.SQLDisconnect
:xmp.
  RETCODE SQL_API SQLDisconnect(
                               LPDBC               lpdbc
                               );
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpdbc:ehp1. - handle to database context
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.08003  :c.no connection established
:row.:c.                     :c.25000  :c.transaction must be ended first
:row.:c.                     :c.58004  :c.can't find path to database
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle to database context
:row.:c.SQL_SUCCESS          :c.-      :c.connection successfully closed
:etable.

:p.The purpose of this routine is to close an open connection established by
:link reftype=hd refid=cli_SQLBrowseConnect.SQLBrowseConnect():elink.,
:link reftype=hd refid=cli_SQLConnect.SQLConnect():elink. or
:link reftype=hd refid=cli_SQLDriverConnect.SQLDriverConnect():elink.. After
successful close there can't be any database activities. Before closing, all
open transactions have to be ended (see
:link reftype=hd refid=cli_SQLCancel.SQLCancel():elink. or
:link reftype=hd refid=cli_SQLTransact.SQLTransact():elink.).

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLDriverConnect clear.SQLDriverConnect
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLEndTran clear.SQLEndTran
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLError'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLError clear.SQLError
:xmp.
  RETCODE SQL_API SQLError(
          LPENV   lpenv,
          LPDBC   lpdbc,
          LPSTMT  lpstmt,
          UCHAR FAR *szSqlState,
          SDWORD FAR *pfNativeError,
          UCHAR FAR *szErrorMsg,
          SWORD   cbErrorMsgMax,
          SWORD FAR *pcbErrorMsg);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpenv:ehp1. - handle for environment block
:li.:hp1.lpdbc:ehp1. - handle for database context block
:li.:hp1.lpstmt:ehp1. - handle for current statement structure
:li.:hp1.szSqlState:ehp1. - pointer to buffer for SQL error state code
:li.:hp1.pfNativeError:ehp1. - pointer to buffer for internal error code
:li.:hp1.szErrorMsg:ehp1. - pointer to string for storing error message text
:li.:hp1.cgErrorMsgMax:ehp1. - maximum length for :hp1.szErrorMsg:ehp1.
:li.:hp1.pcbErrorMsg:ehp1. - result length for :hp1.szErrorMsg:ehp1.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid :hp1.lpenv:ehp1., :hp1.lpdbc:ehp1. and :hp1.lpstmt:ehp1.
:row.:c.SQL_NO_DATA_FOUND    :c.-      :c.no more data or no previous error
:row.:c.SQL_SUCCESS          :c.-      :c.data available
:etable.

:p.Returns a message text for a previously occurred error. If there was no
previous error, :hp2.SQL_NO_DATA_FOUND:ehp2. is returned. After successful
return of this function, all internal states are resetted.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLExecDirect clear.SQLExecDirect
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLExecute'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLExecute clear.SQLExecute
:xmp.
  RETCODE SQL_API SQLExecute(
          LPSTMT  lpstmt);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statment
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.08001  :c.cannot execute
:row.:c.                     :c.40003  :c.no connection to database
:row.:c.                     :c.S1010  :c.no prepared statement found
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.execution ended successfully
:etable.

:p.After preparation of a SQL statement with :link reftype=hd
refid=cli_SQLPrepare.SQLPrepare():elink. this function executes the statement.
Afterwards, on insertion or deletion :link reftype=hd
refid=cli_SQLRowCount.SQLRowCount():elink. returns the number of rows affected
by the operation, on selection :link reftype=hd
refid=cli_SQLNumResultCols.SQLNumResultCols():elink. shows the number of
selected rows, that can be queried by :link reftype=hd
refid=cli_SQLDescribeCol.SQLDescribeCol():elink., :link reftype=hd
refid=cli_SQLBindCol.SQLBindCol():elink. and :link reftype=hd
refid=cli_SQLFetch.SQLFetch():elink..

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLExtendedFetch clear.SQLExtendedFetch
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLFetch clear.SQLFetch
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLForeignKeys clear.SQLForeignKeys
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLFreeConnect'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLFreeConnect clear.SQLFreeConnect
:xmp.
  RETCODE SQL_API SQLFreeConnect(
                               LPDBC               lpdbc
                                );
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpdbc:ehp1. - handle to database context block
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.S1010  :c.connection has to be closed first
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid pointer :hp1.lpdbc:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.context successfully freed
:etable.

:p.After database operation this call has to be used to remove the database
context block. After successful removement :hp1.:link reftype=hd
refid=cli_SQLFreeEnv.SQLFreeEnv():elink.:ehp1. can be called.

.*------------------------------------------------------------------------------
.*   'SQLFreeEnv'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLFreeEnv clear.SQLFreeEnv
:xmp.
  RETCODE SQL_API SQLFreeEnv(  LPENV               lpenv
                            );
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpenv:ehp1. - handle for environment block
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.S1010  :c.connections have to be closed first
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid pointer :hp1.lpenv:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.environment successfully freed
:etable.

:p.This function has to be called at the end of the program to free the CLI
environment block. After successful removement of the environment block, the
variable used for handle storage (input parameter :hp1.lpenv:ehp1.) has to be
invalidated.

:note.
After successfully freeing the CLI environment block, no error message can be
obtained through :hp2.SQLError:ehp2..

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLFreeHandle clear.SQLFreeHandle
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLFreeStmt'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLFreeStmt clear.SQLFreeStmt
:xmp.
  RETCODE SQL_API SQLFreeStmt(
          LPSTMT  lpstmt,
          UWORD   fOption);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:li.:hp1.fOption:ehp1. - option code&colon.:lm margin=10.
:li.:hp2.SQL_CLOSE:ehp2. - close statement (cursor)
:li.:hp2.SQL_DROP:ehp2. - close statement (cursor) and free handle
:li.:hp2.SQL_UNBIND:ehp2. - unbind columns, keep statement
:li.:hp2.SQL_RESET_PARAMS:ehp2. - reset parameters on bind-columns
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.S1092  :c.invalid option :hp1.fOption:ehp1.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.operation succeeded
:etable.

:p.Depending on the option code :hp1.fOption:ehp1. a statement handle allocated
with :link reftype=hd refid=cli_SQLAllocStmt.SQLAllocStmt():elink. is reseted
in parts or total, or is freed.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetCol clear.SQLGetCol
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetConnectAttr clear.SQLGetConnectAttr
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetConnectOption clear.SQLGetConnectOption
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetCursorName clear.SQLGetCursorName
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetData clear.SQLGetData
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetDescField clear.SQLGetDescField
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetDescRec clear.SQLGetDescRec
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetDiagField clear.SQLGetDiagField
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetDiagRec clear.SQLGetDiagRec
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetEnvAttr clear.SQLGetEnvAttr
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetInfo clear.SQLGetInfo
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetStmtAttr clear.SQLGetStmtAttr
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetStmtOption clear.SQLGetStmtOption
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetTypeInfo clear.SQLGetTypeInfo
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLLanguages clear.SQLLanguages
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLMoreResults clear.SQLMoreResults
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLNativeSql clear.SQLNativeSql
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLNumParams clear.SQLNumParams
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLNumResultCols clear.SQLNumResultCols
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLParamData clear.SQLParamData
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLParamOptions clear.SQLParamOptions
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLPrepare'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLPrepare clear.SQLPrepare
:xmp.
  RETCODE SQL_API SQLPrepare(
          LPSTMT  lpstmt,
          UCHAR FAR *szSqlStr,
          SDWORD  cbSqlStr);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:li.:hp1.sqSqlStr:ehp1. - SQL statement to be prepared
:li.:hp1.cbSqlStr:ehp1. - size of string :hp1.szSqlStr:ehp1. or
:hp2.SQL_NTS:ehp2. if string is \0 (NUL) terminated
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.24000  :c.statement handle already in use
:row.:c.                     :c.S1001  :c.memory allocation error
:row.:c.                     :c.S1009  :c.invalid pointer :hp1.szSqlStr:ehp1.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.preparation successfully
:etable.

:p.Prepares a SQL statement for execution with :link reftype=hd
refid=cli_SQLExecute.SQLExecute():elink..

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLPrimaryKeys clear.SQLPrimaryKeys
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLProcedureColumns clear.SQLProcedureColumns
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLProcedures clear.SQLProcedures
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLPutData clear.SQLPutData
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLReleaseEnv clear.SQLReleaseEnv
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLRowCount clear.SQLRowCount
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLServerInfo clear.SQLServerInfo
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetConnectOption clear.SQLSetConnectOption
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetCursorName clear.SQLSetCursorName
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetDescField clear.SQLSetDescField
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetDescRec clear.SQLSetDescRec
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetEnvAttr clear.SQLSetEnvAttr
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetParam clear.SQLSetParam
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetPos clear.SQLSetPos
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetScrollOptions clear.SQLSetScrollOptions
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetStmtAttr clear.SQLSetStmtAttr
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetStmtOption clear.SQLSetStmtOption
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSpecialColumns clear.SQLSpecialColumns
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLStatistics clear.SQLStatistics
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLTablePrivileges clear.SQLTablePrivileges
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLTables clear.SQLTables
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLTransact clear.SQLTransact
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.* 'CLI Function Return Codes'
.*------------------------------------------------------------------------------
:h1 id=cli_function_return_codes clear.CLI Function Return Codes
:p.Each Call-Level Interface (CLI) function returns a result code, that
shows success or failure of an operation, or if there is additional information
code to be processed.

:table cols='25 54'.
:row.:c.SQL_SUCCESS           :c.operation ended successfully
:row.:c.SQL_SUCCESS_WITH_INFO :c.same, but there is additional information
:row.:c.SQL_NEED_DATA         :c.operation aborted due to lack of data
:row.:c.SQL_NO_DATA           :c.operation failed due to lack of data
:row.:c.SQL_NO_DATA_FOUND     :c.there is no data found
:row.:c.SQL_ERROR             :c.operation failed, see :link reftype=hd refid=cli_SQLError.SQLError:elink.
:row.:c.SQL_INVALID_HANDLE    :c.invalid handle (
:link reftype=hd refid=sql_data_types.HDBC:elink.,
:link reftype=hd refid=sql_data_types.HDESC:elink.,
:link reftype=hd refid=sql_data_types.HENV:elink.,
:link reftype=hd refid=sql_data_types.HSTMT:elink.
)
:etable.

:note.
The definition :hp2.SQL_SUCCEEDED(:ehp2.:hp4.x:ehp4.:hp2.):ehp2. can be used to
detect whether :hp4.x:ehp4. specifies a return code of a successful operation
or not.

:p.:hp2.Internal error messages and codes:ehp2. (set at :hp1.SQL_ERROR:ehp1.)
:table cols='25 54'.
:row.:c.Code       :c.Message
:row.:c.S1001      :c.Internal error (memory allocation failed)
:row.:c.S1009      :c.Invalid pointer for handle storage
:row.:c.S1010      :c.Invalid sequence of function calls
:etable.

.*------------------------------------------------------------------------------
.* 'Author's Details'
.*------------------------------------------------------------------------------
:h1 id=author clear.Author's Details
:p.The Call-Level Interface (CLI) for mSQL (OS/2) was written by&colon.
:xmp.
  Dirk Ohme
  Programmer at transtec AG
  T&ue.bingen, Germany

  E-mail:  Dirk.Ohme@transtec.de
  Fidonet: 2&colon.246/2001.9@fidonet
:exmp.

.*------------------------------------------------------------------------------
.* 'Archive Location'
.*------------------------------------------------------------------------------
:h1 id=archive clear.Archive Location
:p.The primary site for this product is&colon.
:xmp.
  Host:   rzsco.fh-albsig.de (141.87.110.2)
  URL:    http&colon.//rzsco.fh-albsig.de/~ohme
  Files:  FILES/msql*.lsm (description)
          FILES/msql*.zip (Zip 2.0.1 archive, Source &amp. Binaries)
  Note:   OS/2 port
:exmp.
:p.It can be also be found at&colon.
:xmp.
  WWW:    http&colon.//Hughes.com.au/
  ftp:    ftp&colon.//ftp.Bond.edu.au/pub/Minerva/msql/Contrib/msql*-os2.lsm
          ftp&colon.//ftp.Bond.edu.au/pub/Minerva/msql/Contrib/msql*-os2.zip
:exmp.

.*------------------------------------------------------------------------------
.* end of document
.*------------------------------------------------------------------------------
:euserdoc.
.*==============================================================================
