@echo off
REM test.cmd
REM
REM testing script for OS/2

set BINDIR=..\..\bin
set DATABASE=test
REM set MINERVA_DEBUG=access:cache:error:key:malloc:mmap:proctitle:query:trace:general
REM set MINERVA_DEBUG=access:cache:error:key:proctitle:query:trace:general
REM set MINERVA_DEBUG=malloc:mmap:query
REM set MINERVA_DEBUG=
set MINERVA_DEBUG=

echo automated testing tool for mSQL for OS/2

echo.
echo removing old stuff
if exist server.log del server.log
if exist server.out del server.out
if exist *.srv del *.srv

echo.
echo starting server
start /c /b /fs %BINDIR%\msqld 2>&1 > server.out 2>&1
set MINERVA_DEBUG=
echo please wait a moment (5..10 sec) 'til the server is up - then press ENTER
pause

echo.
echo testing 'common':
for %%a in (common_1) do call test_sub %%a

echo.
echo testing 'heavy duty':
for %%a in (heavy_duty_1) do call test_sub %%a

echo.
echo testing 'joins':
for %%a in (joins_1 joins_2) do call test_sub %%a

echo.
echo testing 'not null':
for %%a in (not_null_1) do call test_sub %%a

echo.
echo testing 'primary key':
for %%a in (primary_key_1 primary_key_2 primary_key_3 primary_key_4 primary_key_5 primary_key_6) do call test_sub %%a

echo.
echo testing 'real num':
for %%a in (real_num_1) do call test_sub %%a

echo.
echo testing 'missing table bug':
echo.                                            >> server.log
echo [missing_table]                             >> server.log
echo. | time | find /n /v "@@@" | find "[1]"     >> server.log
echo   * init
copy /b %BINDIR%\msql.dll .
echo.                                            >  missing_table.out
echo   * create data
for %%a in (1 2 3 4 5 6 7 8) do echo create table test%%a (foo char(1))\g\q | %BINDIR%\msql %DATABASE% 2>&1 >>NUL && echo   table test%%a created >> missing_table.out
echo   * verify data
for %%a in (1 2 3 4 5 6 7 8) do %BINDIR%\relshow %DATABASE% test%%a 2>&1 >>NUL && echo   table test%%a loaded >> missing_table.out
echo   * create exception
%BINDIR%\relshow %DATABASE% test99 2>&1         >> missing_table.out
echo   * check data
for %%a in (1 2 3 4 5 6 7 8) do %BINDIR%\relshow %DATABASE% test%%a 2>&1 >> missing_table.out
echo   * drop data
for %%a in (1 2 3 4 5 6 7 8) do echo drop table test%%a\g\q | %BINDIR%\msql %DATABASE% 2>&1 >>NUL && echo   table test%%a dropped >> missing_table.out
del msql.dll
echo   * done.
echo. | time | find /n /v "@@@" | find "[1]"     >> server.log

echo.
echo stopping server
%BINDIR%\msqladm shutdown 2>&1 >> NUL

echo.
echo starting compare
pause
comp *.cmp *.out

echo.
echo done.

