;;;
;;; Postgres/CommonLISP interface
;;;
;;; Copyright (c) 1986 Regents of the University of California
;;; 
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;; 
;;; $Author: picasso $
;;; $Source: RCS/defaults.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/23 13:17:57 $
;;;

(in-package 'libpq :use '(lisp excl))

;;;
;;; Declare default values.
;;; 

(defconstant *default-server-hostname* "postgres"
  "The host where backend is running")

(defconstant *default-port* "4321"
  "The default port for communication between the frontend and the backend")

(defconstant *default-tty*  "/dev/null"
  "The tty for backend debugging message output")

(defconstant *default-option* ""
  "Options, not used at this moment")

(defconstant error-msg-length 80
  "The length of the error message returned by the backend")

(defconstant portal-name-length 16
  "The length of a portal name")

(defconstant command-length 20
  "The length of a query command returned from the POSTGRES backend")

(defconstant remark-length 80
  "The length of a remark returned from the POSTGRES backend")

