#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************


CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine Svalue (N, X, F, B, C, D, T, INTRV, S, IFLAG)


******************************************************************
*                                                                *
*    Subroutine Spline_Value                                     *
*                                                                *
*  Evaluate spline S at T using coefficients from SPCOEF.        *
*                                                                *
*  Input parameters:                                             *
*    N,X,F,B,C,D are the same as in SPCOEF.                      *
*    T = point where spline is to be evaluated.                  *
*                                                                *
*  Output parameters:                                            *
*    INTRV = index satisfying  x(intrv) .le. t .lt. x(intrv+1).  *
*    S = value of spline at t.                                   *
*    IFLAG = 0  normal return;                                   *
*          =-1  n .le. 1;                                        *
*          = 1  t .lt. x(1);                                     *
*          = 2  t .gt. x(n).                                     *
*                                                                *
******************************************************************


        Real    X(N),F(N),B(N),C(N),D(N),T,S
        Integer N,INTRV,IFLAG

        Real DT

*       (* Search for correct interval for T. *)

        IF ((INTRV .LT. 1) .OR. (INTRV .GE. N)) INTRV = 1
        IF (N .LE. 1) GOTO 30
        IF (T .LT. X(INTRV)) INTRV=1
   10   IF ((T .LT. X(INTRV+1)) .OR. (INTRV .EQ. N-1)) GOTO 20
        INTRV = INTRV + 1
        GOTO 10
   20   IFLAG = 0
        IF (T .LT. X(1)) IFLAG = 1
        IF (T .GT. X(N)) IFLAG = 2

*       (* Evaluate cubic polynomial on (X(INTRV) , X(INTRV+1)). *)
 
        DT = T-X(INTRV)
        S = F(INTRV)+DT*(B(INTRV)+DT*(C(INTRV)+DT*D(INTRV)))

        RETURN

   30   IFLAG = -1

        RETURN
        END
