


BASIC(1)            UNIX Programmer's Manual             BASIC(1)




     basic - `Basic' language interpreter

SYNOPSIS
     basic [ -e -x -n file ]

DESCRIPTION
     Basic is an interpreter for the Basic language. See below
     for current commands recognised. If a file is given then
     that file is loaded up into core and run without any
     interaction. This can be used for games etc. which use a
     small calling program which is set user-id. All commands are
     only recognised in lower case. A line editor is invoked for
     all input from the terminal.  To get characters less than
     space into a line use the construct \n \a etc. which will
     get cntrl-n and cntrl-a into the line.

     FLAGS

     -e use the in built editor for line input. Even when default
           mode is for no editor.

     -x don't use the editor ever. Use the terminal driver for
           all editing and input.

     -n where n is any number between 0 and 9 defines the number
           of file buffers allocated at start up.

     COMMANDS

     Standard Dartmouth Basic Commands:-

     end
           This terminates the execution of a program and returns
           to command level.

     run { l }
           This will execute a program, if an optional line
           number is given then the program is run from that
           line. All variables are cleared and all files are
           closed.

     goto l
           This command will transfer control to the specified
           line number

     let x = EXP
           This command is used to introduce an assignment. If a
           command is not found on a line then a implied let is
           assumed.





Printed 3/10/88                                                 1






BASIC(1)            UNIX Programmer's Manual             BASIC(1)



     list
           the whole file

     list 1-2
           lines 1 to 2

     list -1
           lines up to 1

     list 1
           line 1 list 1-

     line 1 onwards
           This command will list any number of lines of text
           onto the terminal. The start and last line can be
           specified as can to a specified line and from a speci-
           fied line.

     print or '?'

     print #f
           This command will print out all of it's parameters,
           they have to be separated by commas or semi-colons, if
           a comma is used then the print head is moved to the
           next tab position (16 places ). If a file descriptor
           is given then output is to the given file.

     rem or `'
           A comment statement, is ignored totally by the program
           during execution.

     stop
           Stops the execution of the program and returns to com-
           mand level. Similar to 'end' but prints a message. A
           program can also be 'cont'inued after a stop.

     for x = EXP to EXP { step EXP }
           Will start execution of a for loop. It will take the
           two limits and an optional step argument. The loop is
           always executed once.

     next { x { , y } }
           End of the for loop, if the terminal conditions are
           met then execution continues from the next statement
           otherwise return to end of the corresponding for
           statement. The next does not need a parameter if this
           is the case the most recently activated loop is used.
           If there are more than one parameter then each one is
           only checked after the completion of the inner loop.

     gosub l
           Transfer command to a line number. Save return address



Printed 3/10/88                                                 2






BASIC(1)            UNIX Programmer's Manual             BASIC(1)



           so that the program can resume execution after the
           gosub command.

     return
           Return from a subroutine ( called by gosub ).  It will
           return from the most recently activated subroutine
           call.

     read VAR { , VAR }
           Read data from the data statements contained in the
           program. An item can be a string or a variable.

     data OBJECT { , OBJECT }
           Statements that contain the data used in the read
           statements. Items are separated by commas. The data
           statement must be the only one on the line.

     restore { l }
           Restore the data pointer to the start of the file. So
           that the data can be read again. If an optional line
           number is given then the restore occurs from the start
           of that line. If no data statements are found then the
           restore is from the start of the program.

     if EXP then STATEMENT { else STATEMENT }
           The if statement if the condition is true then the
           commands after the 'then' are executed. If this is a
           line number then a goto is performed. If the condition
           is false then the statement after the else is dealt
           with in a similar manner, the else statement is an
           optinal facility.

     dim VAR(d,d,d) { , VAR(d) }
           Dimension a list of arrays ( string or arithmetic ) a
           maximum of three subscripts can be used.  All arrays
           must be dimensioned before use.

     exit , bye , quit
           Terminate the execution of the interpreter, closing
           all files.

     Extended Basic Commands

     delete l - l
           Delete a specified range of lines. If they are not
           found then no lines will be deleted.

     edit l
           Edit a given line. If the exit from the edit is via a
           cntrl-c then do not change the line.





Printed 3/10/88                                                 3






BASIC(1)            UNIX Programmer's Manual             BASIC(1)



     input { #f, }
           input "prompt";
           Input from a terminal or from a file. If the input is
           from the terminal then a prompt message can also be
           added.

     clear EXP
           Clear all variables then allocate the amount of string
           space specified by the second parameter.

     save STRINGEXP
           Save the current program to a named file.

     old STRINGEXP
           Load a program from the named file. All variables are
           cleared.

     new { EXP }
           Wipe the program from core. All files are closed and
           the interpreter is reset to its inital state. If a
           parameter is given then that is the number of file
           buffers that are allocated.

     shell
           Shell out to Unix. This is the Bourne shell. If the
           interpreter is made set userid then this is turned off
           in the shell.

     resume { l }
           Return from an error trap. If a parameter is given
           then the return is made to that line. An error trap is
           set up by the "on error goto" statement.

     random
           Randomise the random number generator. The generator
           always starts from the same place in its sequence,
           when a program is started.

     on EXP goto l { , l} on - gosub on error goto l
           This command will execute either a goto or a gosub to
           a specified line number. The linenumber is specified
           by the value of the statement and the linenumber is
           taken from the list of line numbers that is given.  If
           the error format is used, only one linenumber is
           required. This is the line where a jump is performed
           to if an error occurs.

     error EXP
           Execute the given error sequence. Useful for debugging
           of error trap routines.





Printed 3/10/88                                                 4






BASIC(1)            UNIX Programmer's Manual             BASIC(1)



     auto { l { ,l } }
           Perform auto line numbering so that a program can be
           typed in without having to bother about linenumbers.
           An optional start and increment can also be specified.

     cls
           Clear the terminals screen.

     base 0 | 1
           Specify the starting index for arrays. This can have a
           value of either zero or one.

     poke EXP,EXP
           Poke a value into a location. Unreasonable addresses
           are ignored. ( Can cause bus-errors if not using split
           i and d space.  (Not available on Vax systems).

     open STRINGEXP { for input|output|append|terminal } as EXP
           Open a file for input/ output. This command can be
           used to specify whether the file is to be read or wri-
           ten to. A file cannot be opened for writing if the
           file is already open. If the mode is terminal then it
           will believe that it is talking to a terminal. (No
           buffering. Open for reading and writing.) If the
           option is 'for output' it may be ommitted.

     close EXP
           Close a file. Releases the file descriptor and flushes
           out all stored data.

     merge STRINGEXP
           Merge two files together. If there is a line in the
           file with the same linenumber as in the program then
           that line is replaced by the new one. All other lines
           are inserted into the file.

     chain STRINGEXP
           Read in a program, then start to execute it.  All sim-
           ple variables are kept but all arrays and strings are
           cleared. The size of the string space is kept the
           same.

     def fnNAME{ ( VAR {,VAR } ) } = EXP
           Define a user defineable function.

     linput
           Identical to input but ignores seperators.

     mid$(STRINGVAL, EXP { ,EXP} ) = STRINGEXP
           Assign STRINGEXP to STRINGVAL starting at EXP1 and
           finishing at EXP2.




Printed 3/10/88                                                 5






BASIC(1)            UNIX Programmer's Manual             BASIC(1)



     cont
           Continue execution of a program that has been halted
           by a stop statement or by control-c.

     while EXP
           Start of a while loop. The loop is repeated until EXP
           is false. If EXP is false at the start then do not
           execute the loop at all. A while loop must be ter-
           minated by a wend statement.

     wend
           Terminating statement of a while loop. Only one wend
           is allowed for each while.

     repeat
           Start statement for a repeat - until loop. This type
           of loop will always be executed at least once.

     until EXP
           The terminating statement of a repeat - until loop.
           The loop terminates when EXP is true.

     String functions Available

     mid$(a$,i,j)
           Returns the part of a$ between the i'th and j'th posi-
           tions. If the second parameter is not specified then
           the string is taken between the start value and the
           end of the string.

     right$(a$,j)
           Returns the right j characters of a$.

     left$(a$,j)
           Returns the left j characters of a$.

     string$(a$,j)
           Returns a$ repeated j times.

     ermsg$(j)
           Returns the j'th error message.

     chr$(j)
           Returns the ascii character corresponding to the value
           of j.

     str$(j)
           Returns a string representation corresponding to j.
           This is similar but not the same as what can printed
           out.





Printed 3/10/88                                                 6






BASIC(1)            UNIX Programmer's Manual             BASIC(1)



     space$(j)
           Returns a string of j spaces

     get$(f)
           Returns one character from file f. If f is zero use
           the terminal. Returns a zero lenght string on cntl-c

     date$
           returns a string coresponding to the current date. (
           Same string as printed out when logging on. ).

     Maths functions Available:-

     sgn(x)
           Returns the sign of a number. It's value is 1 if
           greater than zero , zero if equal to zero. -1 if nega-
           tive.

     len(a$)
           Returns the length of string a$.

     abs(x)
           Returns the absolute value of x.

     int(x)
           than x.

     val(a$)
           Returns the value of the number specified by the
           string.

     asc(a$)
           Returns the ascii code for the first element of a$.

     instr(a$,b$,c)
           Returns the starting position that a$ is in b$, start-
           ing from the optional c'th position.

     eof(f)
           Returns true if the file specified by f has reached
           the end of the file.

     posn(f)
           Returns the current printing position in the file. If
           f is zero then it is the printing position of the ter-
           minal.

     sqrt(x)
           Returns the square root of X.

     log(x)
           Returns the natural logarithm of x.



Printed 3/10/88                                                 7






BASIC(1)            UNIX Programmer's Manual             BASIC(1)



     exp(x)
           Returns e^x. e=2.7182818..

     eval(a$)
           Evaluates a$.  e.g. eval("12") returns the value 12.

     rnd
           Returns a random number between 1 and 32767.

     rnd(x)
           If x is zero returns a random number between 0 and 1
           otherwise returns a random number between 1 and
           int(x).

     peek(x)
           Returns the value of the byte at address x.  If x is
           unreasonable then returns zero.  ( Not available on a
           VAX )

     sin(x)

     cos(x)

     atan(x)
           Trignometric functions. (May not yet be implemented).

     pi
           Returns the value of pi. = 3.141592653589...

     erl
           Returns the line number of the last error.  Zero if
           error was in immeadiate mode.

     err
           Returns the error code of the last error.

     tim
           Returns a numeric value for the number of seconds
           since 1:1:1970 i.e. the value of the Unix clock.

     Mathematical Operators:-

          The  following  mathematical  operators   are accepted.
                        ^               exponentiation
                        *               multiplication
                        /               division
                        mod             remainder
                        +               addition
                        -               subtraction

                bitwise operators:-
                   for real values non-zero is true,



Printed 3/10/88                                                 8






BASIC(1)            UNIX Programmer's Manual             BASIC(1)



                        and             bitwise and
                        or              bitwise or
                        xor             bitwise exclusive or
                        not             bitwise not

                comparison operators:-
                        <=              less than or equal
                        <>              not equal to
                        >=              greater than or equal
                        =               equal
                        >               greater than
                        <               less than

                 Assignment statements can also have the form
                   a +=  b     a -=  b     a *=  b    a /=  b
                 Which have similar meanings to C's interpretation

     EXPRESSION SYNTAX

             stringexp  ::= string | string + stringexp
             string     ::= qstring | stringvar | stringfunc
             qstrings   ::= "any char" | `any char`
                             N.B. strings with nothing after them on the
                                  line do not need the terminating quote
             stringvar  ::= numbvar$ | numbvar$[ dim1 { ,dim2 {, dim3 } } ]
             stringfunc ::= chr$(val) | mid$(stringexp, val {,val} )
                             | date$ | right$(stringexp, val)
                             | left$(stringexp, val) | ermsg$(val)
                             | str$( val) | space$(val)
                             | string$(stringexp, val) | get$( 0 | fval )

             val        ::= term | term sep val
                             | not val | - val
             term       ::= numb | valfunc | numbvr
                             | stringexp csep stringexp
             numb       ::= digit | digit digit+
                             | digit* . digit*
                             | digit* e {+ | -} digit+
                             | digit* . digit* e {+ | -} digit+
             digit      ::= 0 1 2 3 4 5 6 7 8 9
             numbvr     ::= numbvar | subsc
             numbvar    ::= lett | lett alpha+
             subsc      ::= numbvar( val {, val { ,val } } )
             sep        ::= + - * /  ^ and or xor | csep
             csep       ::= <> > < >= <= =
             valfunc    ::= sgn(val) | len(stringexp)
                             | abs(val) | val(stringexp)
                             | asc(stringexp) | eof(fval)
                             | posn( 0 | fval) | sqrt(val)
                             | instr(stringexp, val { ,val} )
                             | log(val) | exp(val) | eval(stringexp)
                             | int(val) | peek(val) | rnd



Printed 3/10/88                                                 9






BASIC(1)            UNIX Programmer's Manual             BASIC(1)



                             | rnd(val) | usrfunc | pi
                             | erl | err | tim
             usrfunc    ::=  fn/numbvar { (val { , val { , val } } ) }
             fval       ::= val with value between 1-9


DIAGNOSTICS
     When the interpreter discovers an error it will call an
     error trapping routine. The errors can be caught by the user
     program using the on-error feature. If no error trapping
     routine has been supplied a message is printed with the
     corresponding line number.


BUGS
     None yet!


AUTHOR
     Phil Cockcroft



































Printed 3/10/88                                                10



