
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

% Pretransformations:  Recognize source forms
% and transform to forms which can be compiled.
% Also transform conjunction into list form.

pretrans((Head:-Body), [PH|PB]) :-
	% Transform head according to change of 12/20 (below).
	correct_name(Head, PH),
	pretrans(Body, PB, []), !.
pretrans(Head, [PH]) :- correct_name(Head, PH).

% Addition - 4/16
% Transform list form of consult and reconsult into explicit calls to consult
% and reconsult.

% Transform a disjunction:
disjpretrans(Disj, (PX;PB)) :- 
	disjtest(Disj, A, B),
	nonvar(A), A=(X -> Y), !,
	pretrans(X, PX, ['->'|PY]),
	pretrans(Y, PY, []),
	disjpretrans(B, PB).
disjpretrans(Disj, (PA;PB)) :- 
	disjtest(Disj, A, B), !,
	pretrans(A, PA, []),
	disjpretrans(B, PB).
disjpretrans(Last, (PX;[fail])) :-
	nonvar(Last), Last=(X->Y), !,
	pretrans(X, PX, ['->'|PY]),
	pretrans(Y, PY, []).
disjpretrans(Last, PL) :-
	pretrans(Last, PL, []).
	
disjtest(Disj, A, B) :- nonvar(Disj), Disj=(A;B).

% Bug fix - 11/29/84
% Transform goal consisting of single variable to call.
% not sure if this is really semantically correct, but goals
% of this form are not handled elsewhere and C-Prolog handles
% them this way. - Wayne
pretrans(X, [CallX|Link], Link) :- var(X), !,
	correct_name(call(X), CallX).

pretrans(call(X), PX, Link) :-
	pretrans(X, PX, Link).
pretrans(not(A), [(PA;[true])|Link], Link) :-
	pretrans(A, PA, ['->',fail]).
pretrans(\+(A),  [(PA;[true])|Link], Link) :-
	pretrans(A, PA, ['->',fail]).
% Lone (X->Y) not in a disjunction:
pretrans((X -> Y), [(PX;[fail])|Link], Link) :-
	pretrans(X, PX, ['->'|PY]),
	pretrans(Y, PY, []).
pretrans((Goal,Body), PG, Link) :-
	pretrans(Goal, PG, PB),
	pretrans(Body, PB, Link).
pretrans(Disj, [PD|Link], Link) :-
	Disj=(_;_),
	disjpretrans(Disj, PD).
pretrans('\='(X,Y), [([X=Y,'->',fail];[true])|Link], Link).
% Transform is/2 into is/4 if not using option 'u'.
pretrans((V is Exp), Is4, Link) :-
	expr_nolist(Exp, NExp),
	top_expression(NExp, V, Is4, Link).

% transform list form of re/consult to explicit call
pretrans(List, Consult, Link) :-
	full_list(List),
	expand_consult(List, Consult, Link).

% Transform subgoal according to change of 12/20.
pretrans(Goal, [PG|Link], Link) :- correct_name(Goal, PG).

	% Transform an expression of the form X is Expr
	% into a series of is/4 calls.
	% Recognizes unary minus and converts all binary operators.
	% Unrecognized forms are kept in is/2.

	% Bug fix Jan. 15, 1987: does 'V is W' correctly, where V & W are vars.

	% Top level call recognizes special cases of top level.
	top_expression(Expr, X, [fail|Link], Link) :- 
		nonvar(X), \+(number(X)), !.  % X is atom or struc or list.
	top_expression(Expr, X, [(X = Expr)|Link], Link) :-
		number(Expr), !.
	top_expression(Expr, X, [(XisExpr)|Link], Link) :-
		(var(Expr); atomic(Expr)), !,
		correct_name((X is Expr), XisExpr).
	top_expression(Expr, X, Code, Link) :-
		\+(compile_options(u)), !,
		expression(Expr, X, Code, Link).
	top_expression(Expr, X, [(XisExpr)|Link], Link) :-
		compile_options(u), !,
		correct_name((X is Expr), XisExpr).

	expression(IExpr, IExpr, Link, Link) :-	var(IExpr), !.
	expression(IExpr, IExpr, Link, Link) :-	number(IExpr), !.
	expression(-(E1), OExpr, Code, Link) :- !,
		correct_name('is'(OExpr,0,'-',A1), Is4),
		expression(E1, A1, Code, [Is4|Link]).
	expression(IExpr, OExpr, Code, Link) :-
		compile_options(s),
		IExpr=..[Op, E1, E2],
		vlsi_instr(Op, LibName), !,
		Pred=..[LibName, A1, A2, OExpr],
		correct_name(Pred, CorrPred),
		expression(E1, A1, Code, L1),
		expression(E2, A2, L1, [CorrPred|Link]).
	expression(IExpr, OExpr, Code, Link) :-
		IExpr=..[Op, E1, E2], !,
		expression(E1, A1, Code, L1),
		correct_name('is'(OExpr,A1,Op,A2), Is4),
		expression(E2, A2, L1, [Is4|Link]).
	expression(IExpr, OExpr, [Is2|Link], Link) :-
		correct_name((OExpr is IExpr), Is2).

	% Bug fix May 17, 1987: recognizes [expr] correctly in expressions.

	% Transform [expr] to expr recursively:
	% This makes is/2 compatible with C-Prolog:
	expr_nolist(IExpr, IExpr) :- var(IExpr), !.
	expr_nolist(IExpr, IExpr) :- number(IExpr), !.
	expr_nolist(IExpr, IExpr) :- atomic(IExpr), !.
	expr_nolist([IExpr], OExpr) :-
		expr_nolist(IExpr, OExpr), !.
	expr_nolist(IExpr, OExpr) :-
		IExpr=..[Op|IArgs],
		mapcar(expr_nolist,IArgs,OArgs),
		OExpr=..[Op|OArgs].
	
	% Expand consult shorthand into explicit calls to re/consult:
	% Ignore nonatomic items in the consult list.
	expand_consult([], Link, Link).
	expand_consult([File|List], [consult(File)|Consult], Link) :-
		(var(File);atom(File)), !,
		expand_consult(List, Consult, Link).
	expand_consult([-File|List], [reconsult(File)|Consult], Link) :-
		(var(File);atom(File)), !,
		expand_consult(List, Consult, Link).
	expand_consult([Other|List], Consult, Link) :-
		expand_consult(List, Consult, Link).

% Addition - 12/20
% If > 7 arguments to a call, force all arguments after the first six into
% a structure passed as the seventh argument.  Must be done for heads and
% subgoals in body. - Wayne
% Also embeds arity in the functor name if necessary.
correct_name(Pred, PH) :-
	functor(Pred, Functor, Arity), Arity >= 8, !,
	Pred =.. [Functor, A1, A2, A3, A4, A5, A6 | Rest],
	RestArgs =.. [dummy | Rest],
	rename_goal(Functor, Arity, NewFunctor),
	PH =.. [NewFunctor, A1, A2, A3, A4, A5, A6, RestArgs].
correct_name(Pred, NewPred) :-
	functor(Pred, Functor, Arity),
	rename_goal(Functor, Arity, NewFunctor),
	Pred=..[Functor|Args],
	NewPred=..[NewFunctor|Args].

% Embed arity into the functor name:
% Only done for nonbuiltins.
rename_goal(Functor, Arity, Functor) :-
	escape_builtin(Functor, Arity), !.
rename_goal(Functor, Arity, NewFunctor) :-
	name(Functor, FList),
	name(Arity, AList),
	concat(FList, "/", AList, NFList),
	name(NewFunctor, NFList).

% Convert an integer into a string:
% to_string(N, [D|Link], Link) :-
% 	N<10, !,
% 	D is N+"0".
% to_string(N, String, Link) :-
% 	D is (N mod 10) + "0",
% 	N1 is (N // 10),
% 	to_string(N1, String, [D|Link]).
