
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

% Special utilities used by the clause compiler:

% Built-in procedures which do not destroy any
% argument registers:
% Includes arity so user can define routines with same
% name but different arity.
escape_builtin(Goal) :-
	Goal=..[Name|Args],
	my_length(Args, Arity),
	escape_builtin(Name, Arity).

escape_builtin(!, 0) :- !.
escape_builtin('->',0) :- !. 	% For correct compilation of if-then-else.
escape_builtin(true, 0) :- !.
escape_builtin(fail, 0) :- !.
escape_builtin('=', 2) :- !.
escape_builtin(Name, Arity) :- user_call(Name, Arity), !, fail.
escape_builtin(Name, Arity) :- table_builtin(Name, Arity), !.
escape_builtin(Name, Arity) :- user_escape(Name, Arity), !.

% Optional predicates NOT to be considered as escape builtins:
user_call(Name, Arity) :- compile_options(nb(L)),
	(member(Name/Arity, L); Name/Arity=L), !.

% Optional predicates to be considered as EXTRA escape builtins:
user_escape(Name, Arity) :- compile_options(b(L)),
	(member(Name/Arity, L); Name/Arity=L), !.

% Note: The table_builtins not,\=,\+ are done in pretrans.
% The unify operator '=' is part & parcel of the compiler.
% However, all four must be listed here for correct compilation.

% 12/4 - added table_builtin routines to handle global variables, set and access.
% - Wayne

% Some of the table_builtins are implemented with existing instructions:
table_builtin(nl, 0).
table_builtin(repeat, 0).
table_builtin('\+', 1).
table_builtin('not', 1).
table_builtin(var, 1).
table_builtin(atom, 1).
table_builtin(list, 1).
table_builtin(write, 1).
table_builtin(writeq, 1).
table_builtin(nonvar, 1).
table_builtin(atomic, 1).
table_builtin(number, 1).
table_builtin(integer, 1).
table_builtin(nonlist, 1).
table_builtin(structure, 1).
table_builtin(random, 1).
table_builtin('@<', 2).
table_builtin('@>', 2).
table_builtin('<', 2).
table_builtin('>', 2).
table_builtin('==', 2).
table_builtin('\=', 2).
table_builtin('<=', 2).
table_builtin('=<', 2).
table_builtin('>=', 2).
table_builtin('\==', 2).
table_builtin('=..', 2).
table_builtin(set,2).		% for global variables
table_builtin(access,2).	% for global variables
table_builtin('is', 2).
% table_builtin('+', 3).	Because of VLSI PLM instructions
% table_builtin('-', 3).
% table_builtin('/\', 3).
% table_builtin('\/', 3).
table_builtin('is', 4).
table_builtin(functor, 3).	% Added 11/15/86.
table_builtin(arg, 3).	% Added 1/15/87.
table_builtin(name,2).
table_builtin(system,1).
table_builtin(consult,1).
table_builtin(reconsult,1).

% additional built-ins not in original list.
table_builtin('=\=',2).
table_builtin('<>',2).
table_builtin(abolish,2).
table_builtin(assert,1).
% table_builtin(call,1). Because call/1 kills temporaries.  11/16/86.
table_builtin(length,2).
table_builtin(put,1).
table_builtin(get,1).
table_builtin(get0,1).
table_builtin(read,1).
table_builtin(retract,1).
table_builtin(see,1).
table_builtin(seen,0).
table_builtin(tab,1).
table_builtin(tell,1).
table_builtin(told,0).

% Source instructions and library routines for VLSI PLM:
vlsi_instr(+, add).
vlsi_instr(-, sub).
vlsi_instr(*, mult).
vlsi_instr((/\), and).
vlsi_instr((\/), or).
vlsi_instr(add, add).
vlsi_instr(sub, sub).
vlsi_instr(mult, mult).
vlsi_instr(and, and).
vlsi_instr(or, or).
vlsi_instr(eor, eor).

% Get type and argument of an instruction:
type_arg(get(T,R,X), T, R).
type_arg(put(T,R,X), T, R).
type_arg(unify(T,R), T, R).

% Maximum:
max(A, B, A) :- A>=B, !.
max(A, B, B) :- A=<B, !.

% Collect variables in a structure.
colvars(S, Vars) :-
	S=..[_|SL],
	split_avs(SL, Vars).
split_avs([A|Args], Vars) :-
	atomic(A), !,
	split_avs(Args, Vars).
split_avs([V|Args], Vars) :-
	var(V), !,
	split_avs(Args, VL),
	includev(V, VL, Vars).
split_avs([S|Args], Vars) :-
	S=..[_|SA],
	split_avs(SA, VL1),
	split_avs(Args, VL2),
	unionv(VL1, VL2, Vars).
split_avs([], []).

% Extract all variable terms from input list
% and put them in a difference list:
getvars(V, [V|Link]-Link) :- var(V), !.
getvars(V, Link-Link) :- nonlist(V), !.
getvars([V|List], Out) :-
	var(V), !,
	Out=[V|Vars]-Link, % Changed for bug in v2.1 BIM-Prolog
	getvars(List, Vars-Link).
getvars([X|List], Vars-Link) :-
	nonvar(X), !,
	getvars(List, Vars-Link).
getvars([], Link-Link).


% Mapping utilities for G.P. traversing of
% clause code.

% 1. Map over a clause (no dependencies):
% Result has same structure as input.
% Call may be a structure with one argument.
mapclause(Call, [X|XRest], [Y|YRest]) :-
	X=(_;_), !,
	mapdis(Call, X, Y),
	mapclause(Call, XRest, YRest).
mapclause(Call, [X|XRest], [Y|YRest]) :-
	Call=..List, 
	concat(List, [X,Y], GoalList),
	G=..GoalList,
	call(G),
	mapclause(Call, XRest, YRest).
mapclause(_, [], []).

mapdis(Call, (X;XRest), (Y;YRest)) :-
	mapclause(Call, X, Y),
	mapdis(Call, XRest, YRest).
mapdis(Call, X, Y) :-
	mapclause(Call, X, Y).


% 2. Mapclause with three inputs:
mapclause(Call, [X|XRest], [Y|YRest], [Z|ZRest]) :-
	X=(_;_), !,
	mapdis(Call, X, Y, Z),
	mapclause(Call, XRest, YRest, ZRest).
mapclause(Call, [X|XRest], [Y|YRest], [Z|ZRest]) :-
	Call=..[A], 
	G=..[A,X,Y,Z],
	call(G),
	mapclause(Call, XRest, YRest, ZRest).
mapclause(_, [], [], []).

mapdis(Call, (X;XRest), (Y;YRest), (Z;ZRest)) :-
	mapclause(Call, X, Y, Z),
	mapdis(Call, XRest, YRest, ZRest).
mapdis(Call, X, Y, Z) :-
	mapclause(Call, X, Y, Z).


% Repeat loop in Prolog.
% by Warren.
% range(10,I,30) succeeds with I=10, 11, ..., 30, and then fails.
% range(L,L,L) :- !.
% range(L,I,H) :-
%    K is (H+L)//2,
%    range(L,I,K).
% range(L,I,H) :-
%    K is 1+(H+L)//2,
%    range(K,I,H).

range(L,L,H).
range(L,I,H) :- L<H, L1 is L+1, range(L1,I,H).
