
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* qsort without trailing */
main :-
	list1(X),
	qsort(X,Y),
	write(Y).

qsort([],[]) :- !.
qsort([A|As], B) :- 
	filter(A, As, Smaller, Greater),
	qsort(Smaller, SmallerSorted),
	qsort(Greater, GreaterSorted),
	append(SmallerSorted, [A|GreaterSorted], B).

filter(A,[],[],[]) :- !.
filter(A, [B|Bs], C, Ds) :-
	A > B, !,
	C = [B|Cs],
	filter(A, Bs, Cs, Ds).
filter(A, [B|Bs], Cs, D) :-
	A =< B,
	D = [B|Ds],
	filter(A, Bs, Cs, Ds).

append([], X, X) :- !.
append([X|Xs], Y, [X|Zs]) :-
	append(Xs, Y, Zs).

list1([3,8,4,0,45,23,3,8,4,0,45,23,3,8,4,0,45,23,3,8,4,0,45,23,3,8,4,0,45,23,3,8,4,0,45,23,3,8,4,0,45,23,3,8,4,0,45,23,98]).


