
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

#include <stream.h>
#include "hash_table.h"
#include "string_table.h"
#include "scan.h"
#include "tags.h"
#include "instr.h"
#include "memory.h"
#include "inst_args.h"
#include "top_level.h"
#include "arg_types.h"
#include "basics.h"

static const int MAX_ARITY = 7;
static inline int min(int a, int b)
{
  return (a > b) ? b : a;
}

 /* a little bit of a problem is that instr_args[ARG_PROC] understands */
 /* procedure addresses as assembly line numbers, while the call and */
 /* execute instructions understand them as pointers to the */
 /* instruction record */

void ArgTypes::init()
{
  HashTable* source = instr_args[ARG_PROC]->get_table();
  addr_to_record = new HashTable(source->size);
  source->reset();
  HashTableEntry* e;
  while (e = source->next()) {
    int addr = (int) (P0 + e->key - 1);
    ArgDataRecordHead* r = new ArgDataRecordHead;
    int arity = instr_args[ARG_PROC]->get_arity(addr);
    r->arity = min(arity, MAX_ARITY);
    r->next = 0;
    addr_to_record->bind(addr, (int) r);
  }
}

void ArgTypes::fill(Cell addr)
{
  ArgDataRecordHead* r = (ArgDataRecordHead*) addr_to_record->get(addr);
  if (addr_to_record->status == HASH_MISS || r == 0) {
    cout << "can't find the arg record of proc ";
    instr_args[ARG_PROC]->print(addr);
    top_level_error("");
  }
  r->fill();
}

void ArgTypes::print()
{
  cout << "/* INFO ON PROCEDURES */\n\n";
  addr_to_record->reset();
  HashTableEntry* e;
  while (e = addr_to_record->next()) {
    instr_args[ARG_PROC]->print(e->key);
    cout << "\n";
    ((ArgDataRecordHead*) e->value)->print();
  }
}

void ArgDataRecordHead::fill()
{
  if (arity == 0) {
    count++;
    return;
  }
  unsigned type_rec = 0;
  for (int i = arity - 1; i >= 0; --i) {
    type_rec <<= 2;
    type_rec |= get_tag(deref(X[i]));
  }
  ArgDataRecord** r = &next;
  while (*r != 0 && type_rec != (*r)->types)
    r = &((*r)->next);
  if (*r == 0) {
    *r = new ArgDataRecord;
    (*r)->types = type_rec;
    (*r)->count = 0;
  }
  (*r)->count++;
}

static inline void print_tag(int tag)
{
  if (tag == TAGREF)
    cout << "ref";
  else if (tag == TAGLIST)
    cout << "list";
  else if (tag == TAGSTRUCT)
    cout << "struct";
  else if (tag == TAGCONST)
    cout << "const";
}    
    
static inline void print_types(int arity, int types)
{
  for (int i = 0; i < arity; i++) {
    print_tag(types & GETTAG);
    cout << " ";
    types >>= 2;
  }
}  

void ArgDataRecordHead::print()
{
  if (arity == 0) {
    printf("\t%8d:\n", count);
    return;
  }
  ArgDataRecord** r = &next;
  while (*r != 0) {
    printf("\t%8d: ", (*r)->count);
    print_types(arity, (*r)->types);
    cout << "\n";
    r = &((*r)->next);
  }
}

/*      ArgData.fill(P->arg1);*/
/*    ArgType.init(instr_args[ARG_PROC]->proc_name_table); */
    /* create a new hash table in which to put the binding between a */
    /* procedure address (as given as an argument to a call or an */
    /* execute_proc) and a list of argtype records. This table need */
    /* only be known by some subroutine of execute. This subroutine is */
    /* only called when this flag is set. */ 
/*    ArgType.print(); */
    /* If this flag is set, will also print the different sets of */
    /* types with which each procedure has been called */
  
