
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

enum {
  UNRESOLVED_ADDRESSES,
  NO_UNRESOLVED_ADDRESSES
  };

class InstrArg {
 public:
  char* name;
  HashTable* TableOfTables;
  int status;
  virtual void init(Scan& scanner) {}
  virtual int fill(char*) {return 0;}
  virtual void print(int value) {cout << value;}
  virtual void clear() {}
  virtual void define(int, int) {}
  virtual int update(int) {return -1;}
  virtual int get_arity(int) {return -1;}
  virtual void print_proc_table() {}
  virtual PF get_exec(int) {return 0;}
  virtual HashTable* get_table() {return 0;}
};

class NoArg : public InstrArg {
 public:
  void print(int value) {}
};

enum {XVAR, YVAR};
/* Xi<->i-1, Yi<->i-1 */
class Var : public InstrArg {
 public:
  int fill(char* s);
};

class Atom : public InstrArg {
  static StringTable* symbol_table;
public:
  void init(Scan& ST) {symbol_table = &ST;}
  int fill(char* s) {
    Cell atom = make_atom(symbol_table->intern(s));
    return atom;
  }
  void print(int value) {
    cout << (char*) get_string(value);
  }
};

class Table : public InstrArg {
  static Scan* scanner;
  static int tcdr;
  static int table_count;
 public:
  void init(Scan& SC) {
    scanner = &SC;
    tcdr = scanner->intern("tcdr");
    TableOfTables = new HashTable;
  }
  int fill(char* s);
  void print(int value);
};

class Int : public InstrArg {
 public:
  int fill(char* s);
  void print(int value) {cout << value;}
};

enum {
#define NAMES
#define use(ID,name,Function)\
  ID,
#include "built_ins.h"
#undef use
#undef NAMES
LAST_BUILT_IN
};

struct BuiltInEntry {
  int name;
  PF exec;
};

class BuiltIn : public InstrArg {
 public:
  static HashTable* name_to_ID;
  static HashTable* exec_to_ID;
  static BuiltInEntry* built_in_table;
  static StringTable* symbol_table;
  void init(Scan& ST);
  PF get_exec(int name);
  int fill(char* s) {
    int ID = name_to_ID->get(symbol_table->intern(s));
    return (int) built_in_table[ID].exec;
  }
  void print(int value) {
    int ID = exec_to_ID->get(value);
    int name = built_in_table[ID].name;
    printf("%d:%s", ID, name);
  }
};

class Const : public InstrArg {
  static StringTable* symbol_table;
 public:
  void init(Scan& ST) {symbol_table = &ST;}
  int fill(char* s);
  void print(int value);
};

class Label : public InstrArg {
  static HashTable* label_table;
 public:
  void define(int label, int address) {label_table->bind(label, address);}
  int update(int label);
  void clear() {label_table->clear();}
  void init(Scan&);
  int fill(char* s);
  void print(int label);
};

class Proc : public InstrArg {
  static HashTable* proc_addr_table;
  static StringTable* symbol_table;
  static HashTable* proc_name_table;
 public:
  void init(Scan& ST);
  int fill(char* s) {return symbol_table->intern(s);}
  HashTable* get_table();
  void define(int name, int address) {
    proc_addr_table->bind(name, address);
    proc_name_table->bind(address, name);
  }
  int update(int name);
  int get_arity(int address);
  void print(int address);
  void print_proc_table();
};

enum {
#define use(String,ARGID,Name)\
  ARGID,
#include "list_inst_args.h"
#undef use
  ARG_LAST
  };

extern InstrArg* instr_args[];
extern void init_instr_args(Scan& scanner);

const int LABEL_FAIL = -1;
