/* 
 * intelEth.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#ifndef NDEBUG
int nCUNoCommandsPending, nCUCommandsPending, nCUStarts, nCUContinues, nCULeavingActives, nCUXmits;

#endif

#include "xkernel.h"
#include "eth.h"
#include "intelEthType.h"
#include "intelEthRcv.h"
#include "intelEthCmd.h"
#include "intelEth.h"

int printXmitSem();

volatile intermInitRoot_t IntermInitRoot;

SetPromiscusous()
{
  configIeDev(1);
}


/*
 * ethCtlrInit
 */

ethCtlrInit(localEthAd)
     ethAd_t localEthAd;
{
  
  TRACE0(ie, 5, "ethCtlrInit");
  
  /* establish the handler for interrupts from the ie device */
  setexvec(handleIeIntrAsm, IE_INTR_NUM);
  
  /* set up memory to be used for communication between ie dev and host */
  initMemSharing();
  TRACE0(ie, 5, "done setting up memory for the device");
  
  /* reset the device, so it shares the correct memory */
  resetIeDev();
  TRACE0(ie, 5, "done reseting the device");
  
  /*
   * ready the hardware and data structures for issuing action commands,
   * which include: configuring the device, setting the local ether address,
   * and transmitting data.
   */
  initCmd();
  TRACE0(ie, 5, "done setting up device for action commands");
  
  /* configure the device the way we want it */
  configIeDev(0);
  TRACE0(ie, 5, "done configuring the device");
  
  /* tell the device what address to use as its own */
  informIeDevLocalEthAd(localEthAd);
  TRACE0(ie, 5, "done telling device what address to use");
  
  /* ready the hardware and data structures for receiving ether packets */
  initRcv();
  TRACE0(ie, 5, "ready to receive packets");
  
  /* TEMP */
#ifdef ETH_OPT_TRACE
  event_register(printXmitSem,0,1000,EV_REPEAT);
#endif
#ifdef BLORT
  intelStatus(0);
  event_register(intelStatus,0,30000,EV_REPEAT);
#endif
}				/* end ethCtlrInit */


extern boolean CuKnownNotActive;

printXmitSem(i)
     int i;
{
  printf("Xmit semaphore: %d\n", FreeCmdCntSem.count);
  printf("Cmd unit status: %d\n", SCB.cmdUnitStatus);
  printf("CUKNA: %d\n", CuKnownNotActive);
}     


/*
 * initMemSharing
 */

initMemSharing()
{
  extern unsigned long AllocateMemory();
  
  /* allocate the memory shared for communication between ie dev and cpu */
  assert(sizeof(ieSharedMem_t) <= 64 * 1024);
  AllocateMemory((unsigned) IeSharedMemPtr, sizeof(ieSharedMem_t));
  bzero((char *) IeSharedMemPtr, sizeof(ieSharedMem_t));
  
}				/* end initMemSharing */


/*
 * resetIeDev
 */

resetIeDev()
{
  int delay;
  
  
  TRACE0(ie, 5, "resetIeDev");
  
  while (TRUE) {
    IE_CTL_REG = IE_CTL_REG_LOOPBACK;
    /* replace these constants with something meaningful */
    for (delay = 0; delay < (SECS400 / 19980); delay++); /* kill ? time */
    IE_CTL_REG = 0;
    
    /* tell the ie dev where to find the memory to be shared */
    InitRoot.busKind = 0;
    InitRoot.intermInitRootAd = IE_AD_FROM_AD(&IntermInitRoot);
    IntermInitRoot.initInProgress = TRUE;
    IntermInitRoot.ieSharedMemAd = IE_AD_FROM_AD(IeSharedMemPtr);
    /* sys control blk is at begining of shared memory */
    IntermInitRoot.scbOffset = 0;
    ALERT_IE_DEV();
    /* see if it worked (??) */
    for (delay = 0; IntermInitRoot.initInProgress && (delay < SECS400);
	 delay++);
    for (delay = 0; delay < (SECS400 / 19980); delay++); /* kill ? time */
    for (delay = 0; !SCB.cuLeftActiveState && (delay < SECS400); delay++);
#if 0
    while (!(IE_CTL_REG & IE_CTL_REG_INTR_PEND)); /* wait for interrupt */
#else
    for (delay = 0; !(IE_CTL_REG & IE_CTL_REG_INTR_PEND) && (delay < SECS400);
	 delay++) ;	/* wait for interrupt */
#endif
    if (SCB.cmdUnitStatus == CU_STATUS_IDLE) {
      return;			/*****HERE'S THE LOOP TERMINATION*****/
    }
    TRACE0(ethp, 1, "command unit not idle after reset");
    /* and try again ... */
  }
}				/* end resetIeDev */


intelStatus(foo)
     int foo;
{
  int x = spl7();
  int i;
  cmd_t *cptr;
  
  rcvFrameDesc_t *rfd;
  extern rcvFrameDesc_t *RcvFrameDescHeadPtr;
  
  printf("IE status: ");
  if (SCB.frameRcvd)
    printf("frame received ");
  if (SCB.cmdDone)
    printf("command done ");
  if (SCB.cuLeftActiveState)
    printf("cu left active ");
  if (SCB.ruNotReady)
    printf("ru not ready ");
  printf("RUS: ");
  switch (SCB.rcvUnitStatus) {
  case RUS_IDLE:
    printf("idle ");
    break;
  case RUS_SUSPENDED:
    printf("suspended ");
    break;
  case RUS_NORESOURCES:
    printf("no resources ");
    break;
  case RUS_READY:
    printf("ready ");
    break;
  default:
    printf("Not used");
    break;
  }
  printf("CUS: ");
  switch (SCB.cmdUnitStatus) {
  case CU_STATUS_IDLE:
    printf("idle");
    break;
  case CU_STATUS_SUSPEND:
    printf("suspended ");
    break;
  case CU_STATUS_ACTIVE:
    printf("active ");
    break;
  default:
    printf("Not used ");
    break;
  }
  {
    for (i = 0, rfd = RcvFrameDescHeadPtr;
	 rfd && rfd->used;
	 i++, rfd = (rcvFrameDesc_t *) AD_FROM_IE_OFFSET(rfd->nextRfdOffset));
    printf(" %d packets pending\n", i);
  }
  splx(x);
}


/*
 * handleIeIntr
 *
 * Old code implies that multiple interrupt conditions can coexist.
 */

handleIeIntr()
{
  boolean foundIntrKind;
  
  
#ifndef NDEBUG
  IFTRACE(ie, 2) putchar('i');
#endif
  TRACE0(ie, 5, "handleIeIntr");
  
  foundIntrKind = FALSE;
  
  if (SCB.frameRcvd) {
    foundIntrKind = TRUE;
    handleRcvdFrame();
  }
  
  if (SCB.cuLeftActiveState) {
    foundIntrKind = TRUE;
    handleCuLeavingActiveState();
  }
  if (SCB.ruNotReady) {
    foundIntrKind = TRUE;
    /* should not happen, probably means exhausted receive buffering */
    TRACE0(ie, 1, "handleIeIntr: RCV UNIT LEFT READY STATE!");
    freeRcvBufs();
    initRcv();
    SCB.ackRuNotReady = TRUE;
    SCB.rcvUnitCtlCmd = RU_START;
    ALERT_IE_DEV();
  }
  if (SCB.cmdDone) {
#ifndef NDEBUG
    IFTRACE(ie, 2) putchar('c');
#endif
    SCB.ackCmdDone = TRUE;
    foundIntrKind = TRUE;
    ALERT_IE_DEV();
  }
  if (!foundIntrKind) {
    /* should not happen, but does routinely! */
#ifdef ETH_OPT_TRACE
    putchar('&');
#endif
    TRACE0(ie, 5, "handleIeIntr: couldn't identify interrupt!");
#ifndef NDEBUG
    IFTRACE(ie, 2) putchar('z');
#endif
    SCB.ackCmdDone = TRUE;
    SCB.ackFrameRcvd = TRUE;
    SCB.ackCuLeftActiveState = TRUE;
    SCB.ackRuNotReady = TRUE;
    ALERT_IE_DEV();
  }
}				/* end handleIeIntr */

#ifndef NDEBUG
intelEthStats()
{
  printf("nCUNoCommandsPending = %d\n", nCUNoCommandsPending);
  printf("nCUCommandsPending = %d\n", nCUCommandsPending);
  printf("nCUStarts = %d\n", nCUStarts);
  printf("nCUContinues = %d\n", nCUContinues);
  printf("nCULeavingActives = %d\n", nCULeavingActives);
  printf("nCUXmits = %d\n", nCUXmits);
}

#endif
