h53608
s 00678/00000/00000
d D 1.1 91/01/10 11:10:17 llp 1 0
c date and time created 91/01/10 11:10:17 by llp
e
u
U
f e 0
t
T
I 1
/* 
 * trap.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "xkernel.h"
#include "meta.h"
#include "memory.h"
#include "ms_trap.h"
#include "ms_consts.h"

UserNop()
{
}

UserCreateProcess(r, priority, nargs, firstarg)
Pfi	r;
unsigned int	priority;
int	nargs;
int	*firstarg;
{
  ICreateProcess(GetAddressableAspace(),r,0,priority,FALSE,nargs,&firstarg);
  return(0);
}

UserDestroyProcess()
{
  DestroyProcess();
}

UserCreateSem(initial)
int	initial;
{
  Semaphore *s;
  s = (Semaphore *) malloc(sizeof(Semaphore));
  InitSemaphore(s, (unsigned)initial);
  return((int)s);
}

UserDestroySem(s)
Semaphore	*s;
{
  while (s->count < 0) V(s);
  free((char *) s);
  return(0);
}

UserP(s)
Semaphore	*s;
{
  TRACE2(user, 7, "User P on %x, val = %d", s, s->count);
  P(s);
}

UserV(s)
Semaphore	*s;
{
  TRACE2(user, 7, "User V on %x, val = %d", s, s->count);
  V(s);
}

UserYield()
{
  kSwitch();
}

UserGetProtlByName(s)
char	*s;
{
  return (int)x_getprotlbyname(s);
}

UserGetPage()
{
  return (int) AllocateUserPage();
}

UserGetTime(where)
UnixTime	*where;
{
  unsigned char buffer[8];
  ReadTime(buffer);
  ConvertTimeToUnix(buffer, where);
}

UserPutChar(s)
int	s;
{
  putchar(s);
}

UserOpen(hlp,llp,participants)
XObj	hlp;
XObj	llp;
Part	*participants;
{
  Sessn s;
  s = x_open(hlp, llp, participants);
  TRACE2(user, 3, "User open of %d returns %x", llp, s);
  return((int)s);
}

UserOpenEnable(hlp,llp,participants)
XObj	hlp;
XObj	llp;
Part	*participants;
{
  int s;
  TRACE2(protocol, 3, "User calling open_enable[%d] by %d", llp, hlp);
  s = x_openenable(hlp, llp, participants);
  return(s);
}

UserOpenDisable(hlp,llp,participants)
XObj	hlp;
XObj	llp;
Part	*participants;
{
  int s;
  s = x_opendisable(hlp, llp, participants);
  return(s);
}

UserClose(s)
XObj	s;
{
  return(x_close(s));
}

UserPush(s,message,length,message2,length2)
XObj	s;
char	*message;
int	length;
char	*message2;
int	*length2;
{
  Msg m;
  Msg rm;
  int result;
  char *buffer;
  TRACE3(protocol, 3, "User push s=%x m=%x l=%d", s, message, length);
  if (length == 0) {
    msg_clear(m);
  } else if (length <= 1024) {
    msg_make_allstack(m, 128, message, length);
  } else {
    buffer = malloc((unsigned)length);
    bcopy(message, buffer, length);
    msg_make_new(m, 128, buffer, length);
  }
  msg_clear(rm);
  if ((result = x_push(s, m, &rm)) >= 0) {
    if (!msg_isnull(rm)) {
      *length2 = min(msg_len(rm), *length2);
      msg_peek(rm, 0, *length2, message2);
      msg_free(rm);
    }
  }
  return result;
}

char *msgtopage(m)
Msg m;
{
  REF *ref;
  char *answer;

  assert(isapage(m));
  ref = m.data->body.contig.ref;
  answer = m.data->body.contig.data;
  ref->ref++;
  msg_free(m);
  free((char *)ref);
  return answer;
}

UserPushPage(s,message,length,message2,length2)
XObj	s;
char	*message;
int	length;
char	*message2;
int	*length2;
{
  Msg m;
  Msg rm;
  REF *ref;
  char *buffer;
  TRACE3(protocol, 3, "User call page s=%x m=%x l=%d", s, message, length);

  if ((int)message % PAGE_SIZE == 0) {
    /* steal the page from the user and give it to the kernel */
    buffer = (char *)MapPage(message, 0, SUPER_ONLY|PAGE_WRITE);
  
    nmsg_makespecialref(ref, buffer, FreePage);
    ref->ref--;
    msg_make_exist(m, META_HDR_LEN, buffer, PAGE_SIZE, ref);
  } else {
    if (length <= 1024) {
      msg_make_allstack(m, 128, message, length);
    } else {
      buffer = malloc((unsigned)length);
      bcopy(message, buffer, length);
      msg_make_new(m, 128, buffer, length);
    }
  }
  msg_clear(rm);
  if (x_push(s, m, &rm) >= 0) {
    if (!msg_isnull(rm)) {
      if (isapage(rm)) {
	int len = msg_len(rm);
	char *kernelpage = msgtopage(rm);
	char *userpage = message2;
	TRACE2(user, 2, "UserPushPage found a page %x mapped to %x", kernelpage,
	  userpage);
	FreePage(userpage);
	MapPage(kernelpage, userpage, PAGE_WRITE);
	*length2 = len;
      } else {
	*length2 = min(msg_len(rm), *length2);
	msg_peek(rm, 0, *length2, message2);
	msg_free(rm);
      }
    }
    return 0;
  } else {
    return (int)-1;
  }
}

UserControlSessn(s,code,buffer,length)
XObj	s;
int	code;
char	*buffer;
int	length;
{
  return(x_controlsessn(s, code, buffer, length));
}

UserControlProtl(p,code,buffer,length)
XObj	p;
int	code;
char	*buffer;
int	length;
{
  return(x_controlprotl(p, code, buffer, length));
}

UserCreateProtocol(s,od,cd,c)
Pfi	s;
Pfs	od;
Pfi	cd;
Pfi	c;
{
  return((int)x_createuserprotl(s, od, cd, c));
}

UserDestroyProtocol(p)
XObj	p;
{
  return(x_destroyprotl(p));
}

typedef struct sUserEvent {
  Aspace *as;
  Pfi	r;
  int	a;
  int	c;
  int	id;
  struct sUserEvent *next;
} UserEvent;

static UserEvent *userEventList = NULL;

/*ARGSUSED*/
UserEventPutArgs(args, p, a, b, c)
int *args;
char *p;
int a, b, c;
{
  *args++ = a;
  *args = b;
}

UserEventHappenedProc(ev)
UserEvent *ev;
{
  register UserEvent *e;
  TRACE2(user, 1, "User timeout 0x%x, arg 0x%x", ev->r, ev->a);
  Ms_CallUserRoutine(ev->as, ev->r, 2, 0, UserEventPutArgs, (Pfi)0, ev->a, ev->id,
    0, 0);
  if (ev->c == EV_ONCE) {
    if (ev == userEventList) {
      userEventList = ev->next;
    } else {
      for (e = userEventList; e->next && e->next != ev; e = e->next) ;
      if (e->next) e->next = e->next->next;
    }
    free((char *)ev);
  }
}

/*ARGSUSED*/
UserEventHappened(ev, id)
UserEvent *ev;
int id;
{
  CreateKernelProcess(UserEventHappenedProc, 5, 1, ev);
}

UserEventRegister(r,a,i,c)
Pfi	r;
int	a;
int	i;
int	c;
{
  UserEvent *ev;
  ev = (UserEvent *)malloc(sizeof(UserEvent));
  ev->as = GetAddressableAspace();
  ev->r = r;
  ev->a = a;
  ev->c = c;
  ev->next = userEventList;
  userEventList = ev;
  TRACE3(user, 1, "UserEvent reg 0x%x arg 0x%x time %d", ev->r, ev->a, i);
  ev->id = event_register(UserEventHappened, (int)ev, (unsigned)i, ev->c);
  return(ev->id);
}
  
doRemove(r, a)
Pfi r;
int a;
{
  UserEvent *e, *f;
  for (f = NULL, e = userEventList; 
    e && (e->r != r || e->as != GetAddressableAspace() || e->a != a) ; 
    f = e, e = e->next) ;
  if (e != NULL) {
    event_remove(UserEventHappened, (int)e);
    if (f) {
      f->next = e->next;
    } else {
      userEventList = e->next;
    }
    free((char *)e);
  }
  return(0);
}

UserEventRemove(r,a)
Pfi	r;
int	a;
{
  return(doRemove(r, a));
}
  
UserEventRemoveEvent(e)
UserEvent	*e;
{
  return(doRemove(e->r, e->a));
}

UserSBrk(amount)
int	amount;
{
  int answer;
  Aspace *as;
  as = GetAddressableAspace();
  answer = GetAspaceSize(as);
  TRACE3(user, 3, "SBrk on %x by %x to %x", as, amount, answer+amount);
  SetAspaceSize(as, (char *)(answer + amount));
  return(answer);
}

UserBrk(amount)
int	amount;
{
  int answer;
  Aspace *as;
  as = GetAddressableAspace();
  answer = GetAspaceSize(as);
  TRACE2(user, 3, "Brk on %x to %x", as, amount);
  SetAspaceSize(as, (char *)amount);
  return(answer);
}

UserSemaphoreCount(s)
Semaphore	*s;
{
  return s->count;
}

UserOnFault(r)
Pfi	r;
{
  /* do the right thing with r */
}

UserPause(m)
int	m;
{
  Delay(m);
}

UserProfile(startEnd,f)
int	startEnd;
Pfi	f;
{
  initProfile(startEnd, f);
}

static int findStrings(buf, len, argv)
char *buf, **argv;
int len;
{
  char *p = buf;
  int argc = 0;
  while (*p && p - buf <= len) {
    argv[argc++] = p;
    while (*p && p - buf <= len) p++;
    p++;
  }
  argv[argc] = 0;
  return argc;
}

UserCloneAspace(buffer)
char	*buffer;
{
  char **argv;
  int argc,len;

  TRACE1(user, 3, "CloneAspace with arg = `%s'",buffer);
  argv = (char **)malloc(8 * sizeof(char *));
  len = strlen(buffer);
  argc = findStrings(buffer, len, argv);
  ExecUser(argc, argv);
}

UserGetAspaceId()
{
  TRACE0(user, 3, "GetAspaceId");
  return 0x100 + (GetAddressableAspace() - AspaceDescriptors);
}
  
isapage(m)
Msg m;
{
  IFTRACE(user, 5) {
    msg_display(m, 0);
  }
  return msg_stack_len(m) == 0 &&
	 m.data &&
  	 m.data->tag == NM_Contig &&
	 msg_data_len(m) <= PAGE_SIZE &&
	 m.data->body.contig.ref->ref == 1 &&
	 m.data->body.contig.ref->xfree == (void(*)) FreePage &&
	 (int) m.data->body.contig.data % PAGE_SIZE == 0;
}
	 
callUserDemux(as, r, session, msg)
Aspace *as;
Pfi r;
Sessn session;
Msg msg;
{
  int callUserDemuxPutArgs(), callUserDemuxPagePutArgs();

  P((Semaphore *)session->mutex);
  TRACE2(user, 1, "Calling user demux %x (length = %d)", r, msg_len(msg));
  if (isapage(msg)) {
    int len = msg_len(msg);
    char *kernelpage = msgtopage(msg);
    TRACE1(user, 2, "CallUserDemux found a page %x", kernelpage);
    Ms_CallUserRoutine(as, r, 3, 0, callUserDemuxPagePutArgs, (Pfi)0,
      (int)session, (int)&kernelpage, len, 0);
    FreePage((unsigned)kernelpage);
  } else {
    Ms_CallUserRoutine(as, r, 3, msg_len(msg), callUserDemuxPutArgs, (Pfi)0,
      (int)session, (int)&msg, 0, 0);
  }
  TRACE1(user, 1, "User demux %x done", r);
  V((Semaphore *)session->mutex);
}

callUserDemuxPutArgs(args, buffer, session, msg)
register int *args;
register char *buffer;
int session;
Msg *msg;
{
  int len;
  *args++ = session;
  *args++ = (int) buffer;
  len = msg_isnull(*msg) ? 0 : msg_len(*msg);
  *args = len;
  TRACE2(user, 1, "UDPA: buffer = %x, msg_len = %d", buffer, len);
  if (len > 0) {
    msg_peek(*msg, 0, len, buffer);
    msg_free(*msg);
  }
}

callUserDemuxPagePutArgs(args, buffer, session, kernelpage, len)
register int *args;
register char *buffer;
int session;
char **kernelpage;
int len;
{
  char *userpage = (char *)MapPage(*kernelpage, 0, PAGE_WRITE);
  *kernelpage = userpage;
  *args++ = session;
  *args++ = (int) userpage;
  *args = len;
  TRACE2(user, 1, "UDPA: page = %x, len = %d", userpage, len);
}

callUserOpenDone(as, r, session, participants)
Aspace *as;
Pfs r;
Sessn session;
Part *participants;
{
  int callUserDonePutArgs();
  int argsize, totalsize, nparticipants;
  register Part *p;

  TRACE1(user, 1, "Calling user open done %x", r);
  for (argsize = 0, nparticipants = 0, p = participants; p->address; p++) {
    argsize += ROUNDUP(p->length, 4);
    nparticipants ++;
  }
  totalsize = argsize + (nparticipants + 1) * sizeof(Part);
  Ms_CallUserRoutine(as, (Pfi)r, 2, totalsize, callUserDonePutArgs, (Pfi)0,
    (int)session, (int)participants, nparticipants, 0);
}

callUserDonePutArgs(args, p, session, participants, nparticipants)
int *args;
register Part *p;
int session;
register Part *participants;
int nparticipants;
{
  register char *addr;
  *args++ = session;
  *args = (int) p;
  addr = (char *) (p + nparticipants + 1);
  TRACE1(user, 3, "Addr = %x", addr);
  for (; participants->length; p++, participants++) {
    p->length = participants->length;
    p->address = addr;
    TRACE2(user, 3, "p = (%x, %d)", p->address, p->length);
    bcopy(participants->address, addr, p->length);
    addr += ROUNDUP(p->length, 4);
  }
  p->length = 0;
  p->address = (char *) 0;
}

callUserControl(as, r, s, opcode, buf, len)
Aspace *as;
Pfi r;
Sessn s;
int opcode, len;
char *buf;
{
  int callUserControlPutArgs(), callUserControlDoneArgs();

  TRACE1(user, 1, "Calling user control %x", r);
  return Ms_CallUserRoutine(as, r, 4, len, callUserControlPutArgs,
    (Pfi)callUserControlDoneArgs, (int)s, opcode, buf, len);
}

/*ARGSUSED*/
callUserControlPutArgs(args, buffer, session, opcode, buf, len)
int *args;
char *buffer;
int session, opcode, len;
char *buf;
{
  *args++ = session;
  *args++ = opcode;
  *args++ = (int)buffer;
  *args   = len;
  bcopy(buf, buffer, len);
}

/*ARGSUSED*/
callUserControlDoneArgs(args, buffer, session, opcode, buf, len)
int *args;
char *buffer;
int session, opcode, len;
char *buf;
{
  bcopy(buffer, buf, len);
}

callUserCloseDone(as, r, session)
Aspace *as;
Pfi r;
Sessn session;
{
  int callUserCloseDonePutArgs();

  P((Semaphore *)session->mutex);
  TRACE1(user, 1, "Calling user close done %x", r);
  Ms_CallUserRoutine(as, r, 1, 0, callUserCloseDonePutArgs, (Pfi)0, (int)session,
    0, 0, 0);
  V((Semaphore *)session->mutex);
}

/*ARGSUSED*/
callUserCloseDonePutArgs(args, p, session, b, c)
int *args;
char *p;
int session, b, c;
{
  *args = session;
}

UserUndefinedTrap(trapnumber)
int trapnumber;
{
  TRACE1(user, 1, "Undefined user trap number %d, ignored\n", trapnumber);
}

struct {
  Pfi f;
  int nargs;
} kernel_epts[] = {
  /* TRAP_NOP */		{ UserNop, 0 },
/* protocol specific entry points */
  /* TRAP_OPEN */		{ UserOpen, 3 },
  /* TRAP_OPENENABLE */		{ UserOpenEnable, 3 },
  /* OPEN_DONE is a call-back */
  /* TRAP_OPENDISABLE */	{ UserOpenDisable, 3 },
  /* DEMUX     is a call-back */
  /* TRAP_CLOSE */		{ UserClose, 1 },
  /* TRAP_PUSH */		{ UserPush, 5 },
  /* POP       does not make sense */
  /* TRAP_CONTROLSessn */	{ UserControlSessn, 4 },
  /* TRAP_CONTROLPROTL */	{ UserControlProtl, 4 },
  /* TRAP_CREATEPROTOCOL */	{ UserCreateProtocol, 4},
  /* TRAP_DESTROYPROTOCOL */	{ UserDestroyProtocol, 1 },
/* Generic entry points */
  /* TRAP_CREATEPROCESS */	{ UserCreateProcess, -3 },
  /* TRAP_DESTROYPROCESS */	{ UserDestroyProcess, 0 },
  /* TRAP_CREATESEMAPHORE */	{ UserCreateSem, 1 },
  /* TRAP_DESTROYSEMAPHORE */	{ UserDestroySem, 1 },
  /* TRAP_P */			{ UserP, 1 },
  /* TRAP_V */			{ UserV, 1 },
  /* TRAP_YIELD */		{ UserYield, 0 },
  /* TRAP_GETTIME */		{ UserGetTime, 1 },
  /* TRAP_PUTCHAR */		{ UserPutChar, 1 },
  /* TRAP_EVENTREGISTER */	{ UserEventRegister, 4 },
  /* TRAP_EVENTREMOVE */	{ UserEventRemove, 2 },
  /* TRAP_EVENTREMOVEEVENT */	{ UserEventRemoveEvent, 1 },
  /* TRAP_SBRK */		{ UserSBrk, 1 },
  /* TRAP_SEMAPHORECOUNT */	{ UserSemaphoreCount, 1 },
  /* TRAP_ONFAULT */		{ UserOnFault, 1 },
  /* TRAP_PROFILE */		{ UserProfile, 2 },
  /* TRAP_PAUSE */		{ UserPause, 1 },
  /* TRAP_CALL obsolete */	{ UserNop, 0 },
  /* TRAP_GETPROTLBYNAME */	{ UserGetProtlByName, 1 },
  /* TRAP_GETPAGE */		{ UserGetPage, 0 },
  /* TRAP_PUSHPAGE */		{ UserPushPage, 5 },
  /* TRAP_CALLPAGE obsolete */	{ UserNop, 0 },
  /* TRAP_BRK */		{ UserBrk, 1 },
  /* TRAP_TEST */		{ UserNop, 0 },
  /* TRAP_CLONEASPACE */	{ UserCloneAspace, 1 },
  /* TRAP_GETASPACEID */	{ UserGetAspaceId, 0 },

  { (Pfi) 0, 0  }
};
E 1
