/* 
 * memory.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "process.h"
#include "memory.h"

/*
 * Memory management
 */

Aspace	*AddressableAspace;
Aspace	*AspaceDescriptors;
Aspace	*AsFreeList;
unsigned long MaxAspaces;


InitMemory()
{
  register Aspace *as;

  Ms_InitMemory();
  Ms_AllocateADs();
  TRACE0(memoryinit, 1, "Initializing aspace free list");
  AsFreeList = NULL;
  for( as = &AspaceDescriptors[MaxAspaces-1]; as >= AspaceDescriptors; --as ) {
    TRACE1(memoryinit, 3, "Freeing aspace %x", as);
    as->next = AsFreeList;
    AsFreeList = as;
    TRACE2(memoryinit, 3, "Ms_InitAs on %x %d", as, as - AspaceDescriptors);
    Ms_InitAs(as, (unsigned) (as - AspaceDescriptors));
  }
  as = AsFreeList;
  AsFreeList = as->next;
  AddressableAspace = as;	/* kernel address space */
  TRACE1(memoryinit, 3, "Calling Ms_InitAs on %x", as);
  Ms_InitAs(as, 0);
}

Aspace *CreateAspace()
/*
 * Return NULL if unsuccessful.
 */
{
  register Aspace *as;

  TRACE0(processcreation, 1, "CreateAspace called");
  /* Find a free aspace descriptor */
  if ( (as = AsFreeList) == NULL) return( NULL );
  AsFreeList = as->next;
  Ms_CreateAspace( as );
  return as;
}

DeallocateAspace(as)
register Aspace *as;
{
  as->next = AsFreeList;
  AsFreeList = as;
  Ms_SetAspaceSize(as, (char *)0);
}

FreePage(addr)
register unsigned addr;
{
  Ms_FreePage(addr);
}



