h01612
s 00002/00003/00076
d D 1.2 91/01/10 11:50:42 llp 2 1
c Prepared for 3.1 Distribution
e
s 00079/00000/00000
d D 1.1 90/11/16 10:53:03 menze 1 0
c date and time created 90/11/16 10:53:03 by menze
e
u
U
f e 0
t
T
I 1
/* 
 * ethernet.h
 *
 * x-kernel v3.1	12/10/90
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */


#ifndef ethernet_h
#define ethernet_h

#define ENET_MIN_DATA	46
#define ENET_MAX_DATA	1500

/* Address types */
typedef struct {
    unsigned short	high;
    unsigned short	mid;
    unsigned short	low;
} ETHhost, ethAd_t;

/* Header definitions */

#define ETHHOSTLEN sizeof(ETHhost)

D 2
# define ETH_SETPROMISCUOUS 0x11
# define ETH_GET_TYPE	    0x12
E 2
I 2
# define ETH_SETPROMISCUOUS	(ETH_CTL*MAXOPS + 0)
E 2

#define ETH_AD_SZ		sizeof(ETHhost)

#define ETH_ADS_EQUAL(A,B)	((A).high==(B).high\
					&&(A).mid==(B).mid\
					&&(A).low==(B).low)

#define ZERO_ETH_AD(ad)		{ad.high=ad.mid=ad.low=0;}

#define	BCAST_ETH_AD		{0xffff,0xffff,0xffff};

/*
 * Ethernet "types"
 *
 * Ether-speak for protocol numbers is "types."
 * Unfortunately, ether "types" are unsigned shorts,
 * while xkernel PROTLs are ints.
 */

typedef unsigned short				ETHtype, ethType_t;

/*
 * Ethernet packet headers
 */
typedef struct {
	ETHhost			destEthAd;
	ETHhost			srcEthAd;
	ethType_t		ethType;	/* higher level protocol */
} ethHdr_t;


typedef struct {
  ETHtype		type;
  ETHhost		host;
} ETHaddr;

/*
 * range of legal data sizes
 */

#define MIN_ETH_DATA_SZ		64
#define	MAX_ETH_DATA_SZ		1500

typedef struct {
	ethHdr_t	ethPktHdr;
	unsigned char	ethPktData[MAX_ETH_DATA_SZ];
} ethPkt_t;

#define MAX_ETH_PKT_SZ		sizeof( ethPkt_t )

#endif ethernet_h
E 1
