h22646
s 01095/01100/00543
d D 1.2 91/01/10 12:13:28 llp 2 1
c Prepared for 3.1 Distribution
e
s 01643/00000/00000
d D 1.1 90/12/08 23:38:34 menze 1 0
c date and time created 90/12/08 23:38:34 by menze
e
u
U
f e 0
t
T
I 1
/*
 * nfs.c
 *
 * x-kernel v3.1	12/10/90
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */

typedef int     bool_t;

D 2
#include "assert.h"
E 2
#include <sys/time.h>
#include <sys/types.h>
#include <sys/errno.h>
#include <sys/stat.h>
#include <nfs/nfs.h>
#include <rpc/rpc.h>
#include <rpcsvc/mount.h>
#include <stdio.h>
#include <string.h>
#include <sys/file.h>
D 2
#include "upi.h"
#include "userupi.h"
#include "process.h"
E 2
I 2
#include "xkernel.h"
E 2
#include "ip.h"
#include "udp.h"
#include "sun_rpc.h"
#include <rpc/pmap_prot.h>
#include <ctype.h>
#include "xnfs.h"
#include "nfs_xdr.h"
#include "nfs_internal.h"

static  XObj    SELF=0;
#define SUNRPC	SELF->down[0]
#define NFS     SELF
D 2

NFS_F_STATE	*getfsys();
E 2
I 2
  
  NFS_F_STATE	*getfsys();
E 2
IPaddr          myipaddr;
int             tracexnfsp = 0;

/* globals .  Later, these should be made one per open file (SESSION).
 * We probably don't need a buffer for each direction, since nfs is
 * synchronous.
 */

XDR      xdrs, xdrr, xdra;
char     raws[MAXRAWLEN], rawr[MAXRAWLEN], rawa[MAXRAWLEN];
static int      raws_len, rawr_len, rawa_len;

static struct	t_margs	mtab[MAXFSYS];
static int	numfsys = 0;

/************************************
 * Uniform Interface Operations
 ************************************/

nfs_instantiateprotl(self)
D 2
XObj self;
E 2
I 2
     XObj self;
E 2
{
  TRACE0(xnfsp, 1, "NFS instantiateprotl");
  assert(x_is_protocol(self));
  SELF = self;
}

nfs_init(self)
D 2
XObj self;
E 2
I 2
     XObj self;
E 2
{
D 2

    TRACE0(xnfsp, 1, "NFS init");

    /* initialize xdr stuff */
    xdrmem_create(&xdrs, raws, MAXRAWLEN, XDR_ENCODE);
    xdrmem_create(&xdrr, rawr, MAXRAWLEN, XDR_DECODE);
    xdrmem_create(&xdra, rawa, MAXRAWLEN, XDR_ENCODE);

    /* get our IP address */
    if (x_controlprotl(x_getprotlbyname("ip"), MYADDR, (char *) &myipaddr,
		       sizeof myipaddr) < 0) {
	printf("nfs: Can't find my IP addr\n");
	return (-1);
    }

    return (0);
E 2
I 2
  
  TRACE0(xnfsp, 1, "NFS init");
  
  /* initialize xdr stuff */
  xdrmem_create(&xdrs, raws, MAXRAWLEN, XDR_ENCODE);
  xdrmem_create(&xdrr, rawr, MAXRAWLEN, XDR_DECODE);
  xdrmem_create(&xdra, rawa, MAXRAWLEN, XDR_ENCODE);
  
  /* get our IP address */
  if (x_controlprotl(x_getprotlbyname("ip"), GETMYADDR, (char *) &myipaddr,
		     sizeof myipaddr) < 0) {
    printf("nfs: Can't find my IP addr\n");
    return (-1);
  }
  
  return (0);
E 2
}

D 2
XObj
nfs_open(self, hlp, p)
XObj	self;
XObj	hlp;
Part           *p;	/* p[0]=mode (OPEN/CREATE) 
E 2
I 2
XObj nfs_open(self, hlp, p)
     XObj	self;
     XObj	hlp;
     Part	*p;	/* p[0]=mode (OPEN/CREATE) 
E 2
			 * p[1]=pathname
			 * p[2]=file attributes (only in CREATE)  */
{
D 2
    XObj		s;
    NFS_S_STATE		*state;
    REMOTEDIR		fsstate;
    int			len, opcode;
    struct nfscreatargs c_args;
    struct nfsdiropargs d_args;
    struct nfsdiropres	d_res;
    char		fname[NFS_MAXNAMLEN];
    char		*path;

    opcode = (int) p[0].address;
    path = p[1].address;

    s = (XObj) NULL;
    if (!p) {
	x_errno = BAD_ADDR;
	TRACE0(xnfsp, 9, "error: 1");
	return (ERR_SESSN);
E 2
I 2
  XObj		s;
  NFS_S_STATE		*state;
  REMOTEDIR		fsstate;
  int			len, opcode;
  struct nfscreatargs c_args;
  struct nfsdiropargs d_args;
  struct nfsdiropres	d_res;
  char		fname[NFS_MAXNAMLEN];
  char		*path;
  
  opcode = (int) p[0].address;
  path = p[1].address;
  
  s = (XObj) NULL;
  if (!p) {
    x_errno = BAD_ADDR;
    TRACE0(xnfsp, 9, "error: 1");
    return (ERR_SESSN);
  }
  
  TRACE1(xnfsp, 1, "NFS open with path=%s", path);
  
  state = (NFS_S_STATE *) malloc(sizeof(NFS_S_STATE));
  assert(state != NULL);
  
  /* create and initialize session */
  s = x_createsession(hlp, NFS, 1);
  s->rcnt = 1;
  s->state = (char *) state;
  
  /*
   * if the opcode is CREATE or OPEN, we might have to parse directories
   * until we do our final action.  We just do a lookup for all but the
   * last path component, and then let the later code act on that last
   * component 
   */
  if ((opcode == NFS_OPEN) || (opcode == NFS_CREATE)) {
    if (parsepath(path, fname, &fsstate) < 0) {
      printf("Parsepath failed resturning error for %s\n", path);
      return(ERR_SESSN);
E 2
    }
D 2

    TRACE1(xnfsp, 1, "NFS open with path=%s", path);

    state = (NFS_S_STATE *) malloc(sizeof(NFS_S_STATE));
    assert(state != NULL);

    /* create and initialize session */
    s = x_createsession(hlp, NFS, 1);
    s->rcnt = 1;
    s->state = (char *) state;

    /*
     * if the opcode is CREATE or OPEN, we might have to parse directories
     * until we do our final action.  We just do a lookup for all but the
     * last path component, and then let the later code act on that last
     * component 
     */
    if ((opcode == NFS_OPEN) || (opcode == NFS_CREATE)) {
        if (parsepath(path, fname, &fsstate) < 0) {
	    printf("Parsepath failed resturning error for %s\n", path);
	    return(ERR_SESSN);
	}
	state->fs_ptr = fsstate.fsptr;
        }

    switch (opcode) {

    case NFS_CREATE:	/* create a remote file */

	TRACE1(xnfsp, 1, "In create %s\n", fname);
	/* setup params for NFS create service */
        bcopy(&fsstate.dhandle, &c_args.ca_da.da_fhandle, NFS_FHSIZE);
	c_args.ca_da.da_name = fname;
	TRACE1(xnfsp, 1, "before bcopy %s\n", fname);
	bcopy(p[2].address, &c_args.ca_sa, sizeof(struct nfssattr));
	TRACE1(xnfsp, 1, "after bcopy %s\n", fname);

	XDR_SETPOS(&xdrs, 0);
	xdr_creatargs(&xdrs, &c_args);

	len = MAXRAWLEN;
	if (rpc_call(state->fs_ptr->rpc_create_s, raws, XDR_GETPOS(&xdrs),
		     rawr, &len) < 0) {
	    printf("nfs_create: xcall failed\n");
	    return (ERR_SESSN);
	}
	XDR_SETPOS(&xdrr, 0);
	xdr_diropres(&xdrr, &d_res);

	TRACE1(xnfsp, 1, "after rpccall %s\n", fname);
	if (d_res.dr_status != NFS_OK) {
	    TRACE1(xnfsp, 1, "nfs_create failed ! err=%d\n", d_res.dr_status);
            x_errno = d_res.dr_status;
	    return (ERR_SESSN);
	}
	/* store results */
	state->f_handle = d_res.dr_u.dr_drok_u.drok_fhandle;
	state->f_attrs = d_res.dr_u.dr_drok_u.drok_attr;
	state->f_pointer = 0;	/* offset */

	break;


    case NFS_OPEN:	/* open a remote file */

	/* setup params for NFS lookup service */
        bcopy(&fsstate.dhandle, &d_args.da_fhandle, NFS_FHSIZE);
	d_args.da_name = fname;

	XDR_SETPOS(&xdrs, 0);
	xdr_diropargs(&xdrs, &d_args);

	len = MAXRAWLEN;
	TRACE1(xnfsp, 5, "len of xdred diropargs =%d\n", XDR_GETPOS(&xdrs));
	TRACE1(xnfsp, 7, "state->fs_ptr == %d", state->fs_ptr);
	if (rpc_call(state->fs_ptr->rpc_lookup_s, raws, XDR_GETPOS(&xdrs),
		     rawr, &len) < 0) {
	    printf("nfs_lookup: xcall failed\n");
	    return (ERR_SESSN);
	}
	XDR_SETPOS(&xdrr, 0);
	xdr_diropres(&xdrr, &d_res);

	if (d_res.dr_status != NFS_OK) {
	    TRACE1(xnfsp, 1, "nfs_open failed ! err=%d\n", d_res.dr_status);
            x_errno = d_res.dr_status;
	    return (ERR_SESSN);
	}
	/* store results */
	bcopy(&d_res.dr_fhandle, &state->f_handle, NFS_FHSIZE);
	state->f_attrs = d_res.dr_u.dr_drok_u.drok_attr;
	state->f_pointer = 0;	/* offset */

	break;

    default:	/* illegal opcode */
	printf("nfs_open: bad opcode %d\n", opcode);
	assert(0);
	break;
E 2
I 2
    state->fs_ptr = fsstate.fsptr;
  }
  
  switch (opcode) {
    
  case NFS_CREATE:	/* create a remote file */
    
    TRACE1(xnfsp, 1, "In create %s\n", fname);
    /* setup params for NFS create service */
    bcopy(&fsstate.dhandle, &c_args.ca_da.da_fhandle, NFS_FHSIZE);
    c_args.ca_da.da_name = fname;
    TRACE1(xnfsp, 1, "before bcopy %s\n", fname);
    bcopy(p[2].address, &c_args.ca_sa, sizeof(struct nfssattr));
    TRACE1(xnfsp, 1, "after bcopy %s\n", fname);
    
    XDR_SETPOS(&xdrs, 0);
    xdr_creatargs(&xdrs, &c_args);
    
    len = MAXRAWLEN;
    if (rpc_call(state->fs_ptr->rpc_create_s, raws, XDR_GETPOS(&xdrs),
		 rawr, &len) < 0) {
      printf("nfs_create: xcall failed\n");
      return (ERR_SESSN);
E 2
    }
D 2


    TRACE1(xnfsp, 3, "NFS open returns %x", s);
    return (s);
E 2
I 2
    XDR_SETPOS(&xdrr, 0);
    xdr_diropres(&xdrr, &d_res);
    
    TRACE1(xnfsp, 1, "after rpccall %s\n", fname);
    if (d_res.dr_status != NFS_OK) {
      TRACE1(xnfsp, 1, "nfs_create failed ! err=%d\n", d_res.dr_status);
      x_errno = d_res.dr_status;
      return (ERR_SESSN);
    }
    /* store results */
    state->f_handle = d_res.dr_u.dr_drok_u.drok_fhandle;
    state->f_attrs = d_res.dr_u.dr_drok_u.drok_attr;
    state->f_pointer = 0;	/* offset */
    
    break;
    
    
  case NFS_OPEN:	/* open a remote file */
    
    /* setup params for NFS lookup service */
    bcopy(&fsstate.dhandle, &d_args.da_fhandle, NFS_FHSIZE);
    d_args.da_name = fname;
    
    XDR_SETPOS(&xdrs, 0);
    xdr_diropargs(&xdrs, &d_args);
    
    len = MAXRAWLEN;
    TRACE1(xnfsp, 5, "len of xdred diropargs =%d\n", XDR_GETPOS(&xdrs));
    TRACE1(xnfsp, 7, "state->fs_ptr == %d", state->fs_ptr);
    if (rpc_call(state->fs_ptr->rpc_lookup_s, raws, XDR_GETPOS(&xdrs),
		 rawr, &len) < 0) {
      printf("nfs_lookup: xcall failed\n");
      return (ERR_SESSN);
    }
    XDR_SETPOS(&xdrr, 0);
    xdr_diropres(&xdrr, &d_res);
    
    if (d_res.dr_status != NFS_OK) {
      TRACE1(xnfsp, 1, "nfs_open failed ! err=%d\n", d_res.dr_status);
      x_errno = d_res.dr_status;
      return (ERR_SESSN);
    }
    /* store results */
    bcopy(&d_res.dr_fhandle, &state->f_handle, NFS_FHSIZE);
    state->f_attrs = d_res.dr_u.dr_drok_u.drok_attr;
    state->f_pointer = 0;	/* offset */
    
    break;
    
  default:	/* illegal opcode */
    printf("nfs_open: bad opcode %d\n", opcode);
    assert(0);
    break;
  }
  
  
  TRACE1(xnfsp, 3, "NFS open returns %x", s);
  return (s);
E 2
}


D 2

E 2
nfs_close(s)
D 2
XObj	s;
E 2
I 2
     XObj	s;
E 2
{
D 2
    TRACE1(xnfsp, 1, "NFS close of session %x", s);
    /*
     * we're going to be dogmatic - if someone closes a session that has
     * already been closed, then we are going to barf all over him. if
     * (!s) return(0);   idempotent closes: just say no! 
     */
    assert(s != NULL);
    
    /* POSSIBLE MEMORY LEAK */
    
    TRACE1(xnfsp, 9, "nfs_close: ref count = %d", s->rcnt);
    x_destroysession(s);

    return (0);
E 2
I 2
  TRACE1(xnfsp, 1, "NFS close of session %x", s);
  /*
   * we're going to be dogmatic - if someone closes a session that has
   * already been closed, then we are going to barf all over him. if
   * (!s) return(0);   idempotent closes: just say no! 
   */
  assert(s != NULL);
  
  /* POSSIBLE MEMORY LEAK */
  
  TRACE1(xnfsp, 9, "nfs_close: ref count = %d", s->rcnt);
  x_destroysession(s);
  
  return (0);
E 2
}


nfs_controlprotl(protl, opcode, buf, blen)
D 2
XObj	protl;
int	opcode;
char	*buf;
int	blen;
E 2
I 2
     XObj	protl;
     int	opcode;
     char	*buf;
     int	blen;
E 2
{
D 2

    TRACE1(xnfsp, 6, "entering nfs_controlprotl %d", opcode);
    switch (opcode) {
    case SETNFSDEBUG:
	{
	    int             old = tracexnfsp;

	    TRACE0(xnfsp, 1, "nfs_controlprotl SETNFSDEBUG");
	    assert(blen == sizeof(int));
	    tracexnfsp = *((unsigned *) buf);
	    TRACE2(xnfsp, 1, "tracexnfsp %d ==> %d", old, tracexnfsp);
	    return (0);	/* don't know what to return, but isn't used */
	}

    case MOUNT:		/* mount a new filesystem */
        {
	    struct minfo   *mount = (struct minfo *) buf;
            Part		part[3];
	    SUNRPCaddr		program, naddr;
            NFS_F_STATE	*fs_state;
	    struct pmap	p_map;
            int	len, nfs_p;
            Sessn		s, *sp;
            struct dstr {
                char *str;
            } our_str;
            static time	auth_time;
	    struct opaque_auth a_cred;
            struct fhstatus mnt_res;


        
	    TRACE0(xnfsp, 3, "NFS mount \n"); 
            /* allocate a filesystem state structure */
	    fs_state = (NFS_F_STATE *) malloc(sizeof(NFS_F_STATE));
            assert(fs_state != NULL);
            TRACE2(xnfsp, 5, "Name = %s, Machname = %s\n", mount->fs_pathname, mount->machname);
            bcopy(mount, &mtab[numfsys], sizeof(struct minfo));
            mtab[numfsys].fs_ptr = fs_state;

            TRACE1(xnfsp, 5, "fsystem handle=%d", fs_state);
            fs_state->host_ipaddr.host = mtab[numfsys].host;
            fs_state->pathname = mtab[numfsys].fs_pathname;
E 2
  
D 2
            /* get mount protocol port # using the rpc portmapper */

            program.host.host = mtab[numfsys].host;
            program.host.port = PMAPPORT;
            program.prot = 17;  	/* UDP is the transport protocol */
            program.prog = PMAPPROG;
            program.vers = PMAPVERS;
            program.proc = PMAPPROC_GETPORT;
    
            /* open an RPC session to the portmapper */
            naddr.host.host = myipaddr.host;
            naddr.host.port = 0;
            init_partlist(part, 2, SUNRPCaddr);
            set_part(part, 0 , naddr);
            set_part(part, 1 , program);
	    TRACE0(xnfsp, 5, "about to open SUNRPC");
            s = x_open(NFS, SUNRPC, part);
            if (s == ERR_SESSN) {
	        printf("portmapper: xopen failed\n");
                return (0);
            }

            /* call the portmapper */
            p_map.pm_prog = MOUNTPROG;      /* ignore XDR for now !!!! */
            p_map.pm_vers = MOUNTVERS;
            p_map.pm_prot = 17;   /* UDP */

            len = sizeof(unsigned);
	    TRACE0(xnfsp, 5, "about to call RPC");
            if (rpc_call(s, &p_map, sizeof(p_map),
                    &(fs_state->mount_port), &len) < 0) {
                printf("portmapper: xcall failed\n");
                return (0);
            }
            x_close(s);

            /* NFS port is currently constant */
	    fs_state->nfs_port = NFS_PORT;

            /* call mount protocol */
            program.host.host = mtab[numfsys].host;
            program.host.port = fs_state->mount_port;
            program.prot = 17;  	/* UDP is the transport protocal */
            program.prog = MOUNTPROG;
            program.vers = MOUNTVERS;
            program.proc = MOUNTPROC_MNT;
    
            /* open an RPC session to mount */
            naddr.host.host = myipaddr.host;
            naddr.host.port = 0;
            init_partlist(part, 2, SUNRPCaddr);
            set_part(part, 0 , naddr);
            set_part(part, 1 , program);
            s = x_open(NFS, SUNRPC, part);
            if (s == ERR_SESSN) {
	        printf("mount: xopen failed\n");
	        return (0);
            }

            /* setup UNIX authentication */
	    /* x_gettime(&auth_time); forget about time for now */
	    /* printtime("auth_time=",&auth_time); */
            fs_state->auth_parms.aup_time = auth_time.sec; 
            fs_state->auth_parms.aup_machname = mtab[numfsys].machname;
            fs_state->auth_parms.aup_uid = mtab[numfsys].uid;
            fs_state->auth_parms.aup_gid = mtab[numfsys].gid; 

            fs_state->auth_parms.aup_len = 0;
            /* fs_state->auth_parms.aup_gids = */


            /* pass authentication info to RPC */

	    XDR_SETPOS(&xdra, 0);

	    xdr_authunix_parms(&xdra, &(fs_state->auth_parms));
	    rawa_len = (int) XDR_GETPOS(&xdra);

            /* credential structure */

            a_cred.oa_flavor = AUTH_UNIX;
            a_cred.oa_base = (caddr_t) rawa;
            a_cred.oa_length = rawa_len;
            /* verifier structure */
            /* for now, we rely on RPC using a default of AUTH_NULL */

            TRACE0(xnfsp, 5, "about to pass auth info to RPC 1");
            x_controlsessn(s, RPCSETCREDTYPE, &a_cred.oa_flavor, sizeof(int));

            TRACE1(xnfsp, 5, "about to pass auth info to RPC 2, len=%d",
                    rawa_len);

            x_controlsessn(s, RPCSETCRED, a_cred.oa_base, a_cred.oa_length);
				
            /* call mount */
            XDR_SETPOS(&xdrs, 0);
            our_str.str = mtab[numfsys].fs_pathname; /* used to be +6  -Sam */

            TRACE1(xnfsp, 5, "new pathname for mount call is %s",our_str.str);

            xdr_string(&xdrs, &our_str.str, MAXRAWLEN);
 
            len = MAXRAWLEN;
            TRACE0(xnfsp, 5, "about to call mount"); 
            if (rpc_call(s, raws, XDR_GETPOS(&xdrs), rawr, &len)
                < 0) {
	        printf("mount: xcall failed\n");
                return (-1);
            }
            x_close(s);

            /* decode received response */
            TRACE2(xnfsp, 5, "raw len of response is %d, len is %d\n",
                             len, NFS_FHSIZE);
            XDR_SETPOS(&xdrr, 0);
	    xdr_fhstatus(&xdrr, &mnt_res);
	 
	    if (mnt_res.fhs_status != NFS_OK) {
	        /* should print error texts later */
	        printf("mount failed ! err=%d\n", mnt_res.fhs_status);
                x_errno = mnt_res.fhs_status;
	        return(-1);
	    }

            /* save file handle */
	    fs_state->fs_handle = mnt_res.fhs_fh;

	    /* open sessions to all NFS services we use */
            program.host.host = fs_state->host_ipaddr.host;
            program.host.port = fs_state->nfs_port;
            program.prot = 17;  	/* UDP is the transport protocal */
            program.prog = NFS_PROGRAM;
            program.vers = NFS_VERSION;

            for (nfs_p = RFS_NULL, sp = &(fs_state->rpc_null_s);
	         nfs_p <= RFS_NPROC; nfs_p++, sp++) {

                program.proc = nfs_p;
	        *sp = x_open(NFS, SUNRPC, part);
	        assert(*sp != ERR_SESSN);

	        /* pass authentication stuff */
                x_controlsessn(*sp,RPCSETCREDTYPE, &a_cred.oa_flavor, sizeof(int));
                x_controlsessn(*sp,RPCSETCRED, a_cred.oa_base, a_cred.oa_length);
	    }	    
            numfsys++;
            TRACE1(xnfsp, 5, "number of numfsys is %d\n",numfsys);
E 2
I 2
  TRACE1(xnfsp, 6, "entering nfs_controlprotl %d", opcode);
  switch (opcode) {
  case SETDEBUG:
    {
      int             old = tracexnfsp;
E 2
      
D 2
   return(0); 
            break;
        } 

    case MKDIR:
        return(domakedir((struct create *) buf, blen));

    case RMDIR:
        return(doremovedir(buf, blen));

    case SETATTR:
        return(dosetattr((struct create *) buf, blen));

    case REMOVE:
        return(doremove(buf, blen));

    case RENAME:
        return(dorename(buf, blen));

    case LINK:
        return(dolink(buf, blen));

    case SYMLINK:
        return(dosymlink(buf, blen));

    case READLINK:
	return(doreadlink(buf, blen));

    case GETATTR:
	return(dogetattr(buf, blen));
E 2
I 2
      TRACE0(xnfsp, 1, "nfs_controlprotl SETNFSDEBUG");
      assert(blen == sizeof(int));
      tracexnfsp = *((unsigned *) buf);
      TRACE2(xnfsp, 1, "tracexnfsp %d ==> %d", old, tracexnfsp);
      return (0);	/* don't know what to return, but isn't used */
    }
E 2
    
D 2
    case READDIR:
	return(doreaddir((struct rddir *)buf, blen));

    default:
	x_errno = INVALID_OPCODE;
E 2
I 2
  case NFS_MOUNT:		/* mount a new filesystem */
    {
      struct minfo   *mount = (struct minfo *) buf;
      Part		part[3];
      SUNRPCaddr		program, naddr;
      NFS_F_STATE	*fs_state;
      struct pmap	p_map;
      int	len, nfs_p;
      Sessn		s, *sp;
      struct dstr {
	char *str;
      } our_str;
      static time	auth_time;
      struct opaque_auth a_cred;
      struct fhstatus mnt_res;
      
      
      
      TRACE0(xnfsp, 3, "NFS mount \n"); 
      /* allocate a filesystem state structure */
      fs_state = (NFS_F_STATE *) malloc(sizeof(NFS_F_STATE));
      assert(fs_state != NULL);
      TRACE2(xnfsp, 5, "Name = %s, Machname = %s\n", mount->fs_pathname, mount->machname);
      bcopy(mount, &mtab[numfsys], sizeof(struct minfo));
      mtab[numfsys].fs_ptr = fs_state;
      
      TRACE1(xnfsp, 5, "fsystem handle=%d", fs_state);
      fs_state->host_ipaddr.host = mtab[numfsys].host;
      fs_state->pathname = mtab[numfsys].fs_pathname;
      
      /* get mount protocol port # using the rpc portmapper */
      
      program.host.host = mtab[numfsys].host;
      program.host.port = PMAPPORT;
      program.prot = 17;  	/* UDP is the transport protocol */
      program.prog = PMAPPROG;
      program.vers = PMAPVERS;
      program.proc = PMAPPROC_GETPORT;
      
      /* open an RPC session to the portmapper */
      naddr.host.host = myipaddr.host;
      naddr.host.port = 0;
      init_partlist(part, 2, SUNRPCaddr);
      set_part(part, 0 , naddr);
      set_part(part, 1 , program);
      TRACE0(xnfsp, 5, "about to open SUNRPC");
      s = x_open(NFS, SUNRPC, part);
      if (s == ERR_SESSN) {
	printf("portmapper: xopen failed\n");
	return (0);
      }
      
      /* call the portmapper */
      p_map.pm_prog = MOUNTPROG;      /* ignore XDR for now !!!! */
      p_map.pm_vers = MOUNTVERS;
      p_map.pm_prot = 17;   /* UDP */
      
      len = sizeof(unsigned);
      TRACE0(xnfsp, 5, "about to call RPC");
      if (rpc_call(s, &p_map, sizeof(p_map),
		   &(fs_state->mount_port), &len) < 0) {
	printf("portmapper: xcall failed\n");
	return (0);
      }
      x_close(s);
      
      /* NFS port is currently constant */
      fs_state->nfs_port = NFS_PORT;
      
      /* call mount protocol */
      program.host.host = mtab[numfsys].host;
      program.host.port = fs_state->mount_port;
      program.prot = 17;  	/* UDP is the transport protocal */
      program.prog = MOUNTPROG;
      program.vers = MOUNTVERS;
      program.proc = MOUNTPROC_MNT;
      
      /* open an RPC session to mount */
      naddr.host.host = myipaddr.host;
      naddr.host.port = 0;
      init_partlist(part, 2, SUNRPCaddr);
      set_part(part, 0 , naddr);
      set_part(part, 1 , program);
      s = x_open(NFS, SUNRPC, part);
      if (s == ERR_SESSN) {
	printf("mount: xopen failed\n");
	return (0);
      }
      
      /* setup UNIX authentication */
      /* x_gettime(&auth_time); forget about time for now */
      /* printtime("auth_time=",&auth_time); */
      fs_state->auth_parms.aup_time = auth_time.sec; 
      fs_state->auth_parms.aup_machname = mtab[numfsys].machname;
      fs_state->auth_parms.aup_uid = mtab[numfsys].uid;
      fs_state->auth_parms.aup_gid = mtab[numfsys].gid; 
      
      fs_state->auth_parms.aup_len = 0;
      /* fs_state->auth_parms.aup_gids = */
      
      
      /* pass authentication info to RPC */
      
      XDR_SETPOS(&xdra, 0);
      
      xdr_authunix_parms(&xdra, &(fs_state->auth_parms));
      rawa_len = (int) XDR_GETPOS(&xdra);
      
      /* credential structure */
      
      a_cred.oa_flavor = AUTH_UNIX;
      a_cred.oa_base = (caddr_t) rawa;
      a_cred.oa_length = rawa_len;
      /* verifier structure */
      /* for now, we rely on RPC using a default of AUTH_NULL */
      
      TRACE0(xnfsp, 5, "about to pass auth info to RPC 1");
      x_controlsessn(s, SUNRPC_SETCREDTYPE, &a_cred.oa_flavor,
		     sizeof(int));
      
      TRACE1(xnfsp, 5, "about to pass auth info to RPC 2, len=%d",
	     rawa_len);
      
      x_controlsessn(s, SUNRPC_SETCRED, a_cred.oa_base,a_cred.oa_length);
      
      /* call mount */
      XDR_SETPOS(&xdrs, 0);
      our_str.str = mtab[numfsys].fs_pathname; /* used to be +6  -Sam */
      
      TRACE1(xnfsp, 5, "new pathname for mount call is %s",our_str.str);
      
      xdr_string(&xdrs, &our_str.str, MAXRAWLEN);
      
      len = MAXRAWLEN;
      TRACE0(xnfsp, 5, "about to call mount"); 
      if (rpc_call(s, raws, XDR_GETPOS(&xdrs), rawr, &len)
	  < 0) {
	printf("mount: xcall failed\n");
E 2
	return (-1);
D 2
    }

    return(1);
E 2
I 2
      }
      x_close(s);
      
      /* decode received response */
      TRACE2(xnfsp, 5, "raw len of response is %d, len is %d\n",
	     len, NFS_FHSIZE);
      XDR_SETPOS(&xdrr, 0);
      xdr_fhstatus(&xdrr, &mnt_res);
      
      if (mnt_res.fhs_status != NFS_OK) {
	/* should print error texts later */
	printf("mount failed ! err=%d\n", mnt_res.fhs_status);
	x_errno = mnt_res.fhs_status;
	return(-1);
      }
      
      /* save file handle */
      fs_state->fs_handle = mnt_res.fhs_fh;
      
      /* open sessions to all NFS services we use */
      program.host.host = fs_state->host_ipaddr.host;
      program.host.port = fs_state->nfs_port;
      program.prot = 17;  	/* UDP is the transport protocal */
      program.prog = NFS_PROGRAM;
      program.vers = NFS_VERSION;
      
      for (nfs_p = RFS_NULL, sp = &(fs_state->rpc_null_s);
	   nfs_p <= RFS_NPROC; nfs_p++, sp++) {
	
	program.proc = nfs_p;
	*sp = x_open(NFS, SUNRPC, part);
	assert(*sp != ERR_SESSN);
	
	/* pass authentication stuff */
	x_controlsessn(*sp, SUNRPC_SETCREDTYPE, &a_cred.oa_flavor,
		       sizeof(int));
	x_controlsessn(*sp, SUNRPC_SETCRED, a_cred.oa_base,
		       a_cred.oa_length);
      }	    
      numfsys++;
      TRACE1(xnfsp, 5, "number of numfsys is %d\n",numfsys);
      
      return(0); 
      break;
    } 
    
  case NFS_MKDIR:
    return(domakedir((struct create *) buf, blen));
    
  case NFS_RMDIR:
    return(doremovedir(buf, blen));
    
  case NFS_SETATTR:
    return(dosetattr((struct create *) buf, blen));
    
  case NFS_REMOVE:
    return(doremove(buf, blen));
    
  case NFS_RENAME:
    return(dorename(buf, blen));
    
  case NFS_LINK:
    return(dolink(buf, blen));
    
  case NFS_SYMLINK:
    return(dosymlink(buf, blen));
    
  case NFS_READLINK:
    return(doreadlink(buf, blen));
    
  case NFS_GETATTR:
    return(dogetattr(buf, blen));
    
  case NFS_READDIR:
    return(doreaddir((struct rddir *)buf, blen));
    
  default:
    x_errno = INVALID_OPCODE;
    return (-1);
  }
  
  return(1);
E 2
}


nfs_controlsessn(s, opcode, buf, blen)
D 2
XObj	s;
int	opcode;
char	*buf;
int	blen;
E 2
I 2
     XObj	s;
     int	opcode;
     char	*buf;
     int	blen;
E 2
{
D 2
    int             len;
    struct nfsreadargs r_args;
    struct nfsrdresult r_res;
    struct nfswriteargs w_args;
    struct nfssaargs	sa_args;
    struct nfsattrstat	sa_res;
    struct nfsattrstat w_res;
    NFS_S_STATE    *state = (NFS_S_STATE *) s->state;


    TRACE1(xnfsp, 3, "in nfs_controlsessn with session=%x\n", s);


    switch (opcode) {

    case NFS_READ:	/* read from remote file */

	TRACE0(xnfsp, 3, "in READ !\n");

	/* setup params for NFS read service */
	r_args.ra_fhandle = state->f_handle;
	r_args.ra_offset = state->f_pointer;
	r_args.ra_count = blen;
	r_args.ra_totcount = 0;	/* unused */
	assert(blen <= NFS_MAXDATA);	/* for now we don't fragment */

	XDR_SETPOS(&xdrs, 0);
	xdr_readargs(&xdrs, &r_args);

	len = MAXRAWLEN;
	if (rpc_call(state->fs_ptr->rpc_read_s, raws, XDR_GETPOS(&xdrs),
		     rawr, &len) < 0) {
	    printf("nfs_read: xcall failed\n");
	    return (-1);
	}
	TRACE1(xnfsp, 5, "read returned, got len=%d\n", len);

	/* set destination address for xdr */
	r_res.rr_u.rr_ok_u.rrok_data = buf;
	XDR_SETPOS(&xdrr, 0);
	xdr_rdresult(&xdrr, &r_res);

	if (r_res.rr_status != NFS_OK) {
	    /* should print error texts later */
	    printf("nfs_read failed ! err=%d\n", r_res.rr_status);
            x_errno = r_res.rr_status;
	    return (-1);
	}
	/* store new attributes */
	state->f_attrs = r_res.rr_u.rr_ok_u.rrok_attr;
	/* adjust file pointer */
	state->f_pointer += r_res.rr_u.rr_ok_u.rrok_count;

	TRACE0(xnfsp, 3, "returning from READ\n");
	return (r_res.rr_u.rr_ok_u.rrok_count);	/* return length */


    case NFS_WRITE:	/* write to remote file */

	TRACE1(xnfsp, 3, "in WRITE with len=%d!\n", blen);

	/* setup params for NFS write service */
	w_args.wa_fhandle = state->f_handle;
	w_args.wa_begoff = 0;	/* unused */
	w_args.wa_offset = state->f_pointer;
	w_args.wa_totcount = 0;	/* unused */
	w_args.wa_count = blen;
	w_args.wa_data = buf;
	/* have no idea what wa_mbuf is ??! */

	assert(blen <= NFS_MAXDATA);	/* for now we don't fragment */

	XDR_SETPOS(&xdrs, 0);
	xdr_writeargs(&xdrs, &w_args);

	len = MAXRAWLEN;
	if (rpc_call(state->fs_ptr->rpc_write_s, raws, XDR_GETPOS(&xdrs),
		     rawr, &len) < 0) {
	    printf("nfs_write: xcall failed\n");
	    return (-1);
	}
	XDR_SETPOS(&xdrr, 0);
	xdr_attrstat(&xdrr, &w_res);

	if (w_res.ns_status != NFS_OK) {
	    /* should print error texts later */
	    printf("nfs_write failed ! err=%d\n", w_res.ns_status);
            x_errno = w_res.ns_status;
	    return (-1);
	}
	/* store new attributes */
	state->f_attrs = w_res.ns_u.ns_attr_u;
	/* adjust file pointer */
	state->f_pointer += blen;

	return (0);


    case NFS_SEEK:	/* set file pointer for remote file */

E 2
I 2
  int             len;
  struct nfsreadargs r_args;
  struct nfsrdresult r_res;
  struct nfswriteargs w_args;
  struct nfssaargs	sa_args;
  struct nfsattrstat	sa_res;
  struct nfsattrstat w_res;
  NFS_S_STATE    *state = (NFS_S_STATE *) s->state;
  
  
  TRACE1(xnfsp, 3, "in nfs_controlsessn with session=%x\n", s);
  
  
  switch (opcode) {
    
  case NFS_READ:	/* read from remote file */
    
    TRACE0(xnfsp, 3, "in READ !\n");
    
    /* setup params for NFS read service */
    r_args.ra_fhandle = state->f_handle;
    r_args.ra_offset = state->f_pointer;
    r_args.ra_count = blen;
    r_args.ra_totcount = 0;	/* unused */
    assert(blen <= NFS_MAXDATA);	/* for now we don't fragment */
    
    XDR_SETPOS(&xdrs, 0);
    xdr_readargs(&xdrs, &r_args);
    
    len = MAXRAWLEN;
    if (rpc_call(state->fs_ptr->rpc_read_s, raws, XDR_GETPOS(&xdrs),
		 rawr, &len) < 0) {
      printf("nfs_read: xcall failed\n");
      return (-1);
    }
    TRACE1(xnfsp, 5, "read returned, got len=%d\n", len);
    
    /* set destination address for xdr */
    r_res.rr_u.rr_ok_u.rrok_data = buf;
    XDR_SETPOS(&xdrr, 0);
    xdr_rdresult(&xdrr, &r_res);
    
    if (r_res.rr_status != NFS_OK) {
      /* should print error texts later */
      printf("nfs_read failed ! err=%d\n", r_res.rr_status);
      x_errno = r_res.rr_status;
      return (-1);
    }
    /* store new attributes */
    state->f_attrs = r_res.rr_u.rr_ok_u.rrok_attr;
    /* adjust file pointer */
    state->f_pointer += r_res.rr_u.rr_ok_u.rrok_count;
    
    TRACE0(xnfsp, 3, "returning from READ\n");
    return (r_res.rr_u.rr_ok_u.rrok_count);	/* return length */
    
    
  case NFS_WRITE:	/* write to remote file */
    
    TRACE1(xnfsp, 3, "in WRITE with len=%d!\n", blen);
    
    /* setup params for NFS write service */
    w_args.wa_fhandle = state->f_handle;
    w_args.wa_begoff = 0;	/* unused */
    w_args.wa_offset = state->f_pointer;
    w_args.wa_totcount = 0;	/* unused */
    w_args.wa_count = blen;
    w_args.wa_data = buf;
    /* have no idea what wa_mbuf is ??! */
    
    assert(blen <= NFS_MAXDATA);	/* for now we don't fragment */
    
    XDR_SETPOS(&xdrs, 0);
    xdr_writeargs(&xdrs, &w_args);
    
    len = MAXRAWLEN;
    if (rpc_call(state->fs_ptr->rpc_write_s, raws, XDR_GETPOS(&xdrs),
		 rawr, &len) < 0) {
      printf("nfs_write: xcall failed\n");
      return (-1);
    }
    XDR_SETPOS(&xdrr, 0);
    xdr_attrstat(&xdrr, &w_res);
    
    if (w_res.ns_status != NFS_OK) {
      /* should print error texts later */
      printf("nfs_write failed ! err=%d\n", w_res.ns_status);
      x_errno = w_res.ns_status;
      return (-1);
    }
    /* store new attributes */
    state->f_attrs = w_res.ns_u.ns_attr_u;
    /* adjust file pointer */
    state->f_pointer += blen;
    
    return (0);
    
    
  case NFS_SEEK:	/* set file pointer for remote file */
    
E 2
    {
D 2
	int      *offset;

	offset  = (int *) buf;

	switch (blen) {
	case L_SET:
	   state->f_pointer = *offset;
	   break;
	case L_INCR:
	   state->f_pointer += *offset;
	   break;
	case L_XTND:
	   state->f_pointer = state->f_attrs.na_size + *offset;
	   break;
	}

	return state->f_pointer;
E 2
I 2
      int      *offset;
      
      offset  = (int *) buf;
      
      switch (blen) {
      case L_SET:
	state->f_pointer = *offset;
	break;
      case L_INCR:
	state->f_pointer += *offset;
	break;
      case L_XTND:
	state->f_pointer = state->f_attrs.na_size + *offset;
	break;
      }
      
      return state->f_pointer;
E 2
    }
D 2

    case NFS_TELL:
E 2
I 2
    
  case NFS_TELL:
E 2
    {
D 2
       return state->f_pointer;
E 2
I 2
      return state->f_pointer;
E 2
    }
D 2

    case GETATTR:
E 2
    
D 2
        bcopy(&state->f_attrs, buf, sizeof(struct nfsfattr));
	break;
E 2
I 2
  case NFS_GETATTR:
E 2
    
D 2
    case  SETATTR:
       /* setup params for NFS setattr service */

       bcopy(&state->f_handle, &sa_args.saa_fh, NFS_FHSIZE);
       bcopy(buf, &sa_args.saa_sa, sizeof(struct nfssattr));

       XDR_SETPOS(&xdrs, 0);
       xdr_saargs(&xdrs, &sa_args);

       len = MAXRAWLEN;
       if (rpc_call(state->fs_ptr->rpc_setattr_s, raws, XDR_GETPOS(&xdrs),
        	     rawr, &len) < 0) {
          printf("nfs_setattr: xcall failed\n");
          return (-1);
       }
       TRACE1(xnfsp, 5, "setattr returned, got len=%d\n", len);

       XDR_SETPOS(&xdrr, 0);
       xdr_attrstat(&xdrr, &sa_res);

       if (sa_res.ns_status != NFS_OK) {
         /* should print error texts later */
         printf("nfs_setattr failed ! err=%d\n", sa_res.ns_status);
         x_errno = sa_res.ns_status;
	 return(-1);
       }
       break;
    default:
	x_errno = INVALID_OPCODE;
	return (-1);

E 2
I 2
    bcopy(&state->f_attrs, buf, sizeof(struct nfsfattr));
    break;
    
  case  NFS_SETATTR:
    /* setup params for NFS setattr service */
    
    bcopy(&state->f_handle, &sa_args.saa_fh, NFS_FHSIZE);
    bcopy(buf, &sa_args.saa_sa, sizeof(struct nfssattr));
    
    XDR_SETPOS(&xdrs, 0);
    xdr_saargs(&xdrs, &sa_args);
    
    len = MAXRAWLEN;
    if (rpc_call(state->fs_ptr->rpc_setattr_s, raws, XDR_GETPOS(&xdrs),
		 rawr, &len) < 0) {
      printf("nfs_setattr: xcall failed\n");
      return (-1);
E 2
    }
I 2
    TRACE1(xnfsp, 5, "setattr returned, got len=%d\n", len);
    
    XDR_SETPOS(&xdrr, 0);
    xdr_attrstat(&xdrr, &sa_res);
    
    if (sa_res.ns_status != NFS_OK) {
      /* should print error texts later */
      printf("nfs_setattr failed ! err=%d\n", sa_res.ns_status);
      x_errno = sa_res.ns_status;
      return(-1);
    }
    break;
  default:
    x_errno = INVALID_OPCODE;
    return (-1);
    
  }
E 2
}

D 2
static noop() {}
E 2

I 2
static noop()
{
}
     
E 2
static int nfs_ddemux();
D 2

E 2
I 2
     
E 2
nfs_getproc(p,type)
D 2
XObj p;
XobjType type;
E 2
I 2
     XObj p;
     XObjType type;
E 2
{
D 2
  TRACE1(xnfsp, 3, "in nfs getproc, type = %s", type == Session ? "Session" : "Protocol");
E 2
I 2
  TRACE1(xnfsp, 3, "in nfs getproc, type = %s", 
	 type == Session ? "Session" : "Protocol");
E 2
  if (type == Protocol) {
    p->instantiateprotl = nfs_instantiateprotl;
    p->init = nfs_init;
    p->close = noop;
    p->push = noop;
    p->pop = noop;
    p->control = nfs_controlprotl;
  } else {
    p->push = noop;
    p->pop = noop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->close = nfs_close;
    p->control = nfs_controlsessn;
  }
  p->demux = nfs_ddemux;
  p->open = (Pfi) nfs_open;
  p->openenable = noop;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->getproc = nfs_getproc;
  TRACE0(xnfsp, 3, "done nfs getproc");
}

D 2
static int
nfs_ddemux(self, trans, msg)
XObj self;
XObj trans;
MSG msg;
E 2
I 2

static int  nfs_ddemux(self, trans, msg)
     XObj self;
     XObj trans;
     Msg msg;
E 2
{
D 2
   printf("NFS demux called!\n");
E 2
I 2
  printf("NFS demux called!\n");
E 2
}

/************************************
 * Internal Routines
 ************************************/

D 2

int
rpc_call(s, cbuff, clen, rbuff, rlen)
    Sessn           s;
    char           *cbuff;
    unsigned        clen;
    char           *rbuff;
    unsigned       *rlen;
E 2
I 2
int  rpc_call(s, cbuff, clen, rbuff, rlen)
     Sessn           s;
     char           *cbuff;
     unsigned        clen;
     char           *rbuff;
     unsigned       *rlen;
E 2
{
D 2

    int             rpc_result, len;
    MSG             msg;

/*  msg = msg_internalize(cbuff, clen);  version 2 messages */
    msg_make_allstack(msg, 128, cbuff, clen);

    /* push to rpc protocol */
    rpc_result = x_push(s, msg, &msg);
    /*
     * NOTE: rpc_push returns either an error message (result < 0) or a
     * MSG, which contains the reply to the rpc 
     */
    /* NOT in version 3 !!!!! P.D 9/3 */
    if (rpc_result < 0)
	return (rpc_result);	/* error */

    len = msg_len(msg);
    TRACE1(xnfsp, 5, "in rpc_call, got reply, len=%d\n", len);
    assert(len <= *rlen);
    *rlen = len;

/*  msg_externalize(msg, rbuff); version 2 messages */
    msg_peek(msg, 0, len, rbuff);
    msg_free(msg);
    return (0);
E 2
I 2
  
  int	rpc_result, len;
  Msg	msg;
  
  /*  msg = msg_internalize(cbuff, clen);  version 2 messages */
  msg_make_allstack(msg, 128, cbuff, clen);
  
  /* push to rpc protocol */
  rpc_result = x_push(s, msg, &msg);
  /*
   * NOTE: rpc_push returns either an error message (result < 0) or a
   * MSG, which contains the reply to the rpc 
   */
  /* NOT in version 3 !!!!! P.D 9/3 */
  if (rpc_result < 0)
    return (rpc_result);	/* error */
  
  len = msg_len(msg);
  TRACE1(xnfsp, 5, "in rpc_call, got reply, len=%d\n", len);
  assert(len <= *rlen);
  *rlen = len;
  
  /*  msg_externalize(msg, rbuff); version 2 messages */
  msg_peek(msg, 0, len, rbuff);
  msg_free(msg);
  return (0);
E 2
}


unsigned break_tokens(buf, tokens, brk_chars)
D 2
char *buf, *tokens[], *brk_chars;
E 2
I 2
     char *buf, *tokens[], *brk_chars;
E 2
{
D 2
   char *cptr, *strtok();
   unsigned num_tokens=0;

   if ( (cptr=strtok(buf,brk_chars)) == NULL)
   {
E 2
I 2
  char *cptr, *strtok();
  unsigned num_tokens=0;
  
  if ( (cptr=strtok(buf,brk_chars)) == NULL)
    {
E 2
      tokens[0]=NULL;
      return(0);
D 2
   }
   else
      tokens[num_tokens++]=cptr;

   for (cptr=strtok(NULL,brk_chars); cptr!=NULL; cptr=strtok(NULL,brk_chars))
      tokens[num_tokens++]=cptr;

   tokens[num_tokens]=NULL;
   return(num_tokens);

E 2
I 2
    }
  else
    tokens[num_tokens++]=cptr;
  
  for (cptr=strtok(NULL,brk_chars); cptr!=NULL; cptr=strtok(NULL,brk_chars))
    tokens[num_tokens++]=cptr;
  
  tokens[num_tokens]=NULL;
  return(num_tokens);
  
E 2
}


parsepath(pathname, filename, state)
D 2
    char	*pathname;
    char	*filename;
    REMOTEDIR	*state;
E 2
I 2
     char	*pathname;
     char	*filename;
     REMOTEDIR	*state;
E 2
{
D 2
    char	*tmp_path, *tokens[100], *str_save();
    unsigned	i, num_toks;
    int		len;
    struct nfsdiropargs d_args;
    struct nfsdiropres d_res;
    char	file[NFS_MAXNAMLEN];
    char	path[200];
    char	oldpath[200];


    TRACE1(xnfsp, 7, "NFS parsepath 1, path=%s", pathname);
    if ((state->fsptr = getfsys(pathname, filename)) == NULL)
       return(-1);
    TRACE0(xnfsp, 7, "NFS parsepath 2");
    strcpy(oldpath, state->fsptr->pathname);
    TRACE0(xnfsp, 7, "NFS parsepath 3");
    tmp_path = str_save(filename);	/* break_tokens chops */
    TRACE0(xnfsp, 7, "NFS parsepath 4");
    num_toks = break_tokens(tmp_path, tokens, "/");

    TRACE3(xnfsp, 7, "PARSEPATH: path =%s, filename=%s, n=%d\n",
           (char *) filename, tokens[num_toks-1], num_toks);
 
    bcopy(&state->fsptr->fs_handle, &d_args.da_fhandle, NFS_FHSIZE);

    TRACE1(xnfsp, 7, "PARSEPATH: before for  path =%s\n",(char *)filename);
E 2
I 2
  char	*tmp_path, *tokens[100], *str_save();
  unsigned	i, num_toks;
  int		len;
  struct nfsdiropargs d_args;
  struct nfsdiropres d_res;
  char	file[NFS_MAXNAMLEN];
  char	path[200];
  char	oldpath[200];
  
  
  TRACE1(xnfsp, 7, "NFS parsepath 1, path=%s", pathname);
  if ((state->fsptr = getfsys(pathname, filename)) == NULL)
    return(-1);
  TRACE0(xnfsp, 7, "NFS parsepath 2");
  strcpy(oldpath, state->fsptr->pathname);
  TRACE0(xnfsp, 7, "NFS parsepath 3");
  tmp_path = str_save(filename);	/* break_tokens chops */
  TRACE0(xnfsp, 7, "NFS parsepath 4");
  num_toks = break_tokens(tmp_path, tokens, "/");
  
  TRACE3(xnfsp, 7, "PARSEPATH: path =%s, filename=%s, n=%d\n",
	 (char *) filename, tokens[num_toks-1], num_toks);
  
  bcopy(&state->fsptr->fs_handle, &d_args.da_fhandle, NFS_FHSIZE);
  
  TRACE1(xnfsp, 7, "PARSEPATH: before for  path =%s\n",(char *)filename);
  
  for (i = 0; i < (num_toks - 1); i++) {
E 2
    
D 2
    for (i = 0; i < (num_toks - 1); i++) {

        TRACE1(xnfsp, 7,"nfs_open: opening path[%d]", i);
        TRACE1(xnfsp, 7,": %s\n", tokens[i]);

        d_args.da_name = tokens[i];

        XDR_SETPOS(&xdrs, 0);
        xdr_diropargs(&xdrs, &d_args);

        len = MAXRAWLEN;
        TRACE1(xnfsp, 5, "len of xdred diropargs =%d\n", 
		XDR_GETPOS(&xdrs));
        TRACE1(xnfsp, 7, "state->fsptr == %d", state->fsptr);
        if (rpc_call(state->fsptr->rpc_lookup_s, raws, 
		XDR_GETPOS(&xdrs), rawr, &len) < 0) {
	    printf("nfs_lookup: xcall failed\n");
	    return (-1);
        }
        XDR_SETPOS(&xdrr, 0);
        xdr_diropres(&xdrr, &d_res);

        if (d_res.dr_status != NFS_OK) {
	    /* should print error texts later */
	    printf("nfs_lookup failed ! err=%d\n", d_res.dr_status);
            x_errno = d_res.dr_status;
	    return (-1);
        }

E 2
I 2
    TRACE1(xnfsp, 7,"nfs_open: opening path[%d]", i);
    TRACE1(xnfsp, 7,": %s\n", tokens[i]);
    
    d_args.da_name = tokens[i];
    
    XDR_SETPOS(&xdrs, 0);
    xdr_diropargs(&xdrs, &d_args);
    
    len = MAXRAWLEN;
    TRACE1(xnfsp, 5, "len of xdred diropargs =%d\n", 
	   XDR_GETPOS(&xdrs));
    TRACE1(xnfsp, 7, "state->fsptr == %d", state->fsptr);
    if (rpc_call(state->fsptr->rpc_lookup_s, raws, 
		 XDR_GETPOS(&xdrs), rawr, &len) < 0) {
      printf("nfs_lookup: xcall failed\n");
      return (-1);
    }
    XDR_SETPOS(&xdrr, 0);
    xdr_diropres(&xdrr, &d_res);
    
    if (d_res.dr_status != NFS_OK) {
      /* should print error texts later */
      printf("nfs_lookup failed ! err=%d\n", d_res.dr_status);
      x_errno = d_res.dr_status;
      return (-1);
    }
    
E 2
    TRACE1(xnfsp, 7, "PARSEPATH: in for  path =%s\n",(char *)filename);
D 2
        while (d_res.dr_attr.na_mode & S_IFLNK) {
            bcopy(&d_res.dr_fhandle, &state->dhandle, NFS_FHSIZE);
            if (nfs_readlink(state, path) < 0) 
		return(-1);
            if (getpath(oldpath, path) < 0)
		return(-1);
	    if (parsepath(path, file, state) < 0) 
		return(-1);
            strcpy(oldpath, path);
            oldpath[strlen(oldpath) - strlen(file)] = NULL;
            bcopy(&state->dhandle, &d_args.da_fhandle, NFS_FHSIZE);
            d_args.da_name = file;

            XDR_SETPOS(&xdrs, 0);
            xdr_diropargs(&xdrs, &d_args);

            len = MAXRAWLEN;
            if (rpc_call(state->fsptr->rpc_lookup_s, raws, 
		XDR_GETPOS(&xdrs), rawr, &len) < 0) {
	        printf("nfs_lookup: xcall failed\n");
	        return (-1);
            }
            XDR_SETPOS(&xdrr, 0);
            xdr_diropres(&xdrr, &d_res);

            if (d_res.dr_status != NFS_OK) {
	        /* should print error texts later */
	        printf("nfs_lookup failed ! err=%d\n", d_res.dr_status);
                x_errno = d_res.dr_status;
	        return (-1);
            }
        }
        bcopy(&d_res.dr_fhandle, &d_args.da_fhandle, NFS_FHSIZE);
        strcat(oldpath, tokens[i]);
        strcat(oldpath, "/");

    } /* for path components */

    TRACE1(xnfsp, 7, "PARSEPATH: after for  path =%s\n",(char *)filename);
    free(tmp_path);
    strcpy(filename, tokens[num_toks-1]);
    bcopy(&d_args.da_fhandle, &state->dhandle, NFS_FHSIZE);
    return(0);
E 2
I 2
    while (d_res.dr_attr.na_mode & S_IFLNK) {
      bcopy(&d_res.dr_fhandle, &state->dhandle, NFS_FHSIZE);
      if (nfs_readlink(state, path) < 0) 
	return(-1);
      if (getpath(oldpath, path) < 0)
	return(-1);
      if (parsepath(path, file, state) < 0) 
	return(-1);
      strcpy(oldpath, path);
      oldpath[strlen(oldpath) - strlen(file)] = NULL;
      bcopy(&state->dhandle, &d_args.da_fhandle, NFS_FHSIZE);
      d_args.da_name = file;
      
      XDR_SETPOS(&xdrs, 0);
      xdr_diropargs(&xdrs, &d_args);
      
      len = MAXRAWLEN;
      if (rpc_call(state->fsptr->rpc_lookup_s, raws, 
		   XDR_GETPOS(&xdrs), rawr, &len) < 0) {
	printf("nfs_lookup: xcall failed\n");
	return (-1);
      }
      XDR_SETPOS(&xdrr, 0);
      xdr_diropres(&xdrr, &d_res);
      
      if (d_res.dr_status != NFS_OK) {
	/* should print error texts later */
	printf("nfs_lookup failed ! err=%d\n", d_res.dr_status);
	x_errno = d_res.dr_status;
	return (-1);
      }
    }
    bcopy(&d_res.dr_fhandle, &d_args.da_fhandle, NFS_FHSIZE);
    strcat(oldpath, tokens[i]);
    strcat(oldpath, "/");
    
  } /* for path components */
  
  TRACE1(xnfsp, 7, "PARSEPATH: after for  path =%s\n",(char *)filename);
  free(tmp_path);
  strcpy(filename, tokens[num_toks-1]);
  bcopy(&d_args.da_fhandle, &state->dhandle, NFS_FHSIZE);
  return(0);
E 2
}


dosetattr(newfile, blen)
D 2
  struct create	*newfile;
  int		blen;
E 2
I 2
     struct create	*newfile;
     int		blen;
E 2
{
  int			len;
  struct nfsdiropargs	d_args;
  struct nfsdiropres	d_res;
  struct nfssaargs	sa_args;
  struct nfsattrstat	sa_res;
  char			fname[NFS_MAXNAMLEN];
  REMOTEDIR		state;
D 2


E 2
I 2
  
  
E 2
  TRACE0(xnfsp, 3, "in SETATTR !\n");
D 2

E 2
I 2
  
E 2
  if (parsepath(newfile->name, fname, &state) == -1)
D 2
      return(-1);

E 2
I 2
    return(-1);
  
E 2
  /* setup params for NFS lookup service */
  bcopy(&state.dhandle, &d_args.da_fhandle, NFS_FHSIZE);
  d_args.da_name = fname;
D 2

E 2
I 2
  
E 2
  XDR_SETPOS(&xdrs, 0);
  xdr_diropargs(&xdrs, &d_args);
D 2

E 2
I 2
  
E 2
  len = MAXRAWLEN;
  TRACE1(xnfsp, 5, "len of xdred diropargs =%d\n", XDR_GETPOS(&xdrs));
  TRACE1(xnfsp, 7, "state.fsptr == %d", state.fsptr);
  if (rpc_call(state.fsptr->rpc_lookup_s, raws, XDR_GETPOS(&xdrs),
D 2
      rawr, &len) < 0) {
E 2
I 2
	       rawr, &len) < 0) {
E 2
    printf("nfs_lookup: xcall failed\n");
    return (-1);
D 2
    }
E 2
I 2
  }
E 2
  XDR_SETPOS(&xdrr, 0);
  xdr_diropres(&xdrr, &d_res);
D 2

E 2
I 2
  
E 2
  if (d_res.dr_status != NFS_OK) {
    /* should print error texts later */
    printf("nfs_lookup failed ! err=%d\n", d_res.dr_status);
    x_errno = d_res.dr_status;
    return (-1);
  }
D 2

E 2
I 2
  
E 2
  /* setup params for NFS setattr service */
  bcopy(&d_res.dr_fhandle, &sa_args.saa_fh, NFS_FHSIZE);
  sa_args.saa_sa.sa_mode = newfile->mode;
  sa_args.saa_sa.sa_uid = newfile->uid;
  sa_args.saa_sa.sa_gid = newfile->gid;
  sa_args.saa_sa.sa_size = newfile->size;
  sa_args.saa_sa.sa_atime.tv_sec = newfile->atime.tv_sec;
  sa_args.saa_sa.sa_atime.tv_usec = newfile->atime.tv_usec;
  sa_args.saa_sa.sa_mtime.tv_sec = newfile->mtime.tv_sec;
  sa_args.saa_sa.sa_mtime.tv_usec = newfile->mtime.tv_usec;
D 2

E 2
I 2
  
E 2
  XDR_SETPOS(&xdrs, 0);
  xdr_saargs(&xdrs, &sa_args);
D 2

E 2
I 2
  
E 2
  len = MAXRAWLEN;
  if (rpc_call(state.fsptr->rpc_setattr_s, raws, XDR_GETPOS(&xdrs),
D 2
	     rawr, &len) < 0) {
E 2
I 2
	       rawr, &len) < 0) {
E 2
    printf("nfs_setattr: xcall failed\n");
    return (-1);
  }
  TRACE1(xnfsp, 5, "setattr returned, got len=%d\n", len);
D 2

E 2
I 2
  
E 2
  XDR_SETPOS(&xdrr, 0);
  xdr_attrstat(&xdrr, &sa_res);
D 2

E 2
I 2
  
E 2
  if (sa_res.ns_status != NFS_OK) {
    /* should print error texts later */
    printf("nfs_setattr failed ! err=%d\n", sa_res.ns_status);
    x_errno = sa_res.ns_status;
    return (-1);
  }
D 2

E 2
I 2
  
E 2
  TRACE0(xnfsp, 3, "returning from SETATTR\n");
  return (0);
}


domakedir(newfile, blen)
D 2
  struct create	*newfile;
  int		blen;
E 2
I 2
     struct create	*newfile;
     int		blen;
E 2
{
  int			len;
  struct nfscreatargs	mkd_args;
  struct nfsdiropres	mkd_res;
  char			fname[NFS_MAXNAMLEN];
  REMOTEDIR		state;
D 2


E 2
I 2
  
  
E 2
  TRACE0(xnfsp, 3, "in MAKEDIR !\n");
D 2

E 2
I 2
  
E 2
  if (parsepath(newfile->name, fname, &state) == -1)
D 2
	   return(-1);

/*
printf("fname: %s, handle %d\n", fname, state.dhandle);
*/

E 2
I 2
    return(-1);
  
  /*
    printf("fname: %s, handle %d\n", fname, state.dhandle);
    */
  
E 2
  /* setup params for NFS mkdir service */
  bcopy(&state.dhandle, &mkd_args.ca_da.da_fhandle, NFS_FHSIZE);
  mkd_args.ca_da.da_name = fname;
  mkd_args.ca_sa.sa_mode = newfile->mode;
  mkd_args.ca_sa.sa_uid = newfile->uid;
  mkd_args.ca_sa.sa_gid = newfile->gid;
  mkd_args.ca_sa.sa_size = newfile->size;
  mkd_args.ca_sa.sa_atime.tv_sec = newfile->atime.tv_sec;
  mkd_args.ca_sa.sa_atime.tv_usec = newfile->atime.tv_usec;
  mkd_args.ca_sa.sa_mtime.tv_sec = newfile->mtime.tv_sec;
  mkd_args.ca_sa.sa_mtime.tv_usec = newfile->mtime.tv_usec;
D 2

E 2
I 2
  
E 2
  XDR_SETPOS(&xdrs, 0);
  xdr_creatargs(&xdrs, &mkd_args);
D 2

E 2
I 2
  
E 2
  len = MAXRAWLEN;
  if (rpc_call(state.fsptr->rpc_mkdir_s, raws, XDR_GETPOS(&xdrs),
D 2
	     rawr, &len) < 0) {
E 2
I 2
	       rawr, &len) < 0) {
E 2
    printf("nfs_mkdir: xcall failed\n");
    return (-1);
  }
  TRACE1(xnfsp, 5, "mkdir returned, got len=%d\n", len);
D 2

E 2
I 2
  
E 2
  XDR_SETPOS(&xdrr, 0);
  xdr_diropres(&xdrr, &mkd_res);
D 2

E 2
I 2
  
E 2
  if (mkd_res.dr_status != NFS_OK) {
    /* should print error texts later */
    printf("nfs_mkdir failed ! err=%d\n", mkd_res.dr_status);
    x_errno = mkd_res.dr_status;
    return (-1);
  }
D 2

E 2
I 2
  
E 2
  TRACE0(xnfsp, 3, "returning from MKDIR\n");
  return (0);
}


doremove(path, blen)
D 2
  char		*path;
  int		blen;
E 2
I 2
     char		*path;
     int		blen;
E 2
{
  int			len;
  struct nfsdiropargs	rm_args;
  enum nfsstat		rm_res;
  char			fname[NFS_MAXNAMLEN];
  REMOTEDIR		state;
D 2


E 2
I 2
  
  
E 2
  TRACE0(xnfsp, 3, "in REMOVE !\n");
D 2

E 2
I 2
  
E 2
  if (parsepath(path, fname, &state) == -1)
D 2
       return(-1);

E 2
I 2
    return(-1);
  
E 2
  /* setup params for NFS remove service */
  bcopy(&state.dhandle, &rm_args.da_fhandle, NFS_FHSIZE);
  rm_args.da_name =  fname;
D 2

E 2
I 2
  
E 2
  XDR_SETPOS(&xdrs, 0);
  xdr_diropargs(&xdrs, &rm_args);
D 2

E 2
I 2
  
E 2
  len = MAXRAWLEN;
  if (rpc_call(state.fsptr->rpc_remove_s, raws, XDR_GETPOS(&xdrs),
D 2
	     rawr, &len) < 0) {
E 2
I 2
	       rawr, &len) < 0) {
E 2
    printf("nfs_remove: xcall failed\n");
    return (-1);
  }
  TRACE1(xnfsp, 5, "remove returned, got len=%d\n", len);
D 2

E 2
I 2
  
E 2
  XDR_SETPOS(&xdrr, 0);
  xdr_enum(&xdrr, &rm_res);
D 2

E 2
I 2
  
E 2
  if (rm_res != NFS_OK) {
    /* should print error texts later */
    printf("nfs_remove failed ! err=%d\n", rm_res);
    x_errno = rm_res;
    return (-1);
  }
D 2

E 2
I 2
  
E 2
  TRACE0(xnfsp, 3, "returning from REMOVE\n");
  return (0);	/* return status */
}


doremovedir(path, blen)
D 2
  char		*path;
  int		blen;
E 2
I 2
     char		*path;
     int		blen;
E 2
{
  int			len;
  struct nfsdiropargs	rmd_args;
  enum nfsstat		rmd_res;
  char			fname[NFS_MAXNAMLEN];
  REMOTEDIR		state;
D 2


E 2
I 2
  
  
E 2
  TRACE0(xnfsp, 3, "in RMDIR !\n");
D 2

E 2
I 2
  
E 2
  if (parsepath(path, fname, &state) < 0)
D 2
     return(-1);

E 2
I 2
    return(-1);
  
E 2
  /* setup params for NFS rmdir service */
  bcopy(&state.dhandle, &rmd_args.da_fhandle, NFS_FHSIZE);
  rmd_args.da_name = fname;
D 2

E 2
I 2
  
E 2
  XDR_SETPOS(&xdrs, 0);
  xdr_diropargs(&xdrs, &rmd_args);
D 2

E 2
I 2
  
E 2
  len = MAXRAWLEN;
  if (rpc_call(state.fsptr->rpc_rmdir_s, raws, XDR_GETPOS(&xdrs),
D 2
	     rawr, &len) < 0) {
E 2
I 2
	       rawr, &len) < 0) {
E 2
    printf("nfs_rmdir: xcall failed\n");
    return (-1);
  }
  TRACE1(xnfsp, 5, "rmdir returned, got len=%d\n", len);
D 2

E 2
I 2
  
E 2
  XDR_SETPOS(&xdrr, 0);
  xdr_enum(&xdrr, &rmd_res);
D 2

E 2
I 2
  
E 2
  if (rmd_res != NFS_OK) {
    /* should print error texts later */
    printf("nfs_rmdir failed ! err=%d\n", rmd_res);
    x_errno = rmd_res;
    return (-1);
  }
D 2

E 2
I 2
  
E 2
  TRACE0(xnfsp, 3, "returning from RMDIR\n");
  return (0);	/* return status */
}


NFS_F_STATE *getfsys(pathname, remotepath)
D 2
  char	*pathname;
  char	*remotepath;
E 2
I 2
     char	*pathname;
     char	*remotepath;
E 2
{
  int	i,
D 2
	len,
	index,
	length = 0;

E 2
I 2
  len,
  index,
  length = 0;
  
E 2
  TRACE1(xnfsp, 1, "GETFSYS: path=%s\n", pathname);
D 2

E 2
I 2
  
E 2
  for (i=0; i<numfsys; i++) {
    TRACE1(xnfsp, 1, "looking at %s", mtab[i].fs_pathname);
    if (isprefix(mtab[i].fs_pathname, pathname)) {
      if (length < (len = strlen(mtab[i].fs_pathname))) {
        length = len;
        index = i;
D 2
        }
E 2
      }
    }
D 2

E 2
I 2
  }
  
E 2
  if (length == 0) {
    printf("GETFSYS: unknown file system - %s\n", pathname);
    return(NULL);
  }
D 2

E 2
I 2
  
E 2
  strcpy(remotepath, pathname + strlen(mtab[index].fs_pathname));
D 2
/*
  printf("GETFSYS: known file system - %s\n", mtab[index].fs_pathname);
  printf("         fs_ptr is %d\n", mtab[index].fs_ptr);
*/
E 2
I 2
  /*
    printf("GETFSYS: known file system - %s\n", mtab[index].fs_pathname);
    printf("         fs_ptr is %d\n", mtab[index].fs_ptr);
    */
E 2
  return(mtab[index].fs_ptr);
}


isprefix(prefix, string)
D 2
  char	*prefix,
	*string;
E 2
I 2
     char	*prefix, *string;
E 2
{
  while (*prefix != '\0')
    if ((*string == '\0') || (*(prefix++) != *(string++))) return(FALSE);
D 2

E 2
I 2
  
E 2
  return(TRUE);
}


D 2


E 2
dolink(buf, blen )
D 2
char       *buf;
int        blen;
E 2
I 2
     char       *buf;
     int        blen;
E 2
{
D 2
   
    int             len;
    char            sfilename[NFS_MAXNAMLEN], tfilename[NFS_MAXNAMLEN];
    struct nfslinkargs l_args;
    struct nfsdiropres  d_res;
    struct nfsdiropargs d_args;
    struct xlinkargs    *xlargs;
    enum   nfsstat      link_res;
    REMOTEDIR      tdir, sdir;


    xlargs = (struct xlinkargs *) buf;
    TRACE1(xnfsp, 3, "in LINK with len=%d!\n", blen);

    /* NFS LINK */

    if (getfsys(xlargs->from) != getfsys(xlargs->to)) {
       printf("NFS Error: Link Failed Not Same Filesystem\n");
       return(-1);
    }
    if (parsepath(xlargs->from, sfilename, &sdir)  == -1)
       return(-1);

    if (parsepath(xlargs->to, tfilename, &tdir) == -1)  
       return(-1); 

    d_args.da_name = tfilename;
    bcopy(&tdir.dhandle, &d_args.da_fhandle, NFS_FHSIZE);

    XDR_SETPOS(&xdrs, 0);
    xdr_diropargs(&xdrs, &d_args);
    len = MAXRAWLEN;
    if (rpc_call(sdir.fsptr->rpc_lookup_s, raws, XDR_GETPOS(&xdrs),
		rawr, &len) < 0) {
       printf("nfs LINK : Lookup  failed Source file error\n");
				      /* ERROR in SOURCE */
       return(-1);
    }

    /* set up args for linking  */

    XDR_SETPOS(&xdrr, 0);

    xdr_diropres(&xdrr, &d_res);
    if (d_res.dr_status != NFS_OK ) {
       printf("LINK_LOOKUP failed errno: %d\n", d_res.dr_status);
       x_errno = d_res.dr_status;
       return(-1);
    }
    bcopy(&d_res.dr_fhandle, &l_args.la_from, NFS_FHSIZE); 
    bcopy(&sdir.dhandle, &l_args.la_to.da_fhandle, NFS_FHSIZE);
    l_args.la_to.da_name = sfilename; 

    XDR_SETPOS(&xdrs, 0);
    xdr_linkargs(&xdrs, &l_args);
    len = MAXRAWLEN;

    /* Call to NFS link routine */

    if (rpc_call(tdir.fsptr->rpc_link_s, raws, XDR_GETPOS(&xdrs),
                 rawr, &len) < 0) {
       printf("nfs link: xcall failed\n");
       return(-1);
    }

    XDR_SETPOS(&xdrr, 0);

    xdr_enum(&xdrr, &link_res);

    if (link_res != NFS_OK) {
       printf("LINK failed errno: %d\n", link_res);
       x_errno = d_res.dr_status;
       return(-1);
    }

    return(0);
E 2
I 2
  int             len;
  char            sfilename[NFS_MAXNAMLEN], tfilename[NFS_MAXNAMLEN];
  struct nfslinkargs l_args;
  struct nfsdiropres  d_res;
  struct nfsdiropargs d_args;
  struct xlinkargs    *xlargs;
  enum   nfsstat      link_res;
  REMOTEDIR      tdir, sdir;
  
  
  xlargs = (struct xlinkargs *) buf;
  TRACE1(xnfsp, 3, "in LINK with len=%d!\n", blen);
  
  /* NFS LINK */
  
  if (getfsys(xlargs->from) != getfsys(xlargs->to)) {
    printf("NFS Error: Link Failed Not Same Filesystem\n");
    return(-1);
  }
  if (parsepath(xlargs->from, sfilename, &sdir)  == -1)
    return(-1);
  
  if (parsepath(xlargs->to, tfilename, &tdir) == -1)  
    return(-1); 
  
  d_args.da_name = tfilename;
  bcopy(&tdir.dhandle, &d_args.da_fhandle, NFS_FHSIZE);
  
  XDR_SETPOS(&xdrs, 0);
  xdr_diropargs(&xdrs, &d_args);
  len = MAXRAWLEN;
  if (rpc_call(sdir.fsptr->rpc_lookup_s, raws, XDR_GETPOS(&xdrs),
	       rawr, &len) < 0) {
    printf("nfs LINK : Lookup  failed Source file error\n");
    /* ERROR in SOURCE */
    return(-1);
  }
  
  /* set up args for linking  */
  
  XDR_SETPOS(&xdrr, 0);
  
  xdr_diropres(&xdrr, &d_res);
  if (d_res.dr_status != NFS_OK ) {
    printf("LINK_LOOKUP failed errno: %d\n", d_res.dr_status);
    x_errno = d_res.dr_status;
    return(-1);
  }
  bcopy(&d_res.dr_fhandle, &l_args.la_from, NFS_FHSIZE); 
  bcopy(&sdir.dhandle, &l_args.la_to.da_fhandle, NFS_FHSIZE);
  l_args.la_to.da_name = sfilename; 
  
  XDR_SETPOS(&xdrs, 0);
  xdr_linkargs(&xdrs, &l_args);
  len = MAXRAWLEN;
  
  /* Call to NFS link routine */
  
  if (rpc_call(tdir.fsptr->rpc_link_s, raws, XDR_GETPOS(&xdrs),
	       rawr, &len) < 0) {
    printf("nfs link: xcall failed\n");
    return(-1);
  }
  
  XDR_SETPOS(&xdrr, 0);
  
  xdr_enum(&xdrr, &link_res);
  
  if (link_res != NFS_OK) {
    printf("LINK failed errno: %d\n", link_res);
    x_errno = d_res.dr_status;
    return(-1);
  }
  
  return(0);
E 2
}


doreadlink(path, blen)
D 2
char       *path;
int        blen;
E 2
I 2
     char       *path;
     int        blen;
E 2
{
D 2
    int             len;
    struct nfsdiropres  d_res;
    struct nfsdiropargs d_args;
    REMOTEDIR      state;
    char	filename[NFS_MAXNAMLEN];


    if (parsepath(path, filename, &state)  == -1)
       return(-1);

    d_args.da_name = path;
    bcopy(&state.dhandle, &d_args.da_fhandle, NFS_FHSIZE);

    XDR_SETPOS(&xdrs, 0);
    xdr_diropargs(&xdrs, &d_args);
    len = MAXRAWLEN;
    if (rpc_call(state.fsptr->rpc_lookup_s, raws, XDR_GETPOS(&xdrs),
		rawr, &len) < 0) {
       printf("nfs LINK : Lookup  failed Source file error\n");
				      /* ERROR in SOURCE */
       return(-1);
    }

    XDR_SETPOS(&xdrr, 0);
    xdr_diropres(&xdrr, &d_res);

    if (d_res.dr_status != NFS_OK ) {
       printf("READLINK_LOOKUP failed errno: %d\n", d_res.dr_status);
       x_errno = d_res.dr_status;
       return(-1);
    }

    bcopy(&d_res.dr_fhandle, &state.dhandle, NFS_FHSIZE); 

    if (readlink(&state, path) < 0)
       return(-1);

    blen = strlen(path);
    return(0);
E 2
I 2
  int             len;
  struct nfsdiropres  d_res;
  struct nfsdiropargs d_args;
  REMOTEDIR      state;
  char	filename[NFS_MAXNAMLEN];
  
  
  if (parsepath(path, filename, &state)  == -1)
    return(-1);
  
  d_args.da_name = path;
  bcopy(&state.dhandle, &d_args.da_fhandle, NFS_FHSIZE);
  
  XDR_SETPOS(&xdrs, 0);
  xdr_diropargs(&xdrs, &d_args);
  len = MAXRAWLEN;
  if (rpc_call(state.fsptr->rpc_lookup_s, raws, XDR_GETPOS(&xdrs),
	       rawr, &len) < 0) {
    printf("nfs LINK : Lookup  failed Source file error\n");
    /* ERROR in SOURCE */
    return(-1);
  }
  
  XDR_SETPOS(&xdrr, 0);
  xdr_diropres(&xdrr, &d_res);
  
  if (d_res.dr_status != NFS_OK ) {
    printf("READLINK_LOOKUP failed errno: %d\n", d_res.dr_status);
    x_errno = d_res.dr_status;
    return(-1);
  }
  
  bcopy(&d_res.dr_fhandle, &state.dhandle, NFS_FHSIZE); 
  
  if (readlink(&state, path) < 0)
    return(-1);
  
  blen = strlen(path);
  return(0);
E 2
}


nfs_readlink(state,  path)
D 2
REMOTEDIR  *state;
char       *path;
E 2
I 2
     REMOTEDIR  *state;
     char       *path;
E 2
{
D 2

   struct nfsrdlnres rl_res; 
   int               len;
   int               i;

   XDR_SETPOS(&xdrs, 0);
   xdr_fhandle(&xdrs, &state->dhandle);
   TRACE0(xnfsp, 3,  "in READ LINK ");

   /*    NFS READLINK */
   len = MAXRAWLEN;

   if (rpc_call(state->fsptr->rpc_readlink_s, raws, XDR_GETPOS(&xdrs),
		rawr, &len) < 0) {
      printf("nfs:  READLINK call failed\n");
      return(-1);
   }

   /*  READLLINK RESULTS */
   rl_res.rl_data = path;
   XDR_SETPOS(&xdrr, 0);
   xdr_rdlnres(&xdrr, &rl_res);
   if (rl_res.rl_status == NFS_OK) {
      path[rl_res.rl_count] = NULL;
      return(0);
   } else {
     printf("READLINK failed errno: %d\n", rl_res.rl_status);
     x_errno = rl_res.rl_status;
     return(-1);
   }
E 2
I 2
  
  struct nfsrdlnres rl_res; 
  int               len;
  int               i;
  
  XDR_SETPOS(&xdrs, 0);
  xdr_fhandle(&xdrs, &state->dhandle);
  TRACE0(xnfsp, 3,  "in READ LINK ");
  
  /*    NFS READLINK */
  len = MAXRAWLEN;
  
  if (rpc_call(state->fsptr->rpc_readlink_s, raws, XDR_GETPOS(&xdrs),
	       rawr, &len) < 0) {
    printf("nfs:  READLINK call failed\n");
    return(-1);
  }
  
  /*  READLLINK RESULTS */
  rl_res.rl_data = path;
  XDR_SETPOS(&xdrr, 0);
  xdr_rdlnres(&xdrr, &rl_res);
  if (rl_res.rl_status == NFS_OK) {
    path[rl_res.rl_count] = NULL;
    return(0);
  } else {
    printf("READLINK failed errno: %d\n", rl_res.rl_status);
    x_errno = rl_res.rl_status;
    return(-1);
  }
E 2
} 


dorename(buf, blen)
D 2
char     *buf;
int      blen;
E 2
I 2
     char     *buf;
     int      blen;
E 2
{
D 2
   struct   xlinkargs  *xlargs = (struct xlinkargs *) buf;
   struct   REMOTEDIR sdir, tdir;
   char     sfilename[NFS_MAXNAMLEN], tfilename[NFS_MAXNAMLEN];
   struct   nfsrnmargs  rnm_args;
   enum    nfsstat     rnm_res;
   int      len;


   
/*
   printf("IN RENAME from %s to %s\n", xlargs->from, xlargs->to);
*/
   if (parsepath(xlargs->from, sfilename, &sdir)  == -1)
      return(-1);
   if (parsepath(xlargs->to, tfilename, &tdir) == -1)
      return(-1);
   

   bcopy(&sdir.dhandle, &rnm_args.rna_from.da_fhandle, NFS_FHSIZE);
   rnm_args.rna_from.da_name = sfilename;
   bcopy(&tdir.dhandle, &rnm_args.rna_to.da_fhandle, NFS_FHSIZE);
   rnm_args.rna_to.da_name = tfilename;

   XDR_SETPOS(&xdrs, 0);
   xdr_rnmargs(&xdrs, &rnm_args);
   len = MAXRAWLEN;

   /* Make RPC RENAME call */

   if (rpc_call(sdir.fsptr->rpc_rename_s, raws, XDR_GETPOS(&xdrs),
		rawr, &len) < 0 ) {
      printf("NFS_RENAME: rpc RENAME call failed \n");
      return(-1);
   }

   XDR_SETPOS(&xdrr, 0);
   xdr_enum(&xdrr, &rnm_res);

   if  (rnm_res != NFS_OK)  {
      printf("RENAME failed errno: %d\n", rnm_res);
      x_errno = rnm_res;
      return(-1);
   }

   return(0);
E 2
I 2
  struct   xlinkargs  *xlargs = (struct xlinkargs *) buf;
  struct   REMOTEDIR sdir, tdir;
  char     sfilename[NFS_MAXNAMLEN], tfilename[NFS_MAXNAMLEN];
  struct   nfsrnmargs  rnm_args;
  enum    nfsstat     rnm_res;
  int      len;
  
  
  
  /*
    printf("IN RENAME from %s to %s\n", xlargs->from, xlargs->to);
    */
  if (parsepath(xlargs->from, sfilename, &sdir)  == -1)
    return(-1);
  if (parsepath(xlargs->to, tfilename, &tdir) == -1)
    return(-1);
  
  
  bcopy(&sdir.dhandle, &rnm_args.rna_from.da_fhandle, NFS_FHSIZE);
  rnm_args.rna_from.da_name = sfilename;
  bcopy(&tdir.dhandle, &rnm_args.rna_to.da_fhandle, NFS_FHSIZE);
  rnm_args.rna_to.da_name = tfilename;
  
  XDR_SETPOS(&xdrs, 0);
  xdr_rnmargs(&xdrs, &rnm_args);
  len = MAXRAWLEN;
  
  /* Make RPC RENAME call */
  
  if (rpc_call(sdir.fsptr->rpc_rename_s, raws, XDR_GETPOS(&xdrs),
	       rawr, &len) < 0 ) {
    printf("NFS_RENAME: rpc RENAME call failed \n");
    return(-1);
  }
  
  XDR_SETPOS(&xdrr, 0);
  xdr_enum(&xdrr, &rnm_res);
  
  if  (rnm_res != NFS_OK)  {
    printf("RENAME failed errno: %d\n", rnm_res);
    x_errno = rnm_res;
    return(-1);
  }
  
  return(0);
E 2
}


dosymlink(buf, blen)
D 2
char    *buf;
int     blen;
E 2
I 2
     char    *buf;
     int     blen;
E 2
{
D 2
   struct  xsymlinkargs  *xslargs;
   char    source[NFS_MAXNAMLEN], test[NFS_MAXNAMLEN];
   REMOTEDIR sdir;
   int     len;
   struct  nfsslargs     sl_args;
   enum    nfsstat       sym_res;

   xslargs = (struct xsymlinkargs *) buf;
   if (parsepath(xslargs->from, source, &sdir) == -1)
      return(-1);
   bcopy(&sdir.dhandle, &sl_args.sla_from.da_fhandle, NFS_FHSIZE);
/*
   printf("SYMLINK:  from  %s to %s\n", source, xslargs->to);
*/
   sl_args.sla_from.da_name = source;
   sl_args.sla_tnm = xslargs->to;
   bcopy(&xslargs->sattr, &sl_args.sla_sa, sizeof(struct nfssattr));

   XDR_SETPOS(&xdrs, 0);
   xdr_slargs(&xdrs, &sl_args);

   len = MAXRAWLEN;

   if (rpc_call(sdir.fsptr->rpc_symlink_s, raws, XDR_GETPOS(&xdrs),
                rawr, &len) < 0)  {
      printf("NFS_SYMLINK: rpc_call SYMLINK  failed\n");
      return(-1);
   }

   XDR_SETPOS(&xdrr, 0);
   xdr_enum(&xdrr, &sym_res);

   if  (sym_res != NFS_OK)  {
      printf("SYMLINK failed errno: %d\n", sym_res);
      x_errno = sym_res;
      return(-1);
   }

   return(0);
E 2
I 2
  struct  xsymlinkargs  *xslargs;
  char    source[NFS_MAXNAMLEN], test[NFS_MAXNAMLEN];
  REMOTEDIR sdir;
  int     len;
  struct  nfsslargs     sl_args;
  enum    nfsstat       sym_res;
  
  xslargs = (struct xsymlinkargs *) buf;
  if (parsepath(xslargs->from, source, &sdir) == -1)
    return(-1);
  bcopy(&sdir.dhandle, &sl_args.sla_from.da_fhandle, NFS_FHSIZE);
  /*
    printf("SYMLINK:  from  %s to %s\n", source, xslargs->to);
    */
  sl_args.sla_from.da_name = source;
  sl_args.sla_tnm = xslargs->to;
  bcopy(&xslargs->sattr, &sl_args.sla_sa, sizeof(struct nfssattr));
  
  XDR_SETPOS(&xdrs, 0);
  xdr_slargs(&xdrs, &sl_args);
  
  len = MAXRAWLEN;
  
  if (rpc_call(sdir.fsptr->rpc_symlink_s, raws, XDR_GETPOS(&xdrs),
	       rawr, &len) < 0)  {
    printf("NFS_SYMLINK: rpc_call SYMLINK  failed\n");
    return(-1);
  }
  
  XDR_SETPOS(&xdrr, 0);
  xdr_enum(&xdrr, &sym_res);
  
  if  (sym_res != NFS_OK)  {
    printf("SYMLINK failed errno: %d\n", sym_res);
    x_errno = sym_res;
    return(-1);
  }
  
  return(0);
E 2
}

doreaddir(buf, blen)
D 2
char   *buf;
int    blen;
E 2
I 2
     char   *buf;
     int    blen;
E 2
{
  int			len, i;
  struct rddir          *rddir_args;
  struct readdirres	rd_res;
  struct nfsrddirargs	rd_ar;
  struct nfsdiropargs	d_args;
  struct nfsdiropres	d_res;
  struct entry		*head;
  char			fname[NFS_MAXNAMLEN];
  REMOTEDIR		state;
D 2


E 2
I 2
  
  
E 2
  TRACE0(xnfsp, 3, "in READDIR !\n");
D 2

E 2
I 2
  
E 2
  rddir_args = (struct rddir *) buf;
  if (parsepath(rddir_args->name, fname, &state) < 0)
D 2
     return(-1);

E 2
I 2
    return(-1);
  
E 2
  /* setup params for NFS lookup service */
  bcopy(&state.dhandle, &d_args.da_fhandle, NFS_FHSIZE);
  d_args.da_name = fname;
D 2

E 2
I 2
  
E 2
  XDR_SETPOS(&xdrs, 0);
  xdr_diropargs(&xdrs, &d_args);
D 2

E 2
I 2
  
E 2
  len = MAXRAWLEN;
  TRACE1(xnfsp, 5, "len of xdred diropargs =%d\n", XDR_GETPOS(&xdrs));
  TRACE1(xnfsp, 7, "state.fsptr == %d", state.fsptr);
  if (rpc_call(state.fsptr->rpc_lookup_s, raws, XDR_GETPOS(&xdrs),
D 2
      rawr, &len) < 0) {
E 2
I 2
	       rawr, &len) < 0) {
E 2
    printf("nfs_lookup: xcall failed\n");
    return (-1);
D 2
    }
E 2
I 2
  }
E 2
  XDR_SETPOS(&xdrr, 0);
  xdr_diropres(&xdrr, &d_res);
D 2

E 2
I 2
  
E 2
  if (d_res.dr_status != NFS_OK) {
    /* should print error texts later */
    printf("nfs_lookup failed ! err=%d\n", d_res.dr_status);
    x_errno = d_res.dr_status;
    return (-1);
  }
D 2

E 2
I 2
  
E 2
  /* setup params for NFS readdir service */
D 2

E 2
I 2
  
E 2
  XDR_SETPOS(&xdrs, 0);
  rd_ar.rda_fh    = d_res.dr_fhandle;
  rd_ar.rda_offset= rddir_args->offs;
  rd_ar.rda_count = rddir_args->nbytes;
  xdr_nfsrddirargs(&xdrs, &rd_ar);
D 2

E 2
I 2
  
E 2
  len = MAXRAWLEN;
  if (rpc_call(state.fsptr->rpc_readdir_s, raws, XDR_GETPOS(&xdrs),
D 2
	     rawr, &len) < 0) {
E 2
I 2
	       rawr, &len) < 0) {
E 2
    printf("nfs_readdir: xcall failed\n");
    return (-1);
  }
D 2

E 2
I 2
  
E 2
  XDR_SETPOS(&xdrr, 0);
D 2

E 2
I 2
  
E 2
  rd_res.readdirres_u.reply.entries=(struct entry *)
D 2
                                    malloc(sizeof(struct entry)*MAX_DIRENTRY);

E 2
I 2
    malloc(sizeof(struct entry)*MAX_DIRENTRY);
  
E 2
  bzero(rd_res.readdirres_u.reply.entries,(sizeof(struct entry)*MAX_DIRENTRY));
  xdr_nfsrddirres(&xdrr, &rd_res);
D 2

E 2
I 2
  
E 2
  if (rd_res.status != NFS_OK) {
    /* should print error texts later */
    printf("nfs_readdir failed ! err=%d\n", rd_res.status);
    x_errno = rd_res.status;
    return (-1);
  }
  head = rd_res.readdirres_u.reply.entries;
  i = 0;
  while (head != NULL) {
D 2
        strcpy(rddir_args->direct[i].name, head->name);
        rddir_args->direct[i].fileid= head->fileid;
        head = head->nextentry;
        i++;
E 2
I 2
    strcpy(rddir_args->direct[i].name, head->name);
    rddir_args->direct[i].fileid= head->fileid;
    head = head->nextentry;
    i++;
E 2
  }
D 2
/*
 *  Use one of the input args, to return # of entries;
 */
E 2
I 2
  /*
   *  Use one of the input args, to return # of entries;
   */
E 2
  rddir_args->nbytes = i;
D 2

E 2
I 2
  
E 2
  TRACE0(xnfsp, 3, "returning from READDIR\n");
  return (0);
}



dogetattr(buf, blen)
D 2
char   *buf;
int    blen;
E 2
I 2
     char   *buf;
     int    blen;
E 2
{
  int			len;
  struct create         *gattr_args;
  struct nfsdiropargs	d_args;
  struct nfsdiropres	d_res;
  struct nfssaargs	sa_args;
  struct nfsattrstat	sa_res;
  char			fname[NFS_MAXNAMLEN];
  REMOTEDIR		state;
D 2


E 2
I 2
  
  
E 2
  TRACE0(xnfsp, 3, "in GETATTR !\n");
D 2

E 2
I 2
  
E 2
  gattr_args = (struct create *) buf;
  if (parsepath(gattr_args->name, fname, &state) == -1)
D 2
     return(-1);

E 2
I 2
    return(-1);
  
E 2
  /* setup params for NFS lookup service */
  bcopy(&state.dhandle, &d_args.da_fhandle, NFS_FHSIZE);
  d_args.da_name = fname;
D 2

E 2
I 2
  
E 2
  XDR_SETPOS(&xdrs, 0);
  xdr_diropargs(&xdrs, &d_args);
D 2

E 2
I 2
  
E 2
  len = MAXRAWLEN;
  TRACE1(xnfsp, 5, "len of xdred diropargs =%d\n", XDR_GETPOS(&xdrs));
  TRACE1(xnfsp, 7, "state.fsptr == %d", state.fsptr);
  if (rpc_call(state.fsptr->rpc_lookup_s, raws, XDR_GETPOS(&xdrs),
D 2
      rawr, &len) < 0) {
E 2
I 2
	       rawr, &len) < 0) {
E 2
    printf("nfs_lookup: xcall failed\n");
    return (-1);
D 2
    }
E 2
I 2
  }
E 2
  XDR_SETPOS(&xdrr, 0);
  xdr_diropres(&xdrr, &d_res);
D 2

E 2
I 2
  
E 2
  if (d_res.dr_status != NFS_OK) {
    /* should print error texts later */
    printf("nfs_lookup failed ! err=%d\n", d_res.dr_status);
    x_errno = d_res.dr_status;
    return (-1);
  }
D 2

E 2
I 2
  
E 2
  /* setup params for NFS setattr service */
D 2

E 2
I 2
  
E 2
  XDR_SETPOS(&xdrs, 0);
D 2

E 2
I 2
  
E 2
  xdr_fhandle(&xdrs, &d_res.dr_fhandle);
D 2

E 2
I 2
  
E 2
  len = MAXRAWLEN;
  if (rpc_call(state.fsptr->rpc_getattr_s, raws, XDR_GETPOS(&xdrs),
D 2
	     rawr, &len) < 0) {
E 2
I 2
	       rawr, &len) < 0) {
E 2
    printf("nfs_setattr: xcall failed\n");
    return (-1);
  }
D 2

E 2
I 2
  
E 2
  XDR_SETPOS(&xdrr, 0);
  xdr_attrstat(&xdrr, &sa_res);
D 2

E 2
I 2
  
E 2
  if (sa_res.ns_status != NFS_OK) {
    /* should print error texts later */
    printf("nfs_setattr failed ! err=%d\n", sa_res.ns_status);
    x_errno = sa_res.ns_status;
    return (-1);
  }
  gattr_args->mode = sa_res.ns_attr.na_mode;
  gattr_args->uid = sa_res.ns_attr.na_uid;
  gattr_args->gid = sa_res.ns_attr.na_gid;
  gattr_args->size = sa_res.ns_attr.na_size;
  gattr_args->atime.tv_sec = sa_res.ns_attr.na_atime.tv_sec;
  gattr_args->atime.tv_usec = sa_res.ns_attr.na_atime.tv_usec;
  gattr_args->mtime.tv_sec = sa_res.ns_attr.na_mtime.tv_sec;
  gattr_args->mtime.tv_usec = sa_res.ns_attr.na_mtime.tv_usec;
D 2

E 2
I 2
  
E 2
  TRACE0(xnfsp, 3, "returning from SETATTR\n");
  return (0);
}


getpath(fullpath, newpath)
D 2
  char	*fullpath,
	*newpath;
E 2
I 2
     char	*fullpath, *newpath;
E 2
{
  int	numtoks,
D 2
	i,
	j;
E 2
I 2
  i,
  j;
E 2
  char	*token[100],
D 2
	tmp[200];


E 2
I 2
  tmp[200];
  
  
E 2
  if (*newpath == '/') {
    if (isprefix("/r/", newpath))
      strcpy(tmp, newpath);
    else {
      strncpy(tmp, fullpath, REMOTESIZE);
      tmp[REMOTESIZE]=NULL;
      strcat(tmp, newpath);
    }
  }
  else {
    strcpy(tmp, fullpath);
    strcat(tmp, newpath);
  }
D 2

E 2
I 2
  
E 2
  numtoks = break_tokens(tmp, token, "/");
D 2

E 2
I 2
  
E 2
  for (i=0; i<numtoks; i++) {
    if (token[i][0] == '.') {
      if (token[i][1] == '.' && token[i][2] == '\0') {
        if (i == 0) {
          printf("BAD PATH\n");
          return(-1);
        }
        for (j=i+1; j<numtoks; j++)
          token[j-2] = token[j];
        token[j-2] = NULL;
        i -= 2;
        numtoks -= 2;
      }
      else if (token[i][1] == '\0') {
        for (j=i+1; j<numtoks; j++)
          token[j-1] = token[j];
        token[j-1] = NULL;
        i--;
        numtoks--;
      }
    }
  }
D 2

E 2
I 2
  
E 2
  *newpath = NULL;
  for (i=0; i<numtoks; i++) {
    strcat(newpath, "/");
    strcat(newpath, token[i]);
  }
D 2

E 2
I 2
  
E 2
  return(0);
}

E 1
