/*
 * pmap1.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include <rpc/rpc.h>
#include "xkernel.h"
#include "ip.h"
#include "udp.h"
#include "sun_rpc.h"
#include "pmap.h"
#include "pmap_internal.h"

int *pmapproc_set();

static XObj SELF=0;
#define SUNRPC SELF->down[0]
#define IP SELF->down[1]
#define PMAP1 SELF
int tracepmap1p=0;

static pmap1_instantiateprotl(self) 
XObj self;
{
  TRACE0(pmap1p, 1, "PMAP1 instanciateprotl");

  if (SELF) {
    Kabort("SUN Portmapper 1: can't instanciate twice");
  }
  SELF = self;
  return 0;
}

static pmap1_init(self)
XObj self;
{

  Part part[2];
  SUNRPCaddr server;
  IPhost myipaddr;


  if (x_controlprotl(IP, GETMYADDR, (char *)&myipaddr, sizeof myipaddr) < 0) {
    printf("Can't find my IP addr\n");
    return(-1);
  }


  /* create address */
  server.prog = PMAP_PROG;
  server.vers = PMAP_VERS;
  server.proc = PMAPPROC_SET;
  server.prot = 17;
  server.host.port = PMAP_PORT;  
  server.host.host = myipaddr;
 
  init_partlist(part, 1, SUNRPCaddr); 
  set_part(part, 0, server);
  x_openenable(PMAP1, SUNRPC, part);
  return(0);
}


static pmap1_demux(self,s, msg)
XObj	self,s;
Msg msg;
{
  char *buf;
  int len;
  char buf2[100];
  int len2;
  PMAP_ARGS args;
  int *results;
  Msg msg2;
  

  /* externalize message */
  len = msg_len(msg);
  buf = (char *) malloc(len + 2);
  msg_externalize(msg,buf);


  /* check authentication */


  /* decode arguments */
  if (decode_xdr(xdr_pmap,buf,len,&args) == -1) {;
    x_controlsessn(s, SUNRPC_SVCGARBAGEARGS,0,0);
    return(-1);
  }
  

  /* call procedure */ 
  results = pmapproc_set(&args);
  

  /* xdr results */
  if (results != 0) { 
    if ((len2 = encode_xdr(xdr_bool,buf2,100,results)) == -1) {;
      x_controlsessn(s, SUNRPC_SVCGARBAGEARGS,0,0);
      free(results);
      return(-1);
    } else {
      free(results);
    }
  } else {
    x_controlsessn(s, SUNRPC_SVCSYSTEMERR,0,0);
    return(-1);
  }

  /* set authentication */

  IFTRACE(pmap1p,7) {
  printf("server_demux: len2 = %d buf2 = %d\n",len2,buf2);
  print_xdr(buf2,len);
  }

  /* internalize message */
   msg_make_allstack(msg2,256,buf2,len2);
  
  /* reply to call */
  x_push(s,msg2,(Msg *)0);
  free(buf);
  return(0);
}

static pmap1_opendone(self,s,part)
XObj s,self;
Part part;
{
  TRACE0(pmap1p,7,"--->pmap1_opendone");
}
static int *pmapproc_set(args)
PMAP_ARGS *args;
{
  PMAP_EXT_ID ext_id;
  int *reply;


  TRACE0(pmap1p,1,"pmap_set: entered\n");
  IFTRACE(pmap1p,1) print_pmap(args);
  ext_id.prog = args->prog;
  ext_id.vers = args->vers;
  ext_id.prot = args->prot;
  TRACE0(pmap1p,7,"pmap_set: args transfered\n");
  reply = (int *) malloc(sizeof(int));
  if (map_bind(port_map,&ext_id,args->port) == (Bind) -1 ) {
    TRACE0(pmap1p,3,"pmap_set: bind fails\n");
    *reply = 0;
    return(reply);
  }
  TRACE0(pmap1p,3,"pmap_set: bind succeeds\n");
  *reply = 1;
  return(reply);
}

pmap1_getproc(p,type)
XObj p;
XObjType type;
{
  if (type == Protocol) {
    p->instantiateprotl = pmap1_instantiateprotl;
    p->init = pmap1_init;
  } else {
    p->instantiateprotl = noop;
    p->init = noop;
  }
  p->close = noop;
  p->control = noop;
  p->push = noop; 
  p->pop = noop;
  p->open = (Pfi) noop;
  p->openenable = noop;
  p->opendone = pmap1_opendone;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = pmap1_demux;
  p->getproc = pmap1_getproc;
}

