h52619
s 00088/00112/00055
d D 1.2 91/01/10 12:11:54 llp 2 1
c Prepared for 3.1 Distribution
e
s 00167/00000/00000
d D 1.1 90/11/16 13:05:55 menze 1 0
c date and time created 90/11/16 13:05:55 by menze
e
u
U
f e 0
t
T
I 1
D 2

E 2
/* 
 * spc_srvr.c
 *
 * x-kernel v3.1	12/10/90
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */

D 2

E 2
#include "xkernel.h"
#include "ip.h"
D 2
#include "rpcTypes.h"
E 2
#include "spc.h"
#include "spc_internal.h"


D 2





E 2
/*
 * SPC_OPENENABLE
 *
 * This will only be invoked by "server protocols" (clients will do opens).
 * This will perform a trivial open (the substantial open
 * involves channel states and happens in spc_srvr_chan_demux).
 */
I 2

E 2
spc_openenable( self, higher_level_protl, participants )
D 2
XObj	self;
XObj	higher_level_protl;
Part*	participants;
E 2
I 2
     XObj	self;
     XObj	higher_level_protl;
     Part*	participants;
E 2
{
D 2
SrvrId	srvrId;
XObj		sessn;
SPCstate*	state_ptr;


	/* check whether a sessn for this service proc already exists */
	srvrId = ((SPCaddr*) participants[0].address) ->srvrId;
	TRACE1(spcp,2,"spc_openenable (srvrId=%d)",srvrId);
	sessn = (XObj) map_resolve( Srvr_map, (char*) &srvrId );
	if( sessn != ERR_XOBJ ){

		/* this openenable conflicts with a previous one */
		TRACE1(spcp,1,"spc_openenable: service proc %d already openenabled",
															srvrId);
		x_errno = ALREADY_OPEN;
		return( ERR );
	}

	/* this service proc has not had a previous openenable */
	/* do a mini-open: construct and bind a new sessn */

	/* construct a new sessn */
	sessn = x_createsession( higher_level_protl, SPC_SELF, 1 );
	TRACE0(spcp,5,"spc_openenable: got past createsession");
	sessn->rcnt = 1;	/* is this necessary? */

	/* build a state for this sessn */
	state_ptr = (SPCstate*) malloc( sizeof( SPCstate ) );
	state_ptr->is_clnt = FALSE;
	InitSemaphore( & state_ptr->mutex, 1 );	/* one request at a time */
	sessn->state = (char*) state_ptr;

	/* add this sessn to the Srvr_map */
	TRACE1(spcp,5,"spc_openenable: sessn looks like %d", (int) sessn);
	sessn->binding = map_bind( Srvr_map, (char*) &srvrId, (int) sessn );

	/* inform the higher level protocol that a sessn has been opened */
	TRACE0(spcp,5,"spc_openenable: invoking callopendone");
	x_callopendone( higher_level_protl, sessn, participants );
	TRACE0(spcp,5,"spc_openenable: callopendone returned");

	return( SUCCESS );

E 2
I 2
  SrvrId	srvrId;
  XObj		sessn;
  SPCstate*	state_ptr;
  
  /* check whether a sessn for this service proc already exists */
  srvrId = ((RPCaddr*) participants[0].address) ->command;
  TRACE1(spcp,2,"spc_openenable (srvrId=%d)",srvrId);
  sessn = (XObj) map_resolve( Srvr_map, (char*) &srvrId );
  if( sessn != ERR_XOBJ ){
    
    /* this openenable conflicts with a previous one */
    TRACE1(spcp,1,"spc_openenable: service proc %d already openenabled",
	   srvrId);
    x_errno = ALREADY_OPEN;
    return( ERR );
  }
  
  /* this service proc has not had a previous openenable */
  /* do a mini-open: construct and bind a new sessn */
  
  /* construct a new sessn */
  sessn = x_createsession( higher_level_protl, SPC_SELF, 1 );
  TRACE0(spcp,5,"spc_openenable: got past createsession");
  sessn->rcnt = 1;	/* is this necessary? */
  
  /* build a state for this sessn */
  state_ptr = (SPCstate*) malloc( sizeof( SPCstate ) );
  state_ptr->is_clnt = FALSE;
  InitSemaphore( & state_ptr->mutex, 1 );	/* one request at a time */
  sessn->state = (char*) state_ptr;
  
  /* add this sessn to the Srvr_map */
  TRACE1(spcp,5,"spc_openenable: sessn looks like %d", (int) sessn);
  sessn->binding = map_bind( Srvr_map, (char*) &srvrId, (int) sessn );
  
  /* inform the higher level protocol that a sessn has been opened */
  TRACE0(spcp,5,"spc_openenable: invoking callopendone");
  x_callopendone( higher_level_protl, sessn, participants );
  TRACE0(spcp,5,"spc_openenable: callopendone returned");
  
  return( SUCCESS );
E 2
} /* end spc_openenable */


D 2




E 2
/*
 * SPC_SRVR_DEMUX
 *
 * All the channel demuxing and popping has already been done,
 * just hook up with the sessn corresponding to the service proc.
 * Openenables do the open work immediately (why?),
 * so don't look for an openenable if there isn't an existing sessn.
 */
I 2

E 2
spc_srvr_demux( cstate_ptr, spc_data, srvrId )
D 2
CSTATE*		cstate_ptr;
MSG			spc_data;
SrvrId	srvrId;
E 2
I 2
     CSTATE*	cstate_ptr;
     Msg	spc_data;
     SrvrId	srvrId;
E 2
{
D 2
XObj		sessn;
E 2
I 2
  XObj		sessn;
  
  TRACE0(spcp,4,"spc_srvr_demux");
  
  /* see if there is a sessn for this msg */
  sessn = (XObj) map_resolve( Srvr_map, (char*) &srvrId );
  if( sessn == ERR_XOBJ ){
E 2

D 2

	TRACE0(spcp,4,"spc_srvr_demux");

	/* see if there is a sessn for this msg */
	sessn = (XObj) map_resolve( Srvr_map, (char*) &srvrId );
	if( sessn == ERR_XOBJ ){

		/* no sessn for this srvrId */
		TRACE1(spcp,1,"spc_srvr_demux: no openenable to accept srvrId %d",
														 srvrId );

		reply_no_srvr( cstate_ptr );
		drop_msg( spc_data );
		
	}else{

		/* there is a sessn to which this msg belongs */
		TRACE1(spcp,5,"spc_srvr_demux: sessn looks like %d", (int) sessn);

		/* make sure there isn't already an outstanding request on sessn */
		P( & ((SPCstate*) (sessn->state)) ->mutex );

		/* attach the cstate to the sessn */
		((SPCstate*) (sessn->state))->cstate_ptr = cstate_ptr;

		return( x_demux( sessn, spc_data ) );
	}
	
E 2
I 2
    /* no sessn for this srvrId */
    TRACE1(spcp,1,"spc_srvr_demux: no openenable to accept srvrId %d",
	   srvrId );
    reply_no_srvr( cstate_ptr );
    drop_msg( spc_data );
  }else{
    
    /* there is a sessn to which this msg belongs */
    TRACE1(spcp,5,"spc_srvr_demux: sessn looks like %d", (int) sessn);
    
    /* make sure there isn't already an outstanding request on sessn */
    P( & ((SPCstate*) (sessn->state)) ->mutex );
    
    /* attach the cstate to the sessn */
    ((SPCstate*) (sessn->state))->cstate_ptr = cstate_ptr;
    
    return( x_demux( sessn, spc_data ) );
  }
E 2
} /* end spc_srvr_demux */


D 2




E 2
/*
 * SPC_SRVR_POP
 * THERE ISN'T ONE;  SPC_SRVR_DEMUX CALLS X_DEMUX.
 */


D 2




E 2
/*
 * SPC_SRVR_PUSH
 *
 * Trivial.  Could easily be collapsed with spc_srvr_chan_push,
 * but this keeps layers cleaner.
 */
I 2

E 2
spc_srvr_push( sessn, higher_level_msg )
D 2
XObj	sessn;
MSG		higher_level_msg;
E 2
I 2
     XObj	sessn;
     Msg	higher_level_msg;
E 2
{
D 2
CSTATE*	cstate_ptr;


	TRACE0(spcp,4,"spc_srvr_push");

	/* get the channel state currently associated with this sessn,	*/
	/*		and do the chan_push. */
	cstate_ptr = ((SPCstate*) sessn->state)->cstate_ptr;
	V( & ((SPCstate*) sessn->state)->mutex ); /* signal avail for new request */
	return( spc_srvr_chan_push( cstate_ptr, higher_level_msg ) );

E 2
I 2
  CSTATE*	cstate_ptr;
  
  TRACE0(spcp,4,"spc_srvr_push");
  
  /* get the channel state currently associated with this sessn,	*/
  /*		and do the chan_push. */
  cstate_ptr = ((SPCstate*) sessn->state)->cstate_ptr;
  V( & ((SPCstate*) sessn->state)->mutex ); /* signal avail for new request */
  return( spc_srvr_chan_push( cstate_ptr, higher_level_msg ) );
  
E 2
} /* end spc_srvr_push */

E 1
