h43082
s 00011/00008/00173
d D 1.2 91/01/10 12:08:46 llp 2 1
c Prepared for 3.1 Distribution
e
s 00181/00000/00000
d D 1.1 90/11/16 13:07:39 menze 1 0
c date and time created 90/11/16 13:07:39 by menze
e
u
U
f e 0
t
T
I 1
/*
 * sb.c
 *
 * Derived from:
 *
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of California at Berkeley. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 * Modified for x-kernel v3.1	12/10/90
D 2
 * Modifications Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Modifications Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */

D 2
#include "message.h"
#include "debug.h"
E 2
I 2
#include "xkernel.h"
E 2
#include "insque.h"
D 2
extern int tracetcpp;
E 2
#include "sb.h"
I 2

extern int tracetcpp;
E 2
struct sb_i *sbifreelist = 0;

print_sb(sb, m)
struct sb *sb;
char *m;
{
  char *foo;
  int i;
  struct sb_i *s;
  printf("%s %d:", m, sb->len);
  for (s = sb->next; s != (struct sb_i *)sb; s = s->next) {
    printf("(%d)", msg_len(s->m));
    foo = msg_top(s->m, msg_len(s->m));
    for (i = 0; i < msg_len(s->m); i++) {
      printf("%d", foo[i] - '0');
    }
  }
  printf("\n");
}

sbappend(sb, m)
struct sb *sb;
D 2
MSG m;
E 2
I 2
Msg m;
E 2
{
  struct sb_i *nsb;
  TRACE3(tcpp, 4, "sbappend on %X olen %d msglen %d", sb, sb->len, msg_len(m));
D 2
  if (msg_len(m) == 0) return;
E 2
I 2
  if (msg_len(m) == 0) {
    msg_free(m);
    return;
  }
E 2
  sbinew(nsb);
  nsb->m = m;
  if (sb->len==0) {
    sb->next = nsb;
    nsb->prev = (struct sb_i *)sb;
  }
  else {
    nsb->prev = sb->prev;
    nsb->prev->next = nsb;
  }
  nsb->next = (struct sb_i *)sb;
  sb->prev = nsb;

  sb->len += msg_len(m);
/*  insque(nsb, sb->next); */
  IFTRACE(tcpp, 5) print_sb(sb, "append");
}

sbcollect(sb, m, off, len, delete)
struct sb *sb;
D 2
MSG *m;
E 2
I 2
Msg *m;
E 2
int off, len, delete;
{
  struct sb_i *s, *next;
D 2
  MSG new;
E 2
I 2
  Msg new;
E 2

  TRACE5(tcpp, 4, "sbcollect on %X olen %d len %d off %d %s", sb, sb->len, len,
    off, delete ? "delete" : "");
  assert(!delete || off == 0);
  if (len == 0) {
    msg_make_allstack(*m, MSG_SSIZE, 0, 0);
    return;
  }
  IFTRACE(tcpp, 5) print_sb(sb, "collect");
  for (s = sb->next;
       s != (struct sb_i *)sb && off >= msg_len(s->m);
       s = s->next) 
    off -= msg_len(s->m);
  assert(s != (struct sb_i *)sb);
  if (off > 0 && off < msg_len(s->m)) {
    struct sb_i *ns;
    sbinew(ns);
    TRACE2(tcpp, 5, "sbcollect: split0 msg size %d at %d", msg_len(s->m), off);
    msg_break(s->m, ns->m, off, MSG_SSIZE);
    insque(ns, s->next);
    s = ns;
  }
  if (msg_len(s->m) > len) {
    struct sb_i *ns;
    sbinew(ns);
    TRACE2(tcpp, 5, "sbcollect: split1 msg size %d at %d", msg_len(s->m), len);
    msg_break(s->m, ns->m, len, MSG_SSIZE);
    insque(ns, s->next);
  }
  /*
   * We now have s pointing to the first msg, collect the rest
   */
  TRACE1(tcpp, 5, "sbcollect: first piece has size %d", msg_len(s->m));
  msg_save(new, s->m);
  len -= msg_len(new);
  s = s->next;
  while (len > 0) {
    assert(s != (struct sb_i *) sb);
    next = s->next;
    if (msg_len(s->m) > len) {
      sbinew(next);
      TRACE2(tcpp, 5, "sbcollect: split2 msg size %d at %d", msg_len(s->m),len);
      msg_break(s->m, next->m, len, MSG_SSIZE);
      insque(next, s->next);
    }
    msg_save(s->m, s->m);
    msg_join(new, new, s->m);
    len -= msg_len(s->m);
    s = next;
  }
  *m = new;
}

sbflush(sb)
struct sb *sb;
{
  struct sb_i *s = sb->next, *next;
  
  TRACE2(tcpp, 4, "sbflush on %X olen %d", sb, sb->len);
  while (s != (struct sb_i *)sb) {
    next = s->next;
    TRACE1(tcpp, 5, "sbflush: freeing msg len %d", msg_len(s->m));
    msg_free(s->m);
    sbifree(s);
    s = next;
  }
  sb->len = 0;
}

sbdrop(sb, len)
struct sb *sb;
int len;
{
  struct sb_i *s, *next;

  s = sb->next;
  TRACE3(tcpp, 4, "sbdrop on %X olen %d len %d", sb, sb->len, len);
  IFTRACE(tcpp, 5) print_sb(sb, "drop before");
  while (s != (struct sb_i *)sb && len > 0) {
    if (len < msg_len(s->m)) {
      struct sb_i *ns;
      sbinew(ns);
      TRACE2(tcpp, 5, "sbdrop: split msg size %d at %d", msg_len(s->m),len);
      msg_break(s->m, ns->m, len, MSG_SSIZE);
      insque(ns, s->next);
    }
    len -= msg_len(s->m);
    sb->len -= msg_len(s->m);
    next = s->next;
    remque(s);
    TRACE1(tcpp, 5, "sbdrop: freeing msg len %d", msg_len(s->m));
    msg_free(s->m);
    sbifree(s);
    s = next;
  }
  IFTRACE(tcpp, 5) print_sb(sb, "drop after");
}

sbdelete(sb)
struct sb *sb;
{
  TRACE1(tcpp, 3, "sbdelete on %X", sb);
  sbflush(sb);
  free((char *)sb);
}
E 1
