/* 
 * unixip.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include <errno.h>

#include "xkernel.h"
#include "unixip.h"
#include "unixip_i.h"

int traceipp;

static IPhost myipaddr;

#define BCASTIFY(ipa){\
  (ipa).d = 0;\
  if(!(((ipa).a) & 192)) {\
    (ipa).c = 0;\
    if(!(((ipa).a) & 128)) (ipa).b = 0;\
  }\
}

XObj IP;

ip_init(self)
XObj self;
{
  char name[32];
  struct hostent *ugly;
  extern char *inet_ntoa();

  IP = self;
  gethostname(name,32);

  ugly = gethostbyname(name);

  bcopy(ugly->h_addr,(char *)&myipaddr,IPADLEN);
  TRACE1(ipp,1,"ip init finds myipaddr %s",
	 inet_ntoa(*(struct in_addr *)&myipaddr));
}

ip_controlprotl(self, op,buf,len)
XObj self;
char *buf;
{
  assert(self == IP);
  switch(op){
  case GETMYADDR:
    if (len < sizeof(IPhost)) {
      x_errno = BUFFER_TOO_SMALL;
      return -1;
    }
    *(IPhost *)buf = myipaddr;
    return sizeof(IPhost);
  case IP_MYNET:
    if (len < sizeof(IPhost)) {
      x_errno = BUFFER_TOO_SMALL;
      return -1;
    }
    BCASTIFY(*(IPhost *)buf);
    return sizeof(IPhost);
  }
  x_errno = INVALID_OPCODE;
  return -1;
}

ip_getproc(p,type)
XObj p;
XObjType type;
{
  if (type == Protocol) {
    p->instantiateprotl = noop;
    p->init = ip_init;
    p->close = noop;
    p->push = noop;
    p->pop = noop;
    p->control = ip_controlprotl;
  } else {
    p->push = noop;
    p->pop = noop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->control = noop;
    p->close = noop;
  }
  p->open = (Pfi) noop;
  p->openenable = noop;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = noop;
  p->getproc = noop;
}
