/* 
 * unixtcp.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include <errno.h>

#include "xkernel.h"
#include "ip.h"
#include "unixtcp.h"
#include "unixtcp_i.h"
int tracetcpp;

extern char *inet_ntoa();

#define IPBROADCASTIFY(ipa){\
  (ipa).d = 0;\
  if(!(((ipa).a) & 192)) {\
    (ipa).c = 0;\
    if(!(((ipa).a) & 128)) (ipa).b = 0;\
  }\
}
#define IMAGINARY 0x42424242
extern int errno;
extern int SignalsPossible;

/**********************************************************************
 * IMPORTS FROM MACHINE.C--have someone clean this interface up someday
 */

/* don't know how many sockets we should allow for */
#define NUMSOCKETSICANUSE 30

struct	int_vector {
  Pfi	handler;
/* device is now given by the index
  int	device;
*/
};

extern int dispatch();

/******************* END IMPORTS FROM MACHINE.C *********************/


/* global data for TCP; need data structure for assigned/free port nums */

static	Map	map;
static  Map     lport2sock;
static  IPhost  myipaddr;
static  void    swap_hdr();
static  XObj	socket2hlp[NUMSOCKETSICANUSE];
static TCP_EXID socket2exid[NUMSOCKETSICANUSE];

int readtcp2demux(), tcp_sly_opendone();
void x_callopendone();
XObj	TCP;
#define IP (TCP->down[0])

tcp_init(self)
XObj	self;
{
  TCP = self;
  map           = map_create(100, 8);
  lport2sock    = map_create(NUMSOCKETSICANUSE+1, 8);
  TRACE0(tcpp, 1, "UNIXTCP init");
  x_controlprotl(IP, GETMYADDR, (char *)&myipaddr, 4);
  return 0;
}

#define ERREXIT(err,freebinding,freeivec,freesessn,freesoc) {\
  x_errno = err;\
  freesoc;\
  if(freeivec) cancelSignalHandler(freeivec);\
  if((freebinding)!=ERR_BIND) map_unbindbinding(lport2sock,(freebinding));\
  freesessn;\
  s = ERR_SESSN;\
  goto quit;\
}
/*
 * In TCP-land, opening on an existing session OR an existing
 * socket means insta-death.
 */
Sessn tcp_open(self, hlp, p)
XObj	self;
XObj	hlp;
Part	*p;
{
  Sessn	  s;
  register TCPaddr *local_addr, *remote_addr;
  struct tcpstate *u_state;
  TCP_EXID ex_id;
  struct sockaddr_in addr;
  int    soc, xxx;
  Bind my_binding = ERR_BIND;

  assert(self == TCP);
  TRACE0(tcpp, 3, "TCP open");
  if (!p) {
    TRACE0(tcpp, 1, "unixtcp_open: No participants!");
    ERREXIT(BAD_ADDR, ERR_BIND, 0, /**/, /**/);
  }

  /* ex_id = localport+remoteport+remotehostaddr */
  local_addr = (TCPaddr *) p[0].address;
  remote_addr = (TCPaddr *) p[1].address;

  ex_id.int_id.real.localport = local_addr->port;
  ex_id.int_id.real.remoteport = remote_addr->port;
  ex_id.ip_addr.real = remote_addr->host;

  TRACE3(tcpp, 3, "in unixtcp_open (my port = %d), to <%s,%d>",
	 ntohs(ex_id.int_id.real.localport),
	 inet_ntoa(*(struct in_addr *)&ex_id.ip_addr.imaginary),
	 ntohs(ex_id.int_id.real.remoteport));

  if ((s=(Sessn)map_resolve(map, (char *)&ex_id)) != ERR_SESSN) {
    TRACE0(tcpp, 3, "can't steal someone else's session!");
    ERREXIT(ALREADY_OPEN, ERR_BIND, 0, /**/, /**/);
  }

  s = x_createsession(hlp, TCP, 1);
  s->binding = map_bind(map, (char *)&ex_id, (int)s);
  s->state   = malloc(sizeof(struct tcpstate));
  s->rcnt    = 1;

  u_state = (struct tcpstate *)s->state;
  u_state->ex_id = ex_id;

  /* Check this TCP port number for an existing socket.  Ex out the
   * remoteport+remotehostaddr part of the ex_id, and try again in
   * another map.  If there is an existing socket, our open must fail.
   */
  ex_id.int_id.real.remoteport = (u_short)IMAGINARY;
  ex_id.ip_addr.imaginary = IMAGINARY;
  if ((soc = map_resolve(lport2sock, (char *)&ex_id)) != -1) {
    TRACE1(tcpp, 3, "can't have port number %d",ntohs(local_addr->port));
    ERREXIT(ALREADY_OPEN, ERR_BIND, 0, x_destroysession(s), /**/);
  }


  /* Oh boy!  We must create a new socket! */

  addr.sin_family = AF_INET;
  addr.sin_addr.s_addr = INADDR_ANY;
  addr.sin_port = local_addr->port;

  TRACE1(tcpp, 5, "Unixtcp open opening lport %d", ntohs(addr.sin_port));

  if((soc = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
    perror("unixtcp_open");
    ERREXIT(INVALID_OPEN, ERR_BIND, 0, x_destroysession(s), /**/);
  }

  /* Having created the socket, tie it into the simulator */
  TRACE1(tcpp, 5, "Unixtcp open receives socket %d", soc);
  if((my_binding=map_bind(lport2sock, (char *)&ex_id, soc)) == ERR_BIND){
    TRACE0(tcpp,1,"unixtcp_open: bind on map lport2sock fails!");
    ERREXIT(INVALID_OPEN, ERR_BIND, 0, x_destroysession(s), close(soc));
  }
  if (soc>=NUMSOCKETSICANUSE) {
    TRACE0(tcpp,1,"unixtcp_open: socket out of range!");
    ERREXIT(INVALID_OPEN, my_binding, 0, x_destroysession(s), close(soc));
  }

  /* fill the ivector slot */
  u_state->sock = soc; /* remember the socket in the session */
  socket2exid[soc].int_id.real.localport = local_addr->port;
  socket2exid[soc].int_id.real.remoteport = remote_addr->port;
  socket2exid[soc].ip_addr.real = remote_addr->host;
  socket2hlp[soc] = hlp;
  installSignalHandler(soc, readtcp2demux);

  if (bind(soc, (struct sockaddr *)&addr, sizeof(addr)) < 0){
    int retry;
    TRACE0(tcpp, 1, "Tcpp open: Waiting for unix bind\n");
    for(retry=2;retry<60;retry++){
      sleep(1);
      if(bind(soc, (struct sockaddr *)&addr, sizeof(addr)) >= 0) goto BINDOK;
      if (retry == 4) printf("Delaying on bind to port %d\n",
	ntohs(addr.sin_port));
    }
    perror("unixtcp open bind");
    ERREXIT(INVALID_OPEN, my_binding, soc, x_destroysession(s), close(soc));
  }
 BINDOK:
  addr.sin_family = AF_INET;
  *(IPhost *)&(addr.sin_addr.s_addr) = remote_addr->host;
  addr.sin_port = remote_addr->port;

  TRACE2(tcpp,3,"Unixtcp opening destination <%s,%d>",
	 inet_ntoa(addr.sin_addr), ntohs(remote_addr->port));


  /* connect, via a flurry of unix system calls
   * inexplicable interrupts during the connect plague 4.3BSD (sigblock)
   */
  xxx = sigblock(-1);
  if (connect(soc, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
    perror("unixtcp open connect");
    sigsetmask(xxx);
    ERREXIT(INVALID_OPEN, my_binding, soc, x_destroysession(s), close(soc));
  }
  if (fcntl(soc,F_SETFL,(FASYNC | FNDELAY)) < 0) {
    perror("unixtcp open fcntl async");
    sigsetmask(xxx);
    ERREXIT(INVALID_OPEN, my_binding, soc, x_destroysession(s), close(soc));
  }
  if (fcntl(soc,F_SETOWN,getpid()) < 0) {
    perror("unixtcp open fcntl setown");
    sigsetmask(xxx);
    ERREXIT(INVALID_OPEN, my_binding, soc, x_destroysession(s), close(soc));
  }
  sigsetmask(xxx);
  SignalsPossible = 1;
 quit:
  TRACE1(tcpp, 3, "UNIXTCP open returns %x", s);
  return s;
}

tcp_openenable(self, hlp, p)
XObj	self;
XObj	hlp;
Part	*p;
{
  TCP_EXID ex_id;	 /* ex_id = port */
  TCPaddr *localaddr; 
  int      soc=0;
  struct sockaddr_in addr;
  Bind my_binding = ERR_BIND;
  Sessn s = NULL;

  assert(self == TCP);
  TRACE0(tcpp, 3, "UNIXTCP open enable");
  localaddr = (TCPaddr *) p[0].address;
  ex_id.int_id.real.localport = localaddr->port;
  ex_id.int_id.real.remoteport = (u_short)IMAGINARY;
  ex_id.ip_addr.imaginary = IMAGINARY;

  /* if someone in MAP has bound the port, they own incoming messages */
  if (map_bind(map, (char *)&ex_id, (int)hlp) == ERR_BIND ) {
    TRACE0(tcpp, 1, "Unixtcp openenable: someone else in map!");
    ERREXIT(ALREADY_OPEN, ERR_BIND, 0, /**/, /**/);
  }
  if ((soc = map_resolve(lport2sock, (char *)&ex_id)) != -1) {
    TRACE0(tcpp, 1, "Unixtcp openenable: someone else in lport2sock!");
    ERREXIT(ALREADY_OPEN, ERR_BIND, 0, /**/, /**/);
  } else {
    /* Oh boy!  We must create a new socket! */
    addr.sin_family = AF_INET;
    addr.sin_addr.s_addr = INADDR_ANY;
    addr.sin_port = localaddr->port;
    TRACE1(tcpp, 5, "Unixtcp openenable for lport %d", ntohs(addr.sin_port));

    errno = 0;
    if ((soc = socket(AF_INET, SOCK_STREAM, 0)) < 0){
      perror("unixtcp openenable socket");
      ERREXIT(INVALID_OPEN, ERR_BIND, 0, /**/, /**/);
    }

    /* Having created the socket, tie it into the simulator */
    TRACE1(tcpp, 5, "unixtcp openenable receives socket %d", soc);
    if((my_binding=map_bind(lport2sock, (char *)&ex_id, soc)) == ERR_BIND){
      TRACE0(tcpp,1,"unixtcp_open: bind on map lport2sock fails!");
      ERREXIT(INCONSISTENT_BIND, my_binding, 0, /**/, close(soc));
    }
    if (soc>=NUMSOCKETSICANUSE) {
      TRACE0(tcpp,1,"unixtcp_openenable: soc descriptor out of range!");
      ERREXIT(INVALID_OPEN, my_binding, 0, /**/, close(soc));
    }
    /* socket2exid for the accepter socket has only the local port valid.
     * remote port and remote ipaddr for actual connections are set in
     * tcp_sly_opendone.
     */
    socket2exid[soc].int_id.real.localport = localaddr->port;
    socket2hlp[soc] = hlp;

    installSignalHandler(soc, tcp_sly_opendone);

    /* set a socket to listen at the required port,
     * via a flurry of unix system calls.
     */
    if (bind(soc, (struct sockaddr *)&addr, sizeof(addr)) < 0){
      int retry;
      TRACE0(tcpp, 1, "unixtcp_openenable: Waiting for unix bind\n");
      for(retry=2;retry<60;retry++){
	sleep(1);
	if(bind(soc, (struct sockaddr *)&addr, sizeof(addr)) >= 0) goto BINDOK;
	if (retry == 4) printf("Delaying on bind to port %d\n",
	  ntohs(addr.sin_port));
      }
      perror("unixtcp openenable bind");
      ERREXIT(INVALID_OPEN, my_binding, soc, /**/, close(soc));
    }
  BINDOK:
    if (fcntl(soc,F_SETFL,FASYNC) < 0){
      perror("unixtcp openenable fcntl async");
      ERREXIT(INVALID_OPEN, my_binding, soc, /**/, close(soc));
    }
    if (fcntl(soc,F_SETOWN,getpid()) < 0){
      perror("unixtcp openenable fcntl setown");
      ERREXIT(INVALID_OPEN, my_binding, soc, /**/, close(soc));
    }
    if(listen(soc,2) < 0){
      perror("unixtcp openenable listen");
      ERREXIT(INVALID_OPEN, my_binding, soc, /**/, close(soc));
    }
    SignalsPossible = 1;
  }
 quit:
  return (int)s;
}

tcp_close(s)
Sessn	s;
{
  int soc;
  struct tcpstate *tcp_state;

  TRACE2(tcpp, 3, "UNIXTCP close of session %x (refcount %d)", s, s->rcnt);

  if (--s->rcnt > 0) return 0;

  map_unbindbinding(map, s->binding);
  if (tcp_state = (struct tcpstate *) s->state) {
    soc = tcp_state->sock;
    socket2exid[soc].int_id.real.remoteport = (u_short)IMAGINARY;
    socket2exid[soc].ip_addr.imaginary = (u_short)IMAGINARY;
    map_unbindbinding(lport2sock, (Bind)&(socket2exid[soc]));
    close(tcp_state->sock);
    cancelSignalHandler(soc);
  }
  x_destroysession(s);
  return 0;
}

/*ARGSUSED*/
tcp_push(s, msg, rmsg)
Sessn	s;
Msg	msg, *rmsg;
{
  char buffer[TCPMAX];
  int len = msg_len(msg);

  TRACE1(tcpp, 3, "in unixtcp push, len %d", len);
  msg_externalize(msg, buffer);
  return write_tcp(s, buffer, len);
}

extern tcp_sly_closedone();

write_tcp(s, buf, len)
Sessn s;
char *buf;
int len;
{
  struct sockaddr_in addr;
  register struct tcpstate *tcp_state;
  int slen;
  extern void Yield();

  tcp_state = (struct tcpstate *) s->state;

  addr.sin_family = AF_INET;
  addr.sin_addr.s_addr = tcp_state->ex_id.ip_addr.imaginary;
  addr.sin_port = tcp_state->ex_id.int_id.real.remoteport;

  TRACE4(tcpp, 1, "unixtcp writing %d bytes on socket %d to <%s,%d>", len,
	 tcp_state->sock,inet_ntoa(addr.sin_addr),ntohs(addr.sin_port));

  do {
    slen = sendto(tcp_state->sock,buf,len,0,(struct sockaddr *)&addr,
      sizeof(struct sockaddr_in));
    if (slen > 0) {
      buf += slen;
      len -= slen;
    } else if (slen < 0 && (errno == EINTR || errno == EWOULDBLOCK)) {
      sleep (1);
      slen = 1;
    }
  } while (slen > 0 && len > 0);
  if (slen < 0) {
    perror("write_tcp (calling tcp_sly_closedone):");
#define USECP
#ifdef USECP
    CreateProcess(tcp_sly_closedone, 0, 1, 1, tcp_state->sock);
    Yield();
#else
    tcp_sly_closedone(tcp_state->sock);
#endif
    return -1;
  }
  return 0;
}

tcp_demux(self, s, dg)
XObj	self;
Sessn	s;
Msg	dg;
{
  TCP_EXID *hdr, ex_id;
  Sessn   tcp_s;

  assert(self == 0);
  hdr = (TCP_EXID *) msg_top(dg, sizeof(TCP_EXID));

  ex_id = *hdr;

  TRACE4(tcpp, 3, "in unixtcp demux with %d bytes for port %d from <%s,%d>",
	 msg_len(dg), ntohs(hdr->int_id.real.localport),
	 inet_ntoa(*(struct in_addr *)&hdr->ip_addr.imaginary),
	 ntohs(hdr->int_id.real.remoteport));

  /* look for an existing session receiving from this source */
  if ((tcp_s=(Sessn)map_resolve(map, (char *)&ex_id)) != ERR_SESSN) {
    TRACE1(tcpp, 3, "Popping to existing session %x", tcp_s);
    return x_pop(tcp_s, s, dg);
  }
  
  /* look for an existing session receiving from any */
  IPBROADCASTIFY(ex_id.ip_addr.real);
  if ((tcp_s=(Sessn)map_resolve(map, (char *)&ex_id)) != ERR_SESSN) {
    TRACE1(tcpp, 3, "Popping to existing session %x", tcp_s);
    return x_pop(tcp_s, s, dg);
  }
  return -1;
}

tcp_sly_closedone(i)
{
  Sessn s;
  if((s=(Sessn)map_resolve(map, (char *)&(socket2exid[i]))) == ERR_SESSN){
    TRACE0(tcpp, 3, "no session found for tcp sly closedone!");
    return -1;
  }
  x_closedone(s);
  return 0;
}

/* tcp_sly_opendone - called from machine.dispatch() when input is possible
 * on our connection socket.  We must do the accept, create
 * a new session (a la opendone()) and then call the parent opendone().
 */
tcp_sly_opendone(oldsoc)
int oldsoc;
{
  struct in_addr a;
  u_short p;
  int newsoc;

  Sessn s;
  TCP_EXID ex_id;
  XObj hlp;
  struct tcpstate *u_state;
  TCPaddr me, you;
  Part part[3];

  struct sockaddr_in addr;
  int addlen = sizeof(struct sockaddr_in);

  if ((newsoc = accept(oldsoc, (struct sockaddr *)&addr, &addlen)) < 0) {
    IFTRACE(tcpp, 1) perror("tcp_sly_opendone accept");
    return;
  }
  
  a = addr.sin_addr;
  p = addr.sin_port;

  TRACE2(tcpp, 1, "X: accepted connection from <%s,%d>",inet_ntoa(a),ntohs(p));
  TRACE4(tcpp,3,"tcp_sly_opendone: oldsoc %d, newsoc %d, from <%s,%d>",
	 oldsoc, newsoc, inet_ntoa(a), ntohs(p));

  hlp = socket2hlp[newsoc] = socket2hlp[oldsoc];

  /* ex_id = localport+remoteport+remotehostaddr */
  ex_id.int_id.real.remoteport = p;
  (*(u_long *)&(ex_id.ip_addr.real)) = a.s_addr;
  ex_id.int_id.real.localport = socket2exid[oldsoc].int_id.real.localport;

  if ((s=(Sessn)map_resolve(map, (char *)&ex_id)) != ERR_SESSN) {
    TRACE0(tcpp,3,"tcp_sly can't steal existing session");
    ERREXIT(ALREADY_OPEN, ERR_BIND, 0, /**/, close(newsoc));
  }

  if((s = x_createsession(hlp, TCP, 1)) == ERR_SESSN) {
    TRACE0(tcpp,3,"tcp_sly createsession fails!");
    ERREXIT(ALREADY_OPEN, ERR_BIND, 0, /**/, close(newsoc));
  }
  TRACE1(tcpp,6,"tcp_sly creates session 0x%x",s);
  if((s->binding = map_bind(map, (char *)&ex_id, (int)s))==ERR_BIND){
    TRACE0(tcpp,3,"tcp_sly mapbind fails!");
    ERREXIT(ALREADY_OPEN, ERR_BIND, 0, /**/, close(newsoc));
  }
  if((s->state = malloc(sizeof(struct tcpstate))) == NULL){
    TRACE0(tcpp,3,"tcp_sly malloc tcpstate fails!");
    ERREXIT(ALREADY_OPEN, ERR_BIND, 0, /**/, close(newsoc));
  }
  s->rcnt = 1;

  u_state = (struct tcpstate *)s->state;
  u_state->ex_id = ex_id;
  u_state->sock = newsoc;

  /* Oh boy!  We actually survived this far; tie socket into simulator! */
  if (newsoc>=NUMSOCKETSICANUSE) {
    TRACE0(tcpp,1,"unixtcp sly_opendone: socket out of range!");
    ERREXIT(INVALID_OPEN, ERR_BIND, 0, x_destroysession(s), close(newsoc));
  }
  TRACE0(tcpp,6,"tcp_sly at point B");

  socket2exid[newsoc].int_id.real.localport =
    socket2exid[oldsoc].int_id.real.localport;
  socket2exid[newsoc].int_id.real.remoteport = p;
  *(u_long *)&(socket2exid[newsoc].ip_addr.real) = a.s_addr;
  installSignalHandler(newsoc, readtcp2demux);

  if (fcntl(newsoc,F_SETFL,(FASYNC | FNDELAY)) < 0) {
    perror("unixtcpsly opendone fcntl async");
    ERREXIT(INVALID_OPEN,ERR_BIND,newsoc,x_destroysession(s),close(newsoc));
  }
  if (fcntl(newsoc,F_SETOWN,getpid()) < 0) {
    perror("unixtcpsly opendone fcntl setown");
    ERREXIT(INVALID_OPEN,ERR_BIND,newsoc,x_destroysession(s),close(newsoc));
  }
  TRACE0(tcpp,6,"tcp_sly at point Z");
  SignalsPossible = 1;

  me.port  = socket2exid[newsoc].int_id.real.localport;
  you.port = socket2exid[newsoc].int_id.real.remoteport;
  me.host  = myipaddr;
  you.host = socket2exid[newsoc].ip_addr.real;

  part[0].address = (char *)&me;
  part[0].length  = TCPADLEN;
  part[1].address = (char *)&you;
  part[1].length  = TCPADLEN;
  part[2].address = NULL; part[2].length = 0;
#ifdef CREATEDISPATCH
  TRACE0(tcpp,3,"tcp_slyopendone creating dispatch");
  CreateProcess(dispatch, 0, 6, 0);
#endif
  TRACE0(tcpp,3,"tcp_slyopendone creating open done");
  CreateProcess((Pfi)x_callopendone, 0, 5, 3, hlp, s, part);
 quit: ;
}

/*ARGSUSED*/
tcp_pop(s, delivery_s, dg)
Sessn	s, delivery_s;
Msg	dg;
{
  msg_pop(dg, sizeof(TCP_EXID));
  TRACE1(tcpp, 3, "UNIXTCP pop, length = %d", msg_len(dg));
  return x_demux(s,dg);
}

/*
 * Generic TCP Device
 */
read_tcp(soc,msg,len)
int   soc,len;
char *msg;
{
  int	n;

  if((n = recv(soc, msg, len, 0))>0) {
    TRACE4(tcpp,1, "X:receiving %d bytes (%s) from unixtcp:<%s,%d>",n,msg,
	   inet_ntoa(*(struct in_addr *)&socket2exid[soc].ip_addr.imaginary),
	   ntohs(socket2exid[soc].int_id.real.remoteport));
  } else if(!n) {
    /* end of stream.  remove socket from mask used by select().
     * socket cleanup waits until emerald gets around to it.
     */
    cancelSignalHandler(soc);
  }
  if(n<0 && errno!=EINTR && errno!=EWOULDBLOCK){
    perror("read_tcp (calling tcp_sly_closedone):");
    CreateProcess(tcp_sly_closedone, 0, 5, 1, soc);
  }
  return n;
}


/* "incoming wounded" handler
 * rather than simulating a tcp header here, we simply construct
 * the localport+remoteport+remoteaddr required to find the session
 */
readtcp2demux(index)
int index;
{
  Msg msg;
  char buf[TCPDLEN+sizeof(TCP_EXID)];
  int buflen, j = 0;
  TCP_EXID *foo;

  while((buflen=read_tcp(index,buf+sizeof(TCP_EXID),TCPDLEN)) >= 0){
    TRACE1(tcpp, 5, "readtcp2demux loop %d", j++);
    foo = (TCP_EXID *) buf;
    *foo = socket2exid[index];
    msg_make_allstack(msg, 16, buf, buflen+sizeof(TCP_EXID));
    CreateProcess(tcp_demux, 0, 5, 2 + (sizeof(Msg)+3)/4, NULL, NULL, msg);
    if(!buflen) break;
  }
  return 0;
}

tcp_getproc(p,type)
XObj p;
XObjType type;
{
  if (type == Protocol) {
    p->instantiateprotl = noop;
    p->init = tcp_init;
    p->close = noop;
    p->push = noop;
    p->pop = noop;
    p->control = noop;
  } else {
    p->push = tcp_push;
    p->pop = tcp_pop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->control = noop;
    p->close = tcp_close;
  }
  p->open = (Pfi) tcp_open;
  p->openenable = tcp_openenable;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = tcp_demux;
  p->getproc = tcp_getproc;
}
