h07989
s 00175/00000/00000
d D 1.1 89/10/24 13:46:33 norm 1 0
c date and time created 89/10/24 13:46:33 by norm
e
u
U
f e 0
t
T
I 1
/* 
 * %W%  %G%
 */
#include "system.h"
/*
 * We need the definitions of:
 *	PREFIX
 *	KEYSIZE
 *	HASH
 *	COMPBYTES
 *	COPYBYTES
 */
struct STRUCT {
  int     int_id;
  struct  STRUCT *next_elem;
  char    ext_id[KEYSIZE];
};

typedef struct STRUCT MAP_ELEM, *BIND, **MAP;

#define	GETMAPELEM(elem) { \
    if (free_list == NULL) \
        elem = (BIND)malloc(sizeof(MAP_ELEM)); \
    else { \
        elem = free_list; \
        free_list = free_list->next_elem; \
    } \
}
#define	FREEIT(elem) { \
    elem->next_elem = free_list; \
    free_list = elem; \
}

static BIND free_list = NULL;

MAP MAP_CREATE (size)
int     size;
{
  MAP	table;

  table = (MAP)calloc((unsigned)(size + 2), sizeof(BIND));
  *table = (BIND)size;
  *(table+1) = (BIND) 0;
  return(table);
}

BIND MAP_BIND (table, ext, intern)
MAP	table;
register char	*ext;
int	intern;
{
  BIND     elem_posn;
  BIND     new_elem;
  MAP   table_posn;
  register char *o_ext;

  table_posn = table + HASH(ext, table) + 2;
  elem_posn = *table_posn;
  while (elem_posn != NULL) {
    o_ext = elem_posn->ext_id;
    if (COMPBYTES(o_ext, ext)) {
      if (elem_posn->int_id == intern) {
	return(elem_posn);
      } else {
	x_errno = INCONSISTENT_BIND;
	return(ERR_BIND);
      }
    } else {
      elem_posn = elem_posn->next_elem;
    }
  }
  GETMAPELEM(new_elem);
  COPYBYTES(new_elem->ext_id, ext);
  new_elem->int_id = intern;
  new_elem->next_elem = *table_posn;
  *(table + 1) = new_elem;
  *table_posn = new_elem;
  return(new_elem);
}

MAP_RESOLVE (table, ext)
MAP	table;
register char	*ext;
{
  register BIND elem_posn;
  register char *o_ext;

  if (elem_posn = *(table + 1)) {
    o_ext = elem_posn->ext_id;
    if (COMPBYTES(o_ext, ext)) {
      return(elem_posn->int_id);
    }
  }
  elem_posn = *(table + HASH(ext, table) + 2);
  while (elem_posn != NULL) {
    o_ext = elem_posn->ext_id;
    if (COMPBYTES(o_ext, ext)) {
      *(table + 1) = elem_posn;
      return(elem_posn->int_id);
    } else {
      elem_posn = elem_posn->next_elem;
    }
  }
  x_errno = CANNOT_RESOLVE;
  return(-1);
}

MAP_UNBINDBINDING (table, binding)
MAP	table;
BIND	binding;
{
  BIND     elem_posn;
  MAP   prev_elem;
  register char *o_ext;

  prev_elem = (table + HASH(binding->ext_id, table) + 2);
  elem_posn = *prev_elem;
  *(table + 1) = 0;
  while (elem_posn != NULL) {
    o_ext = elem_posn->ext_id;
    if (COMPBYTES(o_ext, binding->ext_id)) {
      if (elem_posn->int_id == binding->int_id) {
	*prev_elem = elem_posn->next_elem;
	FREEIT(elem_posn);
	return(0);
      } else {
	x_errno = CANNOT_UNBIND;
	return(-1);
      }
    } else {
      prev_elem = &(elem_posn->next_elem);
      elem_posn = elem_posn->next_elem;
    }
  }
  x_errno = CANNOT_UNBIND;
  return(-1);
} 

MAP_UNBIND (table, ext, intern)
MAP	table;
register char	*ext;
int	intern;
{
  BIND     elem_posn;
  MAP   prev_elem;
  register char *o_ext;

  prev_elem = (table + HASH(ext, table) + 2);
  elem_posn = *prev_elem;
  *(table + 1) = 0;
  while (elem_posn != NULL) {
    o_ext = elem_posn->ext_id;
    if (COMPBYTES(o_ext, ext)) {
      if (elem_posn->int_id == intern || intern == -1) {
	*prev_elem = elem_posn->next_elem;
	FREEIT(elem_posn);
	return(0);
      } else {
	x_errno = CANNOT_UNBIND;
	return(-1);
      }
    } else {
      prev_elem = &(elem_posn->next_elem);
      elem_posn = elem_posn->next_elem;
    }
  }
  x_errno = CANNOT_UNBIND;
  return(-1);
}

MAP_CLOSE (table)
MAP	table;
{
  free((char *)table);
}
E 1
