/* 
 * debug.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#ifndef debug_h

extern int
	tracebuserror,
	tracecustom,
 	traceether,
	traceevent,
	tracefixme,
	traceidle,
	traceie,
	tracememoryinit,
	traceprocesscreation,
	traceprocessswitch,
	traceprotocol,
	tracetick,
	tracetrap,
	traceuser;

extern void trace();


#if !defined(NDEBUG) || defined(lint)

#ifdef __STDC__
#define XPASTE(X,Y) X##Y
#define PASTE(X,Y) XPASTE(X,Y)

#   define IFTRACE(t, l) \
	if (PASTE(trace,t) >= l)
#   define TRACE0(t, l, f) \
	if (PASTE(trace,t) >= l) trace(l, f, 0)
#   define TRACE1(t, l, f, arg1) \
	if (PASTE(trace,t) >= l) trace(l, f, 1, arg1)
#   define TRACE2(t, l, f, arg1, arg2) \
	if (PASTE(trace,t) >= l) trace(l, f, 2, arg1, arg2)
#   define TRACE3(t, l, f, arg1, arg2, arg3) \
	if (PASTE(trace,t) >= l) trace(l, f, 3, arg1, arg2, arg3)
#   define TRACE4(t, l, f, arg1, arg2, arg3, arg4) \
	if (PASTE(trace,t) >= l) trace(l, f, 4, arg1, arg2, arg3, arg4)
#   define TRACE5(t, l, f, arg1, arg2, arg3, arg4, arg5) \
	if (PASTE(trace,t) >= l) trace(l, f, 5, arg1, arg2, arg3, arg4, arg5)
#else
#define D___I(X) X

#   define IFTRACE(t, l) \
	if (D___I(trace)t >= l)
#   define TRACE0(t, l, f) \
	if (D___I(trace)t >= l) trace(l, f, 0)
#   define TRACE1(t, l, f, arg1) \
	if (D___I(trace)t >= l) trace(l, f, 1, arg1)
#   define TRACE2(t, l, f, arg1, arg2) \
	if (D___I(trace)t >= l) trace(l, f, 2, arg1, arg2)
#   define TRACE3(t, l, f, arg1, arg2, arg3) \
	if (D___I(trace)t >= l) trace(l, f, 3, arg1, arg2, arg3)
#   define TRACE4(t, l, f, arg1, arg2, arg3, arg4) \
	if (D___I(trace)t >= l) trace(l, f, 4, arg1, arg2, arg3, arg4)
#   define TRACE5(t, l, f, arg1, arg2, arg3, arg4, arg5) \
	if (D___I(trace)t >= l) trace(l, f, 5, arg1, arg2, arg3, arg4, arg5)
#endif /* __STDC__ */
#else
#   define IFTRACE(t, l) if (0)
#   define TRACE0(t, l, f)
#   define TRACE1(t, l, f, arg1)
#   define TRACE2(t, l, f, arg1, arg2)
#   define TRACE3(t, l, f, arg1, arg2, arg3)
#   define TRACE4(t, l, f, arg1, arg2, arg3, arg4)
#   define TRACE5(t, l, f, arg1, arg2, arg3, arg4, arg5)
#endif

#endif
