/* 
 * userupi.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#ifndef upi_h
#define upi_h

#ifdef	XSIMUL
#include <sys/types.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <syslog.h>
#include <errno.h>
#include <signal.h>

#else
#ifndef _TYPES_
typedef unsigned char u_char;
typedef unsigned short u_short;
#endif
#endif

#ifndef TRUE
#define TRUE  1
#endif

#ifndef FALSE
#define FALSE  0
#endif

#ifndef NULL
#define NULL  0
#endif

typedef	int(*Pfi) ();
typedef struct session *(*Pfs)();

#ifndef DEFININGIDMAPPER
typedef struct umap2_elem *BIND2, **MAP2;
typedef struct umap_elem *BIND, **MAP;
typedef struct umap12_elem *BIND12, **MAP12;
typedef struct umap16_elem *BIND16, **MAP16;
typedef struct umap24_elem *BIND24, **MAP24;
typedef struct umap28_elem *BIND28, **MAP28;
typedef struct umap32_elem *BIND32, **MAP32;
#endif

extern	struct umap_elem ** umap_create(/*size*/);
extern	struct umap_elem *umap_bind(/*table, extern, intern*/);
extern	int   umap_resolve(/*table, extern*/);
extern	int   umap_unbindbinding(/*table, binding*/);
extern	int   umap_unbind(/*table, extern, intern*/);
extern	int   umap_close(/*table*/);

typedef struct msg *Msg;
typedef struct session *Sessn;
typedef int Protl;

/* event stuff */

typedef struct event *EVENT;
#define	EV_REMOVE	0
#define	EV_ONCE		1
#define	EV_REPEAT	2
#define EV_CREATEPROCESS	0x100

/* participant stuff */

typedef struct {
  char *address;
  int   length;
} Part;

/* error stuff */

#define	MAP_FULL		1
#define	INCONSISTENT_BIND	2
#define	CANNOT_RESOLVE		3
#define	CANNOT_UNBIND		4
#define	INVALID_TYPE		5
#define	INVALID_OPCODE		6
#define	BUFFER_TOO_SMALL	7
#define	INVALID_EV_CODE		8
#define	EVENT_NOT_REGISTERED	9
#define	INVALID_OPEN		10
#define	ALREADY_OPEN		11
#define	BAD_ADDR		12

#define	ERR_SESSN	((Sessn) -1)
#define	ERR_PROTL	((Protl) -1)
#define	ERR_BIND	((BIND) -1)

extern	int x_errno;

extern	Sessn xopen(/*hlp, llp, participants*/);
extern	int   xopenenable(/*hlp, llp, participants*/);
extern	Sessn xopendone(/*hlp, llp, participants*/);
extern	int   xopendisable(/*hlp, llp, participants*/);
extern	int   xdemux(/*s, msg*/);
extern	int   xclose(/*s*/);
extern	int   xclosedone(/*s*/);
extern	int   xpush(/*s, msg*/);
extern	int   xpop(/*s, msg*/);
extern	int   xcontrolSessn(/*s, opcode, buf, buflen*/);
extern	int   xcontrolprotl(/* opcode, buf, buflen*/);
extern  EVENT xeventregister(/* r, i, a, c */);
extern  int   xeventremove(/* r, a */);
extern	int   xeventremoveevent(/* e */);


#endif
