h59761
s 00410/00000/00000
d D 1.1 91/01/10 11:11:29 llp 1 0
c date and time created 91/01/10 11:11:29 by llp
e
u
U
f e 0
t
T
I 1
/* 
 * ms_memory.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#ifndef ms_memory_h
#define ms_memory_h

#ifndef system_h
#include "system.h"
#endif

#ifndef ms_inline_h
#include "ms_inline.h"
#endif

/* Where the interrupt vectors live (as set by the boot prom) */
#define VECTOR_BASE 0x0FE60C00

#define MAXPAGES (2 * 1024)		/* 16M */
#define PROM_PMEGS	(17)
#define STACK_PMEG	(0xf0)

/* The prom maps the last 8 pages of available memory into high mem. */
#define PROM_PAGES 8

typedef unsigned /* long */	Bit32; /* lint dislikes unsigned long fields */
typedef unsigned short	Bit16;
typedef unsigned char	Bit8;
typedef long		sBit32;
typedef short		sBit16;
typedef char		sBit8;

#ifndef __STDC__
extern Bit8 Fc3ReadBit8(/*addr*/);		/* read an 8-bit quantity */
extern Bit16 Fc3ReadBit16(/*addr*/);		/* read a 16-bit quantity */
extern Bit32 Fc3ReadBit32(/*addr*/);		/* read a 32-bit quantity */
extern void Fc3WriteBit8(/*addr, value*/);	/* write an 8-bit quantity */
extern void Fc3WriteBit16(/*addr, value*/);	/* write a 16-bit quantity */
extern void Fc3WriteBit32(/*addr, value*/);	/* write a 32-bit quantity */
#endif

/* CPU Layer (Architecure manual, chapter 4) */
/* Addresses and formats for various things in "function code 3" space.
 *  These are accessed using the MOVS instruction with the
 *  value 3 in the function code registers */

#define SPACE(space)(space<<28)

/* - MMU entries for virtual address v in the current address space */
#define PageMapAddr(v)		(SPACE(0x1)|(((Bit32)(v))&0x0fffe000))
#define SegMapAddr(v)		(SPACE(0x2)|(((Bit32)(v))&0x0ffe0000))
#define CONTEXT_REGISTER	SPACE(0x3)

/* MMU hardware characteristics (manual, chapter 4) */

/* Size of a page, a segment, and a context (address space) */
#define PAGE_SIZE	0x2000		/*   8 Kbytes */
#define SEG_SIZE	0x20000		/* 128 Kbytes */
#define CONTEXT_SIZE	0x10000000	/* 256 Mbytes */
#define PROCESSMAXSTACK (SEG_SIZE / 2)	/* works with SEG_SIZE */
#define MAXKERNELSTACK	(PAGE_SIZE)

#define NUM_CONTEXTS	8		/* Total number of contexts */
#define	NUM_PMEGS	256		/* Number of PMEGs available */

#define SEGS_PER_CTX	(CONTEXT_SIZE/SEG_SIZE)	/*  */
#define PGS_PER_SEG	(SEG_SIZE/PAGE_SIZE)	/*  */

/* - Structure of the context register */
typedef Bit8 ContextRegister;

/* For LRU segment map swapping */
#define MAP_NOT_RESIDENT 0xff	/* an invalid context register value */
#define FreePmegAt(x) FreePmeg(GetSegMap(x))
extern struct _Aspace *AddressableAspace;

/* - Pmeg, placed in segment maps */
typedef Bit8 Pmeg;

/* - Page map entry */
typedef union {
  struct {
    Bit32 valid:1;		/* 1 = Valid page */
    Bit32 protection:3;		/* PAGE_WRITE, SUPER_ONLY, DONT_CACHE */
    Bit32 type:2;		/* Page type; see below */
    Bit32 accessed:1;		/* Page has been accessed */
    Bit32 modified:1;		/* Page has been modified */
    Bit32 reserved:5;
    Bit32 pagenum:19;		/* Page number (physical address) */
  } f;
  Bit32 u;	/* Whole thing as an unsigned integer */
} PageMapEntry;
	
/* Protection bits */
#define PAGE_WRITE	0x4
#define SUPER_ONLY	0x2
#define	DONT_CACHE	0x1

/* Page types */
#define ONBOARD_MEM	0	/* "Onboard" (P2 bus) */
#define ONBOARD_IO	1	/* Onboard devices */
#define VME_16		2	/* VMEbus 16 bit data space */
#define VME_32		3	/* VMEbus 32 bit data space */

/* - Structure of a virtual address */
typedef union
  {
    /* Fields */
    struct
      {
	Bit32	unused:4;
	Bit32	segment:11;	/* Segment number */
	Bit32	page:4;		/* Page number within segment */
	Bit32	byte:13;	/* Byte number */
      }
    f;
    char *p;		/* Whole thing as a character pointer */
    Bit32 u;		/* Whole thing as an unsigned 32-bit quantity */
  }
VirtualAddress;

/* Extract the page number (for the pagenum field of a page table entry)
 *   from a physical address */
#define ExtractPageNumber(p) ((p)>>13)	/* effectively same as p%PAGE_SIZE */
/* Extract the segment number from an address */
#define ExtractSegNumber(p) ((p)>>17)	/* effectively same as p%SEG_SIZE */

/*
 * Structure of a logical segment
 */
typedef struct sLSegment {
  unsigned short	refcount;
} LSegment;

extern Pmeg SegMap[NUM_PMEGS];

/*
 * Structure of a frame descriptor
 */
typedef enum { U_Monitor, U_Kernel, U_Malloc, U_Paged } FrameUse;
typedef struct sFrameTableEntry {
  FrameUse		use:3;
  unsigned		unused:13;
  unsigned short	SegmentIndex;
} FrameTableEntry, *FrameTableEntryPtr;

/* Page map entry used to indicate an unmapped page.  Note that the 
 * valid bit is not set!
 */
#define INVALID_PTE	(0x20000000)

#define NULL_PAGE (MAXPAGES + 1)
#define USE_PROM 0
#define USE_FREE 1
#define USE_USED 2
#define USE_KERNEL 3

/* Segment map entry used to indicate an unused segment.  This pmeg
 *   is filled with NULL_PAGE page entries.
 */
#define NULL_PMEG (NUM_PMEGS-1)

/* Round an address up to the nearest page boundary */
#define uptopage(addr)\
  ( ((((Bit32) (addr)) - 1) & (~(PAGE_SIZE-1))) + PAGE_SIZE )
/* Round an address up to the nearest segment boundary */
#define uptoseg(addr)\
  ( ((((Bit32) (addr)) - 1) & (~(SEG_SIZE-1))) + SEG_SIZE )
/* Round an address down to the nearest page boundary */
#define downtopage(addr)\
  ( ((Bit32) (addr)) & ~(PAGE_SIZE-1) )
/* Round an address down to the nearest segment boundary */
#define downtoseg(addr)\
  ( ((Bit32) (addr)) & ~(SEG_SIZE-1) )

/* Read and write MMU registers */
#define SetPageMap(addr, value) Fc3WriteBit32((char *)PageMapAddr(addr), (Bit32)(value))
#define SetSegMap(addr, value) Fc3WriteBit8((char *)SegMapAddr(addr), (Bit8)(value))
#define GetPageMap(addr) Fc3ReadBit32((char *)PageMapAddr(addr))
#define GetSegMap(addr)  Fc3ReadBit8((char *)SegMapAddr(addr))
#define SetContext(cxt)  Fc3WriteBit8((char *)CONTEXT_REGISTER, (Bit8)(cxt))
#define GetContext()     Fc3ReadBit8((char *)CONTEXT_REGISTER)&(NUM_CONTEXTS-1)

/* - Identification PROM (read only)*/
#define IDP SPACE(0x0)
#define IDP_FORMAT		0	/* format byte */
#define IDP_MACHINE_TYPE	1	/* machine type byte */
#define IDP_ENET_ADDRESS	2	/* start of Enet address (6 bytes) */
#define IDP_DATE		8	/* start of manuf. date (4 bytes) */
#define IDP_SERIAL_NUMBER	12	/* start of serial number (3 bytes) */
#define IDP_CHECKSUM		15	/* checksum (1 byte) */
#define IDP_RESERVED		16	/* reserved field (16 bytes) */

/* System Enable register (8 bits, read/write) */
#define SYSTEM_ENABLE_REGISTER	SPACE(0x4)
typedef union
  {
    struct
      {
	Bit8 enableBoot:1;	/* 0 = boot ; 1 = normal */
	Bit8 enableFPP:1;	/* enable floating point coprocessor */
	Bit8 enableDVMA:1;	/* enable VME DVMA */
	Bit8 enableCache:1;	/* enable external cache */
	Bit8 enableVideo:1;	/* enable video output to monitor */
	Bit8 enableCopy:1;	/* enable copy update mode to monitor */
	Bit8 enableFPA:1;	/* enable floating point accelerator */
	Bit8 diag:1;		/* State of diagnostic switch */
      } f;
    Bit8 u;
  }
SystemEnableRegister;

#define DVMA_ENABLE_REGISTER	SPACE(0x5)
typedef union
  {
    struct
      {
	Bit8 enable7:1;		/* Enable DVMA to context 7 */
	Bit8 enable6:1;
	Bit8 enable5:1;
	Bit8 enable4:1;
	Bit8 enable3:1;
	Bit8 enable2:1;
	Bit8 enable1:1;
	Bit8 enable0:1;		/* Enable DVMA to context 0 */
      }
    f;
    Bit8 u;
  }
DVMAEnableRegister;

/* - Diagnostic LED register (1 byte, write only) */
#define DIAGNOSTIC_REGISTER	SPACE(0x7)

/*
 * Physical addresses for things in onboard memory space
 *   These are addressed through page map entries of type ONBOARD_MEM.
 */
#define P_ONBOARD_RAM		0
#define P_ONBOARD_RAM_LIMIT	0x800000	/* No more than 8 Mbytes (?)*/
#define P_BW_FRAMEBUFFER	0xFF000000	/* "new" frame buffer */

/* Addresses for things in onboard mappable device space
 * These are addressed through page map entries of type ONBOARD_IO.
 */
#define P_KBD_MOUSE_UART	0x00000000
#define P_SERIAL_PORT		0x00020000
#define P_EEPROM		0x00040000
#define P_REAL_TIME_CLOCK	0x00060000
#define P_MEMORY_ERROR_REGS	0x00080000
#define P_INTERRUPT_REG		0x000A0000
#define P_INTEL_ETHERNET	0x000C0000
#define P_COLOR_MAP		0x000E0000
#define P_EPROM			0x00100000
#define P_AMD_ETHERNET		0x00120000
#define P_SCSI			0x00140000
#define P_IOX			0x001A0000 /* not on sun-3 */
#define P_ENCRYPTION_CHIP	0x001C0000

/* Conventional virtual addresses.
 */
#define MONITOR_START	0x0FE00000
#define MONITOR_END	0x0FF00000
#define MONITOR_SHORTPAGE 0xFFFFE000

#define KERNEL_LOADED_AT 0x0004000	/* Kernel is loaded at this address */
#define KERNEL_START	0x0F004000	/* Kernel is linked to be here */
#define KERNEL_MALLOC	0x0F100000	/* Kernel's malloc area */
#define KERNEL_MALLOC_LIMIT 0xF300000
#define KERNEL_LIMIT	0x0FD00000	/* end of kernel */
#define ASPACE_START 	0x00004000	/* Start of Aspace space */
#define ASPACE_LIMIT	0x0F000000	/* Address space size limit */
#define XFERSEG		0x0FF60000	/* Used by kernel for moving things */
#define KMAPPINGSEG	0x0ff80000	/* Pages from users are mapped here */
#define UMAPPINGSEG	(ASPACE_LIMIT - SEG_SIZE)
#define ENET_DATA_SEG   0x0FFE0000	/* 128k for buffer/data space */
#define TESTSEG		XFERSEG
#define TESTPAGE	XFERSEG

#define	CFBUFFER		0x0fd00000 /* through 0xfe00000 */
#define CFBUFFERSIZE		0x100000
#define FBUFFER			0x0FE20000
#define FBUFFERSIZE		0x020000
#define V_KBD_MOUSE_UART	0x0FE00000
#define V_SERIAL_PORT		0x0FE02000
#define V_EEPROM		0x0FE04000
#define V_REAL_TIME_CLOCK	0x0FE06000
#define V_MEMORY_ERROR_REGS	0x0FE08000
#define V_INTERRUPT_REG		0x0FE0A000
#define V_INTEL_ETHERNET	0x0FE0C000
#define V_COLOR_MAP		0x0FE0E000
#define V_AMD_ETHERNET		0x0FE10000
#define V_SCSI			0x0FE12000
#define V_IOX			0x00000000 /* not on sun-3 */
#define V_ENCRYPTION_CHIP	0x0FE14000
#define V_EPROM			0x0FEF0000

#define V_DVMA_START	0xF00000	/* Virtual address of DVMA space */
#define V_DVMA_LIMIT	0xF40000

/* end conventional addresses */

/* data structures for memory error registers */
typedef union
  {
    struct
      {
	Bit32 DVMAcycle:1;	/* Error occurred during a dvma cycle */
	Bit32 context:3;	/* Context register value at error time */
	Bit32 address:28;	/* Virtual address of error reference */
      }
    f;
    Bit32 u;
  }
MemoryErrorAddressRegister;

typedef union
  {
    struct
      {
	Bit8 pending:1;		/* Parity interrupt pending */
	Bit8 enable:1;		/* Enable parity check interrupts */
	Bit8 test:1;		/* Invert parity bit to test circuitry */
	Bit8 check:1;		/* Enable parity checking */
	Bit8 bytes:4;		/* Bytes within word that failed check */ 
      }
    f;
    Bit8 u;
  }
ParityMemoryErrorControlRegister;

typedef union
  {
    struct
      {
	Bit8 pending:1;		/* Parity interrupt pending */
	Bit8 enable:1;		/* Enable parity check interrupts */
	Bit8 bushold:1;		/* Hold memory bus mastership */
	Bit8 recording:1;
	Bit8 wbtimeout:1;	/* Writeback failure */
	Bit8 wberror:1;		/* Writeback error */
	Bit8 uncorrectable:1;
	Bit8 correctable:1;	/* See manual */
      }
    f;
    Bit8 u;
  }
ECCMemoryErrorControlRegister;

typedef struct
  {
    unsigned char control;
    unsigned char unused[3];
    unsigned long address; 
  }
MemoryErrorRegister;

/* Interrupt enable register control strcuture */
typedef struct
  {
    Bit8 enableInt7:1;		/* NMI - caught by chip */
    Bit8 enableInt6:1;		/* Serial chips (including mouse/keyboard) */
    Bit8 enableInt5:1;		/* 100Hz timer */
    Bit8 enableInt4:1;		/* Video */
    Bit8 enableInt3:1;		/* Ethernet */
    Bit8 enableInt2:1;
    Bit8 enableInt1:1;
    Bit8 enableInt:1;		/* Master interrupt enable */
  }
InterruptRegister;

/* Modes for Probe() function -- see memory.c */
#define PROBE_READ 1
#define PROBE_INIT 2
#define PROBE_PRESERVE 3

/*********************************************************
* Exported macros, functions, and typedefs
**********************************************************/

extern int Ms_InitMemory();
extern int Ms_CreateAspace();
extern int Ms_InitAs();
extern int Ms_FreePage();
extern int Ms_FreeMemory();
extern int Ms_SetAspaceSize();
extern int Ms_SetAddressableAspace();
extern char *Ms_MapPage();
extern char *Ms_AllocateKernelPage();
extern char *Ms_AllocateUserPage();

#define Ms_GetAddressableAspace()	AddressableAspace
#define Ms_GetAspaceSize(as)		(int) as->aspace_space.size

typedef struct {
  ContextRegister context;	/* SUN processor context number */
  unsigned char unused[3];	/* Keep things on longword boundary */
  char *size;			/* Nominal size (actual size is this, rounded
				   up to a page boundary) */
  long timestamp;
  Pmeg segmap[SEGS_PER_CTX];	/* Save area for segment map while swapped
				 * out of hardware registers */
} Ms_AspaceState;


#endif
E 1
