/*
 * ip.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#ifndef ip_h
#define ip_h
#ifndef upi_h
#include "upi.h"
#endif

#define	IPADLEN	sizeof(IPaddr)

#define CLASSA(ad) (~((ad).a) & 0x80)
#define CLASSB(ad) (((ad).a & 0x80) && (~((ad).a) & 0x40))
#define CLASSC(ad) (((ad).a & 0xC0) && (~((ad).a) & 0x20))


#define IP_EQUAL(a1,a2) (*(long *)&(a1) == *(long *)&(a2))
#define IP_NETEQ(a1,a2) (((a1).a==(a2).a) && \
			 (CLASSA(a1) || (((a1).b==(a2).b) && \
					 (CLASSB(a1) || ((a1).c==(a2).c)))))

typedef	struct {
  u_char a, b, c, d;
} IPhost;

typedef struct ipaddr {
  IPhost	host;
  u_char	protocolnum;
} IPaddr;

extern ip_getproc();

/* IP control opcodes */

#define IP_MYNET		(IP_CTL*MAXOPS+0)
#define IP_REDIRECT 		(IP_CTL*MAXOPS+1)
#define IP_SHOWSETTINGS 	(IP_CTL*MAXOPS+2)
#define IP_SETV 		(IP_CTL*MAXOPS+3)
#define IP_SETTOS 		(IP_CTL*MAXOPS+4)
#define IP_SETID 		(IP_CTL*MAXOPS+5)
#define IP_SETTTL 		(IP_CTL*MAXOPS+6)
#define IP_SETPROT 		(IP_CTL*MAXOPS+7)
#define IP_SETSRC 		(IP_CTL*MAXOPS+8)
#define IP_SETDEST	 	(IP_CTL*MAXOPS+9)
#define IP_SETSECURITY  	(IP_CTL*MAXOPS+10)
#define IP_SETLOOSERT	  	(IP_CTL*MAXOPS+11)
#define IP_SETSTRICTRT	 	(IP_CTL*MAXOPS+12)
#define IP_SETRECORDRT 		(IP_CTL*MAXOPS+13)
#define IP_SETSTREAMID 		(IP_CTL*MAXOPS+14)
#define IP_SETTIMESTAMP 	(IP_CTL*MAXOPS+15)
#define IP_CLRSECURITY  	(IP_CTL*MAXOPS+16)
#define IP_CLRLOOSERT  		(IP_CTL*MAXOPS+17)
#define IP_CLRSTRICTRT 		(IP_CTL*MAXOPS+18)
#define IP_CLRRECORDRT 		(IP_CTL*MAXOPS+19)
#define IP_CLRSTREAMID 		(IP_CTL*MAXOPS+20)
#define IP_CLRTIMESTAMP 	(IP_CTL*MAXOPS+21)


/* IP option classes */
#define IP_CONTROLOPT   0
#define IP_DEBUGGINGOPT 2

/* IP control option numbers */
#define IP_EOOPT     0
#define IP_NOOPT     1
#define IP_SECURITY  2
#define IP_LOOSE_RT  3
#define IP_STRICT_RT 9
#define IP_RECORD_RT 7
#define IP_STREAM_ID 8

#endif 
