h21044
s 00162/00000/00000
d D 1.1 90/12/09 00:24:10 menze 1 0
c date and time created 90/12/09 00:24:10 by menze
e
u
U
f e 0
t
T
I 1
/********************************************************************
/*
/* Test Layered Sprite RPC
/*	TRIPS: number of round trips per test
/*	TESTS: number of tests run
/*	REQ_BUF_SZ: size of request message (range between 1 and 16k)
/*	REQ_BUF_SZ: size of reply message (range between 1 and 16k)
/*
/*
/* modified for xkernel v3.1 072490 cliff hathaway
/*  IPaddr => IPhost, PART => Part, SESSN => Sessn
/*
/********************************************************************/

#include "xkernel.h"
#include "ip.h"
#include "select.h"
#include "chan.h"
#include "sfrag.h"
#include "site.h"

static PROTL IP, SELECT;

static unsigned short server_command = 99;

#define REQ_BUF_SZ  1
#define REP_BUF_SZ  8*1024

static  char	Request_buf[16*1024];
static  char	Reply_buf[16*1024];

IPhost client_host  = SITE_CLIENT_IP;
IPhost server_host  = SITE_SERVER_IP;

SELECTaddr SERVER;
char *SERVERNAME;

typedef struct {
  int sec, usec;
} time;

static time starttime, now, total;
#define TRIPS 100
#define TIMES 5
#define DELAY 2000

client()
{
  int p, s, i;
  int null();
  Part whom[3];
  int test = 0;

  s = NULL;
  p = xcreateprotl(null, null, null);
  printf("I am the client, talking to %s\n", SERVERNAME);
  whom[0].address = (char *)&SERVER;
  whom[0].length = sizeof(SELECTaddr);
  whom[1].address = (char *)0;
  whom[1].length = 0;
  s = xopen(p, SELECT, whom);
  for (test = 0; test < TIMES; test++) {
    printf("Starting test (%d) ...\n", test);
    xgettime(&starttime);
    for (i = 0; i<TRIPS; i++)
	 try_call(s);
    xgettime(&now);
    subtime(&starttime, &now, &total);
    printf("len = %d/%d, %d trips: %6d.%-6d\n", 
      REQ_BUF_SZ, REP_BUF_SZ, TRIPS, total.sec, total.usec);
    xpause(DELAY);
  }
}
  
server()
{
  int serverdemux(), null(), p;
  Part whom[2];
  printf("I am the  server (%s) %d\n", SERVERNAME, server_command);
  whom[0].address = (char *)&SERVER;
  whom[0].length = sizeof(SELECTaddr);
  whom[1].address = (char *)0;
  whom[1].length = 0;
  p = xcreateprotl(serverdemux, null, null);
  (void) xopenenable(p, SELECT, whom);
}

user(argc, argv)
int argc;
char **argv;
{
  IPhost ipaddr, nametoip();
  printf("Layered Sprite timing test\n");
  IP = xgetprotlbyname("ip");
  SELECT = xgetprotlbyname("select");
  SERVER.host = server_host;
  SERVER.command = server_command;
  SERVERNAME = SITE_SERVER_NAME;
  if (xcontrolprotl(IP, MYADDR, &ipaddr, sizeof(IPhost)) != sizeof(IPhost)) {
    printf("Cannot get my own IP addr\n");
    return;
  } else {
    printf("My IP addr = %d.%d.%d.%d\n", ipaddr.a,ipaddr.b,ipaddr.c,ipaddr.d);
  }

  while (argc > 1) {
    if (!strncmp(argv[1], "-s", 2)) {
      SERVER.host = ipaddr;
      SERVERNAME = malloc(24);
      iptoname(SERVER.host, SERVERNAME);
    } else if (!strncmp(argv[1], "-c", 2)) {
      client_host = ipaddr;
      SERVERNAME = &argv[1][2];
      SERVER.host = nametoip(SERVERNAME);
    }
    argc --;
    argv++;
  }
  if (IP_EQUAL(ipaddr, SERVER.host)) {
    xcreateprocess(server, 5, 0);
  }
  if (IP_EQUAL(ipaddr, client_host)) {
    xcreateprocess(client, 6, 0);
  }
}

null(s,m,length)
int s, length;
char *m;
{
}

serverdemux(s, m, length)
int s, length;
char *m;
{
  xpush(s, Reply_buf, REP_BUF_SZ, 0, 0);
}

subtime(t1, t2, t3)
time *t1, *t2, *t3;
{
  t3->sec = t2->sec - t1->sec;
  t3->usec = t2->usec - t1->usec;
  if (t3->usec < 0) {
    t3->usec += 1000000;
    t3->sec -= 1;
  }
}

try_call(sessn)
Sessn		sessn;
{
  int		reply_len;
  int		ret_val;

  reply_len = REP_BUF_SZ;
  ret_val = xpush(sessn,Request_buf,REQ_BUF_SZ,Reply_buf,&reply_len);
  if( ret_val < 0 ) {
    printf( "SELECT CLIENT: SELECT CALL GOT ERR %d\n",ret_val );
  }
}
E 1
