/*
 * nem.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "xkernel.h"
#include "eth.h"
#include "ip.h"
#include "arp.h"
#include "dns.h"
#include "scr.h"

static Enet10Address eaddr;
static Protl ETH, SCR;

ethequal(a, b)
register Enet10Address *a, *b;
{
  return a->high == a->high && a->mid == b->mid && a->low == b->low;
}

typedef struct {
  int sec, usec;
} time;

#define MAXINFO (10 * 12)
#define NERAS 20
#define BARWIDTH 8
typedef struct {
  Enet10Address src;
  unsigned short type;
  unsigned short ocount[NERAS], icount[NERAS];
  char eaddrstring[20];
  char namestring[32];
  int refresh;
} Info;

static int  thisera = 0;
static int  sort[MAXINFO];
static Info info[MAXINFO];
static int curx, cury, ninfo = 0, nsorted = 0, nnamed = 0;
static int size[2], width = 160, height = 80, hheight = 40;
static int xspace = 32, yspace = 0;
#define S(X) ((((X)+1)/2) >= hheight ? hheight-1 : (((X)+1)/2))

static short mytype = 0x98;
static int s_scr;
static Semaphore *nameS, *sortS, *accessS;

static void display(x, y, val)
int x, y, val;
{
  draw_box(x, y, x + BARWIDTH-1, y + hheight - val - 1, 0);
  if (val) draw_box(x, y + hheight - val, x + BARWIDTH-1, y+hheight-1, 1);
}

/*ARGSUSED*/
eventhandler(arg)
int arg;
{
  register int i, c;
  register int curx = 0, cury = 0;
  register Info *in;
  int lastera = thisera, nextera = (thisera + 1) % NERAS;

  for (i = 0; i < ninfo; i++) {
    in = &info[i];
    in->icount[nextera] = in->ocount[nextera] = 0;
  }
  thisera = nextera;
  
  xpsem(accessS);
  for (i = 0; i < ninfo; i++) {
    in = &info[sort[i]];
    if (in->refresh) {
      int j, k;
      for (j = 0; j < NERAS-1; j++) {
	k = (lastera - j + NERAS) % NERAS;
	c = S(in->ocount[k]);
	display(curx + BARWIDTH * j, cury, c);
	c = S(in->icount[k]);
	display(curx + BARWIDTH * j, cury+hheight, c);
      }
    } else {
      do_blt(curx+BARWIDTH, cury, curx, cury, width-BARWIDTH, height);
    }
    c = S(in->ocount[lastera]);
    display(curx+(NERAS-1)*BARWIDTH, cury, c);
    c = S(in->icount[lastera]);
    display(curx+(NERAS-1)*BARWIDTH, cury+hheight, c);

    if (in->refresh) {
      int x[2], len;
      len = strlen(in->eaddrstring);
      x[0] = cury + height;
      x[1] = curx + width / 2 - (len * 8) / 2;
      xcontrolprotl(SCR, SCR_GOTO, (char *)x, 8);
      xpush(s_scr, in->eaddrstring, len, 0, 0);

      len = strlen(in->namestring);
      x[0] = cury + height + 16;
      x[1] = curx + width / 2 - (len * 8) / 2;
      xcontrolprotl(SCR, SCR_GOTO, (char *)x, 8);
      xpush(s_scr, in->namestring, len, 0, 0);
      in->refresh = 0;
    }

    in->ocount[nextera] = in->icount[nextera] = 0;
    curx += width + xspace;
    if (curx >= size[0] - width) {
      curx = 0;
      cury += height + 32 + yspace;
    }
  }
  xvsem(accessS);
}

namer()
{
  int x[2];
  char buffer[256];
  register Info *in;

  while (1) {
    xpsem(nameS);
    in = &info[nnamed];
    ethtoname(in->src, buffer);
    buffer[31] = '\0';
    strcpy(in->namestring, buffer);
    nnamed++;
    in->refresh = 1;
    xvsem(sortS);
  }
}

sorter()
{
  register Info *in;
  int i;
  while (1) {
    xpsem(sortS);
    xpsem(accessS);
    in = &info[nsorted];
    for (i = nsorted - 1; i >= 0; i--) {
      if (strcmp(info[sort[i]].namestring, in->namestring) < 0) {
	sort[i+1] = sort[i];
	info[sort[i]].refresh = 1;
      } else {
	break;
      }
    }
    sort[i+1] = nsorted;
    info[sort[i+1]].refresh = 1;
    nsorted++;
    xvsem(accessS);
  }
}

user(argc, argv)
int argc;
char **argv;
{
  int p, s;
  int clientdemux(), null();
  PART whom[3];
  int true = 1;

  ETH = xgetprotlbyname("eth");
  SCR = xgetprotlbyname("scr");

  if (xcontrolprotl(ETH, GETMYADDR, (char *)&eaddr, 6) != 6) {
    printf("Cannot get my own enet addr\n");
    return;
  } 
  if (xcontrolprotl(SCR, SCR_GETSIZE, (char *)size, sizeof size) < 0) {
    printf("Cannot get screen size\n");
    return;
  } 
  nameS  = (Semaphore *)xcreatesemaphore(0);
  printf("names = %X\n", nameS);
  sortS  = (Semaphore *)xcreatesemaphore(0);
  printf("sorts = %X\n", sortS);
  accessS = (Semaphore *)xcreatesemaphore(1);
  printf("accesss = %X\n", accessS);
  s = NULL;
  p = xcreateprotl(clientdemux, null, null);
  whom[0].address = 0;
  whom[0].length = 0;
  s_scr = xopen(p, SCR, whom);
  whom[0].address = (char *) &mytype;
  whom[0].length = 2;
  whom[1].address = (char *)&eaddr;
  whom[1].length = sizeof(Eaddr);
  whom[2].address = (char *)0;
  whom[2].length = 0;
  if ((s = xopen(p, ETH, whom)) <= 0) {
    printf("Can't open the ethernet session\n");
    return;
  }
  if (xcontrolsessn(s, ETH_SETPROMISCUOUS, (char *)&true, sizeof true) != sizeof true){
    printf("Can't set promiscuious\n");
    xclose(s);
    return;
  }
  xeventregister(eventhandler, 0, 1000, EV_REPEAT);
  xcreateprocess(namer,  4, 0);
  xcreateprocess(sorter, 3, 0);
}

null()
{
}

Info *findinfo(addr, type)
char *addr;
unsigned short type;
{
  register int i;
  register Info *in;
  char buffer[256], *buf;

  for (i = 0; i < ninfo; i++) {
    in = &info[i];
    if (!bcmp((char *)&in->src, addr, 6)) break;
  }
  if (i >= ninfo) {
    in = &info[i];
    sort[i] = i;
    bcopy(addr, (char *)&in->src, 6);
    in->type = type;
    in->icount[thisera] = in->ocount[thisera] = 0;
    buf = buffer;
    hexprint(buf, in->src.high, 4);
    buf += 4;
    *buf++ = '.';
    hexprint(buf, in->src.mid, 4);
    buf += 4;
    *buf++ = '.';
    hexprint(buf, in->src.low, 4);
    buf += 4;
#ifdef DOTYPE
    *buf++ = ' ';
    hexprint(buf, in->type, 4);
    buf += 4;
#endif
    *buf = '\0';
    strcpy(in->eaddrstring, buffer);
    xvsem(nameS);
    ninfo ++;
  }
  return in;
}

/*ARGSUSED*/
clientdemux(s, m, length)
int s, length;
char *m;
{
  register Info *in;
  in = findinfo(m, *(unsigned short *)m + 12);
  in->icount[thisera] ++;
  in = findinfo(m+6, *(unsigned short *)m + 12);
  in->ocount[thisera] ++;
}

draw_line(x1, y1, x2, y2)
{
  long l[4];
  l[0] = x1;
  l[1] = y1;
  l[2] = x2;
  l[3] = y2;
  xcontrolprotl(SCR, SCR_LINE, (char *)l, sizeof l);
}

draw_box(x1, y1, x2, y2, on)
{
  long l[5];
  l[0] = x1;
  l[1] = y1;
  l[2] = x2;
  l[3] = y2;
  l[4] = on;
  xcontrolprotl(SCR, SCR_BLT, (char *)l, sizeof l);
}

do_blt(x1, y1, x2, y2, dx, dy)
{
  long l[6];
  l[0] = x1;
  l[1] = y1;
  l[2] = x2;
  l[3] = y2;
  l[4] = dx;
  l[5] = dy;
  xcontrolprotl(SCR, SCR_BITBLT, (char *)l, sizeof l);
}
