/*
 * testdns.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "xkernel.h"
#include "ip.h"
#include "dns.h"

static Protl DNS;

user(argc,argv)
int	argc;
char	*argv[];
{
  char buf[sizeof(Result)];
  Result *r;
  int status, i;

  DNS = xgetprotlbyname("dns");
  printf("You are running a client-side test of the Domain Naming System\n");
  printf("Enter a name and learn an IP address (or vice versa)\n\n");
  while (1) {
    printf("Name: ");
    scanf("%s", buf);
    if (!strcmp(buf, ".")) break;
    printf("Trying to resolve '%s'\n", buf);
    status = xcontrolprotl(DNS,
      '0' <= *buf && *buf <= '9' ? RRESOLVE : RESOLVE,
      buf, sizeof(Result));
    if (status < 0) {
      printf("Can't resolve the name '%s'\n", buf);
    } else {
      r = (Result *)buf;
      printf("name=%s\n", r->name);
      for (i = 0; i < status; i++) {
	printf("    address[%d] = <%d.%d.%d.%d>\n", i, r->addr[i].a,
	     r->addr[i].b,r->addr[i].c,r->addr[i].d);
      }
    }
  }
  return(0);
}



