/* 
 * copydate.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
extern int errno;

usagePanic()
{
  fprintf(stderr, "Usage: copydate <from> <to>\n");
  exit(1);
}

extern int sys_nerr;
extern char *sys_errlist[];

sysPanic(s, n)
char *s;
int n;
{
  char *code;
  
  if (n <= 0 || n > sys_nerr) {
    code = "Unknown kernel error";
  } else {
    code = sys_errlist[n];
  }
  fprintf(stderr, "copydate: %s: %s\n", s, code);
  exit(1);
}

main(argc, argv)
int argc;
char **argv;
{
  struct stat buf;
  if (argc != 3) usagePanic(0);
  if (stat(argv[1], &buf) < 0) sysPanic(argv[1], errno);
  if (utimes(argv[2], &buf.st_atime) < 0) sysPanic(argv[2], errno);
  exit(0);
}

