/* 
 * editnl.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include <stdio.h>
#include <a.out.h>
#include "sisc.h"
#define min(A,B) ((A) < (B) ? (A) : (B))
#define max(A,B) ((A) > (B) ? (A) : (B))
SISc replace;

panic(s)
char *s;
{
  fprintf(stderr, "%s\n", s);
  exit (1);
}

Usage()
{
  panic("Usage: editnl [-s src dest] ... file");
}

char *srcfilename;
FILE *srcfile;
static struct exec hdr;
#define SIZE 8096

char *stringTable;
long size;

readStringTable()
{
  char *ptr, *key, *value, *malloc();
  if (fread((char *)&size, sizeof size, 1, srcfile) != 1) panic("Can't read string table size");
  stringTable = malloc(size);
  *(long *)stringTable = size;
  if (fread(&stringTable[4], 1, size - 4, srcfile) != size - 4)
    panic("Can't read string table");
}

doSymbols()
{
  char *c, *r;
  int len;
  for (c = &stringTable[4]; c < &stringTable[size]; c += len+1) {
    len = strlen(c);
    if (r = (char *)SIScLookup(replace, c)) {
      fseek(srcfile, N_STROFF(hdr)+c-stringTable, 0);
      fwrite(r, 1, len, srcfile);
      SIScDelete(replace, c);
    }
  }
  if (SIScSize(replace) > 0) { 
    SIScForEach(replace, c, r) {
      printf("Couldn't find the symbol %s\n", c);
    } SIScNext();
    exit(1);
  }
}

doit()
{
  int pos;
  if (fread((char *)&hdr, sizeof hdr, 1, srcfile) != 1) panic("Can't read hdr");
  if (hdr.a_syms == 0) panic("file is stripped");
  /* Now go find the string table */
  fseek(srcfile, N_STROFF(hdr), 0);
  readStringTable();
  doSymbols();
}

main(c, v)
int c;
char **v;
{
  --c;
  ++v;
  replace = SIScCreate();
  while (c) {
    if (**v == '-') {
      ++*v ;
      switch (**v) {
	case 's':
	  if (c < 3) Usage();
	  if (strlen(v[1]) != strlen(v[2])) panic("Length of src and dst must be the same");
	  SIScInsert(replace, v[1], v[2]);
	  c -= 2;
	  v += 2;
	  break;
	default:
	  Usage();
	  break;
      }
    } else if (!srcfilename) {
      srcfilename = *v;
    } else {
      Usage();
    }
    --c;
    ++v;
  }
  if (!srcfilename) Usage();
  srcfile = fopen(srcfilename, "r+");
  if (!srcfile) Usage();
  doit();
  fclose(srcfile);
}
