#include <stdio.h>
#include "gp.h"
#include "sc.h"

#define NAME 0
#define GFILE 1
#define PORT 2
#define X    3
#define Y    4
#define IN   5
#define ID   7
#define END  6
#define DEV  8
#define G_X_OFF 50
#define G_Y_OFF 50

extern int WORK_H;
int c = -1;
int x = 0 ,y = 0 ,width;
int row, col;


Graph
load_file(f)
char *f;

 {

     FILE   *fp;
     int    token,file,flag;
     Graph  g;
     char   buf[200];
     nodeptr q;
     TEPtr   p;
     te      t;

     row = G_X_OFF;  col = WORK_H - G_Y_OFF;
     strcpy(t.device,"yes");
     t.ports[0] = '\0';
     t.files[0] = '\0';
     t.id[0] = '\0';
     x = y = 0;

     g = gpNew();
      
     fp = fopen(f,"r");
     if ( fp == NULL ) 
       {
         fprintf(stderr,"Sorry, but cann't open file %s\n",f);
         gpDestroy(g);
         return(NULL);
       }

      g->file = strsave(f); 
      fprintf(stderr,"Opened file %s \n",f);
      while ( ( token = get_token(fp,buf)) != END )
           switch(token) {
         
           case NAME:     p = ScLookup(dbase,buf);
                          if (p != NULL &&  strcmp(p->device,t.device) != 0 )
                               fprintf(stderr,"protocol %s is a device protocol\n",buf);
                          strcpy(t.name,buf);
                          break;

           case GFILE:    if ( p == NULL )  
                              strcpy(t.files,buf);
                          else 
                           {
                             if ((p->files[0]!='\0') && (strcmp(buf,p->files)!=0))
                   fprintf(stderr,"Files do not match in protocol %s with those in the data base \n",t.name);
                           strcpy(p->files,buf);
                           }
                           file = 1;
                           break;

           case PORT:      strcpy(t.ports,buf);
                           break;
 
           case X:         x = atoi(buf);
                           break;

           case ID:        if ( p != NULL )
                             strcpy(p->id,buf);
                             
                           break;

           case Y:        y = atoi(buf);
                          break;

           case IN:       flag = 1;
                          t.pnum = nocomma(t.ports);
                          if ( p == NULL )
                           {
                             strcpy(t.type,t.name);
                             p = ScInsert(dbase,&t);
                             enterfile(p);
                             add_entry(t.type);
                           }
                          width = ((p->pnum-1)*HALF_WIDTH) + NODE_W; 
                          if ( x == 0 && y == 0 )
                               flag = gparse(g,t.name,t.ports,t.pnum);
                          if ( flag == 1 )
                            {
                              q = gpDefineNode(g,x,y,t.name,width);
                              strcpy(q->id,t.id);
                              if ( q != NULL ) {
                                   q->f = file;
                                  putedge(g,q,t.ports);
                               }
                            } 
                              
                          x = 0; y = 0; file = 0; t.ports[0] = '\0';
                          t.files[0] = '\0';
                          t.id[0] = '\0';
                          c = -1;
                          break;

           case DEV:      strcpy(t.device,"no");
                          while((c = getc(fp)) != ';' )
                                    ;
                          c = -1;  break;
           } 
     
        return(g);

   }


int get_token(fp,buf)
FILE *fp;
char *buf;

   {

      int i,token;
     
      if ( c == ';' )
           return(IN);
      while( (c = getc(fp)) ==  ' ' || c  == '\n') 
               ;
      if ( c == EOF )
           return(END);
      if ( c == 'n' )
          token = NAME;
      else if ( c == 'f' )
          token = GFILE;
      else if ( c == 'p' )
          token = PORT;
      else if ( c == 'x' )
          token = X;
      else if ( c == 'y' )
          token = Y;
      else if ( c == 'i' )
          token = ID;
      else if ( c == '@' )
            return(DEV);
      else if ( c == '&' )
            return(END);
            

      while ( c != '=' )
              c = getc(fp);

      for(i=0,c = getc(fp); c != ' ' && c != ';'; c = getc(fp), i++)
              buf[i] = c;
      buf[i] = '\0';

      return(token);
    }


nodeptr nodebyname(g,s)
Graph g;
char *s;

 {
   nodeptr q;

   for(q = g->root; q != NULL; )
      if ( strcmp(q->type,s) == 0 )
           return(q);
      else
         {
           if ( q->right == g->root )
            {
              fprintf(stderr,"cann't find node %s, illegal dependency\n",s);
              return(NULL);
            }
           q = q->right;

         }
   fprintf(stderr,"cann't find node %s, illegal dependency\n",s);
   return(NULL);
  }

int edgebyname(p,s)
nodeptr p;
char *s;

 {
   int i;


   for(i=0; i <= p->pnum; i++)
      if ( strcmp(p->ports[i].name,s) == 0 )
           return(i);
   return(-1);

  }
int 
nocomma(port)
char *port;

 {
  int i,j;
  
  for(i=0,j=0; port[i] != '\0'; i++ )
     if ( port[i] == ',' )
       {
          port[i] = ' ';
          j++;
       }

   if ( i > 0 )
        j++;

    return(j);

 }


int
gparse(g,name,port,num)
Graph g;
char *name;
char *port;
int num;

 {

     char s[128];
     int  i,j, tempx,tempy;
     nodeptr p,q;

     j = 0;  tempx = -1; tempy = 10000;
  
      if ( num == 0 ||  port[0] == '\0' )
        {
           x = row; row = row + width + G_X_OFF; y = col; 
           while( (p = findnode(g,x,y,width,NODE_H)) !=NULL)
             row = x = p->name.x + p->name.width + G_X_OFF;
           return(1);
        }
     i = 0;
     while(num > 0 )
      {
     for(j=0; port[i] != '\0'; i++)
        if ( port[i] == ' ' )
          {
             i++;
             break;
          }
        else 
           {
             s[j] = port[i];
             j++;
           }

      s[j] = '\0';
     
       q = nodebyname(g,s);
       if ( q == NULL )
            return(0);
        x = q->name.x;
        y = q->name.y - (NODE_H + G_Y_OFF);

       if ( tempy > y )
            tempy = y;
       num--;
      }
       y = tempy;
       while ( ( p = findnode(g,x,y,width,NODE_H)) != NULL)
                 x = p->name.x + p->name.width + G_X_OFF;

      row = x;
      col = y;
      return(1);

  }
                

putedge(g,new,port)
Graph g;
nodeptr new;
char *port;

 {

     nodeptr q;
     llist *tp, *tq;
     int a, i, j;
     char  s[128];

     i = 0;
     while( port[i] != '\0' )
      {
        for(j=0; port[i] != '\0' && port[i] != ' ' ; i++, j++)
                 s[j] = port[i];

        if ( port[i] == ' ') i++;
        s[j] = '\0';
        a = edgebyname(new,s);
        if ( a < 0 )
          {
            fprintf(stderr,"Error: cann't find port to connect edge\n");
            return;
          }
        q = nodebyname(g,s);
        if ( q == NULL )
             return;
        tp = new_llist(0,q);
        tq = new_llist(a,new);
        port_insert(&(new->ports[a].other),tp);
        port_insert(&(q->ports[0].other),tq);
      }

 }
     
