/*     
 * ip_util.c
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.2 $
 * $Date: 1992/01/15 02:08:10 $
 */

#include "xkernel.h"
#include "ip.h"

/*
 * ipIsBroadcast -- this has to be refined in the presence of subnetting
 */
bool
ipIsBroadcast( h )
    IPhost *h;
{
    if ( CLASSA(*h) ) {
	return (h->b & h->c & h->d == 0xff) || (h->b | h->c | h->d == 0);
    }
    if ( CLASSB(*h) ) {
	return (h->c & h->d == 0xff) || (h->c | h->d == 0);
    }
    if ( CLASSC(*h) ) {
	return (h->d == 0xff) || (h->d == 0);
    }
    /*
     * Check for broadcast with all bits set
     */
    return (h->a & h->b & h->c & h->d == 0xff);
}
