# 			//// Makefile for DMAKE. \\\\
# The target system is characterized by the following macros imported from
# the environment.
#
#	OS	      - gives the class of operating system
#	OSRELEASE     - optionally gives the particular release of the OS above.
#	OSENVIRONMENT - optionally gives the environment under which the above
#			OS is in use.
#
# Valid values for the above macros are:
#
#	OS            - unix, msdos, tos
#       OSRELEASE     - bsd43, sysvr3, 386ix
#		      - tccdos, mscdos  (valid only of OS == msdos)
#       OSENVIRONMENT - uw {valid for unix, bsd43 configuration only.}
#			vf (valid for unix, bsd43 configuration only.)
#
# See the config.mk file in the relevant subdirectories for additional
# comments describing when a setting is applicable.

# First target in the makefile, do this so that targets declared in the
# included files are never marked as being the first *default* target.
first : all ;

# Pull in the configuration macros, from the environment.  OS is required,
# OSRELEASE, and OSENVIRONMENT are optional.
.IF $(OS) == $(NULL)
   .IMPORT : OS
.END
.IMPORT .IGNORE : OSRELEASE OSENVIRONMENT TMPDIR

# Define the source files
SRC =\
	infer.c make.c stat.c expand.c string.c hash.c dag.c dmake.c\
	path.c imacs.c sysintf.c parse.c getinp.c quit.c\
	basename.c dump.c macparse.c rulparse.c percent.c function.c

# Common Include files.
HDR = dmake.h extern.h struct.h vextern.h patchlvl.h version.h

# Define the TARGET we are making, and where the OBJECT files go.
OBJDIR := objects
TARGET  = dmake$E
CFLAGS += -DHELP -I. -Icommon

# Meta rule for making .o's from .c's (give our own so we can move object
# to objects directory in a portable, compiler independent way)
# Define it before the .INCLUDE so that different OS combinations can redefine
# it.
%$O : %.c
	%$(CC) -c $(CFLAGS) $<
	mv $(@:f) $(OBJDIR)

# Pull in the proper configuration file, based on the value of OS.
.INCLUDE : $(OS)/config.mk

# Set the .SOURCE targets so that we look for things in the right place.
.SOURCE.c :^ .NULL
.SOURCE.h :^ .NULL
.SOURCE$O :^ $(OBJDIR)
.PRECIOUS : $(HDR)

# Must come after the above INCLUDE so that it gets ALL objects.
OBJECTS	:= {$(ASRC:b) $(SRC:b)}$O

# The main target, make sure the objects directory exists first.
# LDARGS is defined in config.mk file of each OS/OSRELEASE combination.
all : $(TARGET);
$(TARGET) : $(OBJDIR)
$(TARGET) : $(OBJECTS);$(LD) $(LDARGS)

# Other obvious targets...
$(OBJDIR):;+-mkdir $@

# remaining dependencies should be automatically generated
sysintf$O  : $(OS)/sysintf.h
ruletab$O  : $(OS)/startup.h  #khc 01NOV90 - dependency was missing
$(OBJECTS) : $(HDR)
.SOURCE.h  : common

# Define the macros for printing the source, and pull in the 
# makefile portion.
PRINTEXCLUDE = $(OBJDIR) $(OBJDIR).dbg test RCS control man common
.INCLUDE : common/print.mk

clean:;+ $(RM) -rf dmake$E dbdmake$E objects*

# Rules for making the manual pages.
man .SETDIR=man : dmake.nc ;
dmake.nc : dmake.p ; scriptfix < $< > $@
dmake.p  : dmake.tf; typeset -man -Tdumb $< > $@

#--------------------------------------------------------------------------
# Make the various archives for shipping the thing around.
#
archives : zoo tar shar;
zoo   : dmake.zoo ;
shar  : dmake.shar;
tar   : dmake.tar;
unzoo : dmake.zoo ; zoo xO// dmake.zoo
dmake.zoo  .SILENT: src-list
[
	echo "" >> $<
	echo -n '$@ : $$(ALLSRC);@ zoo aI $$@ < ' >> $<
        echo -n '<' >> $<
        echo -n '+' >> $<
        echo -n '$$(ALLSRC:t"\n")\n' >> $<
        echo -n '+' >> $<
        echo '>' >> $<
	$(MAKECMD) -f $< $@
	$(RM) -f $<
]

dmake.shar .SILENT : src-list-shar
[
	echo '$@:$$(ALLSRC) ;xshar -vc -o$@ -l40 $$(ALLSRC)' >> $<
	$(MAKECMD) -f $< $@
	$(RM) -f $<
]

dmake.tar : src-list
[
	echo '$@ .SILENT :$$(ALLSRC) ;tar -cf $@ $$(ALLSRC)' >> $<
	$(MAKECMD) -f $< $@
	mkdir dmake
	cd dmake
	tar xf ../$@; chmod -R u+rw .
	cd ..
	tar cf $@ dmake
	$(RM) -rf $< dmake
]

src-list .SILENT: clean man
	echo 'ALLSRC = \' >$@
	find . -type f -print |\
	sed -e 's/RCS\///' -e 's/,v//' -e 's/$$/\\/' -e 's/^\.\// /'|\
	sort -u |\
	grep -v tst | grep -v $@ | grep -v LICENSE |\
	grep -v '\.zoo' | grep -v '\.tar'| grep -v '\.shar' >> $@
	echo ' LICENSE' >> $@

src-list-shar .SILENT: clean man
	echo 'ALLSRC = \' >$@
	find . -print |\
	sed -e 's/RCS\///' -e 's/,v//' -e 's/$$/\\/' -e 's/^\.\// /'|\
	sort -ur |\
	grep -v tst | grep -v $@ | grep -v LICENSE | grep -v RCS |\
	grep -v '^\.\\$$' | grep -v '\.zoo' | grep -v '\.tar'|\
	grep -v '\.shar' >> $@
	echo ' LICENSE' >> $@


#--------------------------------------------------------------------------
# This section can be used to make the necessary script files so that dmake
# can be bootstrapped.
#
#	dmake scripts	-- makes all the script files at once.
#
SH_n = $(@:s/swp-/-/:s,-,/,:s/scripts/${SCRIPTFILE}/)
MS_n = MAKESTARTUP=$(@:s/swp-/-/:s,-,/,:s/scripts/startup.mk/)
SH = $(SH_n:s/c40d/cd/:s/c50d/cd/:s/c51d/cd/:s/c60d/cd/)
MS = $(MS_n:s/c40d/cd/:s/c50d/cd/:s/c51d/cd/:s/c60d/cd/)
FIX-SH = $(SH:s,fix/,,)

scripts: unix-scripts atari-tos-scripts msdos-scripts os2-scripts

# To add a new environment for UNIX, simply create the appropriate entry
# in the style below for the macro which contains the OS, OSRELEASE and
# OSENVIRONMENT flags.  Then add the entry as a recipe line for the target
# unix-scripts.
#
unix-bsd43-scripts-flags   = OS=unix OSRELEASE=bsd43  OSENVIRONMENT=
unix-sysvr3-scripts-flags  = OS=unix OSRELEASE=sysvr3 OSENVIRONMENT=
unix-sysvr1-scripts-flags  = OS=unix OSRELEASE=sysvr1 OSENVIRONMENT=
unix-386ix-scripts-flags   = OS=unix OSRELEASE=386ix  OSENVIRONMENT=
unix-bsd43-uw-scripts-flags= OS=unix OSRELEASE=bsd43  OSENVIRONMENT=uw
unix-bsd43-vf-scripts-flags= OS=unix OSRELEASE=bsd43  OSENVIRONMENT=vf
tos--scripts-flags          = OS=tos  OSRELEASE=       OSENVIRONMENT=

unix-scripts .SWAP : clean
	$(MAKE) SCRIPTFILE=make.sh unix-bsd43-scripts
	$(MAKE) SCRIPTFILE=make.sh unix-bsd43-uw-scripts
	$(MAKE) SCRIPTFILE=make.sh unix-bsd43-vf-scripts
	$(MAKE) SCRIPTFILE=make.sh unix-sysvr3-scripts
	$(MAKE) SCRIPTFILE=make.sh unix-sysvr1-scripts
	$(MAKE) SCRIPTFILE=make.sh unix-386ix-scripts

unix-%-scripts .SWAP :; $(MAKECMD) -ns $(MS) $($@-flags) >$(SH)
tos-%-scripts  .SWAP :; $(MAKECMD) -ns $(MS) $($@-flags) >$(SH)

atari-tos-scripts .SWAP : clean
	$(MAKE) SCRIPTFILE=make.sh tos--scripts

# We make the standard dos scripts here, but we have to go and fix up the
# mkXX.bat file since it contains names of temporary files for the response
# files required by the linker.  We need to also construct the response file
# contents.  These two functions are performed by the fix-msdos-%-scripts
# meta-target.
#
# To add a new DOS environment just do what is described for adding a new
# unix environment, and then make certain that the fix-msdos-%-scripts target
# performs the correct function for the new environment.
msdos-cf = OS=msdos OSENVIRONMENT=
msdos-tccdos-scripts-flags = $(msdos-cf) OSRELEASE=tccdos SWAP=n
msdos-tccdosswp-scripts-flags = $(msdos-cf) OSRELEASE=tccdos
msdos-msc40dos-scripts-flags= $(msdos-cf) OSRELEASE=mscdos SWAP=n MSC_VER=4.0
msdos-msc40dosswp-scripts-flags = $(msdos-cf) OSRELEASE=mscdos MSC_VER=4.0
msdos-msc50dos-scripts-flags= $(msdos-cf) OSRELEASE=mscdos SWAP=n MSC_VER=5.0
msdos-msc50dosswp-scripts-flags = $(msdos-cf) OSRELEASE=mscdos MSC_VER=5.0
msdos-msc51dos-scripts-flags= $(msdos-cf) OSRELEASE=mscdos SWAP=n MSC_VER=5.1
msdos-msc51dosswp-scripts-flags = $(msdos-cf) OSRELEASE=mscdos MSC_VER=5.1
msdos-msc60dos-scripts-flags= $(msdos-cf) OSRELEASE=mscdos SWAP=n MSC_VER=6.0
msdos-msc60dosswp-scripts-flags = $(msdos-cf) OSRELEASE=mscdos MSC_VER=6.0

msdos-scripts: clean msdos-tcc-scripts msdos-msc-scripts;

msdos-tcc-scripts .SWAP :
	$(MAKE) SCRIPTFILE=mk.bat msdos-tccdos-scripts
	$(MAKE) SCRIPTFILE=mkswp.bat msdos-tccdosswp-scripts

msdos-msc-scripts .SWAP :! 40 50 51 60
	$(MAKE) SCRIPTFILE=mk$?.bat msdos-msc$?dos-scripts
	$(MAKE) SCRIPTFILE=mk$?swp.bat msdos-msc$?dosswp-scripts

msdos-%-scripts .SWAP :
	$(MAKE) -nus $(MS) $($@-flags) >$(SH)
	$(MAKE) -s $(MAKEMACROS) $(MS) $($@-flags) fix-msdos-$*-scripts


# We make the standard OS/2 scripts here, but we have to go and fix up the
# mkXX.bat file since it contains names of temporary files for the response
# files required by the linker.  We need to also construct the response file
# contents.  These two functions are performed by the fix-msdos-%-scripts
# meta-target.
#
# To add a new OS/2 environment just do what is described for adding a new
# unix environment, and then make certain that the fix-msdos-%-scripts target
# performs the correct function for the new environment.
os2-cf = OS=os2 OSENVIRONMENT=
os2-msc40dos-scripts-flags= $(os2-cf) OSRELEASE=mscdos SWAP=n MSC_VER=4.0
os2-msc50dos-scripts-flags= $(os2-cf) OSRELEASE=mscdos SWAP=n MSC_VER=5.0
os2-msc51dos-scripts-flags= $(os2-cf) OSRELEASE=mscdos SWAP=n MSC_VER=5.1
os2-msc60dos-scripts-flags= $(os2-cf) OSRELEASE=mscdos SWAP=n MSC_VER=6.0

os2-scripts: clean os2-msc-scripts;

os2-msc-scripts .SWAP :! 40 50 51 60
	$(MAKE) SCRIPTFILE=mk$?.cmd os2-msc$?dos-scripts

os2-%-scripts .SWAP :
	$(MAKE) -nus $(MS) $($@-flags) >$(SH)
	$(MAKE) -s $(MAKEMACROS) $(MS) $($@-flags) fix-os2-$*-scripts

# Signify NULL targets for the various MSC compiler versions.
40 50 51 60:;

# Go over the created script file and make sure all the '/' that are in
# filenames are '\', and make sure the final link command line looks
# reasonable.
MAPOBJ = obj$(SWAP:s/y/swp/:s/n//).rsp
MAPLIB = lib$(SWAP:s/y/swp/:s/n//).rsp
OBJRSP = $(SH:s,fix/,,:s,${SCRIPTFILE},${MAPOBJ},)
LIBRSP = $(SH:s,fix/,,:s,${SCRIPTFILE},${MAPLIB},)
DOSOBJ = $(CSTARTUP) $(OBJDIR)/{$(OBJECTS)}
fix-%-scripts:
	tail -r $(FIX-SH) >tmp-sh-r
	tail +2 tmp-sh-r | sed -e 's,/,\\,g' >tmp-out
	tail -r tmp-out >$(FIX-SH)
	head -1 tmp-sh-r |\
	sed -e 's,/tmp/mkA..[0-9]*,$(OBJRSP),'\
	    -e 's,/tmp/mkB..[0-9]*,$(LIBRSP),' |\
	sed -e 's,$(OS)/,$(OS)\\,g'\
	    -e 's,$(OS)/$(OSRELEASE)/,$(OS)\\$(OSRELEASE)\\,g'\
	    -e 's,$(OS)\\$(OSRELEASE)/,$(OS)\\$(OSRELEASE)\\,g'\
	    -e 's,$(OS)/$(OSRELEASE)\\,$(OS)\\$(OSRELEASE)\\,g' >>$(FIX-SH)
	rm -f tmp-sh-r tmp-out
	mv <+$(DOSOBJ:s,/,\\,:t"+\n")\n+> $(OBJRSP)
	mv <+$(LDLIBS:s,/,\\,:t"+\n")\n+> $(LIBRSP)


