/*                               -*- Mode: C -*- 
 * 
 * Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * SunBench.c -- This program performs a benchmark test on the concurrency facilities
 *    of Sun LWP. It runs on a Sun OS 4.0 system.
 * 
 * Author           : Peter A. Buhr
 * Created On       : Mon Mar 12 13:12:55 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Thu Nov  8 12:03:03 1990
 * Update Count     : 13
 */

#include <lwp/lwp.h>
#include <lwp/stackdep.h>
#include <lwp/lwperror.h>
#include <lwp/lwpmachdep.h>
#include "Time.i"

void CoroutineDummy() {
} /* CoroutineDummy */

void CoroutineCreateDelete( int N ) {
    printf( "& N/A" );
} /* CoroutineCreateDelete */

void TaskDummy() {
} /* TaskDummy */

void TaskCreateDelete( int N ) {
    int StartTime, EndTime;

    int i;
    thread_t tid;

    StartTime = Time();

    for ( i = 0; i < N; i += 1 ) {
	lwp_create( &tid, TaskDummy, MINPRIO, 0, lwp_newstk(), 0 );
	lwp_join( tid );
    } /* for */

    EndTime = Time();
    printf( "\t& %d", ( EndTime - StartTime ) / N );
} /* TaskCreateDelete */

void ContextSwitch( int N ) {
    int StartTime, EndTime;
    int i;

    StartTime = Time();

    for ( i = 0; i < N; i += 1 ) {
	lwp_yield( THREADNULL );
    } /* for */

    EndTime = Time();
    printf( "\t& %d", ( EndTime - StartTime ) / N );
} /* ContextSwitch */

void PVCxtSw1( int N ) {
    printf( "\t& N/A" );
} /* PVCxtSw1 */

void Resume1( int N ) {
    printf( "\t& N/A" );
} /* Resume1 */

void ReceiveReply( int N ) {
    int i;
    thread_t sender;
    caddr_t arg;
    int argsize;
    caddr_t res;
    int ressize;

    for( i = 0; i < N; i += 1 ) {
	sender = THREADNULL;
	msg_recv( &sender, &arg, &argsize, &res, &ressize, INFINITY );
	bcopy( arg, res, argsize );
	msg_reply( sender );
    } /* for */
} /* ReceiveReply */

void Send( int N ) {
    int StartTime, EndTime;
    int i;
    thread_t replier;
    char smsg[16], rmsg[16];

    lwp_create( &replier, ReceiveReply, MINPRIO, 0, lwp_newstk(), 1, N );

    StartTime = Time();

    for ( i = 0; i < N; i += 1 ) {
	msg_send( replier, smsg, sizeof( smsg ), rmsg, sizeof( rmsg ) );
    } /* for */
    
    EndTime = Time();
    printf( "\t\t& %d", ( EndTime - StartTime ) / N );

    lwp_join( replier );
} /* Send */

main() {
    const int NoOfTimes = 10000;

    printf( "coroutine task\tcontext\tP/V,\tresume/resume,\tsend/rec/reply,\n" );
    printf( "create/\tcreate/\tswitch\tcxt\t16 bytes\t16 bytes\n" );
    printf( "delete\tdelete\t\tswitch\tbidirectional\tbidirectional\n" );

    lwp_setstkcache(4000, 10);

    CoroutineCreateDelete( NoOfTimes );

    TaskCreateDelete( NoOfTimes );
    
    ContextSwitch( NoOfTimes );

    PVCxtSw1( NoOfTimes );

    Resume1( NoOfTimes );

    {
	thread_t sender;
	
	lwp_create( &sender, Send, MINPRIO, 0, lwp_newstk(), 1, NoOfTimes );
	lwp_join( sender );
    }
	
    printf( "\t\\\\\n" );
} /* main */

/* Local Variables: */
/* compile-command: "gcc -O SunBench.c -lnbio -llwp" */
/* End: */
