/* Copyright (c) 1989  P. A. Buhr */
/* imagen Merger.c columns=2 Tabstops=8 +Headings -Compress +Landscape +Outline */

#include <uSystem.h>

void printf( char *, ... );

typedef struct {
    int Max;
    int Posn;
} PassInfo;

#define HighValue 99999999

void merger( uCoroutine creator, uCoroutine *Partner, int SortValues[], int NoOfSortValues, int MergedValues[] ) {
    PassInfo Next;
    int Posn;
    
    Posn = 0;
    SortValues[NoOfSortValues] = HighValue;		/* mark the end of the list */
    uSuspend( &Next, sizeof(Next), NULL, 0 );		/* get the starting infor for the merge */

    for (;;) {
	for (;;) {
	  if ( SortValues[Posn] == HighValue ) break;
	  if ( SortValues[Posn] >  Next.Max ) break;
	    MergedValues[Next.Posn] = SortValues[Posn];
	    Posn += 1;
	    Next.Posn += 1;
	} /* for */
      if ( SortValues[Posn] == HighValue ) break;
	Next.Max = SortValues[Posn];
	uResume( *Partner, &Next, sizeof(Next), &Next, sizeof(Next) );
    } /* for */

    if ( Next.Max != HighValue ) {			/* partner has already finished */
	Next.Max = SortValues[Posn];
	uResume( *Partner, &Next, sizeof(Next), &Next, sizeof(Next) );
    } else {						/* partner has not finished, yet */
	uResume( *Partner, NULL, 0, &Next, sizeof(Next) );
	uResumeDie( creator, NULL, 0 );
    } /* if */
} /* merger */

#define MaxList1 10
#define MaxList2 11
#define MaxMergeList MaxList1 + MaxList2

void uMain() {
    int list1[MaxList1 + 1] = { 2, 3, 3, 10, 14, 16, 20, 24, 28, 34 };
    int list2[MaxList2 + 1] = { 1, 3, 3, 7, 9, 11, 21, 25, 33, 37, 39 };
    int Mlist[MaxMergeList];
    uCoroutine m1, m2;
    PassInfo start;
    int i;

    printf("list 1:\n");
    for ( i = 0; i < MaxList1; i += 1) {
	printf(" %d ", list1[i] );
    } /* for */
    printf("\n");

    printf("list 2:\n");
    for ( i = 0; i < MaxList2; i += 1) {
	printf(" %d ", list2[i] );
    } /* for */
    printf("\n");
    
    m1 = uCocall( NULL, 0, merger, uThisCoroutine(), &m2, list1, MaxList1, Mlist );
    m2 = uCocall( NULL, 0, merger, uThisCoroutine(), &m1, list2, MaxList2, Mlist );
    
    start.Posn = 0;
    if (list1[0] < list2[0] ) {
	start.Max = list2[0];
	uResume( m1, NULL, 0, &start, sizeof(start) );
    } else {
	start.Max = list1[0];
	uResume( m2, NULL, 0, &start, sizeof(start) );
    } /* if */
    
    printf("Merged Lists:\n");
    for ( i = 0; i < MaxMergeList; i += 1) {
	printf(" %d ", Mlist[i] );
    } /* for */
    printf("\n");
    
    printf( "successful completion\n" );
} /* uMain */
