#include <uSystem.h>
#include <uFile.h>
#include <sys/socket.h>
#include <sys/un.h>

void uMain( int argc, char *argv[] ) {

    uFile sd;
    struct sockaddr_un server;
    int c;
    void strcpy( char *, char * );

    switch ( argc ) {
      case 2:
        break;
      default:
        uError( "usage: %s socket-name\n", argv[0] );
    } /* switch */

    sd = uSocket( AF_UNIX, SOCK_STREAM, 0 );		/* create a socket */

    server.sun_family = AF_UNIX;			/* specify socket domain */
    strcpy( server.sun_path, argv[1] );			/* specify destination socket name */ 
    uConnect( sd, &server, sizeof( server ) );		/* connection to destination socket */

    for ( ;; ) {
        c = uGetc( uStdin );				/* get a byte */
      if ( c == EOF ) break;				/* no more bytes? */
        uWrite( sd, &c, sizeof( c ) );			/* write byte to socket */
    } /* for */
    
    uWrite( sd, &c, sizeof( c ) );			/* write end of file marker to socket */

    for ( ;; ) {
        uRead( sd, &c, sizeof( c ) );			/* read byte back from socket */
      if ( c == EOF ) break;				/* no more bytes? */
        uPutc( c, uStdout );				/* put a byte */
    } /* for */

    uClose( sd );					/* close socket */
} /* uMain */

/* Local Variables: */
/* compile-command: "concc -quiet -work -unixrc -multi -O -o Client SocketClient.c" */
/* End: */
